/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.repositories.layout;

import java.net.URI;
import java.util.Locale;
import org.gradle.api.internal.file.FileResolver;

public class ResolvedPattern {
    public final String scheme;
    public final URI baseUri;
    public final String pattern;
    public final String absolutePattern;

    public ResolvedPattern(String rawPattern, FileResolver fileResolver) {
        int pos = rawPattern.indexOf(91);
        String basePath = pos < 0 ? rawPattern : rawPattern.substring(0, pos);
        this.baseUri = fileResolver.resolveUri((Object)basePath);
        this.pattern = pos < 0 ? "" : rawPattern.substring(pos);
        this.scheme = this.baseUri.getScheme().toLowerCase(Locale.ROOT);
        this.absolutePattern = this.constructAbsolutePattern(this.baseUri, this.pattern);
    }

    public ResolvedPattern(URI baseUri, String pattern) {
        this.baseUri = baseUri;
        this.pattern = pattern;
        this.scheme = baseUri.getScheme().toLowerCase(Locale.ROOT);
        this.absolutePattern = this.constructAbsolutePattern(baseUri, pattern);
    }

    private String constructAbsolutePattern(URI baseUri, String patternPart) {
        String uriPart = baseUri.toString();
        String join = uriPart.endsWith("/") || patternPart.length() == 0 ? "" : "/";
        return uriPart + join + patternPart;
    }
}

