/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.rename;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.WorkingCopyOwner;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.core.search.FieldDeclarationMatch;
import org.eclipse.jdt.core.search.MethodDeclarationMatch;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.internal.corext.SourceRange;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.NodeFinder;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.SearchResultGroup;
import org.eclipse.jdt.internal.corext.refactoring.base.JavaStatusContext;
import org.eclipse.jdt.internal.corext.refactoring.base.JavaStringStatusContext;
import org.eclipse.jdt.internal.corext.refactoring.rename.RefactoringAnalyzeUtil;
import org.eclipse.jdt.internal.corext.refactoring.util.RefactoringASTParser;
import org.eclipse.jdt.internal.corext.refactoring.util.TextChangeManager;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.corext.util.SearchUtils;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.RefactoringStatusContext;
import org.eclipse.ltk.core.refactoring.RefactoringStatusEntry;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.core.refactoring.TextEditChangeGroup;
import org.eclipse.text.edits.TextEdit;

class RenameAnalyzeUtil {
    static /* synthetic */ Class class$0;

    private RenameAnalyzeUtil() {
    }

    static RefactoringStatus analyzeRenameChanges(TextChangeManager manager, SearchResultGroup[] oldOccurrences, SearchResultGroup[] newOccurrences) {
        RefactoringStatus result = new RefactoringStatus();
        int i = 0;
        while (i < oldOccurrences.length) {
            SearchResultGroup oldGroup = oldOccurrences[i];
            SearchMatch[] oldSearchResults = oldGroup.getSearchResults();
            ICompilationUnit cunit = oldGroup.getCompilationUnit();
            if (cunit != null) {
                int j = 0;
                while (j < oldSearchResults.length) {
                    SearchMatch oldSearchResult = oldSearchResults[j];
                    if (!RenameAnalyzeUtil.existsInNewOccurrences(oldSearchResult, newOccurrences, manager)) {
                        RenameAnalyzeUtil.addShadowsError(cunit, oldSearchResult, result);
                    }
                    ++j;
                }
            }
            ++i;
        }
        return result;
    }

    static ICompilationUnit findWorkingCopyForCu(ICompilationUnit[] newWorkingCopies, ICompilationUnit cu) {
        ICompilationUnit original = cu == null ? null : cu.getPrimary();
        int i = 0;
        while (i < newWorkingCopies.length) {
            if (newWorkingCopies[i].getPrimary().equals(original)) {
                return newWorkingCopies[i];
            }
            ++i;
        }
        return null;
    }

    static ICompilationUnit[] createNewWorkingCopies(ICompilationUnit[] compilationUnitsToModify, TextChangeManager manager, WorkingCopyOwner owner, SubProgressMonitor pm) throws CoreException {
        pm.beginTask("", compilationUnitsToModify.length);
        ICompilationUnit[] newWorkingCopies = new ICompilationUnit[compilationUnitsToModify.length];
        int i = 0;
        while (i < compilationUnitsToModify.length) {
            ICompilationUnit cu = compilationUnitsToModify[i];
            newWorkingCopies[i] = RenameAnalyzeUtil.createNewWorkingCopy(cu, manager, owner, new SubProgressMonitor((IProgressMonitor)pm, 1));
            ++i;
        }
        pm.done();
        return newWorkingCopies;
    }

    static ICompilationUnit createNewWorkingCopy(ICompilationUnit cu, TextChangeManager manager, WorkingCopyOwner owner, SubProgressMonitor pm) throws CoreException {
        ICompilationUnit newWc = cu.getWorkingCopy(owner, null, null);
        String previewContent = manager.get(cu).getPreviewContent((IProgressMonitor)new NullProgressMonitor());
        newWc.getBuffer().setContents(previewContent);
        newWc.reconcile(0, false, owner, (IProgressMonitor)pm);
        return newWc;
    }

    private static boolean existsInNewOccurrences(SearchMatch searchResult, SearchResultGroup[] newOccurrences, TextChangeManager manager) {
        SearchResultGroup newGroup = RenameAnalyzeUtil.findOccurrenceGroup(searchResult.getResource(), newOccurrences);
        if (newGroup == null) {
            return false;
        }
        IRegion oldEditRange = RenameAnalyzeUtil.getCorrespondingEditChangeRange(searchResult, manager);
        if (oldEditRange == null) {
            return false;
        }
        SearchMatch[] newSearchResults = newGroup.getSearchResults();
        int oldRangeOffset = oldEditRange.getOffset();
        int i = 0;
        while (i < newSearchResults.length) {
            if (newSearchResults[i].getOffset() == oldRangeOffset) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static IRegion getCorrespondingEditChangeRange(SearchMatch searchResult, TextChangeManager manager) {
        TextChange change = RenameAnalyzeUtil.getTextChange(searchResult, manager);
        if (change == null) {
            return null;
        }
        IRegion oldMatchRange = RenameAnalyzeUtil.createTextRange(searchResult);
        TextEditChangeGroup[] editChanges = change.getTextEditChangeGroups();
        int i = 0;
        while (i < editChanges.length) {
            if (oldMatchRange.equals(editChanges[i].getRegion())) {
                return TextEdit.getCoverage((TextEdit[])change.getPreviewEdits(editChanges[i].getTextEdits()));
            }
            ++i;
        }
        return null;
    }

    private static TextChange getTextChange(SearchMatch searchResult, TextChangeManager manager) {
        ICompilationUnit cu = SearchUtils.getCompilationUnit(searchResult);
        if (cu == null) {
            return null;
        }
        return manager.get(cu);
    }

    private static IRegion createTextRange(SearchMatch searchResult) {
        return new Region(searchResult.getOffset(), searchResult.getLength());
    }

    private static SearchResultGroup findOccurrenceGroup(IResource resource, SearchResultGroup[] newOccurrences) {
        int i = 0;
        while (i < newOccurrences.length) {
            if (newOccurrences[i].getResource().equals((Object)resource)) {
                return newOccurrences[i];
            }
            ++i;
        }
        return null;
    }

    static RefactoringStatus analyzeRenameChanges2(TextChangeManager manager, SearchResultGroup[] oldReferences, SearchResultGroup[] newReferences, String newElementName) {
        RefactoringStatus result = new RefactoringStatus();
        HashMap<ICompilationUnit, SearchMatch[]> cuToNewResults = new HashMap<ICompilationUnit, SearchMatch[]>(newReferences.length);
        int i1 = 0;
        while (i1 < newReferences.length) {
            ICompilationUnit cu = newReferences[i1].getCompilationUnit();
            if (cu != null) {
                cuToNewResults.put(cu.getPrimary(), newReferences[i1].getSearchResults());
            }
            ++i1;
        }
        int i = 0;
        while (i < oldReferences.length) {
            SearchResultGroup oldGroup = oldReferences[i];
            SearchMatch[] oldMatches = oldGroup.getSearchResults();
            ICompilationUnit cu = oldGroup.getCompilationUnit();
            if (cu != null) {
                SearchMatch[] newSearchMatches = (SearchMatch[])cuToNewResults.remove(cu);
                if (newSearchMatches == null) {
                    int j = 0;
                    while (j < oldMatches.length) {
                        SearchMatch oldMatch = oldMatches[j];
                        RenameAnalyzeUtil.addShadowsError(cu, oldMatch, result);
                        ++j;
                    }
                } else {
                    RenameAnalyzeUtil.analyzeChanges(cu, manager.get(cu), oldMatches, newSearchMatches, newElementName, result);
                }
            }
            ++i;
        }
        Iterator iter = cuToNewResults.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            ICompilationUnit cu = (ICompilationUnit)entry.getKey();
            SearchMatch[] newSearchMatches = (SearchMatch[])entry.getValue();
            int i2 = 0;
            while (i2 < newSearchMatches.length) {
                SearchMatch newMatch = newSearchMatches[i2];
                RenameAnalyzeUtil.addReferenceShadowedError(cu, newMatch, newElementName, result);
                ++i2;
            }
        }
        return result;
    }

    private static void analyzeChanges(ICompilationUnit cu, TextChange change, SearchMatch[] oldMatches, SearchMatch[] newMatches, String newElementName, RefactoringStatus result) {
        Map updatedOldOffsets = RenameAnalyzeUtil.getUpdatedChangeOffsets(change, oldMatches);
        int i = 0;
        while (i < newMatches.length) {
            SearchMatch newMatch = newMatches[i];
            Integer offsetInNew = new Integer(newMatch.getOffset());
            SearchMatch oldMatch = (SearchMatch)updatedOldOffsets.remove(offsetInNew);
            if (oldMatch == null) {
                RenameAnalyzeUtil.addReferenceShadowedError(cu, newMatch, newElementName, result);
            }
            ++i;
        }
        Iterator iter = updatedOldOffsets.values().iterator();
        while (iter.hasNext()) {
            SearchMatch oldMatch = (SearchMatch)iter.next();
            RenameAnalyzeUtil.addShadowsError(cu, oldMatch, result);
        }
    }

    private static Map getUpdatedChangeOffsets(TextChange change, SearchMatch[] oldMatches) {
        HashMap<Integer, SearchMatch> updatedOffsets = new HashMap<Integer, SearchMatch>();
        Map oldToUpdatedOffsets = RenameAnalyzeUtil.getEditChangeOffsetUpdates(change);
        int i = 0;
        while (i < oldMatches.length) {
            SearchMatch oldMatch = oldMatches[i];
            Integer updatedOffset = (Integer)oldToUpdatedOffsets.get(new Integer(oldMatch.getOffset()));
            if (updatedOffset == null) {
                updatedOffset = new Integer(-1);
            }
            updatedOffsets.put(updatedOffset, oldMatch);
            ++i;
        }
        return updatedOffsets;
    }

    private static Map getEditChangeOffsetUpdates(TextChange change) {
        TextEditChangeGroup[] editChanges = change.getTextEditChangeGroups();
        HashMap<Integer, Integer> offsetUpdates = new HashMap<Integer, Integer>(editChanges.length);
        int i = 0;
        while (i < editChanges.length) {
            IRegion updatedRegion;
            TextEditChangeGroup editChange = editChanges[i];
            IRegion oldRegion = editChange.getRegion();
            if (oldRegion != null && (updatedRegion = TextEdit.getCoverage((TextEdit[])change.getPreviewEdits(editChange.getTextEdits()))) != null) {
                offsetUpdates.put(new Integer(oldRegion.getOffset()), new Integer(updatedRegion.getOffset()));
            }
            ++i;
        }
        return offsetUpdates;
    }

    private static void addReferenceShadowedError(ICompilationUnit cu, SearchMatch newMatch, String newElementName, RefactoringStatus result) {
        if (newMatch instanceof MethodDeclarationMatch || newMatch instanceof FieldDeclarationMatch) {
            return;
        }
        ISourceRange range = RenameAnalyzeUtil.getOldSourceRange(newMatch);
        RefactoringStatusContext context = JavaStatusContext.create((ITypeRoot)cu, range);
        String message = Messages.format(RefactoringCoreMessages.RenameAnalyzeUtil_reference_shadowed, new String[]{cu.getElementName(), newElementName});
        result.addError(message, context);
    }

    private static ISourceRange getOldSourceRange(SearchMatch newMatch) {
        IJavaElement newMatchElement = (IJavaElement)newMatch.getElement();
        IJavaElement primaryElement = newMatchElement.getPrimaryElement();
        ISourceRange range = null;
        if (primaryElement.exists() && primaryElement instanceof ISourceReference) {
            try {
                range = ((ISourceReference)primaryElement).getSourceRange();
            }
            catch (JavaModelException javaModelException) {}
        }
        return range;
    }

    private static void addShadowsError(ICompilationUnit cu, SearchMatch oldMatch, RefactoringStatus result) {
        if (oldMatch instanceof MethodDeclarationMatch || oldMatch instanceof FieldDeclarationMatch) {
            return;
        }
        SourceRange range = new SourceRange(oldMatch.getOffset(), oldMatch.getLength());
        RefactoringStatusContext context = JavaStatusContext.create((ITypeRoot)cu, range);
        String message = Messages.format(RefactoringCoreMessages.RenameAnalyzeUtil_shadows, cu.getElementName());
        result.addError(message, context);
    }

    public static RefactoringStatus analyzeLocalRenames(LocalAnalyzePackage[] analyzePackages, TextChange cuChange, CompilationUnit oldCUNode, boolean statementsRecovery) throws CoreException {
        RefactoringStatus result = new RefactoringStatus();
        ICompilationUnit compilationUnit = (ICompilationUnit)oldCUNode.getJavaElement();
        String newCuSource = cuChange.getPreviewContent((IProgressMonitor)new NullProgressMonitor());
        CompilationUnit newCUNode = new RefactoringASTParser(3).parse(newCuSource, compilationUnit, true, statementsRecovery, null);
        result.merge(RenameAnalyzeUtil.analyzeCompileErrors(newCuSource, newCUNode, oldCUNode));
        if (result.hasError()) {
            return result;
        }
        int i = 0;
        while (i < analyzePackages.length) {
            ASTNode enclosing = RenameAnalyzeUtil.getEnclosingBlockOrMethod(analyzePackages[i].fDeclarationEdit, cuChange, newCUNode);
            IRegion newRegion = RefactoringAnalyzeUtil.getNewTextRange(analyzePackages[i].fDeclarationEdit, cuChange);
            ASTNode newDeclaration = NodeFinder.perform((ASTNode)newCUNode, newRegion.getOffset(), newRegion.getLength());
            Assert.isTrue((boolean)(newDeclaration instanceof Name));
            VariableDeclaration declaration = RenameAnalyzeUtil.getVariableDeclaration((Name)newDeclaration);
            Assert.isNotNull((Object)declaration);
            SimpleName[] problemNodes = ProblemNodeFinder.getProblemNodes(enclosing, declaration, analyzePackages[i].fOccurenceEdits, cuChange);
            result.merge(RefactoringAnalyzeUtil.reportProblemNodes(newCuSource, problemNodes));
            ++i;
        }
        return result;
    }

    private static VariableDeclaration getVariableDeclaration(Name node) {
        IBinding binding = node.resolveBinding();
        if (binding == null && node.getParent() instanceof VariableDeclaration) {
            return (VariableDeclaration)node.getParent();
        }
        if (binding != null && binding.getKind() == 3) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.jdt.core.dom.CompilationUnit");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            CompilationUnit cu = (CompilationUnit)ASTNodes.getParent((ASTNode)node, clazz);
            return ASTNodes.findVariableDeclaration((IVariableBinding)binding, (ASTNode)cu);
        }
        return null;
    }

    private static ASTNode getEnclosingBlockOrMethod(TextEdit declarationEdit, TextChange change, CompilationUnit newCUNode) {
        Block enclosing = RefactoringAnalyzeUtil.getBlock(declarationEdit, change, newCUNode);
        if (enclosing == null) {
            enclosing = RefactoringAnalyzeUtil.getMethodDeclaration(declarationEdit, change, newCUNode);
        }
        return enclosing;
    }

    private static RefactoringStatus analyzeCompileErrors(String newCuSource, CompilationUnit newCUNode, CompilationUnit oldCUNode) {
        RefactoringStatus result = new RefactoringStatus();
        IProblem[] newProblems = RefactoringAnalyzeUtil.getIntroducedCompileProblems(newCUNode, oldCUNode);
        int i = 0;
        while (i < newProblems.length) {
            IProblem problem = newProblems[i];
            if (problem.isError()) {
                result.addEntry(new RefactoringStatusEntry(problem.isError() ? 3 : 2, problem.getMessage(), (RefactoringStatusContext)new JavaStringStatusContext(newCuSource, new SourceRange(problem))));
            }
            ++i;
        }
        return result;
    }

    static class LocalAnalyzePackage {
        public final TextEdit fDeclarationEdit;
        public final TextEdit[] fOccurenceEdits;

        public LocalAnalyzePackage(TextEdit declarationEdit, TextEdit[] occurenceEdits) {
            this.fDeclarationEdit = declarationEdit;
            this.fOccurenceEdits = occurenceEdits;
        }
    }

    private static class ProblemNodeFinder {
        private ProblemNodeFinder() {
        }

        public static SimpleName[] getProblemNodes(ASTNode methodNode, VariableDeclaration variableNode, TextEdit[] edits, TextChange change) {
            String key = variableNode.resolveBinding().getKey();
            NameNodeVisitor visitor = new NameNodeVisitor(edits, change, key);
            methodNode.accept((ASTVisitor)visitor);
            return visitor.getProblemNodes();
        }

        private static class NameNodeVisitor
        extends ASTVisitor {
            private Collection fRanges;
            private Collection fProblemNodes;
            private String fKey;

            public NameNodeVisitor(TextEdit[] edits, TextChange change, String key) {
                Assert.isNotNull((Object)edits);
                Assert.isNotNull((Object)key);
                this.fRanges = new HashSet<IRegion>(Arrays.asList(RefactoringAnalyzeUtil.getNewRanges(edits, change)));
                this.fProblemNodes = new ArrayList(0);
                this.fKey = key;
            }

            public SimpleName[] getProblemNodes() {
                return this.fProblemNodes.toArray(new SimpleName[this.fProblemNodes.size()]);
            }

            public boolean visit(SimpleName node) {
                VariableDeclaration decl = RenameAnalyzeUtil.getVariableDeclaration((Name)node);
                if (decl == null) {
                    return super.visit(node);
                }
                IVariableBinding binding = decl.resolveBinding();
                if (binding == null) {
                    return super.visit(node);
                }
                boolean keysEqual = this.fKey.equals(binding.getKey());
                boolean rangeInSet = this.fRanges.contains(new Region(node.getStartPosition(), node.getLength()));
                if (keysEqual && !rangeInSet) {
                    this.fProblemNodes.add(node);
                }
                if (!keysEqual && rangeInSet) {
                    this.fProblemNodes.add(node);
                }
                return super.visit(node);
            }
        }
    }
}

