/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.apt.core.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.apt.core.internal.AptPlugin;
import org.eclipse.jdt.apt.core.internal.Messages;
import org.eclipse.jdt.core.IJavaProject;

public class LoadFailureHandler {
    private final IProject _project;
    private final List<String> _missingLibraries = new ArrayList<String>();
    private final List<String> _failedFactories = new ArrayList<String>();

    public LoadFailureHandler(IJavaProject proj) {
        this._project = proj.getProject();
    }

    public void addMissingLibrary(String lib) {
        this._missingLibraries.add(lib);
    }

    public void addFailedFactory(String factory) {
        this._failedFactories.add(factory);
    }

    public void reportFailureMarkers() {
        this.reportFailureToLoadFactories();
        this.reportMissingLibraries();
    }

    private void reportMissingLibraries() {
        for (String fc : this._missingLibraries) {
            try {
                String message = Messages.bind((String)Messages.AnnotationProcessorFactoryLoader_factorypath_missingLibrary, (Object[])new String[]{fc, this._project.getName()});
                IMarker marker = this._project.createMarker("org.eclipse.jdt.apt.core.buildproblem");
                marker.setAttributes(new String[]{"message", "severity", "location"}, new Object[]{message, 2, Messages.AnnotationProcessorFactoryLoader_factorypath});
            }
            catch (CoreException e) {
                AptPlugin.log(e, "Unable to create APT build problem marker on project " + this._project.getName());
            }
        }
    }

    private void reportFailureToLoadFactories() {
        for (String factoryName : this._failedFactories) {
            try {
                String message = Messages.bind((String)Messages.AnnotationProcessorFactoryLoader_unableToLoadFactoryClass, (Object[])new String[]{factoryName, this._project.getName()});
                IMarker marker = this._project.createMarker("org.eclipse.jdt.apt.core.buildproblem");
                marker.setAttributes(new String[]{"message", "severity", "location"}, new Object[]{message, 4, Messages.AnnotationProcessorFactoryLoader_factorypath});
            }
            catch (CoreException e) {
                AptPlugin.log(e, "Unable to create build problem marker");
            }
        }
    }

    public int hashCode() {
        return this._project.hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof LoadFailureHandler)) {
            return false;
        }
        LoadFailureHandler otherHandler = (LoadFailureHandler)o;
        return this._project.equals((Object)otherHandler._project);
    }
}

