/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.debug.core.IJavaPatternBreakpoint;
import org.eclipse.jdt.debug.core.IJavaStratumLineBreakpoint;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.actions.ValidBreakpointLocationLocator;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.ui.texteditor.IMarkerUpdater;

public class BreakpointMarkerUpdater
implements IMarkerUpdater {
    public String[] getAttribute() {
        return new String[]{"lineNumber"};
    }

    public String getMarkerType() {
        return "org.eclipse.debug.core.breakpointMarker";
    }

    public boolean updateMarker(IMarker marker, IDocument document, Position position) {
        if (position.isDeleted()) {
            return false;
        }
        IBreakpointManager manager = DebugPlugin.getDefault().getBreakpointManager();
        IBreakpoint breakpoint = manager.getBreakpoint(marker);
        if (breakpoint instanceof IJavaStratumLineBreakpoint || breakpoint instanceof IJavaPatternBreakpoint) {
            return true;
        }
        ASTParser parser = ASTParser.newParser((int)3);
        parser.setSource(document.get().toCharArray());
        CompilationUnit unit = (CompilationUnit)parser.createAST(null);
        if (unit != null) {
            ValidBreakpointLocationLocator loc;
            block9: {
                block8: {
                    loc = new ValidBreakpointLocationLocator(unit, document.getLineOfOffset(position.getOffset()) + 1, true, true);
                    unit.accept((ASTVisitor)loc);
                    if (loc.getLocationType() != 0) break block8;
                    return false;
                }
                if (marker.getAttribute("lineNumber", -1) != loc.getLineLocation()) break block9;
                return true;
            }
            try {
                marker.setAttribute("lineNumber", loc.getLineLocation());
                return true;
            }
            catch (BadLocationException e) {
                JDIDebugUIPlugin.log(e);
            }
            catch (CoreException e) {
                JDIDebugUIPlugin.log(e);
            }
        }
        return false;
    }
}

