/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.launcher;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.internal.debug.ui.launcher.AppletLaunchConfigurationUtils;
import org.eclipse.jdt.internal.debug.ui.launcher.JavaLaunchShortcut;
import org.eclipse.jdt.internal.debug.ui.launcher.LauncherMessages;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jface.operation.IRunnableContext;

public class JavaAppletLaunchShortcut
extends JavaLaunchShortcut {
    protected ILaunchConfiguration createConfiguration(IType type) {
        ILaunchConfiguration config = null;
        try {
            ILaunchConfigurationType configType = this.getConfigurationType();
            ILaunchConfigurationWorkingCopy wc = configType.newInstance(null, DebugPlugin.getDefault().getLaunchManager().generateUniqueLaunchConfigurationNameFrom(type.getElementName()));
            wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, type.getFullyQualifiedName());
            wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, type.getJavaProject().getElementName());
            wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_APPLET_WIDTH, 200);
            wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_APPLET_HEIGHT, 200);
            wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_APPLET_NAME, "");
            wc.setMappedResources(new IResource[]{type.getUnderlyingResource()});
            config = wc.doSave();
        }
        catch (CoreException ce) {
            this.reportErorr(ce);
        }
        return config;
    }

    protected ILaunchConfigurationType getConfigurationType() {
        ILaunchManager lm = DebugPlugin.getDefault().getLaunchManager();
        return lm.getLaunchConfigurationType(IJavaLaunchConfigurationConstants.ID_JAVA_APPLET);
    }

    protected IType[] findTypes(Object[] elements, IRunnableContext context) throws InterruptedException, CoreException {
        try {
            return AppletLaunchConfigurationUtils.findApplets(context, elements);
        }
        catch (InvocationTargetException e) {
            throw (CoreException)e.getTargetException();
        }
    }

    protected String getTypeSelectionTitle() {
        return LauncherMessages.JavaAppletLaunchShortcut_0;
    }

    protected String getEditorEmptyMessage() {
        return LauncherMessages.JavaAppletLaunchShortcut_1;
    }

    protected String getSelectionEmptyMessage() {
        return LauncherMessages.JavaAppletLaunchShortcut_2;
    }
}

