/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.model;

import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.Path;
import org.eclipse.ant.internal.ui.model.AntPropertyNode;

public class AntModelProject
extends Project {
    private Hashtable fBaseProperties;
    private Hashtable fCurrentProperties = new Hashtable();
    private AntPropertyNode fCurrentConfiguringPropertyNode;

    public void setNewProperty(String name, String value) {
        if (this.fCurrentProperties.get(name) != null) {
            return;
        }
        this.fCurrentProperties.put(name, value);
        if (this.fCurrentConfiguringPropertyNode != null) {
            this.fCurrentConfiguringPropertyNode.addProperty(name, value);
        }
        super.setProperty(name, value);
    }

    public void fireBuildFinished(Throwable exception) {
        super.fireBuildFinished(exception);
        Enumeration e = this.getBuildListeners().elements();
        while (e.hasMoreElements()) {
            BuildListener listener = (BuildListener)e.nextElement();
            this.removeBuildListener(listener);
        }
    }

    public void reset() {
        this.getTargets().clear();
        this.setDefault(null);
        this.setDescription(null);
        this.setName("");
        this.fCurrentProperties = new Hashtable(this.fBaseProperties);
    }

    public String getProperty(String name) {
        String result = (String)this.fCurrentProperties.get(name);
        if (result == null) {
            result = this.getUserProperty(name);
        }
        return result;
    }

    public Hashtable getProperties() {
        Hashtable<String, String> allProps = new Hashtable<String, String>(this.fCurrentProperties);
        allProps.putAll(this.getUserProperties());
        allProps.put("basedir", this.getBaseDir().getPath());
        return allProps;
    }

    public void init() throws BuildException {
        super.init();
        this.fBaseProperties = super.getProperties();
        this.fCurrentProperties = super.getProperties();
    }

    public void setBaseDir(File baseDir) throws BuildException {
        super.setBaseDir(baseDir);
        this.fCurrentProperties.put("basedir", this.getBaseDir().getPath());
    }

    public void setCurrentConfiguringProperty(AntPropertyNode node) {
        this.fCurrentConfiguringPropertyNode = node;
    }

    public AntClassLoader createClassLoader(Path path) {
        AntClassLoader loader = super.createClassLoader(path);
        if (path == null) {
            loader.setClassPath(Path.systemClasspath);
        }
        return loader;
    }
}

