/*
 * lib.h - SAM-FS API library functions.
 *
 * Definitions for SAM-FS API library functions.
 *
 */

/*
 *    SAM-QFS_notice_begin
 *
 *      Solaris 2.x Sun Storage & Archiving Management File System
 *
 *		Copyright (c) 2007 Sun Microsystems, Inc. All Rights Reserved.
 *
 *		U.S. Government Rights - Commercial software. Government users are
 *	subject to the Sun Microsystems, Inc. standard license agreement and applicable
 *	provisions of the FAR and its supplements.
 *
 *      	Use is subject to license terms. Sun, Sun Microsystems and the Sun logo
 *	are trademarks or registered trademarks of Sun Microsystems, Inc. in the U.S.
 *	and other countries.
 *
 *    SAM-QFS_notice_end
 */

/*
 *	LGPL NOTICE
 *
 *	This library is free software; you can redistribute it and/or
 *	modify it under the terms of the GNU Lesser General Public
 *	License as published by the Free Software Foundation; either
 *	version 2.1 of the License, or (at your option) any later version.
 *
 *	This library is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *	Lesser General Public License for more details.
 *
 *	You should have received a copy of the GNU Lesser General Public
 *	License along with this library; if not, write to the Free Software
 *	Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

/*
 * $Revision$
 */

#ifdef sun
#pragma ident "$Revision$"
#endif


#ifndef	SAMLIB_H
#define	SAMLIB_H

#ifdef linux
#include <sam/linux_types.h>	/* uint_t */
#endif /* linux */

#ifdef  __cplusplus
extern "C" {
#endif

int sam_archive(const char *name, const char *opns);
int sam_unarchive(const char *name, int num_opts, ...);
int sam_rearch(const char *name, int num_opts, ...);
int sam_unrearch(const char *name, int num_opts, ...);
int sam_exarchive(const char *name, int num_opts, ...);
int sam_damage(const char *name, int num_opts, ...);
int sam_undamage(const char *name, int num_opts, ...);
char *sam_attrtoa(int attr, char *string);
int sam_cancelstage(const char *name);
char *sam_devstr(uint_t p);
int sam_release(const char *name, const char *opns);
int sam_ssum(const char *name, const char *opns);
int sam_stage(const char *name, const char *opns);
int sam_setfa(const char *name, const char *opns);
int sam_segment(const char *name, const char *opns);
int sam_advise(const int fildes, const char *opns);

#ifdef  __cplusplus
}
#endif

#endif /* SAMLIB_H */
