/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.engine;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.junit.platform.commons.JUnitException;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.engine.UniqueId;

class UniqueIdFormat
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final UniqueIdFormat defaultFormat = new UniqueIdFormat('[', ':', ']', '/');
    private final char openSegment;
    private final char closeSegment;
    private final char segmentDelimiter;
    private final char typeValueSeparator;
    private final Pattern segmentPattern;
    private final HashMap<Character, String> encodedCharacterMap = new HashMap();

    static UniqueIdFormat getDefault() {
        return defaultFormat;
    }

    private static String quote(char c) {
        return Pattern.quote(String.valueOf(c));
    }

    private static String encode(char c) {
        try {
            return URLEncoder.encode(String.valueOf(c), StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError("UTF-8 should be supported", e);
        }
    }

    UniqueIdFormat(char openSegment, char typeValueSeparator, char closeSegment, char segmentDelimiter) {
        this.openSegment = openSegment;
        this.typeValueSeparator = typeValueSeparator;
        this.closeSegment = closeSegment;
        this.segmentDelimiter = segmentDelimiter;
        this.segmentPattern = Pattern.compile(String.format("%s(.+)%s(.+)%s", UniqueIdFormat.quote(openSegment), UniqueIdFormat.quote(typeValueSeparator), UniqueIdFormat.quote(closeSegment)), 32);
        this.encodedCharacterMap.computeIfAbsent(Character.valueOf('%'), UniqueIdFormat::encode);
        this.encodedCharacterMap.computeIfAbsent(Character.valueOf('+'), UniqueIdFormat::encode);
        this.encodedCharacterMap.computeIfAbsent(Character.valueOf(openSegment), UniqueIdFormat::encode);
        this.encodedCharacterMap.computeIfAbsent(Character.valueOf(typeValueSeparator), UniqueIdFormat::encode);
        this.encodedCharacterMap.computeIfAbsent(Character.valueOf(closeSegment), UniqueIdFormat::encode);
        this.encodedCharacterMap.computeIfAbsent(Character.valueOf(segmentDelimiter), UniqueIdFormat::encode);
    }

    UniqueId parse(String source) throws JUnitException {
        String[] parts = source.split(String.valueOf(this.segmentDelimiter));
        List<UniqueId.Segment> segments = Arrays.stream(parts).map(this::createSegment).collect(Collectors.toList());
        return new UniqueId(this, segments);
    }

    private UniqueId.Segment createSegment(String segmentString) throws JUnitException {
        Matcher segmentMatcher = this.segmentPattern.matcher(segmentString);
        if (!segmentMatcher.matches()) {
            throw new JUnitException(String.format("'%s' is not a well-formed UniqueId segment", segmentString));
        }
        String type = UniqueIdFormat.decode(this.checkAllowed(segmentMatcher.group(1)));
        String value = UniqueIdFormat.decode(this.checkAllowed(segmentMatcher.group(2)));
        return new UniqueId.Segment(type, value);
    }

    private String checkAllowed(String typeOrValue) {
        this.checkDoesNotContain(typeOrValue, this.segmentDelimiter);
        this.checkDoesNotContain(typeOrValue, this.typeValueSeparator);
        this.checkDoesNotContain(typeOrValue, this.openSegment);
        this.checkDoesNotContain(typeOrValue, this.closeSegment);
        return typeOrValue;
    }

    private void checkDoesNotContain(String typeOrValue, char forbiddenCharacter) {
        Preconditions.condition((typeOrValue.indexOf(forbiddenCharacter) < 0 ? 1 : 0) != 0, () -> String.format("type or value '%s' must not contain '%s'", typeOrValue, Character.valueOf(forbiddenCharacter)));
    }

    String format(UniqueId uniqueId) {
        return uniqueId.getSegments().stream().map(this::describe).collect(Collectors.joining(String.valueOf(this.segmentDelimiter)));
    }

    private String describe(UniqueId.Segment segment) {
        String body = this.encode(segment.getType()) + this.typeValueSeparator + this.encode(segment.getValue());
        return this.openSegment + body + this.closeSegment;
    }

    private String encode(String s) {
        StringBuilder builder = new StringBuilder(s.length());
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            String value = this.encodedCharacterMap.get(Character.valueOf(c));
            if (value == null) {
                builder.append(c);
                continue;
            }
            builder.append(value);
        }
        return builder.toString();
    }

    private static String decode(String s) {
        try {
            return URLDecoder.decode(s, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new JUnitException("UTF-8 should be supported", (Throwable)e);
        }
    }
}

