//  (C) Copyright John Maddock 2006.
//  Use, modification and distribution are subject to the
//  Boost Software License, Version 1.0. (See accompanying file
//  LICENSE_1_0.txt or copy at http://www.boost.org/LICENSE_1_0.txt)


static const boost::array<boost::array<typename table_type<T>::type, 4>, 500> ibeta_derivative_small_data = { {
{{ SC_(1.1510574258863925933837890625000000000000e-02), SC_(2.7266697883605957031250000000000000000000e+00), SC_(9.1334599256515502929687500000000000000000e-01), SC_(1.8741908372998719241272411358629596243048e-04) }},
{{ SC_(4.6342257410287857055664062500000000000000e-02), SC_(3.4317314624786376953125000000000000000000e-01), SC_(2.4176712334156036376953125000000000000000e-01), SC_(1.9358253087597834753056042968027495549137e-01) }},
{{ SC_(6.7153170704841613769531250000000000000000e-02), SC_(2.3063192367553710937500000000000000000000e+00), SC_(9.0844279527664184570312500000000000000000e-01), SC_(3.4914355596369847195545782552516093180294e-03) }},
{{ SC_(1.1902070045471191406250000000000000000000e-01), SC_(7.2695474624633789062500000000000000000000e+00), SC_(1.9963125884532928466796875000000000000000e-01), SC_(1.6224792351472445562789136080338226505083e-01) }},
{{ SC_(1.5403440594673156738281250000000000000000e-01), SC_(4.0498137474060058593750000000000000000000e+00), SC_(3.4629878401756286621093750000000000000000e-01), SC_(1.3529249056602049451352149872806595461679e-01) }},
{{ SC_(1.5487124025821685791015625000000000000000e-01), SC_(8.1611700057983398437500000000000000000000e+00), SC_(6.7876726388931274414062500000000000000000e-01), SC_(9.3101533939569492398542022997514707360962e-05) }},
{{ SC_(2.2512593865394592285156250000000000000000e-01), SC_(4.8983201384544372558593750000000000000000e-01), SC_(7.9967319965362548828125000000000000000000e-01), SC_(4.6999379786635284358436357211061053977257e-01) }},
{{ SC_(2.8674152493476867675781250000000000000000e-01), SC_(5.9605798721313476562500000000000000000000e+00), SC_(5.7525110244750976562500000000000000000000e-01), SC_(1.1087456038944861931416630382789162885490e-02) }},
{{ SC_(2.9220280051231384277343750000000000000000e-01), SC_(2.6592068672180175781250000000000000000000e+00), SC_(4.7334149479866027832031250000000000000000e-01), SC_(2.4367995220381248200940273026206439826307e-01) }},
{{ SC_(3.0540943145751953125000000000000000000000e-01), SC_(4.2397832870483398437500000000000000000000e+00), SC_(5.4692679643630981445312500000000000000000e-01), SC_(6.0385486934828772788398554361431868745314e-02) }},
{{ SC_(3.1832844018936157226562500000000000000000e-01), SC_(3.1655042171478271484375000000000000000000e+00), SC_(7.7649272978305816650390625000000000000000e-02), SC_(2.3760499829110789585463122077459288865822e+00) }},
{{ SC_(3.2600826025009155273437500000000000000000e-01), SC_(6.2543243169784545898437500000000000000000e-01), SC_(7.4315816164016723632812500000000000000000e-01), SC_(5.3280308006046883741514027208714235696548e-01) }},
{{ SC_(3.3603835105895996093750000000000000000000e-01), SC_(5.2892065048217773437500000000000000000000e+00), SC_(8.1474220752716064453125000000000000000000e-01), SC_(5.3452365900572742306389384211346563297013e-04) }},
{{ SC_(3.4446078538894653320312500000000000000000e-01), SC_(6.6360549926757812500000000000000000000000e+00), SC_(9.6544884145259857177734375000000000000000e-02), SC_(1.9037916907129069316265369446392284055955e+00) }},
{{ SC_(3.5711678862571716308593750000000000000000e-01), SC_(3.6129398345947265625000000000000000000000e+00), SC_(4.6266771852970123291015625000000000000000e-02), SC_(3.9156296504974936078995214783807239072499e+00) }},
{{ SC_(3.5762733221054077148437500000000000000000e-01), SC_(8.0645103454589843750000000000000000000000e+00), SC_(9.2886126041412353515625000000000000000000e-01), SC_(6.8095945259515951483690544998191784395901e-09) }},
{{ SC_(3.7738865613937377929687500000000000000000e-01), SC_(8.8396854400634765625000000000000000000000e+00), SC_(5.0323975086212158203125000000000000000000e-01), SC_(6.0668393178800677337610084009410539889055e-03) }},
{{ SC_(4.2431133985519409179687500000000000000000e-01), SC_(8.7180509567260742187500000000000000000000e+00), SC_(5.9454411268234252929687500000000000000000e-01), SC_(1.5037301906603165360660830938510152833023e-03) }},
{{ SC_(4.3023800849914550781250000000000000000000e-01), SC_(9.0843362808227539062500000000000000000000e+00), SC_(3.5004875063896179199218750000000000000000e-01), SC_(6.9133189400898965404830519250544598629573e-02) }},
{{ SC_(4.6171388030052185058593750000000000000000e-01), SC_(1.4911397695541381835937500000000000000000e+00), SC_(8.1217654049396514892578125000000000000000e-02), SC_(2.1390614928196542016734883444376107406060e+00) }},
{{ SC_(4.9654427170753479003906250000000000000000e-01), SC_(8.2345542907714843750000000000000000000000e+00), SC_(3.0131623148918151855468750000000000000000e-01), SC_(2.1491222223112030301186682034940283337252e-01) }},
{{ SC_(5.2676993608474731445312500000000000000000e-01), SC_(9.4657726287841796875000000000000000000000e+00), SC_(6.9526332616806030273437500000000000000000e-01), SC_(9.7214327602493616629553150579981845587656e-05) }},
{{ SC_(5.3950119018554687500000000000000000000000e-01), SC_(3.5276241302490234375000000000000000000000e+00), SC_(1.8489784002304077148437500000000000000000e-01), SC_(1.5025993715045931537535173574744100041793e+00) }},
{{ SC_(5.9618860483169555664062500000000000000000e-01), SC_(9.5247201919555664062500000000000000000000e+00), SC_(5.8708602190017700195312500000000000000000e-01), SC_(1.6646068415868031337766694663533129085201e-03) }},
{{ SC_(5.9779542684555053710937500000000000000000e-01), SC_(4.3524570465087890625000000000000000000000e+00), SC_(3.4045168757438659667968750000000000000000e-01), SC_(5.9946367792610300493757313070016957982690e-01) }},
{{ SC_(6.0471183061599731445312500000000000000000e-01), SC_(2.7766406536102294921875000000000000000000e+00), SC_(6.5411365032196044921875000000000000000000e-01), SC_(2.1564329694343850766631162608079762156900e-01) }},
{{ SC_(6.7992764711380004882812500000000000000000e-01), SC_(9.0447483062744140625000000000000000000000e+00), SC_(8.8773733377456665039062500000000000000000e-01), SC_(7.8858289514473742934219392886691051252907e-08) }},
{{ SC_(6.8806105852127075195312500000000000000000e-01), SC_(2.9616763591766357421875000000000000000000e+00), SC_(8.1578749418258666992187500000000000000000e-01), SC_(5.9671677486881955489353414250161473987061e-02) }},
{{ SC_(7.1445453166961669921875000000000000000000e-01), SC_(9.3460264205932617187500000000000000000000e+00), SC_(5.9493660926818847656250000000000000000000e-01), SC_(2.3538600518603314137088654222819197646159e-03) }},
{{ SC_(7.5854289531707763671875000000000000000000e-01), SC_(4.0420851707458496093750000000000000000000e+00), SC_(1.8398940563201904296875000000000000000000e-01), SC_(1.8841684847888279230426133586608123815234e+00) }},
{{ SC_(7.5966686010360717773437500000000000000000e-01), SC_(7.6242132186889648437500000000000000000000e+00), SC_(2.8591042757034301757812500000000000000000e-01), SC_(5.5356968659268658999290870309432347656896e-01) }},
{{ SC_(7.8175532817840576171875000000000000000000e-01), SC_(8.5445098876953125000000000000000000000000e+00), SC_(2.3957851529121398925781250000000000000000e-01), SC_(7.7313855031782090144124981541228831526191e-01) }},
{{ SC_(8.1125766038894653320312500000000000000000e-01), SC_(3.7941887378692626953125000000000000000000e+00), SC_(3.7948089838027954101562500000000000000000e-01), SC_(7.9481127654812164270433922363527228414488e-01) }},
{{ SC_(8.3469820022583007812500000000000000000000e-01), SC_(9.0694408416748046875000000000000000000000e+00), SC_(6.4435368776321411132812500000000000000000e-01), SC_(1.4205766604850521430605776133355702343859e-03) }},
{{ SC_(8.3821380138397216796875000000000000000000e-01), SC_(9.1257753372192382812500000000000000000000e+00), SC_(2.2599919140338897705078125000000000000000e-01), SC_(8.9417867483364126954471276137630873760815e-01) }},
{{ SC_(8.4435856342315673828125000000000000000000e-01), SC_(3.4623341560363769531250000000000000000000e+00), SC_(2.5115874409675598144531250000000000000000e-01), SC_(1.5246092567090266579479605061104614934871e+00) }},
{{ SC_(8.5515785217285156250000000000000000000000e-01), SC_(9.9353475570678710937500000000000000000000e+00), SC_(4.7097623348236083984375000000000000000000e-01), SC_(2.4110311685700295282019847153970904907783e-02) }},
{{ SC_(9.0823286771774291992187500000000000000000e-01), SC_(6.7884832620620727539062500000000000000000e-01), SC_(8.4073317050933837890625000000000000000000e-01), SC_(1.1551615269972047129032528360208354844893e+00) }},
{{ SC_(9.1113471984863281250000000000000000000000e-01), SC_(8.6217230558395385742187500000000000000000e-01), SC_(9.5751106739044189453125000000000000000000e-01), SC_(1.2291641481829493965308411038338260948733e+00) }},
{{ SC_(9.4229334592819213867187500000000000000000e-01), SC_(7.7645378112792968750000000000000000000000e+00), SC_(8.0819469690322875976562500000000000000000e-01), SC_(9.4577644334068573319892340911992747150700e-05) }},
{{ SC_(9.6454536914825439453125000000000000000000e-01), SC_(2.2341995239257812500000000000000000000000e+00), SC_(3.2503104209899902343750000000000000000000e-01), SC_(1.3517969221416669098304600091072222041243e+00) }},
{{ SC_(9.6730029582977294921875000000000000000000e-01), SC_(2.8968939781188964843750000000000000000000e+00), SC_(6.0288280248641967773437500000000000000000e-01), SC_(4.8125601052060564014049063136882544660946e-01) }},
{{ SC_(9.7131776809692382812500000000000000000000e-01), SC_(9.9406852722167968750000000000000000000000e+00), SC_(8.3912998437881469726562500000000000000000e-02), SC_(4.4799822741903251318266582347635305770854e+00) }},
{{ SC_(9.7540396451950073242187500000000000000000e-01), SC_(5.4722056388854980468750000000000000000000e+00), SC_(1.3637771829962730407714843750000000000000e-02), SC_(5.3939293310926713416159933994561605017939e+00) }},
{{ SC_(9.8712283372879028320312500000000000000000e-01), SC_(7.6685409545898437500000000000000000000000e+00), SC_(5.0600647926330566406250000000000000000000e-01), SC_(6.7773109966104035633009387524547305237113e-02) }},
{{ SC_(1.0562920570373535156250000000000000000000e+00), SC_(6.8127136230468750000000000000000000000000e+00), SC_(8.2583439350128173828125000000000000000000e-01), SC_(3.0084065543432262583243607218886904489503e-04) }},
{{ SC_(1.0621634721755981445312500000000000000000e+00), SC_(4.9278960227966308593750000000000000000000e+00), SC_(6.7985177040100097656250000000000000000000e-01), SC_(6.3010981102510187959875134044157528620691e-02) }},
{{ SC_(1.0665277242660522460937500000000000000000e+00), SC_(4.9854421615600585937500000000000000000000e+00), SC_(2.4002853035926818847656250000000000000000e-01), SC_(1.7617154124087510449476626113450697860141e+00) }},
{{ SC_(1.0676186084747314453125000000000000000000e+00), SC_(5.0197439193725585937500000000000000000000e+00), SC_(5.2858030796051025390625000000000000000000e-01), SC_(2.7220526544576023698147618120602184863496e-01) }},
{{ SC_(1.0776901245117187500000000000000000000000e+00), SC_(3.7481257915496826171875000000000000000000e+00), SC_(7.9485189914703369140625000000000000000000e-01), SC_(5.5223844165622593888730179782323480706242e-02) }},
{{ SC_(1.1111922264099121093750000000000000000000e+00), SC_(7.0732154846191406250000000000000000000000e+00), SC_(4.4273400306701660156250000000000000000000e-01), SC_(2.4540901423001771379045808515884642300110e-01) }},
{{ SC_(1.1120275259017944335937500000000000000000e+00), SC_(1.6287212371826171875000000000000000000000e+00), SC_(3.1257674098014831542968750000000000000000e-01), SC_(1.3037158003001024927473270527303228668401e+00) }},
{{ SC_(1.1741765737533569335937500000000000000000e+00), SC_(3.2496352195739746093750000000000000000000e+00), SC_(4.5804336667060852050781250000000000000000e-01), SC_(9.7691723094437333223828933284134563721179e-01) }},
{{ SC_(1.1899768114089965820312500000000000000000e+00), SC_(4.5603284835815429687500000000000000000000e+00), SC_(1.2527024745941162109375000000000000000000e-01), SC_(2.8306591297678280868672853102044926837764e+00) }},
{{ SC_(1.1939624547958374023437500000000000000000e+00), SC_(1.1107937097549438476562500000000000000000e+00), SC_(9.7992765903472900390625000000000000000000e-01), SC_(8.6767170176175187498358636988474774001679e-01) }},
{{ SC_(1.2061161994934082031250000000000000000000e+00), SC_(7.0715970993041992187500000000000000000000e+00), SC_(7.6554024219512939453125000000000000000000e-01), SC_(1.6642955117588874778955715276668585146159e-03) }},
{{ SC_(1.2331893444061279296875000000000000000000e+00), SC_(2.5295596122741699218750000000000000000000e+00), SC_(2.9639115929603576660156250000000000000000e-01), SC_(1.5987903273163698970756367717970753942786e+00) }},
{{ SC_(1.2698681354522705078125000000000000000000e+00), SC_(9.6886777877807617187500000000000000000000e+00), SC_(4.8830057494342327117919921875000000000000e-03), SC_(4.5943796499514525501233770635056278414865e+00) }},
{{ SC_(1.2801439762115478515625000000000000000000e+00), SC_(8.8172550201416015625000000000000000000000e+00), SC_(7.3174923658370971679687500000000000000000e-01), SC_(5.7401735453733960462141467006337718718368e-04) }},
{{ SC_(1.2990620136260986328125000000000000000000e+00), SC_(1.5443842411041259765625000000000000000000e+00), SC_(1.9457593560218811035156250000000000000000e-01), SC_(1.1883322389344632666427686371608960832771e+00) }},
{{ SC_(1.3197329044342041015625000000000000000000e+00), SC_(4.9030146598815917968750000000000000000000e+00), SC_(3.3251503109931945800781250000000000000000e-01), SC_(1.3777211742089946385975567128005133873758e+00) }},
{{ SC_(1.3317101001739501953125000000000000000000e+00), SC_(7.6503980159759521484375000000000000000000e-01), SC_(6.4458608627319335937500000000000000000000e-01), SC_(1.0692905948871155699958253880801921597023e+00) }},
{{ SC_(1.3606855869293212890625000000000000000000e+00), SC_(8.0211143493652343750000000000000000000000e+00), SC_(2.6255598664283752441406250000000000000000e-01), SC_(1.4308354185405005210488397231944950492181e+00) }},
{{ SC_(1.3655313253402709960937500000000000000000e+00), SC_(8.4710969924926757812500000000000000000000e+00), SC_(5.1329821348190307617187500000000000000000e-01), SC_(7.7251589462445037863536689824943376382268e-02) }},
{{ SC_(1.3862445354461669921875000000000000000000e+00), SC_(7.6173119544982910156250000000000000000000e+00), SC_(1.4197215437889099121093750000000000000000e-01), SC_(3.3199114023975402964034299653933327967042e+00) }},
{{ SC_(1.4188634157180786132812500000000000000000e+00), SC_(4.7834839671850204467773437500000000000000e-02), SC_(3.5808108747005462646484375000000000000000e-02), SC_(1.2587728811440588273844244915503357850740e-02) }},
{{ SC_(1.4495480060577392578125000000000000000000e+00), SC_(6.8028707504272460937500000000000000000000e+00), SC_(2.7282574772834777832031250000000000000000e-01), SC_(1.6716535517232510881664771166879651107347e+00) }},
{{ SC_(1.4553898572921752929687500000000000000000e+00), SC_(2.8267331123352050781250000000000000000000e+00), SC_(2.6228553056716918945312500000000000000000e-01), SC_(1.7756035217027754713499332141816970730275e+00) }},
{{ SC_(1.4929400682449340820312500000000000000000e+00), SC_(2.3015606403350830078125000000000000000000e+00), SC_(1.4504030346870422363281250000000000000000e-01), SC_(1.4189732988508193944882657328122362131254e+00) }},
{{ SC_(1.4986544847488403320312500000000000000000e+00), SC_(1.9510740041732788085937500000000000000000e+00), SC_(6.2209290266036987304687500000000000000000e-01), SC_(1.1325602886964452835119853392565789444467e+00) }},
{{ SC_(1.5237802267074584960937500000000000000000e+00), SC_(5.0319004058837890625000000000000000000000e+00), SC_(2.3023304343223571777343750000000000000000e-01), SC_(2.2974863369837232203314070801959009324386e+00) }},
{{ SC_(1.5272119045257568359375000000000000000000e+00), SC_(5.4025206565856933593750000000000000000000e+00), SC_(9.3401730060577392578125000000000000000000e-01), SC_(9.7284320612582418074751251441327462563792e-05) }},
{{ SC_(1.5365672111511230468750000000000000000000e+00), SC_(5.2704281806945800781250000000000000000000e+00), SC_(8.4848290681838989257812500000000000000000e-01), SC_(4.5144341318872055419073270290282138126859e-03) }},
{{ SC_(1.5640494823455810546875000000000000000000e+00), SC_(3.3579792976379394531250000000000000000000e+00), SC_(7.5722450017929077148437500000000000000000e-01), SC_(2.5546105968555965066511736397753199290757e-01) }},
{{ SC_(1.5761308670043945312500000000000000000000e+00), SC_(7.2583894729614257812500000000000000000000e+00), SC_(2.9317358508706092834472656250000000000000e-02), SC_(2.9429294482254198769259324867847623434354e+00) }},
{{ SC_(1.6148475408554077148437500000000000000000e+00), SC_(4.8818402290344238281250000000000000000000e+00), SC_(8.0103451013565063476562500000000000000000e-01), SC_(2.6291328365120759937737992983455477050014e-02) }},
{{ SC_(1.6218229532241821289062500000000000000000e+00), SC_(9.2749280929565429687500000000000000000000e+00), SC_(2.0782151818275451660156250000000000000000e-01), SC_(2.3857055623356743230192419593620412343175e+00) }},
{{ SC_(1.6261173486709594726562500000000000000000e+00), SC_(6.4396095275878906250000000000000000000000e+00), SC_(1.2340660393238067626953125000000000000000e-01), SC_(3.2735613237996452055199199401972489356687e+00) }},
{{ SC_(1.6564872264862060546875000000000000000000e+00), SC_(1.1954717636108398437500000000000000000000e+00), SC_(2.1200314164161682128906250000000000000000e-01), SC_(7.2923414537115505886716673851929837947418e-01) }},
{{ SC_(1.6716840267181396484375000000000000000000e+00), SC_(1.7211780548095703125000000000000000000000e+00), SC_(6.7973470687866210937500000000000000000000e-01), SC_(1.2175811545240493285691920498201630579712e+00) }},
{{ SC_(1.6792714595794677734375000000000000000000e+00), SC_(9.6299753189086914062500000000000000000000e+00), SC_(5.7974660396575927734375000000000000000000e-01), SC_(2.0417034490345291880125712177778832993307e-02) }},
{{ SC_(1.6899003982543945312500000000000000000000e+00), SC_(8.0913715362548828125000000000000000000000e+00), SC_(3.5079205036163330078125000000000000000000e-01), SC_(9.1725120663671452980985845958877000200499e-01) }},
{{ SC_(1.7070804834365844726562500000000000000000e+00), SC_(2.3950247764587402343750000000000000000000e+00), SC_(4.3026438355445861816406250000000000000000e-01), SC_(1.5235419639236300360193604039763803711076e+00) }},
{{ SC_(1.7112106084823608398437500000000000000000e+00), SC_(7.3929758071899414062500000000000000000000e+00), SC_(7.4067318439483642578125000000000000000000e-01), SC_(5.2630910046287638701723845825881473013077e-03) }},
{{ SC_(1.7118667364120483398437500000000000000000e+00), SC_(3.0191311836242675781250000000000000000000e+00), SC_(7.5946711003780364990234375000000000000000e-02), SC_(1.1841227485220410543932667095959412132471e+00) }},
{{ SC_(1.7338861227035522460937500000000000000000e+00), SC_(7.1390390396118164062500000000000000000000e+00), SC_(6.4634835720062255859375000000000000000000e-01), SC_(4.4123984877451030110431723250370480035689e-02) }},
{{ SC_(1.7587440013885498046875000000000000000000e+00), SC_(4.8637113571166992187500000000000000000000e+00), SC_(9.2927074432373046875000000000000000000000e-01), SC_(6.7585589843977522028162000702736056590064e-04) }},
{{ SC_(1.7813246250152587890625000000000000000000e+00), SC_(3.1267695426940917968750000000000000000000e+00), SC_(7.3035782575607299804687500000000000000000e-01), SC_(4.8220862271590760923769541062284921676133e-01) }},
{{ SC_(1.7876619100570678710937500000000000000000e+00), SC_(4.2912654876708984375000000000000000000000e+00), SC_(8.0213123559951782226562500000000000000000e-01), SC_(6.8693378198135786626234265585559930514585e-02) }},
{{ SC_(1.8184702396392822265625000000000000000000e+00), SC_(9.8236055374145507812500000000000000000000e+00), SC_(2.5837007164955139160156250000000000000000e-01), SC_(1.7297157094434462485616932159364632278202e+00) }},
{{ SC_(1.8292245864868164062500000000000000000000e+00), SC_(2.4501924514770507812500000000000000000000e+00), SC_(5.6786483526229858398437500000000000000000e-01), SC_(1.3227830238763360738543727830768709883563e+00) }},
{{ SC_(1.8351116180419921875000000000000000000000e+00), SC_(3.8571052551269531250000000000000000000000e+00), SC_(3.6854773759841918945312500000000000000000e-01), SC_(1.7672967048751542846971809642689368161665e+00) }},
{{ SC_(1.8390779495239257812500000000000000000000e+00), SC_(5.0477099418640136718750000000000000000000e+00), SC_(2.9674619436264038085937500000000000000000e-01), SC_(2.0815735207602663402498760247327703979695e+00) }},
{{ SC_(1.8481632471084594726562500000000000000000e+00), SC_(5.8438224792480468750000000000000000000000e+00), SC_(4.3872296810150146484375000000000000000000e-01), SC_(9.4901455890521777291817098243556851588579e-01) }},
{{ SC_(1.8687260150909423828125000000000000000000e+00), SC_(4.0873117446899414062500000000000000000000e+00), SC_(1.0815110802650451660156250000000000000000e-01), SC_(1.7759383462915167092626286862224988356718e+00) }},
{{ SC_(1.8866198062896728515625000000000000000000e+00), SC_(8.8494262695312500000000000000000000000000e+00), SC_(9.5613896846771240234375000000000000000000e-01), SC_(1.4733541503853567841142366212432525485297e-09) }},
{{ SC_(1.8895499706268310546875000000000000000000e+00), SC_(8.1187400817871093750000000000000000000000e+00), SC_(3.6135786771774291992187500000000000000000e-01), SC_(1.0001521206370728951751218180800473244513e+00) }},
{{ SC_(1.9043327569961547851562500000000000000000e+00), SC_(4.5651044845581054687500000000000000000000e+00), SC_(7.5129193067550659179687500000000000000000e-01), SC_(1.2018009459374212273354157907616294835319e-01) }},
{{ SC_(1.9092369079589843750000000000000000000000e+00), SC_(5.9598097801208496093750000000000000000000e+00), SC_(7.6244509220123291015625000000000000000000e-01), SC_(2.2445345088643400393017483632554993317945e-02) }},
{{ SC_(1.9174524545669555664062500000000000000000e+00), SC_(5.4286212921142578125000000000000000000000e+00), SC_(9.4205635786056518554687500000000000000000e-01), SC_(9.6787795428953466603639109062340446310774e-05) }},
{{ SC_(1.9476429224014282226562500000000000000000e+00), SC_(4.4122347831726074218750000000000000000000e+00), SC_(4.2322281002998352050781250000000000000000e-01), SC_(1.5050533057629153627126340159475944758847e+00) }},
{{ SC_(1.9659525156021118164062500000000000000000e+00), SC_(8.4846782684326171875000000000000000000000e+00), SC_(1.5814177691936492919921875000000000000000e-01), SC_(3.5034424237576001656089084072630546772097e+00) }},
{{ SC_(1.9780982732772827148437500000000000000000e+00), SC_(5.1385922431945800781250000000000000000000e+00), SC_(5.4663729667663574218750000000000000000000e-01), SC_(6.4044529558485750188797811217729470343640e-01) }},
{{ SC_(1.9811840057373046875000000000000000000000e+00), SC_(8.6430749893188476562500000000000000000000e+00), SC_(6.8043857812881469726562500000000000000000e-01), SC_(9.0067472189010184326776620865170800678539e-03) }},
{{ SC_(2.0774228572845458984375000000000000000000e+00), SC_(5.4013800621032714843750000000000000000000e+00), SC_(4.1272526979446411132812500000000000000000e-01), SC_(1.4367897405725317619306875538797913649876e+00) }},
{{ SC_(2.0893492698669433593750000000000000000000e+00), SC_(5.8787703514099121093750000000000000000000e+00), SC_(9.7059571743011474609375000000000000000000e-01), SC_(1.5160660986764441145333144533844476899032e-06) }},
{{ SC_(2.2174673080444335937500000000000000000000e+00), SC_(8.3121433258056640625000000000000000000000e+00), SC_(4.5608720183372497558593750000000000000000e-01), SC_(5.1321732657316730564614527523476107050004e-01) }},
{{ SC_(2.2381193637847900390625000000000000000000e+00), SC_(1.7773896455764770507812500000000000000000e-01), SC_(1.3206009566783905029296875000000000000000e-01), SC_(1.9648413981788285704864552917652373129546e-02) }},
{{ SC_(2.2404003143310546875000000000000000000000e+00), SC_(9.1827659606933593750000000000000000000000e+00), SC_(9.0006387233734130859375000000000000000000e-01), SC_(8.4280524568236529883943320149779864588857e-07) }},
{{ SC_(2.2592177391052246093750000000000000000000e+00), SC_(1.4782900810241699218750000000000000000000e+00), SC_(4.2422434687614440917968750000000000000000e-01), SC_(1.1268685903060459726759584920557997826152e+00) }},
{{ SC_(2.2618765830993652343750000000000000000000e+00), SC_(4.7799577713012695312500000000000000000000e+00), SC_(7.7493298053741455078125000000000000000000e-01), SC_(1.0176506438095927590774135194657233501928e-01) }},
{{ SC_(2.2766430377960205078125000000000000000000e+00), SC_(7.9965314865112304687500000000000000000000e+00), SC_(4.3147069215774536132812500000000000000000e-01), SC_(7.6973749719970797767473481977747179749405e-01) }},
{{ SC_(2.2897696495056152343750000000000000000000e+00), SC_(5.0549855232238769531250000000000000000000e+00), SC_(2.2774152457714080810546875000000000000000e-01), SC_(2.3830128127495285016657885600230793301872e+00) }},
{{ SC_(2.3048815727233886718750000000000000000000e+00), SC_(1.9449536800384521484375000000000000000000e+00), SC_(4.2181909084320068359375000000000000000000e-01), SC_(1.3984178047477433872293193159540809620071e+00) }},
{{ SC_(2.3159439563751220703125000000000000000000e+00), SC_(4.0157146453857421875000000000000000000000e+00), SC_(4.9035245180130004882812500000000000000000e-01), SC_(1.5178244048082788205918675508255817149786e+00) }},
{{ SC_(2.3477990627288818359375000000000000000000e+00), SC_(5.5288114547729492187500000000000000000000e+00), SC_(3.4390515089035034179687500000000000000000e-01), SC_(2.1009255832805428570367355523433117989335e+00) }},
{{ SC_(2.3623058795928955078125000000000000000000e+00), SC_(3.2823646068572998046875000000000000000000e+00), SC_(9.7975039482116699218750000000000000000000e-01), SC_(2.7482601927872162847301971784743159702379e-03) }},
{{ SC_(2.3728356361389160156250000000000000000000e+00), SC_(9.6864032745361328125000000000000000000000e+00), SC_(4.8762014508247375488281250000000000000000e-01), SC_(2.3514176551632200273001528024977797277250e-01) }},
{{ SC_(2.3991615772247314453125000000000000000000e+00), SC_(4.0471109747886657714843750000000000000000e-01), SC_(2.8787621855735778808593750000000000000000e-01), SC_(1.3249506932872345214768646793858890650407e-01) }},
{{ SC_(2.3993201255798339843750000000000000000000e+00), SC_(3.3300526142120361328125000000000000000000e+00), SC_(5.6886672973632812500000000000000000000000e-01), SC_(1.4162569000900879249745083750699576926222e+00) }},
{{ SC_(2.3995251655578613281250000000000000000000e+00), SC_(8.2260494232177734375000000000000000000000e+00), SC_(2.9709973931312561035156250000000000000000e-01), SC_(2.1898551494724759946611825498348065598464e+00) }},
{{ SC_(2.4070703983306884765625000000000000000000e+00), SC_(4.1576251983642578125000000000000000000000e+00), SC_(8.7595522403717041015625000000000000000000e-01), SC_(4.0256305211527114809298011542068691427611e-02) }},
{{ SC_(2.4169127941131591796875000000000000000000e+00), SC_(2.7275302410125732421875000000000000000000e+00), SC_(3.1884643435478210449218750000000000000000e-01), SC_(1.5373729019174879272724222119262727653137e+00) }},
{{ SC_(2.4284958839416503906250000000000000000000e+00), SC_(3.3197727203369140625000000000000000000000e+00), SC_(9.4893020391464233398437500000000000000000e-01), SC_(2.1181052738778514303335882255329753923200e-02) }},
{{ SC_(2.4352498054504394531250000000000000000000e+00), SC_(1.3539126515388488769531250000000000000000e-01), SC_(1.5246278047561645507812500000000000000000e-01), SC_(1.2318262771064781378754607775408077290899e-02) }},
{{ SC_(2.5108385086059570312500000000000000000000e+00), SC_(9.5501756668090820312500000000000000000000e+00), SC_(1.6226607561111450195312500000000000000000e-01), SC_(3.6623013221340525180266899467660921106685e+00) }},
{{ SC_(2.5180611610412597656250000000000000000000e+00), SC_(6.5472359657287597656250000000000000000000e+00), SC_(7.7918928861618041992187500000000000000000e-01), SC_(1.7286202558531142023363643227842292442683e-02) }},
{{ SC_(2.5428216457366943359375000000000000000000e+00), SC_(3.3244826793670654296875000000000000000000e+00), SC_(1.4919906854629516601562500000000000000000e-01), SC_(9.2697049834583070299059518944058204439267e-01) }},
{{ SC_(2.5479016304016113281250000000000000000000e+00), SC_(9.3521432876586914062500000000000000000000e+00), SC_(8.9091414213180541992187500000000000000000e-01), SC_(2.0250634410824053581414789001159579746832e-06) }},
{{ SC_(2.5509512424468994140625000000000000000000e+00), SC_(8.2084074020385742187500000000000000000000e+00), SC_(1.3382300734519958496093750000000000000000e-01), SC_(3.0559317467479720108638413040401953742310e+00) }},
{{ SC_(2.5644099712371826171875000000000000000000e+00), SC_(3.4306178092956542968750000000000000000000e+00), SC_(9.9613505601882934570312500000000000000000e-01), SC_(3.7645062313670812866685877116497504330320e-05) }},
{{ SC_(2.5750823020935058593750000000000000000000e+00), SC_(8.0973453521728515625000000000000000000000e+00), SC_(1.4562442898750305175781250000000000000000e-01), SC_(3.0851373028392605938406685341485589056586e+00) }},
{{ SC_(2.5806469917297363281250000000000000000000e+00), SC_(1.6232850551605224609375000000000000000000e+00), SC_(4.4564163684844970703125000000000000000000e-01), SC_(1.1911618082945008833829913213131697079495e+00) }},
{{ SC_(2.5987040996551513671875000000000000000000e+00), SC_(4.5059543848037719726562500000000000000000e-01), SC_(2.5435674190521240234375000000000000000000e-01), SC_(9.8226470293328348334195149226681330259405e-02) }},
{{ SC_(2.6072800159454345703125000000000000000000e+00), SC_(6.5921058654785156250000000000000000000000e+00), SC_(7.9794883728027343750000000000000000000000e-01), SC_(1.1522805693151532328397398579845457822509e-02) }},
{{ SC_(2.6187119483947753906250000000000000000000e+00), SC_(3.2779777050018310546875000000000000000000e+00), SC_(5.0790750980377197265625000000000000000000e-01), SC_(1.7583386592027931168094478376287187667619e+00) }},
{{ SC_(2.6221175193786621093750000000000000000000e+00), SC_(4.2054122686386108398437500000000000000000e-01), SC_(4.4961112737655639648437500000000000000000e-01), SC_(2.6250502955306280980600912100099897334017e-01) }},
{{ SC_(2.6248221397399902343750000000000000000000e+00), SC_(1.8157297372817993164062500000000000000000e+00), SC_(4.7200959920883178710937500000000000000000e-01), SC_(1.3786320972708189834791639333319601448040e+00) }},
{{ SC_(2.6297128200531005859375000000000000000000e+00), SC_(3.4021968841552734375000000000000000000000e+00), SC_(2.1731612086296081542968750000000000000000e-01), SC_(1.3380521446462808405373085776564779076442e+00) }},
{{ SC_(2.6380290985107421875000000000000000000000e+00), SC_(9.5355176925659179687500000000000000000000e-01), SC_(2.5994440913200378417968750000000000000000e-01), SC_(2.7131445099690803595976465549227384667267e-01) }},
{{ SC_(2.6528089046478271484375000000000000000000e+00), SC_(9.9647502899169921875000000000000000000000e+00), SC_(7.8027403354644775390625000000000000000000e-01), SC_(3.0714500788604620193470023218643645419787e-04) }},
{{ SC_(2.6647150516510009765625000000000000000000e+00), SC_(6.9140052795410156250000000000000000000000e-01), SC_(8.4432435035705566406250000000000000000000e-01), SC_(1.9339399248440883501673572989676848960124e+00) }},
{{ SC_(2.6906161308288574218750000000000000000000e+00), SC_(8.5707244873046875000000000000000000000000e+00), SC_(9.5494788885116577148437500000000000000000e-01), SC_(1.6034824950577518378273477065041278908262e-08) }},
{{ SC_(2.6911940574645996093750000000000000000000e+00), SC_(9.7187738418579101562500000000000000000000e+00), SC_(7.0580369234085083007812500000000000000000e-01), SC_(4.7653160545805576960515804952936038089344e-03) }},
{{ SC_(2.7602508068084716796875000000000000000000e+00), SC_(7.0577421188354492187500000000000000000000e+00), SC_(1.1750591546297073364257812500000000000000e-01), SC_(2.0058448243332991941276861192194232875999e+00) }},
{{ SC_(2.7692296504974365234375000000000000000000e+00), SC_(8.7242879867553710937500000000000000000000e+00), SC_(7.8267715871334075927734375000000000000000e-02), SC_(1.8769306710588232891077327170739417016035e+00) }},
{{ SC_(2.7849822044372558593750000000000000000000e+00), SC_(1.8838198184967041015625000000000000000000e+00), SC_(1.5501900576055049896240234375000000000000e-02), SC_(5.4113651642997962531121184691215852954696e-03) }},
{{ SC_(2.8100528717041015625000000000000000000000e+00), SC_(2.6204881668090820312500000000000000000000e+00), SC_(8.4914439916610717773437500000000000000000e-01), SC_(6.6185176817317484722945701879792033480679e-01) }},
{{ SC_(2.8583903312683105468750000000000000000000e+00), SC_(6.7981977462768554687500000000000000000000e+00), SC_(1.7126956582069396972656250000000000000000e-01), SC_(2.4483854920968318434070250810867259777798e+00) }},
{{ SC_(2.8749816417694091796875000000000000000000e+00), SC_(5.9308695793151855468750000000000000000000e+00), SC_(9.5717126131057739257812500000000000000000e-01), SC_(2.3076978752328876492899611469600870791616e-05) }},
{{ SC_(2.8906457424163818359375000000000000000000e+00), SC_(5.5441427230834960937500000000000000000000e-01), SC_(8.7737619876861572265625000000000000000000e-01), SC_(2.1417322068195723851297627179147253380441e+00) }},
{{ SC_(2.9044067859649658203125000000000000000000e+00), SC_(7.8066945075988769531250000000000000000000e-01), SC_(7.7971142530441284179687500000000000000000e-01), SC_(1.6334721227441327823779639969647326287182e+00) }},
{{ SC_(2.9198408126831054687500000000000000000000e+00), SC_(8.2463169097900390625000000000000000000000e+00), SC_(6.6363912820816040039062500000000000000000e-01), SC_(5.8885332358411636389046480221723246546397e-02) }},
{{ SC_(2.9632079601287841796875000000000000000000e+00), SC_(2.8780498504638671875000000000000000000000e+00), SC_(3.5640951991081237792968750000000000000000e-01), SC_(1.5263328074804998214335971965360335221670e+00) }},
{{ SC_(2.9667584896087646484375000000000000000000e+00), SC_(6.5577988624572753906250000000000000000000e+00), SC_(4.5855104923248291015625000000000000000000e-01), SC_(1.4491593204736579334297912759603524267588e+00) }},
{{ SC_(3.0124633312225341796875000000000000000000e+00), SC_(1.8450842797756195068359375000000000000000e-01), SC_(4.1732531785964965820312500000000000000000e-01), SC_(6.3939668082821591599718578185937520532827e-02) }},
{{ SC_(3.0145497322082519531250000000000000000000e+00), SC_(3.1048996448516845703125000000000000000000e+00), SC_(7.1612906455993652343750000000000000000000e-01), SC_(1.1860784672481748137836091167682628075171e+00) }},
{{ SC_(3.0634949207305908203125000000000000000000e+00), SC_(1.0806190967559814453125000000000000000000e+00), SC_(3.8863095641136169433593750000000000000000e-01), SC_(4.8414120651594679545189651712511941911314e-01) }},
{{ SC_(3.1110229492187500000000000000000000000000e+00), SC_(8.9823162555694580078125000000000000000000e-01), SC_(4.3575510382652282714843750000000000000000e-01), SC_(4.6876680070365628922588073130896797369825e-01) }},
{{ SC_(3.1121504306793212890625000000000000000000e+00), SC_(8.6267814636230468750000000000000000000000e+00), SC_(2.1028804779052734375000000000000000000000e-01), SC_(3.1915631926419935554576283290988303343950e+00) }},
{{ SC_(3.1271891593933105468750000000000000000000e+00), SC_(4.9175214767456054687500000000000000000000e+00), SC_(8.0030041933059692382812500000000000000000e-01), SC_(1.3034132761151814446880000963245983055967e-01) }},
{{ SC_(3.1709947586059570312500000000000000000000e+00), SC_(7.6374998092651367187500000000000000000000e+00), SC_(8.9914172887802124023437500000000000000000e-02), SC_(1.1511423911175713327642055599500770654032e+00) }},
{{ SC_(3.1877830028533935546875000000000000000000e+00), SC_(4.2018995285034179687500000000000000000000e+00), SC_(4.5890295505523681640625000000000000000000e-01), SC_(2.0660336762867071118577758117196192618885e+00) }},
{{ SC_(3.1959974765777587890625000000000000000000e+00), SC_(3.2532787322998046875000000000000000000000e+00), SC_(8.1732153892517089843750000000000000000000e-01), SC_(5.9313472764618810325957224692747103482329e-01) }},
{{ SC_(3.2247180938720703125000000000000000000000e+00), SC_(3.0466351509094238281250000000000000000000e+00), SC_(9.2088270187377929687500000000000000000000e-01), SC_(1.7116754575294349742714348020910381447929e-01) }},
{{ SC_(3.2514567375183105468750000000000000000000e+00), SC_(6.8296647071838378906250000000000000000000e+00), SC_(8.2347548007965087890625000000000000000000e-01), SC_(8.5434921671291947431262980224033026824676e-03) }},
{{ SC_(3.3416304588317871093750000000000000000000e+00), SC_(7.1997094154357910156250000000000000000000e+00), SC_(5.4385107755661010742187500000000000000000e-01), SC_(7.8389750674951472045269641901782176133857e-01) }},
{{ SC_(3.3535683155059814453125000000000000000000e+00), SC_(1.2906616926193237304687500000000000000000e+00), SC_(5.0855785608291625976562500000000000000000e-01), SC_(9.2515197323536610144613021353263143586294e-01) }},
{{ SC_(3.3712265491485595703125000000000000000000e+00), SC_(3.8856978416442871093750000000000000000000e+00), SC_(1.9995288550853729248046875000000000000000e-01), SC_(8.9853524999011145108799487525703229103982e-01) }},
{{ SC_(3.3771941661834716796875000000000000000000e+00), SC_(8.8772611618041992187500000000000000000000e+00), SC_(3.0823621153831481933593750000000000000000e-01), SC_(2.7602552625196193138419508205654505215342e+00) }},
{{ SC_(3.3949341773986816406250000000000000000000e+00), SC_(6.1627225875854492187500000000000000000000e+00), SC_(6.8680679798126220703125000000000000000000e-01), SC_(2.9184196213438842345408457890165200751343e-01) }},
{{ SC_(3.4038574695587158203125000000000000000000e+00), SC_(8.7675743103027343750000000000000000000000e+00), SC_(1.2993355095386505126953125000000000000000e-01), SC_(2.0726778658159453875152605981255829531246e+00) }},
{{ SC_(3.4112460613250732421875000000000000000000e+00), SC_(7.2302422523498535156250000000000000000000e+00), SC_(9.3900763988494873046875000000000000000000e-01), SC_(1.0873840703676346271066973575033299926453e-05) }},
{{ SC_(3.4387702941894531250000000000000000000000e+00), SC_(2.0375971794128417968750000000000000000000e+00), SC_(7.9399561882019042968750000000000000000000e-01), SC_(1.7639781429493939934358980432572936302924e+00) }},
{{ SC_(3.4446244239807128906250000000000000000000e+00), SC_(2.2622740268707275390625000000000000000000e+00), SC_(9.0489047765731811523437500000000000000000e-01), SC_(8.2606269498593313358714749174659871853600e-01) }},
{{ SC_(3.4998373985290527343750000000000000000000e+00), SC_(9.0736474990844726562500000000000000000000e+00), SC_(1.5769731998443603515625000000000000000000e-01), SC_(2.5879562411971644388435835761718695788874e+00) }},
{{ SC_(3.5021800994873046875000000000000000000000e+00), SC_(6.8738579750061035156250000000000000000000e-01), SC_(9.8852270841598510742187500000000000000000e-01), SC_(6.8394502073865398896095129423659206000867e+00) }},
{{ SC_(3.5072712898254394531250000000000000000000e+00), SC_(9.9011001586914062500000000000000000000000e+00), SC_(4.0186783671379089355468750000000000000000e-01), SC_(1.4569329318327913113291752812135155793552e+00) }},
{{ SC_(3.5095238685607910156250000000000000000000e+00), SC_(1.9955120086669921875000000000000000000000e+00), SC_(2.7857038378715515136718750000000000000000e-01), SC_(4.6019137739095985951037731571955587962530e-01) }},
{{ SC_(3.5165951251983642578125000000000000000000e+00), SC_(6.7595374584197998046875000000000000000000e-01), SC_(1.6295583546161651611328125000000000000000e-01), SC_(1.8690681011951883842861949488479711085925e-02) }},
{{ SC_(3.5315856933593750000000000000000000000000e+00), SC_(5.3152573108673095703125000000000000000000e-01), SC_(3.4399533271789550781250000000000000000000e-01), SC_(9.2436052825235446931308477971519329442992e-02) }},
{{ SC_(3.6743664741516113281250000000000000000000e+00), SC_(1.5157415866851806640625000000000000000000e+00), SC_(4.9841421842575073242187500000000000000000e-01), SC_(9.7246935950911052351094376776207149316695e-01) }},
{{ SC_(3.6848456859588623046875000000000000000000e+00), SC_(3.4392974376678466796875000000000000000000e+00), SC_(3.6930984258651733398437500000000000000000e-01), SC_(1.5985229068396188567334113665961573537763e+00) }},
{{ SC_(3.6891655921936035156250000000000000000000e+00), SC_(6.3430333137512207031250000000000000000000e+00), SC_(7.5375372171401977539062500000000000000000e-01), SC_(1.1391417591482350953482966112672646946022e-01) }},
{{ SC_(3.6924679279327392578125000000000000000000e+00), SC_(3.3268564939498901367187500000000000000000e-01), SC_(3.1128391623497009277343750000000000000000e-01), SC_(3.0909804636147289973438438902616945332436e-02) }},
{{ SC_(3.7240974903106689453125000000000000000000e+00), SC_(1.9532476663589477539062500000000000000000e+00), SC_(6.8031901121139526367187500000000000000000e-01), SC_(1.9600706034484035726687062699369956596302e+00) }},
{{ SC_(3.7627220153808593750000000000000000000000e+00), SC_(1.7316303253173828125000000000000000000000e+00), SC_(7.6175504922866821289062500000000000000000e-01), SC_(2.0841053783792902520200080388201368452232e+00) }},
{{ SC_(3.7860939502716064453125000000000000000000e+00), SC_(1.4014384746551513671875000000000000000000e+00), SC_(3.9496871829032897949218750000000000000000e-01), SC_(4.7926178464285493293630237804881918885846e-01) }},
{{ SC_(3.8044581413269042968750000000000000000000e+00), SC_(2.0806806087493896484375000000000000000000e+00), SC_(1.8192884325981140136718750000000000000000e-01), SC_(1.3651706208772702170874953563564397837724e-01) }},
{{ SC_(3.8155846595764160156250000000000000000000e+00), SC_(2.1020905971527099609375000000000000000000e+00), SC_(9.7630649805068969726562500000000000000000e-02), SC_(2.6577746064144832527375056086114784635655e-02) }},
{{ SC_(3.8461909294128417968750000000000000000000e+00), SC_(1.8211762607097625732421875000000000000000e-01), SC_(7.7573508024215698242187500000000000000000e-01), SC_(4.0749259911360981081856330653124652268371e-01) }},
{{ SC_(3.8677120208740234375000000000000000000000e+00), SC_(9.8445262908935546875000000000000000000000e+00), SC_(9.1065651178359985351562500000000000000000e-01), SC_(9.1424198584186483672281240388107210981562e-07) }},
{{ SC_(3.8973884582519531250000000000000000000000e+00), SC_(2.1030187606811523437500000000000000000000e+00), SC_(3.1716775894165039062500000000000000000000e-01), SC_(5.1117384386925821803758604327449519770638e-01) }},
{{ SC_(3.9093780517578125000000000000000000000000e+00), SC_(6.1720490455627441406250000000000000000000e+00), SC_(6.4778119325637817382812500000000000000000e-01), SC_(6.4560724203013873735401253014966850242527e-01) }},
{{ SC_(3.9222702980041503906250000000000000000000e+00), SC_(4.2208766937255859375000000000000000000000e+00), SC_(5.9873566031455993652343750000000000000000e-02), SC_(3.3962543338007396979972568008769018377981e-02) }},
{{ SC_(3.9551520347595214843750000000000000000000e+00), SC_(6.3646860122680664062500000000000000000000e+00), SC_(4.9337750673294067382812500000000000000000e-01), SC_(1.8859953317410266950449414842694766119922e+00) }},
{{ SC_(3.9925777912139892578125000000000000000000e+00), SC_(8.5809926986694335937500000000000000000000e+00), SC_(6.5513253211975097656250000000000000000000e-01), SC_(1.4668264584556942592411831096846785226176e-01) }},
{{ SC_(3.9978263378143310546875000000000000000000e+00), SC_(8.5587520599365234375000000000000000000000e+00), SC_(2.5303068757057189941406250000000000000000e-01), SC_(2.9727796569488702157924300111128966923220e+00) }},
{{ SC_(4.0180802345275878906250000000000000000000e+00), SC_(3.8233294486999511718750000000000000000000e+00), SC_(2.8274503350257873535156250000000000000000e-01), SC_(1.0699330996433410225140881164592753941829e+00) }},
{{ SC_(4.0391211509704589843750000000000000000000e+00), SC_(4.9244198799133300781250000000000000000000e+00), SC_(3.2257848978042602539062500000000000000000e-01), SC_(1.9227621384848144272753633544602487526545e+00) }},
{{ SC_(4.0761919021606445312500000000000000000000e+00), SC_(5.1604781150817871093750000000000000000000e+00), SC_(8.2121193408966064453125000000000000000000e-01), SC_(1.4018645465500963417683594483707030418891e-01) }},
{{ SC_(4.0871982574462890625000000000000000000000e+00), SC_(1.3373639583587646484375000000000000000000e+00), SC_(4.4683906435966491699218750000000000000000e-01), SC_(5.2810075853426483599239251474197743948563e-01) }},
{{ SC_(4.1615858078002929687500000000000000000000e+00), SC_(4.3342967033386230468750000000000000000000e+00), SC_(9.9288201332092285156250000000000000000000e-01), SC_(1.3731036427839137757516245846978066186316e-05) }},
{{ SC_(4.1679944992065429687500000000000000000000e+00), SC_(6.1727914810180664062500000000000000000000e+00), SC_(6.5577512979507446289062500000000000000000e-01), SC_(6.9091408193572917664962881429190677983615e-01) }},
{{ SC_(4.1726703643798828125000000000000000000000e+00), SC_(9.8172311782836914062500000000000000000000e+00), SC_(2.9990172386169433593750000000000000000000e-01), SC_(3.1788618649614988835542784371239639477928e+00) }},
{{ SC_(4.1774411201477050781250000000000000000000e+00), SC_(5.6677742004394531250000000000000000000000e+00), SC_(7.1073275804519653320312500000000000000000e-01), SC_(5.1157270160598556009519865379517834881864e-01) }},
{{ SC_(4.2176127433776855468750000000000000000000e+00), SC_(1.1246451139450073242187500000000000000000e+00), SC_(3.6537606269121170043945312500000000000000e-02), SC_(1.2861656526451207462009179500741594392568e-04) }},
{{ SC_(4.2283563613891601562500000000000000000000e+00), SC_(5.6396493911743164062500000000000000000000e+00), SC_(7.0607548952102661132812500000000000000000e-01), SC_(5.6577519670880895126510795566245086432507e-01) }},
{{ SC_(4.2288570404052734375000000000000000000000e+00), SC_(3.9472770690917968750000000000000000000000e+00), SC_(8.0755025148391723632812500000000000000000e-01), SC_(6.2048734145950080335242208783128693727784e-01) }},
{{ SC_(4.2345290184020996093750000000000000000000e+00), SC_(6.9814691543579101562500000000000000000000e+00), SC_(8.3502507209777832031250000000000000000000e-01), SC_(1.2456415768872471707658447458668875716277e-02) }},
{{ SC_(4.2416677474975585937500000000000000000000e+00), SC_(7.8190917968750000000000000000000000000000e+00), SC_(4.6252796053886413574218750000000000000000e-01), SC_(1.9182873405138792904996798911507786966337e+00) }},
{{ SC_(4.2434902191162109375000000000000000000000e+00), SC_(3.0012050643563270568847656250000000000000e-02), SC_(9.1574394702911376953125000000000000000000e-01), SC_(2.6300610189936086868642526925399828026184e-01) }},
{{ SC_(4.2525930404663085937500000000000000000000e+00), SC_(7.6996564865112304687500000000000000000000e+00), SC_(8.0008846521377563476562500000000000000000e-01), SC_(1.5466673300037699770455456733815238501079e-02) }},
{{ SC_(4.2572884559631347656250000000000000000000e+00), SC_(9.0002212524414062500000000000000000000000e+00), SC_(9.6190190315246582031250000000000000000000e-01), SC_(1.0659094181287075608969612861654338860483e-08) }},
{{ SC_(4.2825298309326171875000000000000000000000e+00), SC_(7.2689313888549804687500000000000000000000e+00), SC_(7.6295512914657592773437500000000000000000e-01), SC_(6.4389629458977646366895190180151158371841e-02) }},
{{ SC_(4.3020739555358886718750000000000000000000e+00), SC_(6.3306365013122558593750000000000000000000e+00), SC_(4.3617394566535949707031250000000000000000e-01), SC_(2.4787109663702545626023935543868116260320e+00) }},
{{ SC_(4.3141384124755859375000000000000000000000e+00), SC_(7.4994101524353027343750000000000000000000e+00), SC_(2.5758248567581176757812500000000000000000e-01), SC_(2.4206969328782940169695575655724567408348e+00) }},
{{ SC_(4.3165121078491210937500000000000000000000e+00), SC_(3.5932440757751464843750000000000000000000e+00), SC_(6.6931819915771484375000000000000000000000e-01), SC_(1.8854283682137119462724688138748341643195e+00) }},
{{ SC_(4.3239150047302246093750000000000000000000e+00), SC_(2.4431965351104736328125000000000000000000e+00), SC_(6.3979935646057128906250000000000000000000e-01), SC_(2.0762920660938046234049896668031464897743e+00) }},
{{ SC_(4.3569869995117187500000000000000000000000e+00), SC_(4.7301506996154785156250000000000000000000e+00), SC_(4.3530216813087463378906250000000000000000e-01), SC_(2.2940927001182334294137695165241334363530e+00) }},
{{ SC_(4.3585858345031738281250000000000000000000e+00), SC_(4.8861770629882812500000000000000000000000e+00), SC_(3.8577193021774291992187500000000000000000e-01), SC_(2.1618415188138988973089948497719427752107e+00) }},
{{ SC_(4.3874435424804687500000000000000000000000e+00), SC_(1.2589663267135620117187500000000000000000e+00), SC_(9.7222059965133666992187500000000000000000e-02), SC_(2.6725454823686120885902784177011731714371e-03) }},
{{ SC_(4.3886995315551757812500000000000000000000e+00), SC_(6.8040666580200195312500000000000000000000e+00), SC_(4.4127935171127319335937500000000000000000e-01), SC_(2.4417465223678180760675874450586841428933e+00) }},
{{ SC_(4.4008512496948242187500000000000000000000e+00), SC_(4.8337516784667968750000000000000000000000e+00), SC_(8.5304582118988037109375000000000000000000e-01), SC_(1.3129750343277069318842761685451188251833e-01) }},
{{ SC_(4.4267826080322265625000000000000000000000e+00), SC_(6.0423150062561035156250000000000000000000e+00), SC_(2.3999217152595520019531250000000000000000e-01), SC_(1.4661860780780033997347272291911745448440e+00) }},
{{ SC_(4.4558620452880859375000000000000000000000e+00), SC_(4.8756895065307617187500000000000000000000e+00), SC_(1.1120810359716415405273437500000000000000e-01), SC_(1.2102940245330142328197412348985853143199e-01) }},
{{ SC_(4.4678373336791992187500000000000000000000e+00), SC_(7.5578985214233398437500000000000000000000e+00), SC_(3.8735717535018920898437500000000000000000e-01), SC_(2.7361955858808132782350510590103956069631e+00) }},
{{ SC_(4.5013771057128906250000000000000000000000e+00), SC_(9.7391500473022460937500000000000000000000e+00), SC_(9.8172497749328613281250000000000000000000e-01), SC_(2.9954278272613515591262154458974329771557e-12) }},
{{ SC_(4.5054159164428710937500000000000000000000e+00), SC_(7.2049345970153808593750000000000000000000e+00), SC_(2.2388955950736999511718750000000000000000e-01), SC_(1.7368034873471902279923474053089884151869e+00) }},
{{ SC_(4.5092372894287109375000000000000000000000e+00), SC_(3.7850043773651123046875000000000000000000e+00), SC_(3.5322323441505432128906250000000000000000e-01), SC_(1.3014535346241886168347812257947268755524e+00) }},
{{ SC_(4.5379767417907714843750000000000000000000e+00), SC_(4.3693289756774902343750000000000000000000e+00), SC_(6.3310039043426513671875000000000000000000e-01), SC_(1.8776273358012489281253417397027317387417e+00) }},
{{ SC_(4.5742435455322265625000000000000000000000e+00), SC_(9.4440764188766479492187500000000000000000e-01), SC_(8.5588955879211425781250000000000000000000e-01), SC_(2.5783577799950543024457925181582518534546e+00) }},
{{ SC_(4.5872545242309570312500000000000000000000e+00), SC_(5.3322949409484863281250000000000000000000e+00), SC_(9.8236232995986938476562500000000000000000e-01), SC_(1.3650555494165020699463244384522360781098e-05) }},
{{ SC_(4.5884885787963867187500000000000000000000e+00), SC_(2.1377272605895996093750000000000000000000e+00), SC_(4.8866012692451477050781250000000000000000e-01), SC_(1.1027409695768360680997335078849972297542e+00) }},
{{ SC_(4.6072592735290527343750000000000000000000e+00), SC_(5.2976298332214355468750000000000000000000e+00), SC_(7.5471121072769165039062500000000000000000e-01), SC_(4.9332043492642212462264841347559237154516e-01) }},
{{ SC_(4.6091637611389160156250000000000000000000e+00), SC_(4.4642395973205566406250000000000000000000e+00), SC_(9.1712617874145507812500000000000000000000e-01), SC_(4.1225546953648625323345812539997290717231e-02) }},
{{ SC_(4.6244916915893554687500000000000000000000e+00), SC_(4.6901559829711914062500000000000000000000e+00), SC_(9.1338449716567993164062500000000000000000e-01), SC_(3.2633001307531900005022852156334661833724e-02) }},
{{ SC_(4.6939063072204589843750000000000000000000e+00), SC_(3.8729591369628906250000000000000000000000e+00), SC_(1.9667559862136840820312500000000000000000e-01), SC_(2.6989684404135318675961923064074363493190e-01) }},
{{ SC_(4.7092332839965820312500000000000000000000e+00), SC_(9.0018320083618164062500000000000000000000e+00), SC_(4.2024794220924377441406250000000000000000e-01), SC_(2.3801927469328323779655453106526445179275e+00) }},
{{ SC_(4.7092428207397460937500000000000000000000e+00), SC_(7.4850516319274902343750000000000000000000e+00), SC_(8.0975353717803955078125000000000000000000e-01), SC_(2.1912216523635245453571492730219677764521e-02) }},
{{ SC_(4.7108836174011230468750000000000000000000e+00), SC_(3.1823215484619140625000000000000000000000e+00), SC_(5.8530920743942260742187500000000000000000e-01), SC_(2.1864159183620791098504584894679707038808e+00) }},
{{ SC_(4.7135715484619140625000000000000000000000e+00), SC_(2.4758505821228027343750000000000000000000e+00), SC_(9.2750012874603271484375000000000000000000e-01), SC_(7.8707647017874981747303824012654489683918e-01) }},
{{ SC_(4.7328882217407226562500000000000000000000e+00), SC_(9.8745956420898437500000000000000000000000e+00), SC_(1.6269548237323760986328125000000000000000e-01), SC_(1.6298247040881630356670874604574080237199e+00) }},
{{ SC_(4.7348604202270507812500000000000000000000e+00), SC_(2.1562929153442382812500000000000000000000e+00), SC_(9.3399983644485473632812500000000000000000e-01), SC_(1.1252685697919106712251310864027635296018e+00) }},
{{ SC_(4.7992215156555175781250000000000000000000e+00), SC_(4.0151958465576171875000000000000000000000e+00), SC_(5.4726588726043701171875000000000000000000e-01), SC_(2.3132835903883093571064012742911787453421e+00) }},
{{ SC_(4.8202204704284667968750000000000000000000e+00), SC_(8.7757310867309570312500000000000000000000e+00), SC_(7.6377362012863159179687500000000000000000e-01), SC_(2.2789758407204548830305474609758586043603e-02) }},
{{ SC_(4.8537564277648925781250000000000000000000e+00), SC_(7.9810585975646972656250000000000000000000e+00), SC_(3.4413881599903106689453125000000000000000e-02), SC_(6.0659831353086590356525152410777690101931e-03) }},
{{ SC_(4.8679165840148925781250000000000000000000e+00), SC_(9.1056499481201171875000000000000000000000e+00), SC_(3.8239473104476928710937500000000000000000e-01), SC_(2.8476834099112002055404528978132961843288e+00) }},
{{ SC_(4.8860898017883300781250000000000000000000e+00), SC_(3.4432792663574218750000000000000000000000e+00), SC_(4.8542711138725280761718750000000000000000e-01), SC_(1.8540195525461429100840600665249671792245e+00) }},
{{ SC_(4.8889775276184082031250000000000000000000e+00), SC_(4.1329064369201660156250000000000000000000e+00), SC_(4.9063998460769653320312500000000000000000e-01), SC_(2.2155351190881966879234850181028263161129e+00) }},
{{ SC_(4.8925261497497558593750000000000000000000e+00), SC_(5.4405612945556640625000000000000000000000e+00), SC_(3.0641886591911315917968750000000000000000e-01), SC_(1.5666071157771335911473718207537174232999e+00) }},
{{ SC_(4.8968763351440429687500000000000000000000e+00), SC_(2.0419716835021972656250000000000000000000e+00), SC_(6.8139141798019409179687500000000000000000e-01), SC_(2.0877170577892445191152026123892426055838e+00) }},
{{ SC_(4.8976440429687500000000000000000000000000e+00), SC_(4.5798916816711425781250000000000000000000e+00), SC_(1.0995076596736907958984375000000000000000e-01), SC_(5.1177634648813790911978341516730892779070e-02) }},
{{ SC_(4.8990139961242675781250000000000000000000e+00), SC_(3.1015598773956298828125000000000000000000e+00), SC_(5.7856720685958862304687500000000000000000e-01), SC_(2.1401131401778768777365759152082508685522e+00) }},
{{ SC_(4.9086408615112304687500000000000000000000e+00), SC_(2.4784760475158691406250000000000000000000e+00), SC_(3.0368360877037048339843750000000000000000e-01), SC_(3.0456854921737064624583457870069395777684e-01) }},
{{ SC_(4.9417390823364257812500000000000000000000e+00), SC_(1.2538804113864898681640625000000000000000e-01), SC_(5.3084444999694824218750000000000000000000e-01), SC_(2.5693311168463182322197402873975481666082e-02) }},
{{ SC_(4.9836406707763671875000000000000000000000e+00), SC_(7.7391715049743652343750000000000000000000e+00), SC_(1.2598404288291931152343750000000000000000e-01), SC_(3.5797170075111586239806998370815480340607e-01) }},
{{ SC_(5.0002241134643554687500000000000000000000e+00), SC_(2.5394310951232910156250000000000000000000e+00), SC_(5.4726082086563110351562500000000000000000e-01), SC_(1.6309071426758177097998666492801959632281e+00) }},
{{ SC_(5.0047163963317871093750000000000000000000e+00), SC_(3.2253296375274658203125000000000000000000e+00), SC_(5.8530557155609130859375000000000000000000e-01), SC_(2.2090914091225322741009481012940623938464e+00) }},
{{ SC_(5.0595707893371582031250000000000000000000e+00), SC_(9.4007396697998046875000000000000000000000e+00), SC_(1.3556346297264099121093750000000000000000e-01), SC_(7.2765419782868855233491990220031897073703e-01) }},
{{ SC_(5.0785827636718750000000000000000000000000e+00), SC_(1.1319253444671630859375000000000000000000e+00), SC_(4.6944367885589599609375000000000000000000e-01), SC_(2.8602741174998473742970571331978021740794e-01) }},
{{ SC_(5.0850868225097656250000000000000000000000e+00), SC_(3.9358985424041748046875000000000000000000e+00), SC_(3.8867628574371337890625000000000000000000e-01), SC_(1.3846419506569038269864913261891706301364e+00) }},
{{ SC_(5.1077156066894531250000000000000000000000e+00), SC_(8.7018680572509765625000000000000000000000e+00), SC_(3.8979986310005187988281250000000000000000e-01), SC_(2.9158850928029802105042991141234373351854e+00) }},
{{ SC_(5.1324949264526367187500000000000000000000e+00), SC_(1.3800132274627685546875000000000000000000e+00), SC_(2.8169915080070495605468750000000000000000e-01), SC_(5.2992444376102073520178429882946299579869e-02) }},
{{ SC_(5.1805210113525390625000000000000000000000e+00), SC_(9.6983718872070312500000000000000000000000e+00), SC_(8.6870783567428588867187500000000000000000e-01), SC_(1.2817771772014877497258559130659208348541e-04) }},
{{ SC_(5.1859493255615234375000000000000000000000e+00), SC_(9.3605508804321289062500000000000000000000e+00), SC_(6.2347322702407836914062500000000000000000e-01), SC_(3.6633063514679081331341314290541890508694e-01) }},
{{ SC_(5.2113580703735351562500000000000000000000e+00), SC_(1.8990548849105834960937500000000000000000e+00), SC_(4.8981541395187377929687500000000000000000e-01), SC_(7.5143004765486630916921141680354495127271e-01) }},
{{ SC_(5.2164983749389648437500000000000000000000e+00), SC_(6.6711411476135253906250000000000000000000e+00), SC_(6.0202175378799438476562500000000000000000e-01), SC_(1.4659298038483985694520015839114201652711e+00) }},
{{ SC_(5.2687582969665527343750000000000000000000e+00), SC_(9.0893650054931640625000000000000000000000e+00), SC_(6.5551233291625976562500000000000000000000e-01), SC_(2.6668697483786968067743156196013523985919e-01) }},
{{ SC_(5.2714276313781738281250000000000000000000e+00), SC_(1.3080546855926513671875000000000000000000e+00), SC_(8.5446554422378540039062500000000000000000e-01), SC_(2.8711334753160708230184846324350431742994e+00) }},
{{ SC_(5.2853317260742187500000000000000000000000e+00), SC_(6.2036004066467285156250000000000000000000e+00), SC_(2.1038085222244262695312500000000000000000e-01), SC_(6.7100811341892853113311060918473982647521e-01) }},
{{ SC_(5.3079752922058105468750000000000000000000e+00), SC_(5.9282388687133789062500000000000000000000e+00), SC_(1.8695391714572906494140625000000000000000e-01), SC_(4.0692391188785218890580819606320073744442e-01) }},
{{ SC_(5.3086428642272949218750000000000000000000e+00), SC_(6.3111991882324218750000000000000000000000e+00), SC_(8.1764596700668334960937500000000000000000e-01), SC_(9.9631380773852430917331304739601023601428e-02) }},
{{ SC_(5.3133392333984375000000000000000000000000e+00), SC_(7.4860916137695312500000000000000000000000e+00), SC_(8.2347303628921508789062500000000000000000e-01), SC_(2.3001972243349309200878904469648744845953e-02) }},
{{ SC_(5.3282556533813476562500000000000000000000e+00), SC_(9.4892511367797851562500000000000000000000e+00), SC_(3.9984267950057983398437500000000000000000e-01), SC_(2.8650071944043876743132350598615719414876e+00) }},
{{ SC_(5.3834238052368164062500000000000000000000e+00), SC_(5.4659194946289062500000000000000000000000e+00), SC_(2.3485642671585083007812500000000000000000e-01), SC_(6.2543538514468499228857913537016192596078e-01) }},
{{ SC_(5.3912649154663085937500000000000000000000e+00), SC_(2.4272365570068359375000000000000000000000e+00), SC_(7.2586637735366821289062500000000000000000e-01), SC_(2.4325190534638146452082594030473330682562e+00) }},
{{ SC_(5.4659314155578613281250000000000000000000e+00), SC_(9.8075675964355468750000000000000000000000e+00), SC_(9.5974802970886230468750000000000000000000e-01), SC_(6.6613399296304970523182059788394477223106e-09) }},
{{ SC_(5.4680571556091308593750000000000000000000e+00), SC_(2.2655131816864013671875000000000000000000e+00), SC_(4.8930370807647705078125000000000000000000e-01), SC_(9.1265414347125957297138351421419445910814e-01) }},
{{ SC_(5.4688148498535156250000000000000000000000e+00), SC_(9.9288129806518554687500000000000000000000e+00), SC_(1.6618931666016578674316406250000000000000e-02), SC_(1.5865621501770517424938211578788351898310e-04) }},
{{ SC_(5.4700884819030761718750000000000000000000e+00), SC_(7.1847000122070312500000000000000000000000e+00), SC_(3.5470265150070190429687500000000000000000e-01), SC_(2.5606224802167470106320420501376009662060e+00) }},
{{ SC_(5.4721555709838867187500000000000000000000e+00), SC_(1.5805758237838745117187500000000000000000e+00), SC_(1.4022982120513916015625000000000000000000e-01), SC_(2.4959598229515210659096709058369272075692e-03) }},
{{ SC_(5.4787087440490722656250000000000000000000e+00), SC_(5.9836888313293457031250000000000000000000e+00), SC_(7.0735079050064086914062500000000000000000e-01), SC_(8.5566515477935553420730479973894905456614e-01) }},
{{ SC_(5.4972362518310546875000000000000000000000e+00), SC_(7.3279867172241210937500000000000000000000e+00), SC_(1.6907313466072082519531250000000000000000e-01), SC_(4.6137056183537080918200164585969931093618e-01) }},
{{ SC_(5.4986019134521484375000000000000000000000e+00), SC_(8.0939121544361114501953125000000000000000e-02), SC_(2.6599407196044921875000000000000000000000e-01), SC_(3.3056635316858261029252991535030108471575e-04) }},
{{ SC_(5.5015635490417480468750000000000000000000e+00), SC_(3.8861515522003173828125000000000000000000e+00), SC_(4.0504088997840881347656250000000000000000e-01), SC_(1.3037985480077119314984708556085075852393e+00) }},
{{ SC_(5.6119980812072753906250000000000000000000e+00), SC_(1.3156156539916992187500000000000000000000e+00), SC_(7.4471831321716308593750000000000000000000e-01), SC_(1.8681626519784686725451977379903877108602e+00) }},
{{ SC_(5.6782159805297851562500000000000000000000e+00), SC_(5.2737150192260742187500000000000000000000e+00), SC_(1.8359279632568359375000000000000000000000e-01), SC_(1.9173370056427691877391994212285506181422e-01) }},
{{ SC_(5.6882362365722656250000000000000000000000e+00), SC_(3.9490821361541748046875000000000000000000e+00), SC_(1.9484481215476989746093750000000000000000e-01), SC_(9.9504368461930583082456470274478242613015e-02) }},
{{ SC_(5.7520856857299804687500000000000000000000e+00), SC_(7.5750365257263183593750000000000000000000e+00), SC_(3.4028568863868713378906250000000000000000e-01), SC_(2.4824945996282764162762524331195851435981e+00) }},
{{ SC_(5.7620935440063476562500000000000000000000e+00), SC_(9.2487592697143554687500000000000000000000e+00), SC_(9.5929545164108276367187500000000000000000e-01), SC_(4.5168744809423525718853968477926953455644e-08) }},
{{ SC_(5.7672147750854492187500000000000000000000e+00), SC_(5.1451959609985351562500000000000000000000e+00), SC_(5.6160134077072143554687500000000000000000e-01), SC_(2.5489570376117999152662397422931366530920e+00) }},
{{ SC_(5.7852506637573242187500000000000000000000e+00), SC_(2.8162732124328613281250000000000000000000e+00), SC_(4.8684296011924743652343750000000000000000e-01), SC_(1.1607318482575314471971020689412318325116e+00) }},
{{ SC_(5.7970457077026367187500000000000000000000e+00), SC_(6.2738437652587890625000000000000000000000e+00), SC_(2.6387652754783630371093750000000000000000e-01), SC_(9.6331484689969337497572059137112939136660e-01) }},
{{ SC_(5.8298635482788085937500000000000000000000e+00), SC_(7.4733123779296875000000000000000000000000e+00), SC_(7.7891981601715087890625000000000000000000e-01), SC_(1.1057132942025461272326103662397389698901e-01) }},
{{ SC_(5.8406934738159179687500000000000000000000e+00), SC_(9.0710859298706054687500000000000000000000e+00), SC_(7.9430508613586425781250000000000000000000e-01), SC_(1.5031843731961056663852689272259244558454e-02) }},
{{ SC_(5.8526411056518554687500000000000000000000e+00), SC_(5.9450359344482421875000000000000000000000e+00), SC_(1.6763903200626373291015625000000000000000e-01), SC_(1.6595075137331712185626597119337707698324e-01) }},
{{ SC_(5.8526773452758789062500000000000000000000e+00), SC_(8.0817546844482421875000000000000000000000e+00), SC_(1.2999321520328521728515625000000000000000e-01), SC_(1.7660914116045616856552640644241985368954e-01) }},
{{ SC_(5.8704471588134765625000000000000000000000e+00), SC_(4.7663807868957519531250000000000000000000e+00), SC_(4.0879029035568237304687500000000000000000e-01), SC_(1.6818794370014441825078367905531560525569e+00) }},
{{ SC_(5.8950743675231933593750000000000000000000e+00), SC_(2.3476560115814208984375000000000000000000e+00), SC_(7.7393972873687744140625000000000000000000e-01), SC_(2.6303125032272567510131423567358514433060e+00) }},
{{ SC_(5.9435625076293945312500000000000000000000e+00), SC_(5.8676500320434570312500000000000000000000e+00), SC_(7.9812604188919067382812500000000000000000e-01), SC_(3.2773133023940313495308953628195869930366e-01) }},
{{ SC_(5.9489607810974121093750000000000000000000e+00), SC_(4.4955606460571289062500000000000000000000e+00), SC_(4.4763964414596557617187500000000000000000e-01), SC_(1.8444345321394328058444479246271000511724e+00) }},
{{ SC_(5.9852366447448730468750000000000000000000e+00), SC_(9.7475442886352539062500000000000000000000e+00), SC_(8.0915629863739013671875000000000000000000e-01), SC_(4.6347185956277952259671747246318459489915e-03) }},
{{ SC_(6.0198192596435546875000000000000000000000e+00), SC_(4.7195677757263183593750000000000000000000e+00), SC_(2.1385136246681213378906250000000000000000e-01), SC_(1.7745312992023805270233712939695822440073e-01) }},
{{ SC_(6.0217046737670898437500000000000000000000e+00), SC_(7.1188077926635742187500000000000000000000e+00), SC_(9.1057389974594116210937500000000000000000e-01), SC_(1.4622287823249978686937612896732104453573e-03) }},
{{ SC_(6.0284309387207031250000000000000000000000e+00), SC_(7.9736413955688476562500000000000000000000e+00), SC_(4.5059654116630554199218750000000000000000e-01), SC_(2.8984048191430019555845731248714638664787e+00) }},
{{ SC_(6.0730390548706054687500000000000000000000e+00), SC_(1.2427265644073486328125000000000000000000e+00), SC_(9.8111158609390258789062500000000000000000e-01), SC_(3.6765526524051669918316585460799262611713e+00) }},
{{ SC_(6.0738921165466308593750000000000000000000e+00), SC_(2.8369390964508056640625000000000000000000e+00), SC_(9.4008004665374755859375000000000000000000e-01), SC_(5.8746653986351073153964245359953062238461e-01) }},
{{ SC_(6.0986661911010742187500000000000000000000e+00), SC_(9.3425054550170898437500000000000000000000e+00), SC_(5.4990518093109130859375000000000000000000e-01), SC_(1.4442205183008606944122415996982642439971e+00) }},
{{ SC_(6.1095862388610839843750000000000000000000e+00), SC_(7.8842371702194213867187500000000000000000e-01), SC_(8.3084553480148315429687500000000000000000e-01), SC_(1.9723320385135461369180019600234819276087e+00) }},
{{ SC_(6.1346073150634765625000000000000000000000e+00), SC_(3.1223006248474121093750000000000000000000e+00), SC_(9.9646168947219848632812500000000000000000e-01), SC_(1.2734972076591828834258940207269541498479e-03) }},
{{ SC_(6.1604471206665039062500000000000000000000e+00), SC_(7.7889771461486816406250000000000000000000e+00), SC_(1.6241228580474853515625000000000000000000e-01), SC_(2.6483154163996034312895100437626603304978e-01) }},
{{ SC_(6.1709089279174804687500000000000000000000e+00), SC_(4.7276911735534667968750000000000000000000e+00), SC_(7.8024941682815551757812500000000000000000e-01), SC_(1.0799182848726139305501182535861129056711e+00) }},
{{ SC_(6.1766633987426757812500000000000000000000e+00), SC_(4.7252526283264160156250000000000000000000e+00), SC_(5.5020135641098022460937500000000000000000e-01), SC_(2.5612792429534902678634442862510540716563e+00) }},
{{ SC_(6.2205514907836914062500000000000000000000e+00), SC_(4.3866682052612304687500000000000000000000e+00), SC_(2.7699527144432067871093750000000000000000e-01), SC_(3.4017642118489488562449023282010192576082e-01) }},
{{ SC_(6.2247509956359863281250000000000000000000e+00), SC_(7.7968940734863281250000000000000000000000e+00), SC_(4.0877896547317504882812500000000000000000e-01), SC_(2.9105507978922518573537270311006297463319e+00) }},
{{ SC_(6.2406010627746582031250000000000000000000e+00), SC_(1.7015228271484375000000000000000000000000e+00), SC_(4.9091500043869018554687500000000000000000e-01), SC_(4.0609253420285007064185154037973949129231e-01) }},
{{ SC_(6.2561860084533691406250000000000000000000e+00), SC_(8.1576900482177734375000000000000000000000e+00), SC_(3.7856256961822509765625000000000000000000e-01), SC_(2.8572533804213620022152408440794624816879e+00) }},
{{ SC_(6.2797336578369140625000000000000000000000e+00), SC_(5.1502370834350585937500000000000000000000e+00), SC_(6.6015344858169555664062500000000000000000e-01), SC_(2.1683723736924417629753049000183848745007e+00) }},
{{ SC_(6.3235926628112792968750000000000000000000e+00), SC_(3.0816702842712402343750000000000000000000e+00), SC_(1.2000879272818565368652343750000000000000e-02), SC_(1.2378951638531811457500482536648097585174e-08) }},
{{ SC_(6.3578672409057617187500000000000000000000e+00), SC_(7.7779402732849121093750000000000000000000e+00), SC_(9.6864354610443115234375000000000000000000e-01), SC_(6.6587600748516130651393750428131570810031e-07) }},
{{ SC_(6.3770909309387207031250000000000000000000e+00), SC_(2.6817638874053955078125000000000000000000e+00), SC_(8.7019973993301391601562500000000000000000e-01), SC_(1.9850029813688920783482541850463556283984e+00) }},
{{ SC_(6.3853073120117187500000000000000000000000e+00), SC_(6.3336329460144042968750000000000000000000e+00), SC_(8.1430339813232421875000000000000000000000e-01), SC_(1.9585572869917018033790634395373041911471e-01) }},
{{ SC_(6.4431810379028320312500000000000000000000e+00), SC_(5.4380545616149902343750000000000000000000e+00), SC_(3.9365050196647644042968750000000000000000e-01), SC_(1.6462126809184323777375096109420506703252e+00) }},
{{ SC_(6.4444284439086914062500000000000000000000e+00), SC_(9.4971456527709960937500000000000000000000e+00), SC_(9.6489202976226806640625000000000000000000e-01), SC_(1.2961153826653854568711541226087141693534e-08) }},
{{ SC_(6.4476456642150878906250000000000000000000e+00), SC_(2.3367543220520019531250000000000000000000e+00), SC_(7.5776433944702148437500000000000000000000e-01), SC_(2.7017797733997384422367241882001903498283e+00) }},
{{ SC_(6.4631299972534179687500000000000000000000e+00), SC_(7.9397497177124023437500000000000000000000e+00), SC_(1.1129163205623626708984375000000000000000e-01), SC_(4.0461525108542052866676167044129641454983e-02) }},
{{ SC_(6.4761762619018554687500000000000000000000e+00), SC_(9.3452196121215820312500000000000000000000e+00), SC_(9.6496987342834472656250000000000000000000e-01), SC_(2.0064421125476633429301329906644715456529e-08) }},
{{ SC_(6.4774599075317382812500000000000000000000e+00), SC_(4.9332685470581054687500000000000000000000e+00), SC_(3.5282713174819946289062500000000000000000e-01), SC_(9.6099276888663037331396519539320695452295e-01) }},
{{ SC_(6.4899148941040039062500000000000000000000e+00), SC_(6.4318099021911621093750000000000000000000e+00), SC_(6.2742161750793457031250000000000000000000e-01), SC_(1.9790930040972487325994936586052741154739e+00) }},
{{ SC_(6.4911551475524902343750000000000000000000e+00), SC_(2.5829589366912841796875000000000000000000e+00), SC_(3.5101729631423950195312500000000000000000e-01), SC_(1.8994790215054069806661005490099977531405e-01) }},
{{ SC_(6.5375733375549316406250000000000000000000e+00), SC_(1.5979040414094924926757812500000000000000e-02), SC_(5.2988898754119873046875000000000000000000e-01), SC_(1.0355608006083586940736331637788856320837e-03) }},
{{ SC_(6.5407905578613281250000000000000000000000e+00), SC_(5.2984194755554199218750000000000000000000e+00), SC_(2.2111195325851440429687500000000000000000e-01), SC_(1.8305645769818897422312414192255384124340e-01) }},
{{ SC_(6.5444574356079101562500000000000000000000e+00), SC_(9.9450540542602539062500000000000000000000e+00), SC_(8.2085871696472167968750000000000000000000e-01), SC_(3.5236418396625544445811020953473601526191e-03) }},
{{ SC_(6.5509805679321289062500000000000000000000e+00), SC_(7.1070389747619628906250000000000000000000e+00), SC_(1.1963522434234619140625000000000000000000e-01), SC_(3.2290617806782607330167550112745075600245e-02) }},
{{ SC_(6.5547790527343750000000000000000000000000e+00), SC_(1.7386516332626342773437500000000000000000e+00), SC_(6.7688621580600738525390625000000000000000e-02), SC_(9.5260525498777078726677409370039455447323e-06) }},
{{ SC_(6.5574064254760742187500000000000000000000e+00), SC_(7.9792861938476562500000000000000000000000e+00), SC_(4.5155037194490432739257812500000000000000e-02), SC_(3.9884062353488379571563303467407478048266e-04) }},
{{ SC_(6.5685987472534179687500000000000000000000e+00), SC_(1.8081871271133422851562500000000000000000e+00), SC_(6.5581434965133666992187500000000000000000e-01), SC_(1.4411590823779134392614119955424465344396e+00) }},
{{ SC_(6.5960526466369628906250000000000000000000e+00), SC_(4.2221841812133789062500000000000000000000e+00), SC_(6.2251281738281250000000000000000000000000e-01), SC_(2.6476945337674246123016987190037757246032e+00) }},
{{ SC_(6.6194472312927246093750000000000000000000e+00), SC_(6.6230025291442871093750000000000000000000e+00), SC_(9.8746085166931152343750000000000000000000e-01), SC_(1.3025926144936264713897850762072908600103e-07) }},
{{ SC_(6.6200957298278808593750000000000000000000e+00), SC_(2.0595557689666748046875000000000000000000e+00), SC_(9.9011099338531494140625000000000000000000e-01), SC_(3.9552569099112613164882072501158966271160e-01) }},
{{ SC_(6.6633887290954589843750000000000000000000e+00), SC_(7.3779082298278808593750000000000000000000e+00), SC_(7.2052139043807983398437500000000000000000e-01), SC_(5.5831811846529146581846041804370119788062e-01) }},
{{ SC_(6.6652793884277343750000000000000000000000e+00), SC_(1.8547598123550415039062500000000000000000e+00), SC_(7.2698199748992919921875000000000000000000e-01), SC_(2.1557954421873452409532944844481542536434e+00) }},
{{ SC_(6.6783270835876464843750000000000000000000e+00), SC_(3.0382525920867919921875000000000000000000e+00), SC_(9.0019315481185913085937500000000000000000e-01), SC_(1.1735332967584067095701707592990479958643e+00) }},
{{ SC_(6.6917533874511718750000000000000000000000e+00), SC_(8.3144456148147583007812500000000000000000e-02), SC_(7.4996602535247802734375000000000000000000e-01), SC_(7.0005450176333404185240684916170996018622e-02) }},
{{ SC_(6.7180814743041992187500000000000000000000e+00), SC_(6.1374411582946777343750000000000000000000e+00), SC_(8.7844282388687133789062500000000000000000e-01), SC_(4.8527279951268432819521949137669190388031e-02) }},
{{ SC_(6.7533202171325683593750000000000000000000e+00), SC_(5.1010885238647460937500000000000000000000e+00), SC_(9.0737396478652954101562500000000000000000e-01), SC_(7.2635286742236777147774711709348076332811e-02) }},
{{ SC_(6.7612228393554687500000000000000000000000e+00), SC_(4.7471837997436523437500000000000000000000e+00), SC_(8.7676978111267089843750000000000000000000e-01), SC_(2.9171544070757590123633124097079845416447e-01) }},
{{ SC_(6.7873511314392089843750000000000000000000e+00), SC_(3.9873852729797363281250000000000000000000e+00), SC_(5.1311306655406951904296875000000000000000e-02), SC_(2.1916691899289316790012317754159879915118e-05) }},
{{ SC_(6.7901678085327148437500000000000000000000e+00), SC_(8.3242706954479217529296875000000000000000e-02), SC_(9.6769815683364868164062500000000000000000e-01), SC_(1.9484999346037105210373819819425443561692e+00) }},
{{ SC_(6.7913560867309570312500000000000000000000e+00), SC_(2.9905180931091308593750000000000000000000e+00), SC_(4.9249273538589477539062500000000000000000e-01), SC_(9.8506283326493054093370650457984413282564e-01) }},
{{ SC_(6.7970266342163085937500000000000000000000e+00), SC_(2.8184324502944946289062500000000000000000e-02), SC_(1.1908578127622604370117187500000000000000e-01), SC_(1.4983244272057164692133346442394307191163e-07) }},
{{ SC_(6.7972793579101562500000000000000000000000e+00), SC_(2.9196076393127441406250000000000000000000e+00), SC_(5.1082050800323486328125000000000000000000e-01), SC_(1.0819106276000948476408032411407740735086e+00) }},
{{ SC_(6.8197188377380371093750000000000000000000e+00), SC_(5.3472104072570800781250000000000000000000e+00), SC_(5.9286457300186157226562500000000000000000e-01), SC_(2.7296825189736936252701328566652703843692e+00) }},
{{ SC_(6.8336324691772460937500000000000000000000e+00), SC_(9.1371955871582031250000000000000000000000e+00), SC_(9.5949649810791015625000000000000000000000e-01), SC_(1.5467953911952450730816263181925488039079e-07) }},
{{ SC_(6.8677544593811035156250000000000000000000e+00), SC_(3.1250798702239990234375000000000000000000e+00), SC_(3.6325013637542724609375000000000000000000e-01), SC_(2.8361815276094428036341123387193675476604e-01) }},
{{ SC_(6.8921456336975097656250000000000000000000e+00), SC_(7.1610069274902343750000000000000000000000e+00), SC_(2.2182455658912658691406250000000000000000e-01), SC_(3.7221081535763236848487994115899834554780e-01) }},
{{ SC_(6.9482865333557128906250000000000000000000e+00), SC_(1.2518275976181030273437500000000000000000e+00), SC_(8.5607238113880157470703125000000000000000e-02), SC_(5.5812362919837245263124809674615896484874e-06) }},
{{ SC_(6.9514045715332031250000000000000000000000e+00), SC_(4.9061918258666992187500000000000000000000e+00), SC_(8.8600951433181762695312500000000000000000e-01), SC_(2.0722473621035103282615482421302133157383e-01) }},
{{ SC_(6.9594931602478027343750000000000000000000e+00), SC_(6.3450198173522949218750000000000000000000e+00), SC_(8.1159931421279907226562500000000000000000e-01), SC_(2.7362527603956142436309554330796078135252e-01) }},
{{ SC_(6.9810552597045898437500000000000000000000e+00), SC_(8.2285919189453125000000000000000000000000e+00), SC_(7.2668176889419555664062500000000000000000e-01), SC_(3.4450136151896596305836033987645988241585e-01) }},
{{ SC_(6.9874587059020996093750000000000000000000e+00), SC_(6.5445065498352050781250000000000000000000e-01), SC_(5.4410171508789062500000000000000000000000e-01), SC_(8.7522038942023094881477069838826419176656e-02) }},
{{ SC_(6.9907670021057128906250000000000000000000e+00), SC_(4.1266651153564453125000000000000000000000e+00), SC_(1.3615494966506958007812500000000000000000e-01), SC_(3.9389967597073144008360482581352709257986e-03) }},
{{ SC_(6.9988784790039062500000000000000000000000e+00), SC_(7.2180259227752685546875000000000000000000e-01), SC_(8.1189280748367309570312500000000000000000e-01), SC_(1.4477937661045304949477136900792676422802e+00) }},
{{ SC_(7.0109872817993164062500000000000000000000e+00), SC_(1.2064893245697021484375000000000000000000e+00), SC_(7.1849811077117919921875000000000000000000e-01), SC_(1.2276304948538378095108134545324222283998e+00) }},
{{ SC_(7.0604615211486816406250000000000000000000e+00), SC_(7.9727988243103027343750000000000000000000e+00), SC_(7.6059088110923767089843750000000000000000e-02), SC_(2.3631333905703112151200451115507666314304e-03) }},
{{ SC_(7.0928168296813964843750000000000000000000e+00), SC_(6.4978075027465820312500000000000000000000e+00), SC_(9.7700434923171997070312500000000000000000e-01), SC_(7.4936402496908910941914477548934478228573e-06) }},
{{ SC_(7.0936484336853027343750000000000000000000e+00), SC_(9.2087478637695312500000000000000000000000e+00), SC_(1.1255326867103576660156250000000000000000e-01), SC_(3.4426136543515118298582773676755401483480e-02) }},
{{ SC_(7.1121582984924316406250000000000000000000e+00), SC_(1.6755578517913818359375000000000000000000e+00), SC_(4.5097860693931579589843750000000000000000e-01), SC_(1.6379359149535483242377196466785547673840e-01) }},
{{ SC_(7.1269445419311523437500000000000000000000e+00), SC_(7.4690423011779785156250000000000000000000e+00), SC_(5.8442378044128417968750000000000000000000e-01), SC_(2.3459441787817076210815615929849406951439e+00) }},
{{ SC_(7.1503705978393554687500000000000000000000e+00), SC_(9.8699045181274414062500000000000000000000e-01), SC_(5.3397971391677856445312500000000000000000e-01), SC_(1.4723163157693309108385475256144686560220e-01) }},
{{ SC_(7.1835889816284179687500000000000000000000e+00), SC_(2.4557473659515380859375000000000000000000e+00), SC_(8.2192111015319824218750000000000000000000e-01), SC_(2.9812422426260720811454419033431674528381e+00) }},
{{ SC_(7.2122750282287597656250000000000000000000e+00), SC_(2.3076438903808593750000000000000000000000e+00), SC_(5.2741873264312744140625000000000000000000e-01), SC_(6.9740723881533068645986468836563268381243e-01) }},
{{ SC_(7.2175803184509277343750000000000000000000e+00), SC_(4.0750188827514648437500000000000000000000e+00), SC_(9.2939299345016479492187500000000000000000e-01), SC_(1.8515900116150382528648040573905264148553e-01) }},
{{ SC_(7.2243957519531250000000000000000000000000e+00), SC_(7.0472373962402343750000000000000000000000e+00), SC_(6.2039798498153686523437500000000000000000e-01), SC_(2.1418574167016941524085424138906485882914e+00) }},
{{ SC_(7.3024878501892089843750000000000000000000e+00), SC_(7.7290091514587402343750000000000000000000e+00), SC_(7.9361820220947265625000000000000000000000e-01), SC_(1.4421313698414734272317350780599014472922e-01) }},
{{ SC_(7.3033089637756347656250000000000000000000e+00), SC_(1.0073848962783813476562500000000000000000e+00), SC_(4.7669041156768798828125000000000000000000e-01), SC_(6.9453221023640431634073442672108674284330e-02) }},
{{ SC_(7.3172240257263183593750000000000000000000e+00), SC_(1.2984652519226074218750000000000000000000e+00), SC_(3.5172432661056518554687500000000000000000e-01), SC_(1.8086816980216503045431744583757542903850e-02) }},
{{ SC_(7.3785810470581054687500000000000000000000e+00), SC_(1.6669826507568359375000000000000000000000e+00), SC_(6.9910681247711181640625000000000000000000e-01), SC_(1.5237873299098442824540501337178321722711e+00) }},
{{ SC_(7.3842687606811523437500000000000000000000e+00), SC_(7.5592470169067382812500000000000000000000e+00), SC_(9.4479274749755859375000000000000000000000e-01), SC_(9.3068033608171866967469661178801108830766e-05) }},
{{ SC_(7.4313249588012695312500000000000000000000e+00), SC_(4.7475867271423339843750000000000000000000e+00), SC_(5.4044723510742187500000000000000000000000e-02), SC_(1.3140278373627786718979158714071370929573e-05) }},
{{ SC_(7.4407424926757812500000000000000000000000e+00), SC_(6.8980126380920410156250000000000000000000e+00), SC_(5.4705417156219482421875000000000000000000e-01), SC_(2.9258699660249706177215441961837899020760e+00) }},
{{ SC_(7.4469285011291503906250000000000000000000e+00), SC_(6.2343554496765136718750000000000000000000e+00), SC_(3.6092463135719299316406250000000000000000e-01), SC_(1.2084102643573794503827588902380724484585e+00) }},
{{ SC_(7.4815163612365722656250000000000000000000e+00), SC_(9.8837947845458984375000000000000000000000e+00), SC_(2.2349761426448822021484375000000000000000e-01), SC_(7.4225142393836858896257026765531868451763e-01) }},
{{ SC_(7.5126709938049316406250000000000000000000e+00), SC_(8.2124595642089843750000000000000000000000e+00), SC_(1.3308273255825042724609375000000000000000e-01), SC_(2.9252255474692475595931105127878392071682e-02) }},
{{ SC_(7.5372910499572753906250000000000000000000e+00), SC_(5.6155748367309570312500000000000000000000e+00), SC_(1.8165481090545654296875000000000000000000e-01), SC_(3.1627960514016464367307870409504767305979e-02) }},
{{ SC_(7.5468664169311523437500000000000000000000e+00), SC_(8.0753097534179687500000000000000000000000e+00), SC_(1.1328122019767761230468750000000000000000e-01), SC_(1.0633470986403946785197945897916900061698e-02) }},
{{ SC_(7.5720024108886718750000000000000000000000e+00), SC_(3.9232044219970703125000000000000000000000e+00), SC_(1.7394778132438659667968750000000000000000e-01), SC_(5.8367258089889934375070100984763483174677e-03) }},
{{ SC_(7.5774016380310058593750000000000000000000e+00), SC_(7.4064726829528808593750000000000000000000e+00), SC_(5.3247254341840744018554687500000000000000e-02), SC_(7.2560394508439247304937881660284511530568e-05) }},
{{ SC_(7.6550002098083496093750000000000000000000e+00), SC_(1.4891698956489562988281250000000000000000e-01), SC_(9.5502203702926635742187500000000000000000e-01), SC_(2.2093289150909276070126114565891184587988e+00) }},
{{ SC_(7.6551680564880371093750000000000000000000e+00), SC_(5.1216423511505126953125000000000000000000e-01), SC_(1.0082841664552688598632812500000000000000e-01), SC_(3.9672295968120204045349712556923445240524e-07) }},
{{ SC_(7.7015976905822753906250000000000000000000e+00), SC_(9.7094411849975585937500000000000000000000e+00), SC_(9.1720193624496459960937500000000000000000e-01), SC_(2.6724542948615901120672521279192373617455e-05) }},
{{ SC_(7.7028551101684570312500000000000000000000e+00), SC_(7.0825757980346679687500000000000000000000e+00), SC_(9.8838055133819580078125000000000000000000e-01), SC_(3.3081671362349803709700979045293568376925e-08) }},
{{ SC_(7.7491044998168945312500000000000000000000e+00), SC_(9.7700204849243164062500000000000000000000e+00), SC_(2.4360062181949615478515625000000000000000e-01), SC_(8.5653097797129819395392956607617403241911e-01) }},
{{ SC_(7.7571268081665039062500000000000000000000e+00), SC_(3.0361397266387939453125000000000000000000e+00), SC_(3.8162028789520263671875000000000000000000e-01), SC_(1.9513213918341487071326092199028412893137e-01) }},
{{ SC_(7.7880220413208007812500000000000000000000e+00), SC_(4.5893626213073730468750000000000000000000e+00), SC_(8.3123117685317993164062500000000000000000e-01), SC_(1.1156916834031814382952257097668095779123e+00) }},
{{ SC_(7.7905173301696777343750000000000000000000e+00), SC_(2.8658659458160400390625000000000000000000e+00), SC_(5.3287231922149658203125000000000000000000e-01), SC_(9.3097531363601035854041622421468106208634e-01) }},
{{ SC_(7.7916727066040039062500000000000000000000e+00), SC_(3.5634512901306152343750000000000000000000e+00), SC_(1.8846313655376434326171875000000000000000e-01), SC_(4.9721613688385367570547711593893409311297e-03) }},
{{ SC_(7.8022742271423339843750000000000000000000e+00), SC_(6.6928510665893554687500000000000000000000e+00), SC_(3.7867152690887451171875000000000000000000e-01), SC_(1.4836063802925511899870992824947898431149e+00) }},
{{ SC_(7.8025207519531250000000000000000000000000e+00), SC_(8.7736387252807617187500000000000000000000e+00), SC_(3.1661877036094665527343750000000000000000e-01), SC_(1.5739099224430582574395801532821036943949e+00) }},
{{ SC_(7.8051962852478027343750000000000000000000e+00), SC_(4.4895186424255371093750000000000000000000e+00), SC_(9.0580135583877563476562500000000000000000e-01), SC_(2.8222641557883416420829701773461978144534e-01) }},
{{ SC_(7.8473930358886718750000000000000000000000e+00), SC_(2.1510903835296630859375000000000000000000e+00), SC_(9.2338734865188598632812500000000000000000e-01), SC_(2.7328600158792779448755291248164354797753e+00) }},
{{ SC_(7.9220733642578125000000000000000000000000e+00), SC_(8.7843065261840820312500000000000000000000e+00), SC_(4.2149920016527175903320312500000000000000e-02), SC_(1.8148236957916674348506479659132069851128e-05) }},
{{ SC_(7.9428453445434570312500000000000000000000e+00), SC_(4.3611755371093750000000000000000000000000e+00), SC_(2.0814725756645202636718750000000000000000e-01), SC_(1.6475003028788981292328851809416316347815e-02) }},
{{ SC_(7.9483137130737304687500000000000000000000e+00), SC_(9.1711788177490234375000000000000000000000e+00), SC_(3.9238122105598449707031250000000000000000e-01), SC_(2.8352968846356923724915099008852945087097e+00) }},
{{ SC_(7.9519996643066406250000000000000000000000e+00), SC_(3.6441251635551452636718750000000000000000e-01), SC_(1.0674210637807846069335937500000000000000e-01), SC_(1.6227202447430148176306863957615145949380e-07) }},
{{ SC_(7.9618387222290039062500000000000000000000e+00), SC_(5.8284640312194824218750000000000000000000e+00), SC_(5.0554800033569335937500000000000000000000e-01), SC_(2.4908935141716276335609938464283363323736e+00) }},
{{ SC_(8.0006847381591796875000000000000000000000e+00), SC_(6.6011948585510253906250000000000000000000e+00), SC_(2.5516960024833679199218750000000000000000e-01), SC_(2.3429162629947622117252259900544528870439e-01) }},
{{ SC_(8.0028047561645507812500000000000000000000e+00), SC_(2.9702944755554199218750000000000000000000e+00), SC_(3.4542635083198547363281250000000000000000e-02), SC_(1.8729407999983965238454959097237769324057e-08) }},
{{ SC_(8.0033054351806640625000000000000000000000e+00), SC_(4.7273211479187011718750000000000000000000e+00), SC_(6.3239604234695434570312500000000000000000e-01), SC_(2.8944825625774429591513095929955665826678e+00) }},
{{ SC_(8.0101461410522460937500000000000000000000e+00), SC_(7.6293144226074218750000000000000000000000e+00), SC_(4.7306776046752929687500000000000000000000e-01), SC_(2.9678504492751637061519925263515636887965e+00) }},
{{ SC_(8.0336437225341796875000000000000000000000e+00), SC_(3.9698181152343750000000000000000000000000e+00), SC_(6.5200346708297729492187500000000000000000e-01), SC_(2.7748044082783035549558195124058310413180e+00) }},
{{ SC_(8.0548944473266601562500000000000000000000e+00), SC_(4.8840188980102539062500000000000000000000e+00), SC_(5.5831295251846313476562500000000000000000e-01), SC_(2.4756230128387635650782538726463141341233e+00) }},
{{ SC_(8.1158046722412109375000000000000000000000e+00), SC_(1.9987287521362304687500000000000000000000e+00), SC_(3.9879864454269409179687500000000000000000e-01), SC_(6.4040093017433168290764432707026518877160e-02) }},
{{ SC_(8.1428480148315429687500000000000000000000e+00), SC_(2.9983172416687011718750000000000000000000e+00), SC_(1.4937907457351684570312500000000000000000e-01), SC_(3.4482681911642454187840103993353320391656e-04) }},
{{ SC_(8.1472368240356445312500000000000000000000e+00), SC_(1.3547700643539428710937500000000000000000e+00), SC_(2.9181505087763071060180664062500000000000e-03), SC_(1.5098720821885146270745370855660519881341e-17) }},
{{ SC_(8.1730327606201171875000000000000000000000e+00), SC_(3.6318645477294921875000000000000000000000e+00), SC_(2.4421386420726776123046875000000000000000e-01), SC_(1.7481728132230106226291957601030406835166e-02) }},
{{ SC_(8.1754703521728515625000000000000000000000e+00), SC_(2.3188862800598144531250000000000000000000e+00), SC_(6.1608308553695678710937500000000000000000e-01), SC_(1.1536324518746882048542984525878385316260e+00) }},
{{ SC_(8.1762771606445312500000000000000000000000e+00), SC_(3.6086070537567138671875000000000000000000e+00), SC_(3.9228779077529907226562500000000000000000e-01), SC_(2.8913663842111618201321542744564048455050e-01) }},
{{ SC_(8.1776065826416015625000000000000000000000e+00), SC_(3.2673664093017578125000000000000000000000e+00), SC_(7.9738438129425048828125000000000000000000e-01), SC_(2.9345362139203277921086331056266232089449e+00) }},
{{ SC_(8.1814861297607421875000000000000000000000e+00), SC_(6.5524458885192871093750000000000000000000e-01), SC_(6.0427105426788330078125000000000000000000e-01), SC_(1.0510153395264651387245518031837225293985e-01) }},
{{ SC_(8.1998119354248046875000000000000000000000e+00), SC_(7.2445387840270996093750000000000000000000e+00), SC_(8.2126384973526000976562500000000000000000e-01), SC_(1.7276219797935272792577705191845749565703e-01) }},
{{ SC_(8.2119407653808593750000000000000000000000e+00), SC_(3.2251076698303222656250000000000000000000e+00), SC_(3.4439349174499511718750000000000000000000e-01), SC_(9.5192452048285745767707774725086110251230e-02) }},
{{ SC_(8.2345790863037109375000000000000000000000e+00), SC_(8.2190332412719726562500000000000000000000e+00), SC_(8.4527403116226196289062500000000000000000e-02), SC_(6.5288798463402467226924170976231454477041e-04) }},
{{ SC_(8.2437629699707031250000000000000000000000e+00), SC_(5.3209753036499023437500000000000000000000e+00), SC_(7.8193098306655883789062500000000000000000e-01), SC_(1.4488667124167548220653714836664931948173e+00) }},
{{ SC_(8.2531375885009765625000000000000000000000e+00), SC_(5.0591936111450195312500000000000000000000e+00), SC_(6.4399653673171997070312500000000000000000e-01), SC_(2.9701053416530557498775680891352965165154e+00) }},
{{ SC_(8.2581691741943359375000000000000000000000e+00), SC_(4.6247420310974121093750000000000000000000e+00), SC_(2.3056511580944061279296875000000000000000e-01), SC_(2.7702982844283517444013148574671034911324e-02) }},
{{ SC_(8.3082866668701171875000000000000000000000e+00), SC_(7.9359755516052246093750000000000000000000e+00), SC_(1.6573216021060943603515625000000000000000e-01), SC_(3.4353160252649308720788230746243079622131e-02) }},
{{ SC_(8.3137979507446289062500000000000000000000e+00), SC_(1.8908418416976928710937500000000000000000e+00), SC_(6.4915060997009277343750000000000000000000e-01), SC_(1.0508604606562352063373081912715042193101e+00) }},
{{ SC_(8.3291683197021484375000000000000000000000e+00), SC_(6.9262528419494628906250000000000000000000e-01), SC_(9.9406909942626953125000000000000000000000e-01), SC_(1.5151123663060896877454436010322739507934e+01) }},
{{ SC_(8.4071722030639648437500000000000000000000e+00), SC_(9.8852157592773437500000000000000000000000e+00), SC_(1.4791423082351684570312500000000000000000e-01), SC_(4.3516547659678205774961665470231491372477e-02) }},
{{ SC_(8.4192914962768554687500000000000000000000e+00), SC_(1.1192586272954940795898437500000000000000e-01), SC_(9.9353539943695068359375000000000000000000e-01), SC_(1.2508467836573196048183232720525592209493e+01) }},
{{ SC_(8.4430875778198242187500000000000000000000e+00), SC_(8.8599815368652343750000000000000000000000e+00), SC_(4.2214545607566833496093750000000000000000e-01), SC_(2.8792584741713609340087190675323632835114e+00) }},
{{ SC_(8.4439220428466796875000000000000000000000e+00), SC_(7.9010176658630371093750000000000000000000e+00), SC_(9.0272581577301025390625000000000000000000e-01), SC_(3.1724825147289066134762247951591202596765e-03) }},
{{ SC_(8.4912929534912109375000000000000000000000e+00), SC_(2.1192431449890136718750000000000000000000e+00), SC_(4.8039492219686508178710937500000000000000e-02), SC_(1.2633543571694602472620118956589604040027e-08) }},
{{ SC_(8.5303106307983398437500000000000000000000e+00), SC_(5.3393311500549316406250000000000000000000e+00), SC_(2.7609747648239135742187500000000000000000e-01), SC_(1.1146958037654895514222556079052669124934e-01) }},
{{ SC_(8.5552282333374023437500000000000000000000e+00), SC_(2.5282335281372070312500000000000000000000e+00), SC_(7.5752788782119750976562500000000000000000e-01), SC_(2.9113095100281916153410951754726269906004e+00) }},
{{ SC_(8.5944232940673828125000000000000000000000e+00), SC_(6.1091623306274414062500000000000000000000e+00), SC_(5.5292588472366333007812500000000000000000e-01), SC_(2.9082431280079248878632389252761923111209e+00) }},
{{ SC_(8.6869468688964843750000000000000000000000e+00), SC_(6.7951974868774414062500000000000000000000e+00), SC_(2.4792282283306121826171875000000000000000e-01), SC_(1.3234565244862970207376433685414285381688e-01) }},
{{ SC_(8.6929225921630859375000000000000000000000e+00), SC_(7.7557027339935302734375000000000000000000e-01), SC_(2.6304498314857482910156250000000000000000e-01), SC_(1.6428379972439576631802502223237510005838e-04) }},
{{ SC_(8.7537155151367187500000000000000000000000e+00), SC_(1.2038167715072631835937500000000000000000e+00), SC_(8.6269187927246093750000000000000000000000e-01), SC_(3.1959333062310075507244584328572192221294e+00) }},
{{ SC_(8.7594280242919921875000000000000000000000e+00), SC_(1.6520583629608154296875000000000000000000e-01), SC_(4.0426808595657348632812500000000000000000e-01), SC_(3.4546560257744948096832357100256950467987e-04) }},
{{ SC_(8.7965373992919921875000000000000000000000e+00), SC_(3.2669925689697265625000000000000000000000e+00), SC_(7.9730015993118286132812500000000000000000e-01), SC_(3.1541735072646344860665440510884590719576e+00) }},
{{ SC_(8.8186655044555664062500000000000000000000e+00), SC_(8.9952909946441650390625000000000000000000e-01), SC_(7.4817681312561035156250000000000000000000e-01), SC_(7.8396820753809210409116312507034976002998e-01) }},
{{ SC_(8.8516798019409179687500000000000000000000e+00), SC_(9.5922155380249023437500000000000000000000e+00), SC_(5.0371235609054565429687500000000000000000e-01), SC_(3.3080848159251191130987334090289030387749e+00) }},
{{ SC_(8.8651189804077148437500000000000000000000e+00), SC_(5.0236234664916992187500000000000000000000e+00), SC_(5.7379728555679321289062500000000000000000e-01), SC_(2.5395100611539593719779296225157753164953e+00) }},
{{ SC_(8.9090328216552734375000000000000000000000e+00), SC_(4.2316513061523437500000000000000000000000e+00), SC_(1.3808752596378326416015625000000000000000e-01), SC_(2.4944957422844736892976035621433834940899e-04) }},
{{ SC_(8.9092245101928710937500000000000000000000e+00), SC_(3.5534870624542236328125000000000000000000e+00), SC_(5.4018402099609375000000000000000000000000e-01), SC_(1.1227485998465319859664903039958166635896e+00) }},
{{ SC_(9.0005388259887695312500000000000000000000e+00), SC_(3.4383952617645263671875000000000000000000e+00), SC_(3.1117120385169982910156250000000000000000e-01), SC_(3.3189335424658363554135510919317997389343e-02) }},
{{ SC_(9.0271606445312500000000000000000000000000e+00), SC_(3.0182731151580810546875000000000000000000e+00), SC_(3.0189713835716247558593750000000000000000e-01), SC_(1.6594044604087693360739275577175963723034e-02) }},
{{ SC_(9.0372056961059570312500000000000000000000e+00), SC_(3.8475520610809326171875000000000000000000e+00), SC_(5.3838860988616943359375000000000000000000e-01), SC_(1.2598865263042324987582684232400287311628e+00) }},
{{ SC_(9.0472221374511718750000000000000000000000e+00), SC_(2.6447653770446777343750000000000000000000e+00), SC_(5.4976862668991088867187500000000000000000e-01), SC_(6.2497344835184271424150546783654879970105e-01) }},
{{ SC_(9.0488090515136718750000000000000000000000e+00), SC_(7.2665443420410156250000000000000000000000e+00), SC_(4.3880048394203186035156250000000000000000e-01), SC_(2.0623963092395779717241862945847351110912e+00) }},
{{ SC_(9.0579195022583007812500000000000000000000e+00), SC_(8.3500852584838867187500000000000000000000e+00), SC_(4.7337622381746768951416015625000000000000e-03), SC_(2.5094704846685393052685144090898814494690e-14) }},
{{ SC_(9.0630817413330078125000000000000000000000e+00), SC_(8.4808883666992187500000000000000000000000e+00), SC_(7.9522043466567993164062500000000000000000e-01), SC_(1.7298579713104115618015632399032278008368e-01) }},
{{ SC_(9.1064758300781250000000000000000000000000e+00), SC_(1.3299603462219238281250000000000000000000e+00), SC_(2.5813889503479003906250000000000000000000e-01), SC_(3.3452720400472671045699597178468731304705e-04) }},
{{ SC_(9.1328678131103515625000000000000000000000e+00), SC_(1.8066270649433135986328125000000000000000e-01), SC_(5.0482052564620971679687500000000000000000e-01), SC_(1.9821946324192786155255130505424525190900e-03) }},
{{ SC_(9.1333732604980468750000000000000000000000e+00), SC_(5.5826878547668457031250000000000000000000e+00), SC_(2.2905406355857849121093750000000000000000e-01), SC_(2.4058694064973102871475881444697087609623e-02) }},
{{ SC_(9.1337585449218750000000000000000000000000e+00), SC_(2.2103404998779296875000000000000000000000e+00), SC_(8.1931026652455329895019531250000000000000e-03), SC_(1.4551633278326225811958879135154366427468e-15) }},
{{ SC_(9.1573553085327148437500000000000000000000e+00), SC_(6.3976335525512695312500000000000000000000e+00), SC_(4.0567062795162200927734375000000000000000e-02), SC_(1.0151385469924381598168318575028076468581e-07) }},
{{ SC_(9.1599121093750000000000000000000000000000e+00), SC_(6.5521326065063476562500000000000000000000e+00), SC_(9.1258627176284790039062500000000000000000e-01), SC_(2.0868343845134583150673837150569774131069e-02) }},
{{ SC_(9.1719369888305664062500000000000000000000e+00), SC_(6.9523286819458007812500000000000000000000e+00), SC_(1.7079097032546997070312500000000000000000e-01), SC_(8.3850440171116299088841815602088665458922e-03) }},
{{ SC_(9.1742429733276367187500000000000000000000e+00), SC_(8.0176296234130859375000000000000000000000e+00), SC_(9.5022708177566528320312500000000000000000e-01), SC_(5.5373530529064689865734459307771790082069e-05) }},
{{ SC_(9.2033205032348632812500000000000000000000e+00), SC_(3.9246907234191894531250000000000000000000e+00), SC_(6.9485914707183837890625000000000000000000e-01), SC_(3.0436567440394611607503996270159259892907e+00) }},
{{ SC_(9.2337970733642578125000000000000000000000e+00), SC_(6.4455056190490722656250000000000000000000e+00), SC_(4.3591499328613281250000000000000000000000e-01), SC_(1.4855635669459493923304348609554424622275e+00) }},
{{ SC_(9.2885417938232421875000000000000000000000e+00), SC_(2.4413828849792480468750000000000000000000e+00), SC_(4.7481119632720947265625000000000000000000e-01), SC_(1.7773000027397512881111292624484365754970e-01) }},
{{ SC_(9.2926368713378906250000000000000000000000e+00), SC_(2.1723785400390625000000000000000000000000e+00), SC_(1.5452297031879425048828125000000000000000e-01), SC_(2.0552058473221920903394269605439033261804e-05) }},
{{ SC_(9.2938594818115234375000000000000000000000e+00), SC_(4.5849690437316894531250000000000000000000e+00), SC_(3.8050779700279235839843750000000000000000e-01), SC_(2.7127888360627749078195290189437501370105e-01) }},
{{ SC_(9.3399324417114257812500000000000000000000e+00), SC_(6.8135957717895507812500000000000000000000e+00), SC_(4.9749460071325302124023437500000000000000e-02), SC_(4.6849511716122559675653085228948657493975e-07) }},
{{ SC_(9.3401069641113281250000000000000000000000e+00), SC_(9.6496639251708984375000000000000000000000e+00), SC_(1.8903611600399017333984375000000000000000e-01), SC_(6.7291466951622526173527703608079781194027e-02) }},
{{ SC_(9.3900156021118164062500000000000000000000e+00), SC_(2.4007594585418701171875000000000000000000e+00), SC_(4.0397173166275024414062500000000000000000e-01), SC_(4.9680916547647338442650882764862964934337e-02) }},
{{ SC_(9.4205055236816406250000000000000000000000e+00), SC_(9.5494337081909179687500000000000000000000e+00), SC_(3.3718892931938171386718750000000000000000e-01), SC_(1.3834083927715818677001676997362715740191e+00) }},
{{ SC_(9.4273700714111328125000000000000000000000e+00), SC_(1.3122184276580810546875000000000000000000e+00), SC_(7.0939391851425170898437500000000000000000e-01), SC_(8.1551974376522731000813468441628284721772e-01) }},
{{ SC_(9.4362268447875976562500000000000000000000e+00), SC_(7.5628166198730468750000000000000000000000e+00), SC_(8.6930525302886962890625000000000000000000e-01), SC_(4.6265468088423006099488502520228209035143e-02) }},
{{ SC_(9.4478721618652343750000000000000000000000e+00), SC_(4.7944283485412597656250000000000000000000e-01), SC_(3.0198290944099426269531250000000000000000e-01), SC_(7.6479439825769138426911040873632725978082e-05) }},
{{ SC_(9.4517412185668945312500000000000000000000e+00), SC_(2.5958877801895141601562500000000000000000e-01), SC_(9.6887087821960449218750000000000000000000e-01), SC_(5.0847281125871500991688048861635083364244e+00) }},
{{ SC_(9.5022211074829101562500000000000000000000e+00), SC_(4.9058904647827148437500000000000000000000e+00), SC_(9.5445640385150909423828125000000000000000e-02), SC_(1.0374272431581276080100760637807288700154e-05) }},
{{ SC_(9.5163049697875976562500000000000000000000e+00), SC_(8.7805051803588867187500000000000000000000e+00), SC_(6.8924558162689208984375000000000000000000e-01), SC_(1.2604566086181621652965747663317275340910e+00) }},
{{ SC_(9.5613460540771484375000000000000000000000e+00), SC_(6.5196866989135742187500000000000000000000e+00), SC_(3.3778563141822814941406250000000000000000e-01), SC_(3.7995920231441071362700454690300661002977e-01) }},
{{ SC_(9.5716695785522460937500000000000000000000e+00), SC_(1.0986175537109375000000000000000000000000e+00), SC_(3.3365238457918167114257812500000000000000e-02), SC_(2.7685637821008035782657892613376030268045e-12) }},
{{ SC_(9.5750684738159179687500000000000000000000e+00), SC_(9.9646129608154296875000000000000000000000e+00), SC_(1.7872119322419166564941406250000000000000e-02), SC_(5.7825399640144394938278555373571194147105e-10) }},
{{ SC_(9.5769395828247070312500000000000000000000e+00), SC_(7.2490601539611816406250000000000000000000e+00), SC_(8.7244158983230590820312500000000000000000e-01), SC_(6.3132069457413796399347130985149574904784e-02) }},
{{ SC_(9.5929136276245117187500000000000000000000e+00), SC_(5.8095669746398925781250000000000000000000e+00), SC_(1.3871058821678161621093750000000000000000e-01), SC_(4.1837426164208682010131830405158183493650e-04) }},
{{ SC_(9.5949239730834960937500000000000000000000e+00), SC_(5.0366272926330566406250000000000000000000e+00), SC_(4.3119497597217559814453125000000000000000e-02), SC_(1.3511735192095064014668480492285174867586e-08) }},
{{ SC_(9.5974397659301757812500000000000000000000e+00), SC_(5.7375464439392089843750000000000000000000e+00), SC_(1.2707412242889404296875000000000000000000e-01), SC_(1.9561166603390849965599234448742292199839e-04) }},
{{ SC_(9.6189813613891601562500000000000000000000e+00), SC_(9.7992563247680664062500000000000000000000e+00), SC_(2.4015194177627563476562500000000000000000e-01), SC_(2.4796522067025285296887850607532406212377e-01) }},
{{ SC_(9.6308851242065429687500000000000000000000e+00), SC_(6.0592818260192871093750000000000000000000e+00), SC_(4.8866885900497436523437500000000000000000e-01), SC_(1.8449975090544742197382234553682412245838e+00) }},
{{ SC_(9.6488857269287109375000000000000000000000e+00), SC_(9.6769495010375976562500000000000000000000e+00), SC_(1.8548998981714248657226562500000000000000e-02), SC_(5.0971399864718535203455092408233550506808e-10) }},
{{ SC_(9.6864929199218750000000000000000000000000e+00), SC_(3.3233909606933593750000000000000000000000e+00), SC_(8.2262271642684936523437500000000000000000e-01), SC_(3.2717274941761246172959584113055180298399e+00) }},
{{ SC_(9.7059278488159179687500000000000000000000e+00), SC_(9.8110971450805664062500000000000000000000e+00), SC_(3.1929660588502883911132812500000000000000e-02), SC_(4.6564465336704686912032414816072918675231e-08) }},
{{ SC_(9.7297458648681640625000000000000000000000e+00), SC_(1.4221720695495605468750000000000000000000e+00), SC_(6.2565600872039794921875000000000000000000e-01), SC_(3.2552079343907254581097239154724268307332e-01) }},
{{ SC_(9.7868061065673828125000000000000000000000e+00), SC_(2.3240036964416503906250000000000000000000e+00), SC_(5.8099859952926635742187500000000000000000e-01), SC_(5.2600967595621154401661464437893470406325e-01) }},
{{ SC_(9.7974834442138671875000000000000000000000e+00), SC_(3.5463814735412597656250000000000000000000e+00), SC_(4.3892610073089599609375000000000000000000e-01), SC_(2.3326106479092034840535988424125063388238e-01) }},
{{ SC_(9.8163795471191406250000000000000000000000e+00), SC_(4.9786939620971679687500000000000000000000e+00), SC_(7.5581431388854980468750000000000000000000e-01), SC_(2.8037984816003826783358231801486388053656e+00) }},
{{ SC_(9.8266344070434570312500000000000000000000e+00), SC_(8.9943599700927734375000000000000000000000e+00), SC_(7.9222810268402099609375000000000000000000e-01), SC_(1.7394663743923000662298636807538570232944e-01) }},
{{ SC_(9.8305253982543945312500000000000000000000e+00), SC_(5.5438032150268554687500000000000000000000e+00), SC_(7.1124464273452758789062500000000000000000e-01), SC_(2.9852490321687385616164951375819039707105e+00) }},
{{ SC_(9.8406372070312500000000000000000000000000e+00), SC_(2.9338824748992919921875000000000000000000e+00), SC_(6.7955178022384643554687500000000000000000e-01), SC_(2.0672314946608625015982141272883995264634e+00) }},
{{ SC_(9.8798198699951171875000000000000000000000e+00), SC_(7.6924314498901367187500000000000000000000e+00), SC_(4.9859434366226196289062500000000000000000e-01), SC_(2.8358346864716274308729254613382323925378e+00) }},
{{ SC_(9.9613475799560546875000000000000000000000e+00), SC_(4.4758439064025878906250000000000000000000e+00), SC_(2.3735985159873962402343750000000000000000e-01), SC_(5.1546813913797326938584231223559193805323e-03) }},
{{ SC_(9.9908046722412109375000000000000000000000e+00), SC_(6.7421293258666992187500000000000000000000e+00), SC_(7.3282539844512939453125000000000000000000e-01), SC_(1.9525893224770479980770708371063254836270e+00) }}
}};

