/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2005 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.freedesktop.cairo;

import org.gnu.glib.Enum;

/**
 * Specifies the type of hinting to do on font outlines. Hinting is the process
 * of fitting outlines to the pixel grid in order to improve the appearance of
 * the result. Since hinting outlines involves distorting them, it also reduces
 * the faithfulness to the original outline shapes. Not all of the outline
 * hinting styles are supported by all font backends.
 *
 * @deprecated This class is part of the java-gnome 2.x family of libraries,
 *             which, due to their inefficiency and complexity, are no longer
 *             being maintained and have been abandoned by the java-gnome
 *             project. This class may exist in java-gnome 4.0; look out for
 *             <code>org.freedesktop.cairo.HintStyle</code>.
 *             As this package was never correctly implemented in java-gnome 2.x,
 *             any new code written will likely have a considerably different
 *             public API.
 */
public class HintStyle extends Enum {

    static final private int _DEFAULT = 0;

    /**
     * Use the default hint style for for font backend and target device
     * @deprecated Superceeded by java-gnome 4.0; this method or constant
     *             will no doubt exist conceptually, but it may have a different
     *             name or signature in order that the presented API is an
     *             algorithmic mapping of the underlying native libraries.
     */
    static final public HintStyle DEFAULT = new HintStyle(_DEFAULT);

    static final private int _NONE = 1;

    /**
     * Do not hint outlines
     * @deprecated Superceeded by java-gnome 4.0; this method or constant
     *             will no doubt exist conceptually, but it may have a different
     *             name or signature in order that the presented API is an
     *             algorithmic mapping of the underlying native libraries.
     */
    static final public HintStyle NONE = new HintStyle(_NONE);

    static final private int _SLIGHT = 2;

    /**
     * Hint outlines slightly to improve contrast while retaining good fidelity
     * to the original shapes.
     * @deprecated Superceeded by java-gnome 4.0; this method or constant
     *             will no doubt exist conceptually, but it may have a different
     *             name or signature in order that the presented API is an
     *             algorithmic mapping of the underlying native libraries.
     */
    static final public HintStyle SLIGHT = new HintStyle(_SLIGHT);

    static final private int _MEDIUM = 3;

    /**
     * Hint outlines with medium strength giving a compromise between fidelity
     * to the original shapes and contrast
     * @deprecated Superceeded by java-gnome 4.0; this method or constant
     *             will no doubt exist conceptually, but it may have a different
     *             name or signature in order that the presented API is an
     *             algorithmic mapping of the underlying native libraries.
     */
    static final public HintStyle MEDIUM = new HintStyle(_MEDIUM);

    static final private int _FULL = 4;

    /**
     * Hint outlines to maximize contrast
     * @deprecated Superceeded by java-gnome 4.0; this method or constant
     *             will no doubt exist conceptually, but it may have a different
     *             name or signature in order that the presented API is an
     *             algorithmic mapping of the underlying native libraries.
     */
    static final public HintStyle FULL = new HintStyle(_FULL);

    static final private HintStyle[] theInterned = new HintStyle[] { DEFAULT,
            NONE, SLIGHT, MEDIUM, FULL };

    static private java.util.Hashtable theInternedExtras;

    static final private HintStyle theSacrificialOne = new HintStyle(0);

    static public HintStyle intern(int value) {
        if (value < theInterned.length) {
            return theInterned[value];
        }
        theSacrificialOne.value_ = value;
        if (theInternedExtras == null) {
            theInternedExtras = new java.util.Hashtable();
        }
        HintStyle already = (HintStyle) theInternedExtras
                .get(theSacrificialOne);
        if (already == null) {
            already = new HintStyle(value);
            theInternedExtras.put(already, already);
        }
        return already;
    }

    private HintStyle(int value) {
        value_ = value;
    }

    public boolean test(HintStyle other) {
        return (value_ & other.value_) == other.value_;
    }

}
