require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_SYS_SYSTM_H_)) {
    eval 'sub _SYS_SYSTM_H_ () {1;}' unless defined(&_SYS_SYSTM_H_);
    require 'machine/atomic.ph';
    require 'machine/cpufunc.ph';
    require 'sys/callout.ph';
    require 'sys/cdefs.ph';
    require 'sys/queue.ph';
    require 'sys/stdint.ph';
    eval("sub VM_GUEST_NO () { 0; }") unless defined(&VM_GUEST_NO);
    eval("sub VM_GUEST_VM () { 1; }") unless defined(&VM_GUEST_VM);
    eval("sub VM_GUEST_XEN () { 2; }") unless defined(&VM_GUEST_XEN);
    eval("sub VM_GUEST_HV () { 3; }") unless defined(&VM_GUEST_HV);
    eval("sub VM_GUEST_VMWARE () { 4; }") unless defined(&VM_GUEST_VMWARE);
    eval("sub VM_GUEST_KVM () { 5; }") unless defined(&VM_GUEST_KVM);
    eval("sub VM_LAST () { 6; }") unless defined(&VM_LAST);
    if(defined(&WITNESS) || defined(&INVARIANT_SUPPORT)) {
    }
    if(defined(&INVARIANTS)) {
	eval 'sub KASSERT {
	    my($exp,$msg) = @_;
    	    eval q( &do {  &if ( &__predict_false(!($exp)))  &kassert_panic $msg; }  &while (0));
	}' unless defined(&KASSERT);
	eval 'sub VNASSERT {
	    my($exp, $vp, $msg) = @_;
    	    eval q( &do {  &if ( &__predict_false(!($exp))) {  &vn_printf($vp, \\"VNASSERT failed\\\\n\\");  &kassert_panic $msg; } }  &while (0));
	}' unless defined(&VNASSERT);
    } else {
	eval 'sub KASSERT {
	    my($exp,$msg) = @_;
    	    eval q( &do { }  &while (0));
	}' unless defined(&KASSERT);
	eval 'sub VNASSERT {
	    my($exp, $vp, $msg) = @_;
    	    eval q( &do { }  &while (0));
	}' unless defined(&VNASSERT);
    }
    unless(defined(&CTASSERT)) {
	eval 'sub CTASSERT {
	    my($x) = @_;
    	    eval q( &_Static_assert($x, \\"compile-time assertion failed\\"));
	}' unless defined(&CTASSERT);
    }
    eval 'sub ASSERT_ATOMIC_LOAD_PTR {
        my($var, $msg) = @_;
	    eval q( &KASSERT($sizeof{$var} == $sizeof{ &void }  && (( &uintptr_t)($var) & ($sizeof{ &void } - 1)) == 0, $msg));
    }' unless defined(&ASSERT_ATOMIC_LOAD_PTR);
    eval 'sub CRITICAL_ASSERT {
        my($td) = @_;
	    eval q( &KASSERT(($td)-> &td_critnest >= 1, (\\"Not in critical section\\")););
    }' unless defined(&CRITICAL_ASSERT);
    eval 'sub SCHEDULER_STOPPED_TD {
        my($td) = @_;
	    eval q(({  &MPASS(($td) ==  &curthread);  &__predict_false(($td)-> &td_stopsched); }));
    }' unless defined(&SCHEDULER_STOPPED_TD);
    eval 'sub SCHEDULER_STOPPED () {
        eval q( &SCHEDULER_STOPPED_TD( &curthread));
    }' unless defined(&SCHEDULER_STOPPED);
    eval 'sub __read_mostly () { &__section(".data.read_mostly");}' unless defined(&__read_mostly);
    eval 'sub __exclusive_cache_line () { &__aligned( &CACHE_LINE_SIZE)  &__section(".data.exclusive_cache_line");}' unless defined(&__exclusive_cache_line);
    if(defined(&__LP64__)) {
	eval 'sub IOSIZE_MAX () { &iosize_max();}' unless defined(&IOSIZE_MAX);
	eval 'sub DEVFS_IOSIZE_MAX () { &devfs_iosize_max();}' unless defined(&DEVFS_IOSIZE_MAX);
    } else {
	eval 'sub IOSIZE_MAX () { &SSIZE_MAX;}' unless defined(&IOSIZE_MAX);
	eval 'sub DEVFS_IOSIZE_MAX () { &SSIZE_MAX;}' unless defined(&DEVFS_IOSIZE_MAX);
    }
    eval 'sub HASH_NOWAIT () {0x1;}' unless defined(&HASH_NOWAIT);
    eval 'sub HASH_WAITOK () {0x2;}' unless defined(&HASH_WAITOK);
    if(defined(&EARLY_PRINTF)) {
    }
    eval 'sub HD_COLUMN_MASK () {0xff;}' unless defined(&HD_COLUMN_MASK);
    eval 'sub HD_DELIM_MASK () {0xff00;}' unless defined(&HD_DELIM_MASK);
    eval 'sub HD_OMIT_COUNT () {(1<< 16);}' unless defined(&HD_OMIT_COUNT);
    eval 'sub HD_OMIT_HEX () {(1<< 17);}' unless defined(&HD_OMIT_HEX);
    eval 'sub HD_OMIT_CHARS () {(1<< 18);}' unless defined(&HD_OMIT_CHARS);
    eval 'sub ovbcopy {
        my($f, $t, $l) = @_;
	    eval q( &bcopy(($f), ($t), ($l)));
    }' unless defined(&ovbcopy);
    if(defined(&APM_FIXUP_CALLTODO)) {
    }
    require 'sys/libkern.ph';
    eval 'sub CALLOUT_HANDLE_INITIALIZER {
        my($handle) = @_;
	    eval q({  &NULL });
    }' unless defined(&CALLOUT_HANDLE_INITIALIZER);
# some #ifdef were dropped here -- fill in the blanks
    eval 'sub splx {
        my($__unused) = @_;
	    eval q({ ; } \'int\'  &_sleep( &void *  &_Nonnull  &chan, \'struct lock_object\' * &lock, \'int\'  &pri,  &const \'char\' * &wmesg,  &sbintime_t  &sbt,  &sbintime_t  &pr, \'int\'  &flags);  &define  &msleep( &chan,  &mtx,  &pri,  &wmesg,  &timo)  &_sleep(( &chan), ( &mtx)-> &lock_object, ( &pri), ( &wmesg),  &tick_sbt * ( &timo), 0,  &C_HARDCLOCK)  &define  &msleep_sbt( &chan,  &mtx,  &pri,  &wmesg,  &bt,  &pr,  &flags)  &_sleep(( &chan), ( &mtx)-> &lock_object, ( &pri), ( &wmesg), ( &bt), ( &pr), ( &flags)) \'int\'  &msleep_spin_sbt( &void *  &_Nonnull  &chan, \'struct mtx\' * &mtx,  &const \'char\' * &wmesg,  &sbintime_t  &sbt,  &sbintime_t  &pr, \'int\'  &flags);  &define  &msleep_spin( &chan,  &mtx,  &wmesg,  &timo)  &msleep_spin_sbt(( &chan), ( &mtx), ( &wmesg),  &tick_sbt * ( &timo), 0,  &C_HARDCLOCK) \'int\'  &pause_sbt( &const \'char\' * &wmesg,  &sbintime_t  &sbt,  &sbintime_t  &pr, \'int\'  &flags);  &define  &pause( &wmesg,  &timo)  &pause_sbt(( &wmesg),  &tick_sbt * ( &timo), 0,  &C_HARDCLOCK)  &define  &tsleep( &chan,  &pri,  &wmesg,  &timo)  &_sleep(( &chan),  &NULL, ( &pri), ( &wmesg),  &tick_sbt * ( &timo), 0,  &C_HARDCLOCK)  &define  &tsleep_sbt( &chan,  &pri,  &wmesg,  &bt,  &pr,  &flags)  &_sleep(( &chan),  &NULL, ( &pri), ( &wmesg), ( &bt), ( &pr), ( &flags))  &void  &wakeup( &void *  &chan);  &void  &wakeup_one( &void *  &chan); \'struct cdev\';  &dev_t  &dev2udev(\'struct cdev\' * &x);  &const \'char\' * &devtoname(\'struct cdev\' * &cdev); \'int\'  &poll_no_poll(\'int\'  &events);  &void  &DELAY(\'int\'  &usec); \'struct root_hold_token\'; \'struct root_hold_token\' * &root_mount_hold( &const \'char\' * &identifier);  &void  &root_mount_rel(\'struct root_hold_token\' * &h); \'int\'  &root_mounted( &void); \'struct unrhdr\'; \'struct unrhdr\' * &new_unrhdr(\'int\'  &low, \'int\'  &high, \'struct mtx\' * &mutex);  &void  &init_unrhdr(\'struct unrhdr\' * &uh, \'int\'  &low, \'int\'  &high, \'struct mtx\' * &mutex);  &void  &delete_unrhdr(\'struct unrhdr\' * &uh);  &void  &clean_unrhdr(\'struct unrhdr\' * &uh);  &void  &clean_unrhdrl(\'struct unrhdr\' * &uh); \'int\'  &alloc_unr(\'struct unrhdr\' * &uh); \'int\'  &alloc_unr_specific(\'struct unrhdr\' * &uh, \'u_int\'  &item); \'int\'  &alloc_unrl(\'struct unrhdr\' * &uh);  &void  &free_unr(\'struct unrhdr\' * &uh, \'u_int\'  &item);  &void  &intr_prof_stack_use(\'struct thread\' * &td, \'struct trapframe\' * &frame);  &void  &counted_warning(\'unsigned\' * &counter,  &const \'char\' * &msg);  &__NULLABILITY_PRAGMA_POP  &endif );
    }' unless defined(&splx);
1;
