"""Generated message classes for source version v1.

Access source code repositories hosted by Google.
"""
# NOTE: This file is autogenerated and should not be edited by hand.

from apitools.base.protorpclite import messages as _messages
from apitools.base.py import encoding


package = 'source'


class Action(_messages.Message):
  r"""An action to perform on a path in a workspace.

  Fields:
    copyAction: Copy the contents of one path to another.
    deleteAction: Delete a file or directory.
    writeAction: Create or modify a file.
  """

  copyAction = _messages.MessageField('CopyAction', 1)
  deleteAction = _messages.MessageField('DeleteAction', 2)
  writeAction = _messages.MessageField('WriteAction', 3)


class Alias(_messages.Message):
  r"""An alias is a named reference to a revision. Examples include git
  branches and tags.

  Enums:
    KindValueValuesEnum: The alias kind.

  Fields:
    kind: The alias kind.
    name: The alias name.
    revisionId: The revision referred to by this alias. For git tags and
      branches, this is the corresponding hash.
    workspaceNames: The list of workspace names whose alias is this one. NOT
      YET IMPLEMENTED (b/16943429).
  """

  class KindValueValuesEnum(_messages.Enum):
    r"""The alias kind.

    Values:
      ANY: ANY is used to indicate to ListAliases to return aliases of all
        kinds, and when used with GetAlias, the GetAlias function will return
        a FIXED, or MOVABLE, in that priority order. Using ANY with
        CreateAlias or DeleteAlias will result in an error.
      FIXED: Git tag
      MOVABLE: Git branch
      MERCURIAL_BRANCH_DEPRECATED: <no description>
      OTHER: OTHER is used to fetch non-standard aliases, which are none of
        the kinds above or below. For example, if a git repo has a ref named
        "refs/foo/bar", it is considered to be OTHER.
      SPECIAL_DEPRECATED: DO NOT USE.
    """
    ANY = 0
    FIXED = 1
    MOVABLE = 2
    MERCURIAL_BRANCH_DEPRECATED = 3
    OTHER = 4
    SPECIAL_DEPRECATED = 5

  kind = _messages.EnumField('KindValueValuesEnum', 1)
  name = _messages.StringField(2)
  revisionId = _messages.StringField(3)
  workspaceNames = _messages.StringField(4, repeated=True)


class AliasContext(_messages.Message):
  r"""An alias to a repo revision.

  Enums:
    KindValueValuesEnum: The alias kind.

  Fields:
    kind: The alias kind.
    name: The alias name.
  """

  class KindValueValuesEnum(_messages.Enum):
    r"""The alias kind.

    Values:
      ANY: Do not use.
      FIXED: Git tag
      MOVABLE: Git branch
      OTHER: OTHER is used to specify non-standard aliases, those not of the
        kinds above. For example, if a Git repo has a ref named
        "refs/foo/bar", it is considered to be of kind OTHER.
    """
    ANY = 0
    FIXED = 1
    MOVABLE = 2
    OTHER = 3

  kind = _messages.EnumField('KindValueValuesEnum', 1)
  name = _messages.StringField(2)


class ChangedFileInfo(_messages.Message):
  r"""Represents file information.

  Enums:
    OperationValueValuesEnum: The operation type for the file.

  Fields:
    fromPath: Related file path for copies or renames.  For copies, the type
      will be ADDED and the from_path will point to the source of the copy.
      For renames, the type will be ADDED, the from_path will point to the
      source of the rename, and another ChangedFileInfo record with that path
      will appear with type DELETED. In other words, a rename is represented
      as a copy plus a delete of the old path.
    hash: A hex-encoded hash for the file. Not necessarily a hash of the
      file's contents. Two paths in the same revision with the same hash have
      the same contents with high probability. Empty if the operation is
      CONFLICTED.
    operation: The operation type for the file.
    path: The path of the file.
  """

  class OperationValueValuesEnum(_messages.Enum):
    r"""The operation type for the file.

    Values:
      OPERATION_UNSPECIFIED: No operation was specified.
      ADDED: The file was added.
      DELETED: The file was deleted.
      MODIFIED: The file was modified.
      CONFLICTED: The result of merging the file is a conflict. The CONFLICTED
        type only appears in Workspace.changed_files or Snapshot.changed_files
        when the workspace is in a merge state.
    """
    OPERATION_UNSPECIFIED = 0
    ADDED = 1
    DELETED = 2
    MODIFIED = 3
    CONFLICTED = 4

  fromPath = _messages.StringField(1)
  hash = _messages.StringField(2)
  operation = _messages.EnumField('OperationValueValuesEnum', 3)
  path = _messages.StringField(4)


class CloudRepoSourceContext(_messages.Message):
  r"""A CloudRepoSourceContext denotes a particular revision in a cloud repo
  (a repo hosted by the Google Cloud Platform).

  Fields:
    aliasContext: An alias, which may be a branch or tag.
    aliasName: The name of an alias (branch, tag, etc.).
    repoId: The ID of the repo.
    revisionId: A revision ID.
  """

  aliasContext = _messages.MessageField('AliasContext', 1)
  aliasName = _messages.StringField(2)
  repoId = _messages.MessageField('RepoId', 3)
  revisionId = _messages.StringField(4)


class CloudWorkspaceId(_messages.Message):
  r"""A CloudWorkspaceId is a unique identifier for a cloud workspace. A cloud
  workspace is a place associated with a repo where modified files can be
  stored before they are committed.

  Fields:
    name: The unique name of the workspace within the repo.  This is the name
      chosen by the client in the Source API's CreateWorkspace method.
    repoId: The ID of the repo containing the workspace.
  """

  name = _messages.StringField(1)
  repoId = _messages.MessageField('RepoId', 2)


class CloudWorkspaceSourceContext(_messages.Message):
  r"""A CloudWorkspaceSourceContext denotes a workspace at a particular
  snapshot.

  Fields:
    snapshotId: The ID of the snapshot. An empty snapshot_id refers to the
      most recent snapshot.
    workspaceId: The ID of the workspace.
  """

  snapshotId = _messages.StringField(1)
  workspaceId = _messages.MessageField('CloudWorkspaceId', 2)


class CommitWorkspaceRequest(_messages.Message):
  r"""Request for CommitWorkspace.

  Fields:
    author: Author of the commit in the format: "Author Name
      <author@example.com>" required
    currentSnapshotId: If non-empty, current_snapshot_id must refer to the
      most recent update to the workspace, or ABORTED is returned.
    message: The commit message. required
    paths: The subset of modified paths to commit. If empty, then commit all
      modified paths.
    workspaceId: The ID of the workspace.
  """

  author = _messages.StringField(1)
  currentSnapshotId = _messages.StringField(2)
  message = _messages.StringField(3)
  paths = _messages.StringField(4, repeated=True)
  workspaceId = _messages.MessageField('CloudWorkspaceId', 5)


class CopyAction(_messages.Message):
  r"""Copy the contents of a file or directory at from_path in the specified
  revision or snapshot to to_path.  To rename a file, copy it to the new path
  and delete the old.

  Fields:
    fromPath: The path to copy from.
    fromRevisionId: The revision ID from which to copy the file.
    fromSnapshotId: The snapshot ID from which to copy the file.
    toPath: The path to copy to.
  """

  fromPath = _messages.StringField(1)
  fromRevisionId = _messages.StringField(2)
  fromSnapshotId = _messages.StringField(3)
  toPath = _messages.StringField(4)


class CreateWorkspaceRequest(_messages.Message):
  r"""Request for CreateWorkspace.

  Fields:
    actions: An ordered sequence of actions to perform in the workspace. Can
      be empty. Specifying actions here instead of using ModifyWorkspace saves
      one RPC.
    repoId: The repo within which to create the workspace.
    workspace: The following fields of workspace, with the allowable exception
      of baseline, must be set. No other fields of workspace should be set.
      id.name Provides the name of the workspace and must be unique within the
      repo. Note: Do not set field id.repo_id.  The repo_id is provided above
      as a CreateWorkspaceRequest field.  alias: If alias names an existing
      movable alias, the workspace's baseline is set to the alias's revision.
      If alias does not name an existing movable alias, then the workspace is
      created with no baseline. When the workspace is committed, a new root
      revision is created with no parents. The new revision becomes the
      workspace's baseline and the alias name is used to create a movable
      alias referring to the revision.  baseline: A revision ID (hexadecimal
      string) for sequencing. If non-empty, alias must name an existing
      movable alias and baseline must match the alias's revision ID.
  """

  actions = _messages.MessageField('Action', 1, repeated=True)
  repoId = _messages.MessageField('RepoId', 2)
  workspace = _messages.MessageField('Workspace', 3)


class DeleteAction(_messages.Message):
  r"""Delete a file or directory.

  Fields:
    path: The path of the file or directory. If path refers to a directory,
      the directory and its contents are deleted.
  """

  path = _messages.StringField(1)


class DirectoryEntry(_messages.Message):
  r"""Information about a directory.

  Fields:
    info: Information about the entry.
    isDir: Whether the entry is a file or directory.
    lastModifiedRevisionId: ID of the revision that most recently modified
      this file.
    name: Name of the entry relative to the directory.
  """

  info = _messages.MessageField('FileInfo', 1)
  isDir = _messages.BooleanField(2)
  lastModifiedRevisionId = _messages.StringField(3)
  name = _messages.StringField(4)


class Empty(_messages.Message):
  r"""A generic empty message that you can re-use to avoid defining duplicated
  empty messages in your APIs. A typical example is to use it as the request
  or the response type of an API method. For instance:      service Foo {
  rpc Bar(google.protobuf.Empty) returns (google.protobuf.Empty);     }  The
  JSON representation for `Empty` is empty JSON object `{}`.
  """



class ExternalReference(_messages.Message):
  r"""A submodule or subrepository."""


class File(_messages.Message):
  r"""A file, with contents and metadata.  Pagination can be used to limit the
  size of the file. Otherwise, there is a default max size for the contents.
  Whether the file has been truncated can be determined by comparing
  len(contents) to info.Size.

  Fields:
    contents: The contents of the file.
    info: Information about the file.
    path: The path to the file starting from the root of the revision.
  """

  contents = _messages.BytesField(1)
  info = _messages.MessageField('FileInfo', 2)
  path = _messages.StringField(3)


class FileInfo(_messages.Message):
  r"""File metadata, including a hash of the file contents.

  Enums:
    ModeValueValuesEnum: The mode of the file: an executable, a symbolic link,
      or neither.

  Fields:
    hash: A hex-encoded cryptographic hash of the file's contents, possibly
      with other data.
    isText: An educated guess as to whether the file is human-readable text,
      or binary. Typically available only when file contents are retrieved
      (since the guess depends on examining a prefix of the contents), but
      some systems might store this metadata for every file.
    mode: The mode of the file: an executable, a symbolic link, or neither.
    size: The size of the file in bytes.
  """

  class ModeValueValuesEnum(_messages.Enum):
    r"""The mode of the file: an executable, a symbolic link, or neither.

    Values:
      FILE_MODE_UNSPECIFIED: No file mode was specified.
      NORMAL: Neither a symbolic link nor executable.
      SYMLINK: A symbolic link.
      EXECUTABLE: An executable.
    """
    FILE_MODE_UNSPECIFIED = 0
    NORMAL = 1
    SYMLINK = 2
    EXECUTABLE = 3

  hash = _messages.StringField(1)
  isText = _messages.BooleanField(2)
  mode = _messages.EnumField('ModeValueValuesEnum', 3)
  size = _messages.IntegerField(4)


class GerritSourceContext(_messages.Message):
  r"""A SourceContext referring to a Gerrit project.

  Fields:
    aliasContext: An alias, which may be a branch or tag.
    aliasName: The name of an alias (branch, tag, etc.).
    gerritProject: The full project name within the host. Projects may be
      nested, so "project/subproject" is a valid project name. The "repo name"
      is hostURI/project.
    hostUri: The URI of a running Gerrit instance.
    revisionId: A revision (commit) ID.
  """

  aliasContext = _messages.MessageField('AliasContext', 1)
  aliasName = _messages.StringField(2)
  gerritProject = _messages.StringField(3)
  hostUri = _messages.StringField(4)
  revisionId = _messages.StringField(5)


class GetRevisionsResponse(_messages.Message):
  r"""Response for GetRevisions.

  Fields:
    revisions: The revisions.
  """

  revisions = _messages.MessageField('Revision', 1, repeated=True)


class GitSourceContext(_messages.Message):
  r"""A GitSourceContext denotes a particular revision in a third party Git
  repository (e.g. GitHub).

  Fields:
    revisionId: Git commit hash. required.
    url: Git repository URL.
  """

  revisionId = _messages.StringField(1)
  url = _messages.StringField(2)


class ListAliasesResponse(_messages.Message):
  r"""Response for ListAliases.

  Fields:
    aliases: The list of aliases.
    nextPageToken: Use as the value of page_token in the next call to obtain
      the next page of results. If empty, there are no more results.
    totalAliases: The total number of aliases in the repo of the kind
      specified in the request.
  """

  aliases = _messages.MessageField('Alias', 1, repeated=True)
  nextPageToken = _messages.StringField(2)
  totalAliases = _messages.IntegerField(3, variant=_messages.Variant.INT32)


class ListChangedFilesRequest(_messages.Message):
  r"""Request for ListChangedFiles.

  Fields:
    pageSize: The maximum number of ChangedFileInfo values to return.
    pageToken: The value of next_page_token from the previous call. Omit for
      the first page.
    sourceContext1: The starting source context to compare.
    sourceContext2: The ending source context to compare.
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  sourceContext1 = _messages.MessageField('SourceContext', 3)
  sourceContext2 = _messages.MessageField('SourceContext', 4)


class ListChangedFilesResponse(_messages.Message):
  r"""Response for ListChangedFiles.

  Fields:
    changedFiles: Note: ChangedFileInfo.from_path is not set here.
      ListChangedFiles does not perform rename/copy detection.  The
      ChangedFileInfo.Type describes the changes from source_context1 to
      source_context2. Thus ADDED would mean a file is not present in
      source_context1 but is present in source_context2.
    nextPageToken: Use as the value of page_token in the next call to obtain
      the next page of results. If empty, there are no more results.
  """

  changedFiles = _messages.MessageField('ChangedFileInfo', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListFilesResponse(_messages.Message):
  r"""Response for ListFiles.

  Fields:
    files: The contents field is empty.
    nextPageToken: Use as the value of page_token in the next call to obtain
      the next page of results. If empty, there are no more results.
  """

  files = _messages.MessageField('File', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListReposResponse(_messages.Message):
  r"""Response for ListRepos.

  Fields:
    repos: The listed repos.
  """

  repos = _messages.MessageField('Repo', 1, repeated=True)


class ListRevisionsResponse(_messages.Message):
  r"""Response for ListRevisions.

  Fields:
    nextPageToken: Use as the value of page_token in the next call to obtain
      the next page of results. If empty, there are no more results.
    revisions: The list of revisions.
  """

  nextPageToken = _messages.StringField(1)
  revisions = _messages.MessageField('Revision', 2, repeated=True)


class ListSnapshotsResponse(_messages.Message):
  r"""Response for ListSnapshots.

  Fields:
    nextPageToken: Use as the value of page_token in the next call to obtain
      the next page of results. If empty, there are no more results.
    snapshots: The list of snapshots.
  """

  nextPageToken = _messages.StringField(1)
  snapshots = _messages.MessageField('Snapshot', 2, repeated=True)


class ListWorkspacesResponse(_messages.Message):
  r"""Response for ListWorkspaces.

  Fields:
    workspaces: The listed workspaces.
  """

  workspaces = _messages.MessageField('Workspace', 1, repeated=True)


class MergeInfo(_messages.Message):
  r"""MergeInfo holds information needed while resolving merges, and refreshes
  that involve conflicts.

  Fields:
    commonAncestorRevisionId: Revision ID of the closest common ancestor of
      the file trees that are participating in a refresh or merge.  During a
      refresh, the common ancestor is the baseline of the workspace.  During a
      merge of two branches, the common ancestor is derived from the workspace
      baseline and the alias of the branch being merged in.  The repository
      state at the common ancestor provides the base version for a three-way
      merge.
    isRefresh: If true, a refresh operation is in progress.  If false, a merge
      is in progress.
    otherRevisionId: During a refresh, the ID of the revision with which the
      workspace is being refreshed. This is the revision ID to which the
      workspace's alias refers at the time of the RefreshWorkspace call.
      During a merge, the ID of the revision that's being merged into the
      workspace's alias. This is the revision_id field of the MergeRequest.
    workspaceAfterSnapshotId: The workspace snapshot immediately after the
      refresh or merge RPC completes.  If a file has conflicts, this snapshot
      contains the version of the file with conflict markers.
    workspaceBeforeSnapshotId: During a refresh, the snapshot ID of the latest
      change to the workspace before the refresh.  During a merge, the
      workspace's baseline, which is identical to the commit hash of the
      workspace's alias before initiating the merge.
  """

  commonAncestorRevisionId = _messages.StringField(1)
  isRefresh = _messages.BooleanField(2)
  otherRevisionId = _messages.StringField(3)
  workspaceAfterSnapshotId = _messages.StringField(4)
  workspaceBeforeSnapshotId = _messages.StringField(5)


class MergeRequest(_messages.Message):
  r"""Request for Merge.

  Fields:
    revisionId: The other revision to be merged.
    workspaceId: The workspace to use for the merge. The revision referred to
      by the workspace's alias will be one of the revisions merged.
  """

  revisionId = _messages.StringField(1)
  workspaceId = _messages.MessageField('CloudWorkspaceId', 2)


class ModifyWorkspaceRequest(_messages.Message):
  r"""Request for ModifyWorkspace.

  Fields:
    actions: An ordered sequence of actions to perform in the workspace.  May
      not be empty.
    currentSnapshotId: If non-empty, current_snapshot_id must refer to the
      most recent update to the workspace, or ABORTED is returned.
    workspaceId: The ID of the workspace.
  """

  actions = _messages.MessageField('Action', 1, repeated=True)
  currentSnapshotId = _messages.StringField(2)
  workspaceId = _messages.MessageField('CloudWorkspaceId', 3)


class ProjectRepoId(_messages.Message):
  r"""Selects a repo using a Google Cloud Platform project ID (e.g. winged-
  cargo-31) and a repo name within that project.
  """



class ReadResponse(_messages.Message):
  r"""Response to read request. Exactly one of entries, file or
  external_reference will be populated, depending on what the path in the
  request denotes.

  Fields:
    entries: Contains the directory entries if the request specifies a
      directory.
    externalReference: The read path denotes a Git submodule.
    file: Contains file metadata and contents if the request specifies a file.
    nextPageToken: Use as the value of page_token in the next call to obtain
      the next page of results. If empty, there are no more results.
    sourceContext: Returns the SourceContext actually used, resolving any
      alias in the input SourceContext into its revision ID and returning the
      actual current snapshot ID if the read was from a workspace with an
      unspecified snapshot ID.
  """

  entries = _messages.MessageField('DirectoryEntry', 1, repeated=True)
  externalReference = _messages.MessageField('ExternalReference', 2)
  file = _messages.MessageField('File', 3)
  nextPageToken = _messages.StringField(4)
  sourceContext = _messages.MessageField('SourceContext', 5)


class RefreshWorkspaceRequest(_messages.Message):
  r"""Request for RefreshWorkspace.

  Fields:
    workspaceId: The ID of the workspace.
  """

  workspaceId = _messages.MessageField('CloudWorkspaceId', 1)


class Repo(_messages.Message):
  r"""A repository (or repo) stores files for a version-control system.

  Enums:
    StateValueValuesEnum: The state the repo is in.
    VcsValueValuesEnum: The version control system of the repo.

  Fields:
    createTime: Timestamp when the repo was created.
    id: Randomly generated ID that uniquely identifies a repo.
    name: Human-readable, user-defined name of the repository. Names must be
      alphanumeric, lowercase, begin with a letter, and be between 3 and 63
      characters long. The - character can appear in the middle positions.
      (Names must satisfy the regular expression a-z{1,61}[a-z0-9].)
    projectId: Immutable, globally unique, DNS-compatible textual identifier.
      Examples: user-chosen-project-id, yellow-banana-33.
    repoSyncConfig: How RepoSync is configured for this repo. If missing, this
      repo is not set up for RepoSync.
    state: The state the repo is in.
    vcs: The version control system of the repo.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""The state the repo is in.

    Values:
      STATE_UNSPECIFIED: No state was specified.
      LIVE: The repo is live and available for use.
      DELETED: The repo has been deleted.
    """
    STATE_UNSPECIFIED = 0
    LIVE = 1
    DELETED = 2

  class VcsValueValuesEnum(_messages.Enum):
    r"""The version control system of the repo.

    Values:
      VCS_UNSPECIFIED: No version control system was specified.
      GIT: The Git version control system.
    """
    VCS_UNSPECIFIED = 0
    GIT = 1

  createTime = _messages.StringField(1)
  id = _messages.StringField(2)
  name = _messages.StringField(3)
  projectId = _messages.StringField(4)
  repoSyncConfig = _messages.MessageField('RepoSyncConfig', 5)
  state = _messages.EnumField('StateValueValuesEnum', 6)
  vcs = _messages.EnumField('VcsValueValuesEnum', 7)


class RepoId(_messages.Message):
  r"""A unique identifier for a cloud repo.

  Fields:
    projectRepoId: A combination of a project ID and a repo name.
    uid: A server-assigned, globally unique identifier.
  """

  projectRepoId = _messages.MessageField('ProjectRepoId', 1)
  uid = _messages.StringField(2)


class RepoSyncConfig(_messages.Message):
  r"""RepoSync configuration information.

  Enums:
    StatusValueValuesEnum: The status of RepoSync.

  Fields:
    externalRepoUrl: If this repo is enabled for RepoSync, this will be the
      URL of the external repo that this repo should sync with.
    status: The status of RepoSync.
  """

  class StatusValueValuesEnum(_messages.Enum):
    r"""The status of RepoSync.

    Values:
      REPO_SYNC_STATUS_UNSPECIFIED: No RepoSync status was specified.
      OK: RepoSync is working.
      FAILED_AUTH: RepoSync failed because of authorization/authentication.
      FAILED_OTHER: RepoSync failed for a reason other than auth.
      FAILED_NOT_FOUND: RepoSync failed because the repository was not found.
    """
    REPO_SYNC_STATUS_UNSPECIFIED = 0
    OK = 1
    FAILED_AUTH = 2
    FAILED_OTHER = 3
    FAILED_NOT_FOUND = 4

  externalRepoUrl = _messages.StringField(1)
  status = _messages.EnumField('StatusValueValuesEnum', 2)


class ResolveFilesRequest(_messages.Message):
  r"""Request for ResolveFiles.

  Fields:
    resolvedPaths: Files that should be marked as resolved in the workspace.
      All files in resolved_paths must currently be in the CONFLICTED state in
      Workspace.changed_files.  NOTE: Changing a file's contents to match the
      contents in the workspace baseline, then calling ResolveFiles on it,
      will cause the file to be removed from the changed_files list entirely.
      If resolved_paths is empty, INVALID_ARGUMENT is returned. If
      resolved_paths contains duplicates, INVALID_ARGUMENT is returned. If
      resolved_paths contains a path that was never unresolved, or has already
      been resolved, FAILED_PRECONDITION is returned.
    workspaceId: The ID of the workspace.
  """

  resolvedPaths = _messages.StringField(1, repeated=True)
  workspaceId = _messages.MessageField('CloudWorkspaceId', 2)


class RevertRefreshRequest(_messages.Message):
  r"""Request for RevertRefresh.

  Fields:
    workspaceId: The ID of the workspace.
  """

  workspaceId = _messages.MessageField('CloudWorkspaceId', 1)


class Revision(_messages.Message):
  r"""A revision is a snapshot of a file tree, with associated metadata. This
  message contains metadata only. Use the Read or ReadFromWorkspaceOrAlias
  rpcs to read the contents of the revision's file tree.

  Fields:
    author: The name of the user who wrote the revision. (In Git, this can
      differ from committer.)
    branchName: Mercurial branch name.
    changedFiles: Files changed in this revision.
    changedFilesUnknown: In some cases changed-file information is generated
      asynchronously. So there is a period of time when it is not available.
      This field encodes that fact. (An empty changed_files field is not
      sufficient, since it is possible for a revision to have no changed
      files.)
    commitMessage: The message added by the committer.
    commitTime: When the revision was committed.
    committer: The name of the user who committed the revision.
    createTime: When the revision was made. This may or may not be reliable,
      depending on the version control system being used.
    id: The unique ID of the revision. For many version control systems, this
      will be string of hex digits representing a hash value.
    parentIds: The revision IDs of this revision's parents.
  """

  author = _messages.StringField(1)
  branchName = _messages.StringField(2)
  changedFiles = _messages.MessageField('ChangedFileInfo', 3, repeated=True)
  changedFilesUnknown = _messages.BooleanField(4)
  commitMessage = _messages.StringField(5)
  commitTime = _messages.StringField(6)
  committer = _messages.StringField(7)
  createTime = _messages.StringField(8)
  id = _messages.StringField(9)
  parentIds = _messages.StringField(10, repeated=True)


class Snapshot(_messages.Message):
  r"""A snapshot is a version of a workspace. Each change to a workspace's
  files creates a new snapshot. A workspace consists of a sequence of
  snapshots.

  Fields:
    changedFiles: The set of files modified in this snapshot, relative to the
      workspace baseline. ChangedFileInfo.from_path is not set.
    createTime: Timestamp when the snapshot was created.
    snapshotId: The ID of the snapshot.
  """

  changedFiles = _messages.MessageField('ChangedFileInfo', 1, repeated=True)
  createTime = _messages.StringField(2)
  snapshotId = _messages.StringField(3)


class SourceContext(_messages.Message):
  r"""A SourceContext is a reference to a tree of files. A SourceContext
  together with a path point to a unique revision of a single file or
  directory.

  Fields:
    cloudRepo: A SourceContext referring to a revision in a cloud repo.
    cloudWorkspace: A SourceContext referring to a snapshot in a cloud
      workspace.
    gerrit: A SourceContext referring to a Gerrit project.
    git: A SourceContext referring to any third party Git repo (e.g. GitHub).
  """

  cloudRepo = _messages.MessageField('CloudRepoSourceContext', 1)
  cloudWorkspace = _messages.MessageField('CloudWorkspaceSourceContext', 2)
  gerrit = _messages.MessageField('GerritSourceContext', 3)
  git = _messages.MessageField('GitSourceContext', 4)


class SourceProjectsReposAliasesCreateRequest(_messages.Message):
  r"""A SourceProjectsReposAliasesCreateRequest object.

  Fields:
    alias: A Alias resource to be passed as the request body.
    projectId: The ID of the project.
    repoId_uid: A server-assigned, globally unique identifier.
    repoName: The name of the repo. Leave empty for the default repo.
  """

  alias = _messages.MessageField('Alias', 1)
  projectId = _messages.StringField(2, required=True)
  repoId_uid = _messages.StringField(3)
  repoName = _messages.StringField(4, required=True)


class SourceProjectsReposAliasesDeleteRequest(_messages.Message):
  r"""A SourceProjectsReposAliasesDeleteRequest object.

  Enums:
    KindValueValuesEnum: The kind of the alias to delete.

  Fields:
    kind: The kind of the alias to delete.
    name: The name of the alias to delete.
    projectId: The ID of the project.
    repoId_uid: A server-assigned, globally unique identifier.
    repoName: The name of the repo. Leave empty for the default repo.
    revisionId: If non-empty, must match the revision that the alias refers
      to.
  """

  class KindValueValuesEnum(_messages.Enum):
    r"""The kind of the alias to delete.

    Values:
      ANY: <no description>
      FIXED: <no description>
      MOVABLE: <no description>
      MERCURIAL_BRANCH_DEPRECATED: <no description>
      OTHER: <no description>
      SPECIAL_DEPRECATED: <no description>
    """
    ANY = 0
    FIXED = 1
    MOVABLE = 2
    MERCURIAL_BRANCH_DEPRECATED = 3
    OTHER = 4
    SPECIAL_DEPRECATED = 5

  kind = _messages.EnumField('KindValueValuesEnum', 1, required=True)
  name = _messages.StringField(2, required=True)
  projectId = _messages.StringField(3, required=True)
  repoId_uid = _messages.StringField(4)
  repoName = _messages.StringField(5, required=True)
  revisionId = _messages.StringField(6)


class SourceProjectsReposAliasesFilesGetRequest(_messages.Message):
  r"""A SourceProjectsReposAliasesFilesGetRequest object.

  Enums:
    KindValueValuesEnum: The alias kind.
    SourceContextGerritAliasContextKindValueValuesEnum: The alias kind.

  Fields:
    kind: The alias kind.
    name: The alias name.
    pageSize: The maximum number of values to return.
    pageToken: The value of next_page_token from the previous call. Omit for
      the first page, or if using start_index.
    path: Path to the file or directory from the root directory of the source
      context. It must not have leading or trailing slashes.
    projectId: The ID of the project.
    repoName: The name of the repo. Leave empty for the default repo.
    sourceContext_cloudRepo_aliasName: The name of an alias (branch, tag,
      etc.).
    sourceContext_cloudRepo_repoId_uid: A server-assigned, globally unique
      identifier.
    sourceContext_cloudRepo_revisionId: A revision ID.
    sourceContext_cloudWorkspace_snapshotId: The ID of the snapshot. An empty
      snapshot_id refers to the most recent snapshot.
    sourceContext_cloudWorkspace_workspaceId_name: The unique name of the
      workspace within the repo.  This is the name chosen by the client in the
      Source API's CreateWorkspace method.
    sourceContext_cloudWorkspace_workspaceId_repoId_projectRepoId_projectId:
      The ID of the project.
    sourceContext_cloudWorkspace_workspaceId_repoId_projectRepoId_repoName:
      The name of the repo. Leave empty for the default repo.
    sourceContext_cloudWorkspace_workspaceId_repoId_uid: A server-assigned,
      globally unique identifier.
    sourceContext_gerrit_aliasContext_kind: The alias kind.
    sourceContext_gerrit_aliasContext_name: The alias name.
    sourceContext_gerrit_aliasName: The name of an alias (branch, tag, etc.).
    sourceContext_gerrit_gerritProject: The full project name within the host.
      Projects may be nested, so "project/subproject" is a valid project name.
      The "repo name" is hostURI/project.
    sourceContext_gerrit_hostUri: The URI of a running Gerrit instance.
    sourceContext_gerrit_revisionId: A revision (commit) ID.
    sourceContext_git_revisionId: Git commit hash. required.
    sourceContext_git_url: Git repository URL.
    startPosition: If path refers to a file, the position of the first byte of
      its contents to return. If path refers to a directory, the position of
      the first entry in the listing. If page_token is specified, this field
      is ignored.
  """

  class KindValueValuesEnum(_messages.Enum):
    r"""The alias kind.

    Values:
      ANY: <no description>
      FIXED: <no description>
      MOVABLE: <no description>
      OTHER: <no description>
    """
    ANY = 0
    FIXED = 1
    MOVABLE = 2
    OTHER = 3

  class SourceContextGerritAliasContextKindValueValuesEnum(_messages.Enum):
    r"""The alias kind.

    Values:
      ANY: <no description>
      FIXED: <no description>
      MOVABLE: <no description>
      OTHER: <no description>
    """
    ANY = 0
    FIXED = 1
    MOVABLE = 2
    OTHER = 3

  kind = _messages.EnumField('KindValueValuesEnum', 1, required=True)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3)
  pageToken = _messages.StringField(4)
  path = _messages.StringField(5, required=True)
  projectId = _messages.StringField(6, required=True)
  repoName = _messages.StringField(7, required=True)
  sourceContext_cloudRepo_aliasName = _messages.StringField(8)
  sourceContext_cloudRepo_repoId_uid = _messages.StringField(9)
  sourceContext_cloudRepo_revisionId = _messages.StringField(10)
  sourceContext_cloudWorkspace_snapshotId = _messages.StringField(11)
  sourceContext_cloudWorkspace_workspaceId_name = _messages.StringField(12)
  sourceContext_cloudWorkspace_workspaceId_repoId_projectRepoId_projectId = _messages.StringField(13)
  sourceContext_cloudWorkspace_workspaceId_repoId_projectRepoId_repoName = _messages.StringField(14)
  sourceContext_cloudWorkspace_workspaceId_repoId_uid = _messages.StringField(15)
  sourceContext_gerrit_aliasContext_kind = _messages.EnumField('SourceContextGerritAliasContextKindValueValuesEnum', 16)
  sourceContext_gerrit_aliasContext_name = _messages.StringField(17)
  sourceContext_gerrit_aliasName = _messages.StringField(18)
  sourceContext_gerrit_gerritProject = _messages.StringField(19)
  sourceContext_gerrit_hostUri = _messages.StringField(20)
  sourceContext_gerrit_revisionId = _messages.StringField(21)
  sourceContext_git_revisionId = _messages.StringField(22)
  sourceContext_git_url = _messages.StringField(23)
  startPosition = _messages.IntegerField(24)


class SourceProjectsReposAliasesGetRequest(_messages.Message):
  r"""A SourceProjectsReposAliasesGetRequest object.

  Enums:
    KindValueValuesEnum: The kind of the alias.

  Fields:
    kind: The kind of the alias.
    name: The alias name.
    projectId: The ID of the project.
    repoId_uid: A server-assigned, globally unique identifier.
    repoName: The name of the repo. Leave empty for the default repo.
  """

  class KindValueValuesEnum(_messages.Enum):
    r"""The kind of the alias.

    Values:
      ANY: <no description>
      FIXED: <no description>
      MOVABLE: <no description>
      MERCURIAL_BRANCH_DEPRECATED: <no description>
      OTHER: <no description>
      SPECIAL_DEPRECATED: <no description>
    """
    ANY = 0
    FIXED = 1
    MOVABLE = 2
    MERCURIAL_BRANCH_DEPRECATED = 3
    OTHER = 4
    SPECIAL_DEPRECATED = 5

  kind = _messages.EnumField('KindValueValuesEnum', 1, required=True)
  name = _messages.StringField(2, required=True)
  projectId = _messages.StringField(3, required=True)
  repoId_uid = _messages.StringField(4)
  repoName = _messages.StringField(5, required=True)


class SourceProjectsReposAliasesListFilesRequest(_messages.Message):
  r"""A SourceProjectsReposAliasesListFilesRequest object.

  Enums:
    KindValueValuesEnum: The alias kind.
    SourceContextGerritAliasContextKindValueValuesEnum: The alias kind.

  Fields:
    kind: The alias kind.
    name: The alias name.
    pageSize: The maximum number of values to return.
    pageToken: The value of next_page_token from the previous call. Omit for
      the first page.
    projectId: The ID of the project.
    repoName: The name of the repo. Leave empty for the default repo.
    sourceContext_cloudRepo_aliasName: The name of an alias (branch, tag,
      etc.).
    sourceContext_cloudRepo_repoId_uid: A server-assigned, globally unique
      identifier.
    sourceContext_cloudRepo_revisionId: A revision ID.
    sourceContext_cloudWorkspace_snapshotId: The ID of the snapshot. An empty
      snapshot_id refers to the most recent snapshot.
    sourceContext_cloudWorkspace_workspaceId_name: The unique name of the
      workspace within the repo.  This is the name chosen by the client in the
      Source API's CreateWorkspace method.
    sourceContext_cloudWorkspace_workspaceId_repoId_projectRepoId_projectId:
      The ID of the project.
    sourceContext_cloudWorkspace_workspaceId_repoId_projectRepoId_repoName:
      The name of the repo. Leave empty for the default repo.
    sourceContext_cloudWorkspace_workspaceId_repoId_uid: A server-assigned,
      globally unique identifier.
    sourceContext_gerrit_aliasContext_kind: The alias kind.
    sourceContext_gerrit_aliasContext_name: The alias name.
    sourceContext_gerrit_aliasName: The name of an alias (branch, tag, etc.).
    sourceContext_gerrit_gerritProject: The full project name within the host.
      Projects may be nested, so "project/subproject" is a valid project name.
      The "repo name" is hostURI/project.
    sourceContext_gerrit_hostUri: The URI of a running Gerrit instance.
    sourceContext_gerrit_revisionId: A revision (commit) ID.
    sourceContext_git_revisionId: Git commit hash. required.
    sourceContext_git_url: Git repository URL.
  """

  class KindValueValuesEnum(_messages.Enum):
    r"""The alias kind.

    Values:
      ANY: <no description>
      FIXED: <no description>
      MOVABLE: <no description>
      OTHER: <no description>
    """
    ANY = 0
    FIXED = 1
    MOVABLE = 2
    OTHER = 3

  class SourceContextGerritAliasContextKindValueValuesEnum(_messages.Enum):
    r"""The alias kind.

    Values:
      ANY: <no description>
      FIXED: <no description>
      MOVABLE: <no description>
      OTHER: <no description>
    """
    ANY = 0
    FIXED = 1
    MOVABLE = 2
    OTHER = 3

  kind = _messages.EnumField('KindValueValuesEnum', 1, required=True)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  projectId = _messages.StringField(5, required=True)
  repoName = _messages.StringField(6, required=True)
  sourceContext_cloudRepo_aliasName = _messages.StringField(7)
  sourceContext_cloudRepo_repoId_uid = _messages.StringField(8)
  sourceContext_cloudRepo_revisionId = _messages.StringField(9)
  sourceContext_cloudWorkspace_snapshotId = _messages.StringField(10)
  sourceContext_cloudWorkspace_workspaceId_name = _messages.StringField(11)
  sourceContext_cloudWorkspace_workspaceId_repoId_projectRepoId_projectId = _messages.StringField(12)
  sourceContext_cloudWorkspace_workspaceId_repoId_projectRepoId_repoName = _messages.StringField(13)
  sourceContext_cloudWorkspace_workspaceId_repoId_uid = _messages.StringField(14)
  sourceContext_gerrit_aliasContext_kind = _messages.EnumField('SourceContextGerritAliasContextKindValueValuesEnum', 15)
  sourceContext_gerrit_aliasContext_name = _messages.StringField(16)
  sourceContext_gerrit_aliasName = _messages.StringField(17)
  sourceContext_gerrit_gerritProject = _messages.StringField(18)
  sourceContext_gerrit_hostUri = _messages.StringField(19)
  sourceContext_gerrit_revisionId = _messages.StringField(20)
  sourceContext_git_revisionId = _messages.StringField(21)
  sourceContext_git_url = _messages.StringField(22)


class SourceProjectsReposAliasesListRequest(_messages.Message):
  r"""A SourceProjectsReposAliasesListRequest object.

  Enums:
    KindValueValuesEnum: Return only aliases of this kind.

  Fields:
    kind: Return only aliases of this kind.
    pageSize: The maximum number of values to return.
    pageToken: The value of next_page_token from the previous call. Omit for
      the first page.
    projectId: The ID of the project.
    repoId_uid: A server-assigned, globally unique identifier.
    repoName: The name of the repo. Leave empty for the default repo.
  """

  class KindValueValuesEnum(_messages.Enum):
    r"""Return only aliases of this kind.

    Values:
      ANY: <no description>
      FIXED: <no description>
      MOVABLE: <no description>
      MERCURIAL_BRANCH_DEPRECATED: <no description>
      OTHER: <no description>
      SPECIAL_DEPRECATED: <no description>
    """
    ANY = 0
    FIXED = 1
    MOVABLE = 2
    MERCURIAL_BRANCH_DEPRECATED = 3
    OTHER = 4
    SPECIAL_DEPRECATED = 5

  kind = _messages.EnumField('KindValueValuesEnum', 1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  projectId = _messages.StringField(4, required=True)
  repoId_uid = _messages.StringField(5)
  repoName = _messages.StringField(6, required=True)


class SourceProjectsReposAliasesUpdateRequest(_messages.Message):
  r"""A SourceProjectsReposAliasesUpdateRequest object.

  Fields:
    alias: A Alias resource to be passed as the request body.
    aliasesId: A string attribute.
    oldRevisionId: If non-empty, must match the revision that the alias refers
      to.
    projectId: The ID of the project.
    repoId_uid: A server-assigned, globally unique identifier.
    repoName: The name of the repo. Leave empty for the default repo.
  """

  alias = _messages.MessageField('Alias', 1)
  aliasesId = _messages.StringField(2, required=True)
  oldRevisionId = _messages.StringField(3)
  projectId = _messages.StringField(4, required=True)
  repoId_uid = _messages.StringField(5)
  repoName = _messages.StringField(6, required=True)


class SourceProjectsReposDeleteRequest(_messages.Message):
  r"""A SourceProjectsReposDeleteRequest object.

  Fields:
    projectId: The ID of the project.
    repoId_uid: A server-assigned, globally unique identifier.
    repoName: The name of the repo. Leave empty for the default repo.
  """

  projectId = _messages.StringField(1, required=True)
  repoId_uid = _messages.StringField(2)
  repoName = _messages.StringField(3, required=True)


class SourceProjectsReposFilesReadFromWorkspaceOrAliasRequest(_messages.Message):
  r"""A SourceProjectsReposFilesReadFromWorkspaceOrAliasRequest object.

  Fields:
    alias: MOVABLE alias to read from, if the workspace doesn't exist.
    pageSize: The maximum number of values to return.
    pageToken: The value of next_page_token from the previous call. Omit for
      the first page.
    path: Path to the file or directory from the root directory of the source
      context. It must not have leading or trailing slashes.
    projectId: The ID of the project.
    repoId_uid: A server-assigned, globally unique identifier.
    repoName: The name of the repo. Leave empty for the default repo.
    startPosition: If path refers to a file, the position of the first byte of
      its contents to return. If path refers to a directory, the position of
      the first entry in the listing. If page_token is specified, this field
      is ignored.
    workspaceName: Workspace to read from, if it exists.
  """

  alias = _messages.StringField(1)
  pageSize = _messages.IntegerField(2)
  pageToken = _messages.StringField(3)
  path = _messages.StringField(4, required=True)
  projectId = _messages.StringField(5, required=True)
  repoId_uid = _messages.StringField(6)
  repoName = _messages.StringField(7, required=True)
  startPosition = _messages.IntegerField(8)
  workspaceName = _messages.StringField(9)


class SourceProjectsReposGetRequest(_messages.Message):
  r"""A SourceProjectsReposGetRequest object.

  Fields:
    projectId: The ID of the project.
    repoId_uid: A server-assigned, globally unique identifier.
    repoName: The name of the repo. Leave empty for the default repo.
  """

  projectId = _messages.StringField(1, required=True)
  repoId_uid = _messages.StringField(2)
  repoName = _messages.StringField(3, required=True)


class SourceProjectsReposListRequest(_messages.Message):
  r"""A SourceProjectsReposListRequest object.

  Fields:
    projectId: The project ID whose repos should be listed.
  """

  projectId = _messages.StringField(1, required=True)


class SourceProjectsReposMergeRequest(_messages.Message):
  r"""A SourceProjectsReposMergeRequest object.

  Fields:
    mergeRequest: A MergeRequest resource to be passed as the request body.
    projectId: The ID of the project.
    repoName: The name of the repo. Leave empty for the default repo.
  """

  mergeRequest = _messages.MessageField('MergeRequest', 1)
  projectId = _messages.StringField(2, required=True)
  repoName = _messages.StringField(3, required=True)


class SourceProjectsReposRevisionsFilesGetRequest(_messages.Message):
  r"""A SourceProjectsReposRevisionsFilesGetRequest object.

  Enums:
    SourceContextCloudRepoAliasContextKindValueValuesEnum: The alias kind.
    SourceContextGerritAliasContextKindValueValuesEnum: The alias kind.

  Fields:
    pageSize: The maximum number of values to return.
    pageToken: The value of next_page_token from the previous call. Omit for
      the first page, or if using start_index.
    path: Path to the file or directory from the root directory of the source
      context. It must not have leading or trailing slashes.
    projectId: The ID of the project.
    repoName: The name of the repo. Leave empty for the default repo.
    revisionId: A revision ID.
    sourceContext_cloudRepo_aliasContext_kind: The alias kind.
    sourceContext_cloudRepo_aliasContext_name: The alias name.
    sourceContext_cloudRepo_aliasName: The name of an alias (branch, tag,
      etc.).
    sourceContext_cloudRepo_repoId_uid: A server-assigned, globally unique
      identifier.
    sourceContext_cloudWorkspace_snapshotId: The ID of the snapshot. An empty
      snapshot_id refers to the most recent snapshot.
    sourceContext_cloudWorkspace_workspaceId_name: The unique name of the
      workspace within the repo.  This is the name chosen by the client in the
      Source API's CreateWorkspace method.
    sourceContext_cloudWorkspace_workspaceId_repoId_projectRepoId_projectId:
      The ID of the project.
    sourceContext_cloudWorkspace_workspaceId_repoId_projectRepoId_repoName:
      The name of the repo. Leave empty for the default repo.
    sourceContext_cloudWorkspace_workspaceId_repoId_uid: A server-assigned,
      globally unique identifier.
    sourceContext_gerrit_aliasContext_kind: The alias kind.
    sourceContext_gerrit_aliasContext_name: The alias name.
    sourceContext_gerrit_aliasName: The name of an alias (branch, tag, etc.).
    sourceContext_gerrit_gerritProject: The full project name within the host.
      Projects may be nested, so "project/subproject" is a valid project name.
      The "repo name" is hostURI/project.
    sourceContext_gerrit_hostUri: The URI of a running Gerrit instance.
    sourceContext_gerrit_revisionId: A revision (commit) ID.
    sourceContext_git_revisionId: Git commit hash. required.
    sourceContext_git_url: Git repository URL.
    startPosition: If path refers to a file, the position of the first byte of
      its contents to return. If path refers to a directory, the position of
      the first entry in the listing. If page_token is specified, this field
      is ignored.
  """

  class SourceContextCloudRepoAliasContextKindValueValuesEnum(_messages.Enum):
    r"""The alias kind.

    Values:
      ANY: <no description>
      FIXED: <no description>
      MOVABLE: <no description>
      OTHER: <no description>
    """
    ANY = 0
    FIXED = 1
    MOVABLE = 2
    OTHER = 3

  class SourceContextGerritAliasContextKindValueValuesEnum(_messages.Enum):
    r"""The alias kind.

    Values:
      ANY: <no description>
      FIXED: <no description>
      MOVABLE: <no description>
      OTHER: <no description>
    """
    ANY = 0
    FIXED = 1
    MOVABLE = 2
    OTHER = 3

  pageSize = _messages.IntegerField(1)
  pageToken = _messages.StringField(2)
  path = _messages.StringField(3, required=True)
  projectId = _messages.StringField(4, required=True)
  repoName = _messages.StringField(5, required=True)
  revisionId = _messages.StringField(6, required=True)
  sourceContext_cloudRepo_aliasContext_kind = _messages.EnumField('SourceContextCloudRepoAliasContextKindValueValuesEnum', 7)
  sourceContext_cloudRepo_aliasContext_name = _messages.StringField(8)
  sourceContext_cloudRepo_aliasName = _messages.StringField(9)
  sourceContext_cloudRepo_repoId_uid = _messages.StringField(10)
  sourceContext_cloudWorkspace_snapshotId = _messages.StringField(11)
  sourceContext_cloudWorkspace_workspaceId_name = _messages.StringField(12)
  sourceContext_cloudWorkspace_workspaceId_repoId_projectRepoId_projectId = _messages.StringField(13)
  sourceContext_cloudWorkspace_workspaceId_repoId_projectRepoId_repoName = _messages.StringField(14)
  sourceContext_cloudWorkspace_workspaceId_repoId_uid = _messages.StringField(15)
  sourceContext_gerrit_aliasContext_kind = _messages.EnumField('SourceContextGerritAliasContextKindValueValuesEnum', 16)
  sourceContext_gerrit_aliasContext_name = _messages.StringField(17)
  sourceContext_gerrit_aliasName = _messages.StringField(18)
  sourceContext_gerrit_gerritProject = _messages.StringField(19)
  sourceContext_gerrit_hostUri = _messages.StringField(20)
  sourceContext_gerrit_revisionId = _messages.StringField(21)
  sourceContext_git_revisionId = _messages.StringField(22)
  sourceContext_git_url = _messages.StringField(23)
  startPosition = _messages.IntegerField(24)


class SourceProjectsReposRevisionsGetBatchGetRequest(_messages.Message):
  r"""A SourceProjectsReposRevisionsGetBatchGetRequest object.

  Fields:
    projectId: The ID of the project.
    repoId_uid: A server-assigned, globally unique identifier.
    repoName: The name of the repo. Leave empty for the default repo.
    revisionIds: The revision IDs to retrieve.
  """

  projectId = _messages.StringField(1, required=True)
  repoId_uid = _messages.StringField(2)
  repoName = _messages.StringField(3, required=True)
  revisionIds = _messages.StringField(4, repeated=True)


class SourceProjectsReposRevisionsGetRequest(_messages.Message):
  r"""A SourceProjectsReposRevisionsGetRequest object.

  Fields:
    projectId: The ID of the project.
    repoId_uid: A server-assigned, globally unique identifier.
    repoName: The name of the repo. Leave empty for the default repo.
    revisionId: The ID of the revision.
  """

  projectId = _messages.StringField(1, required=True)
  repoId_uid = _messages.StringField(2)
  repoName = _messages.StringField(3, required=True)
  revisionId = _messages.StringField(4, required=True)


class SourceProjectsReposRevisionsListFilesRequest(_messages.Message):
  r"""A SourceProjectsReposRevisionsListFilesRequest object.

  Enums:
    SourceContextCloudRepoAliasContextKindValueValuesEnum: The alias kind.
    SourceContextGerritAliasContextKindValueValuesEnum: The alias kind.

  Fields:
    pageSize: The maximum number of values to return.
    pageToken: The value of next_page_token from the previous call. Omit for
      the first page.
    projectId: The ID of the project.
    repoName: The name of the repo. Leave empty for the default repo.
    revisionId: A revision ID.
    sourceContext_cloudRepo_aliasContext_kind: The alias kind.
    sourceContext_cloudRepo_aliasContext_name: The alias name.
    sourceContext_cloudRepo_aliasName: The name of an alias (branch, tag,
      etc.).
    sourceContext_cloudRepo_repoId_uid: A server-assigned, globally unique
      identifier.
    sourceContext_cloudWorkspace_snapshotId: The ID of the snapshot. An empty
      snapshot_id refers to the most recent snapshot.
    sourceContext_cloudWorkspace_workspaceId_name: The unique name of the
      workspace within the repo.  This is the name chosen by the client in the
      Source API's CreateWorkspace method.
    sourceContext_cloudWorkspace_workspaceId_repoId_projectRepoId_projectId:
      The ID of the project.
    sourceContext_cloudWorkspace_workspaceId_repoId_projectRepoId_repoName:
      The name of the repo. Leave empty for the default repo.
    sourceContext_cloudWorkspace_workspaceId_repoId_uid: A server-assigned,
      globally unique identifier.
    sourceContext_gerrit_aliasContext_kind: The alias kind.
    sourceContext_gerrit_aliasContext_name: The alias name.
    sourceContext_gerrit_aliasName: The name of an alias (branch, tag, etc.).
    sourceContext_gerrit_gerritProject: The full project name within the host.
      Projects may be nested, so "project/subproject" is a valid project name.
      The "repo name" is hostURI/project.
    sourceContext_gerrit_hostUri: The URI of a running Gerrit instance.
    sourceContext_gerrit_revisionId: A revision (commit) ID.
    sourceContext_git_revisionId: Git commit hash. required.
    sourceContext_git_url: Git repository URL.
  """

  class SourceContextCloudRepoAliasContextKindValueValuesEnum(_messages.Enum):
    r"""The alias kind.

    Values:
      ANY: <no description>
      FIXED: <no description>
      MOVABLE: <no description>
      OTHER: <no description>
    """
    ANY = 0
    FIXED = 1
    MOVABLE = 2
    OTHER = 3

  class SourceContextGerritAliasContextKindValueValuesEnum(_messages.Enum):
    r"""The alias kind.

    Values:
      ANY: <no description>
      FIXED: <no description>
      MOVABLE: <no description>
      OTHER: <no description>
    """
    ANY = 0
    FIXED = 1
    MOVABLE = 2
    OTHER = 3

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  projectId = _messages.StringField(3, required=True)
  repoName = _messages.StringField(4, required=True)
  revisionId = _messages.StringField(5, required=True)
  sourceContext_cloudRepo_aliasContext_kind = _messages.EnumField('SourceContextCloudRepoAliasContextKindValueValuesEnum', 6)
  sourceContext_cloudRepo_aliasContext_name = _messages.StringField(7)
  sourceContext_cloudRepo_aliasName = _messages.StringField(8)
  sourceContext_cloudRepo_repoId_uid = _messages.StringField(9)
  sourceContext_cloudWorkspace_snapshotId = _messages.StringField(10)
  sourceContext_cloudWorkspace_workspaceId_name = _messages.StringField(11)
  sourceContext_cloudWorkspace_workspaceId_repoId_projectRepoId_projectId = _messages.StringField(12)
  sourceContext_cloudWorkspace_workspaceId_repoId_projectRepoId_repoName = _messages.StringField(13)
  sourceContext_cloudWorkspace_workspaceId_repoId_uid = _messages.StringField(14)
  sourceContext_gerrit_aliasContext_kind = _messages.EnumField('SourceContextGerritAliasContextKindValueValuesEnum', 15)
  sourceContext_gerrit_aliasContext_name = _messages.StringField(16)
  sourceContext_gerrit_aliasName = _messages.StringField(17)
  sourceContext_gerrit_gerritProject = _messages.StringField(18)
  sourceContext_gerrit_hostUri = _messages.StringField(19)
  sourceContext_gerrit_revisionId = _messages.StringField(20)
  sourceContext_git_revisionId = _messages.StringField(21)
  sourceContext_git_url = _messages.StringField(22)


class SourceProjectsReposRevisionsListRequest(_messages.Message):
  r"""A SourceProjectsReposRevisionsListRequest object.

  Enums:
    WalkDirectionValueValuesEnum: The direction to walk the graph.

  Fields:
    ends: Revision IDs (hexadecimal strings) that specify where the listing
      ends. If this field is present, the listing will contain only revisions
      that are topologically between starts and ends, inclusive.
    pageSize: The maximum number of values to return.
    pageToken: The value of next_page_token from the previous call. Omit for
      the first page.
    path: List only those revisions that modify path.
    projectId: The ID of the project.
    repoId_uid: A server-assigned, globally unique identifier.
    repoName: The name of the repo. Leave empty for the default repo.
    starts: Revision IDs (hexadecimal strings) that specify where the listing
      begins. If empty, the repo heads (revisions with no children) are used.
    walkDirection: The direction to walk the graph.
  """

  class WalkDirectionValueValuesEnum(_messages.Enum):
    r"""The direction to walk the graph.

    Values:
      BACKWARD: <no description>
      FORWARD: <no description>
    """
    BACKWARD = 0
    FORWARD = 1

  ends = _messages.StringField(1, repeated=True)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  path = _messages.StringField(4)
  projectId = _messages.StringField(5, required=True)
  repoId_uid = _messages.StringField(6)
  repoName = _messages.StringField(7, required=True)
  starts = _messages.StringField(8, repeated=True)
  walkDirection = _messages.EnumField('WalkDirectionValueValuesEnum', 9)


class SourceProjectsReposUpdateRequest(_messages.Message):
  r"""A SourceProjectsReposUpdateRequest object.

  Fields:
    projectId: The ID of the project.
    repoName: The name of the repo. Leave empty for the default repo.
    updateRepoRequest: A UpdateRepoRequest resource to be passed as the
      request body.
  """

  projectId = _messages.StringField(1, required=True)
  repoName = _messages.StringField(2, required=True)
  updateRepoRequest = _messages.MessageField('UpdateRepoRequest', 3)


class SourceProjectsReposWorkspacesCommitWorkspaceRequest(_messages.Message):
  r"""A SourceProjectsReposWorkspacesCommitWorkspaceRequest object.

  Fields:
    commitWorkspaceRequest: A CommitWorkspaceRequest resource to be passed as
      the request body.
    name: The unique name of the workspace within the repo.  This is the name
      chosen by the client in the Source API's CreateWorkspace method.
    projectId: The ID of the project.
    repoName: The name of the repo. Leave empty for the default repo.
  """

  commitWorkspaceRequest = _messages.MessageField('CommitWorkspaceRequest', 1)
  name = _messages.StringField(2, required=True)
  projectId = _messages.StringField(3, required=True)
  repoName = _messages.StringField(4, required=True)


class SourceProjectsReposWorkspacesCreateRequest(_messages.Message):
  r"""A SourceProjectsReposWorkspacesCreateRequest object.

  Fields:
    createWorkspaceRequest: A CreateWorkspaceRequest resource to be passed as
      the request body.
    projectId: The ID of the project.
    repoName: The name of the repo. Leave empty for the default repo.
  """

  createWorkspaceRequest = _messages.MessageField('CreateWorkspaceRequest', 1)
  projectId = _messages.StringField(2, required=True)
  repoName = _messages.StringField(3, required=True)


class SourceProjectsReposWorkspacesDeleteRequest(_messages.Message):
  r"""A SourceProjectsReposWorkspacesDeleteRequest object.

  Fields:
    currentSnapshotId: If non-empty, current_snapshot_id must refer to the
      most recent update to the workspace, or ABORTED is returned.
    name: The unique name of the workspace within the repo.  This is the name
      chosen by the client in the Source API's CreateWorkspace method.
    projectId: The ID of the project.
    repoName: The name of the repo. Leave empty for the default repo.
    workspaceId_repoId_uid: A server-assigned, globally unique identifier.
  """

  currentSnapshotId = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  projectId = _messages.StringField(3, required=True)
  repoName = _messages.StringField(4, required=True)
  workspaceId_repoId_uid = _messages.StringField(5)


class SourceProjectsReposWorkspacesFilesGetRequest(_messages.Message):
  r"""A SourceProjectsReposWorkspacesFilesGetRequest object.

  Enums:
    SourceContextCloudRepoAliasContextKindValueValuesEnum: The alias kind.
    SourceContextGerritAliasContextKindValueValuesEnum: The alias kind.

  Fields:
    name: The unique name of the workspace within the repo.  This is the name
      chosen by the client in the Source API's CreateWorkspace method.
    pageSize: The maximum number of values to return.
    pageToken: The value of next_page_token from the previous call. Omit for
      the first page, or if using start_index.
    path: Path to the file or directory from the root directory of the source
      context. It must not have leading or trailing slashes.
    projectId: The ID of the project.
    repoName: The name of the repo. Leave empty for the default repo.
    sourceContext_cloudRepo_aliasContext_kind: The alias kind.
    sourceContext_cloudRepo_aliasContext_name: The alias name.
    sourceContext_cloudRepo_aliasName: The name of an alias (branch, tag,
      etc.).
    sourceContext_cloudRepo_repoId_projectRepoId_projectId: The ID of the
      project.
    sourceContext_cloudRepo_repoId_projectRepoId_repoName: The name of the
      repo. Leave empty for the default repo.
    sourceContext_cloudRepo_repoId_uid: A server-assigned, globally unique
      identifier.
    sourceContext_cloudRepo_revisionId: A revision ID.
    sourceContext_cloudWorkspace_snapshotId: The ID of the snapshot. An empty
      snapshot_id refers to the most recent snapshot.
    sourceContext_cloudWorkspace_workspaceId_repoId_uid: A server-assigned,
      globally unique identifier.
    sourceContext_gerrit_aliasContext_kind: The alias kind.
    sourceContext_gerrit_aliasContext_name: The alias name.
    sourceContext_gerrit_aliasName: The name of an alias (branch, tag, etc.).
    sourceContext_gerrit_gerritProject: The full project name within the host.
      Projects may be nested, so "project/subproject" is a valid project name.
      The "repo name" is hostURI/project.
    sourceContext_gerrit_hostUri: The URI of a running Gerrit instance.
    sourceContext_gerrit_revisionId: A revision (commit) ID.
    sourceContext_git_revisionId: Git commit hash. required.
    sourceContext_git_url: Git repository URL.
    startPosition: If path refers to a file, the position of the first byte of
      its contents to return. If path refers to a directory, the position of
      the first entry in the listing. If page_token is specified, this field
      is ignored.
  """

  class SourceContextCloudRepoAliasContextKindValueValuesEnum(_messages.Enum):
    r"""The alias kind.

    Values:
      ANY: <no description>
      FIXED: <no description>
      MOVABLE: <no description>
      OTHER: <no description>
    """
    ANY = 0
    FIXED = 1
    MOVABLE = 2
    OTHER = 3

  class SourceContextGerritAliasContextKindValueValuesEnum(_messages.Enum):
    r"""The alias kind.

    Values:
      ANY: <no description>
      FIXED: <no description>
      MOVABLE: <no description>
      OTHER: <no description>
    """
    ANY = 0
    FIXED = 1
    MOVABLE = 2
    OTHER = 3

  name = _messages.StringField(1, required=True)
  pageSize = _messages.IntegerField(2)
  pageToken = _messages.StringField(3)
  path = _messages.StringField(4, required=True)
  projectId = _messages.StringField(5, required=True)
  repoName = _messages.StringField(6, required=True)
  sourceContext_cloudRepo_aliasContext_kind = _messages.EnumField('SourceContextCloudRepoAliasContextKindValueValuesEnum', 7)
  sourceContext_cloudRepo_aliasContext_name = _messages.StringField(8)
  sourceContext_cloudRepo_aliasName = _messages.StringField(9)
  sourceContext_cloudRepo_repoId_projectRepoId_projectId = _messages.StringField(10)
  sourceContext_cloudRepo_repoId_projectRepoId_repoName = _messages.StringField(11)
  sourceContext_cloudRepo_repoId_uid = _messages.StringField(12)
  sourceContext_cloudRepo_revisionId = _messages.StringField(13)
  sourceContext_cloudWorkspace_snapshotId = _messages.StringField(14)
  sourceContext_cloudWorkspace_workspaceId_repoId_uid = _messages.StringField(15)
  sourceContext_gerrit_aliasContext_kind = _messages.EnumField('SourceContextGerritAliasContextKindValueValuesEnum', 16)
  sourceContext_gerrit_aliasContext_name = _messages.StringField(17)
  sourceContext_gerrit_aliasName = _messages.StringField(18)
  sourceContext_gerrit_gerritProject = _messages.StringField(19)
  sourceContext_gerrit_hostUri = _messages.StringField(20)
  sourceContext_gerrit_revisionId = _messages.StringField(21)
  sourceContext_git_revisionId = _messages.StringField(22)
  sourceContext_git_url = _messages.StringField(23)
  startPosition = _messages.IntegerField(24)


class SourceProjectsReposWorkspacesGetRequest(_messages.Message):
  r"""A SourceProjectsReposWorkspacesGetRequest object.

  Fields:
    name: The unique name of the workspace within the repo.  This is the name
      chosen by the client in the Source API's CreateWorkspace method.
    projectId: The ID of the project.
    repoName: The name of the repo. Leave empty for the default repo.
    workspaceId_repoId_uid: A server-assigned, globally unique identifier.
  """

  name = _messages.StringField(1, required=True)
  projectId = _messages.StringField(2, required=True)
  repoName = _messages.StringField(3, required=True)
  workspaceId_repoId_uid = _messages.StringField(4)


class SourceProjectsReposWorkspacesListFilesRequest(_messages.Message):
  r"""A SourceProjectsReposWorkspacesListFilesRequest object.

  Enums:
    SourceContextCloudRepoAliasContextKindValueValuesEnum: The alias kind.
    SourceContextGerritAliasContextKindValueValuesEnum: The alias kind.

  Fields:
    name: The unique name of the workspace within the repo.  This is the name
      chosen by the client in the Source API's CreateWorkspace method.
    pageSize: The maximum number of values to return.
    pageToken: The value of next_page_token from the previous call. Omit for
      the first page.
    projectId: The ID of the project.
    repoName: The name of the repo. Leave empty for the default repo.
    sourceContext_cloudRepo_aliasContext_kind: The alias kind.
    sourceContext_cloudRepo_aliasContext_name: The alias name.
    sourceContext_cloudRepo_aliasName: The name of an alias (branch, tag,
      etc.).
    sourceContext_cloudRepo_repoId_projectRepoId_projectId: The ID of the
      project.
    sourceContext_cloudRepo_repoId_projectRepoId_repoName: The name of the
      repo. Leave empty for the default repo.
    sourceContext_cloudRepo_repoId_uid: A server-assigned, globally unique
      identifier.
    sourceContext_cloudRepo_revisionId: A revision ID.
    sourceContext_cloudWorkspace_snapshotId: The ID of the snapshot. An empty
      snapshot_id refers to the most recent snapshot.
    sourceContext_cloudWorkspace_workspaceId_repoId_uid: A server-assigned,
      globally unique identifier.
    sourceContext_gerrit_aliasContext_kind: The alias kind.
    sourceContext_gerrit_aliasContext_name: The alias name.
    sourceContext_gerrit_aliasName: The name of an alias (branch, tag, etc.).
    sourceContext_gerrit_gerritProject: The full project name within the host.
      Projects may be nested, so "project/subproject" is a valid project name.
      The "repo name" is hostURI/project.
    sourceContext_gerrit_hostUri: The URI of a running Gerrit instance.
    sourceContext_gerrit_revisionId: A revision (commit) ID.
    sourceContext_git_revisionId: Git commit hash. required.
    sourceContext_git_url: Git repository URL.
  """

  class SourceContextCloudRepoAliasContextKindValueValuesEnum(_messages.Enum):
    r"""The alias kind.

    Values:
      ANY: <no description>
      FIXED: <no description>
      MOVABLE: <no description>
      OTHER: <no description>
    """
    ANY = 0
    FIXED = 1
    MOVABLE = 2
    OTHER = 3

  class SourceContextGerritAliasContextKindValueValuesEnum(_messages.Enum):
    r"""The alias kind.

    Values:
      ANY: <no description>
      FIXED: <no description>
      MOVABLE: <no description>
      OTHER: <no description>
    """
    ANY = 0
    FIXED = 1
    MOVABLE = 2
    OTHER = 3

  name = _messages.StringField(1, required=True)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  projectId = _messages.StringField(4, required=True)
  repoName = _messages.StringField(5, required=True)
  sourceContext_cloudRepo_aliasContext_kind = _messages.EnumField('SourceContextCloudRepoAliasContextKindValueValuesEnum', 6)
  sourceContext_cloudRepo_aliasContext_name = _messages.StringField(7)
  sourceContext_cloudRepo_aliasName = _messages.StringField(8)
  sourceContext_cloudRepo_repoId_projectRepoId_projectId = _messages.StringField(9)
  sourceContext_cloudRepo_repoId_projectRepoId_repoName = _messages.StringField(10)
  sourceContext_cloudRepo_repoId_uid = _messages.StringField(11)
  sourceContext_cloudRepo_revisionId = _messages.StringField(12)
  sourceContext_cloudWorkspace_snapshotId = _messages.StringField(13)
  sourceContext_cloudWorkspace_workspaceId_repoId_uid = _messages.StringField(14)
  sourceContext_gerrit_aliasContext_kind = _messages.EnumField('SourceContextGerritAliasContextKindValueValuesEnum', 15)
  sourceContext_gerrit_aliasContext_name = _messages.StringField(16)
  sourceContext_gerrit_aliasName = _messages.StringField(17)
  sourceContext_gerrit_gerritProject = _messages.StringField(18)
  sourceContext_gerrit_hostUri = _messages.StringField(19)
  sourceContext_gerrit_revisionId = _messages.StringField(20)
  sourceContext_git_revisionId = _messages.StringField(21)
  sourceContext_git_url = _messages.StringField(22)


class SourceProjectsReposWorkspacesListRequest(_messages.Message):
  r"""A SourceProjectsReposWorkspacesListRequest object.

  Enums:
    ViewValueValuesEnum: Specifies which parts of the Workspace resource
      should be returned in the response.

  Fields:
    projectId: The ID of the project.
    repoId_uid: A server-assigned, globally unique identifier.
    repoName: The name of the repo. Leave empty for the default repo.
    view: Specifies which parts of the Workspace resource should be returned
      in the response.
  """

  class ViewValueValuesEnum(_messages.Enum):
    r"""Specifies which parts of the Workspace resource should be returned in
    the response.

    Values:
      STANDARD: <no description>
      MINIMAL: <no description>
      FULL: <no description>
    """
    STANDARD = 0
    MINIMAL = 1
    FULL = 2

  projectId = _messages.StringField(1, required=True)
  repoId_uid = _messages.StringField(2)
  repoName = _messages.StringField(3, required=True)
  view = _messages.EnumField('ViewValueValuesEnum', 4)


class SourceProjectsReposWorkspacesModifyWorkspaceRequest(_messages.Message):
  r"""A SourceProjectsReposWorkspacesModifyWorkspaceRequest object.

  Fields:
    modifyWorkspaceRequest: A ModifyWorkspaceRequest resource to be passed as
      the request body.
    name: The unique name of the workspace within the repo.  This is the name
      chosen by the client in the Source API's CreateWorkspace method.
    projectId: The ID of the project.
    repoName: The name of the repo. Leave empty for the default repo.
  """

  modifyWorkspaceRequest = _messages.MessageField('ModifyWorkspaceRequest', 1)
  name = _messages.StringField(2, required=True)
  projectId = _messages.StringField(3, required=True)
  repoName = _messages.StringField(4, required=True)


class SourceProjectsReposWorkspacesRefreshWorkspaceRequest(_messages.Message):
  r"""A SourceProjectsReposWorkspacesRefreshWorkspaceRequest object.

  Fields:
    name: The unique name of the workspace within the repo.  This is the name
      chosen by the client in the Source API's CreateWorkspace method.
    projectId: The ID of the project.
    refreshWorkspaceRequest: A RefreshWorkspaceRequest resource to be passed
      as the request body.
    repoName: The name of the repo. Leave empty for the default repo.
  """

  name = _messages.StringField(1, required=True)
  projectId = _messages.StringField(2, required=True)
  refreshWorkspaceRequest = _messages.MessageField('RefreshWorkspaceRequest', 3)
  repoName = _messages.StringField(4, required=True)


class SourceProjectsReposWorkspacesResolveFilesRequest(_messages.Message):
  r"""A SourceProjectsReposWorkspacesResolveFilesRequest object.

  Fields:
    name: The unique name of the workspace within the repo.  This is the name
      chosen by the client in the Source API's CreateWorkspace method.
    projectId: The ID of the project.
    repoName: The name of the repo. Leave empty for the default repo.
    resolveFilesRequest: A ResolveFilesRequest resource to be passed as the
      request body.
  """

  name = _messages.StringField(1, required=True)
  projectId = _messages.StringField(2, required=True)
  repoName = _messages.StringField(3, required=True)
  resolveFilesRequest = _messages.MessageField('ResolveFilesRequest', 4)


class SourceProjectsReposWorkspacesRevertRefreshRequest(_messages.Message):
  r"""A SourceProjectsReposWorkspacesRevertRefreshRequest object.

  Fields:
    name: The unique name of the workspace within the repo.  This is the name
      chosen by the client in the Source API's CreateWorkspace method.
    projectId: The ID of the project.
    repoName: The name of the repo. Leave empty for the default repo.
    revertRefreshRequest: A RevertRefreshRequest resource to be passed as the
      request body.
  """

  name = _messages.StringField(1, required=True)
  projectId = _messages.StringField(2, required=True)
  repoName = _messages.StringField(3, required=True)
  revertRefreshRequest = _messages.MessageField('RevertRefreshRequest', 4)


class SourceProjectsReposWorkspacesSnapshotsFilesGetRequest(_messages.Message):
  r"""A SourceProjectsReposWorkspacesSnapshotsFilesGetRequest object.

  Enums:
    SourceContextCloudRepoAliasContextKindValueValuesEnum: The alias kind.
    SourceContextGerritAliasContextKindValueValuesEnum: The alias kind.

  Fields:
    name: The unique name of the workspace within the repo.  This is the name
      chosen by the client in the Source API's CreateWorkspace method.
    pageSize: The maximum number of values to return.
    pageToken: The value of next_page_token from the previous call. Omit for
      the first page, or if using start_index.
    path: Path to the file or directory from the root directory of the source
      context. It must not have leading or trailing slashes.
    projectId: The ID of the project.
    repoName: The name of the repo. Leave empty for the default repo.
    snapshotId: The ID of the snapshot. An empty snapshot_id refers to the
      most recent snapshot.
    sourceContext_cloudRepo_aliasContext_kind: The alias kind.
    sourceContext_cloudRepo_aliasContext_name: The alias name.
    sourceContext_cloudRepo_aliasName: The name of an alias (branch, tag,
      etc.).
    sourceContext_cloudRepo_repoId_projectRepoId_projectId: The ID of the
      project.
    sourceContext_cloudRepo_repoId_projectRepoId_repoName: The name of the
      repo. Leave empty for the default repo.
    sourceContext_cloudRepo_repoId_uid: A server-assigned, globally unique
      identifier.
    sourceContext_cloudRepo_revisionId: A revision ID.
    sourceContext_cloudWorkspace_workspaceId_repoId_uid: A server-assigned,
      globally unique identifier.
    sourceContext_gerrit_aliasContext_kind: The alias kind.
    sourceContext_gerrit_aliasContext_name: The alias name.
    sourceContext_gerrit_aliasName: The name of an alias (branch, tag, etc.).
    sourceContext_gerrit_gerritProject: The full project name within the host.
      Projects may be nested, so "project/subproject" is a valid project name.
      The "repo name" is hostURI/project.
    sourceContext_gerrit_hostUri: The URI of a running Gerrit instance.
    sourceContext_gerrit_revisionId: A revision (commit) ID.
    sourceContext_git_revisionId: Git commit hash. required.
    sourceContext_git_url: Git repository URL.
    startPosition: If path refers to a file, the position of the first byte of
      its contents to return. If path refers to a directory, the position of
      the first entry in the listing. If page_token is specified, this field
      is ignored.
  """

  class SourceContextCloudRepoAliasContextKindValueValuesEnum(_messages.Enum):
    r"""The alias kind.

    Values:
      ANY: <no description>
      FIXED: <no description>
      MOVABLE: <no description>
      OTHER: <no description>
    """
    ANY = 0
    FIXED = 1
    MOVABLE = 2
    OTHER = 3

  class SourceContextGerritAliasContextKindValueValuesEnum(_messages.Enum):
    r"""The alias kind.

    Values:
      ANY: <no description>
      FIXED: <no description>
      MOVABLE: <no description>
      OTHER: <no description>
    """
    ANY = 0
    FIXED = 1
    MOVABLE = 2
    OTHER = 3

  name = _messages.StringField(1, required=True)
  pageSize = _messages.IntegerField(2)
  pageToken = _messages.StringField(3)
  path = _messages.StringField(4, required=True)
  projectId = _messages.StringField(5, required=True)
  repoName = _messages.StringField(6, required=True)
  snapshotId = _messages.StringField(7, required=True)
  sourceContext_cloudRepo_aliasContext_kind = _messages.EnumField('SourceContextCloudRepoAliasContextKindValueValuesEnum', 8)
  sourceContext_cloudRepo_aliasContext_name = _messages.StringField(9)
  sourceContext_cloudRepo_aliasName = _messages.StringField(10)
  sourceContext_cloudRepo_repoId_projectRepoId_projectId = _messages.StringField(11)
  sourceContext_cloudRepo_repoId_projectRepoId_repoName = _messages.StringField(12)
  sourceContext_cloudRepo_repoId_uid = _messages.StringField(13)
  sourceContext_cloudRepo_revisionId = _messages.StringField(14)
  sourceContext_cloudWorkspace_workspaceId_repoId_uid = _messages.StringField(15)
  sourceContext_gerrit_aliasContext_kind = _messages.EnumField('SourceContextGerritAliasContextKindValueValuesEnum', 16)
  sourceContext_gerrit_aliasContext_name = _messages.StringField(17)
  sourceContext_gerrit_aliasName = _messages.StringField(18)
  sourceContext_gerrit_gerritProject = _messages.StringField(19)
  sourceContext_gerrit_hostUri = _messages.StringField(20)
  sourceContext_gerrit_revisionId = _messages.StringField(21)
  sourceContext_git_revisionId = _messages.StringField(22)
  sourceContext_git_url = _messages.StringField(23)
  startPosition = _messages.IntegerField(24)


class SourceProjectsReposWorkspacesSnapshotsGetRequest(_messages.Message):
  r"""A SourceProjectsReposWorkspacesSnapshotsGetRequest object.

  Fields:
    name: The unique name of the workspace within the repo.  This is the name
      chosen by the client in the Source API's CreateWorkspace method.
    projectId: The ID of the project.
    repoName: The name of the repo. Leave empty for the default repo.
    snapshotId: The ID of the snapshot to get. If empty, the most recent
      snapshot is retrieved.
    workspaceId_repoId_uid: A server-assigned, globally unique identifier.
  """

  name = _messages.StringField(1, required=True)
  projectId = _messages.StringField(2, required=True)
  repoName = _messages.StringField(3, required=True)
  snapshotId = _messages.StringField(4, required=True)
  workspaceId_repoId_uid = _messages.StringField(5)


class SourceProjectsReposWorkspacesSnapshotsListFilesRequest(_messages.Message):
  r"""A SourceProjectsReposWorkspacesSnapshotsListFilesRequest object.

  Enums:
    SourceContextCloudRepoAliasContextKindValueValuesEnum: The alias kind.
    SourceContextGerritAliasContextKindValueValuesEnum: The alias kind.

  Fields:
    name: The unique name of the workspace within the repo.  This is the name
      chosen by the client in the Source API's CreateWorkspace method.
    pageSize: The maximum number of values to return.
    pageToken: The value of next_page_token from the previous call. Omit for
      the first page.
    projectId: The ID of the project.
    repoName: The name of the repo. Leave empty for the default repo.
    snapshotId: The ID of the snapshot. An empty snapshot_id refers to the
      most recent snapshot.
    sourceContext_cloudRepo_aliasContext_kind: The alias kind.
    sourceContext_cloudRepo_aliasContext_name: The alias name.
    sourceContext_cloudRepo_aliasName: The name of an alias (branch, tag,
      etc.).
    sourceContext_cloudRepo_repoId_projectRepoId_projectId: The ID of the
      project.
    sourceContext_cloudRepo_repoId_projectRepoId_repoName: The name of the
      repo. Leave empty for the default repo.
    sourceContext_cloudRepo_repoId_uid: A server-assigned, globally unique
      identifier.
    sourceContext_cloudRepo_revisionId: A revision ID.
    sourceContext_cloudWorkspace_workspaceId_repoId_uid: A server-assigned,
      globally unique identifier.
    sourceContext_gerrit_aliasContext_kind: The alias kind.
    sourceContext_gerrit_aliasContext_name: The alias name.
    sourceContext_gerrit_aliasName: The name of an alias (branch, tag, etc.).
    sourceContext_gerrit_gerritProject: The full project name within the host.
      Projects may be nested, so "project/subproject" is a valid project name.
      The "repo name" is hostURI/project.
    sourceContext_gerrit_hostUri: The URI of a running Gerrit instance.
    sourceContext_gerrit_revisionId: A revision (commit) ID.
    sourceContext_git_revisionId: Git commit hash. required.
    sourceContext_git_url: Git repository URL.
  """

  class SourceContextCloudRepoAliasContextKindValueValuesEnum(_messages.Enum):
    r"""The alias kind.

    Values:
      ANY: <no description>
      FIXED: <no description>
      MOVABLE: <no description>
      OTHER: <no description>
    """
    ANY = 0
    FIXED = 1
    MOVABLE = 2
    OTHER = 3

  class SourceContextGerritAliasContextKindValueValuesEnum(_messages.Enum):
    r"""The alias kind.

    Values:
      ANY: <no description>
      FIXED: <no description>
      MOVABLE: <no description>
      OTHER: <no description>
    """
    ANY = 0
    FIXED = 1
    MOVABLE = 2
    OTHER = 3

  name = _messages.StringField(1, required=True)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  projectId = _messages.StringField(4, required=True)
  repoName = _messages.StringField(5, required=True)
  snapshotId = _messages.StringField(6, required=True)
  sourceContext_cloudRepo_aliasContext_kind = _messages.EnumField('SourceContextCloudRepoAliasContextKindValueValuesEnum', 7)
  sourceContext_cloudRepo_aliasContext_name = _messages.StringField(8)
  sourceContext_cloudRepo_aliasName = _messages.StringField(9)
  sourceContext_cloudRepo_repoId_projectRepoId_projectId = _messages.StringField(10)
  sourceContext_cloudRepo_repoId_projectRepoId_repoName = _messages.StringField(11)
  sourceContext_cloudRepo_repoId_uid = _messages.StringField(12)
  sourceContext_cloudRepo_revisionId = _messages.StringField(13)
  sourceContext_cloudWorkspace_workspaceId_repoId_uid = _messages.StringField(14)
  sourceContext_gerrit_aliasContext_kind = _messages.EnumField('SourceContextGerritAliasContextKindValueValuesEnum', 15)
  sourceContext_gerrit_aliasContext_name = _messages.StringField(16)
  sourceContext_gerrit_aliasName = _messages.StringField(17)
  sourceContext_gerrit_gerritProject = _messages.StringField(18)
  sourceContext_gerrit_hostUri = _messages.StringField(19)
  sourceContext_gerrit_revisionId = _messages.StringField(20)
  sourceContext_git_revisionId = _messages.StringField(21)
  sourceContext_git_url = _messages.StringField(22)


class SourceProjectsReposWorkspacesSnapshotsListRequest(_messages.Message):
  r"""A SourceProjectsReposWorkspacesSnapshotsListRequest object.

  Fields:
    name: The unique name of the workspace within the repo.  This is the name
      chosen by the client in the Source API's CreateWorkspace method.
    pageSize: The maximum number of values to return.
    pageToken: The value of next_page_token from the previous call. Omit for
      the first page.
    projectId: The ID of the project.
    repoName: The name of the repo. Leave empty for the default repo.
    workspaceId_repoId_uid: A server-assigned, globally unique identifier.
  """

  name = _messages.StringField(1, required=True)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  projectId = _messages.StringField(4, required=True)
  repoName = _messages.StringField(5, required=True)
  workspaceId_repoId_uid = _messages.StringField(6)


class StandardQueryParameters(_messages.Message):
  r"""Query parameters accepted by all methods.

  Enums:
    FXgafvValueValuesEnum: V1 error format.
    AltValueValuesEnum: Data format for response.

  Fields:
    f__xgafv: V1 error format.
    access_token: OAuth access token.
    alt: Data format for response.
    bearer_token: OAuth bearer token.
    callback: JSONP
    fields: Selector specifying which fields to include in a partial response.
    key: API key. Your API key identifies your project and provides you with
      API access, quota, and reports. Required unless you provide an OAuth 2.0
      token.
    oauth_token: OAuth 2.0 token for the current user.
    pp: Pretty-print response.
    prettyPrint: Returns response with indentations and line breaks.
    quotaUser: Available to use for quota purposes for server-side
      applications. Can be any arbitrary string assigned to a user, but should
      not exceed 40 characters.
    trace: A tracing token of the form "token:<tokenid>" to include in api
      requests.
    uploadType: Legacy upload protocol for media (e.g. "media", "multipart").
    upload_protocol: Upload protocol for media (e.g. "raw", "multipart").
  """

  class AltValueValuesEnum(_messages.Enum):
    r"""Data format for response.

    Values:
      json: Responses with Content-Type of application/json
      media: Media download with context-dependent Content-Type
      proto: Responses with Content-Type of application/x-protobuf
    """
    json = 0
    media = 1
    proto = 2

  class FXgafvValueValuesEnum(_messages.Enum):
    r"""V1 error format.

    Values:
      _1: v1 error format
      _2: v2 error format
    """
    _1 = 0
    _2 = 1

  f__xgafv = _messages.EnumField('FXgafvValueValuesEnum', 1)
  access_token = _messages.StringField(2)
  alt = _messages.EnumField('AltValueValuesEnum', 3, default=u'json')
  bearer_token = _messages.StringField(4)
  callback = _messages.StringField(5)
  fields = _messages.StringField(6)
  key = _messages.StringField(7)
  oauth_token = _messages.StringField(8)
  pp = _messages.BooleanField(9, default=True)
  prettyPrint = _messages.BooleanField(10, default=True)
  quotaUser = _messages.StringField(11)
  trace = _messages.StringField(12)
  uploadType = _messages.StringField(13)
  upload_protocol = _messages.StringField(14)


class UpdateRepoRequest(_messages.Message):
  r"""Request for UpdateRepo.

  Fields:
    repoId: The ID of the repo to be updated.
    repoName: DEPRECATED and will be removed (see b/32283418); leave unset.
      Renames the repo. repo_name cannot already be in use by a LIVE repo
      within the project. This field is ignored if left blank or set to the
      empty string. If you want to rename a repo to "default," you need to
      explicitly set that value here.
    repoSyncConfig: Sets or updates the RepoSync config. When the
      repo_sync_config field is not set it actually clears the repo sync
      config.
  """

  repoId = _messages.MessageField('RepoId', 1)
  repoName = _messages.StringField(2)
  repoSyncConfig = _messages.MessageField('RepoSyncConfig', 3)


class Workspace(_messages.Message):
  r"""A Cloud Workspace stores modified files before they are committed to a
  repo. This message contains metadata. Use the Read or
  ReadFromWorkspaceOrAlias methods to read files from the workspace, and use
  ModifyWorkspace to change files.

  Fields:
    alias: The alias associated with the workspace. When the workspace is
      committed, this alias will be moved to point to the new revision.
    baseline: The revision of the workspace's alias when the workspace was
      created.
    changedFiles: The set of files modified in this workspace.
    currentSnapshotId: If non-empty, current_snapshot_id refers to the most
      recent update to the workspace.
    id: The ID of the workspace.
    mergeInfo: Information needed to manage a refresh or merge operation.
      Present only during a merge (i.e. after a call to Merge) or a call to
      RefreshWorkspace which results in conflicts.
  """

  alias = _messages.StringField(1)
  baseline = _messages.StringField(2)
  changedFiles = _messages.MessageField('ChangedFileInfo', 3, repeated=True)
  currentSnapshotId = _messages.StringField(4)
  id = _messages.MessageField('CloudWorkspaceId', 5)
  mergeInfo = _messages.MessageField('MergeInfo', 6)


class WriteAction(_messages.Message):
  r"""Create or modify a file.

  Enums:
    ModeValueValuesEnum: The new mode of the file.

  Fields:
    contents: The new contents of the file.
    mode: The new mode of the file.
    path: The path of the file to write.
  """

  class ModeValueValuesEnum(_messages.Enum):
    r"""The new mode of the file.

    Values:
      FILE_MODE_UNSPECIFIED: No file mode was specified.
      NORMAL: Neither a symbolic link nor executable.
      SYMLINK: A symbolic link.
      EXECUTABLE: An executable.
    """
    FILE_MODE_UNSPECIFIED = 0
    NORMAL = 1
    SYMLINK = 2
    EXECUTABLE = 3

  contents = _messages.BytesField(1)
  mode = _messages.EnumField('ModeValueValuesEnum', 2)
  path = _messages.StringField(3)


encoding.AddCustomJsonFieldMapping(
    StandardQueryParameters, 'f__xgafv', '$.xgafv')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_1', '1')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_2', '2')
