#!/usr/bin/env python

"""
Copyright (c) 2014-2020 Maltrail developers (https://github.com/stamparm/maltrail/)
See the file 'LICENSE' for copying permission
"""

import re

from core.common import retrieve_content

__url__ = "https://www.malwaredomainlist.com/hostslist/hosts.txt"
__check__ = "malwaredomainlist"
__info__ = "malware"
__reference__ = "malwaredomainlist.com"

def fetch():
    retval = {}
    content = retrieve_content(__url__)

    if __check__ in content:
        for line in content.split('\n'):
            line = line.strip()
            if not line or line.startswith('#') or '.' not in line:
                continue
            match = re.search(r"\A127.0.0.1\s+(.+)\Z", line)
            if match:
                retval[match.group(1)] = (__info__, __reference__)

    return retval
