﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/appsync/AppSync_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/appsync/model/EvaluateCodeErrorDetail.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <utility>

namespace Aws
{
template<typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils
{
namespace Json
{
  class JsonValue;
} // namespace Json
} // namespace Utils
namespace AppSync
{
namespace Model
{
  class EvaluateCodeResult
  {
  public:
    AWS_APPSYNC_API EvaluateCodeResult();
    AWS_APPSYNC_API EvaluateCodeResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
    AWS_APPSYNC_API EvaluateCodeResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);


    /**
     * <p>The result of the evaluation operation.</p>
     */
    inline const Aws::String& GetEvaluationResult() const{ return m_evaluationResult; }

    /**
     * <p>The result of the evaluation operation.</p>
     */
    inline void SetEvaluationResult(const Aws::String& value) { m_evaluationResult = value; }

    /**
     * <p>The result of the evaluation operation.</p>
     */
    inline void SetEvaluationResult(Aws::String&& value) { m_evaluationResult = std::move(value); }

    /**
     * <p>The result of the evaluation operation.</p>
     */
    inline void SetEvaluationResult(const char* value) { m_evaluationResult.assign(value); }

    /**
     * <p>The result of the evaluation operation.</p>
     */
    inline EvaluateCodeResult& WithEvaluationResult(const Aws::String& value) { SetEvaluationResult(value); return *this;}

    /**
     * <p>The result of the evaluation operation.</p>
     */
    inline EvaluateCodeResult& WithEvaluationResult(Aws::String&& value) { SetEvaluationResult(std::move(value)); return *this;}

    /**
     * <p>The result of the evaluation operation.</p>
     */
    inline EvaluateCodeResult& WithEvaluationResult(const char* value) { SetEvaluationResult(value); return *this;}


    /**
     * <p>Contains the payload of the response error.</p>
     */
    inline const EvaluateCodeErrorDetail& GetError() const{ return m_error; }

    /**
     * <p>Contains the payload of the response error.</p>
     */
    inline void SetError(const EvaluateCodeErrorDetail& value) { m_error = value; }

    /**
     * <p>Contains the payload of the response error.</p>
     */
    inline void SetError(EvaluateCodeErrorDetail&& value) { m_error = std::move(value); }

    /**
     * <p>Contains the payload of the response error.</p>
     */
    inline EvaluateCodeResult& WithError(const EvaluateCodeErrorDetail& value) { SetError(value); return *this;}

    /**
     * <p>Contains the payload of the response error.</p>
     */
    inline EvaluateCodeResult& WithError(EvaluateCodeErrorDetail&& value) { SetError(std::move(value)); return *this;}


    /**
     * <p>A list of logs that were generated by calls to <code>util.log.info</code> and
     * <code>util.log.error</code> in the evaluated code.</p>
     */
    inline const Aws::Vector<Aws::String>& GetLogs() const{ return m_logs; }

    /**
     * <p>A list of logs that were generated by calls to <code>util.log.info</code> and
     * <code>util.log.error</code> in the evaluated code.</p>
     */
    inline void SetLogs(const Aws::Vector<Aws::String>& value) { m_logs = value; }

    /**
     * <p>A list of logs that were generated by calls to <code>util.log.info</code> and
     * <code>util.log.error</code> in the evaluated code.</p>
     */
    inline void SetLogs(Aws::Vector<Aws::String>&& value) { m_logs = std::move(value); }

    /**
     * <p>A list of logs that were generated by calls to <code>util.log.info</code> and
     * <code>util.log.error</code> in the evaluated code.</p>
     */
    inline EvaluateCodeResult& WithLogs(const Aws::Vector<Aws::String>& value) { SetLogs(value); return *this;}

    /**
     * <p>A list of logs that were generated by calls to <code>util.log.info</code> and
     * <code>util.log.error</code> in the evaluated code.</p>
     */
    inline EvaluateCodeResult& WithLogs(Aws::Vector<Aws::String>&& value) { SetLogs(std::move(value)); return *this;}

    /**
     * <p>A list of logs that were generated by calls to <code>util.log.info</code> and
     * <code>util.log.error</code> in the evaluated code.</p>
     */
    inline EvaluateCodeResult& AddLogs(const Aws::String& value) { m_logs.push_back(value); return *this; }

    /**
     * <p>A list of logs that were generated by calls to <code>util.log.info</code> and
     * <code>util.log.error</code> in the evaluated code.</p>
     */
    inline EvaluateCodeResult& AddLogs(Aws::String&& value) { m_logs.push_back(std::move(value)); return *this; }

    /**
     * <p>A list of logs that were generated by calls to <code>util.log.info</code> and
     * <code>util.log.error</code> in the evaluated code.</p>
     */
    inline EvaluateCodeResult& AddLogs(const char* value) { m_logs.push_back(value); return *this; }


    
    inline const Aws::String& GetRequestId() const{ return m_requestId; }

    
    inline void SetRequestId(const Aws::String& value) { m_requestId = value; }

    
    inline void SetRequestId(Aws::String&& value) { m_requestId = std::move(value); }

    
    inline void SetRequestId(const char* value) { m_requestId.assign(value); }

    
    inline EvaluateCodeResult& WithRequestId(const Aws::String& value) { SetRequestId(value); return *this;}

    
    inline EvaluateCodeResult& WithRequestId(Aws::String&& value) { SetRequestId(std::move(value)); return *this;}

    
    inline EvaluateCodeResult& WithRequestId(const char* value) { SetRequestId(value); return *this;}

  private:

    Aws::String m_evaluationResult;

    EvaluateCodeErrorDetail m_error;

    Aws::Vector<Aws::String> m_logs;

    Aws::String m_requestId;
  };

} // namespace Model
} // namespace AppSync
} // namespace Aws
