﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/identitystore/IdentityStore_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/identitystore/model/ConflictExceptionReason.h>
#include <utility>

namespace Aws
{
namespace Utils
{
namespace Json
{
  class JsonValue;
  class JsonView;
} // namespace Json
} // namespace Utils
namespace IdentityStore
{
namespace Model
{

  /**
   * <p>This request cannot be completed for one of the following reasons:</p> <ul>
   * <li> <p>Performing the requested operation would violate an existing uniqueness
   * claim in the identity store. Resolve the conflict before retrying this
   * request.</p> </li> <li> <p>The requested resource was being concurrently
   * modified by another request.</p> </li> </ul><p><h3>See Also:</h3>   <a
   * href="http://docs.aws.amazon.com/goto/WebAPI/identitystore-2020-06-15/ConflictException">AWS
   * API Reference</a></p>
   */
  class ConflictException
  {
  public:
    AWS_IDENTITYSTORE_API ConflictException();
    AWS_IDENTITYSTORE_API ConflictException(Aws::Utils::Json::JsonView jsonValue);
    AWS_IDENTITYSTORE_API ConflictException& operator=(Aws::Utils::Json::JsonView jsonValue);
    AWS_IDENTITYSTORE_API Aws::Utils::Json::JsonValue Jsonize() const;


    
    inline const Aws::String& GetMessage() const{ return m_message; }

    
    inline bool MessageHasBeenSet() const { return m_messageHasBeenSet; }

    
    inline void SetMessage(const Aws::String& value) { m_messageHasBeenSet = true; m_message = value; }

    
    inline void SetMessage(Aws::String&& value) { m_messageHasBeenSet = true; m_message = std::move(value); }

    
    inline void SetMessage(const char* value) { m_messageHasBeenSet = true; m_message.assign(value); }

    
    inline ConflictException& WithMessage(const Aws::String& value) { SetMessage(value); return *this;}

    
    inline ConflictException& WithMessage(Aws::String&& value) { SetMessage(std::move(value)); return *this;}

    
    inline ConflictException& WithMessage(const char* value) { SetMessage(value); return *this;}


    /**
     * <p>The identifier for each request. This value is a globally unique ID that is
     * generated by the identity store service for each sent request, and is then
     * returned inside the exception if the request fails.</p>
     */
    inline const Aws::String& GetRequestId() const{ return m_requestId; }

    /**
     * <p>The identifier for each request. This value is a globally unique ID that is
     * generated by the identity store service for each sent request, and is then
     * returned inside the exception if the request fails.</p>
     */
    inline bool RequestIdHasBeenSet() const { return m_requestIdHasBeenSet; }

    /**
     * <p>The identifier for each request. This value is a globally unique ID that is
     * generated by the identity store service for each sent request, and is then
     * returned inside the exception if the request fails.</p>
     */
    inline void SetRequestId(const Aws::String& value) { m_requestIdHasBeenSet = true; m_requestId = value; }

    /**
     * <p>The identifier for each request. This value is a globally unique ID that is
     * generated by the identity store service for each sent request, and is then
     * returned inside the exception if the request fails.</p>
     */
    inline void SetRequestId(Aws::String&& value) { m_requestIdHasBeenSet = true; m_requestId = std::move(value); }

    /**
     * <p>The identifier for each request. This value is a globally unique ID that is
     * generated by the identity store service for each sent request, and is then
     * returned inside the exception if the request fails.</p>
     */
    inline void SetRequestId(const char* value) { m_requestIdHasBeenSet = true; m_requestId.assign(value); }

    /**
     * <p>The identifier for each request. This value is a globally unique ID that is
     * generated by the identity store service for each sent request, and is then
     * returned inside the exception if the request fails.</p>
     */
    inline ConflictException& WithRequestId(const Aws::String& value) { SetRequestId(value); return *this;}

    /**
     * <p>The identifier for each request. This value is a globally unique ID that is
     * generated by the identity store service for each sent request, and is then
     * returned inside the exception if the request fails.</p>
     */
    inline ConflictException& WithRequestId(Aws::String&& value) { SetRequestId(std::move(value)); return *this;}

    /**
     * <p>The identifier for each request. This value is a globally unique ID that is
     * generated by the identity store service for each sent request, and is then
     * returned inside the exception if the request fails.</p>
     */
    inline ConflictException& WithRequestId(const char* value) { SetRequestId(value); return *this;}


    /**
     * <p>This request cannot be completed for one of the following reasons:</p> <ul>
     * <li> <p>Performing the requested operation would violate an existing uniqueness
     * claim in the identity store. Resolve the conflict before retrying this
     * request.</p> </li> <li> <p>The requested resource was being concurrently
     * modified by another request.</p> </li> </ul>
     */
    inline const ConflictExceptionReason& GetReason() const{ return m_reason; }

    /**
     * <p>This request cannot be completed for one of the following reasons:</p> <ul>
     * <li> <p>Performing the requested operation would violate an existing uniqueness
     * claim in the identity store. Resolve the conflict before retrying this
     * request.</p> </li> <li> <p>The requested resource was being concurrently
     * modified by another request.</p> </li> </ul>
     */
    inline bool ReasonHasBeenSet() const { return m_reasonHasBeenSet; }

    /**
     * <p>This request cannot be completed for one of the following reasons:</p> <ul>
     * <li> <p>Performing the requested operation would violate an existing uniqueness
     * claim in the identity store. Resolve the conflict before retrying this
     * request.</p> </li> <li> <p>The requested resource was being concurrently
     * modified by another request.</p> </li> </ul>
     */
    inline void SetReason(const ConflictExceptionReason& value) { m_reasonHasBeenSet = true; m_reason = value; }

    /**
     * <p>This request cannot be completed for one of the following reasons:</p> <ul>
     * <li> <p>Performing the requested operation would violate an existing uniqueness
     * claim in the identity store. Resolve the conflict before retrying this
     * request.</p> </li> <li> <p>The requested resource was being concurrently
     * modified by another request.</p> </li> </ul>
     */
    inline void SetReason(ConflictExceptionReason&& value) { m_reasonHasBeenSet = true; m_reason = std::move(value); }

    /**
     * <p>This request cannot be completed for one of the following reasons:</p> <ul>
     * <li> <p>Performing the requested operation would violate an existing uniqueness
     * claim in the identity store. Resolve the conflict before retrying this
     * request.</p> </li> <li> <p>The requested resource was being concurrently
     * modified by another request.</p> </li> </ul>
     */
    inline ConflictException& WithReason(const ConflictExceptionReason& value) { SetReason(value); return *this;}

    /**
     * <p>This request cannot be completed for one of the following reasons:</p> <ul>
     * <li> <p>Performing the requested operation would violate an existing uniqueness
     * claim in the identity store. Resolve the conflict before retrying this
     * request.</p> </li> <li> <p>The requested resource was being concurrently
     * modified by another request.</p> </li> </ul>
     */
    inline ConflictException& WithReason(ConflictExceptionReason&& value) { SetReason(std::move(value)); return *this;}

  private:

    Aws::String m_message;
    bool m_messageHasBeenSet = false;

    Aws::String m_requestId;
    bool m_requestIdHasBeenSet = false;

    ConflictExceptionReason m_reason;
    bool m_reasonHasBeenSet = false;
  };

} // namespace Model
} // namespace IdentityStore
} // namespace Aws
