%% LilyPond-File generated by Laborejo - http://www.laborejo.org
%% Generation Date: %$$DATE$$
%% Filename: %$$FILENAME$$

\version "2.22"
#(set-default-paper-size "a4")
#(set-global-staff-size %$$GLOBAL-STAFF-SIZE$$ )
#(ly:set-option 'point-and-click #f)

\paper {
  print-all-headers = ##f
  %scoreTitleMarkup = ##f

    %Print small title on every page.
    oddHeaderMarkup = \markup
    \fill-line {
    \on-the-fly #not-first-page \fromproperty #'header:title
    \on-the-fly #not-first-page \fromproperty #'header:instrument
    %"" % This will make sure that the header is never completely empty, to
    % avoid some layout problems. Also, moving it in between the title and
    % the page number, makes these be typeset left and right aligned, respectively.
    \on-the-fly #not-first-page  \on-the-fly #print-page-number-check-first \fromproperty #'page:page-number-string
    }

    evenHeaderMarkup = \markup
    \fill-line {
    \on-the-fly #print-page-number-check-first \fromproperty #'page:page-number-string
    \fromproperty #'header:instrument
    \fromproperty #'header:title
    }

}

\header{
    %$$HEADER$$
}

correctFraction = #(lambda (grob)
  (let ((ev (event-cause grob)))
    (if (and (= (ly:event-property ev 'numerator) 2) (= (ly:event-property ev 'denominator) 3))

    (format #f "~a" 3)

    (format #f "~a/~a"
            (ly:event-property ev 'numerator)
            (ly:event-property ev 'denominator))
    )))


\layout{
   %ragged-right = ##t
  \context { \Score
    \override TupletNumber #'text = \correctFraction %traditional but wrong: #tuplet-number::calc-fraction-text
    \override Fingering #'add-stem-support = ##t
    \override StringNumber #'add-stem-support = ##t
    \override StrokeFinger #'add-stem-support = ##t
    %Dynamics
    \override Hairpin #'to-barline = ##f
    \override DynamicLineSpanner #'staff-padding = #2.0
    \override DynamicLineSpanner #'Y-extent = #'(-1.5 . 1.5)
    \override TextScript #'Y-extent = #'(-1.5 . 1.5)
    \override PaperColumn #'keep-inside-line = ##t
     %Remove engraver here and add them in context staff to make multiple timesigs possible. This deactivates barnumbers!
    %\remove "Timing_translator"
    %\remove "Default_bar_line_engraver"
    %\override Tie #'details #'ratio = #2
  }
  \context { \Voice
    %Exchange note_heads_engraver with the completition variant which auto-ties notes on bar-breaks
    \remove "Note_heads_engraver"
    \consists "Completion_heads_engraver"
    \remove "Rest_engraver"
    \consists "Completion_rest_engraver"
    tieWaitForNote = ##t

  }
  \context { \Staff
    \RemoveEmptyStaves
    %\override VerticalAxisGroup #'remove-first = ##t
    \override TimeSignature #'style = #'numbered

    %Commenting the following two lines in again, together with the revmoval in \score enables mutli-timesig mode. But disables barnumbers.
    %\consists "Timing_translator"
    %\consists "Default_bar_line_engraver"

    \override NoteHead  #'style = #'baroque  %breve and longa are squared.


  }
}


%Music definitions. Containers, Staff, Parts.
tempoStaff = { %$$TEMPOSTAFF$$ }

%$$VOICES$$

\score  {

%Transpose the entire score. Nothing happens when "c c"
%$$TRANSPOSITION$$

<<
%How the definitions are arranged. Only staffgroups (staff prefix) and staffs, merged as voices.
\accidentalStyle Score.neo-modern-voice
%$$STRUCTURE$$
>>}



\markup{
  \vspace #2
  \column {
   \wordwrap {
   %$$SUBTEXT$$
   }
  }
}
