/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.option;

import java.awt.Color;
import java.io.File;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.option.OptionUI;
import net.sf.freecol.client.gui.panel.FreeColButton;
import net.sf.freecol.client.gui.panel.Utility;
import net.sf.freecol.common.io.FreeColDirectories;
import net.sf.freecol.common.option.FileOption;

public final class FileOptionUI
extends OptionUI<FileOption> {
    private final JPanel panel = new JPanel();
    private final JTextField fileField;

    public FileOptionUI(GUI gui, FileOption option, boolean editable) {
        super(option, editable);
        this.panel.add(this.getJLabel());
        File file = option.getValue();
        this.fileField = new JTextField(file == null ? null : file.getAbsolutePath(), 20);
        this.fileField.setToolTipText(file == null ? null : file.getAbsolutePath());
        this.fileField.setDisabledTextColor(Color.BLACK);
        this.panel.add(this.fileField);
        FreeColButton browse = Utility.localizedButton("browse");
        if (editable) {
            browse.addActionListener(ae -> {
                String[] stringArray;
                File root;
                boolean isMap = "map".equals(option.getType());
                File file = root = isMap ? FreeColDirectories.getMapsDirectory() : FreeColDirectories.getSaveDirectory();
                if (isMap) {
                    String[] stringArray2 = new String[3];
                    stringArray2[0] = "fsm";
                    stringArray2[1] = "fsg";
                    stringArray = stringArray2;
                    stringArray2[2] = "*";
                } else {
                    String[] stringArray3 = new String[2];
                    stringArray3[0] = "fsg";
                    stringArray = stringArray3;
                    stringArray3[1] = "*";
                }
                String[] extensions = stringArray;
                File f = gui.showLoadSaveFileDialog(root, extensions);
                if (f != null) {
                    this.setValue(f);
                }
            });
        }
        this.panel.add(browse);
        FreeColButton remove = Utility.localizedButton("remove");
        if (editable) {
            remove.addActionListener(ae -> this.setValue(null));
        }
        this.panel.add(remove);
        browse.setEnabled(editable);
        remove.setEnabled(editable);
        this.fileField.setEnabled(false);
        this.getJLabel().setLabelFor(this.fileField);
    }

    public void setValue(File f) {
        ((FileOption)this.getOption()).setValue(f);
        this.reset();
    }

    @Override
    public JPanel getComponent() {
        return this.panel;
    }

    @Override
    public void updateOption() {
        File f = this.fileField.getText() == null || this.fileField.getText().isEmpty() ? null : new File(this.fileField.getText());
        ((FileOption)this.getOption()).setValue(f);
    }

    @Override
    public void reset() {
        File file = ((FileOption)this.getOption()).getValue();
        String text = file == null ? "" : file.getAbsolutePath();
        this.fileField.setText(text);
        this.fileField.setToolTipText(text);
    }
}

