/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.flamingo.internal.ui.ribbon;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.pushingpixels.flamingo.api.common.CommandButtonDisplayState;
import org.pushingpixels.flamingo.api.common.CommandToggleButtonGroup;
import org.pushingpixels.flamingo.api.common.JCommandButtonPanel;
import org.pushingpixels.flamingo.api.common.JCommandToggleButton;
import org.pushingpixels.flamingo.api.common.StringValuePair;
import org.pushingpixels.flamingo.api.ribbon.JRibbonBand;
import org.pushingpixels.flamingo.api.ribbon.RibbonElementPriority;
import org.pushingpixels.flamingo.internal.ui.ribbon.BasicRibbonGalleryUI;
import org.pushingpixels.flamingo.internal.ui.ribbon.RibbonGalleryUI;

public class JRibbonGallery
extends JComponent {
    protected List<JCommandToggleButton> buttons = new ArrayList<JCommandToggleButton>();
    protected CommandToggleButtonGroup buttonSelectionGroup = new CommandToggleButtonGroup();
    protected RibbonElementPriority displayPriority;
    protected Map<RibbonElementPriority, Integer> preferredVisibleIconCount;
    protected List<StringValuePair<List<JCommandToggleButton>>> buttonGroups;
    protected int preferredPopupMaxButtonColumns;
    protected int preferredPopupMaxVisibleButtonRows;
    protected boolean isShowingPopupPanel;
    protected JRibbonBand.RibbonGalleryPopupCallback popupCallback;
    public static final String uiClassID = "RibbonGalleryUI";
    private String expandKeyTip;
    private CommandButtonDisplayState buttonDisplayState;

    public JRibbonGallery() {
        this.buttonSelectionGroup.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(final PropertyChangeEvent evt) {
                if ("selected".equals(evt.getPropertyName())) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            JRibbonGallery.this.firePropertyChange("selectedButton", evt.getOldValue(), evt.getNewValue());
                        }
                    });
                }
            }
        });
        this.preferredVisibleIconCount = new HashMap<RibbonElementPriority, Integer>();
        for (RibbonElementPriority state : RibbonElementPriority.values()) {
            this.preferredVisibleIconCount.put(state, 100);
        }
        this.isShowingPopupPanel = false;
        this.buttonDisplayState = JRibbonBand.BIG_FIXED_LANDSCAPE;
        this.updateUI();
    }

    public void setUI(RibbonGalleryUI ui) {
        super.setUI(ui);
    }

    @Override
    public void updateUI() {
        if (UIManager.get(this.getUIClassID()) != null) {
            this.setUI((RibbonGalleryUI)UIManager.getUI(this));
        } else {
            this.setUI(new BasicRibbonGalleryUI());
        }
    }

    @Override
    public RibbonGalleryUI getUI() {
        return (RibbonGalleryUI)this.ui;
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    private void addGalleryButton(StringValuePair<List<JCommandToggleButton>> buttonGroup, JCommandToggleButton button) {
        String buttonGroupName = (String)buttonGroup.getKey();
        int indexToAdd = 0;
        for (int i = 0; i < this.buttonGroups.size(); ++i) {
            StringValuePair<List<JCommandToggleButton>> buttonGroupPair = this.buttonGroups.get(i);
            String currGroupName = (String)buttonGroupPair.getKey();
            indexToAdd += ((List)buttonGroupPair.getValue()).size();
            if (currGroupName == null && buttonGroupName == null || currGroupName.compareTo(buttonGroupName) == 0) break;
        }
        this.buttons.add(indexToAdd, button);
        this.buttonSelectionGroup.add(button);
        ((List)buttonGroup.getValue()).add(button);
        button.setDisplayState(this.buttonDisplayState);
        super.add(button);
    }

    private void removeGalleryButton(JCommandToggleButton button) {
        this.buttons.remove(button);
        this.buttonSelectionGroup.remove(button);
        super.remove(button);
    }

    public void setPreferredVisibleButtonCount(RibbonElementPriority state, int visibleButtonCount) {
        this.preferredVisibleIconCount.put(state, visibleButtonCount);
    }

    public int getPreferredWidth(RibbonElementPriority state, int availableHeight) {
        int preferredVisibleButtonCount = this.preferredVisibleIconCount.get((Object)state);
        BasicRibbonGalleryUI ui = (BasicRibbonGalleryUI)this.getUI();
        return ui.getPreferredWidth(preferredVisibleButtonCount, availableHeight);
    }

    public void setDisplayPriority(RibbonElementPriority displayPriority) {
        this.displayPriority = displayPriority;
    }

    public RibbonElementPriority getDisplayPriority() {
        return this.displayPriority;
    }

    public int getButtonGroupCount() {
        return this.buttonGroups.size();
    }

    public List<JCommandToggleButton> getButtonGroup(String buttonGroupName) {
        for (StringValuePair<List<JCommandToggleButton>> group : this.buttonGroups) {
            if (((String)group.getKey()).compareTo(buttonGroupName) != 0) continue;
            return (List)group.getValue();
        }
        return null;
    }

    public int getButtonCount() {
        return this.buttons.size();
    }

    public JCommandToggleButton getButtonAt(int index) {
        return this.buttons.get(index);
    }

    public JCommandToggleButton getSelectedButton() {
        return this.buttonSelectionGroup.getSelected();
    }

    public void setSelectedButton(JCommandToggleButton selectedButton) {
        this.buttonSelectionGroup.setSelected(selectedButton, true);
    }

    public JCommandButtonPanel getPopupButtonPanel() {
        JCommandButtonPanel buttonPanel = new JCommandButtonPanel(this.buttonDisplayState);
        buttonPanel.setMaxButtonColumns(this.preferredPopupMaxButtonColumns);
        buttonPanel.setToShowGroupLabels(true);
        for (StringValuePair<List<JCommandToggleButton>> buttonGroupEntry : this.buttonGroups) {
            String groupName = (String)buttonGroupEntry.getKey();
            if (groupName == null) {
                buttonPanel.setToShowGroupLabels(false);
            }
            buttonPanel.addButtonGroup(groupName);
            for (JCommandToggleButton button : (List)buttonGroupEntry.getValue()) {
                button.setVisible(true);
                buttonPanel.addButtonToLastGroup(button);
            }
        }
        buttonPanel.setSingleSelectionMode(true);
        return buttonPanel;
    }

    public void setShowingPopupPanel(boolean isShowingPopupPanel) {
        this.isShowingPopupPanel = isShowingPopupPanel;
        if (!isShowingPopupPanel) {
            for (StringValuePair<List<JCommandToggleButton>> buttonGroupEntry : this.buttonGroups) {
                for (JCommandToggleButton button : (List)buttonGroupEntry.getValue()) {
                    button.setDisplayState(this.buttonDisplayState);
                    this.add(button);
                }
            }
            this.doLayout();
        }
    }

    public boolean isShowingPopupPanel() {
        return this.isShowingPopupPanel;
    }

    public void setGroupMapping(List<StringValuePair<List<JCommandToggleButton>>> buttons) {
        this.buttonGroups = new ArrayList<StringValuePair<List<JCommandToggleButton>>>();
        boolean hasGroupWithNullTitle = false;
        for (StringValuePair<List<JCommandToggleButton>> buttonGroupPair : buttons) {
            if (buttonGroupPair.getKey() == null) {
                if (hasGroupWithNullTitle) {
                    throw new IllegalArgumentException("Can't have more than one ribbon gallery group with null name");
                }
                hasGroupWithNullTitle = true;
            }
            ArrayList buttonGroupCopy = new ArrayList();
            StringValuePair<List<JCommandToggleButton>> buttonGroupInfo = new StringValuePair<List<JCommandToggleButton>>((String)buttonGroupPair.getKey(), (List<JCommandToggleButton>)buttonGroupCopy);
            this.buttonGroups.add(buttonGroupInfo);
            for (JCommandToggleButton button : (List)buttonGroupPair.getValue()) {
                this.addGalleryButton(buttonGroupInfo, button);
            }
        }
    }

    public void addRibbonGalleryButtons(String buttonGroupName, JCommandToggleButton ... buttons) {
        for (StringValuePair<List<JCommandToggleButton>> buttonGroup : this.buttonGroups) {
            if (((String)buttonGroup.getKey()).compareTo(buttonGroupName) != 0) continue;
            for (JCommandToggleButton button : buttons) {
                this.addGalleryButton(buttonGroup, button);
            }
            return;
        }
        this.revalidate();
        this.doLayout();
    }

    public void removeRibbonGalleryButtons(JCommandToggleButton ... buttons) {
        for (StringValuePair<List<JCommandToggleButton>> buttonGroup : this.buttonGroups) {
            Iterator it = ((List)buttonGroup.getValue()).iterator();
            while (it.hasNext()) {
                JCommandToggleButton currButtonInGroup = (JCommandToggleButton)it.next();
                for (JCommandToggleButton toRemove : buttons) {
                    if (toRemove != currButtonInGroup) continue;
                    it.remove();
                    this.removeGalleryButton(toRemove);
                }
            }
        }
        this.revalidate();
        this.doLayout();
    }

    public void setPreferredPopupPanelDimension(int preferredPopupMaxButtonColumns, int preferredPopupMaxVisibleButtonRows) {
        this.preferredPopupMaxButtonColumns = preferredPopupMaxButtonColumns;
        this.preferredPopupMaxVisibleButtonRows = preferredPopupMaxVisibleButtonRows;
    }

    public void setPopupCallback(JRibbonBand.RibbonGalleryPopupCallback popupCallback) {
        this.popupCallback = popupCallback;
    }

    public JRibbonBand.RibbonGalleryPopupCallback getPopupCallback() {
        return this.popupCallback;
    }

    public int getPreferredPopupMaxButtonColumns() {
        return this.preferredPopupMaxButtonColumns;
    }

    public int getPreferredPopupMaxVisibleButtonRows() {
        return this.preferredPopupMaxVisibleButtonRows;
    }

    public void setExpandKeyTip(String expandKeyTip) {
        String old = this.expandKeyTip;
        this.expandKeyTip = expandKeyTip;
        this.firePropertyChange("expandKeyTip", old, this.expandKeyTip);
    }

    public String getExpandKeyTip() {
        return this.expandKeyTip;
    }

    public CommandButtonDisplayState getButtonDisplayState() {
        return this.buttonDisplayState;
    }

    public void setButtonDisplayState(CommandButtonDisplayState buttonDisplayState) {
        boolean isSupported;
        if (this.getButtonCount() > 0) {
            throw new IllegalStateException("Cannot change button display state on ribbon gallery with existing buttons");
        }
        boolean bl = isSupported = buttonDisplayState == JRibbonBand.BIG_FIXED || buttonDisplayState == CommandButtonDisplayState.SMALL || buttonDisplayState == JRibbonBand.BIG_FIXED_LANDSCAPE;
        if (!isSupported) {
            throw new IllegalArgumentException("Display state " + buttonDisplayState.getDisplayName() + " is not supported in ribbon galleries");
        }
        if (!buttonDisplayState.equals(this.buttonDisplayState)) {
            CommandButtonDisplayState old = this.buttonDisplayState;
            this.buttonDisplayState = buttonDisplayState;
            for (JCommandToggleButton button : this.buttons) {
                button.setDisplayState(buttonDisplayState);
            }
            this.firePropertyChange("buttonDisplayState", old, this.buttonDisplayState);
        }
    }
}

