# append-buffer [![NPM version](https://img.shields.io/npm/v/append-buffer.svg?style=flat)](https://www.npmjs.com/package/append-buffer) [![NPM monthly downloads](https://img.shields.io/npm/dm/append-buffer.svg?style=flat)](https://npmjs.org/package/append-buffer)  [![NPM total downloads](https://img.shields.io/npm/dt/append-buffer.svg?style=flat)](https://npmjs.org/package/append-buffer) [![Linux Build Status](https://img.shields.io/travis/doowb/append-buffer.svg?style=flat&label=Travis)](https://travis-ci.org/doowb/append-buffer) [![Windows Build Status](https://img.shields.io/appveyor/ci/doowb/append-buffer.svg?style=flat&label=AppVeyor)](https://ci.appveyor.com/project/doowb/append-buffer)

> Append a buffer to another buffer ensuring to preserve line ending characters.

## Install

Install with [npm](https://www.npmjs.com/):

```sh
$ npm install --save append-buffer
```

Install with [yarn](https://yarnpkg.com):

```sh
$ yarn add append-buffer
```

## Usage

```js
var appendBuffer = require('append-buffer');
```

## API

### [appendBuffer](index.js#L28)

Append a buffer to another buffer ensuring to preserve line ending characters.

**Params**

* `buf` **{Buffer}**: Buffer that will be used to check for an existing line ending. The suffix is appended to this.
* `suffix` **{Buffer}**: Buffer that will be appended to the buf.
* `returns` **{Buffer}**: Final Buffer

**Example**

```js
console.log([appendBuffer(new Buffer('abc\r\n'), new Buffer('def')).toString()]);
//=> [ 'abc\r\ndef\r\n' ]

console.log([appendBuffer(new Buffer('abc\n'), new Buffer('def')).toString()]);
//=> [ 'abc\ndef\n' ]

// uses os.EOL when a line ending is not found
console.log([appendBuffer(new Buffer('abc'), new Buffer('def')).toString()]);
//=> [ 'abc\ndef' ]
```

## Attribution

The code in this module was originally added in a [PR](https://github.com/jonschlinkert/file-normalize/pull/3) to [file-normalize](https://github.com/jonschlinkert/file-normalize). It has been split out to allow for standalone use cases.

## About

### Contributing

Pull requests and stars are always welcome. For bugs and feature requests, [please create an issue](../../issues/new).

Please read the [contributing guide](.github/contributing.md) for advice on opening issues, pull requests, and coding standards.

### Building docs

_(This project's readme.md is generated by [verb](https://github.com/verbose/verb-generate-readme), please don't edit the readme directly. Any changes to the readme must be made in the [.verb.md](.verb.md) readme template.)_

To generate the readme, run the following command:

```sh
$ npm install -g verbose/verb#dev verb-generate-readme && verb
```

### Running tests

Running and reviewing unit tests is a great way to get familiarized with a library and its API. You can install dependencies and run tests with the following command:

```sh
$ npm install && npm test
```

### Author

**Brian Woodward**

* [github/doowb](https://github.com/doowb)
* [twitter/doowb](https://twitter.com/doowb)

### License

Copyright © 2017, [Brian Woodward](https://doowb.com).
Released under the [MIT License](LICENSE).

***

_This file was generated by [verb-generate-readme](https://github.com/verbose/verb-generate-readme), v0.6.0, on August 01, 2017._