#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 brick
version:              0.60.1
visibility:           public
id:                   brick-0.60.1-LhAlGNMSNCvFJICQXBu7QG
key:                  brick-0.60.1-LhAlGNMSNCvFJICQXBu7QG
license:              BSD-3-Clause
copyright:            (c) Jonathan Daugherty 2015-2020
maintainer:           Jonathan Daugherty <cygnus@foobox.com>
author:               Jonathan Daugherty <cygnus@foobox.com>
homepage:             https://github.com/jtdaugherty/brick/
synopsis:             A declarative terminal user interface library
description:
    Write terminal user interfaces (TUIs) painlessly with '\''brick'\''! You
    write an event handler and a drawing function and the library does the
    rest.


    > module Main where
    >
    > import Brick
    >
    > ui :: Widget ()
    > ui = str "Hello, world!"
    >
    > main :: IO ()
    > main = simpleMain ui


    To get started, see:

    * <https://github.com/jtdaugherty/brick/blob/master/README.md The README>

    * The <https://github.com/jtdaugherty/brick/blob/master/docs/guide.rst Brick user guide>

    * The demonstration programs in the '\''programs'\'' directory


    This package deprecates <http://hackage.haskell.org/package/vty-ui vty-ui>.

category:             Graphics
abi:                  2a73957cf76aae6d47c24f4328571ed8
exposed:              True
exposed-modules:
    Brick Brick.AttrMap Brick.BChan Brick.BorderMap Brick.Focus
    Brick.Forms Brick.Main Brick.Markup Brick.Themes Brick.Types
    Brick.Util Brick.Widgets.Border Brick.Widgets.Border.Style
    Brick.Widgets.Center Brick.Widgets.Core Brick.Widgets.Dialog
    Brick.Widgets.Edit Brick.Widgets.FileBrowser Brick.Widgets.List
    Brick.Widgets.ProgressBar Brick.Widgets.Table Data.IMap
    Data.Text.Markup

hidden-modules:
    Brick.Types.Common Brick.Types.TH Brick.Types.Internal
    Brick.Widgets.Internal

import-dirs:          /usr/lib/ghc-8.10.3/site-local/brick-0.60.1
library-dirs:         /usr/lib/ghc-8.10.3/site-local/brick-0.60.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/i386-linux-ghc-8.10.3/brick-0.60.1
hs-libraries:         HSbrick-0.60.1-LhAlGNMSNCvFJICQXBu7QG
depends:
    base-4.14.1.0 bytestring-0.10.12.0
    config-ini-0.2.4.0-47t40DhyZqGKte11kQyGtB containers-0.6.2.1
    contravariant-1.5.3-7koBfVZf7s8G3BlROnwJJd
    data-clist-0.1.2.3-IfxKxFDlOCMIZ7XfakMYhe deepseq-1.4.4.0
    directory-1.3.6.0 dlist-1.0-KFY6kePYM7gDQLIElBL83C
    exceptions-0.10.4 filepath-1.4.2.1
    microlens-0.4.12.0-LWmCgM3D0eIxbRgAEzd8k
    microlens-mtl-0.2.0.1-3tNQgwbNspG9ZtqGot68nU
    microlens-th-0.4.3.9-8lY9YzOSn74KKUTb0A8pMI stm-2.5.0.0
    template-haskell-2.16.0.0 text-1.2.4.1
    text-zipper-0.11-G06rcaJx9O5885ZqOx7Y49 transformers-0.5.6.2
    unix-2.7.2.2 vector-0.12.2.0-8ehm6YCQqIm9C6Fn68BeE2
    vty-5.32-48KPQt5k4MB3fPJLDncSVO
    word-wrap-0.4.1-HcTxPJJoBKmCadGxsBTBn6

haddock-interfaces:   /usr/share/doc/haskell-brick/html/brick.haddock
haddock-html:         /usr/share/doc/haskell-brick/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

