#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 dependent-sum
version:              0.7.1.0
visibility:           public
id:                   dependent-sum-0.7.1.0-K5Ubw1JI8oOA91k5GKnqt6
key:                  dependent-sum-0.7.1.0-K5Ubw1JI8oOA91k5GKnqt6
license:              LicenseRef-PublicDomain
maintainer:           Obsidian Systems, LLC <maintainer@obsidian.systems>
author:               James Cook <mokus@deepbondi.net>
stability:            provisional
homepage:             https://github.com/obsidiansystems/dependent-sum
synopsis:             Dependent sum type
description:
    A dependent sum is a generalization of a
    particular way of thinking about the @Either@
    type.  @Either a b@ can be thought of as a
    2-tuple @(tag, value)@, where the value of the
    tag determines the type of the value.  In
    particular, either @tag = Left@ and @value :: a@
    or @tag = Right@ and @value :: b@.

    This package allows you to define your own
    dependent sum types by using your own \"tag\"
    types.

category:             Data, Dependent Types
abi:                  ba4fd9546f494f83e340ca39ef636dcd
exposed:              True
exposed-modules:
    Data.Dependent.Sum,
    Data.GADT.Compare from some-1.0.3-1KmRXE4Js6K5qWAWmRn59k:Data.GADT.Compare,
    Data.GADT.Show from some-1.0.3-1KmRXE4Js6K5qWAWmRn59k:Data.GADT.Show,
    Data.Some from some-1.0.3-1KmRXE4Js6K5qWAWmRn59k:Data.Some

import-dirs:          /usr/lib/ghc-8.10.5/site-local/dependent-sum-0.7.1.0
library-dirs:         /usr/lib/ghc-8.10.5/site-local/dependent-sum-0.7.1.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/i386-linux-ghc-8.10.5/dependent-sum-0.7.1.0
hs-libraries:         HSdependent-sum-0.7.1.0-K5Ubw1JI8oOA91k5GKnqt6
depends:
    base-4.14.2.0 constraints-extras-0.3.1.0-2LnlfO4CkU1CvXDwv6boYo
    some-1.0.3-1KmRXE4Js6K5qWAWmRn59k

haddock-interfaces:
    /usr/share/doc/haskell-dependent-sum/html/dependent-sum.haddock

haddock-html:         /usr/share/doc/haskell-dependent-sum/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

