/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.theme;

import java.util.Map;
import javax.ws.rs.core.Response;
import org.keycloak.models.BrowserSecurityHeaders;
import org.keycloak.models.RealmModel;

public class BrowserSecurityHeaderSetup {
    public static Response.ResponseBuilder headers(Response.ResponseBuilder builder, RealmModel realm) {
        return BrowserSecurityHeaderSetup.headers(builder, realm.getBrowserSecurityHeaders(), null);
    }

    public static Response.ResponseBuilder headers(Response.ResponseBuilder builder, RealmModel realm, Options options) {
        return BrowserSecurityHeaderSetup.headers(builder, realm.getBrowserSecurityHeaders(), options);
    }

    public static Response.ResponseBuilder headers(Response.ResponseBuilder builder) {
        return BrowserSecurityHeaderSetup.headers(builder, BrowserSecurityHeaders.defaultHeaders, null);
    }

    private static Response.ResponseBuilder headers(Response.ResponseBuilder builder, Map<String, String> headers, Options options) {
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            String header = (String)BrowserSecurityHeaders.headerAttributeMap.get(entry.getKey());
            String value = entry.getValue();
            if (options != null && header.equals("Content-Security-Policy") && value.equals("frame-src 'self'; frame-ancestors 'self'; object-src 'none';") && options.allowedFrameSrc != null) {
                value = "frame-src " + options.allowedFrameSrc + "; frame-ancestors 'self'; object-src 'none';";
            }
            if (header == null || value == null || value.isEmpty()) continue;
            builder.header(header, (Object)value);
        }
        return builder;
    }

    public static class Options {
        private String allowedFrameSrc;

        public static Options create() {
            return new Options();
        }

        public Options allowFrameSrc(String source) {
            this.allowedFrameSrc = source;
            return this;
        }

        public Options build() {
            return this;
        }
    }
}

