/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.microprofile.health;

import org.jboss.as.controller.AbstractBoottimeAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.server.AbstractDeploymentChainStep;
import org.jboss.as.server.DeploymentProcessorTarget;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.Phase;
import org.jboss.dmr.ModelNode;
import org.wildfly.extension.microprofile.health.HealthContextService;
import org.wildfly.extension.microprofile.health.HealthReporterService;
import org.wildfly.extension.microprofile.health.MicroProfileHealthSubsystemDefinition;
import org.wildfly.extension.microprofile.health._private.MicroProfileHealthLogger;
import org.wildfly.extension.microprofile.health.deployment.DependencyProcessor;
import org.wildfly.extension.microprofile.health.deployment.DeploymentProcessor;

class MicroProfileHealthSubsystemAdd
extends AbstractBoottimeAddStepHandler {
    static MicroProfileHealthSubsystemAdd INSTANCE = new MicroProfileHealthSubsystemAdd();

    private MicroProfileHealthSubsystemAdd() {
        super(MicroProfileHealthSubsystemDefinition.ATTRIBUTES);
    }

    protected void performBoottime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        super.performBoottime(context, operation, model);
        context.addStep((OperationStepHandler)new AbstractDeploymentChainStep(){

            public void execute(DeploymentProcessorTarget processorTarget) {
                processorTarget.addDeploymentProcessor("microprofile-health-smallrye", Phase.DEPENDENCIES, 6256, (DeploymentUnitProcessor)new DependencyProcessor());
                processorTarget.addDeploymentProcessor("microprofile-health-smallrye", Phase.POST_MODULE, 14192, (DeploymentUnitProcessor)new DeploymentProcessor());
            }
        }, OperationContext.Stage.RUNTIME);
        boolean securityEnabled = MicroProfileHealthSubsystemDefinition.SECURITY_ENABLED.resolveModelAttribute(context, model).asBoolean();
        String emptyLivenessChecksStatus = MicroProfileHealthSubsystemDefinition.EMPTY_LIVENESS_CHECKS_STATUS.resolveModelAttribute(context, model).asString();
        String emptyReadinessChecksStatus = MicroProfileHealthSubsystemDefinition.EMPTY_READINESS_CHECKS_STATUS.resolveModelAttribute(context, model).asString();
        HealthReporterService.install(context, emptyLivenessChecksStatus, emptyReadinessChecksStatus);
        HealthContextService.install(context, securityEnabled);
        MicroProfileHealthLogger.LOGGER.activatingSubsystem();
    }
}

