/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.xacml.sunxacml.cond;

import java.net.URI;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jboss.security.xacml.sunxacml.ParsingException;
import org.jboss.security.xacml.sunxacml.UnknownIdentifierException;
import org.jboss.security.xacml.sunxacml.cond.Function;
import org.jboss.security.xacml.sunxacml.cond.FunctionFactory;
import org.jboss.security.xacml.sunxacml.cond.FunctionProxy;
import org.jboss.security.xacml.sunxacml.cond.FunctionTypeException;
import org.w3c.dom.Node;

public class BaseFunctionFactory
extends FunctionFactory {
    private HashMap functionMap = new HashMap();
    private FunctionFactory superset = null;

    public BaseFunctionFactory() {
        this(null);
    }

    public BaseFunctionFactory(FunctionFactory superset) {
        this.superset = superset;
    }

    public BaseFunctionFactory(Set supportedFunctions, Map supportedAbstractFunctions) {
        this(null, supportedFunctions, supportedAbstractFunctions);
    }

    public BaseFunctionFactory(FunctionFactory superset, Set supportedFunctions, Map supportedAbstractFunctions) {
        this(superset);
        for (Function function : supportedFunctions) {
            this.functionMap.put(function.getIdentifier().toString(), function);
        }
        for (URI id : supportedAbstractFunctions.keySet()) {
            FunctionProxy proxy = (FunctionProxy)supportedAbstractFunctions.get(id);
            this.functionMap.put(id.toString(), proxy);
        }
    }

    public void addFunction(Function function) throws IllegalArgumentException {
        String id = function.getIdentifier().toString();
        if (this.functionMap.containsKey(id)) {
            throw new IllegalArgumentException("function already exists");
        }
        if (this.superset != null) {
            this.superset.addFunction(function);
        }
        this.functionMap.put(id, function);
    }

    public void addAbstractFunction(FunctionProxy proxy, URI identity) throws IllegalArgumentException {
        String id = identity.toString();
        if (this.functionMap.containsKey(id)) {
            throw new IllegalArgumentException("function already exists");
        }
        if (this.superset != null) {
            this.superset.addAbstractFunction(proxy, identity);
        }
        this.functionMap.put(id, proxy);
    }

    public Set getSupportedFunctions() {
        HashSet set = new HashSet(this.functionMap.keySet());
        if (this.superset != null) {
            set.addAll(this.superset.getSupportedFunctions());
        }
        return set;
    }

    public Function createFunction(URI identity) throws UnknownIdentifierException, FunctionTypeException {
        return this.createFunction(identity.toString());
    }

    public Function createFunction(String identity) throws UnknownIdentifierException, FunctionTypeException {
        Object entry = this.functionMap.get(identity);
        if (entry != null) {
            if (entry instanceof Function) {
                return (Function)entry;
            }
            throw new FunctionTypeException("function is abstract");
        }
        throw new UnknownIdentifierException("functions of type " + identity + " are not " + "supported by this factory");
    }

    public Function createAbstractFunction(URI identity, Node root) throws UnknownIdentifierException, ParsingException, FunctionTypeException {
        return this.createAbstractFunction(identity.toString(), root, null);
    }

    public Function createAbstractFunction(URI identity, Node root, String xpathVersion) throws UnknownIdentifierException, ParsingException, FunctionTypeException {
        return this.createAbstractFunction(identity.toString(), root, xpathVersion);
    }

    public Function createAbstractFunction(String identity, Node root) throws UnknownIdentifierException, ParsingException, FunctionTypeException {
        return this.createAbstractFunction(identity, root, null);
    }

    public Function createAbstractFunction(String identity, Node root, String xpathVersion) throws UnknownIdentifierException, ParsingException, FunctionTypeException {
        Object entry = this.functionMap.get(identity);
        if (entry != null) {
            if (entry instanceof FunctionProxy) {
                try {
                    return ((FunctionProxy)entry).getInstance(root, xpathVersion);
                }
                catch (Exception e) {
                    throw new ParsingException("couldn't create abstract function " + identity, e);
                }
            }
            throw new FunctionTypeException("function is concrete");
        }
        throw new UnknownIdentifierException("abstract functions of type " + identity + " are not supported by " + "this factory");
    }
}

