/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.data.attestation.authenticator;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.exc.InvalidFormatException;
import com.webauthn4j.util.ECUtil;
import java.security.spec.ECParameterSpec;

public enum Curve {
    SECP256R1(1, 32, ECUtil.P_256_SPEC),
    SECP384R1(2, 48, ECUtil.P_384_SPEC),
    SECP521R1(3, 66, ECUtil.P_521_SPEC);

    private final int value;
    private final int size;
    private final ECParameterSpec parameterSpec;

    private Curve(int value, int size, ECParameterSpec parameterSpec) {
        this.value = value;
        this.size = size;
        this.parameterSpec = parameterSpec;
    }

    public static Curve create(int value) {
        switch (value) {
            case 1: {
                return SECP256R1;
            }
            case 2: {
                return SECP384R1;
            }
            case 3: {
                return SECP521R1;
            }
        }
        throw new IllegalArgumentException("value '" + value + "' is out of range");
    }

    @JsonCreator
    static Curve deserialize(int value) throws InvalidFormatException {
        try {
            return Curve.create(value);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidFormatException(null, "value is out of range", (Object)value, Curve.class);
        }
    }

    @JsonValue
    public int getValue() {
        return this.value;
    }

    public int getSize() {
        return this.size;
    }

    public ECParameterSpec getECParameterSpec() {
        return this.parameterSpec;
    }
}

