/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.near;

import java.util.concurrent.ConcurrentMap;
import org.infinispan.client.hotrod.MetadataValue;
import org.infinispan.client.hotrod.configuration.NearCacheConfiguration;
import org.infinispan.client.hotrod.near.NearCache;
import org.infinispan.commons.util.CollectionFactory;

final class BoundedConcurrentMapNearCache<K, V>
implements NearCache<K, V> {
    private final ConcurrentMap<K, MetadataValue<V>> cache;

    private BoundedConcurrentMapNearCache(ConcurrentMap<K, MetadataValue<V>> cache) {
        this.cache = cache;
    }

    public static <K, V> NearCache<K, V> create(NearCacheConfiguration config) {
        return new BoundedConcurrentMapNearCache<K, V>(CollectionFactory.makeBoundedConcurrentMap((int)config.maxEntries()));
    }

    @Override
    public void put(K key, MetadataValue<V> value) {
        this.cache.put(key, value);
    }

    @Override
    public void putIfAbsent(K key, MetadataValue<V> value) {
        this.cache.putIfAbsent(key, value);
    }

    @Override
    public boolean remove(K key) {
        return this.cache.remove(key) != null;
    }

    @Override
    public MetadataValue<V> get(K key) {
        return (MetadataValue)this.cache.get(key);
    }

    @Override
    public void clear() {
        this.cache.clear();
    }

    @Override
    public int size() {
        return this.cache.size();
    }
}

