/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.ejb.parser.jboss.ejb3;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.metadata.ejb.jboss.IIOPMetaData;
import org.jboss.metadata.ejb.jboss.IORASContextMetaData;
import org.jboss.metadata.ejb.jboss.IORSASContextMetaData;
import org.jboss.metadata.ejb.jboss.IORSecurityConfigMetaData;
import org.jboss.metadata.ejb.jboss.IORTransportConfigMetaData;
import org.jboss.metadata.ejb.parser.jboss.ejb3.AbstractEJBBoundMetaDataParser;
import org.jboss.metadata.property.PropertyReplacer;

public class IIOPMetaDataParser
extends AbstractEJBBoundMetaDataParser<IIOPMetaData> {
    @Override
    public IIOPMetaData parse(XMLStreamReader reader, PropertyReplacer propertyReplacer) throws XMLStreamException {
        IIOPMetaData metaData = new IIOPMetaData();
        super.processElements(metaData, reader, propertyReplacer);
        return metaData;
    }

    @Override
    protected void processElement(IIOPMetaData metaData, XMLStreamReader reader, PropertyReplacer propertyReplacer) throws XMLStreamException {
        Namespace namespace = Namespace.forUri(reader.getNamespaceURI());
        switch (namespace) {
            case EJB3_IIOP: {
                Element element = Element.forName(reader.getLocalName());
                switch (element) {
                    case EJB_NAME: {
                        String ejbName = IIOPMetaDataParser.getElementText((XMLStreamReader)reader, (PropertyReplacer)propertyReplacer);
                        break;
                    }
                    case BINDING_NAME: {
                        metaData.setBindingName(IIOPMetaDataParser.getElementText((XMLStreamReader)reader, (PropertyReplacer)propertyReplacer));
                        break;
                    }
                    case IOR_SECURITY_CONFIG: {
                        IORSecurityConfigMetaData iorSecurityMetaData = this.processIORSecurityConfig(reader, propertyReplacer);
                        metaData.setIorSecurityConfigMetaData(iorSecurityMetaData);
                        break;
                    }
                }
                return;
            }
        }
        super.processElement(metaData, reader, propertyReplacer);
    }

    protected IORSecurityConfigMetaData processIORSecurityConfig(XMLStreamReader reader, PropertyReplacer propertyReplacer) throws XMLStreamException {
        IORSecurityConfigMetaData iorSecurityMetaData = new IORSecurityConfigMetaData();
        block5: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case TRANSPORT_CONFIG: {
                    IORTransportConfigMetaData transportConfig = this.processTransportConfig(reader, propertyReplacer);
                    iorSecurityMetaData.setTransportConfig(transportConfig);
                    continue block5;
                }
                case AS_CONTEXT: {
                    IORASContextMetaData asContext = this.processASContext(reader, propertyReplacer);
                    iorSecurityMetaData.setAsContext(asContext);
                    continue block5;
                }
                case SAS_CONTEXT: {
                    IORSASContextMetaData sasContext = this.processSASContext(reader, propertyReplacer);
                    iorSecurityMetaData.setSasContext(sasContext);
                    continue block5;
                }
            }
            throw IIOPMetaDataParser.unexpectedElement((XMLStreamReader)reader);
        }
        return iorSecurityMetaData;
    }

    protected IORTransportConfigMetaData processTransportConfig(XMLStreamReader reader, PropertyReplacer propertyReplacer) throws XMLStreamException {
        int count = reader.getAttributeCount();
        if (count == 0) {
            return this.processTransportConfigLegacy(reader, propertyReplacer);
        }
        EnumSet<Attribute> requiredAttributes = EnumSet.of(Attribute.INTEGRITY, Attribute.CONFIDENTIALITY, Attribute.ESTABLISH_TRUST_IN_CLIENT, Attribute.ESTABLISH_TRUST_IN_TARGET);
        IORTransportConfigMetaData transportConfig = new IORTransportConfigMetaData();
        for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            String attValue = reader.getAttributeValue(i);
            switch (attribute) {
                case INTEGRITY: {
                    transportConfig.setIntegrity(attValue);
                    break;
                }
                case CONFIDENTIALITY: {
                    transportConfig.setConfidentiality(attValue);
                    break;
                }
                case DETECT_MISORDERING: {
                    transportConfig.setDetectMisordering(attValue);
                    break;
                }
                case DETECT_REPLAY: {
                    transportConfig.setDetectReplay(attValue);
                    break;
                }
                case ESTABLISH_TRUST_IN_CLIENT: {
                    transportConfig.setEstablishTrustInClient(attValue);
                    break;
                }
                case ESTABLISH_TRUST_IN_TARGET: {
                    transportConfig.setEstablishTrustInTarget(attValue);
                    break;
                }
                default: {
                    IIOPMetaDataParser.unexpectedAttribute((XMLStreamReader)reader, (int)i);
                }
            }
            requiredAttributes.remove((Object)attribute);
        }
        if (!requiredAttributes.isEmpty()) {
            throw IIOPMetaDataParser.missingRequiredAttributes((XMLStreamReader)reader, requiredAttributes);
        }
        if (reader.nextTag() != 2) {
            throw IIOPMetaDataParser.unexpectedElement((XMLStreamReader)reader);
        }
        return transportConfig;
    }

    protected IORTransportConfigMetaData processTransportConfigLegacy(XMLStreamReader reader, PropertyReplacer propertyReplacer) throws XMLStreamException {
        IIOPMetaDataParser.requireNoAttributes((XMLStreamReader)reader);
        EnumSet<Element> requiredElements = EnumSet.of(Element.INTEGRITY, Element.CONFIDENTIALITY, Element.ESTABLISH_TRUST_IN_CLIENT, Element.ESTABLISH_TRUST_IN_TARGET);
        IORTransportConfigMetaData transportConfig = new IORTransportConfigMetaData();
        while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case INTEGRITY: {
                    IIOPMetaDataParser.requireNoAttributes((XMLStreamReader)reader);
                    transportConfig.setIntegrity(IIOPMetaDataParser.getElementText((XMLStreamReader)reader, (PropertyReplacer)propertyReplacer));
                    break;
                }
                case CONFIDENTIALITY: {
                    IIOPMetaDataParser.requireNoAttributes((XMLStreamReader)reader);
                    transportConfig.setConfidentiality(IIOPMetaDataParser.getElementText((XMLStreamReader)reader, (PropertyReplacer)propertyReplacer));
                    break;
                }
                case DETECT_MISORDERING: {
                    IIOPMetaDataParser.requireNoAttributes((XMLStreamReader)reader);
                    transportConfig.setDetectMisordering(IIOPMetaDataParser.getElementText((XMLStreamReader)reader, (PropertyReplacer)propertyReplacer));
                    break;
                }
                case DETECT_REPLAY: {
                    IIOPMetaDataParser.requireNoAttributes((XMLStreamReader)reader);
                    transportConfig.setDetectReplay(IIOPMetaDataParser.getElementText((XMLStreamReader)reader, (PropertyReplacer)propertyReplacer));
                    break;
                }
                case ESTABLISH_TRUST_IN_CLIENT: {
                    IIOPMetaDataParser.requireNoAttributes((XMLStreamReader)reader);
                    transportConfig.setEstablishTrustInClient(IIOPMetaDataParser.getElementText((XMLStreamReader)reader, (PropertyReplacer)propertyReplacer));
                    break;
                }
                case ESTABLISH_TRUST_IN_TARGET: {
                    IIOPMetaDataParser.requireNoAttributes((XMLStreamReader)reader);
                    transportConfig.setEstablishTrustInTarget(IIOPMetaDataParser.getElementText((XMLStreamReader)reader, (PropertyReplacer)propertyReplacer));
                    break;
                }
                default: {
                    throw IIOPMetaDataParser.unexpectedElement((XMLStreamReader)reader);
                }
            }
            requiredElements.remove((Object)element);
        }
        if (!requiredElements.isEmpty()) {
            throw IIOPMetaDataParser.missingRequiredElement((XMLStreamReader)reader, requiredElements);
        }
        return transportConfig;
    }

    protected IORASContextMetaData processASContext(XMLStreamReader reader, PropertyReplacer propertyReplacer) throws XMLStreamException {
        int count = reader.getAttributeCount();
        if (count == 0) {
            return this.processASContextLegacy(reader, propertyReplacer);
        }
        EnumSet<Attribute> requiredAttributes = EnumSet.of(Attribute.AUTH_METHOD, Attribute.REALM, Attribute.REQUIRED);
        IORASContextMetaData asContext = new IORASContextMetaData();
        for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            String attValue = reader.getAttributeValue(i);
            switch (attribute) {
                case AUTH_METHOD: {
                    asContext.setAuthMethod(attValue);
                    break;
                }
                case REALM: {
                    asContext.setRealm(attValue);
                    break;
                }
                case REQUIRED: {
                    asContext.setRequired(Boolean.valueOf(attValue));
                    break;
                }
                default: {
                    IIOPMetaDataParser.unexpectedAttribute((XMLStreamReader)reader, (int)i);
                }
            }
            requiredAttributes.remove((Object)attribute);
        }
        if (!requiredAttributes.isEmpty()) {
            throw IIOPMetaDataParser.missingRequiredAttributes((XMLStreamReader)reader, requiredAttributes);
        }
        if (reader.nextTag() != 2) {
            throw IIOPMetaDataParser.unexpectedElement((XMLStreamReader)reader);
        }
        return asContext;
    }

    protected IORASContextMetaData processASContextLegacy(XMLStreamReader reader, PropertyReplacer propertyReplacer) throws XMLStreamException {
        IIOPMetaDataParser.requireNoAttributes((XMLStreamReader)reader);
        EnumSet<Element> requiredElements = EnumSet.of(Element.AUTH_METHOD, Element.REALM, Element.REQUIRED);
        IORASContextMetaData asContext = new IORASContextMetaData();
        while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case AUTH_METHOD: {
                    IIOPMetaDataParser.requireNoAttributes((XMLStreamReader)reader);
                    asContext.setAuthMethod(IIOPMetaDataParser.getElementText((XMLStreamReader)reader, (PropertyReplacer)propertyReplacer));
                    break;
                }
                case REALM: {
                    IIOPMetaDataParser.requireNoAttributes((XMLStreamReader)reader);
                    asContext.setRealm(IIOPMetaDataParser.getElementText((XMLStreamReader)reader, (PropertyReplacer)propertyReplacer));
                    break;
                }
                case REQUIRED: {
                    IIOPMetaDataParser.requireNoAttributes((XMLStreamReader)reader);
                    asContext.setRequired(Boolean.valueOf(IIOPMetaDataParser.getElementText((XMLStreamReader)reader, (PropertyReplacer)propertyReplacer)));
                    break;
                }
                default: {
                    throw IIOPMetaDataParser.unexpectedElement((XMLStreamReader)reader);
                }
            }
            requiredElements.remove((Object)element);
        }
        if (!requiredElements.isEmpty()) {
            throw IIOPMetaDataParser.missingRequiredElement((XMLStreamReader)reader, requiredElements);
        }
        return asContext;
    }

    protected IORSASContextMetaData processSASContext(XMLStreamReader reader, PropertyReplacer propertyReplacer) throws XMLStreamException {
        int count = reader.getAttributeCount();
        if (count == 0) {
            return this.processSASContextLegacy(reader, propertyReplacer);
        }
        EnumSet<Attribute> requiredAttributes = EnumSet.of(Attribute.CALLER_PROPAGATION);
        IORSASContextMetaData sasContext = new IORSASContextMetaData();
        for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            String attValue = reader.getAttributeValue(i);
            switch (attribute) {
                case CALLER_PROPAGATION: {
                    sasContext.setCallerPropagation(attValue);
                    break;
                }
                default: {
                    IIOPMetaDataParser.unexpectedAttribute((XMLStreamReader)reader, (int)i);
                }
            }
            requiredAttributes.remove((Object)attribute);
        }
        if (!requiredAttributes.isEmpty()) {
            throw IIOPMetaDataParser.missingRequiredAttributes((XMLStreamReader)reader, requiredAttributes);
        }
        if (reader.nextTag() != 2) {
            throw IIOPMetaDataParser.unexpectedElement((XMLStreamReader)reader);
        }
        return sasContext;
    }

    protected IORSASContextMetaData processSASContextLegacy(XMLStreamReader reader, PropertyReplacer propertyReplacer) throws XMLStreamException {
        IIOPMetaDataParser.requireNoAttributes((XMLStreamReader)reader);
        EnumSet<Element> requiredElements = EnumSet.of(Element.CALLER_PROPAGATION);
        IORSASContextMetaData sasContext = new IORSASContextMetaData();
        while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case CALLER_PROPAGATION: {
                    IIOPMetaDataParser.requireNoAttributes((XMLStreamReader)reader);
                    sasContext.setCallerPropagation(IIOPMetaDataParser.getElementText((XMLStreamReader)reader, (PropertyReplacer)propertyReplacer));
                    break;
                }
                default: {
                    throw IIOPMetaDataParser.unexpectedElement((XMLStreamReader)reader);
                }
            }
            requiredElements.remove((Object)element);
        }
        if (!requiredElements.isEmpty()) {
            throw IIOPMetaDataParser.missingRequiredElement((XMLStreamReader)reader, requiredElements);
        }
        return sasContext;
    }

    static enum Element {
        UNKNOWN(null),
        BINDING_NAME("binding-name"),
        EJB_NAME("ejb-name"),
        IOR_SECURITY_CONFIG("ior-security-config"),
        TRANSPORT_CONFIG("transport-config"),
        INTEGRITY("integrity"),
        CONFIDENTIALITY("confidentiality"),
        DETECT_MISORDERING("detect-misordering"),
        DETECT_REPLAY("detect-replay"),
        ESTABLISH_TRUST_IN_CLIENT("establish-trust-in-client"),
        ESTABLISH_TRUST_IN_TARGET("establish-trust-in-target"),
        AS_CONTEXT("as-context"),
        AUTH_METHOD("auth-method"),
        REALM("realm"),
        REQUIRED("required"),
        SAS_CONTEXT("sas-context"),
        CALLER_PROPAGATION("caller-propagation");

        private final String name;
        private static final Map<String, Element> MAP;

        private Element(String name) {
            this.name = name;
        }

        public String getLocalName() {
            return this.name;
        }

        public static Element forName(String localName) {
            Element element = MAP.get(localName);
            return element == null ? UNKNOWN : element;
        }

        static {
            HashMap<String, Element> map = new HashMap<String, Element>();
            for (Element element : Element.values()) {
                String name = element.getLocalName();
                if (name == null) continue;
                map.put(name, element);
            }
            MAP = map;
        }
    }

    static enum Attribute {
        UNKNOWN(null),
        INTEGRITY("integrity"),
        CONFIDENTIALITY("confidentiality"),
        DETECT_MISORDERING("detect-misordering"),
        DETECT_REPLAY("detect-replay"),
        ESTABLISH_TRUST_IN_CLIENT("establish-trust-in-client"),
        ESTABLISH_TRUST_IN_TARGET("establish-trust-in-target"),
        AS_CONTEXT("as-context"),
        AUTH_METHOD("auth-method"),
        REALM("realm"),
        REQUIRED("required"),
        SAS_CONTEXT("sas-context"),
        CALLER_PROPAGATION("caller-propagation");

        private final String name;
        private static final Map<String, Attribute> MAP;

        private Attribute(String name) {
            this.name = name;
        }

        public String getLocalName() {
            return this.name;
        }

        public static Attribute forName(String localName) {
            Attribute attribute = MAP.get(localName);
            return attribute == null ? UNKNOWN : attribute;
        }

        static {
            HashMap<String, Attribute> map = new HashMap<String, Attribute>();
            for (Attribute attribute : Attribute.values()) {
                String name = attribute.getLocalName();
                if (name == null) continue;
                map.put(name, attribute);
            }
            MAP = map;
        }
    }

    static enum Namespace {
        UNKNOWN(null),
        EJB3_IIOP("urn:iiop");

        private final String namespaceURI;
        private static final Map<String, Namespace> MAP;

        private Namespace(String namespaceURI) {
            this.namespaceURI = namespaceURI;
        }

        String getUriString() {
            return this.namespaceURI;
        }

        static Namespace forUri(String uri) {
            Namespace element = MAP.get(uri);
            return element == null ? UNKNOWN : element;
        }

        static {
            HashMap<String, Namespace> map = new HashMap<String, Namespace>();
            for (Namespace namespace : Namespace.values()) {
                String name = namespace.getUriString();
                if (name == null) continue;
                map.put(name, namespace);
            }
            MAP = map;
        }
    }
}

