/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.base.accumulators;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.drools.core.base.accumulators.AbstractAccumulateFunction;

public class CollectListAccumulateFunction
extends AbstractAccumulateFunction<CollectListData> {
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
    }

    public void writeExternal(ObjectOutput out) throws IOException {
    }

    public CollectListData createContext() {
        return new CollectListData();
    }

    public void init(CollectListData data) {
        data.list.clear();
    }

    public void accumulate(CollectListData data, Object value) {
        data.list.add(value);
    }

    public void reverse(CollectListData data, Object value) {
        data.list.remove(value);
    }

    public Object getResult(CollectListData data) {
        return Collections.unmodifiableList(data.list);
    }

    public boolean supportsReverse() {
        return true;
    }

    public Class<?> getResultType() {
        return List.class;
    }

    public static class CollectListData
    implements Externalizable {
        public List<Object> list = new ArrayList<Object>();

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.list = (List)in.readObject();
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.list);
        }
    }
}

