/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ejb.infinispan;

import java.time.Duration;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.wildfly.clustering.dispatcher.Command;
import org.wildfly.clustering.dispatcher.CommandDispatcher;
import org.wildfly.clustering.dispatcher.CommandDispatcherException;
import org.wildfly.clustering.dispatcher.CommandDispatcherFactory;
import org.wildfly.clustering.ejb.infinispan.BeanEntry;
import org.wildfly.clustering.ejb.infinispan.BeanFactory;
import org.wildfly.clustering.ejb.infinispan.BeanGroupEvictor;
import org.wildfly.clustering.ejb.infinispan.ImmutableBeanEntry;
import org.wildfly.clustering.ejb.infinispan.Scheduler;
import org.wildfly.clustering.ejb.infinispan.logging.InfinispanEjbLogger;
import org.wildfly.clustering.group.Node;
import org.wildfly.clustering.infinispan.spi.distribution.Locality;

public class EagerEvictionScheduler<I, T>
implements Scheduler<I>,
BeanGroupEvictor<I>,
Consumer<I> {
    private final Map<I, Future<?>> evictionFutures = new ConcurrentHashMap();
    private final BeanFactory<I, T> factory;
    private final ScheduledExecutorService executor;
    private final Duration idleTimeout;
    private final CommandDispatcher<BeanGroupEvictor<I>> dispatcher;

    public EagerEvictionScheduler(BeanFactory<I, T> factory, BeanGroupEvictor<I> evictor, ScheduledExecutorService executor, Duration idleTimeout, CommandDispatcherFactory dispatcherFactory, String dispatcherName) {
        this.factory = factory;
        this.executor = executor;
        this.idleTimeout = idleTimeout;
        this.dispatcher = dispatcherFactory.createCommandDispatcher((Object)(dispatcherName + "/eviction"), evictor);
    }

    @Override
    public void accept(I id) {
        this.evictionFutures.remove(id);
    }

    @Override
    public void schedule(I id) {
        BeanEntry entry = (BeanEntry)this.factory.findValue(id);
        if (entry != null) {
            this.schedule(id, entry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void schedule(I id, ImmutableBeanEntry<I> entry) {
        EvictionTask<I> task;
        InfinispanEjbLogger.ROOT_LOGGER.tracef("Scheduling stateful session bean %s to passivate in %s", id, this.idleTimeout);
        EvictionTask<I> evictionTask = task = new EvictionTask<I>(this, id, entry.getGroupId(), this);
        synchronized (evictionTask) {
            this.evictionFutures.put(id, this.executor.schedule(task, this.idleTimeout.toMillis(), TimeUnit.MILLISECONDS));
        }
    }

    @Override
    public void prepareRescheduling(I id) {
        this.cancel(id);
    }

    @Override
    public void cancel(I id) {
        Future<?> future = this.evictionFutures.remove(id);
        if (future != null) {
            future.cancel(false);
        }
    }

    @Override
    public void cancel(Locality locality) {
        for (I id : this.evictionFutures.keySet()) {
            if (Thread.currentThread().isInterrupted()) break;
            if (locality.isLocal(id)) continue;
            this.cancel(id);
        }
    }

    @Override
    public void close() {
        for (Future<?> future : this.evictionFutures.values()) {
            future.cancel(false);
        }
        for (Future<?> future : this.evictionFutures.values()) {
            if (future.isDone()) continue;
            try {
                future.get();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (ExecutionException executionException) {}
        }
        this.evictionFutures.clear();
        this.dispatcher.close();
    }

    @Override
    public void evict(I id) {
        try {
            this.dispatcher.executeOnGroup(new EvictCommand<I>(id), new Node[0]);
        }
        catch (CommandDispatcherException e) {
            InfinispanEjbLogger.ROOT_LOGGER.warn(e.getLocalizedMessage(), e);
        }
    }

    private static class EvictionTask<I>
    implements Runnable {
        private final BeanGroupEvictor<I> evictor;
        private final I beanId;
        private final I groupId;
        private final Consumer<I> finalizer;

        EvictionTask(BeanGroupEvictor<I> evictor, I beanId, I groupId, Consumer<I> finalizer) {
            this.evictor = evictor;
            this.beanId = beanId;
            this.groupId = groupId;
            this.finalizer = finalizer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                this.evictor.evict(this.groupId);
            }
            finally {
                EvictionTask evictionTask = this;
                synchronized (evictionTask) {
                    this.finalizer.accept(this.beanId);
                }
            }
        }
    }

    static class EvictCommand<I>
    implements Command<Void, BeanGroupEvictor<I>> {
        private static final long serialVersionUID = -7382608648983713382L;
        private final I id;

        EvictCommand(I id) {
            this.id = id;
        }

        public Void execute(BeanGroupEvictor<I> evictor) throws Exception {
            InfinispanEjbLogger.ROOT_LOGGER.tracef("Passivating stateful session bean %s", this.id);
            evictor.evict(this.id);
            return null;
        }
    }
}

