/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container.versioning;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.Set;
import org.infinispan.commons.marshall.AbstractExternalizer;
import org.infinispan.container.versioning.EntryVersion;
import org.infinispan.container.versioning.IncrementableEntryVersion;
import org.infinispan.container.versioning.InequalVersionComparisonResult;

public class NumericVersion
implements IncrementableEntryVersion {
    private final long version;

    public NumericVersion(long version) {
        this.version = version;
    }

    public long getVersion() {
        return this.version;
    }

    @Override
    public InequalVersionComparisonResult compareTo(EntryVersion other) {
        if (other instanceof NumericVersion) {
            NumericVersion otherVersion = (NumericVersion)other;
            if (this.version < otherVersion.version) {
                return InequalVersionComparisonResult.BEFORE;
            }
            if (this.version > otherVersion.version) {
                return InequalVersionComparisonResult.AFTER;
            }
            return InequalVersionComparisonResult.EQUAL;
        }
        throw new IllegalArgumentException("Unable to compare other types: " + other.getClass().getName());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NumericVersion that = (NumericVersion)o;
        return this.version == that.version;
    }

    public int hashCode() {
        return (int)(this.version ^ this.version >>> 32);
    }

    public String toString() {
        return "NumericVersion{version=" + this.version + '}';
    }

    public static class Externalizer
    extends AbstractExternalizer<NumericVersion> {
        public Set<Class<? extends NumericVersion>> getTypeClasses() {
            return Collections.singleton(NumericVersion.class);
        }

        public void writeObject(ObjectOutput output, NumericVersion object) throws IOException {
            output.writeLong(object.version);
        }

        public NumericVersion readObject(ObjectInput input) throws IOException {
            return new NumericVersion(input.readLong());
        }

        public Integer getId() {
            return 58;
        }
    }
}

