"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
var spec_1 = require("../../state/utils/spec");
var specs_1 = require("../../utils/specs");
var dimensions_1 = require("../rect/dimensions");
var utils_1 = require("../utils");
function computeLineAnnotationTooltipState(cursorPosition, annotationLines, groupId, domainType, axesSpecs, chartDimensions) {
    var _a = spec_1.getAxesSpecForSpecId(axesSpecs, groupId), xAxis = _a.xAxis, yAxis = _a.yAxis;
    var isXDomainAnnotation = utils_1.isXDomain(domainType);
    var annotationAxis = isXDomainAnnotation ? xAxis : yAxis;
    if (!annotationAxis) {
        return null;
    }
    var projectedPointer = utils_1.getTransformedCursor(cursorPosition, chartDimensions, null, true);
    var totalAnnotationLines = annotationLines.length;
    for (var i = 0; i < totalAnnotationLines; i++) {
        var line = annotationLines[i];
        if (isWithinLineMarkerBounds(projectedPointer, line.marker)) {
            var position = utils_1.invertTranformedCursor({
                x: line.marker.position.left,
                y: line.marker.position.top,
            }, chartDimensions, null, true);
            return __assign(__assign({ annotationType: specs_1.AnnotationTypes.Line, isVisible: true, anchor: __assign({ top: position.y, left: position.x }, line.marker.dimension) }, (line.details && { header: line.details.headerText })), (line.details && { details: line.details.detailsText }));
        }
    }
    return null;
}
exports.computeLineAnnotationTooltipState = computeLineAnnotationTooltipState;
function isWithinLineMarkerBounds(cursorPosition, marker) {
    if (!marker) {
        return false;
    }
    var _a = marker.position, top = _a.top, left = _a.left;
    var _b = marker.dimension, width = _b.width, height = _b.height;
    var markerRect = { startX: left, startY: top, endX: left + width, endY: top + height };
    return dimensions_1.isWithinRectBounds(cursorPosition, markerRect);
}
//# sourceMappingURL=tooltip.js.map