"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var commons_1 = require("../../../utils/commons");
function isLowerBound(domain) {
    return domain.min != null;
}
exports.isLowerBound = isLowerBound;
function isUpperBound(domain) {
    return domain.max != null;
}
exports.isUpperBound = isUpperBound;
function isCompleteBound(domain) {
    return domain.max != null && domain.min != null;
}
exports.isCompleteBound = isCompleteBound;
function isBounded(domain) {
    return domain.max != null || domain.min != null;
}
exports.isBounded = isBounded;
function isVerticalAxis(axisPosition) {
    return axisPosition === commons_1.Position.Left || axisPosition === commons_1.Position.Right;
}
exports.isVerticalAxis = isVerticalAxis;
function isHorizontalAxis(axisPosition) {
    return axisPosition === commons_1.Position.Top || axisPosition === commons_1.Position.Bottom;
}
exports.isHorizontalAxis = isHorizontalAxis;
function isVerticalGrid(axisPosition) {
    return isHorizontalAxis(axisPosition);
}
exports.isVerticalGrid = isVerticalGrid;
function isHorizontalGrid(axisPosition) {
    return isVerticalAxis(axisPosition);
}
exports.isHorizontalGrid = isHorizontalGrid;
//# sourceMappingURL=axis_type_utils.js.map