/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import java.io.IOException;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.languagetool.AnalyzedSentence;
import org.languagetool.JLanguageTool;
import org.languagetool.TestTools;
import org.languagetool.rules.CommaWhitespaceRule;
import org.languagetool.rules.RuleMatch;

public class CommaWhitespaceRuleTest {
    private CommaWhitespaceRule rule;
    private JLanguageTool lt;

    @Before
    public void setUp() {
        this.rule = new CommaWhitespaceRule(TestTools.getEnglishMessages());
        this.lt = new JLanguageTool(TestTools.getDemoLanguage());
    }

    @Test
    public void testRule() throws IOException {
        this.assertMatches("This is a test sentence.", 0);
        this.assertMatches("I use .MP3 or .WAV file suffix", 0);
        this.assertMatches("This, is, a test sentence.", 0);
        this.assertMatches("This (foo bar) is a test!.", 0);
        this.assertMatches("Das kostet \u20ac2,45.", 0);
        this.assertMatches("Das kostet 50,- Euro", 0);
        this.assertMatches("This is a sentence with ellipsis ...", 0);
        this.assertMatches("This is a figure: .5 and it's correct.", 0);
        this.assertMatches("This is $1,000,000.", 0);
        this.assertMatches("This is 1,5.", 0);
        this.assertMatches("This is a ,,test''.", 0);
        this.assertMatches("Run ./validate.sh to check the file.", 0);
        this.assertMatches("This is,\u00a0really,\u00a0non-breaking whitespace.", 0);
        this.assertMatches("In his book,\u0002 Einstein proved this to be true.", 0);
        this.assertMatches("- [ ] A checkbox at GitHub", 0);
        this.assertMatches("- [x] A checked checkbox at GitHub", 0);
        this.assertMatches("A sentence 'with' ten \"correct\" examples of \u2019using\u2019 quotation \u201cmarks\u201d at \u00abonce\u00bb in it.", 0);
        this.assertMatches("I'd recommend resaving the .DOC as a PDF file.", 0);
        this.assertMatches("I'd recommend resaving the .mp3 as a WAV file.", 0);
        this.assertMatches("I'd suggest buying the .org domain.", 0);
        this.assertMatches(". This isn't good.", 0);
        this.assertMatches("), this isn't good.", 0);
        this.assertMatches("Das sind .exe-Dateien", 0);
        this.assertMatches("I live in .Los Angeles", 1);
        this.assertMatchesForText("Die Vertriebsniederlassu\u00adng der Versorgungstechnik..\u00ad.", 1);
        this.assertMatchesForText("Die Vertriebsniederlassu\u00adng der Versorgungstechnik..\u00ad.\n", 1);
        this.assertMatches("This,is a test sentence.", 1);
        this.assertMatches("This , is a test sentence.", 1);
        this.assertMatches("This ,is a test sentence.", 2);
        this.assertMatches(",is a test sentence.", 2);
        this.assertMatches("This ( foo bar) is a test!.", 1);
        this.assertMatches("This (foo bar ) is a test!.", 1);
        this.assertMatches("This [ foo bar) is a test!.", 1);
        this.assertMatches("This (foo bar ] is a test!.", 1);
        this.assertMatches("This { foo bar) is a test!.", 1);
        this.assertMatches("This (foo bar } is a test!.", 1);
        this.assertMatches("This is a sentence with an orphaned full stop .", 1);
        this.assertMatches("This is a test with a OOo footnote\u0002, which is denoted by 0x2 in the text.", 0);
        this.assertMatches("A sentence ' with ' ten \" incorrect \" examples of \u2019 using \u2019 quotation \u201c marks \u201d at \u00ab once \u00bb in it.", 10);
        this.assertMatches("A sentence ' with' one examples of wrong quotations marks in it.", 1);
        this.assertMatches("A sentence 'with ' one examples of wrong quotations marks in it.", 1);
        RuleMatch[] matches = this.rule.match(this.lt.getAnalyzedSentence("ABB (  z.B. )"));
        Assert.assertEquals((long)2L, (long)matches.length);
        Assert.assertEquals((long)4L, (long)matches[0].getFromPos());
        Assert.assertEquals((long)6L, (long)matches[0].getToPos());
        Assert.assertEquals((long)11L, (long)matches[1].getFromPos());
        Assert.assertEquals((long)13L, (long)matches[1].getToPos());
        matches = this.rule.match(this.lt.getAnalyzedSentence("This ,"));
        Assert.assertEquals((long)1L, (long)matches.length);
        Assert.assertEquals((Object)",", matches[0].getSuggestedReplacements().get(0));
        matches = this.rule.match(this.lt.getAnalyzedSentence("This ,is a test sentence."));
        Assert.assertEquals((long)2L, (long)matches.length);
        Assert.assertEquals((Object)", ", matches[0].getSuggestedReplacements().get(0));
        matches = this.rule.match(this.lt.getAnalyzedSentence("This , is a test sentence."));
        Assert.assertEquals((long)1L, (long)matches.length);
        Assert.assertEquals((Object)",", matches[0].getSuggestedReplacements().get(0));
        matches = this.rule.match(this.lt.getAnalyzedSentence("You \" fixed\" it."));
        Assert.assertEquals((long)1L, (long)matches.length);
        Assert.assertEquals((Object)"\" ", matches[0].getSuggestedReplacements().get(0));
        Assert.assertEquals((Object)" \"", matches[0].getSuggestedReplacements().get(1));
        Assert.assertEquals((long)3L, (long)matches[0].getFromPos());
        Assert.assertEquals((long)6L, (long)matches[0].getToPos());
        matches = this.rule.match(this.lt.getAnalyzedSentence("You \"fixed \" it."));
        Assert.assertEquals((long)1L, (long)matches.length);
        Assert.assertEquals((Object)"\" ", matches[0].getSuggestedReplacements().get(0));
        Assert.assertEquals((Object)" \"", matches[0].getSuggestedReplacements().get(1));
        Assert.assertEquals((long)10L, (long)matches[0].getFromPos());
        Assert.assertEquals((long)13L, (long)matches[0].getToPos());
        this.assertMatches("Ellipsis . . . as suggested by The Chicago Manual of Style", 3);
        this.assertMatches("Ellipsis . . . . as suggested by The Chicago Manual of Style", 4);
    }

    private void assertMatches(String text, int expectedMatches) throws IOException {
        Assert.assertEquals((long)expectedMatches, (long)this.rule.match(this.lt.getAnalyzedSentence(text)).length);
    }

    private void assertMatchesForText(String text, int expectedMatches) throws IOException {
        List analyzedSentences = this.lt.analyzeText(text);
        int matchCount = 0;
        for (AnalyzedSentence analyzedSentence : analyzedSentences) {
            matchCount += this.rule.match(analyzedSentence).length;
        }
        Assert.assertEquals((long)expectedMatches, (long)matchCount);
    }
}

