# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.unstructured_grid_algorithm import UnstructuredGridAlgorithm


class CellTypeSource(UnstructuredGridAlgorithm):
    """
    CellTypeSource - Create cells of a given type
    
    Superclass: UnstructuredGridAlgorithm
    
    CellTypeSource is a source object that creates cells of the given
    input type. blocks_dimensions specifies the number of cell "blocks" in
    each direction. A cell block may be divided into multiple cells based
    on the chosen cell type (e.g. 6 pyramid cells make up a single cell
    block). If a 1d cell is selected then only the first dimension is
    used to specify how many cells are generated. If a 2d cell is
    selected then only the first and second dimensions are used to
    determine how many cells are created. The source respects pieces.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkCellTypeSource, obj, update, **traits)
    
    complete_quadratic_simplicial_elements = tvtk_base.false_bool_trait(desc=\
        """
        Set/Get whether quadratic cells with simplicial shapes should be
        "completed".
        
        By default, quadratic Lagrange cells with simplicial shapes do
        not completely span the basis of all polynomial of the maximal
        degree. This can be corrected by adding mid-face and
        body-centered nodes. Setting this option to true will generate
        cells with these additional nodes.
        
        This is only used when (1) the cell type is a Lagrange triangle,
        tetrahedron, or wedge; and (2) cell_order is set to 2 (quadratic
        elements). The default is false.
        
        When true, generated (1) triangles will have 7 nodes instead of
        6; (2) tetrahedra will have 15 nodes instead of 10; (3) wedges
        will have 21 nodes instead of 18.
        """
    )

    def _complete_quadratic_simplicial_elements_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetCompleteQuadraticSimplicialElements,
                        self.complete_quadratic_simplicial_elements_)

    blocks_dimensions = traits.Array(enter_set=True, auto_set=False, shape=(3,), dtype="int", value=(1, 1, 1), cols=3, desc=\
        """
        Set the number of cells in each direction. If a 1d cell type is
        selected then only the first dimension is used and if a 2d cell
        type is selected then the first and second dimensions are used.
        Default is (1, 1, 1), which results in a single block of cells.
        """
    )

    def _blocks_dimensions_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetBlocksDimensions,
                        self.blocks_dimensions)

    cell_order = traits.Int(3, enter_set=True, auto_set=False, desc=\
        """
        Set/Get the order of Lagrange interpolation to be used.
        
        This is only used when the cell type is a Lagrange element. The
        default is cubic (order 3). Lagrange elements are the same order
        along all axes (i.e., you cannot specify a different
        interpolation order for the i, j, and k axes of a hexahedron).
        """
    )

    def _cell_order_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetCellOrder,
                        self.cell_order)

    cell_type = traits.Int(12, enter_set=True, auto_set=False, desc=\
        """
        Set/Get the type of cells to be generated.
        """
    )

    def _cell_type_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetCellType,
                        self.cell_type)

    output_precision = traits.Trait(0, traits.Range(0, 1, enter_set=True, auto_set=False), desc=\
        """
        Set/get the desired precision for the output points.
        Algorithm::SINGLE_PRECISION (0) - Output single-precision
        floating point. Algorithm::DOUBLE_PRECISION (1) - Output
        double-precision floating point.
        """
    )

    def _output_precision_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetOutputPrecision,
                        self.output_precision)

    polynomial_field_order = traits.Trait(1, traits.Range(0, 2147483647, enter_set=True, auto_set=False), desc=\
        """
        Set/Get the polynomial order of the "Polynomial" point field. The
        default is 1.
        """
    )

    def _polynomial_field_order_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetPolynomialFieldOrder,
                        self.polynomial_field_order)

    def _get_cell_dimension(self):
        return self._vtk_obj.GetCellDimension()
    cell_dimension = traits.Property(_get_cell_dimension, desc=\
        """
        Get the dimension of the cell blocks to be generated
        """
    )

    def _get_input(self):
        try:
            return wrap_vtk(self._vtk_obj.GetInput(0))
        except TypeError:
            return wrap_vtk(self._vtk_obj.GetInput())
    input = traits.Property(_get_input,
                            desc="The first input of this object, i.e. the result of `get_input(0)`.")
    
    def get_input(self, *args):
        """
        V.get_input(int) -> DataObject
        C++: DataObject *GetInput(int port)
        V.get_input() -> DataObject
        C++: DataObject *GetInput()"""
        ret = self._wrap_call(self._vtk_obj.GetInput, *args)
        return wrap_vtk(ret)

    _updateable_traits_ = \
    (('complete_quadratic_simplicial_elements',
    'GetCompleteQuadraticSimplicialElements'), ('abort_execute',
    'GetAbortExecute'), ('release_data_flag', 'GetReleaseDataFlag'),
    ('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('blocks_dimensions',
    'GetBlocksDimensions'), ('cell_order', 'GetCellOrder'), ('cell_type',
    'GetCellType'), ('output_precision', 'GetOutputPrecision'),
    ('polynomial_field_order', 'GetPolynomialFieldOrder'), ('progress',
    'GetProgress'), ('progress_text', 'GetProgressText'),
    ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'complete_quadratic_simplicial_elements', 'debug',
    'global_warning_display', 'release_data_flag', 'blocks_dimensions',
    'cell_order', 'cell_type', 'output_precision',
    'polynomial_field_order', 'progress_text'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(CellTypeSource, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit CellTypeSource properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['complete_quadratic_simplicial_elements'], [],
            ['blocks_dimensions', 'cell_order', 'cell_type', 'output_precision',
            'polynomial_field_order']),
            title='Edit CellTypeSource properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit CellTypeSource properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

