/*
 * Decompiled with CFR 0.152.
 */
package mediathek.javafx.filmlist;

import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.util.Duration;
import mediathek.config.Daten;
import mediathek.javafx.tool.ComputedLabel;
import org.apache.commons.lang3.time.DurationFormatUtils;

public class FilmListAgeLabel
extends ComputedLabel {
    private Timeline timeline;

    FilmListAgeLabel() {
        this.setupTimer();
    }

    public void enableTimer() {
        this.timeline.play();
    }

    public void disableTimer() {
        this.timeline.pause();
    }

    private void setupTimer() {
        this.timeline = new Timeline(new KeyFrame(Duration.millis(1000.0), ae -> this.setAgeToLabel(), new KeyValue[0]));
        this.timeline.setCycleCount(-1);
        this.timeline.play();
    }

    private void setAgeToLabel() {
        this.setComputedText(this.computeAge(Daten.getInstance().getListeFilme().getAge()));
    }

    private String computeAge(long seconds) {
        java.time.Duration duration = java.time.Duration.ofSeconds(seconds);
        return String.format("Alter: %s", DurationFormatUtils.formatDuration(duration.toMillis(), "HH:mm:ss"));
    }
}

