/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.model.search;

import com.google.common.base.Stopwatch;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.UnmodifiableIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.SwingUtilities;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.model.OWLModelManager;
import org.protege.editor.owl.model.event.EventType;
import org.protege.editor.owl.model.event.OWLModelManagerChangeEvent;
import org.protege.editor.owl.model.event.OWLModelManagerListener;
import org.protege.editor.owl.model.search.SearchCategory;
import org.protege.editor.owl.model.search.SearchManager;
import org.protege.editor.owl.model.search.SearchMetadata;
import org.protege.editor.owl.model.search.SearchMetadataDB;
import org.protege.editor.owl.model.search.SearchMetadataImportManager;
import org.protege.editor.owl.model.search.SearchMetadataImporter;
import org.protege.editor.owl.model.search.SearchRequest;
import org.protege.editor.owl.model.search.SearchResult;
import org.protege.editor.owl.model.search.SearchResultHandler;
import org.protege.editor.owl.model.search.SearchResultMatch;
import org.semanticweb.owlapi.model.OWLOntologyChangeListener;
import org.semanticweb.owlapi.util.ProgressMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSearchManager
extends SearchManager {
    private final Logger logger = LoggerFactory.getLogger(DefaultSearchManager.class);
    private OWLEditorKit editorKit;
    private ExecutorService service = Executors.newSingleThreadExecutor();
    private AtomicLong lastSearchId = new AtomicLong(0L);
    private Set<SearchCategory> categories = new HashSet<SearchCategory>();
    private List<SearchMetadata> searchMetadataCache = new ArrayList<SearchMetadata>();
    private OWLOntologyChangeListener ontologyChangeListener;
    private OWLModelManagerListener modelManagerListener;
    private SearchMetadataImportManager importManager;
    private final List<ProgressMonitor> progressMonitors = new ArrayList<ProgressMonitor>();

    public void initialise() {
        this.editorKit = this.getEditorKit();
        this.importManager = new SearchMetadataImportManager();
        this.categories.add(SearchCategory.DISPLAY_NAME);
        this.categories.add(SearchCategory.IRI);
        this.categories.add(SearchCategory.ANNOTATION_VALUE);
        this.categories.add(SearchCategory.LOGICAL_AXIOM);
        this.ontologyChangeListener = changes -> this.markCacheAsStale();
        this.modelManagerListener = this::handleModelManagerEvent;
        this.editorKit.getModelManager().addListener(this.modelManagerListener);
        this.editorKit.getOWLModelManager().addOntologyChangeListener(this.ontologyChangeListener);
    }

    @Override
    public void addProgressMonitor(ProgressMonitor pm) {
        this.progressMonitors.add(pm);
    }

    @Override
    public void dispose() {
        if (this.editorKit == null) {
            return;
        }
        OWLModelManager modelMan = this.editorKit.getOWLModelManager();
        modelMan.removeOntologyChangeListener(this.ontologyChangeListener);
        modelMan.removeListener(this.modelManagerListener);
    }

    private void handleModelManagerEvent(OWLModelManagerChangeEvent event) {
        if (this.isCacheMutatingEvent(event)) {
            this.markCacheAsStale();
        }
    }

    private boolean isCacheMutatingEvent(OWLModelManagerChangeEvent event) {
        return event.isType(EventType.ACTIVE_ONTOLOGY_CHANGED) || event.isType(EventType.ENTITY_RENDERER_CHANGED) || event.isType(EventType.ENTITY_RENDERING_CHANGED);
    }

    private void markCacheAsStale() {
        this.lastSearchId.set(0L);
    }

    @Override
    public boolean isSearchType(SearchCategory category) {
        return this.categories.contains((Object)category);
    }

    @Override
    public void setCategories(Collection<SearchCategory> categories) {
        this.categories.clear();
        this.categories.addAll(categories);
        this.markCacheAsStale();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rebuildMetadataCache() {
        Stopwatch stopwatch = Stopwatch.createStarted();
        this.logger.info("Rebuilding search metadata cache...");
        this.fireIndexingStarted();
        try {
            this.searchMetadataCache.clear();
            List<SearchMetadataImporter> importerList = this.importManager.getImporters();
            for (SearchMetadataImporter importer : importerList) {
                SearchMetadataDB db = importer.getSearchMetadata(this.editorKit, this.categories);
                this.searchMetadataCache.addAll(db.getResults());
            }
            stopwatch.stop();
            this.logger.info("    ...rebuilt search metadata cache in {} ms", (Object)stopwatch.elapsed(TimeUnit.MILLISECONDS));
        }
        catch (Exception e) {
            this.logger.error("An error occurred whilst rebuilding the search metadata cache: {}", (Object)e.getMessage(), (Object)e);
        }
        finally {
            this.fireIndexingFinished();
        }
    }

    @Override
    public void performSearch(SearchRequest searchRequest, SearchResultHandler searchResultHandler) {
        if (this.lastSearchId.getAndIncrement() == 0L) {
            this.service.submit(this::rebuildMetadataCache);
        }
        this.service.submit(new SearchCallable(this.lastSearchId.incrementAndGet(), searchRequest, searchResultHandler));
    }

    private void fireIndexingFinished() {
        SwingUtilities.invokeLater(() -> {
            for (ProgressMonitor pm : this.progressMonitors) {
                pm.setFinished();
                pm.setIndeterminate(false);
            }
        });
    }

    private void fireIndexingStarted() {
        SwingUtilities.invokeLater(() -> {
            for (ProgressMonitor pm : this.progressMonitors) {
                pm.setIndeterminate(true);
                pm.setMessage("Searching");
                pm.setStarted();
            }
        });
    }

    private void fireSearchStarted() {
        SwingUtilities.invokeLater(() -> {
            for (ProgressMonitor pm : this.progressMonitors) {
                pm.setSize(100L);
                pm.setStarted();
            }
        });
    }

    private void fireSearchProgressed(long progress, int found) {
        SwingUtilities.invokeLater(() -> {
            for (ProgressMonitor pm : this.progressMonitors) {
                pm.setProgress(progress);
                if (found > 1 || found == 0) {
                    pm.setMessage(found + " results");
                    continue;
                }
                pm.setMessage(found + " result");
            }
        });
    }

    private void fireSearchFinished() {
        SwingUtilities.invokeLater(() -> {
            for (ProgressMonitor pm : this.progressMonitors) {
                pm.setFinished();
            }
        });
    }

    private class SearchCallable
    implements Runnable {
        private long searchId;
        private SearchRequest searchRequest;
        private SearchResultHandler searchResultHandler;

        private SearchCallable(long searchId, SearchRequest searchRequest, SearchResultHandler searchResultHandler) {
            this.searchId = searchId;
            this.searchRequest = searchRequest;
            this.searchResultHandler = searchResultHandler;
        }

        @Override
        public void run() {
            StringBuilder patternString = new StringBuilder();
            UnmodifiableIterator it = this.searchRequest.getSearchPatterns().iterator();
            while (it.hasNext()) {
                Pattern pattern = (Pattern)it.next();
                patternString.append(pattern.pattern());
                if (!it.hasNext()) continue;
                patternString.append("  AND  ");
            }
            DefaultSearchManager.this.logger.info("Starting search {} (pattern: {})", (Object)this.searchId, (Object)patternString);
            ArrayList<SearchResult> results = new ArrayList<SearchResult>();
            long searchStartTime = System.currentTimeMillis();
            DefaultSearchManager.this.fireSearchStarted();
            long count = 0L;
            int total = DefaultSearchManager.this.searchMetadataCache.size();
            int percent = 0;
            for (SearchMetadata searchMetadata : DefaultSearchManager.this.searchMetadataCache) {
                int nextPercent;
                if (!this.isLatestSearch()) {
                    DefaultSearchManager.this.logger.info("    Terminating search {} prematurely", (Object)this.searchId);
                    return;
                }
                String text = searchMetadata.getSearchString();
                boolean matchedAllPatterns = true;
                int startIndex = 0;
                ImmutableList.Builder matchesBuilder = ImmutableList.builder();
                for (Pattern pattern : this.searchRequest.getSearchPatterns()) {
                    if (startIndex >= text.length()) {
                        matchedAllPatterns = false;
                        break;
                    }
                    Matcher matcher = pattern.matcher(text);
                    if (matcher.find()) {
                        SearchResultMatch match = new SearchResultMatch(pattern, matcher.start(), matcher.end());
                        matchesBuilder.add((Object)match);
                        startIndex = matcher.end() + 1;
                        continue;
                    }
                    matchedAllPatterns = false;
                    break;
                }
                if (matchedAllPatterns) {
                    results.add(new SearchResult(searchMetadata, (ImmutableList<SearchResultMatch>)matchesBuilder.build()));
                }
                if ((nextPercent = (int)(++count * 100L / (long)total)) == percent) continue;
                percent = nextPercent;
                DefaultSearchManager.this.fireSearchProgressed(percent, results.size());
            }
            DefaultSearchManager.this.fireSearchFinished();
            long searchEndTime = System.currentTimeMillis();
            long searchTime = searchEndTime - searchStartTime;
            DefaultSearchManager.this.logger.info("    Finished search {} in {} ms ({} results)", new Object[]{this.searchId, searchTime, results.size()});
            this.fireSearchFinished(results, this.searchResultHandler);
        }

        private boolean isLatestSearch() {
            return this.searchId == DefaultSearchManager.this.lastSearchId.get();
        }

        private void fireSearchFinished(List<SearchResult> results, SearchResultHandler searchResultHandler) {
            if (SwingUtilities.isEventDispatchThread()) {
                searchResultHandler.searchFinished(results);
            } else {
                SwingUtilities.invokeLater(() -> searchResultHandler.searchFinished(results));
            }
        }
    }
}

