/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.resolver.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.apache.felix.resolver.util.CopyOnWriteSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CopyOnWriteList<E>
implements List<E>,
Cloneable {
    Object[] data;

    public CopyOnWriteList() {
        this.data = new Object[0];
    }

    public CopyOnWriteList(CopyOnWriteList<? extends E> col) {
        this.data = col.data;
    }

    public CopyOnWriteList(Collection<? extends E> col) {
        this.data = col.toArray(new Object[col.size()]);
    }

    @Override
    public int size() {
        return this.data.length;
    }

    @Override
    public E get(int index) {
        return (E)this.data[index];
    }

    @Override
    public E set(int index, E element) {
        this.data = CopyOnWriteSet.copyOf(this.data, this.data.length);
        Object prev = this.data[index];
        this.data[index] = element;
        return (E)prev;
    }

    @Override
    public void add(int index, E element) {
        Object[] elements = this.data;
        int len = elements.length;
        Object[] newElements = new Object[len + 1];
        int numMoved = len - index;
        if (index > 0) {
            System.arraycopy(elements, 0, newElements, 0, index);
        }
        if (numMoved > 0) {
            System.arraycopy(elements, index, newElements, index + 1, numMoved);
        }
        newElements[index] = element;
        this.data = newElements;
    }

    @Override
    public E remove(int index) {
        Object[] elements = this.data;
        int len = elements.length;
        Object oldValue = elements[index];
        Object[] newElements = new Object[len - 1];
        int numMoved = len - index - 1;
        if (index > 0) {
            System.arraycopy(elements, 0, newElements, 0, index);
        }
        if (numMoved > 0) {
            System.arraycopy(elements, index + 1, newElements, index, numMoved);
        }
        this.data = newElements;
        return (E)oldValue;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean contains(Object o) {
        return this.indexOf(o) >= 0;
    }

    @Override
    public Iterator<E> iterator() {
        return new Iterator<E>(){
            int idx = 0;

            @Override
            public boolean hasNext() {
                return this.idx < CopyOnWriteList.this.data.length;
            }

            @Override
            public E next() {
                return CopyOnWriteList.this.data[this.idx++];
            }

            @Override
            public void remove() {
                CopyOnWriteList.this.remove(--this.idx);
            }
        };
    }

    @Override
    public Object[] toArray() {
        return (Object[])this.data.clone();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        int size = this.data.length;
        if (a.length < size) {
            return CopyOnWriteSet.copyOf(this.data, size, a.getClass());
        }
        System.arraycopy(this.data, 0, a, 0, size);
        if (a.length > size) {
            a[size] = null;
        }
        return a;
    }

    @Override
    public boolean add(E e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        int index = this.indexOf(o);
        if (index >= 0) {
            this.remove(index);
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        Object[] elements = this.data;
        int len = elements.length;
        for (Object e : c) {
            if (CopyOnWriteList.indexOf(e, elements, len) >= 0) continue;
            return false;
        }
        return true;
    }

    private static int indexOf(Object o, Object[] d, int len) {
        if (o == null) {
            int i = len;
            while (i-- > 0) {
                if (d[i] != null) continue;
                return i;
            }
        } else {
            int i = len;
            while (i-- > 0) {
                if (!o.equals(d[i])) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean modified = false;
        Object[] d = this.data;
        Object[] o = this.data;
        int idx = 0;
        int l = o.length;
        for (int i = 0; i < l; ++i) {
            if (c.contains(o[i])) {
                if (modified) continue;
                d = (Object[])o.clone();
                idx = i;
                modified = true;
                continue;
            }
            if (!modified) continue;
            d[idx++] = o[i];
        }
        if (modified) {
            this.data = CopyOnWriteSet.copyOf(d, idx);
        }
        return modified;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        this.data = new Object[0];
    }

    @Override
    public int indexOf(Object o) {
        return CopyOnWriteList.indexOf(o, this.data, this.data.length);
    }

    @Override
    public int lastIndexOf(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ListIterator<E> listIterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException();
    }

    public CopyOnWriteList<E> clone() {
        try {
            return (CopyOnWriteList)super.clone();
        }
        catch (CloneNotSupportedException exc) {
            InternalError e = new InternalError();
            e.initCause(exc);
            throw e;
        }
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.data);
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof CopyOnWriteList)) {
            return false;
        }
        Object[] o1 = this.data;
        Object[] o2 = ((CopyOnWriteList)o).data;
        if (o1 == o2) {
            return true;
        }
        int i = o1.length;
        if (i != o2.length) {
            return false;
        }
        while (i-- > 0) {
            Object v1 = o1[i];
            Object v2 = o2[i];
            if (v1 != null ? v1.equals(v2) : v2 == null) continue;
            return false;
        }
        return true;
    }
}

