// Copyright (C) 2022 The Qt Company Ltd.
// SPDX-License-Identifier: LicenseRef-Qt-Commercial OR GPL-3.0+ OR GPL-3.0 WITH Qt-GPL-exception-1.0

#pragma once

#include <QSpinBox>
#include <QSlider>
#include <QToolBar>
#include <QValidator>
#include <QWidget>

#include "keyframe.h"

namespace QmlDesigner {

class CurveEditorModel;

class ValidatableSpinBox : public QSpinBox
{
    Q_OBJECT
public:
    ValidatableSpinBox(std::function<bool(int)> validator, QWidget* parent=nullptr);
protected:
    QValidator::State validate(QString &text, int &pos) const override;
private:
    std::function<bool(int)> m_validator;
};


class CurveEditorToolBar : public QToolBar
{
    Q_OBJECT

signals:
    void unifyClicked();

    void interpolationClicked(Keyframe::Interpolation interpol);

    void startFrameChanged(int start);

    void endFrameChanged(int end);

    void currentFrameChanged(int current);

    void zoomChanged(double zoom);

public:
    CurveEditorToolBar(CurveEditorModel *model, QWidget* parent = nullptr);

    void setZoom(double zoom);

    void setCurrentFrame(int current, bool notify);

    void updateBoundsSilent(int start, int end);

private:
    ValidatableSpinBox *m_startSpin;
    ValidatableSpinBox *m_endSpin;
    QSpinBox *m_currentSpin;
    QSlider *m_zoomSlider;
};

} // End namespace QmlDesigner.
