# Print an optspec for argparse to handle cmd's options that are independent of any subcommand.
function __fish_spytrap_adb_global_optspecs
	string join \n v/verbose start-adb-server= h/help V/version
end

function __fish_spytrap_adb_needs_command
	# Figure out if the current invocation already has a command.
	set -l cmd (commandline -opc)
	set -e cmd[1]
	argparse -s (__fish_spytrap_adb_global_optspecs) -- $cmd 2>/dev/null
	or return
	if set -q argv[1]
		# Also print the command, so this can be used to figure out what it is.
		echo $argv[1]
		return 1
	end
	return 0
end

function __fish_spytrap_adb_using_subcommand
	set -l cmd (__fish_spytrap_adb_needs_command)
	test -z "$cmd"
	and return 1
	contains -- $cmd[1] $argv
end

complete -c spytrap-adb -n "__fish_spytrap_adb_needs_command" -l start-adb-server -d 'Configure if an adb server should be started if needed' -r -f -a "{auto\t'',always\t'',never\t''}"
complete -c spytrap-adb -n "__fish_spytrap_adb_needs_command" -s v -l verbose -d 'More verbose logs'
complete -c spytrap-adb -n "__fish_spytrap_adb_needs_command" -s h -l help -d 'Print help'
complete -c spytrap-adb -n "__fish_spytrap_adb_needs_command" -s V -l version -d 'Print version'
complete -c spytrap-adb -n "__fish_spytrap_adb_needs_command" -f -a "scan" -d 'Run a scan on a given device'
complete -c spytrap-adb -n "__fish_spytrap_adb_needs_command" -f -a "list" -d 'List all available devices'
complete -c spytrap-adb -n "__fish_spytrap_adb_needs_command" -f -a "download-ioc" -d 'Download the latest version of stalkerware-indicators ioc.yaml'
complete -c spytrap-adb -n "__fish_spytrap_adb_needs_command" -f -a "completions" -d 'Generate shell completions'
complete -c spytrap-adb -n "__fish_spytrap_adb_needs_command" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c spytrap-adb -n "__fish_spytrap_adb_using_subcommand scan" -l rules -d 'Use specific rule files instead of latest downloaded' -r -F
complete -c spytrap-adb -n "__fish_spytrap_adb_using_subcommand scan" -l start-adb-server -d 'Configure if an adb server should be started if needed' -r -f -a "{auto\t'',always\t'',never\t''}"
complete -c spytrap-adb -n "__fish_spytrap_adb_using_subcommand scan" -l test-load-only
complete -c spytrap-adb -n "__fish_spytrap_adb_using_subcommand scan" -l skip-apps -d 'Do not scan apps for suspicious permissions'
complete -c spytrap-adb -n "__fish_spytrap_adb_using_subcommand scan" -s v -l verbose -d 'More verbose logs'
complete -c spytrap-adb -n "__fish_spytrap_adb_using_subcommand scan" -s h -l help -d 'Print help'
complete -c spytrap-adb -n "__fish_spytrap_adb_using_subcommand list" -l start-adb-server -d 'Configure if an adb server should be started if needed' -r -f -a "{auto\t'',always\t'',never\t''}"
complete -c spytrap-adb -n "__fish_spytrap_adb_using_subcommand list" -s v -l verbose -d 'More verbose logs'
complete -c spytrap-adb -n "__fish_spytrap_adb_using_subcommand list" -s h -l help -d 'Print help'
complete -c spytrap-adb -n "__fish_spytrap_adb_using_subcommand download-ioc" -l start-adb-server -d 'Configure if an adb server should be started if needed' -r -f -a "{auto\t'',always\t'',never\t''}"
complete -c spytrap-adb -n "__fish_spytrap_adb_using_subcommand download-ioc" -s v -l verbose -d 'More verbose logs'
complete -c spytrap-adb -n "__fish_spytrap_adb_using_subcommand download-ioc" -s h -l help -d 'Print help'
complete -c spytrap-adb -n "__fish_spytrap_adb_using_subcommand completions" -l start-adb-server -d 'Configure if an adb server should be started if needed' -r -f -a "{auto\t'',always\t'',never\t''}"
complete -c spytrap-adb -n "__fish_spytrap_adb_using_subcommand completions" -s v -l verbose -d 'More verbose logs'
complete -c spytrap-adb -n "__fish_spytrap_adb_using_subcommand completions" -s h -l help -d 'Print help'
complete -c spytrap-adb -n "__fish_spytrap_adb_using_subcommand help; and not __fish_seen_subcommand_from scan list download-ioc completions help" -f -a "scan" -d 'Run a scan on a given device'
complete -c spytrap-adb -n "__fish_spytrap_adb_using_subcommand help; and not __fish_seen_subcommand_from scan list download-ioc completions help" -f -a "list" -d 'List all available devices'
complete -c spytrap-adb -n "__fish_spytrap_adb_using_subcommand help; and not __fish_seen_subcommand_from scan list download-ioc completions help" -f -a "download-ioc" -d 'Download the latest version of stalkerware-indicators ioc.yaml'
complete -c spytrap-adb -n "__fish_spytrap_adb_using_subcommand help; and not __fish_seen_subcommand_from scan list download-ioc completions help" -f -a "completions" -d 'Generate shell completions'
complete -c spytrap-adb -n "__fish_spytrap_adb_using_subcommand help; and not __fish_seen_subcommand_from scan list download-ioc completions help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
