/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.targets.indy;

import org.jruby.ir.IRClosure;
import org.jruby.ir.targets.BlockCompiler;
import org.jruby.ir.targets.IRBytecodeAdapter;
import org.jruby.ir.targets.indy.ConstructBlockBootstrap;
import org.jruby.org.objectweb.asm.Handle;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Block;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.Signature;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.CodegenUtils;

public class IndyBlockCompiler
implements BlockCompiler {
    private final IRBytecodeAdapter compiler;

    public IndyBlockCompiler(IRBytecodeAdapter compiler) {
        this.compiler = compiler;
    }

    @Override
    public void prepareBlock(IRClosure closure, String parentScopeField, Handle handle, String file2, int line, String encodedArgumentDescriptors, Signature signature) {
        String className = this.compiler.getClassData().clsName;
        String scopeField = handle.getName() + "_StaticScope";
        Handle scopeHandle = new Handle(2, className, scopeField, CodegenUtils.ci(StaticScope.class), false);
        Handle setScopeHandle = new Handle(4, className, scopeField, CodegenUtils.ci(StaticScope.class), false);
        Handle parentScopeHandle = new Handle(2, className, parentScopeField, CodegenUtils.ci(StaticScope.class), false);
        String scopeDescriptor = Helpers.describeScope(closure.getStaticScope());
        long encodedSignature = signature.encode();
        this.compiler.adapter.invokedynamic(handle.getName(), CodegenUtils.sig(Block.class, ThreadContext.class, IRubyObject.class, DynamicScope.class), ConstructBlockBootstrap.PREPARE_BLOCK_BOOTSTRAP, handle, scopeHandle, setScopeHandle, parentScopeHandle, scopeDescriptor, encodedSignature, file2, line, encodedArgumentDescriptors);
    }
}

