/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSGPUShaderModule.h"

#include "ActiveDOMObject.h"
#include "DOMPromiseProxy.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertPromise.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMOperation.h"
#include "JSDOMOperationReturningPromise.h"
#include "JSDOMWrapperCache.h"
#include "JSGPUCompilationInfo.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsGPUShaderModulePrototypeFunction_compilationInfo);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsGPUShaderModuleConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsGPUShaderModule_label);
static JSC_DECLARE_CUSTOM_SETTER(setJSGPUShaderModule_label);

class JSGPUShaderModulePrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSGPUShaderModulePrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSGPUShaderModulePrototype* ptr = new (NotNull, JSC::allocateCell<JSGPUShaderModulePrototype>(vm)) JSGPUShaderModulePrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSGPUShaderModulePrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSGPUShaderModulePrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSGPUShaderModulePrototype, JSGPUShaderModulePrototype::Base);

using JSGPUShaderModuleDOMConstructor = JSDOMConstructorNotConstructable<JSGPUShaderModule>;

template<> const ClassInfo JSGPUShaderModuleDOMConstructor::s_info = { "GPUShaderModule"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSGPUShaderModuleDOMConstructor) };

template<> JSValue JSGPUShaderModuleDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSGPUShaderModuleDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "GPUShaderModule"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSGPUShaderModule::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const HashTableValue JSGPUShaderModulePrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsGPUShaderModuleConstructor, 0 } },
    { "label"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsGPUShaderModule_label, setJSGPUShaderModule_label } },
    { "compilationInfo"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsGPUShaderModulePrototypeFunction_compilationInfo, 0 } },
};

const ClassInfo JSGPUShaderModulePrototype::s_info = { "GPUShaderModule"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSGPUShaderModulePrototype) };

void JSGPUShaderModulePrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSGPUShaderModule::info(), JSGPUShaderModulePrototypeTableValues, *this);
    bool hasDisabledRuntimeProperties = false;
    if (!jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().webGPUEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "label"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (hasDisabledRuntimeProperties && structure()->isDictionary())
        flattenDictionaryObject(vm);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSGPUShaderModule::s_info = { "GPUShaderModule"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSGPUShaderModule) };

JSGPUShaderModule::JSGPUShaderModule(Structure* structure, JSDOMGlobalObject& globalObject, Ref<GPUShaderModule>&& impl)
    : JSDOMWrapper<GPUShaderModule>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, GPUShaderModule>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSGPUShaderModule::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSGPUShaderModulePrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSGPUShaderModulePrototype::create(vm, &globalObject, structure);
}

JSObject* JSGPUShaderModule::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSGPUShaderModule>(vm, globalObject);
}

JSValue JSGPUShaderModule::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSGPUShaderModuleDOMConstructor, DOMConstructorID::GPUShaderModule>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSGPUShaderModule::destroy(JSC::JSCell* cell)
{
    JSGPUShaderModule* thisObject = static_cast<JSGPUShaderModule*>(cell);
    thisObject->JSGPUShaderModule::~JSGPUShaderModule();
}

JSC_DEFINE_CUSTOM_GETTER(jsGPUShaderModuleConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSGPUShaderModulePrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSGPUShaderModule::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

static inline JSValue jsGPUShaderModule_labelGetter(JSGlobalObject& lexicalGlobalObject, JSGPUShaderModule& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLNullable<IDLUSVString>>(lexicalGlobalObject, throwScope, impl.label())));
}

JSC_DEFINE_CUSTOM_GETTER(jsGPUShaderModule_label, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSGPUShaderModule>::get<jsGPUShaderModule_labelGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSGPUShaderModule_labelSetter(JSGlobalObject& lexicalGlobalObject, JSGPUShaderModule& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLNullable<IDLUSVString>>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setLabel(WTFMove(nativeValue));
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSGPUShaderModule_label, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSGPUShaderModule>::set<setJSGPUShaderModule_labelSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSC::EncodedJSValue jsGPUShaderModulePrototypeFunction_compilationInfoBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSGPUShaderModule>::ClassParameter castedThis, Ref<DeferredPromise>&& promise)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLPromise<IDLInterface<GPUCompilationInfo>>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, [&]() -> decltype(auto) { return impl.compilationInfo(WTFMove(promise)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsGPUShaderModulePrototypeFunction_compilationInfo, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperationReturningPromise<JSGPUShaderModule>::call<jsGPUShaderModulePrototypeFunction_compilationInfoBody>(*lexicalGlobalObject, *callFrame, "compilationInfo");
}

JSC::GCClient::IsoSubspace* JSGPUShaderModule::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSGPUShaderModule, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForGPUShaderModule.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForGPUShaderModule = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForGPUShaderModule.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForGPUShaderModule = std::forward<decltype(space)>(space); }
    );
}

void JSGPUShaderModule::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSGPUShaderModule*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url "_s + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSGPUShaderModuleOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, const char** reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSGPUShaderModuleOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsGPUShaderModule = static_cast<JSGPUShaderModule*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsGPUShaderModule->wrapped(), jsGPUShaderModule);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7GPUShaderModule@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore15GPUShaderModuleE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<GPUShaderModule>&& impl)
{

    if constexpr (std::is_polymorphic_v<GPUShaderModule>) {
#if ENABLE(BINDING_INTEGRITY)
        const void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7GPUShaderModule@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore15GPUShaderModuleE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // GPUShaderModule has subclasses. If GPUShaderModule has subclasses that get passed
        // to toJS() we currently require GPUShaderModule you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    }
    return createWrapper<GPUShaderModule>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, GPUShaderModule& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

GPUShaderModule* JSGPUShaderModule::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSGPUShaderModule*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
