/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSIntersectionObserverEntry.h"

#include "ActiveDOMObject.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMRectInit.h"
#include "JSDOMRectReadOnly.h"
#include "JSDOMWrapperCache.h"
#include "JSElement.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

template<> IntersectionObserverEntry::Init convertDictionary<IntersectionObserverEntry::Init>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    IntersectionObserverEntry::Init result;
    JSValue boundingClientRectValue;
    if (isNullOrUndefined)
        boundingClientRectValue = jsUndefined();
    else {
        boundingClientRectValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "boundingClientRect"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!boundingClientRectValue.isUndefined()) {
        result.boundingClientRect = convert<IDLDictionary<DOMRectInit>>(lexicalGlobalObject, boundingClientRectValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "boundingClientRect", "IntersectionObserverEntryInit", "DOMRectInit");
        return { };
    }
    JSValue intersectionRatioValue;
    if (isNullOrUndefined)
        intersectionRatioValue = jsUndefined();
    else {
        intersectionRatioValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "intersectionRatio"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!intersectionRatioValue.isUndefined()) {
        result.intersectionRatio = convert<IDLDouble>(lexicalGlobalObject, intersectionRatioValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "intersectionRatio", "IntersectionObserverEntryInit", "double");
        return { };
    }
    JSValue intersectionRectValue;
    if (isNullOrUndefined)
        intersectionRectValue = jsUndefined();
    else {
        intersectionRectValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "intersectionRect"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!intersectionRectValue.isUndefined()) {
        result.intersectionRect = convert<IDLDictionary<DOMRectInit>>(lexicalGlobalObject, intersectionRectValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "intersectionRect", "IntersectionObserverEntryInit", "DOMRectInit");
        return { };
    }
    JSValue isIntersectingValue;
    if (isNullOrUndefined)
        isIntersectingValue = jsUndefined();
    else {
        isIntersectingValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "isIntersecting"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!isIntersectingValue.isUndefined()) {
        result.isIntersecting = convert<IDLBoolean>(lexicalGlobalObject, isIntersectingValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "isIntersecting", "IntersectionObserverEntryInit", "boolean");
        return { };
    }
    JSValue rootBoundsValue;
    if (isNullOrUndefined)
        rootBoundsValue = jsUndefined();
    else {
        rootBoundsValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "rootBounds"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!rootBoundsValue.isUndefined()) {
        result.rootBounds = convert<IDLNullable<IDLDictionary<DOMRectInit>>>(lexicalGlobalObject, rootBoundsValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "rootBounds", "IntersectionObserverEntryInit", "DOMRectInit");
        return { };
    }
    JSValue targetValue;
    if (isNullOrUndefined)
        targetValue = jsUndefined();
    else {
        targetValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "target"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!targetValue.isUndefined()) {
        result.target = convert<IDLInterface<Element>>(lexicalGlobalObject, targetValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "target", "IntersectionObserverEntryInit", "Element");
        return { };
    }
    JSValue timeValue;
    if (isNullOrUndefined)
        timeValue = jsUndefined();
    else {
        timeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "time"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!timeValue.isUndefined()) {
        result.time = convert<IDLDouble>(lexicalGlobalObject, timeValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "time", "IntersectionObserverEntryInit", "double");
        return { };
    }
    return result;
}

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsIntersectionObserverEntryConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsIntersectionObserverEntry_time);
static JSC_DECLARE_CUSTOM_GETTER(jsIntersectionObserverEntry_rootBounds);
static JSC_DECLARE_CUSTOM_GETTER(jsIntersectionObserverEntry_boundingClientRect);
static JSC_DECLARE_CUSTOM_GETTER(jsIntersectionObserverEntry_intersectionRect);
static JSC_DECLARE_CUSTOM_GETTER(jsIntersectionObserverEntry_isIntersecting);
static JSC_DECLARE_CUSTOM_GETTER(jsIntersectionObserverEntry_intersectionRatio);
static JSC_DECLARE_CUSTOM_GETTER(jsIntersectionObserverEntry_target);

class JSIntersectionObserverEntryPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSIntersectionObserverEntryPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSIntersectionObserverEntryPrototype* ptr = new (NotNull, JSC::allocateCell<JSIntersectionObserverEntryPrototype>(vm)) JSIntersectionObserverEntryPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSIntersectionObserverEntryPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSIntersectionObserverEntryPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSIntersectionObserverEntryPrototype, JSIntersectionObserverEntryPrototype::Base);

using JSIntersectionObserverEntryDOMConstructor = JSDOMConstructor<JSIntersectionObserverEntry>;

template<> EncodedJSValue JSC_HOST_CALL_ATTRIBUTES JSIntersectionObserverEntryDOMConstructor::construct(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    VM& vm = lexicalGlobalObject->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* castedThis = jsCast<JSIntersectionObserverEntryDOMConstructor*>(callFrame->jsCallee());
    ASSERT(castedThis);
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto intersectionObserverEntryInit = convert<IDLDictionary<IntersectionObserverEntry::Init>>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto object = IntersectionObserverEntry::create(WTFMove(intersectionObserverEntryInit));
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    static_assert(TypeOrExceptionOrUnderlyingType<decltype(object)>::isRef);
    auto jsValue = toJSNewlyCreated<IDLInterface<IntersectionObserverEntry>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, WTFMove(object));
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    setSubclassStructureIfNeeded<IntersectionObserverEntry>(lexicalGlobalObject, callFrame, asObject(jsValue));
    RETURN_IF_EXCEPTION(throwScope, { });
    return JSValue::encode(jsValue);
}
JSC_ANNOTATE_HOST_FUNCTION(JSIntersectionObserverEntryDOMConstructorConstruct, JSIntersectionObserverEntryDOMConstructor::construct);

template<> const ClassInfo JSIntersectionObserverEntryDOMConstructor::s_info = { "IntersectionObserverEntry"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSIntersectionObserverEntryDOMConstructor) };

template<> JSValue JSIntersectionObserverEntryDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSIntersectionObserverEntryDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(1), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "IntersectionObserverEntry"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSIntersectionObserverEntry::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const HashTableValue JSIntersectionObserverEntryPrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsIntersectionObserverEntryConstructor, 0 } },
    { "time"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsIntersectionObserverEntry_time, 0 } },
    { "rootBounds"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsIntersectionObserverEntry_rootBounds, 0 } },
    { "boundingClientRect"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsIntersectionObserverEntry_boundingClientRect, 0 } },
    { "intersectionRect"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsIntersectionObserverEntry_intersectionRect, 0 } },
    { "isIntersecting"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsIntersectionObserverEntry_isIntersecting, 0 } },
    { "intersectionRatio"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsIntersectionObserverEntry_intersectionRatio, 0 } },
    { "target"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsIntersectionObserverEntry_target, 0 } },
};

const ClassInfo JSIntersectionObserverEntryPrototype::s_info = { "IntersectionObserverEntry"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSIntersectionObserverEntryPrototype) };

void JSIntersectionObserverEntryPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSIntersectionObserverEntry::info(), JSIntersectionObserverEntryPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSIntersectionObserverEntry::s_info = { "IntersectionObserverEntry"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSIntersectionObserverEntry) };

JSIntersectionObserverEntry::JSIntersectionObserverEntry(Structure* structure, JSDOMGlobalObject& globalObject, Ref<IntersectionObserverEntry>&& impl)
    : JSDOMWrapper<IntersectionObserverEntry>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, IntersectionObserverEntry>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSIntersectionObserverEntry::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSIntersectionObserverEntryPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSIntersectionObserverEntryPrototype::create(vm, &globalObject, structure);
}

JSObject* JSIntersectionObserverEntry::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSIntersectionObserverEntry>(vm, globalObject);
}

JSValue JSIntersectionObserverEntry::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSIntersectionObserverEntryDOMConstructor, DOMConstructorID::IntersectionObserverEntry>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSIntersectionObserverEntry::destroy(JSC::JSCell* cell)
{
    JSIntersectionObserverEntry* thisObject = static_cast<JSIntersectionObserverEntry*>(cell);
    thisObject->JSIntersectionObserverEntry::~JSIntersectionObserverEntry();
}

JSC_DEFINE_CUSTOM_GETTER(jsIntersectionObserverEntryConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSIntersectionObserverEntryPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSIntersectionObserverEntry::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

static inline JSValue jsIntersectionObserverEntry_timeGetter(JSGlobalObject& lexicalGlobalObject, JSIntersectionObserverEntry& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDouble>(lexicalGlobalObject, throwScope, impl.time())));
}

JSC_DEFINE_CUSTOM_GETTER(jsIntersectionObserverEntry_time, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSIntersectionObserverEntry>::get<jsIntersectionObserverEntry_timeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsIntersectionObserverEntry_rootBoundsGetter(JSGlobalObject& lexicalGlobalObject, JSIntersectionObserverEntry& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLNullable<IDLInterface<DOMRectReadOnly>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.rootBounds())));
}

JSC_DEFINE_CUSTOM_GETTER(jsIntersectionObserverEntry_rootBounds, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSIntersectionObserverEntry>::get<jsIntersectionObserverEntry_rootBoundsGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsIntersectionObserverEntry_boundingClientRectGetter(JSGlobalObject& lexicalGlobalObject, JSIntersectionObserverEntry& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<DOMRectReadOnly>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.boundingClientRect())));
}

JSC_DEFINE_CUSTOM_GETTER(jsIntersectionObserverEntry_boundingClientRect, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSIntersectionObserverEntry>::get<jsIntersectionObserverEntry_boundingClientRectGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsIntersectionObserverEntry_intersectionRectGetter(JSGlobalObject& lexicalGlobalObject, JSIntersectionObserverEntry& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<DOMRectReadOnly>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.intersectionRect())));
}

JSC_DEFINE_CUSTOM_GETTER(jsIntersectionObserverEntry_intersectionRect, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSIntersectionObserverEntry>::get<jsIntersectionObserverEntry_intersectionRectGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsIntersectionObserverEntry_isIntersectingGetter(JSGlobalObject& lexicalGlobalObject, JSIntersectionObserverEntry& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.isIntersecting())));
}

JSC_DEFINE_CUSTOM_GETTER(jsIntersectionObserverEntry_isIntersecting, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSIntersectionObserverEntry>::get<jsIntersectionObserverEntry_isIntersectingGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsIntersectionObserverEntry_intersectionRatioGetter(JSGlobalObject& lexicalGlobalObject, JSIntersectionObserverEntry& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDouble>(lexicalGlobalObject, throwScope, impl.intersectionRatio())));
}

JSC_DEFINE_CUSTOM_GETTER(jsIntersectionObserverEntry_intersectionRatio, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSIntersectionObserverEntry>::get<jsIntersectionObserverEntry_intersectionRatioGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsIntersectionObserverEntry_targetGetter(JSGlobalObject& lexicalGlobalObject, JSIntersectionObserverEntry& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<Element>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.target())));
}

JSC_DEFINE_CUSTOM_GETTER(jsIntersectionObserverEntry_target, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSIntersectionObserverEntry>::get<jsIntersectionObserverEntry_targetGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

JSC::GCClient::IsoSubspace* JSIntersectionObserverEntry::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSIntersectionObserverEntry, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForIntersectionObserverEntry.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForIntersectionObserverEntry = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForIntersectionObserverEntry.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForIntersectionObserverEntry = std::forward<decltype(space)>(space); }
    );
}

template<typename Visitor>
void JSIntersectionObserverEntry::visitChildrenImpl(JSCell* cell, Visitor& visitor)
{
    auto* thisObject = jsCast<JSIntersectionObserverEntry*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitChildren(thisObject, visitor);
    thisObject->visitAdditionalChildren(visitor);
}

DEFINE_VISIT_CHILDREN(JSIntersectionObserverEntry);

template<typename Visitor>
void JSIntersectionObserverEntry::visitOutputConstraints(JSCell* cell, Visitor& visitor)
{
    auto* thisObject = jsCast<JSIntersectionObserverEntry*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitOutputConstraints(thisObject, visitor);
    thisObject->visitAdditionalChildren(visitor);
}

template void JSIntersectionObserverEntry::visitOutputConstraints(JSCell*, AbstractSlotVisitor&);
template void JSIntersectionObserverEntry::visitOutputConstraints(JSCell*, SlotVisitor&);
void JSIntersectionObserverEntry::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSIntersectionObserverEntry*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url "_s + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSIntersectionObserverEntryOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, const char** reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSIntersectionObserverEntryOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsIntersectionObserverEntry = static_cast<JSIntersectionObserverEntry*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsIntersectionObserverEntry->wrapped(), jsIntersectionObserverEntry);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7IntersectionObserverEntry@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore25IntersectionObserverEntryE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<IntersectionObserverEntry>&& impl)
{

    if constexpr (std::is_polymorphic_v<IntersectionObserverEntry>) {
#if ENABLE(BINDING_INTEGRITY)
        const void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7IntersectionObserverEntry@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore25IntersectionObserverEntryE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // IntersectionObserverEntry has subclasses. If IntersectionObserverEntry has subclasses that get passed
        // to toJS() we currently require IntersectionObserverEntry you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    }
    return createWrapper<IntersectionObserverEntry>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, IntersectionObserverEntry& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

IntersectionObserverEntry* JSIntersectionObserverEntry::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSIntersectionObserverEntry*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
