/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSMediaCapabilities.h"

#include "ActiveDOMObject.h"
#include "DOMPromiseProxy.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertDictionary.h"
#include "JSDOMConvertPromise.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMOperation.h"
#include "JSDOMOperationReturningPromise.h"
#include "JSDOMWrapperCache.h"
#include "JSMediaCapabilitiesDecodingInfo.h"
#include "JSMediaCapabilitiesEncodingInfo.h"
#include "JSMediaDecodingConfiguration.h"
#include "JSMediaEncodingConfiguration.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsMediaCapabilitiesPrototypeFunction_decodingInfo);
static JSC_DECLARE_HOST_FUNCTION(jsMediaCapabilitiesPrototypeFunction_encodingInfo);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsMediaCapabilitiesConstructor);

class JSMediaCapabilitiesPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSMediaCapabilitiesPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSMediaCapabilitiesPrototype* ptr = new (NotNull, JSC::allocateCell<JSMediaCapabilitiesPrototype>(vm)) JSMediaCapabilitiesPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSMediaCapabilitiesPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSMediaCapabilitiesPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSMediaCapabilitiesPrototype, JSMediaCapabilitiesPrototype::Base);

using JSMediaCapabilitiesDOMConstructor = JSDOMConstructorNotConstructable<JSMediaCapabilities>;

template<> const ClassInfo JSMediaCapabilitiesDOMConstructor::s_info = { "MediaCapabilities"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSMediaCapabilitiesDOMConstructor) };

template<> JSValue JSMediaCapabilitiesDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSMediaCapabilitiesDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "MediaCapabilities"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSMediaCapabilities::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const HashTableValue JSMediaCapabilitiesPrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsMediaCapabilitiesConstructor, 0 } },
    { "decodingInfo"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsMediaCapabilitiesPrototypeFunction_decodingInfo, 1 } },
    { "encodingInfo"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsMediaCapabilitiesPrototypeFunction_encodingInfo, 1 } },
};

const ClassInfo JSMediaCapabilitiesPrototype::s_info = { "MediaCapabilities"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSMediaCapabilitiesPrototype) };

void JSMediaCapabilitiesPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSMediaCapabilities::info(), JSMediaCapabilitiesPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSMediaCapabilities::s_info = { "MediaCapabilities"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSMediaCapabilities) };

JSMediaCapabilities::JSMediaCapabilities(Structure* structure, JSDOMGlobalObject& globalObject, Ref<MediaCapabilities>&& impl)
    : JSDOMWrapper<MediaCapabilities>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, MediaCapabilities>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSMediaCapabilities::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSMediaCapabilitiesPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSMediaCapabilitiesPrototype::create(vm, &globalObject, structure);
}

JSObject* JSMediaCapabilities::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSMediaCapabilities>(vm, globalObject);
}

JSValue JSMediaCapabilities::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSMediaCapabilitiesDOMConstructor, DOMConstructorID::MediaCapabilities>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSMediaCapabilities::destroy(JSC::JSCell* cell)
{
    JSMediaCapabilities* thisObject = static_cast<JSMediaCapabilities*>(cell);
    thisObject->JSMediaCapabilities::~JSMediaCapabilities();
}

JSC_DEFINE_CUSTOM_GETTER(jsMediaCapabilitiesConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSMediaCapabilitiesPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSMediaCapabilities::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

static inline JSC::EncodedJSValue jsMediaCapabilitiesPrototypeFunction_decodingInfoBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSMediaCapabilities>::ClassParameter castedThis, Ref<DeferredPromise>&& promise)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto* context = jsCast<JSDOMGlobalObject*>(lexicalGlobalObject)->scriptExecutionContext();
    if (UNLIKELY(!context))
        return JSValue::encode(jsUndefined());
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto configuration = convert<IDLDictionary<MediaDecodingConfiguration>>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLPromise<IDLDictionary<MediaCapabilitiesDecodingInfo>>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, [&]() -> decltype(auto) { return impl.decodingInfo(*context, WTFMove(configuration), WTFMove(promise)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsMediaCapabilitiesPrototypeFunction_decodingInfo, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperationReturningPromise<JSMediaCapabilities>::call<jsMediaCapabilitiesPrototypeFunction_decodingInfoBody>(*lexicalGlobalObject, *callFrame, "decodingInfo");
}

static inline JSC::EncodedJSValue jsMediaCapabilitiesPrototypeFunction_encodingInfoBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSMediaCapabilities>::ClassParameter castedThis, Ref<DeferredPromise>&& promise)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto* context = jsCast<JSDOMGlobalObject*>(lexicalGlobalObject)->scriptExecutionContext();
    if (UNLIKELY(!context))
        return JSValue::encode(jsUndefined());
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto configuration = convert<IDLDictionary<MediaEncodingConfiguration>>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLPromise<IDLDictionary<MediaCapabilitiesEncodingInfo>>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, [&]() -> decltype(auto) { return impl.encodingInfo(*context, WTFMove(configuration), WTFMove(promise)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsMediaCapabilitiesPrototypeFunction_encodingInfo, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperationReturningPromise<JSMediaCapabilities>::call<jsMediaCapabilitiesPrototypeFunction_encodingInfoBody>(*lexicalGlobalObject, *callFrame, "encodingInfo");
}

JSC::GCClient::IsoSubspace* JSMediaCapabilities::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSMediaCapabilities, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForMediaCapabilities.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForMediaCapabilities = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForMediaCapabilities.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForMediaCapabilities = std::forward<decltype(space)>(space); }
    );
}

void JSMediaCapabilities::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSMediaCapabilities*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url "_s + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSMediaCapabilitiesOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, const char** reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSMediaCapabilitiesOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsMediaCapabilities = static_cast<JSMediaCapabilities*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsMediaCapabilities->wrapped(), jsMediaCapabilities);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7MediaCapabilities@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore17MediaCapabilitiesE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<MediaCapabilities>&& impl)
{

    if constexpr (std::is_polymorphic_v<MediaCapabilities>) {
#if ENABLE(BINDING_INTEGRITY)
        const void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7MediaCapabilities@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore17MediaCapabilitiesE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // MediaCapabilities has subclasses. If MediaCapabilities has subclasses that get passed
        // to toJS() we currently require MediaCapabilities you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    }
    return createWrapper<MediaCapabilities>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, MediaCapabilities& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

MediaCapabilities* JSMediaCapabilities::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSMediaCapabilities*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
