/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSSVGTextPositioningElement.h"

#include "ActiveDOMObject.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMWrapperCache.h"
#include "JSSVGAnimatedLengthList.h"
#include "JSSVGAnimatedNumberList.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsSVGTextPositioningElementConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGTextPositioningElement_x);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGTextPositioningElement_y);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGTextPositioningElement_dx);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGTextPositioningElement_dy);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGTextPositioningElement_rotate);

class JSSVGTextPositioningElementPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSSVGTextPositioningElementPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSSVGTextPositioningElementPrototype* ptr = new (NotNull, JSC::allocateCell<JSSVGTextPositioningElementPrototype>(vm)) JSSVGTextPositioningElementPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSSVGTextPositioningElementPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSSVGTextPositioningElementPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSSVGTextPositioningElementPrototype, JSSVGTextPositioningElementPrototype::Base);

using JSSVGTextPositioningElementDOMConstructor = JSDOMConstructorNotConstructable<JSSVGTextPositioningElement>;

template<> const ClassInfo JSSVGTextPositioningElementDOMConstructor::s_info = { "SVGTextPositioningElement"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSSVGTextPositioningElementDOMConstructor) };

template<> JSValue JSSVGTextPositioningElementDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSSVGTextContentElement::getConstructor(vm, &globalObject);
}

template<> void JSSVGTextPositioningElementDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "SVGTextPositioningElement"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSSVGTextPositioningElement::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const HashTableValue JSSVGTextPositioningElementPrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGTextPositioningElementConstructor, 0 } },
    { "x"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGTextPositioningElement_x, 0 } },
    { "y"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGTextPositioningElement_y, 0 } },
    { "dx"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGTextPositioningElement_dx, 0 } },
    { "dy"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGTextPositioningElement_dy, 0 } },
    { "rotate"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGTextPositioningElement_rotate, 0 } },
};

const ClassInfo JSSVGTextPositioningElementPrototype::s_info = { "SVGTextPositioningElement"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSSVGTextPositioningElementPrototype) };

void JSSVGTextPositioningElementPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSSVGTextPositioningElement::info(), JSSVGTextPositioningElementPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSSVGTextPositioningElement::s_info = { "SVGTextPositioningElement"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSSVGTextPositioningElement) };

JSSVGTextPositioningElement::JSSVGTextPositioningElement(Structure* structure, JSDOMGlobalObject& globalObject, Ref<SVGTextPositioningElement>&& impl)
    : JSSVGTextContentElement(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSSVGTextPositioningElement::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSSVGTextPositioningElementPrototype::createStructure(vm, &globalObject, JSSVGTextContentElement::prototype(vm, globalObject));
    structure->setMayBePrototype(true);
    return JSSVGTextPositioningElementPrototype::create(vm, &globalObject, structure);
}

JSObject* JSSVGTextPositioningElement::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSSVGTextPositioningElement>(vm, globalObject);
}

JSValue JSSVGTextPositioningElement::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSVGTextPositioningElementDOMConstructor, DOMConstructorID::SVGTextPositioningElement>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGTextPositioningElementConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSSVGTextPositioningElementPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSSVGTextPositioningElement::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

static inline JSValue jsSVGTextPositioningElement_xGetter(JSGlobalObject& lexicalGlobalObject, JSSVGTextPositioningElement& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<SVGAnimatedLengthList>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.xAnimated())));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGTextPositioningElement_x, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGTextPositioningElement>::get<jsSVGTextPositioningElement_xGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsSVGTextPositioningElement_yGetter(JSGlobalObject& lexicalGlobalObject, JSSVGTextPositioningElement& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<SVGAnimatedLengthList>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.yAnimated())));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGTextPositioningElement_y, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGTextPositioningElement>::get<jsSVGTextPositioningElement_yGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsSVGTextPositioningElement_dxGetter(JSGlobalObject& lexicalGlobalObject, JSSVGTextPositioningElement& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<SVGAnimatedLengthList>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.dxAnimated())));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGTextPositioningElement_dx, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGTextPositioningElement>::get<jsSVGTextPositioningElement_dxGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsSVGTextPositioningElement_dyGetter(JSGlobalObject& lexicalGlobalObject, JSSVGTextPositioningElement& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<SVGAnimatedLengthList>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.dyAnimated())));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGTextPositioningElement_dy, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGTextPositioningElement>::get<jsSVGTextPositioningElement_dyGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsSVGTextPositioningElement_rotateGetter(JSGlobalObject& lexicalGlobalObject, JSSVGTextPositioningElement& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<SVGAnimatedNumberList>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.rotateAnimated())));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGTextPositioningElement_rotate, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGTextPositioningElement>::get<jsSVGTextPositioningElement_rotateGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

JSC::GCClient::IsoSubspace* JSSVGTextPositioningElement::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSSVGTextPositioningElement, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForSVGTextPositioningElement.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForSVGTextPositioningElement = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForSVGTextPositioningElement.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForSVGTextPositioningElement = std::forward<decltype(space)>(space); }
    );
}

void JSSVGTextPositioningElement::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSSVGTextPositioningElement*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url "_s + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}


}
