/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEB_AUDIO)

#include "JSScriptProcessorNode.h"

#include "ActiveDOMObject.h"
#include "EventNames.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMWrapperCache.h"
#include "JSEventListener.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsScriptProcessorNodeConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsScriptProcessorNode_onaudioprocess);
static JSC_DECLARE_CUSTOM_SETTER(setJSScriptProcessorNode_onaudioprocess);
static JSC_DECLARE_CUSTOM_GETTER(jsScriptProcessorNode_bufferSize);

class JSScriptProcessorNodePrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSScriptProcessorNodePrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSScriptProcessorNodePrototype* ptr = new (NotNull, JSC::allocateCell<JSScriptProcessorNodePrototype>(vm)) JSScriptProcessorNodePrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSScriptProcessorNodePrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSScriptProcessorNodePrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSScriptProcessorNodePrototype, JSScriptProcessorNodePrototype::Base);

using JSScriptProcessorNodeDOMConstructor = JSDOMConstructorNotConstructable<JSScriptProcessorNode>;

template<> const ClassInfo JSScriptProcessorNodeDOMConstructor::s_info = { "ScriptProcessorNode"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSScriptProcessorNodeDOMConstructor) };

template<> JSValue JSScriptProcessorNodeDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSAudioNode::getConstructor(vm, &globalObject);
}

template<> void JSScriptProcessorNodeDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "ScriptProcessorNode"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSScriptProcessorNode::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const HashTableValue JSScriptProcessorNodePrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsScriptProcessorNodeConstructor, 0 } },
    { "onaudioprocess"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsScriptProcessorNode_onaudioprocess, setJSScriptProcessorNode_onaudioprocess } },
    { "bufferSize"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsScriptProcessorNode_bufferSize, 0 } },
};

const ClassInfo JSScriptProcessorNodePrototype::s_info = { "ScriptProcessorNode"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSScriptProcessorNodePrototype) };

void JSScriptProcessorNodePrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSScriptProcessorNode::info(), JSScriptProcessorNodePrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSScriptProcessorNode::s_info = { "ScriptProcessorNode"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSScriptProcessorNode) };

JSScriptProcessorNode::JSScriptProcessorNode(Structure* structure, JSDOMGlobalObject& globalObject, Ref<ScriptProcessorNode>&& impl)
    : JSAudioNode(structure, globalObject, WTFMove(impl))
{
}

static_assert(std::is_base_of<ActiveDOMObject, ScriptProcessorNode>::value, "Interface is marked as [ActiveDOMObject] but implementation class does not subclass ActiveDOMObject.");

JSObject* JSScriptProcessorNode::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSScriptProcessorNodePrototype::createStructure(vm, &globalObject, JSAudioNode::prototype(vm, globalObject));
    structure->setMayBePrototype(true);
    return JSScriptProcessorNodePrototype::create(vm, &globalObject, structure);
}

JSObject* JSScriptProcessorNode::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSScriptProcessorNode>(vm, globalObject);
}

JSValue JSScriptProcessorNode::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSScriptProcessorNodeDOMConstructor, DOMConstructorID::ScriptProcessorNode>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsScriptProcessorNodeConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSScriptProcessorNodePrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSScriptProcessorNode::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

static inline JSValue jsScriptProcessorNode_onaudioprocessGetter(JSGlobalObject& lexicalGlobalObject, JSScriptProcessorNode& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().audioprocessEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsScriptProcessorNode_onaudioprocess, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSScriptProcessorNode>::get<jsScriptProcessorNode_onaudioprocessGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSScriptProcessorNode_onaudioprocessSetter(JSGlobalObject& lexicalGlobalObject, JSScriptProcessorNode& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.wrapped(), eventNames().audioprocessEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSScriptProcessorNode_onaudioprocess, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSScriptProcessorNode>::set<setJSScriptProcessorNode_onaudioprocessSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsScriptProcessorNode_bufferSizeGetter(JSGlobalObject& lexicalGlobalObject, JSScriptProcessorNode& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLLong>(lexicalGlobalObject, throwScope, impl.bufferSize())));
}

JSC_DEFINE_CUSTOM_GETTER(jsScriptProcessorNode_bufferSize, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSScriptProcessorNode>::get<jsScriptProcessorNode_bufferSizeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

JSC::GCClient::IsoSubspace* JSScriptProcessorNode::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSScriptProcessorNode, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForScriptProcessorNode.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForScriptProcessorNode = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForScriptProcessorNode.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForScriptProcessorNode = std::forward<decltype(space)>(space); }
    );
}

void JSScriptProcessorNode::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSScriptProcessorNode*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url "_s + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSScriptProcessorNodeOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, const char** reason)
{
    auto* jsScriptProcessorNode = jsCast<JSScriptProcessorNode*>(handle.slot()->asCell());
    auto& wrapped = jsScriptProcessorNode->wrapped();
    if (!wrapped.isContextStopped() && wrapped.hasPendingActivity()) {
        if (UNLIKELY(reason))
            *reason = "ActiveDOMObject with pending activity";
        return true;
     }
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSScriptProcessorNodeOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsScriptProcessorNode = static_cast<JSScriptProcessorNode*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsScriptProcessorNode->wrapped(), jsScriptProcessorNode);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7ScriptProcessorNode@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore19ScriptProcessorNodeE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<ScriptProcessorNode>&& impl)
{

    if constexpr (std::is_polymorphic_v<ScriptProcessorNode>) {
#if ENABLE(BINDING_INTEGRITY)
        const void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7ScriptProcessorNode@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore19ScriptProcessorNodeE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // ScriptProcessorNode has subclasses. If ScriptProcessorNode has subclasses that get passed
        // to toJS() we currently require ScriptProcessorNode you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    }
    return createWrapper<ScriptProcessorNode>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, ScriptProcessorNode& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

ScriptProcessorNode* JSScriptProcessorNode::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSScriptProcessorNode*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(WEB_AUDIO)
