// This file is automatically generated from CSSProperties.json by the process-css-properties.py script. Do not edit it.

#include "config.h"
#include "StyleBuilderGenerated.h"

#include "CSSPrimitiveValueMappings.h"
#include "CSSProperty.h"
#include "RenderStyleSetters.h"
#include "StyleBuilderConverter.h"
#include "StyleBuilderCustom.h"
#include "StyleBuilderState.h"
#include "StylePropertyShorthand.h"

namespace WebCore {
namespace Style {

class BuilderFunctions {
public:
    static void applyInitialColorScheme(BuilderState& builderState)
    {
        builderState.style().setColorScheme(RenderStyle::initialColorScheme());
    }
    static void applyInheritColorScheme(BuilderState& builderState)
    {
        builderState.style().setColorScheme(forwardInheritedValue(builderState.parentStyle().colorScheme()));
    }
    static void applyInitialRubyPosition(BuilderState& builderState)
    {
        builderState.style().setRubyPosition(RenderStyle::initialRubyPosition());
    }
    static void applyInheritRubyPosition(BuilderState& builderState)
    {
        builderState.style().setRubyPosition(forwardInheritedValue(builderState.parentStyle().rubyPosition()));
    }
    static void applyValueRubyPosition(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setRubyPosition(fromCSSValueDeducingType(value));
    }
    static void applyInitialWritingMode(BuilderState& builderState)
    {
        builderState.style().setWritingMode(RenderStyle::initialWritingMode());
    }
    static void applyInheritWritingMode(BuilderState& builderState)
    {
        builderState.style().setWritingMode(forwardInheritedValue(builderState.parentStyle().writingMode()));
    }
    static void applyInitialDirection(BuilderState& builderState)
    {
        builderState.style().setDirection(RenderStyle::initialDirection());
    }
    static void applyInheritDirection(BuilderState& builderState)
    {
        builderState.style().setDirection(forwardInheritedValue(builderState.parentStyle().direction()));
    }
    static void applyInitialDisplay(BuilderState& builderState)
    {
        builderState.style().setDisplay(RenderStyle::initialDisplay());
    }
    static void applyInheritDisplay(BuilderState& builderState)
    {
        builderState.style().setDisplay(forwardInheritedValue(builderState.parentStyle().display()));
    }
    static void applyValueDisplay(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setDisplay(fromCSSValueDeducingType(value));
    }
    static void applyValueFontFeatureSettings(BuilderState& builderState, CSSValue& value)
    {
        auto fontDescription = builderState.fontDescription();
        fontDescription.setFeatureSettings(BuilderConverter::convertFontFeatureSettings(builderState, value));
        builderState.setFontDescription(WTFMove(fontDescription));
    }
    static void applyInitialFontKerning(BuilderState& builderState)
    {
        auto fontDescription = builderState.fontDescription();
        fontDescription.setKerning(FontCascadeDescription::initialKerning());
        builderState.setFontDescription(WTFMove(fontDescription));
    }
    static void applyInheritFontKerning(BuilderState& builderState)
    {
        auto fontDescription = builderState.fontDescription();
        fontDescription.setKerning(builderState.parentFontDescription().kerning());
        builderState.setFontDescription(WTFMove(fontDescription));
    }
    static void applyValueFontKerning(BuilderState& builderState, CSSValue& value)
    {
        if (CSSPropertyParserHelpers::isSystemFontShorthand(value.valueID())) {
            applyInitialFontKerning(builderState);
            return;
        }
        auto fontDescription = builderState.fontDescription();
        fontDescription.setKerning(fromCSSValueDeducingType(value));
        builderState.setFontDescription(WTFMove(fontDescription));
    }
    static void applyInitialFontOpticalSizing(BuilderState& builderState)
    {
        auto fontDescription = builderState.fontDescription();
        fontDescription.setOpticalSizing(FontCascadeDescription::initialOpticalSizing());
        builderState.setFontDescription(WTFMove(fontDescription));
    }
    static void applyInheritFontOpticalSizing(BuilderState& builderState)
    {
        auto fontDescription = builderState.fontDescription();
        fontDescription.setOpticalSizing(builderState.parentFontDescription().opticalSizing());
        builderState.setFontDescription(WTFMove(fontDescription));
    }
    static void applyValueFontOpticalSizing(BuilderState& builderState, CSSValue& value)
    {
        if (CSSPropertyParserHelpers::isSystemFontShorthand(value.valueID())) {
            applyInitialFontOpticalSizing(builderState);
            return;
        }
        auto fontDescription = builderState.fontDescription();
        fontDescription.setOpticalSizing(fromCSSValueDeducingType(value));
        builderState.setFontDescription(WTFMove(fontDescription));
    }
    static void applyInitialFontPalette(BuilderState& builderState)
    {
        auto fontDescription = builderState.fontDescription();
        fontDescription.setFontPalette(FontCascadeDescription::initialFontPalette());
        builderState.setFontDescription(WTFMove(fontDescription));
    }
    static void applyInheritFontPalette(BuilderState& builderState)
    {
        auto fontDescription = builderState.fontDescription();
        fontDescription.setFontPalette(builderState.parentFontDescription().fontPalette());
        builderState.setFontDescription(WTFMove(fontDescription));
    }
    static void applyValueFontPalette(BuilderState& builderState, CSSValue& value)
    {
        auto fontDescription = builderState.fontDescription();
        fontDescription.setFontPalette(BuilderConverter::convertFontPalette(builderState, value));
        builderState.setFontDescription(WTFMove(fontDescription));
    }
    static void applyInitialFontSizeAdjust(BuilderState& builderState)
    {
        auto fontDescription = builderState.fontDescription();
        fontDescription.setFontSizeAdjust(FontCascadeDescription::initialFontSizeAdjust());
        builderState.setFontDescription(WTFMove(fontDescription));
    }
    static void applyInheritFontSizeAdjust(BuilderState& builderState)
    {
        auto fontDescription = builderState.fontDescription();
        fontDescription.setFontSizeAdjust(builderState.parentFontDescription().fontSizeAdjust());
        builderState.setFontDescription(WTFMove(fontDescription));
    }
    static void applyInitialFontStretch(BuilderState& builderState)
    {
        auto fontDescription = builderState.fontDescription();
        fontDescription.setStretch(FontCascadeDescription::initialStretch());
        builderState.setFontDescription(WTFMove(fontDescription));
    }
    static void applyInheritFontStretch(BuilderState& builderState)
    {
        auto fontDescription = builderState.fontDescription();
        fontDescription.setStretch(builderState.parentFontDescription().stretch());
        builderState.setFontDescription(WTFMove(fontDescription));
    }
    static void applyValueFontStretch(BuilderState& builderState, CSSValue& value)
    {
        auto fontDescription = builderState.fontDescription();
        fontDescription.setStretch(BuilderConverter::convertFontStretch(builderState, value));
        builderState.setFontDescription(WTFMove(fontDescription));
    }
    static void applyInitialFontSynthesisSmallCaps(BuilderState& builderState)
    {
        auto fontDescription = builderState.fontDescription();
        fontDescription.setFontSynthesisSmallCaps(FontCascadeDescription::initialFontSynthesisSmallCaps());
        builderState.setFontDescription(WTFMove(fontDescription));
    }
    static void applyInheritFontSynthesisSmallCaps(BuilderState& builderState)
    {
        auto fontDescription = builderState.fontDescription();
        fontDescription.setFontSynthesisSmallCaps(builderState.parentFontDescription().fontSynthesisSmallCaps());
        builderState.setFontDescription(WTFMove(fontDescription));
    }
    static void applyValueFontSynthesisSmallCaps(BuilderState& builderState, CSSValue& value)
    {
        auto fontDescription = builderState.fontDescription();
        fontDescription.setFontSynthesisSmallCaps(fromCSSValueDeducingType(value));
        builderState.setFontDescription(WTFMove(fontDescription));
    }
    static void applyInitialFontSynthesisStyle(BuilderState& builderState)
    {
        auto fontDescription = builderState.fontDescription();
        fontDescription.setFontSynthesisStyle(FontCascadeDescription::initialFontSynthesisStyle());
        builderState.setFontDescription(WTFMove(fontDescription));
    }
    static void applyInheritFontSynthesisStyle(BuilderState& builderState)
    {
        auto fontDescription = builderState.fontDescription();
        fontDescription.setFontSynthesisStyle(builderState.parentFontDescription().fontSynthesisStyle());
        builderState.setFontDescription(WTFMove(fontDescription));
    }
    static void applyValueFontSynthesisStyle(BuilderState& builderState, CSSValue& value)
    {
        auto fontDescription = builderState.fontDescription();
        fontDescription.setFontSynthesisStyle(fromCSSValueDeducingType(value));
        builderState.setFontDescription(WTFMove(fontDescription));
    }
    static void applyInitialFontSynthesisWeight(BuilderState& builderState)
    {
        auto fontDescription = builderState.fontDescription();
        fontDescription.setFontSynthesisWeight(FontCascadeDescription::initialFontSynthesisWeight());
        builderState.setFontDescription(WTFMove(fontDescription));
    }
    static void applyInheritFontSynthesisWeight(BuilderState& builderState)
    {
        auto fontDescription = builderState.fontDescription();
        fontDescription.setFontSynthesisWeight(builderState.parentFontDescription().fontSynthesisWeight());
        builderState.setFontDescription(WTFMove(fontDescription));
    }
    static void applyValueFontSynthesisWeight(BuilderState& builderState, CSSValue& value)
    {
        auto fontDescription = builderState.fontDescription();
        fontDescription.setFontSynthesisWeight(fromCSSValueDeducingType(value));
        builderState.setFontDescription(WTFMove(fontDescription));
    }
    static void applyInitialFontVariantCaps(BuilderState& builderState)
    {
        auto fontDescription = builderState.fontDescription();
        fontDescription.setVariantCaps(FontCascadeDescription::initialVariantCaps());
        builderState.setFontDescription(WTFMove(fontDescription));
    }
    static void applyInheritFontVariantCaps(BuilderState& builderState)
    {
        auto fontDescription = builderState.fontDescription();
        fontDescription.setVariantCaps(builderState.parentFontDescription().variantCaps());
        builderState.setFontDescription(WTFMove(fontDescription));
    }
    static void applyValueFontVariantCaps(BuilderState& builderState, CSSValue& value)
    {
        if (CSSPropertyParserHelpers::isSystemFontShorthand(value.valueID())) {
            applyInitialFontVariantCaps(builderState);
            return;
        }
        auto fontDescription = builderState.fontDescription();
        fontDescription.setVariantCaps(fromCSSValueDeducingType(value));
        builderState.setFontDescription(WTFMove(fontDescription));
    }
    static void applyInitialFontVariantEmoji(BuilderState& builderState)
    {
        auto fontDescription = builderState.fontDescription();
        fontDescription.setVariantEmoji(FontCascadeDescription::initialVariantEmoji());
        builderState.setFontDescription(WTFMove(fontDescription));
    }
    static void applyInheritFontVariantEmoji(BuilderState& builderState)
    {
        auto fontDescription = builderState.fontDescription();
        fontDescription.setVariantEmoji(builderState.parentFontDescription().variantEmoji());
        builderState.setFontDescription(WTFMove(fontDescription));
    }
    static void applyValueFontVariantEmoji(BuilderState& builderState, CSSValue& value)
    {
        if (CSSPropertyParserHelpers::isSystemFontShorthand(value.valueID())) {
            applyInitialFontVariantEmoji(builderState);
            return;
        }
        auto fontDescription = builderState.fontDescription();
        fontDescription.setVariantEmoji(fromCSSValueDeducingType(value));
        builderState.setFontDescription(WTFMove(fontDescription));
    }
    static void applyInitialFontVariantPosition(BuilderState& builderState)
    {
        auto fontDescription = builderState.fontDescription();
        fontDescription.setVariantPosition(FontCascadeDescription::initialVariantPosition());
        builderState.setFontDescription(WTFMove(fontDescription));
    }
    static void applyInheritFontVariantPosition(BuilderState& builderState)
    {
        auto fontDescription = builderState.fontDescription();
        fontDescription.setVariantPosition(builderState.parentFontDescription().variantPosition());
        builderState.setFontDescription(WTFMove(fontDescription));
    }
    static void applyValueFontVariantPosition(BuilderState& builderState, CSSValue& value)
    {
        if (CSSPropertyParserHelpers::isSystemFontShorthand(value.valueID())) {
            applyInitialFontVariantPosition(builderState);
            return;
        }
        auto fontDescription = builderState.fontDescription();
        fontDescription.setVariantPosition(fromCSSValueDeducingType(value));
        builderState.setFontDescription(WTFMove(fontDescription));
    }
    static void applyValueFontVariationSettings(BuilderState& builderState, CSSValue& value)
    {
        auto fontDescription = builderState.fontDescription();
        fontDescription.setVariationSettings(BuilderConverter::convertFontVariationSettings(builderState, value));
        builderState.setFontDescription(WTFMove(fontDescription));
    }
    static void applyInitialFontWeight(BuilderState& builderState)
    {
        auto fontDescription = builderState.fontDescription();
        fontDescription.setWeight(FontCascadeDescription::initialWeight());
        builderState.setFontDescription(WTFMove(fontDescription));
    }
    static void applyInheritFontWeight(BuilderState& builderState)
    {
        auto fontDescription = builderState.fontDescription();
        fontDescription.setWeight(builderState.parentFontDescription().weight());
        builderState.setFontDescription(WTFMove(fontDescription));
    }
    static void applyValueFontWeight(BuilderState& builderState, CSSValue& value)
    {
        auto fontDescription = builderState.fontDescription();
        fontDescription.setWeight(BuilderConverter::convertFontWeight(builderState, value));
        builderState.setFontDescription(WTFMove(fontDescription));
    }
    static void applyInitialTextOrientation(BuilderState& builderState)
    {
        builderState.style().setTextOrientation(RenderStyle::initialTextOrientation());
    }
    static void applyInheritTextOrientation(BuilderState& builderState)
    {
        builderState.style().setTextOrientation(forwardInheritedValue(builderState.parentStyle().textOrientation()));
    }
    static void applyInitialTextRendering(BuilderState& builderState)
    {
        auto fontDescription = builderState.fontDescription();
        fontDescription.setTextRenderingMode(FontCascadeDescription::initialTextRenderingMode());
        builderState.setFontDescription(WTFMove(fontDescription));
    }
    static void applyInheritTextRendering(BuilderState& builderState)
    {
        auto fontDescription = builderState.fontDescription();
        fontDescription.setTextRenderingMode(builderState.parentFontDescription().textRenderingMode());
        builderState.setFontDescription(WTFMove(fontDescription));
    }
    static void applyValueTextRendering(BuilderState& builderState, CSSValue& value)
    {
        auto fontDescription = builderState.fontDescription();
        fontDescription.setTextRenderingMode(fromCSSValueDeducingType(value));
        builderState.setFontDescription(WTFMove(fontDescription));
    }
    static void applyInitialWebkitFontSmoothing(BuilderState& builderState)
    {
        auto fontDescription = builderState.fontDescription();
        fontDescription.setFontSmoothing(FontCascadeDescription::initialFontSmoothing());
        builderState.setFontDescription(WTFMove(fontDescription));
    }
    static void applyInheritWebkitFontSmoothing(BuilderState& builderState)
    {
        auto fontDescription = builderState.fontDescription();
        fontDescription.setFontSmoothing(builderState.parentFontDescription().fontSmoothing());
        builderState.setFontDescription(WTFMove(fontDescription));
    }
    static void applyValueWebkitFontSmoothing(BuilderState& builderState, CSSValue& value)
    {
        auto fontDescription = builderState.fontDescription();
        fontDescription.setFontSmoothing(fromCSSValueDeducingType(value));
        builderState.setFontDescription(WTFMove(fontDescription));
    }
    static void applyInitialWebkitLocale(BuilderState& builderState)
    {
        auto fontDescription = builderState.fontDescription();
        fontDescription.setSpecifiedLocale(FontCascadeDescription::initialSpecifiedLocale());
        builderState.setFontDescription(WTFMove(fontDescription));
    }
    static void applyInheritWebkitLocale(BuilderState& builderState)
    {
        auto fontDescription = builderState.fontDescription();
        fontDescription.setSpecifiedLocale(builderState.parentFontDescription().specifiedLocale());
        builderState.setFontDescription(WTFMove(fontDescription));
    }
    static void applyInitialWebkitTextZoom(BuilderState& builderState)
    {
        builderState.style().setTextZoom(RenderStyle::initialTextZoom());
    }
    static void applyInheritWebkitTextZoom(BuilderState& builderState)
    {
        builderState.style().setTextZoom(forwardInheritedValue(builderState.parentStyle().textZoom()));
    }
    static void applyInitialTextAutospace(BuilderState& builderState)
    {
        auto fontDescription = builderState.fontDescription();
        fontDescription.setTextAutospace(FontCascadeDescription::initialTextAutospace());
        builderState.setFontDescription(WTFMove(fontDescription));
    }
    static void applyInheritTextAutospace(BuilderState& builderState)
    {
        auto fontDescription = builderState.fontDescription();
        fontDescription.setTextAutospace(builderState.parentFontDescription().textAutospace());
        builderState.setFontDescription(WTFMove(fontDescription));
    }
    static void applyValueTextAutospace(BuilderState& builderState, CSSValue& value)
    {
        auto fontDescription = builderState.fontDescription();
        fontDescription.setTextAutospace(BuilderConverter::convertTextAutospace(builderState, value));
        builderState.setFontDescription(WTFMove(fontDescription));
    }
    static void applyInitialTextSpacingTrim(BuilderState& builderState)
    {
        auto fontDescription = builderState.fontDescription();
        fontDescription.setTextSpacingTrim(FontCascadeDescription::initialTextSpacingTrim());
        builderState.setFontDescription(WTFMove(fontDescription));
    }
    static void applyInheritTextSpacingTrim(BuilderState& builderState)
    {
        auto fontDescription = builderState.fontDescription();
        fontDescription.setTextSpacingTrim(builderState.parentFontDescription().textSpacingTrim());
        builderState.setFontDescription(WTFMove(fontDescription));
    }
    static void applyValueTextSpacingTrim(BuilderState& builderState, CSSValue& value)
    {
        auto fontDescription = builderState.fontDescription();
        fontDescription.setTextSpacingTrim(BuilderConverter::convertTextSpacingTrim(builderState, value));
        builderState.setFontDescription(WTFMove(fontDescription));
    }
    static void applyInitialAccentColor(BuilderState& builderState)
    {
        builderState.style().setHasAutoAccentColor();
    }
    static void applyInheritAccentColor(BuilderState& builderState)
    {
        if (builderState.parentStyle().hasAutoAccentColor()) {
            builderState.style().setHasAutoAccentColor();
            return;
        }
        builderState.style().setAccentColor(forwardInheritedValue(builderState.parentStyle().accentColor()));
    }
    static void applyValueAccentColor(BuilderState& builderState, CSSValue& value)
    {
        if (value.valueID() == CSSValueAuto) {
            builderState.style().setHasAutoAccentColor();
            return;
        }
        builderState.style().setAccentColor(builderState.colorFromPrimitiveValue(downcast<CSSPrimitiveValue>(value), ForVisitedLink::No));
    }
    static void applyInitialAlignContent(BuilderState& builderState)
    {
        builderState.style().setAlignContent(RenderStyle::initialContentAlignment());
    }
    static void applyInheritAlignContent(BuilderState& builderState)
    {
        builderState.style().setAlignContent(forwardInheritedValue(builderState.parentStyle().alignContent()));
    }
    static void applyValueAlignContent(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setAlignContent(BuilderConverter::convertContentAlignmentData(builderState, value));
    }
    static void applyInitialAlignItems(BuilderState& builderState)
    {
        builderState.style().setAlignItems(RenderStyle::initialDefaultAlignment());
    }
    static void applyInheritAlignItems(BuilderState& builderState)
    {
        builderState.style().setAlignItems(forwardInheritedValue(builderState.parentStyle().alignItems()));
    }
    static void applyValueAlignItems(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setAlignItems(BuilderConverter::convertSelfOrDefaultAlignmentData(builderState, value));
    }
    static void applyInitialAlignSelf(BuilderState& builderState)
    {
        builderState.style().setAlignSelf(RenderStyle::initialSelfAlignment());
    }
    static void applyInheritAlignSelf(BuilderState& builderState)
    {
        builderState.style().setAlignSelf(forwardInheritedValue(builderState.parentStyle().alignSelf()));
    }
    static void applyValueAlignSelf(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setAlignSelf(BuilderConverter::convertSelfOrDefaultAlignmentData(builderState, value));
    }
    static void applyInitialAlignmentBaseline(BuilderState& builderState)
    {
        builderState.style().accessSVGStyle().setAlignmentBaseline(SVGRenderStyle::initialAlignmentBaseline());
    }
    static void applyInheritAlignmentBaseline(BuilderState& builderState)
    {
        builderState.style().accessSVGStyle().setAlignmentBaseline(forwardInheritedValue(builderState.parentStyle().svgStyle().alignmentBaseline()));
    }
    static void applyValueAlignmentBaseline(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().accessSVGStyle().setAlignmentBaseline(fromCSSValueDeducingType(value));
    }
    static void applyInitialAnchorName(BuilderState& builderState)
    {
        builderState.style().setAnchorNames(RenderStyle::initialAnchorNames());
    }
    static void applyInheritAnchorName(BuilderState& builderState)
    {
        builderState.style().setAnchorNames(forwardInheritedValue(builderState.parentStyle().anchorNames()));
    }
    static void applyValueAnchorName(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setAnchorNames(BuilderConverter::convertAnchorName(builderState, value));
    }
    static void applyInitialAnimationComposition(BuilderState& builderState)
    {
        auto& list = builderState.style().ensureAnimations();
        if (list.isEmpty())
            list.append(Animation::create());
        list.animation(0).setCompositeOperation(Animation::initialCompositeOperation());
        for (auto& animation : list)
            animation->clearCompositeOperation();
    }
    static void applyInheritAnimationComposition(BuilderState& builderState)
    {
        auto& list = builderState.style().ensureAnimations();
        auto* parentList = builderState.parentStyle().animations();
        size_t i = 0, parentSize = parentList ? parentList->size() : 0;
        for ( ; i < parentSize && parentList->animation(i).isCompositeOperationSet(); ++i) {
            if (list.size() <= i)
                list.append(Animation::create());
            list.animation(i).setCompositeOperation(parentList->animation(i).compositeOperation());
        }
        // Reset any remaining animations to not have the property set.
        for ( ; i < list.size(); ++i)
            list.animation(i).clearCompositeOperation();
    }
    static void applyValueAnimationComposition(BuilderState& builderState, CSSValue& value)
    {
        auto& list = builderState.style().ensureAnimations();
        size_t childIndex = 0;
        if (auto* valueList = dynamicDowncast<CSSValueList>(value)) {
            // Walk each value and put it into an animation, creating new animations as needed.
            for (auto& currentValue : *valueList) {
                if (childIndex >= list.size())
                    list.append(Animation::create());
                builderState.styleMap().mapAnimationCompositeOperation(list.animation(childIndex), currentValue);
                ++childIndex;
            }
        } else {
            if (list.isEmpty())
                list.append(Animation::create());
            builderState.styleMap().mapAnimationCompositeOperation(list.animation(childIndex), value);
            childIndex = 1;
        }
        for ( ; childIndex < list.size(); ++childIndex) {
            // Reset all remaining animations to not have the property set.
            list.animation(childIndex).clearCompositeOperation();
        }
    }
    static void applyInitialAnimationDelay(BuilderState& builderState)
    {
        auto& list = builderState.style().ensureAnimations();
        if (list.isEmpty())
            list.append(Animation::create());
        list.animation(0).setDelay(Animation::initialDelay());
        for (auto& animation : list)
            animation->clearDelay();
    }
    static void applyInheritAnimationDelay(BuilderState& builderState)
    {
        auto& list = builderState.style().ensureAnimations();
        auto* parentList = builderState.parentStyle().animations();
        size_t i = 0, parentSize = parentList ? parentList->size() : 0;
        for ( ; i < parentSize && parentList->animation(i).isDelaySet(); ++i) {
            if (list.size() <= i)
                list.append(Animation::create());
            list.animation(i).setDelay(parentList->animation(i).delay());
        }
        // Reset any remaining animations to not have the property set.
        for ( ; i < list.size(); ++i)
            list.animation(i).clearDelay();
    }
    static void applyValueAnimationDelay(BuilderState& builderState, CSSValue& value)
    {
        auto& list = builderState.style().ensureAnimations();
        size_t childIndex = 0;
        if (auto* valueList = dynamicDowncast<CSSValueList>(value)) {
            // Walk each value and put it into an animation, creating new animations as needed.
            for (auto& currentValue : *valueList) {
                if (childIndex >= list.size())
                    list.append(Animation::create());
                builderState.styleMap().mapAnimationDelay(list.animation(childIndex), currentValue);
                ++childIndex;
            }
        } else {
            if (list.isEmpty())
                list.append(Animation::create());
            builderState.styleMap().mapAnimationDelay(list.animation(childIndex), value);
            childIndex = 1;
        }
        for ( ; childIndex < list.size(); ++childIndex) {
            // Reset all remaining animations to not have the property set.
            list.animation(childIndex).clearDelay();
        }
    }
    static void applyInitialAnimationDirection(BuilderState& builderState)
    {
        auto& list = builderState.style().ensureAnimations();
        if (list.isEmpty())
            list.append(Animation::create());
        list.animation(0).setDirection(Animation::initialDirection());
        for (auto& animation : list)
            animation->clearDirection();
    }
    static void applyInheritAnimationDirection(BuilderState& builderState)
    {
        auto& list = builderState.style().ensureAnimations();
        auto* parentList = builderState.parentStyle().animations();
        size_t i = 0, parentSize = parentList ? parentList->size() : 0;
        for ( ; i < parentSize && parentList->animation(i).isDirectionSet(); ++i) {
            if (list.size() <= i)
                list.append(Animation::create());
            list.animation(i).setDirection(parentList->animation(i).direction());
        }
        // Reset any remaining animations to not have the property set.
        for ( ; i < list.size(); ++i)
            list.animation(i).clearDirection();
    }
    static void applyValueAnimationDirection(BuilderState& builderState, CSSValue& value)
    {
        auto& list = builderState.style().ensureAnimations();
        size_t childIndex = 0;
        if (auto* valueList = dynamicDowncast<CSSValueList>(value)) {
            // Walk each value and put it into an animation, creating new animations as needed.
            for (auto& currentValue : *valueList) {
                if (childIndex >= list.size())
                    list.append(Animation::create());
                builderState.styleMap().mapAnimationDirection(list.animation(childIndex), currentValue);
                ++childIndex;
            }
        } else {
            if (list.isEmpty())
                list.append(Animation::create());
            builderState.styleMap().mapAnimationDirection(list.animation(childIndex), value);
            childIndex = 1;
        }
        for ( ; childIndex < list.size(); ++childIndex) {
            // Reset all remaining animations to not have the property set.
            list.animation(childIndex).clearDirection();
        }
    }
    static void applyInitialAnimationDuration(BuilderState& builderState)
    {
        auto& list = builderState.style().ensureAnimations();
        if (list.isEmpty())
            list.append(Animation::create());
        list.animation(0).setDuration(Animation::initialDuration());
        for (auto& animation : list)
            animation->clearDuration();
    }
    static void applyInheritAnimationDuration(BuilderState& builderState)
    {
        auto& list = builderState.style().ensureAnimations();
        auto* parentList = builderState.parentStyle().animations();
        size_t i = 0, parentSize = parentList ? parentList->size() : 0;
        for ( ; i < parentSize && parentList->animation(i).isDurationSet(); ++i) {
            if (list.size() <= i)
                list.append(Animation::create());
            list.animation(i).setDuration(parentList->animation(i).duration());
        }
        // Reset any remaining animations to not have the property set.
        for ( ; i < list.size(); ++i)
            list.animation(i).clearDuration();
    }
    static void applyValueAnimationDuration(BuilderState& builderState, CSSValue& value)
    {
        auto& list = builderState.style().ensureAnimations();
        size_t childIndex = 0;
        if (auto* valueList = dynamicDowncast<CSSValueList>(value)) {
            // Walk each value and put it into an animation, creating new animations as needed.
            for (auto& currentValue : *valueList) {
                if (childIndex >= list.size())
                    list.append(Animation::create());
                builderState.styleMap().mapAnimationDuration(list.animation(childIndex), currentValue);
                ++childIndex;
            }
        } else {
            if (list.isEmpty())
                list.append(Animation::create());
            builderState.styleMap().mapAnimationDuration(list.animation(childIndex), value);
            childIndex = 1;
        }
        for ( ; childIndex < list.size(); ++childIndex) {
            // Reset all remaining animations to not have the property set.
            list.animation(childIndex).clearDuration();
        }
    }
    static void applyInitialAnimationFillMode(BuilderState& builderState)
    {
        auto& list = builderState.style().ensureAnimations();
        if (list.isEmpty())
            list.append(Animation::create());
        list.animation(0).setFillMode(Animation::initialFillMode());
        for (auto& animation : list)
            animation->clearFillMode();
    }
    static void applyInheritAnimationFillMode(BuilderState& builderState)
    {
        auto& list = builderState.style().ensureAnimations();
        auto* parentList = builderState.parentStyle().animations();
        size_t i = 0, parentSize = parentList ? parentList->size() : 0;
        for ( ; i < parentSize && parentList->animation(i).isFillModeSet(); ++i) {
            if (list.size() <= i)
                list.append(Animation::create());
            list.animation(i).setFillMode(parentList->animation(i).fillMode());
        }
        // Reset any remaining animations to not have the property set.
        for ( ; i < list.size(); ++i)
            list.animation(i).clearFillMode();
    }
    static void applyValueAnimationFillMode(BuilderState& builderState, CSSValue& value)
    {
        auto& list = builderState.style().ensureAnimations();
        size_t childIndex = 0;
        if (auto* valueList = dynamicDowncast<CSSValueList>(value)) {
            // Walk each value and put it into an animation, creating new animations as needed.
            for (auto& currentValue : *valueList) {
                if (childIndex >= list.size())
                    list.append(Animation::create());
                builderState.styleMap().mapAnimationFillMode(list.animation(childIndex), currentValue);
                ++childIndex;
            }
        } else {
            if (list.isEmpty())
                list.append(Animation::create());
            builderState.styleMap().mapAnimationFillMode(list.animation(childIndex), value);
            childIndex = 1;
        }
        for ( ; childIndex < list.size(); ++childIndex) {
            // Reset all remaining animations to not have the property set.
            list.animation(childIndex).clearFillMode();
        }
    }
    static void applyInitialAnimationIterationCount(BuilderState& builderState)
    {
        auto& list = builderState.style().ensureAnimations();
        if (list.isEmpty())
            list.append(Animation::create());
        list.animation(0).setIterationCount(Animation::initialIterationCount());
        for (auto& animation : list)
            animation->clearIterationCount();
    }
    static void applyInheritAnimationIterationCount(BuilderState& builderState)
    {
        auto& list = builderState.style().ensureAnimations();
        auto* parentList = builderState.parentStyle().animations();
        size_t i = 0, parentSize = parentList ? parentList->size() : 0;
        for ( ; i < parentSize && parentList->animation(i).isIterationCountSet(); ++i) {
            if (list.size() <= i)
                list.append(Animation::create());
            list.animation(i).setIterationCount(parentList->animation(i).iterationCount());
        }
        // Reset any remaining animations to not have the property set.
        for ( ; i < list.size(); ++i)
            list.animation(i).clearIterationCount();
    }
    static void applyValueAnimationIterationCount(BuilderState& builderState, CSSValue& value)
    {
        auto& list = builderState.style().ensureAnimations();
        size_t childIndex = 0;
        if (auto* valueList = dynamicDowncast<CSSValueList>(value)) {
            // Walk each value and put it into an animation, creating new animations as needed.
            for (auto& currentValue : *valueList) {
                if (childIndex >= list.size())
                    list.append(Animation::create());
                builderState.styleMap().mapAnimationIterationCount(list.animation(childIndex), currentValue);
                ++childIndex;
            }
        } else {
            if (list.isEmpty())
                list.append(Animation::create());
            builderState.styleMap().mapAnimationIterationCount(list.animation(childIndex), value);
            childIndex = 1;
        }
        for ( ; childIndex < list.size(); ++childIndex) {
            // Reset all remaining animations to not have the property set.
            list.animation(childIndex).clearIterationCount();
        }
    }
    static void applyInitialAnimationName(BuilderState& builderState)
    {
        auto& list = builderState.style().ensureAnimations();
        if (list.isEmpty())
            list.append(Animation::create());
        list.animation(0).setName(Animation::initialName());
        for (auto& animation : list)
            animation->clearName();
    }
    static void applyInheritAnimationName(BuilderState& builderState)
    {
        auto& list = builderState.style().ensureAnimations();
        auto* parentList = builderState.parentStyle().animations();
        size_t i = 0, parentSize = parentList ? parentList->size() : 0;
        for ( ; i < parentSize && parentList->animation(i).isNameSet(); ++i) {
            if (list.size() <= i)
                list.append(Animation::create());
            list.animation(i).setName(parentList->animation(i).name());
        }
        // Reset any remaining animations to not have the property set.
        for ( ; i < list.size(); ++i)
            list.animation(i).clearName();
    }
    static void applyValueAnimationName(BuilderState& builderState, CSSValue& value)
    {
        auto& list = builderState.style().ensureAnimations();
        size_t childIndex = 0;
        if (auto* valueList = dynamicDowncast<CSSValueList>(value)) {
            // Walk each value and put it into an animation, creating new animations as needed.
            for (auto& currentValue : *valueList) {
                if (childIndex >= list.size())
                    list.append(Animation::create());
                builderState.styleMap().mapAnimationName(list.animation(childIndex), currentValue);
                ++childIndex;
            }
        } else {
            if (list.isEmpty())
                list.append(Animation::create());
            builderState.styleMap().mapAnimationName(list.animation(childIndex), value);
            childIndex = 1;
        }
        for ( ; childIndex < list.size(); ++childIndex) {
            // Reset all remaining animations to not have the property set.
            list.animation(childIndex).clearName();
        }
    }
    static void applyInitialAnimationPlayState(BuilderState& builderState)
    {
        auto& list = builderState.style().ensureAnimations();
        if (list.isEmpty())
            list.append(Animation::create());
        list.animation(0).setPlayState(Animation::initialPlayState());
        for (auto& animation : list)
            animation->clearPlayState();
    }
    static void applyInheritAnimationPlayState(BuilderState& builderState)
    {
        auto& list = builderState.style().ensureAnimations();
        auto* parentList = builderState.parentStyle().animations();
        size_t i = 0, parentSize = parentList ? parentList->size() : 0;
        for ( ; i < parentSize && parentList->animation(i).isPlayStateSet(); ++i) {
            if (list.size() <= i)
                list.append(Animation::create());
            list.animation(i).setPlayState(parentList->animation(i).playState());
        }
        // Reset any remaining animations to not have the property set.
        for ( ; i < list.size(); ++i)
            list.animation(i).clearPlayState();
    }
    static void applyValueAnimationPlayState(BuilderState& builderState, CSSValue& value)
    {
        auto& list = builderState.style().ensureAnimations();
        size_t childIndex = 0;
        if (auto* valueList = dynamicDowncast<CSSValueList>(value)) {
            // Walk each value and put it into an animation, creating new animations as needed.
            for (auto& currentValue : *valueList) {
                if (childIndex >= list.size())
                    list.append(Animation::create());
                builderState.styleMap().mapAnimationPlayState(list.animation(childIndex), currentValue);
                ++childIndex;
            }
        } else {
            if (list.isEmpty())
                list.append(Animation::create());
            builderState.styleMap().mapAnimationPlayState(list.animation(childIndex), value);
            childIndex = 1;
        }
        for ( ; childIndex < list.size(); ++childIndex) {
            // Reset all remaining animations to not have the property set.
            list.animation(childIndex).clearPlayState();
        }
    }
    static void applyInitialAnimationTimeline(BuilderState& builderState)
    {
        auto& list = builderState.style().ensureAnimations();
        if (list.isEmpty())
            list.append(Animation::create());
        list.animation(0).setTimeline(Animation::initialTimeline());
        for (auto& animation : list)
            animation->clearTimeline();
    }
    static void applyInheritAnimationTimeline(BuilderState& builderState)
    {
        auto& list = builderState.style().ensureAnimations();
        auto* parentList = builderState.parentStyle().animations();
        size_t i = 0, parentSize = parentList ? parentList->size() : 0;
        for ( ; i < parentSize && parentList->animation(i).isTimelineSet(); ++i) {
            if (list.size() <= i)
                list.append(Animation::create());
            list.animation(i).setTimeline(parentList->animation(i).timeline());
        }
        // Reset any remaining animations to not have the property set.
        for ( ; i < list.size(); ++i)
            list.animation(i).clearTimeline();
    }
    static void applyValueAnimationTimeline(BuilderState& builderState, CSSValue& value)
    {
        auto& list = builderState.style().ensureAnimations();
        size_t childIndex = 0;
        if (auto* valueList = dynamicDowncast<CSSValueList>(value)) {
            // Walk each value and put it into an animation, creating new animations as needed.
            for (auto& currentValue : *valueList) {
                if (childIndex >= list.size())
                    list.append(Animation::create());
                builderState.styleMap().mapAnimationTimeline(list.animation(childIndex), currentValue);
                ++childIndex;
            }
        } else {
            if (list.isEmpty())
                list.append(Animation::create());
            builderState.styleMap().mapAnimationTimeline(list.animation(childIndex), value);
            childIndex = 1;
        }
        for ( ; childIndex < list.size(); ++childIndex) {
            // Reset all remaining animations to not have the property set.
            list.animation(childIndex).clearTimeline();
        }
    }
    static void applyInitialAnimationTimingFunction(BuilderState& builderState)
    {
        auto& list = builderState.style().ensureAnimations();
        if (list.isEmpty())
            list.append(Animation::create());
        list.animation(0).setTimingFunction(Animation::initialTimingFunction());
        for (auto& animation : list)
            animation->clearTimingFunction();
    }
    static void applyInheritAnimationTimingFunction(BuilderState& builderState)
    {
        auto& list = builderState.style().ensureAnimations();
        auto* parentList = builderState.parentStyle().animations();
        size_t i = 0, parentSize = parentList ? parentList->size() : 0;
        for ( ; i < parentSize && parentList->animation(i).isTimingFunctionSet(); ++i) {
            if (list.size() <= i)
                list.append(Animation::create());
            list.animation(i).setTimingFunction(parentList->animation(i).timingFunction());
        }
        // Reset any remaining animations to not have the property set.
        for ( ; i < list.size(); ++i)
            list.animation(i).clearTimingFunction();
    }
    static void applyValueAnimationTimingFunction(BuilderState& builderState, CSSValue& value)
    {
        auto& list = builderState.style().ensureAnimations();
        size_t childIndex = 0;
        if (auto* valueList = dynamicDowncast<CSSValueList>(value)) {
            // Walk each value and put it into an animation, creating new animations as needed.
            for (auto& currentValue : *valueList) {
                if (childIndex >= list.size())
                    list.append(Animation::create());
                builderState.styleMap().mapAnimationTimingFunction(list.animation(childIndex), currentValue);
                ++childIndex;
            }
        } else {
            if (list.isEmpty())
                list.append(Animation::create());
            builderState.styleMap().mapAnimationTimingFunction(list.animation(childIndex), value);
            childIndex = 1;
        }
        for ( ; childIndex < list.size(); ++childIndex) {
            // Reset all remaining animations to not have the property set.
            list.animation(childIndex).clearTimingFunction();
        }
    }
    static void applyInitialAppearance(BuilderState& builderState)
    {
        builderState.style().setAppearance(RenderStyle::initialAppearance());
    }
    static void applyInheritAppearance(BuilderState& builderState)
    {
        builderState.style().setAppearance(forwardInheritedValue(builderState.parentStyle().appearance()));
    }
    static void applyValueAppearance(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setAppearance(fromCSSValueDeducingType(value));
    }
    static void applyInitialBackdropFilter(BuilderState& builderState)
    {
        builderState.style().setBackdropFilter(RenderStyle::initialBackdropFilter());
    }
    static void applyInheritBackdropFilter(BuilderState& builderState)
    {
        builderState.style().setBackdropFilter(forwardInheritedValue(builderState.parentStyle().backdropFilter()));
    }
    static void applyValueBackdropFilter(BuilderState& builderState, CSSValue& value)
    {
        auto convertedValue = BuilderConverter::convertFilterOperations(builderState, value);
        if (convertedValue)
            builderState.style().setBackdropFilter(WTFMove(convertedValue.value()));
    }
    static void applyInitialBackfaceVisibility(BuilderState& builderState)
    {
        builderState.style().setBackfaceVisibility(RenderStyle::initialBackfaceVisibility());
    }
    static void applyInheritBackfaceVisibility(BuilderState& builderState)
    {
        builderState.style().setBackfaceVisibility(forwardInheritedValue(builderState.parentStyle().backfaceVisibility()));
    }
    static void applyValueBackfaceVisibility(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setBackfaceVisibility(fromCSSValueDeducingType(value));
    }
    static void applyInitialBackgroundAttachment(BuilderState& builderState)
    {
        // Check for (single-layer) no-op before clearing anything.
        auto& layers = builderState.style().backgroundLayers();
        if (!layers.next() && (!layers.isAttachmentSet() || layers.attachment() == FillLayer::initialFillAttachment(FillLayerType::Background)))
            return;
        auto* child = &builderState.style().ensureBackgroundLayers();
        child->setAttachment(FillLayer::initialFillAttachment(FillLayerType::Background));
        for (child = child->next(); child; child = child->next())
            child->clearAttachment();
    }
    static void applyInheritBackgroundAttachment(BuilderState& builderState)
    {
        // Check for no-op before copying anything.
        if (builderState.parentStyle().backgroundLayers() == builderState.style().backgroundLayers())
            return;
        auto* child = &builderState.style().ensureBackgroundLayers();
        FillLayer* previousChild = nullptr;
        for (auto* parent = &builderState.parentStyle().backgroundLayers(); parent && parent->isAttachmentSet(); parent = parent->next()) {
            if (!child) {
                previousChild->setNext(FillLayer::create(FillLayerType::Background));
                child = previousChild->next();
            }
            child->setAttachment(parent->attachment());
            previousChild = child;
            child = previousChild->next();
        }
        for (; child; child = child->next())
            child->clearAttachment();
    }
    static void applyValueBackgroundAttachment(CSSPropertyID id, BuilderState& builderState, CSSValue& value)
    {
        auto* child = &builderState.style().ensureBackgroundLayers();
        FillLayer* previousChild = nullptr;
        if (auto* valueList = dynamicDowncast<CSSValueList>(value)) {
            // Walk each value and put it into a layer, creating new layers as needed.
            for (auto& item : *valueList) {
                if (!child) {
                    previousChild->setNext(FillLayer::create(FillLayerType::Background));
                    child = previousChild->next();
                }
                builderState.styleMap().mapFillAttachment(id, *child, item);
                previousChild = child;
                child = child->next();
            }
        } else {
            builderState.styleMap().mapFillAttachment(id, *child, value);
            child = child->next();
        }
        for (; child; child = child->next())
            child->clearAttachment();
    }
    static void applyInitialBackgroundBlendMode(BuilderState& builderState)
    {
        // Check for (single-layer) no-op before clearing anything.
        auto& layers = builderState.style().backgroundLayers();
        if (!layers.next() && (!layers.isBlendModeSet() || layers.blendMode() == FillLayer::initialFillBlendMode(FillLayerType::Background)))
            return;
        auto* child = &builderState.style().ensureBackgroundLayers();
        child->setBlendMode(FillLayer::initialFillBlendMode(FillLayerType::Background));
        for (child = child->next(); child; child = child->next())
            child->clearBlendMode();
    }
    static void applyInheritBackgroundBlendMode(BuilderState& builderState)
    {
        // Check for no-op before copying anything.
        if (builderState.parentStyle().backgroundLayers() == builderState.style().backgroundLayers())
            return;
        auto* child = &builderState.style().ensureBackgroundLayers();
        FillLayer* previousChild = nullptr;
        for (auto* parent = &builderState.parentStyle().backgroundLayers(); parent && parent->isBlendModeSet(); parent = parent->next()) {
            if (!child) {
                previousChild->setNext(FillLayer::create(FillLayerType::Background));
                child = previousChild->next();
            }
            child->setBlendMode(parent->blendMode());
            previousChild = child;
            child = previousChild->next();
        }
        for (; child; child = child->next())
            child->clearBlendMode();
    }
    static void applyValueBackgroundBlendMode(CSSPropertyID id, BuilderState& builderState, CSSValue& value)
    {
        auto* child = &builderState.style().ensureBackgroundLayers();
        FillLayer* previousChild = nullptr;
        if (auto* valueList = dynamicDowncast<CSSValueList>(value)) {
            // Walk each value and put it into a layer, creating new layers as needed.
            for (auto& item : *valueList) {
                if (!child) {
                    previousChild->setNext(FillLayer::create(FillLayerType::Background));
                    child = previousChild->next();
                }
                builderState.styleMap().mapFillBlendMode(id, *child, item);
                previousChild = child;
                child = child->next();
            }
        } else {
            builderState.styleMap().mapFillBlendMode(id, *child, value);
            child = child->next();
        }
        for (; child; child = child->next())
            child->clearBlendMode();
    }
    static void applyInitialBackgroundClip(BuilderState& builderState)
    {
        // Check for (single-layer) no-op before clearing anything.
        auto& layers = builderState.style().backgroundLayers();
        if (!layers.next() && (!layers.isClipSet() || layers.clip() == FillLayer::initialFillClip(FillLayerType::Background)))
            return;
        auto* child = &builderState.style().ensureBackgroundLayers();
        child->setClip(FillLayer::initialFillClip(FillLayerType::Background));
        for (child = child->next(); child; child = child->next())
            child->clearClip();
    }
    static void applyInheritBackgroundClip(BuilderState& builderState)
    {
        // Check for no-op before copying anything.
        if (builderState.parentStyle().backgroundLayers() == builderState.style().backgroundLayers())
            return;
        auto* child = &builderState.style().ensureBackgroundLayers();
        FillLayer* previousChild = nullptr;
        for (auto* parent = &builderState.parentStyle().backgroundLayers(); parent && parent->isClipSet(); parent = parent->next()) {
            if (!child) {
                previousChild->setNext(FillLayer::create(FillLayerType::Background));
                child = previousChild->next();
            }
            child->setClip(parent->clip());
            previousChild = child;
            child = previousChild->next();
        }
        for (; child; child = child->next())
            child->clearClip();
    }
    static void applyValueBackgroundClip(CSSPropertyID id, BuilderState& builderState, CSSValue& value)
    {
        auto* child = &builderState.style().ensureBackgroundLayers();
        FillLayer* previousChild = nullptr;
        if (auto* valueList = dynamicDowncast<CSSValueList>(value)) {
            // Walk each value and put it into a layer, creating new layers as needed.
            for (auto& item : *valueList) {
                if (!child) {
                    previousChild->setNext(FillLayer::create(FillLayerType::Background));
                    child = previousChild->next();
                }
                builderState.styleMap().mapFillClip(id, *child, item);
                previousChild = child;
                child = child->next();
            }
        } else {
            builderState.styleMap().mapFillClip(id, *child, value);
            child = child->next();
        }
        for (; child; child = child->next())
            child->clearClip();
    }
    static void applyInitialBackgroundColor(BuilderState& builderState)
    {
        if (builderState.applyPropertyToRegularStyle())
            builderState.style().setBackgroundColor(RenderStyle::initialBackgroundColor());
        if (builderState.applyPropertyToVisitedLinkStyle())
            builderState.style().setVisitedLinkBackgroundColor(RenderStyle::initialBackgroundColor());
    }
    static void applyInheritBackgroundColor(BuilderState& builderState)
    {
        if (builderState.applyPropertyToRegularStyle())
            builderState.style().setBackgroundColor(builderState.parentStyle().backgroundColor());
        if (builderState.applyPropertyToVisitedLinkStyle())
            builderState.style().setVisitedLinkBackgroundColor(builderState.parentStyle().backgroundColor());
    }
    static void applyValueBackgroundColor(BuilderState& builderState, CSSValue& value)
    {
        if (builderState.applyPropertyToRegularStyle())
            builderState.style().setBackgroundColor(builderState.colorFromPrimitiveValue(fromCSSValueDeducingType(value), ForVisitedLink::No));
        if (builderState.applyPropertyToVisitedLinkStyle())
            builderState.style().setVisitedLinkBackgroundColor(builderState.colorFromPrimitiveValue(fromCSSValueDeducingType(value), ForVisitedLink::Yes));
    }
    static void applyInitialBackgroundImage(BuilderState& builderState)
    {
        // Check for (single-layer) no-op before clearing anything.
        auto& layers = builderState.style().backgroundLayers();
        if (!layers.next() && (!layers.isImageSet() || layers.image() == FillLayer::initialFillImage(FillLayerType::Background)))
            return;
        auto* child = &builderState.style().ensureBackgroundLayers();
        child->setImage(FillLayer::initialFillImage(FillLayerType::Background));
        for (child = child->next(); child; child = child->next())
            child->clearImage();
    }
    static void applyInheritBackgroundImage(BuilderState& builderState)
    {
        // Check for no-op before copying anything.
        if (builderState.parentStyle().backgroundLayers() == builderState.style().backgroundLayers())
            return;
        auto* child = &builderState.style().ensureBackgroundLayers();
        FillLayer* previousChild = nullptr;
        for (auto* parent = &builderState.parentStyle().backgroundLayers(); parent && parent->isImageSet(); parent = parent->next()) {
            if (!child) {
                previousChild->setNext(FillLayer::create(FillLayerType::Background));
                child = previousChild->next();
            }
            child->setImage(parent->image());
            previousChild = child;
            child = previousChild->next();
        }
        for (; child; child = child->next())
            child->clearImage();
    }
    static void applyValueBackgroundImage(CSSPropertyID id, BuilderState& builderState, CSSValue& value)
    {
        auto* child = &builderState.style().ensureBackgroundLayers();
        FillLayer* previousChild = nullptr;
        if (auto* valueList = dynamicDowncast<CSSValueList>(value)) {
            // Walk each value and put it into a layer, creating new layers as needed.
            for (auto& item : *valueList) {
                if (!child) {
                    previousChild->setNext(FillLayer::create(FillLayerType::Background));
                    child = previousChild->next();
                }
                builderState.styleMap().mapFillImage(id, *child, item);
                previousChild = child;
                child = child->next();
            }
        } else {
            builderState.styleMap().mapFillImage(id, *child, value);
            child = child->next();
        }
        for (; child; child = child->next())
            child->clearImage();
    }
    static void applyInitialBackgroundOrigin(BuilderState& builderState)
    {
        // Check for (single-layer) no-op before clearing anything.
        auto& layers = builderState.style().backgroundLayers();
        if (!layers.next() && (!layers.isOriginSet() || layers.origin() == FillLayer::initialFillOrigin(FillLayerType::Background)))
            return;
        auto* child = &builderState.style().ensureBackgroundLayers();
        child->setOrigin(FillLayer::initialFillOrigin(FillLayerType::Background));
        for (child = child->next(); child; child = child->next())
            child->clearOrigin();
    }
    static void applyInheritBackgroundOrigin(BuilderState& builderState)
    {
        // Check for no-op before copying anything.
        if (builderState.parentStyle().backgroundLayers() == builderState.style().backgroundLayers())
            return;
        auto* child = &builderState.style().ensureBackgroundLayers();
        FillLayer* previousChild = nullptr;
        for (auto* parent = &builderState.parentStyle().backgroundLayers(); parent && parent->isOriginSet(); parent = parent->next()) {
            if (!child) {
                previousChild->setNext(FillLayer::create(FillLayerType::Background));
                child = previousChild->next();
            }
            child->setOrigin(parent->origin());
            previousChild = child;
            child = previousChild->next();
        }
        for (; child; child = child->next())
            child->clearOrigin();
    }
    static void applyValueBackgroundOrigin(CSSPropertyID id, BuilderState& builderState, CSSValue& value)
    {
        auto* child = &builderState.style().ensureBackgroundLayers();
        FillLayer* previousChild = nullptr;
        if (auto* valueList = dynamicDowncast<CSSValueList>(value)) {
            // Walk each value and put it into a layer, creating new layers as needed.
            for (auto& item : *valueList) {
                if (!child) {
                    previousChild->setNext(FillLayer::create(FillLayerType::Background));
                    child = previousChild->next();
                }
                builderState.styleMap().mapFillOrigin(id, *child, item);
                previousChild = child;
                child = child->next();
            }
        } else {
            builderState.styleMap().mapFillOrigin(id, *child, value);
            child = child->next();
        }
        for (; child; child = child->next())
            child->clearOrigin();
    }
    static void applyInitialBackgroundPositionX(BuilderState& builderState)
    {
        // Check for (single-layer) no-op before clearing anything.
        auto& layers = builderState.style().backgroundLayers();
        if (!layers.next() && (!layers.isXPositionSet() || layers.xPosition() == FillLayer::initialFillXPosition(FillLayerType::Background)))
            return;
        auto* child = &builderState.style().ensureBackgroundLayers();
        child->setXPosition(FillLayer::initialFillXPosition(FillLayerType::Background));
        for (child = child->next(); child; child = child->next())
            child->clearXPosition();
    }
    static void applyInheritBackgroundPositionX(BuilderState& builderState)
    {
        // Check for no-op before copying anything.
        if (builderState.parentStyle().backgroundLayers() == builderState.style().backgroundLayers())
            return;
        auto* child = &builderState.style().ensureBackgroundLayers();
        FillLayer* previousChild = nullptr;
        for (auto* parent = &builderState.parentStyle().backgroundLayers(); parent && parent->isXPositionSet(); parent = parent->next()) {
            if (!child) {
                previousChild->setNext(FillLayer::create(FillLayerType::Background));
                child = previousChild->next();
            }
            child->setXPosition(parent->xPosition());
            previousChild = child;
            child = previousChild->next();
        }
        for (; child; child = child->next())
            child->clearXPosition();
    }
    static void applyValueBackgroundPositionX(CSSPropertyID id, BuilderState& builderState, CSSValue& value)
    {
        auto* child = &builderState.style().ensureBackgroundLayers();
        FillLayer* previousChild = nullptr;
        if (auto* valueList = dynamicDowncast<CSSValueList>(value)) {
            // Walk each value and put it into a layer, creating new layers as needed.
            for (auto& item : *valueList) {
                if (!child) {
                    previousChild->setNext(FillLayer::create(FillLayerType::Background));
                    child = previousChild->next();
                }
                builderState.styleMap().mapFillXPosition(id, *child, item);
                previousChild = child;
                child = child->next();
            }
        } else {
            builderState.styleMap().mapFillXPosition(id, *child, value);
            child = child->next();
        }
        for (; child; child = child->next())
            child->clearXPosition();
    }
    static void applyInitialBackgroundPositionY(BuilderState& builderState)
    {
        // Check for (single-layer) no-op before clearing anything.
        auto& layers = builderState.style().backgroundLayers();
        if (!layers.next() && (!layers.isYPositionSet() || layers.yPosition() == FillLayer::initialFillYPosition(FillLayerType::Background)))
            return;
        auto* child = &builderState.style().ensureBackgroundLayers();
        child->setYPosition(FillLayer::initialFillYPosition(FillLayerType::Background));
        for (child = child->next(); child; child = child->next())
            child->clearYPosition();
    }
    static void applyInheritBackgroundPositionY(BuilderState& builderState)
    {
        // Check for no-op before copying anything.
        if (builderState.parentStyle().backgroundLayers() == builderState.style().backgroundLayers())
            return;
        auto* child = &builderState.style().ensureBackgroundLayers();
        FillLayer* previousChild = nullptr;
        for (auto* parent = &builderState.parentStyle().backgroundLayers(); parent && parent->isYPositionSet(); parent = parent->next()) {
            if (!child) {
                previousChild->setNext(FillLayer::create(FillLayerType::Background));
                child = previousChild->next();
            }
            child->setYPosition(parent->yPosition());
            previousChild = child;
            child = previousChild->next();
        }
        for (; child; child = child->next())
            child->clearYPosition();
    }
    static void applyValueBackgroundPositionY(CSSPropertyID id, BuilderState& builderState, CSSValue& value)
    {
        auto* child = &builderState.style().ensureBackgroundLayers();
        FillLayer* previousChild = nullptr;
        if (auto* valueList = dynamicDowncast<CSSValueList>(value)) {
            // Walk each value and put it into a layer, creating new layers as needed.
            for (auto& item : *valueList) {
                if (!child) {
                    previousChild->setNext(FillLayer::create(FillLayerType::Background));
                    child = previousChild->next();
                }
                builderState.styleMap().mapFillYPosition(id, *child, item);
                previousChild = child;
                child = child->next();
            }
        } else {
            builderState.styleMap().mapFillYPosition(id, *child, value);
            child = child->next();
        }
        for (; child; child = child->next())
            child->clearYPosition();
    }
    static void applyInitialBackgroundRepeat(BuilderState& builderState)
    {
        // Check for (single-layer) no-op before clearing anything.
        auto& layers = builderState.style().backgroundLayers();
        if (!layers.next() && (!layers.isRepeatSet() || layers.repeat() == FillLayer::initialFillRepeat(FillLayerType::Background)))
            return;
        auto* child = &builderState.style().ensureBackgroundLayers();
        child->setRepeat(FillLayer::initialFillRepeat(FillLayerType::Background));
        for (child = child->next(); child; child = child->next())
            child->clearRepeat();
    }
    static void applyInheritBackgroundRepeat(BuilderState& builderState)
    {
        // Check for no-op before copying anything.
        if (builderState.parentStyle().backgroundLayers() == builderState.style().backgroundLayers())
            return;
        auto* child = &builderState.style().ensureBackgroundLayers();
        FillLayer* previousChild = nullptr;
        for (auto* parent = &builderState.parentStyle().backgroundLayers(); parent && parent->isRepeatSet(); parent = parent->next()) {
            if (!child) {
                previousChild->setNext(FillLayer::create(FillLayerType::Background));
                child = previousChild->next();
            }
            child->setRepeat(parent->repeat());
            previousChild = child;
            child = previousChild->next();
        }
        for (; child; child = child->next())
            child->clearRepeat();
    }
    static void applyValueBackgroundRepeat(CSSPropertyID id, BuilderState& builderState, CSSValue& value)
    {
        auto* child = &builderState.style().ensureBackgroundLayers();
        FillLayer* previousChild = nullptr;
        if (auto* valueList = dynamicDowncast<CSSValueList>(value)) {
            // Walk each value and put it into a layer, creating new layers as needed.
            for (auto& item : *valueList) {
                if (!child) {
                    previousChild->setNext(FillLayer::create(FillLayerType::Background));
                    child = previousChild->next();
                }
                builderState.styleMap().mapFillRepeat(id, *child, item);
                previousChild = child;
                child = child->next();
            }
        } else {
            builderState.styleMap().mapFillRepeat(id, *child, value);
            child = child->next();
        }
        for (; child; child = child->next())
            child->clearRepeat();
    }
    static void applyInitialBackgroundSize(BuilderState& builderState)
    {
        // Check for (single-layer) no-op before clearing anything.
        auto& layers = builderState.style().backgroundLayers();
        if (!layers.next() && (!layers.isSizeSet() || layers.size() == FillLayer::initialFillSize(FillLayerType::Background)))
            return;
        auto* child = &builderState.style().ensureBackgroundLayers();
        child->setSize(FillLayer::initialFillSize(FillLayerType::Background));
        for (child = child->next(); child; child = child->next())
            child->clearSize();
    }
    static void applyInheritBackgroundSize(BuilderState& builderState)
    {
        // Check for no-op before copying anything.
        if (builderState.parentStyle().backgroundLayers() == builderState.style().backgroundLayers())
            return;
        auto* child = &builderState.style().ensureBackgroundLayers();
        FillLayer* previousChild = nullptr;
        for (auto* parent = &builderState.parentStyle().backgroundLayers(); parent && parent->isSizeSet(); parent = parent->next()) {
            if (!child) {
                previousChild->setNext(FillLayer::create(FillLayerType::Background));
                child = previousChild->next();
            }
            child->setSize(parent->size());
            previousChild = child;
            child = previousChild->next();
        }
        for (; child; child = child->next())
            child->clearSize();
    }
    static void applyValueBackgroundSize(CSSPropertyID id, BuilderState& builderState, CSSValue& value)
    {
        auto* child = &builderState.style().ensureBackgroundLayers();
        FillLayer* previousChild = nullptr;
        if (auto* valueList = dynamicDowncast<CSSValueList>(value)) {
            // Walk each value and put it into a layer, creating new layers as needed.
            for (auto& item : *valueList) {
                if (!child) {
                    previousChild->setNext(FillLayer::create(FillLayerType::Background));
                    child = previousChild->next();
                }
                builderState.styleMap().mapFillSize(id, *child, item);
                previousChild = child;
                child = child->next();
            }
        } else {
            builderState.styleMap().mapFillSize(id, *child, value);
            child = child->next();
        }
        for (; child; child = child->next())
            child->clearSize();
    }
    static void applyInitialBaselineShift(BuilderState& builderState)
    {
        builderState.style().accessSVGStyle().setBaselineShift(SVGRenderStyle::initialBaselineShift());
    }
    static void applyInitialBlockStepInsert(BuilderState& builderState)
    {
        builderState.style().setBlockStepInsert(RenderStyle::initialBlockStepInsert());
    }
    static void applyInheritBlockStepInsert(BuilderState& builderState)
    {
        builderState.style().setBlockStepInsert(forwardInheritedValue(builderState.parentStyle().blockStepInsert()));
    }
    static void applyValueBlockStepInsert(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setBlockStepInsert(fromCSSValueDeducingType(value));
    }
    static void applyInitialBlockStepSize(BuilderState& builderState)
    {
        builderState.style().setBlockStepSize(RenderStyle::initialBlockStepSize());
    }
    static void applyInheritBlockStepSize(BuilderState& builderState)
    {
        builderState.style().setBlockStepSize(forwardInheritedValue(builderState.parentStyle().blockStepSize()));
    }
    static void applyValueBlockStepSize(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setBlockStepSize(BuilderConverter::convertBlockStepSize(builderState, value));
    }
    static void applyInitialBorderCollapse(BuilderState& builderState)
    {
        builderState.style().setBorderCollapse(RenderStyle::initialBorderCollapse());
    }
    static void applyInheritBorderCollapse(BuilderState& builderState)
    {
        builderState.style().setBorderCollapse(forwardInheritedValue(builderState.parentStyle().borderCollapse()));
    }
    static void applyValueBorderCollapse(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setBorderCollapse(fromCSSValueDeducingType(value));
    }
    static void applyInitialBorderImageSource(BuilderState& builderState)
    {
        builderState.style().setBorderImageSource(RenderStyle::initialBorderImageSource());
    }
    static void applyInheritBorderImageSource(BuilderState& builderState)
    {
        builderState.style().setBorderImageSource(forwardInheritedValue(builderState.parentStyle().borderImageSource()));
    }
    static void applyValueBorderImageSource(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setBorderImageSource(BuilderConverter::convertStyleImage<CSSPropertyBorderImageSource>(builderState, value));
    }
    static void applyInitialBoxSizing(BuilderState& builderState)
    {
        builderState.style().setBoxSizing(RenderStyle::initialBoxSizing());
    }
    static void applyInheritBoxSizing(BuilderState& builderState)
    {
        builderState.style().setBoxSizing(forwardInheritedValue(builderState.parentStyle().boxSizing()));
    }
    static void applyValueBoxSizing(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setBoxSizing(fromCSSValueDeducingType(value));
    }
    static void applyInitialBreakAfter(BuilderState& builderState)
    {
        builderState.style().setBreakAfter(RenderStyle::initialBreakBetween());
    }
    static void applyInheritBreakAfter(BuilderState& builderState)
    {
        builderState.style().setBreakAfter(forwardInheritedValue(builderState.parentStyle().breakAfter()));
    }
    static void applyValueBreakAfter(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setBreakAfter(fromCSSValueDeducingType(value));
    }
    static void applyInitialBreakBefore(BuilderState& builderState)
    {
        builderState.style().setBreakBefore(RenderStyle::initialBreakBetween());
    }
    static void applyInheritBreakBefore(BuilderState& builderState)
    {
        builderState.style().setBreakBefore(forwardInheritedValue(builderState.parentStyle().breakBefore()));
    }
    static void applyValueBreakBefore(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setBreakBefore(fromCSSValueDeducingType(value));
    }
    static void applyInitialBreakInside(BuilderState& builderState)
    {
        builderState.style().setBreakInside(RenderStyle::initialBreakInside());
    }
    static void applyInheritBreakInside(BuilderState& builderState)
    {
        builderState.style().setBreakInside(forwardInheritedValue(builderState.parentStyle().breakInside()));
    }
    static void applyValueBreakInside(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setBreakInside(fromCSSValueDeducingType(value));
    }
    static void applyInitialBufferedRendering(BuilderState& builderState)
    {
        builderState.style().accessSVGStyle().setBufferedRendering(SVGRenderStyle::initialBufferedRendering());
    }
    static void applyInheritBufferedRendering(BuilderState& builderState)
    {
        builderState.style().accessSVGStyle().setBufferedRendering(forwardInheritedValue(builderState.parentStyle().svgStyle().bufferedRendering()));
    }
    static void applyValueBufferedRendering(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().accessSVGStyle().setBufferedRendering(fromCSSValueDeducingType(value));
    }
    static void applyInitialCaptionSide(BuilderState& builderState)
    {
        builderState.style().setCaptionSide(RenderStyle::initialCaptionSide());
    }
    static void applyInheritCaptionSide(BuilderState& builderState)
    {
        builderState.style().setCaptionSide(forwardInheritedValue(builderState.parentStyle().captionSide()));
    }
    static void applyValueCaptionSide(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setCaptionSide(fromCSSValueDeducingType(value));
    }
    static void applyInitialClear(BuilderState& builderState)
    {
        builderState.style().setClear(RenderStyle::initialClear());
    }
    static void applyInheritClear(BuilderState& builderState)
    {
        builderState.style().setClear(forwardInheritedValue(builderState.parentStyle().clear()));
    }
    static void applyValueClear(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setClear(fromCSSValueDeducingType(value));
    }
    static void applyInitialClipPath(BuilderState& builderState)
    {
        builderState.style().setClipPath(RenderStyle::initialClipPath());
    }
    static void applyInheritClipPath(BuilderState& builderState)
    {
        builderState.style().setClipPath(forwardInheritedValue(builderState.parentStyle().clipPath()));
    }
    static void applyValueClipPath(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setClipPath(BuilderConverter::convertPathOperation(builderState, value));
    }
    static void applyInitialClipRule(BuilderState& builderState)
    {
        builderState.style().accessSVGStyle().setClipRule(SVGRenderStyle::initialClipRule());
    }
    static void applyInheritClipRule(BuilderState& builderState)
    {
        builderState.style().accessSVGStyle().setClipRule(forwardInheritedValue(builderState.parentStyle().svgStyle().clipRule()));
    }
    static void applyValueClipRule(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().accessSVGStyle().setClipRule(fromCSSValueDeducingType(value));
    }
    static void applyInitialColorInterpolation(BuilderState& builderState)
    {
        builderState.style().accessSVGStyle().setColorInterpolation(SVGRenderStyle::initialColorInterpolation());
    }
    static void applyInheritColorInterpolation(BuilderState& builderState)
    {
        builderState.style().accessSVGStyle().setColorInterpolation(forwardInheritedValue(builderState.parentStyle().svgStyle().colorInterpolation()));
    }
    static void applyValueColorInterpolation(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().accessSVGStyle().setColorInterpolation(fromCSSValueDeducingType(value));
    }
    static void applyInitialColorInterpolationFilters(BuilderState& builderState)
    {
        builderState.style().accessSVGStyle().setColorInterpolationFilters(SVGRenderStyle::initialColorInterpolationFilters());
    }
    static void applyInheritColorInterpolationFilters(BuilderState& builderState)
    {
        builderState.style().accessSVGStyle().setColorInterpolationFilters(forwardInheritedValue(builderState.parentStyle().svgStyle().colorInterpolationFilters()));
    }
    static void applyValueColorInterpolationFilters(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().accessSVGStyle().setColorInterpolationFilters(fromCSSValueDeducingType(value));
    }
    static void applyInitialColumnCount(BuilderState& builderState)
    {
        builderState.style().setHasAutoColumnCount();
    }
    static void applyInheritColumnCount(BuilderState& builderState)
    {
        if (builderState.parentStyle().hasAutoColumnCount()) {
            builderState.style().setHasAutoColumnCount();
            return;
        }
        builderState.style().setColumnCount(forwardInheritedValue(builderState.parentStyle().columnCount()));
    }
    static void applyValueColumnCount(BuilderState& builderState, CSSValue& value)
    {
        if (value.valueID() == CSSValueAuto) {
            builderState.style().setHasAutoColumnCount();
            return;
        }
        builderState.style().setColumnCount(fromCSSValueDeducingType(value));
    }
    static void applyInitialColumnFill(BuilderState& builderState)
    {
        builderState.style().setColumnFill(RenderStyle::initialColumnFill());
    }
    static void applyInheritColumnFill(BuilderState& builderState)
    {
        builderState.style().setColumnFill(forwardInheritedValue(builderState.parentStyle().columnFill()));
    }
    static void applyValueColumnFill(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setColumnFill(fromCSSValueDeducingType(value));
    }
    static void applyInitialColumnGap(BuilderState& builderState)
    {
        builderState.style().setColumnGap(RenderStyle::initialColumnGap());
    }
    static void applyInheritColumnGap(BuilderState& builderState)
    {
        builderState.style().setColumnGap(forwardInheritedValue(builderState.parentStyle().columnGap()));
    }
    static void applyValueColumnGap(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setColumnGap(BuilderConverter::convertGapLength(builderState, value));
    }
    static void applyInitialColumnRuleColor(BuilderState& builderState)
    {
        if (builderState.applyPropertyToRegularStyle())
            builderState.style().setColumnRuleColor(StyleColor::currentColor());
        if (builderState.applyPropertyToVisitedLinkStyle())
            builderState.style().setVisitedLinkColumnRuleColor(StyleColor::currentColor());
    }
    static void applyInheritColumnRuleColor(BuilderState& builderState)
    {
        if (builderState.applyPropertyToRegularStyle())
            builderState.style().setColumnRuleColor(builderState.parentStyle().columnRuleColor());
        if (builderState.applyPropertyToVisitedLinkStyle())
            builderState.style().setVisitedLinkColumnRuleColor(builderState.parentStyle().columnRuleColor());
    }
    static void applyValueColumnRuleColor(BuilderState& builderState, CSSValue& value)
    {
        if (builderState.applyPropertyToRegularStyle())
            builderState.style().setColumnRuleColor(builderState.colorFromPrimitiveValue(fromCSSValueDeducingType(value), ForVisitedLink::No));
        if (builderState.applyPropertyToVisitedLinkStyle())
            builderState.style().setVisitedLinkColumnRuleColor(builderState.colorFromPrimitiveValue(fromCSSValueDeducingType(value), ForVisitedLink::Yes));
    }
    static void applyInitialColumnRuleStyle(BuilderState& builderState)
    {
        builderState.style().setColumnRuleStyle(RenderStyle::initialBorderStyle());
    }
    static void applyInheritColumnRuleStyle(BuilderState& builderState)
    {
        builderState.style().setColumnRuleStyle(forwardInheritedValue(builderState.parentStyle().columnRuleStyle()));
    }
    static void applyValueColumnRuleStyle(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setColumnRuleStyle(fromCSSValueDeducingType(value));
    }
    static void applyInitialColumnRuleWidth(BuilderState& builderState)
    {
        builderState.style().setColumnRuleWidth(RenderStyle::initialColumnRuleWidth());
    }
    static void applyInheritColumnRuleWidth(BuilderState& builderState)
    {
        builderState.style().setColumnRuleWidth(forwardInheritedValue(builderState.parentStyle().columnRuleWidth()));
    }
    static void applyValueColumnRuleWidth(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setColumnRuleWidth(BuilderConverter::convertLineWidth<unsigned short>(builderState, value));
    }
    static void applyInitialColumnSpan(BuilderState& builderState)
    {
        builderState.style().setColumnSpan(RenderStyle::initialColumnSpan());
    }
    static void applyInheritColumnSpan(BuilderState& builderState)
    {
        builderState.style().setColumnSpan(forwardInheritedValue(builderState.parentStyle().columnSpan()));
    }
    static void applyValueColumnSpan(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setColumnSpan(fromCSSValueDeducingType(value));
    }
    static void applyInitialColumnWidth(BuilderState& builderState)
    {
        builderState.style().setHasAutoColumnWidth();
    }
    static void applyInheritColumnWidth(BuilderState& builderState)
    {
        if (builderState.parentStyle().hasAutoColumnWidth()) {
            builderState.style().setHasAutoColumnWidth();
            return;
        }
        builderState.style().setColumnWidth(forwardInheritedValue(builderState.parentStyle().columnWidth()));
    }
    static void applyValueColumnWidth(BuilderState& builderState, CSSValue& value)
    {
        if (value.valueID() == CSSValueAuto) {
            builderState.style().setHasAutoColumnWidth();
            return;
        }
        builderState.style().setColumnWidth(BuilderConverter::convertComputedLength<float>(builderState, value));
    }
    static void applyInitialContain(BuilderState& builderState)
    {
        builderState.style().setContain(RenderStyle::initialContainment());
    }
    static void applyInheritContain(BuilderState& builderState)
    {
        builderState.style().setContain(forwardInheritedValue(builderState.parentStyle().contain()));
    }
    static void applyValueContain(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setContain(BuilderConverter::convertContain(builderState, value));
    }
    static void applyInitialContainerName(BuilderState& builderState)
    {
        builderState.style().setContainerNames(RenderStyle::initialContainerNames());
    }
    static void applyInheritContainerName(BuilderState& builderState)
    {
        builderState.style().setContainerNames(forwardInheritedValue(builderState.parentStyle().containerNames()));
    }
    static void applyValueContainerName(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setContainerNames(BuilderConverter::convertContainerName(builderState, value));
    }
    static void applyInitialContainerType(BuilderState& builderState)
    {
        builderState.style().setContainerType(RenderStyle::initialContainerType());
    }
    static void applyInheritContainerType(BuilderState& builderState)
    {
        builderState.style().setContainerType(forwardInheritedValue(builderState.parentStyle().containerType()));
    }
    static void applyValueContainerType(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setContainerType(fromCSSValueDeducingType(value));
    }
    static void applyInitialContentVisibility(BuilderState& builderState)
    {
        builderState.style().setContentVisibility(RenderStyle::initialContentVisibility());
    }
    static void applyInheritContentVisibility(BuilderState& builderState)
    {
        builderState.style().setContentVisibility(forwardInheritedValue(builderState.parentStyle().contentVisibility()));
    }
    static void applyValueContentVisibility(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setContentVisibility(fromCSSValueDeducingType(value));
    }
    static void applyInitialCx(BuilderState& builderState)
    {
        builderState.style().setCx(RenderStyle::zeroLength());
    }
    static void applyInheritCx(BuilderState& builderState)
    {
        builderState.style().setCx(forwardInheritedValue(builderState.parentStyle().cx()));
    }
    static void applyValueCx(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setCx(BuilderConverter::convertLength(builderState, value));
    }
    static void applyInitialCy(BuilderState& builderState)
    {
        builderState.style().setCy(RenderStyle::zeroLength());
    }
    static void applyInheritCy(BuilderState& builderState)
    {
        builderState.style().setCy(forwardInheritedValue(builderState.parentStyle().cy()));
    }
    static void applyValueCy(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setCy(BuilderConverter::convertLength(builderState, value));
    }
    static void applyInitialD(BuilderState& builderState)
    {
        builderState.style().setD(RenderStyle::initialD());
    }
    static void applyInheritD(BuilderState& builderState)
    {
        builderState.style().setD(forwardInheritedValue(builderState.parentStyle().d()));
    }
    static void applyValueD(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setD(BuilderConverter::convertSVGPath(builderState, value));
    }
    static void applyInitialDominantBaseline(BuilderState& builderState)
    {
        builderState.style().accessSVGStyle().setDominantBaseline(SVGRenderStyle::initialDominantBaseline());
    }
    static void applyInheritDominantBaseline(BuilderState& builderState)
    {
        builderState.style().accessSVGStyle().setDominantBaseline(forwardInheritedValue(builderState.parentStyle().svgStyle().dominantBaseline()));
    }
    static void applyValueDominantBaseline(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().accessSVGStyle().setDominantBaseline(fromCSSValueDeducingType(value));
    }
    static void applyInitialEmptyCells(BuilderState& builderState)
    {
        builderState.style().setEmptyCells(RenderStyle::initialEmptyCells());
    }
    static void applyInheritEmptyCells(BuilderState& builderState)
    {
        builderState.style().setEmptyCells(forwardInheritedValue(builderState.parentStyle().emptyCells()));
    }
    static void applyValueEmptyCells(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setEmptyCells(fromCSSValueDeducingType(value));
    }
    static void applyInitialFieldSizing(BuilderState& builderState)
    {
        builderState.style().setFieldSizing(RenderStyle::initialFieldSizing());
    }
    static void applyInheritFieldSizing(BuilderState& builderState)
    {
        builderState.style().setFieldSizing(forwardInheritedValue(builderState.parentStyle().fieldSizing()));
    }
    static void applyValueFieldSizing(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setFieldSizing(fromCSSValueDeducingType(value));
    }
    static void applyInitialFillOpacity(BuilderState& builderState)
    {
        builderState.style().accessSVGStyle().setFillOpacity(SVGRenderStyle::initialFillOpacity());
    }
    static void applyInheritFillOpacity(BuilderState& builderState)
    {
        builderState.style().accessSVGStyle().setFillOpacity(forwardInheritedValue(builderState.parentStyle().svgStyle().fillOpacity()));
    }
    static void applyValueFillOpacity(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().accessSVGStyle().setFillOpacity(BuilderConverter::convertOpacity(builderState, value));
    }
    static void applyInitialFillRule(BuilderState& builderState)
    {
        builderState.style().accessSVGStyle().setFillRule(SVGRenderStyle::initialFillRule());
    }
    static void applyInheritFillRule(BuilderState& builderState)
    {
        builderState.style().accessSVGStyle().setFillRule(forwardInheritedValue(builderState.parentStyle().svgStyle().fillRule()));
    }
    static void applyValueFillRule(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().accessSVGStyle().setFillRule(fromCSSValueDeducingType(value));
    }
    static void applyInitialFilter(BuilderState& builderState)
    {
        builderState.style().setFilter(RenderStyle::initialFilter());
    }
    static void applyInheritFilter(BuilderState& builderState)
    {
        builderState.style().setFilter(forwardInheritedValue(builderState.parentStyle().filter()));
    }
    static void applyValueFilter(BuilderState& builderState, CSSValue& value)
    {
        auto convertedValue = BuilderConverter::convertFilterOperations(builderState, value);
        if (convertedValue)
            builderState.style().setFilter(WTFMove(convertedValue.value()));
    }
    static void applyInitialFlexBasis(BuilderState& builderState)
    {
        builderState.style().setFlexBasis(RenderStyle::initialFlexBasis());
    }
    static void applyInheritFlexBasis(BuilderState& builderState)
    {
        builderState.style().setFlexBasis(forwardInheritedValue(builderState.parentStyle().flexBasis()));
    }
    static void applyValueFlexBasis(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setFlexBasis(BuilderConverter::convertLengthSizing(builderState, value));
    }
    static void applyInitialFlexDirection(BuilderState& builderState)
    {
        builderState.style().setFlexDirection(RenderStyle::initialFlexDirection());
    }
    static void applyInheritFlexDirection(BuilderState& builderState)
    {
        builderState.style().setFlexDirection(forwardInheritedValue(builderState.parentStyle().flexDirection()));
    }
    static void applyValueFlexDirection(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setFlexDirection(fromCSSValueDeducingType(value));
    }
    static void applyInitialFlexGrow(BuilderState& builderState)
    {
        builderState.style().setFlexGrow(RenderStyle::initialFlexGrow());
    }
    static void applyInheritFlexGrow(BuilderState& builderState)
    {
        builderState.style().setFlexGrow(forwardInheritedValue(builderState.parentStyle().flexGrow()));
    }
    static void applyValueFlexGrow(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setFlexGrow(fromCSSValueDeducingType(value));
    }
    static void applyInitialFlexShrink(BuilderState& builderState)
    {
        builderState.style().setFlexShrink(RenderStyle::initialFlexShrink());
    }
    static void applyInheritFlexShrink(BuilderState& builderState)
    {
        builderState.style().setFlexShrink(forwardInheritedValue(builderState.parentStyle().flexShrink()));
    }
    static void applyValueFlexShrink(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setFlexShrink(fromCSSValueDeducingType(value));
    }
    static void applyInitialFlexWrap(BuilderState& builderState)
    {
        builderState.style().setFlexWrap(RenderStyle::initialFlexWrap());
    }
    static void applyInheritFlexWrap(BuilderState& builderState)
    {
        builderState.style().setFlexWrap(forwardInheritedValue(builderState.parentStyle().flexWrap()));
    }
    static void applyValueFlexWrap(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setFlexWrap(fromCSSValueDeducingType(value));
    }
    static void applyInitialFloat(BuilderState& builderState)
    {
        builderState.style().setFloating(RenderStyle::initialFloating());
    }
    static void applyInheritFloat(BuilderState& builderState)
    {
        builderState.style().setFloating(forwardInheritedValue(builderState.parentStyle().floating()));
    }
    static void applyValueFloat(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setFloating(fromCSSValueDeducingType(value));
    }
    static void applyInitialFloodColor(BuilderState& builderState)
    {
        builderState.style().accessSVGStyle().setFloodColor(SVGRenderStyle::initialFloodColor());
    }
    static void applyInheritFloodColor(BuilderState& builderState)
    {
        builderState.style().accessSVGStyle().setFloodColor(forwardInheritedValue(builderState.parentStyle().svgStyle().floodColor()));
    }
    static void applyValueFloodColor(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().accessSVGStyle().setFloodColor(builderState.colorFromPrimitiveValue(downcast<CSSPrimitiveValue>(value), ForVisitedLink::No));
    }
    static void applyInitialFloodOpacity(BuilderState& builderState)
    {
        builderState.style().accessSVGStyle().setFloodOpacity(SVGRenderStyle::initialFloodOpacity());
    }
    static void applyInheritFloodOpacity(BuilderState& builderState)
    {
        builderState.style().accessSVGStyle().setFloodOpacity(forwardInheritedValue(builderState.parentStyle().svgStyle().floodOpacity()));
    }
    static void applyValueFloodOpacity(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().accessSVGStyle().setFloodOpacity(BuilderConverter::convertOpacity(builderState, value));
    }
    static void applyInitialGlyphOrientationHorizontal(BuilderState& builderState)
    {
        builderState.style().accessSVGStyle().setGlyphOrientationHorizontal(SVGRenderStyle::initialGlyphOrientationHorizontal());
    }
    static void applyInheritGlyphOrientationHorizontal(BuilderState& builderState)
    {
        builderState.style().accessSVGStyle().setGlyphOrientationHorizontal(forwardInheritedValue(builderState.parentStyle().svgStyle().glyphOrientationHorizontal()));
    }
    static void applyValueGlyphOrientationHorizontal(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().accessSVGStyle().setGlyphOrientationHorizontal(BuilderConverter::convertGlyphOrientation(builderState, value));
    }
    static void applyInitialGlyphOrientationVertical(BuilderState& builderState)
    {
        builderState.style().accessSVGStyle().setGlyphOrientationVertical(SVGRenderStyle::initialGlyphOrientationVertical());
    }
    static void applyInheritGlyphOrientationVertical(BuilderState& builderState)
    {
        builderState.style().accessSVGStyle().setGlyphOrientationVertical(forwardInheritedValue(builderState.parentStyle().svgStyle().glyphOrientationVertical()));
    }
    static void applyValueGlyphOrientationVertical(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().accessSVGStyle().setGlyphOrientationVertical(BuilderConverter::convertGlyphOrientationOrAuto(builderState, value));
    }
    static void applyInitialGridAutoColumns(BuilderState& builderState)
    {
        builderState.style().setGridAutoColumns(RenderStyle::initialGridAutoColumns());
    }
    static void applyInheritGridAutoColumns(BuilderState& builderState)
    {
        builderState.style().setGridAutoColumns(forwardInheritedValue(builderState.parentStyle().gridAutoColumns()));
    }
    static void applyValueGridAutoColumns(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setGridAutoColumns(BuilderConverter::convertGridTrackSizeList(builderState, value));
    }
    static void applyInitialGridAutoFlow(BuilderState& builderState)
    {
        builderState.style().setGridAutoFlow(RenderStyle::initialGridAutoFlow());
    }
    static void applyInheritGridAutoFlow(BuilderState& builderState)
    {
        builderState.style().setGridAutoFlow(forwardInheritedValue(builderState.parentStyle().gridAutoFlow()));
    }
    static void applyValueGridAutoFlow(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setGridAutoFlow(BuilderConverter::convertGridAutoFlow(builderState, value));
    }
    static void applyInitialGridAutoRows(BuilderState& builderState)
    {
        builderState.style().setGridAutoRows(RenderStyle::initialGridAutoRows());
    }
    static void applyInheritGridAutoRows(BuilderState& builderState)
    {
        builderState.style().setGridAutoRows(forwardInheritedValue(builderState.parentStyle().gridAutoRows()));
    }
    static void applyValueGridAutoRows(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setGridAutoRows(BuilderConverter::convertGridTrackSizeList(builderState, value));
    }
    static void applyInitialGridColumnEnd(BuilderState& builderState)
    {
        builderState.style().setGridItemColumnEnd(RenderStyle::initialGridItemColumnEnd());
    }
    static void applyInheritGridColumnEnd(BuilderState& builderState)
    {
        builderState.style().setGridItemColumnEnd(forwardInheritedValue(builderState.parentStyle().gridItemColumnEnd()));
    }
    static void applyValueGridColumnEnd(BuilderState& builderState, CSSValue& value)
    {
        auto convertedValue = BuilderConverter::convertGridPosition(builderState, value);
        if (convertedValue)
            builderState.style().setGridItemColumnEnd(WTFMove(convertedValue.value()));
    }
    static void applyInitialGridColumnStart(BuilderState& builderState)
    {
        builderState.style().setGridItemColumnStart(RenderStyle::initialGridItemColumnStart());
    }
    static void applyInheritGridColumnStart(BuilderState& builderState)
    {
        builderState.style().setGridItemColumnStart(forwardInheritedValue(builderState.parentStyle().gridItemColumnStart()));
    }
    static void applyValueGridColumnStart(BuilderState& builderState, CSSValue& value)
    {
        auto convertedValue = BuilderConverter::convertGridPosition(builderState, value);
        if (convertedValue)
            builderState.style().setGridItemColumnStart(WTFMove(convertedValue.value()));
    }
    static void applyInitialGridRowEnd(BuilderState& builderState)
    {
        builderState.style().setGridItemRowEnd(RenderStyle::initialGridItemRowEnd());
    }
    static void applyInheritGridRowEnd(BuilderState& builderState)
    {
        builderState.style().setGridItemRowEnd(forwardInheritedValue(builderState.parentStyle().gridItemRowEnd()));
    }
    static void applyValueGridRowEnd(BuilderState& builderState, CSSValue& value)
    {
        auto convertedValue = BuilderConverter::convertGridPosition(builderState, value);
        if (convertedValue)
            builderState.style().setGridItemRowEnd(WTFMove(convertedValue.value()));
    }
    static void applyInitialGridRowStart(BuilderState& builderState)
    {
        builderState.style().setGridItemRowStart(RenderStyle::initialGridItemRowStart());
    }
    static void applyInheritGridRowStart(BuilderState& builderState)
    {
        builderState.style().setGridItemRowStart(forwardInheritedValue(builderState.parentStyle().gridItemRowStart()));
    }
    static void applyValueGridRowStart(BuilderState& builderState, CSSValue& value)
    {
        auto convertedValue = BuilderConverter::convertGridPosition(builderState, value);
        if (convertedValue)
            builderState.style().setGridItemRowStart(WTFMove(convertedValue.value()));
    }
    static void applyInitialHangingPunctuation(BuilderState& builderState)
    {
        builderState.style().setHangingPunctuation(RenderStyle::initialHangingPunctuation());
    }
    static void applyInheritHangingPunctuation(BuilderState& builderState)
    {
        builderState.style().setHangingPunctuation(forwardInheritedValue(builderState.parentStyle().hangingPunctuation()));
    }
    static void applyValueHangingPunctuation(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setHangingPunctuation(BuilderConverter::convertHangingPunctuation(builderState, value));
    }
    static void applyInitialHyphenateCharacter(BuilderState& builderState)
    {
        builderState.style().setHyphenationString(RenderStyle::initialHyphenationString());
    }
    static void applyInheritHyphenateCharacter(BuilderState& builderState)
    {
        builderState.style().setHyphenationString(forwardInheritedValue(builderState.parentStyle().hyphenationString()));
    }
    static void applyValueHyphenateCharacter(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setHyphenationString(BuilderConverter::convertStringOrAutoAtom(builderState, value));
    }
    static void applyInitialHyphens(BuilderState& builderState)
    {
        builderState.style().setHyphens(RenderStyle::initialHyphens());
    }
    static void applyInheritHyphens(BuilderState& builderState)
    {
        builderState.style().setHyphens(forwardInheritedValue(builderState.parentStyle().hyphens()));
    }
    static void applyValueHyphens(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setHyphens(fromCSSValueDeducingType(value));
    }
    static void applyInitialImageOrientation(BuilderState& builderState)
    {
        builderState.style().setImageOrientation(RenderStyle::initialImageOrientation());
    }
    static void applyInheritImageOrientation(BuilderState& builderState)
    {
        builderState.style().setImageOrientation(forwardInheritedValue(builderState.parentStyle().imageOrientation()));
    }
    static void applyValueImageOrientation(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setImageOrientation(BuilderConverter::convertImageOrientation(builderState, value));
    }
    static void applyInitialImageRendering(BuilderState& builderState)
    {
        builderState.style().setImageRendering(RenderStyle::initialImageRendering());
    }
    static void applyInheritImageRendering(BuilderState& builderState)
    {
        builderState.style().setImageRendering(forwardInheritedValue(builderState.parentStyle().imageRendering()));
    }
    static void applyValueImageRendering(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setImageRendering(fromCSSValueDeducingType(value));
    }
    static void applyInitialInputSecurity(BuilderState& builderState)
    {
        builderState.style().setInputSecurity(RenderStyle::initialInputSecurity());
    }
    static void applyInheritInputSecurity(BuilderState& builderState)
    {
        builderState.style().setInputSecurity(forwardInheritedValue(builderState.parentStyle().inputSecurity()));
    }
    static void applyValueInputSecurity(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setInputSecurity(fromCSSValueDeducingType(value));
    }
    static void applyInitialIsolation(BuilderState& builderState)
    {
        builderState.style().setIsolation(RenderStyle::initialIsolation());
    }
    static void applyInheritIsolation(BuilderState& builderState)
    {
        builderState.style().setIsolation(forwardInheritedValue(builderState.parentStyle().isolation()));
    }
    static void applyValueIsolation(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setIsolation(fromCSSValueDeducingType(value));
    }
    static void applyInitialJustifyContent(BuilderState& builderState)
    {
        builderState.style().setJustifyContent(RenderStyle::initialContentAlignment());
    }
    static void applyInheritJustifyContent(BuilderState& builderState)
    {
        builderState.style().setJustifyContent(forwardInheritedValue(builderState.parentStyle().justifyContent()));
    }
    static void applyValueJustifyContent(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setJustifyContent(BuilderConverter::convertContentAlignmentData(builderState, value));
    }
    static void applyInitialJustifyItems(BuilderState& builderState)
    {
        builderState.style().setJustifyItems(RenderStyle::initialJustifyItems());
    }
    static void applyInheritJustifyItems(BuilderState& builderState)
    {
        builderState.style().setJustifyItems(forwardInheritedValue(builderState.parentStyle().justifyItems()));
    }
    static void applyValueJustifyItems(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setJustifyItems(BuilderConverter::convertSelfOrDefaultAlignmentData(builderState, value));
    }
    static void applyInitialJustifySelf(BuilderState& builderState)
    {
        builderState.style().setJustifySelf(RenderStyle::initialSelfAlignment());
    }
    static void applyInheritJustifySelf(BuilderState& builderState)
    {
        builderState.style().setJustifySelf(forwardInheritedValue(builderState.parentStyle().justifySelf()));
    }
    static void applyValueJustifySelf(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setJustifySelf(BuilderConverter::convertSelfOrDefaultAlignmentData(builderState, value));
    }
    static void applyInitialKerning(BuilderState& builderState)
    {
        builderState.style().accessSVGStyle().setKerning(SVGRenderStyle::initialKerning());
    }
    static void applyInheritKerning(BuilderState& builderState)
    {
        builderState.style().accessSVGStyle().setKerning(forwardInheritedValue(builderState.parentStyle().svgStyle().kerning()));
    }
    static void applyValueKerning(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().accessSVGStyle().setKerning(BuilderConverter::convertSVGLengthValue(builderState, value));
    }
    static void applyInitialLightingColor(BuilderState& builderState)
    {
        builderState.style().accessSVGStyle().setLightingColor(SVGRenderStyle::initialLightingColor());
    }
    static void applyInheritLightingColor(BuilderState& builderState)
    {
        builderState.style().accessSVGStyle().setLightingColor(forwardInheritedValue(builderState.parentStyle().svgStyle().lightingColor()));
    }
    static void applyValueLightingColor(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().accessSVGStyle().setLightingColor(builderState.colorFromPrimitiveValue(downcast<CSSPrimitiveValue>(value), ForVisitedLink::No));
    }
    static void applyInitialLineBreak(BuilderState& builderState)
    {
        builderState.style().setLineBreak(RenderStyle::initialLineBreak());
    }
    static void applyInheritLineBreak(BuilderState& builderState)
    {
        builderState.style().setLineBreak(forwardInheritedValue(builderState.parentStyle().lineBreak()));
    }
    static void applyValueLineBreak(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setLineBreak(fromCSSValueDeducingType(value));
    }
    static void applyInitialLineFitEdge(BuilderState& builderState)
    {
        builderState.style().setLineFitEdge(RenderStyle::initialLineFitEdge());
    }
    static void applyInheritLineFitEdge(BuilderState& builderState)
    {
        builderState.style().setLineFitEdge(forwardInheritedValue(builderState.parentStyle().lineFitEdge()));
    }
    static void applyValueLineFitEdge(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setLineFitEdge(BuilderConverter::convertTextEdge(builderState, value));
    }
    static void applyInitialLineHeight(BuilderState& builderState)
    {
        builderState.style().setLineHeight(RenderStyle::initialLineHeight());
    }
    static void applyInheritLineHeight(BuilderState& builderState)
    {
        builderState.style().setLineHeight(forwardInheritedValue(builderState.parentStyle().specifiedLineHeight()));
    }
    static void applyValueLineHeight(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setLineHeight(BuilderConverter::convertLineHeight(builderState, value));
    }
    static void applyInitialListStyleImage(BuilderState& builderState)
    {
        builderState.style().setListStyleImage(RenderStyle::initialListStyleImage());
    }
    static void applyInheritListStyleImage(BuilderState& builderState)
    {
        builderState.style().setListStyleImage(forwardInheritedValue(builderState.parentStyle().listStyleImage()));
    }
    static void applyValueListStyleImage(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setListStyleImage(BuilderConverter::convertStyleImage<CSSPropertyListStyleImage>(builderState, value));
    }
    static void applyInitialListStylePosition(BuilderState& builderState)
    {
        builderState.style().setListStylePosition(RenderStyle::initialListStylePosition());
    }
    static void applyInheritListStylePosition(BuilderState& builderState)
    {
        builderState.style().setListStylePosition(forwardInheritedValue(builderState.parentStyle().listStylePosition()));
    }
    static void applyValueListStylePosition(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setListStylePosition(fromCSSValueDeducingType(value));
    }
    static void applyInitialListStyleType(BuilderState& builderState)
    {
        builderState.style().setListStyleType(RenderStyle::initialListStyleType());
    }
    static void applyInheritListStyleType(BuilderState& builderState)
    {
        builderState.style().setListStyleType(forwardInheritedValue(builderState.parentStyle().listStyleType()));
    }
    static void applyValueListStyleType(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setListStyleType(BuilderConverter::convertListStyleType(builderState, value));
    }
    static void applyInitialMarginTrim(BuilderState& builderState)
    {
        builderState.style().setMarginTrim(RenderStyle::initialMarginTrim());
    }
    static void applyInheritMarginTrim(BuilderState& builderState)
    {
        builderState.style().setMarginTrim(forwardInheritedValue(builderState.parentStyle().marginTrim()));
    }
    static void applyValueMarginTrim(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setMarginTrim(BuilderConverter::convertMarginTrim(builderState, value));
    }
    static void applyInitialMarkerEnd(BuilderState& builderState)
    {
        builderState.style().accessSVGStyle().setMarkerEndResource(SVGRenderStyle::initialMarkerEndResource());
    }
    static void applyInheritMarkerEnd(BuilderState& builderState)
    {
        builderState.style().accessSVGStyle().setMarkerEndResource(forwardInheritedValue(builderState.parentStyle().svgStyle().markerEndResource()));
    }
    static void applyValueMarkerEnd(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().accessSVGStyle().setMarkerEndResource(BuilderConverter::convertSVGURIReference(builderState, value));
    }
    static void applyInitialMarkerMid(BuilderState& builderState)
    {
        builderState.style().accessSVGStyle().setMarkerMidResource(SVGRenderStyle::initialMarkerMidResource());
    }
    static void applyInheritMarkerMid(BuilderState& builderState)
    {
        builderState.style().accessSVGStyle().setMarkerMidResource(forwardInheritedValue(builderState.parentStyle().svgStyle().markerMidResource()));
    }
    static void applyValueMarkerMid(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().accessSVGStyle().setMarkerMidResource(BuilderConverter::convertSVGURIReference(builderState, value));
    }
    static void applyInitialMarkerStart(BuilderState& builderState)
    {
        builderState.style().accessSVGStyle().setMarkerStartResource(SVGRenderStyle::initialMarkerStartResource());
    }
    static void applyInheritMarkerStart(BuilderState& builderState)
    {
        builderState.style().accessSVGStyle().setMarkerStartResource(forwardInheritedValue(builderState.parentStyle().svgStyle().markerStartResource()));
    }
    static void applyValueMarkerStart(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().accessSVGStyle().setMarkerStartResource(BuilderConverter::convertSVGURIReference(builderState, value));
    }
    static void applyInitialMaskBorderSource(BuilderState& builderState)
    {
        builderState.style().setMaskBorderSource(RenderStyle::initialMaskBorderSource());
    }
    static void applyInheritMaskBorderSource(BuilderState& builderState)
    {
        builderState.style().setMaskBorderSource(forwardInheritedValue(builderState.parentStyle().maskBorderSource()));
    }
    static void applyValueMaskBorderSource(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setMaskBorderSource(BuilderConverter::convertStyleImage<CSSPropertyMaskBorderSource>(builderState, value));
    }
    static void applyInitialMaskClip(BuilderState& builderState)
    {
        // Check for (single-layer) no-op before clearing anything.
        auto& layers = builderState.style().maskLayers();
        if (!layers.next() && (!layers.isClipSet() || layers.clip() == FillLayer::initialFillClip(FillLayerType::Mask)))
            return;
        auto* child = &builderState.style().ensureMaskLayers();
        child->setClip(FillLayer::initialFillClip(FillLayerType::Mask));
        for (child = child->next(); child; child = child->next())
            child->clearClip();
    }
    static void applyInheritMaskClip(BuilderState& builderState)
    {
        // Check for no-op before copying anything.
        if (builderState.parentStyle().maskLayers() == builderState.style().maskLayers())
            return;
        auto* child = &builderState.style().ensureMaskLayers();
        FillLayer* previousChild = nullptr;
        for (auto* parent = &builderState.parentStyle().maskLayers(); parent && parent->isClipSet(); parent = parent->next()) {
            if (!child) {
                previousChild->setNext(FillLayer::create(FillLayerType::Mask));
                child = previousChild->next();
            }
            child->setClip(parent->clip());
            previousChild = child;
            child = previousChild->next();
        }
        for (; child; child = child->next())
            child->clearClip();
    }
    static void applyValueMaskClip(CSSPropertyID id, BuilderState& builderState, CSSValue& value)
    {
        auto* child = &builderState.style().ensureMaskLayers();
        FillLayer* previousChild = nullptr;
        if (auto* valueList = dynamicDowncast<CSSValueList>(value)) {
            // Walk each value and put it into a layer, creating new layers as needed.
            for (auto& item : *valueList) {
                if (!child) {
                    previousChild->setNext(FillLayer::create(FillLayerType::Mask));
                    child = previousChild->next();
                }
                builderState.styleMap().mapFillClip(id, *child, item);
                previousChild = child;
                child = child->next();
            }
        } else {
            builderState.styleMap().mapFillClip(id, *child, value);
            child = child->next();
        }
        for (; child; child = child->next())
            child->clearClip();
    }
    static void applyInitialMaskComposite(BuilderState& builderState)
    {
        // Check for (single-layer) no-op before clearing anything.
        auto& layers = builderState.style().maskLayers();
        if (!layers.next() && (!layers.isCompositeSet() || layers.composite() == FillLayer::initialFillComposite(FillLayerType::Mask)))
            return;
        auto* child = &builderState.style().ensureMaskLayers();
        child->setComposite(FillLayer::initialFillComposite(FillLayerType::Mask));
        for (child = child->next(); child; child = child->next())
            child->clearComposite();
    }
    static void applyInheritMaskComposite(BuilderState& builderState)
    {
        // Check for no-op before copying anything.
        if (builderState.parentStyle().maskLayers() == builderState.style().maskLayers())
            return;
        auto* child = &builderState.style().ensureMaskLayers();
        FillLayer* previousChild = nullptr;
        for (auto* parent = &builderState.parentStyle().maskLayers(); parent && parent->isCompositeSet(); parent = parent->next()) {
            if (!child) {
                previousChild->setNext(FillLayer::create(FillLayerType::Mask));
                child = previousChild->next();
            }
            child->setComposite(parent->composite());
            previousChild = child;
            child = previousChild->next();
        }
        for (; child; child = child->next())
            child->clearComposite();
    }
    static void applyValueMaskComposite(CSSPropertyID id, BuilderState& builderState, CSSValue& value)
    {
        auto* child = &builderState.style().ensureMaskLayers();
        FillLayer* previousChild = nullptr;
        if (auto* valueList = dynamicDowncast<CSSValueList>(value)) {
            // Walk each value and put it into a layer, creating new layers as needed.
            for (auto& item : *valueList) {
                if (!child) {
                    previousChild->setNext(FillLayer::create(FillLayerType::Mask));
                    child = previousChild->next();
                }
                builderState.styleMap().mapFillComposite(id, *child, item);
                previousChild = child;
                child = child->next();
            }
        } else {
            builderState.styleMap().mapFillComposite(id, *child, value);
            child = child->next();
        }
        for (; child; child = child->next())
            child->clearComposite();
    }
    static void applyInitialMaskImage(BuilderState& builderState)
    {
        // Check for (single-layer) no-op before clearing anything.
        auto& layers = builderState.style().maskLayers();
        if (!layers.next() && (!layers.isImageSet() || layers.image() == FillLayer::initialFillImage(FillLayerType::Mask)))
            return;
        auto* child = &builderState.style().ensureMaskLayers();
        child->setImage(FillLayer::initialFillImage(FillLayerType::Mask));
        for (child = child->next(); child; child = child->next())
            child->clearImage();
    }
    static void applyInheritMaskImage(BuilderState& builderState)
    {
        // Check for no-op before copying anything.
        if (builderState.parentStyle().maskLayers() == builderState.style().maskLayers())
            return;
        auto* child = &builderState.style().ensureMaskLayers();
        FillLayer* previousChild = nullptr;
        for (auto* parent = &builderState.parentStyle().maskLayers(); parent && parent->isImageSet(); parent = parent->next()) {
            if (!child) {
                previousChild->setNext(FillLayer::create(FillLayerType::Mask));
                child = previousChild->next();
            }
            child->setImage(parent->image());
            previousChild = child;
            child = previousChild->next();
        }
        for (; child; child = child->next())
            child->clearImage();
    }
    static void applyValueMaskImage(CSSPropertyID id, BuilderState& builderState, CSSValue& value)
    {
        auto* child = &builderState.style().ensureMaskLayers();
        FillLayer* previousChild = nullptr;
        if (auto* valueList = dynamicDowncast<CSSValueList>(value)) {
            // Walk each value and put it into a layer, creating new layers as needed.
            for (auto& item : *valueList) {
                if (!child) {
                    previousChild->setNext(FillLayer::create(FillLayerType::Mask));
                    child = previousChild->next();
                }
                builderState.styleMap().mapFillImage(id, *child, item);
                previousChild = child;
                child = child->next();
            }
        } else {
            builderState.styleMap().mapFillImage(id, *child, value);
            child = child->next();
        }
        for (; child; child = child->next())
            child->clearImage();
    }
    static void applyInitialMaskMode(BuilderState& builderState)
    {
        // Check for (single-layer) no-op before clearing anything.
        auto& layers = builderState.style().maskLayers();
        if (!layers.next() && (!layers.isMaskModeSet() || layers.maskMode() == FillLayer::initialFillMaskMode(FillLayerType::Mask)))
            return;
        auto* child = &builderState.style().ensureMaskLayers();
        child->setMaskMode(FillLayer::initialFillMaskMode(FillLayerType::Mask));
        for (child = child->next(); child; child = child->next())
            child->clearMaskMode();
    }
    static void applyInheritMaskMode(BuilderState& builderState)
    {
        // Check for no-op before copying anything.
        if (builderState.parentStyle().maskLayers() == builderState.style().maskLayers())
            return;
        auto* child = &builderState.style().ensureMaskLayers();
        FillLayer* previousChild = nullptr;
        for (auto* parent = &builderState.parentStyle().maskLayers(); parent && parent->isMaskModeSet(); parent = parent->next()) {
            if (!child) {
                previousChild->setNext(FillLayer::create(FillLayerType::Mask));
                child = previousChild->next();
            }
            child->setMaskMode(parent->maskMode());
            previousChild = child;
            child = previousChild->next();
        }
        for (; child; child = child->next())
            child->clearMaskMode();
    }
    static void applyValueMaskMode(CSSPropertyID id, BuilderState& builderState, CSSValue& value)
    {
        auto* child = &builderState.style().ensureMaskLayers();
        FillLayer* previousChild = nullptr;
        if (auto* valueList = dynamicDowncast<CSSValueList>(value)) {
            // Walk each value and put it into a layer, creating new layers as needed.
            for (auto& item : *valueList) {
                if (!child) {
                    previousChild->setNext(FillLayer::create(FillLayerType::Mask));
                    child = previousChild->next();
                }
                builderState.styleMap().mapFillMaskMode(id, *child, item);
                previousChild = child;
                child = child->next();
            }
        } else {
            builderState.styleMap().mapFillMaskMode(id, *child, value);
            child = child->next();
        }
        for (; child; child = child->next())
            child->clearMaskMode();
    }
    static void applyInitialMaskOrigin(BuilderState& builderState)
    {
        // Check for (single-layer) no-op before clearing anything.
        auto& layers = builderState.style().maskLayers();
        if (!layers.next() && (!layers.isOriginSet() || layers.origin() == FillLayer::initialFillOrigin(FillLayerType::Mask)))
            return;
        auto* child = &builderState.style().ensureMaskLayers();
        child->setOrigin(FillLayer::initialFillOrigin(FillLayerType::Mask));
        for (child = child->next(); child; child = child->next())
            child->clearOrigin();
    }
    static void applyInheritMaskOrigin(BuilderState& builderState)
    {
        // Check for no-op before copying anything.
        if (builderState.parentStyle().maskLayers() == builderState.style().maskLayers())
            return;
        auto* child = &builderState.style().ensureMaskLayers();
        FillLayer* previousChild = nullptr;
        for (auto* parent = &builderState.parentStyle().maskLayers(); parent && parent->isOriginSet(); parent = parent->next()) {
            if (!child) {
                previousChild->setNext(FillLayer::create(FillLayerType::Mask));
                child = previousChild->next();
            }
            child->setOrigin(parent->origin());
            previousChild = child;
            child = previousChild->next();
        }
        for (; child; child = child->next())
            child->clearOrigin();
    }
    static void applyValueMaskOrigin(CSSPropertyID id, BuilderState& builderState, CSSValue& value)
    {
        auto* child = &builderState.style().ensureMaskLayers();
        FillLayer* previousChild = nullptr;
        if (auto* valueList = dynamicDowncast<CSSValueList>(value)) {
            // Walk each value and put it into a layer, creating new layers as needed.
            for (auto& item : *valueList) {
                if (!child) {
                    previousChild->setNext(FillLayer::create(FillLayerType::Mask));
                    child = previousChild->next();
                }
                builderState.styleMap().mapFillOrigin(id, *child, item);
                previousChild = child;
                child = child->next();
            }
        } else {
            builderState.styleMap().mapFillOrigin(id, *child, value);
            child = child->next();
        }
        for (; child; child = child->next())
            child->clearOrigin();
    }
    static void applyInitialMaskRepeat(BuilderState& builderState)
    {
        // Check for (single-layer) no-op before clearing anything.
        auto& layers = builderState.style().maskLayers();
        if (!layers.next() && (!layers.isRepeatSet() || layers.repeat() == FillLayer::initialFillRepeat(FillLayerType::Mask)))
            return;
        auto* child = &builderState.style().ensureMaskLayers();
        child->setRepeat(FillLayer::initialFillRepeat(FillLayerType::Mask));
        for (child = child->next(); child; child = child->next())
            child->clearRepeat();
    }
    static void applyInheritMaskRepeat(BuilderState& builderState)
    {
        // Check for no-op before copying anything.
        if (builderState.parentStyle().maskLayers() == builderState.style().maskLayers())
            return;
        auto* child = &builderState.style().ensureMaskLayers();
        FillLayer* previousChild = nullptr;
        for (auto* parent = &builderState.parentStyle().maskLayers(); parent && parent->isRepeatSet(); parent = parent->next()) {
            if (!child) {
                previousChild->setNext(FillLayer::create(FillLayerType::Mask));
                child = previousChild->next();
            }
            child->setRepeat(parent->repeat());
            previousChild = child;
            child = previousChild->next();
        }
        for (; child; child = child->next())
            child->clearRepeat();
    }
    static void applyValueMaskRepeat(CSSPropertyID id, BuilderState& builderState, CSSValue& value)
    {
        auto* child = &builderState.style().ensureMaskLayers();
        FillLayer* previousChild = nullptr;
        if (auto* valueList = dynamicDowncast<CSSValueList>(value)) {
            // Walk each value and put it into a layer, creating new layers as needed.
            for (auto& item : *valueList) {
                if (!child) {
                    previousChild->setNext(FillLayer::create(FillLayerType::Mask));
                    child = previousChild->next();
                }
                builderState.styleMap().mapFillRepeat(id, *child, item);
                previousChild = child;
                child = child->next();
            }
        } else {
            builderState.styleMap().mapFillRepeat(id, *child, value);
            child = child->next();
        }
        for (; child; child = child->next())
            child->clearRepeat();
    }
    static void applyInitialMaskSize(BuilderState& builderState)
    {
        // Check for (single-layer) no-op before clearing anything.
        auto& layers = builderState.style().maskLayers();
        if (!layers.next() && (!layers.isSizeSet() || layers.size() == FillLayer::initialFillSize(FillLayerType::Mask)))
            return;
        auto* child = &builderState.style().ensureMaskLayers();
        child->setSize(FillLayer::initialFillSize(FillLayerType::Mask));
        for (child = child->next(); child; child = child->next())
            child->clearSize();
    }
    static void applyInheritMaskSize(BuilderState& builderState)
    {
        // Check for no-op before copying anything.
        if (builderState.parentStyle().maskLayers() == builderState.style().maskLayers())
            return;
        auto* child = &builderState.style().ensureMaskLayers();
        FillLayer* previousChild = nullptr;
        for (auto* parent = &builderState.parentStyle().maskLayers(); parent && parent->isSizeSet(); parent = parent->next()) {
            if (!child) {
                previousChild->setNext(FillLayer::create(FillLayerType::Mask));
                child = previousChild->next();
            }
            child->setSize(parent->size());
            previousChild = child;
            child = previousChild->next();
        }
        for (; child; child = child->next())
            child->clearSize();
    }
    static void applyValueMaskSize(CSSPropertyID id, BuilderState& builderState, CSSValue& value)
    {
        auto* child = &builderState.style().ensureMaskLayers();
        FillLayer* previousChild = nullptr;
        if (auto* valueList = dynamicDowncast<CSSValueList>(value)) {
            // Walk each value and put it into a layer, creating new layers as needed.
            for (auto& item : *valueList) {
                if (!child) {
                    previousChild->setNext(FillLayer::create(FillLayerType::Mask));
                    child = previousChild->next();
                }
                builderState.styleMap().mapFillSize(id, *child, item);
                previousChild = child;
                child = child->next();
            }
        } else {
            builderState.styleMap().mapFillSize(id, *child, value);
            child = child->next();
        }
        for (; child; child = child->next())
            child->clearSize();
    }
    static void applyInitialMaskType(BuilderState& builderState)
    {
        builderState.style().accessSVGStyle().setMaskType(SVGRenderStyle::initialMaskType());
    }
    static void applyInheritMaskType(BuilderState& builderState)
    {
        builderState.style().accessSVGStyle().setMaskType(forwardInheritedValue(builderState.parentStyle().svgStyle().maskType()));
    }
    static void applyValueMaskType(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().accessSVGStyle().setMaskType(fromCSSValueDeducingType(value));
    }
    static void applyInitialMasonryAutoFlow(BuilderState& builderState)
    {
        builderState.style().setMasonryAutoFlow(RenderStyle::initialMasonryAutoFlow());
    }
    static void applyInheritMasonryAutoFlow(BuilderState& builderState)
    {
        builderState.style().setMasonryAutoFlow(forwardInheritedValue(builderState.parentStyle().masonryAutoFlow()));
    }
    static void applyValueMasonryAutoFlow(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setMasonryAutoFlow(BuilderConverter::convertMasonryAutoFlow(builderState, value));
    }
    static void applyInitialMathStyle(BuilderState& builderState)
    {
        builderState.style().setMathStyle(RenderStyle::initialMathStyle());
    }
    static void applyInheritMathStyle(BuilderState& builderState)
    {
        builderState.style().setMathStyle(forwardInheritedValue(builderState.parentStyle().mathStyle()));
    }
    static void applyValueMathStyle(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setMathStyle(fromCSSValueDeducingType(value));
    }
    static void applyInitialMixBlendMode(BuilderState& builderState)
    {
        builderState.style().setBlendMode(RenderStyle::initialBlendMode());
    }
    static void applyInheritMixBlendMode(BuilderState& builderState)
    {
        builderState.style().setBlendMode(forwardInheritedValue(builderState.parentStyle().blendMode()));
    }
    static void applyValueMixBlendMode(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setBlendMode(fromCSSValueDeducingType(value));
    }
    static void applyInitialObjectFit(BuilderState& builderState)
    {
        builderState.style().setObjectFit(RenderStyle::initialObjectFit());
    }
    static void applyInheritObjectFit(BuilderState& builderState)
    {
        builderState.style().setObjectFit(forwardInheritedValue(builderState.parentStyle().objectFit()));
    }
    static void applyValueObjectFit(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setObjectFit(fromCSSValueDeducingType(value));
    }
    static void applyInitialObjectPosition(BuilderState& builderState)
    {
        builderState.style().setObjectPosition(RenderStyle::initialObjectPosition());
    }
    static void applyInheritObjectPosition(BuilderState& builderState)
    {
        builderState.style().setObjectPosition(forwardInheritedValue(builderState.parentStyle().objectPosition()));
    }
    static void applyValueObjectPosition(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setObjectPosition(BuilderConverter::convertPosition(builderState, value));
    }
    static void applyInitialOffsetAnchor(BuilderState& builderState)
    {
        builderState.style().setOffsetAnchor(RenderStyle::initialOffsetAnchor());
    }
    static void applyInheritOffsetAnchor(BuilderState& builderState)
    {
        builderState.style().setOffsetAnchor(forwardInheritedValue(builderState.parentStyle().offsetAnchor()));
    }
    static void applyValueOffsetAnchor(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setOffsetAnchor(BuilderConverter::convertPositionOrAuto(builderState, value));
    }
    static void applyInitialOffsetDistance(BuilderState& builderState)
    {
        builderState.style().setOffsetDistance(RenderStyle::initialOffsetDistance());
    }
    static void applyInheritOffsetDistance(BuilderState& builderState)
    {
        builderState.style().setOffsetDistance(forwardInheritedValue(builderState.parentStyle().offsetDistance()));
    }
    static void applyValueOffsetDistance(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setOffsetDistance(BuilderConverter::convertLength(builderState, value));
    }
    static void applyInitialOffsetPath(BuilderState& builderState)
    {
        builderState.style().setOffsetPath(RenderStyle::initialOffsetPath());
    }
    static void applyInheritOffsetPath(BuilderState& builderState)
    {
        builderState.style().setOffsetPath(forwardInheritedValue(builderState.parentStyle().offsetPath()));
    }
    static void applyValueOffsetPath(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setOffsetPath(BuilderConverter::convertPathOperation(builderState, value));
    }
    static void applyInitialOffsetPosition(BuilderState& builderState)
    {
        builderState.style().setOffsetPosition(RenderStyle::initialOffsetPosition());
    }
    static void applyInheritOffsetPosition(BuilderState& builderState)
    {
        builderState.style().setOffsetPosition(forwardInheritedValue(builderState.parentStyle().offsetPosition()));
    }
    static void applyValueOffsetPosition(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setOffsetPosition(BuilderConverter::convertPositionOrAutoOrNormal(builderState, value));
    }
    static void applyInitialOffsetRotate(BuilderState& builderState)
    {
        builderState.style().setOffsetRotate(RenderStyle::initialOffsetRotate());
    }
    static void applyInheritOffsetRotate(BuilderState& builderState)
    {
        builderState.style().setOffsetRotate(forwardInheritedValue(builderState.parentStyle().offsetRotate()));
    }
    static void applyValueOffsetRotate(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setOffsetRotate(BuilderConverter::convertOffsetRotate(builderState, value));
    }
    static void applyInitialOpacity(BuilderState& builderState)
    {
        builderState.style().setOpacity(RenderStyle::initialOpacity());
    }
    static void applyInheritOpacity(BuilderState& builderState)
    {
        builderState.style().setOpacity(forwardInheritedValue(builderState.parentStyle().opacity()));
    }
    static void applyValueOpacity(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setOpacity(BuilderConverter::convertOpacity(builderState, value));
    }
    static void applyInitialOrder(BuilderState& builderState)
    {
        builderState.style().setOrder(RenderStyle::initialOrder());
    }
    static void applyInheritOrder(BuilderState& builderState)
    {
        builderState.style().setOrder(forwardInheritedValue(builderState.parentStyle().order()));
    }
    static void applyValueOrder(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setOrder(fromCSSValueDeducingType(value));
    }
    static void applyInitialOrphans(BuilderState& builderState)
    {
        builderState.style().setHasAutoOrphans();
    }
    static void applyInheritOrphans(BuilderState& builderState)
    {
        if (builderState.parentStyle().hasAutoOrphans()) {
            builderState.style().setHasAutoOrphans();
            return;
        }
        builderState.style().setOrphans(forwardInheritedValue(builderState.parentStyle().orphans()));
    }
    static void applyValueOrphans(BuilderState& builderState, CSSValue& value)
    {
        if (value.valueID() == CSSValueAuto) {
            builderState.style().setHasAutoOrphans();
            return;
        }
        builderState.style().setOrphans(fromCSSValueDeducingType(value));
    }
    static void applyInitialOutlineColor(BuilderState& builderState)
    {
        if (builderState.applyPropertyToRegularStyle())
            builderState.style().setOutlineColor(StyleColor::currentColor());
        if (builderState.applyPropertyToVisitedLinkStyle())
            builderState.style().setVisitedLinkOutlineColor(StyleColor::currentColor());
    }
    static void applyInheritOutlineColor(BuilderState& builderState)
    {
        if (builderState.applyPropertyToRegularStyle())
            builderState.style().setOutlineColor(builderState.parentStyle().outlineColor());
        if (builderState.applyPropertyToVisitedLinkStyle())
            builderState.style().setVisitedLinkOutlineColor(builderState.parentStyle().outlineColor());
    }
    static void applyValueOutlineColor(BuilderState& builderState, CSSValue& value)
    {
        if (builderState.applyPropertyToRegularStyle())
            builderState.style().setOutlineColor(builderState.colorFromPrimitiveValue(fromCSSValueDeducingType(value), ForVisitedLink::No));
        if (builderState.applyPropertyToVisitedLinkStyle())
            builderState.style().setVisitedLinkOutlineColor(builderState.colorFromPrimitiveValue(fromCSSValueDeducingType(value), ForVisitedLink::Yes));
    }
    static void applyInitialOutlineOffset(BuilderState& builderState)
    {
        builderState.style().setOutlineOffset(RenderStyle::initialOutlineOffset());
    }
    static void applyInheritOutlineOffset(BuilderState& builderState)
    {
        builderState.style().setOutlineOffset(forwardInheritedValue(builderState.parentStyle().outlineOffset()));
    }
    static void applyValueOutlineOffset(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setOutlineOffset(BuilderConverter::convertComputedLength<float>(builderState, value));
    }
    static void applyInitialOutlineWidth(BuilderState& builderState)
    {
        builderState.style().setOutlineWidth(RenderStyle::initialOutlineWidth());
    }
    static void applyInheritOutlineWidth(BuilderState& builderState)
    {
        builderState.style().setOutlineWidth(forwardInheritedValue(builderState.parentStyle().outlineWidth()));
    }
    static void applyValueOutlineWidth(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setOutlineWidth(BuilderConverter::convertLineWidth<float>(builderState, value));
    }
    static void applyInitialOverflowAnchor(BuilderState& builderState)
    {
        builderState.style().setOverflowAnchor(RenderStyle::initialOverflowAnchor());
    }
    static void applyInheritOverflowAnchor(BuilderState& builderState)
    {
        builderState.style().setOverflowAnchor(forwardInheritedValue(builderState.parentStyle().overflowAnchor()));
    }
    static void applyValueOverflowAnchor(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setOverflowAnchor(fromCSSValueDeducingType(value));
    }
    static void applyInitialOverflowWrap(BuilderState& builderState)
    {
        builderState.style().setOverflowWrap(RenderStyle::initialOverflowWrap());
    }
    static void applyInheritOverflowWrap(BuilderState& builderState)
    {
        builderState.style().setOverflowWrap(forwardInheritedValue(builderState.parentStyle().overflowWrap()));
    }
    static void applyValueOverflowWrap(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setOverflowWrap(fromCSSValueDeducingType(value));
    }
    static void applyInitialOverflowX(BuilderState& builderState)
    {
        builderState.style().setOverflowX(RenderStyle::initialOverflowX());
    }
    static void applyInheritOverflowX(BuilderState& builderState)
    {
        builderState.style().setOverflowX(forwardInheritedValue(builderState.parentStyle().overflowX()));
    }
    static void applyValueOverflowX(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setOverflowX(fromCSSValueDeducingType(value));
    }
    static void applyInitialOverflowY(BuilderState& builderState)
    {
        builderState.style().setOverflowY(RenderStyle::initialOverflowY());
    }
    static void applyInheritOverflowY(BuilderState& builderState)
    {
        builderState.style().setOverflowY(forwardInheritedValue(builderState.parentStyle().overflowY()));
    }
    static void applyValueOverflowY(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setOverflowY(fromCSSValueDeducingType(value));
    }
    static void applyInitialPaintOrder(BuilderState& builderState)
    {
        builderState.style().setPaintOrder(RenderStyle::initialPaintOrder());
    }
    static void applyInheritPaintOrder(BuilderState& builderState)
    {
        builderState.style().setPaintOrder(forwardInheritedValue(builderState.parentStyle().paintOrder()));
    }
    static void applyValuePaintOrder(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setPaintOrder(BuilderConverter::convertPaintOrder(builderState, value));
    }
    static void applyInitialPerspective(BuilderState& builderState)
    {
        builderState.style().setPerspective(RenderStyle::initialPerspective());
    }
    static void applyInheritPerspective(BuilderState& builderState)
    {
        builderState.style().setPerspective(forwardInheritedValue(builderState.parentStyle().perspective()));
    }
    static void applyValuePerspective(BuilderState& builderState, CSSValue& value)
    {
        auto convertedValue = BuilderConverter::convertPerspective(builderState, value);
        if (convertedValue)
            builderState.style().setPerspective(WTFMove(convertedValue.value()));
    }
    static void applyInitialPerspectiveOriginX(BuilderState& builderState)
    {
        builderState.style().setPerspectiveOriginX(RenderStyle::initialPerspectiveOriginX());
    }
    static void applyInheritPerspectiveOriginX(BuilderState& builderState)
    {
        builderState.style().setPerspectiveOriginX(forwardInheritedValue(builderState.parentStyle().perspectiveOriginX()));
    }
    static void applyValuePerspectiveOriginX(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setPerspectiveOriginX(BuilderConverter::convertPositionComponentX(builderState, value));
    }
    static void applyInitialPerspectiveOriginY(BuilderState& builderState)
    {
        builderState.style().setPerspectiveOriginY(RenderStyle::initialPerspectiveOriginY());
    }
    static void applyInheritPerspectiveOriginY(BuilderState& builderState)
    {
        builderState.style().setPerspectiveOriginY(forwardInheritedValue(builderState.parentStyle().perspectiveOriginY()));
    }
    static void applyValuePerspectiveOriginY(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setPerspectiveOriginY(BuilderConverter::convertPositionComponentY(builderState, value));
    }
    static void applyInitialPointerEvents(BuilderState& builderState)
    {
        builderState.style().setPointerEvents(RenderStyle::initialPointerEvents());
    }
    static void applyInheritPointerEvents(BuilderState& builderState)
    {
        builderState.style().setPointerEvents(forwardInheritedValue(builderState.parentStyle().pointerEvents()));
    }
    static void applyValuePointerEvents(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setPointerEvents(fromCSSValueDeducingType(value));
    }
    static void applyInitialPosition(BuilderState& builderState)
    {
        builderState.style().setPosition(RenderStyle::initialPosition());
    }
    static void applyInheritPosition(BuilderState& builderState)
    {
        builderState.style().setPosition(forwardInheritedValue(builderState.parentStyle().position()));
    }
    static void applyValuePosition(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setPosition(fromCSSValueDeducingType(value));
    }
    static void applyInitialPositionAnchor(BuilderState& builderState)
    {
        builderState.style().setPositionAnchor(RenderStyle::initialPositionAnchor());
    }
    static void applyInheritPositionAnchor(BuilderState& builderState)
    {
        builderState.style().setPositionAnchor(forwardInheritedValue(builderState.parentStyle().positionAnchor()));
    }
    static void applyValuePositionAnchor(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setPositionAnchor(BuilderConverter::convertStringOrAutoAtom(builderState, value));
    }
    static void applyInitialPrintColorAdjust(BuilderState& builderState)
    {
        builderState.style().setPrintColorAdjust(RenderStyle::initialPrintColorAdjust());
    }
    static void applyInheritPrintColorAdjust(BuilderState& builderState)
    {
        builderState.style().setPrintColorAdjust(forwardInheritedValue(builderState.parentStyle().printColorAdjust()));
    }
    static void applyValuePrintColorAdjust(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setPrintColorAdjust(fromCSSValueDeducingType(value));
    }
    static void applyInitialQuotes(BuilderState& builderState)
    {
        builderState.style().setQuotes(RenderStyle::initialQuotes());
    }
    static void applyInheritQuotes(BuilderState& builderState)
    {
        builderState.style().setQuotes(forwardInheritedValue(builderState.parentStyle().quotes()));
    }
    static void applyValueQuotes(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setQuotes(BuilderConverter::convertQuotes(builderState, value));
    }
    static void applyInitialR(BuilderState& builderState)
    {
        builderState.style().setR(RenderStyle::zeroLength());
    }
    static void applyInheritR(BuilderState& builderState)
    {
        builderState.style().setR(forwardInheritedValue(builderState.parentStyle().r()));
    }
    static void applyValueR(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setR(BuilderConverter::convertLength(builderState, value));
    }
    static void applyInitialResize(BuilderState& builderState)
    {
        builderState.style().setResize(RenderStyle::initialResize());
    }
    static void applyInheritResize(BuilderState& builderState)
    {
        builderState.style().setResize(forwardInheritedValue(builderState.parentStyle().resize()));
    }
    static void applyValueResize(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setResize(BuilderConverter::convertResize(builderState, value));
    }
    static void applyInitialRotate(BuilderState& builderState)
    {
        builderState.style().setRotate(RenderStyle::initialRotate());
    }
    static void applyInheritRotate(BuilderState& builderState)
    {
        builderState.style().setRotate(forwardInheritedValue(builderState.parentStyle().rotate()));
    }
    static void applyValueRotate(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setRotate(BuilderConverter::convertRotate(builderState, value));
    }
    static void applyInitialRowGap(BuilderState& builderState)
    {
        builderState.style().setRowGap(RenderStyle::initialRowGap());
    }
    static void applyInheritRowGap(BuilderState& builderState)
    {
        builderState.style().setRowGap(forwardInheritedValue(builderState.parentStyle().rowGap()));
    }
    static void applyValueRowGap(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setRowGap(BuilderConverter::convertGapLength(builderState, value));
    }
    static void applyInitialRubyAlign(BuilderState& builderState)
    {
        builderState.style().setRubyAlign(RenderStyle::initialRubyAlign());
    }
    static void applyInheritRubyAlign(BuilderState& builderState)
    {
        builderState.style().setRubyAlign(forwardInheritedValue(builderState.parentStyle().rubyAlign()));
    }
    static void applyValueRubyAlign(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setRubyAlign(fromCSSValueDeducingType(value));
    }
    static void applyInitialRx(BuilderState& builderState)
    {
        builderState.style().setRx(RenderStyle::initialRadius());
    }
    static void applyInheritRx(BuilderState& builderState)
    {
        builderState.style().setRx(forwardInheritedValue(builderState.parentStyle().rx()));
    }
    static void applyValueRx(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setRx(BuilderConverter::convertLengthOrAuto(builderState, value));
    }
    static void applyInitialRy(BuilderState& builderState)
    {
        builderState.style().setRy(RenderStyle::initialRadius());
    }
    static void applyInheritRy(BuilderState& builderState)
    {
        builderState.style().setRy(forwardInheritedValue(builderState.parentStyle().ry()));
    }
    static void applyValueRy(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setRy(BuilderConverter::convertLengthOrAuto(builderState, value));
    }
    static void applyInitialScale(BuilderState& builderState)
    {
        builderState.style().setScale(RenderStyle::initialScale());
    }
    static void applyInheritScale(BuilderState& builderState)
    {
        builderState.style().setScale(forwardInheritedValue(builderState.parentStyle().scale()));
    }
    static void applyValueScale(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setScale(BuilderConverter::convertScale(builderState, value));
    }
    static void applyInitialScrollBehavior(BuilderState& builderState)
    {
        builderState.style().setUseSmoothScrolling(RenderStyle::initialUseSmoothScrolling());
    }
    static void applyInheritScrollBehavior(BuilderState& builderState)
    {
        builderState.style().setUseSmoothScrolling(forwardInheritedValue(builderState.parentStyle().useSmoothScrolling()));
    }
    static void applyValueScrollBehavior(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setUseSmoothScrolling(BuilderConverter::convertSmoothScrolling(builderState, value));
    }
    static void applyInitialScrollSnapAlign(BuilderState& builderState)
    {
        builderState.style().setScrollSnapAlign(RenderStyle::initialScrollSnapAlign());
    }
    static void applyInheritScrollSnapAlign(BuilderState& builderState)
    {
        builderState.style().setScrollSnapAlign(forwardInheritedValue(builderState.parentStyle().scrollSnapAlign()));
    }
    static void applyValueScrollSnapAlign(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setScrollSnapAlign(BuilderConverter::convertScrollSnapAlign(builderState, value));
    }
    static void applyInitialScrollSnapStop(BuilderState& builderState)
    {
        builderState.style().setScrollSnapStop(RenderStyle::initialScrollSnapStop());
    }
    static void applyInheritScrollSnapStop(BuilderState& builderState)
    {
        builderState.style().setScrollSnapStop(forwardInheritedValue(builderState.parentStyle().scrollSnapStop()));
    }
    static void applyValueScrollSnapStop(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setScrollSnapStop(BuilderConverter::convertScrollSnapStop(builderState, value));
    }
    static void applyInitialScrollSnapType(BuilderState& builderState)
    {
        builderState.style().setScrollSnapType(RenderStyle::initialScrollSnapType());
    }
    static void applyInheritScrollSnapType(BuilderState& builderState)
    {
        builderState.style().setScrollSnapType(forwardInheritedValue(builderState.parentStyle().scrollSnapType()));
    }
    static void applyValueScrollSnapType(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setScrollSnapType(BuilderConverter::convertScrollSnapType(builderState, value));
    }
    static void applyInitialScrollTimelineAxis(BuilderState& builderState)
    {
        builderState.style().setScrollTimelineAxes(RenderStyle::initialScrollTimelineAxes());
    }
    static void applyInheritScrollTimelineAxis(BuilderState& builderState)
    {
        builderState.style().setScrollTimelineAxes(forwardInheritedValue(builderState.parentStyle().scrollTimelineAxes()));
    }
    static void applyValueScrollTimelineAxis(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setScrollTimelineAxes(BuilderConverter::convertScrollTimelineAxis(builderState, value));
    }
    static void applyInitialScrollTimelineName(BuilderState& builderState)
    {
        builderState.style().setScrollTimelineNames(RenderStyle::initialScrollTimelineNames());
    }
    static void applyInheritScrollTimelineName(BuilderState& builderState)
    {
        builderState.style().setScrollTimelineNames(forwardInheritedValue(builderState.parentStyle().scrollTimelineNames()));
    }
    static void applyValueScrollTimelineName(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setScrollTimelineNames(BuilderConverter::convertScrollTimelineName(builderState, value));
    }
    static void applyInitialScrollbarColor(BuilderState& builderState)
    {
        builderState.style().setScrollbarColor(RenderStyle::initialScrollbarColor());
    }
    static void applyInheritScrollbarColor(BuilderState& builderState)
    {
        builderState.style().setScrollbarColor(forwardInheritedValue(builderState.parentStyle().scrollbarColor()));
    }
    static void applyValueScrollbarColor(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setScrollbarColor(BuilderConverter::convertScrollbarColor(builderState, value));
    }
    static void applyInitialScrollbarGutter(BuilderState& builderState)
    {
        builderState.style().setScrollbarGutter(RenderStyle::initialScrollbarGutter());
    }
    static void applyInheritScrollbarGutter(BuilderState& builderState)
    {
        builderState.style().setScrollbarGutter(forwardInheritedValue(builderState.parentStyle().scrollbarGutter()));
    }
    static void applyValueScrollbarGutter(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setScrollbarGutter(BuilderConverter::convertScrollbarGutter(builderState, value));
    }
    static void applyInitialScrollbarWidth(BuilderState& builderState)
    {
        builderState.style().setScrollbarWidth(RenderStyle::initialScrollbarWidth());
    }
    static void applyInheritScrollbarWidth(BuilderState& builderState)
    {
        builderState.style().setScrollbarWidth(forwardInheritedValue(builderState.parentStyle().scrollbarWidth()));
    }
    static void applyValueScrollbarWidth(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setScrollbarWidth(fromCSSValueDeducingType(value));
    }
    static void applyInitialShapeImageThreshold(BuilderState& builderState)
    {
        builderState.style().setShapeImageThreshold(RenderStyle::initialShapeImageThreshold());
    }
    static void applyInheritShapeImageThreshold(BuilderState& builderState)
    {
        builderState.style().setShapeImageThreshold(forwardInheritedValue(builderState.parentStyle().shapeImageThreshold()));
    }
    static void applyValueShapeImageThreshold(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setShapeImageThreshold(BuilderConverter::convertNumberOrAuto<float>(builderState, value));
    }
    static void applyInitialShapeMargin(BuilderState& builderState)
    {
        builderState.style().setShapeMargin(RenderStyle::initialShapeMargin());
    }
    static void applyInheritShapeMargin(BuilderState& builderState)
    {
        builderState.style().setShapeMargin(forwardInheritedValue(builderState.parentStyle().shapeMargin()));
    }
    static void applyValueShapeMargin(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setShapeMargin(BuilderConverter::convertLength(builderState, value));
    }
    static void applyInitialShapeOutside(BuilderState& builderState)
    {
        builderState.style().setShapeOutside(RenderStyle::initialShapeOutside());
    }
    static void applyInheritShapeOutside(BuilderState& builderState)
    {
        builderState.style().setShapeOutside(forwardInheritedValue(builderState.parentStyle().shapeOutside()));
    }
    static void applyValueShapeOutside(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setShapeOutside(BuilderConverter::convertShapeValue(builderState, value));
    }
    static void applyInitialShapeRendering(BuilderState& builderState)
    {
        builderState.style().accessSVGStyle().setShapeRendering(SVGRenderStyle::initialShapeRendering());
    }
    static void applyInheritShapeRendering(BuilderState& builderState)
    {
        builderState.style().accessSVGStyle().setShapeRendering(forwardInheritedValue(builderState.parentStyle().svgStyle().shapeRendering()));
    }
    static void applyValueShapeRendering(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().accessSVGStyle().setShapeRendering(fromCSSValueDeducingType(value));
    }
    static void applyInitialSpeakAs(BuilderState& builderState)
    {
        builderState.style().setSpeakAs(RenderStyle::initialSpeakAs());
    }
    static void applyInheritSpeakAs(BuilderState& builderState)
    {
        builderState.style().setSpeakAs(forwardInheritedValue(builderState.parentStyle().speakAs()));
    }
    static void applyValueSpeakAs(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setSpeakAs(BuilderConverter::convertSpeakAs(builderState, value));
    }
    static void applyInitialStopColor(BuilderState& builderState)
    {
        builderState.style().accessSVGStyle().setStopColor(SVGRenderStyle::initialStopColor());
    }
    static void applyInheritStopColor(BuilderState& builderState)
    {
        builderState.style().accessSVGStyle().setStopColor(forwardInheritedValue(builderState.parentStyle().svgStyle().stopColor()));
    }
    static void applyValueStopColor(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().accessSVGStyle().setStopColor(builderState.colorFromPrimitiveValue(downcast<CSSPrimitiveValue>(value), ForVisitedLink::No));
    }
    static void applyInitialStopOpacity(BuilderState& builderState)
    {
        builderState.style().accessSVGStyle().setStopOpacity(SVGRenderStyle::initialStopOpacity());
    }
    static void applyInheritStopOpacity(BuilderState& builderState)
    {
        builderState.style().accessSVGStyle().setStopOpacity(forwardInheritedValue(builderState.parentStyle().svgStyle().stopOpacity()));
    }
    static void applyValueStopOpacity(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().accessSVGStyle().setStopOpacity(BuilderConverter::convertOpacity(builderState, value));
    }
    static void applyInitialStrokeColor(BuilderState& builderState)
    {
        if (builderState.applyPropertyToRegularStyle())
            builderState.style().setStrokeColor(RenderStyle::initialStrokeColor());
        if (builderState.applyPropertyToVisitedLinkStyle())
            builderState.style().setVisitedLinkStrokeColor(RenderStyle::initialStrokeColor());
    }
    static void applyInheritStrokeColor(BuilderState& builderState)
    {
        if (builderState.applyPropertyToRegularStyle())
            builderState.style().setStrokeColor(builderState.parentStyle().strokeColor());
        if (builderState.applyPropertyToVisitedLinkStyle())
            builderState.style().setVisitedLinkStrokeColor(builderState.parentStyle().strokeColor());
    }
    static void applyInitialStrokeDasharray(BuilderState& builderState)
    {
        builderState.style().accessSVGStyle().setStrokeDashArray(SVGRenderStyle::initialStrokeDashArray());
    }
    static void applyInheritStrokeDasharray(BuilderState& builderState)
    {
        builderState.style().accessSVGStyle().setStrokeDashArray(forwardInheritedValue(builderState.parentStyle().svgStyle().strokeDashArray()));
    }
    static void applyValueStrokeDasharray(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().accessSVGStyle().setStrokeDashArray(BuilderConverter::convertStrokeDashArray(builderState, value));
    }
    static void applyInitialStrokeDashoffset(BuilderState& builderState)
    {
        builderState.style().setStrokeDashOffset(RenderStyle::zeroLength());
    }
    static void applyInheritStrokeDashoffset(BuilderState& builderState)
    {
        builderState.style().setStrokeDashOffset(forwardInheritedValue(builderState.parentStyle().strokeDashOffset()));
    }
    static void applyValueStrokeDashoffset(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setStrokeDashOffset(BuilderConverter::convertLengthAllowingNumber(builderState, value));
    }
    static void applyInitialStrokeLinecap(BuilderState& builderState)
    {
        builderState.style().setCapStyle(RenderStyle::initialCapStyle());
    }
    static void applyInheritStrokeLinecap(BuilderState& builderState)
    {
        builderState.style().setCapStyle(forwardInheritedValue(builderState.parentStyle().capStyle()));
    }
    static void applyValueStrokeLinecap(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setCapStyle(fromCSSValueDeducingType(value));
    }
    static void applyInitialStrokeLinejoin(BuilderState& builderState)
    {
        builderState.style().setJoinStyle(RenderStyle::initialJoinStyle());
    }
    static void applyInheritStrokeLinejoin(BuilderState& builderState)
    {
        builderState.style().setJoinStyle(forwardInheritedValue(builderState.parentStyle().joinStyle()));
    }
    static void applyValueStrokeLinejoin(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setJoinStyle(fromCSSValueDeducingType(value));
    }
    static void applyInitialStrokeMiterlimit(BuilderState& builderState)
    {
        builderState.style().setStrokeMiterLimit(RenderStyle::initialStrokeMiterLimit());
    }
    static void applyInheritStrokeMiterlimit(BuilderState& builderState)
    {
        builderState.style().setStrokeMiterLimit(forwardInheritedValue(builderState.parentStyle().strokeMiterLimit()));
    }
    static void applyValueStrokeMiterlimit(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setStrokeMiterLimit(BuilderConverter::convertNumber<float>(builderState, value));
    }
    static void applyInitialStrokeOpacity(BuilderState& builderState)
    {
        builderState.style().accessSVGStyle().setStrokeOpacity(SVGRenderStyle::initialStrokeOpacity());
    }
    static void applyInheritStrokeOpacity(BuilderState& builderState)
    {
        builderState.style().accessSVGStyle().setStrokeOpacity(forwardInheritedValue(builderState.parentStyle().svgStyle().strokeOpacity()));
    }
    static void applyValueStrokeOpacity(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().accessSVGStyle().setStrokeOpacity(BuilderConverter::convertOpacity(builderState, value));
    }
    static void applyInitialStrokeWidth(BuilderState& builderState)
    {
        builderState.style().setStrokeWidth(RenderStyle::oneLength());
    }
    static void applyInheritStrokeWidth(BuilderState& builderState)
    {
        builderState.style().setStrokeWidth(forwardInheritedValue(builderState.parentStyle().strokeWidth()));
    }
    static void applyInitialTabSize(BuilderState& builderState)
    {
        builderState.style().setTabSize(RenderStyle::initialTabSize());
    }
    static void applyInheritTabSize(BuilderState& builderState)
    {
        builderState.style().setTabSize(forwardInheritedValue(builderState.parentStyle().tabSize()));
    }
    static void applyValueTabSize(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setTabSize(BuilderConverter::convertTabSize(builderState, value));
    }
    static void applyInitialTableLayout(BuilderState& builderState)
    {
        builderState.style().setTableLayout(RenderStyle::initialTableLayout());
    }
    static void applyInheritTableLayout(BuilderState& builderState)
    {
        builderState.style().setTableLayout(forwardInheritedValue(builderState.parentStyle().tableLayout()));
    }
    static void applyValueTableLayout(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setTableLayout(fromCSSValueDeducingType(value));
    }
    static void applyInitialTextAlign(BuilderState& builderState)
    {
        builderState.style().setTextAlign(RenderStyle::initialTextAlign());
    }
    static void applyInheritTextAlign(BuilderState& builderState)
    {
        builderState.style().setTextAlign(forwardInheritedValue(builderState.parentStyle().textAlign()));
    }
    static void applyValueTextAlign(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setTextAlign(BuilderConverter::convertTextAlign(builderState, value));
    }
    static void applyInitialTextAlignLast(BuilderState& builderState)
    {
        builderState.style().setTextAlignLast(RenderStyle::initialTextAlignLast());
    }
    static void applyInheritTextAlignLast(BuilderState& builderState)
    {
        builderState.style().setTextAlignLast(forwardInheritedValue(builderState.parentStyle().textAlignLast()));
    }
    static void applyValueTextAlignLast(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setTextAlignLast(BuilderConverter::convertTextAlignLast(builderState, value));
    }
    static void applyInitialTextAnchor(BuilderState& builderState)
    {
        builderState.style().accessSVGStyle().setTextAnchor(SVGRenderStyle::initialTextAnchor());
    }
    static void applyInheritTextAnchor(BuilderState& builderState)
    {
        builderState.style().accessSVGStyle().setTextAnchor(forwardInheritedValue(builderState.parentStyle().svgStyle().textAnchor()));
    }
    static void applyValueTextAnchor(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().accessSVGStyle().setTextAnchor(fromCSSValueDeducingType(value));
    }
    static void applyInitialTextBoxEdge(BuilderState& builderState)
    {
        builderState.style().setTextBoxEdge(RenderStyle::initialTextBoxEdge());
    }
    static void applyInheritTextBoxEdge(BuilderState& builderState)
    {
        builderState.style().setTextBoxEdge(forwardInheritedValue(builderState.parentStyle().textBoxEdge()));
    }
    static void applyValueTextBoxEdge(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setTextBoxEdge(BuilderConverter::convertTextEdge(builderState, value));
    }
    static void applyInitialTextBoxTrim(BuilderState& builderState)
    {
        builderState.style().setTextBoxTrim(RenderStyle::initialTextBoxTrim());
    }
    static void applyInheritTextBoxTrim(BuilderState& builderState)
    {
        builderState.style().setTextBoxTrim(forwardInheritedValue(builderState.parentStyle().textBoxTrim()));
    }
    static void applyValueTextBoxTrim(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setTextBoxTrim(fromCSSValueDeducingType(value));
    }
    static void applyInitialTextCombineUpright(BuilderState& builderState)
    {
        builderState.style().setTextCombine(RenderStyle::initialTextCombine());
    }
    static void applyInheritTextCombineUpright(BuilderState& builderState)
    {
        builderState.style().setTextCombine(forwardInheritedValue(builderState.parentStyle().textCombine()));
    }
    static void applyValueTextCombineUpright(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setTextCombine(fromCSSValueDeducingType(value));
    }
    static void applyInitialTextDecorationColor(BuilderState& builderState)
    {
        if (builderState.applyPropertyToRegularStyle())
            builderState.style().setTextDecorationColor(StyleColor::currentColor());
        if (builderState.applyPropertyToVisitedLinkStyle())
            builderState.style().setVisitedLinkTextDecorationColor(StyleColor::currentColor());
    }
    static void applyInheritTextDecorationColor(BuilderState& builderState)
    {
        if (builderState.applyPropertyToRegularStyle())
            builderState.style().setTextDecorationColor(builderState.parentStyle().textDecorationColor());
        if (builderState.applyPropertyToVisitedLinkStyle())
            builderState.style().setVisitedLinkTextDecorationColor(builderState.parentStyle().textDecorationColor());
    }
    static void applyValueTextDecorationColor(BuilderState& builderState, CSSValue& value)
    {
        if (builderState.applyPropertyToRegularStyle())
            builderState.style().setTextDecorationColor(builderState.colorFromPrimitiveValue(fromCSSValueDeducingType(value), ForVisitedLink::No));
        if (builderState.applyPropertyToVisitedLinkStyle())
            builderState.style().setVisitedLinkTextDecorationColor(builderState.colorFromPrimitiveValue(fromCSSValueDeducingType(value), ForVisitedLink::Yes));
    }
    static void applyInitialTextDecorationLine(BuilderState& builderState)
    {
        builderState.style().setTextDecorationLine(RenderStyle::initialTextDecorationLine());
    }
    static void applyInheritTextDecorationLine(BuilderState& builderState)
    {
        builderState.style().setTextDecorationLine(forwardInheritedValue(builderState.parentStyle().textDecorationLine()));
    }
    static void applyValueTextDecorationLine(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setTextDecorationLine(BuilderConverter::convertTextDecorationLine(builderState, value));
    }
    static void applyInitialTextDecorationSkipInk(BuilderState& builderState)
    {
        builderState.style().setTextDecorationSkipInk(RenderStyle::initialTextDecorationSkipInk());
    }
    static void applyInheritTextDecorationSkipInk(BuilderState& builderState)
    {
        builderState.style().setTextDecorationSkipInk(forwardInheritedValue(builderState.parentStyle().textDecorationSkipInk()));
    }
    static void applyValueTextDecorationSkipInk(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setTextDecorationSkipInk(fromCSSValueDeducingType(value));
    }
    static void applyInitialTextDecorationStyle(BuilderState& builderState)
    {
        builderState.style().setTextDecorationStyle(RenderStyle::initialTextDecorationStyle());
    }
    static void applyInheritTextDecorationStyle(BuilderState& builderState)
    {
        builderState.style().setTextDecorationStyle(forwardInheritedValue(builderState.parentStyle().textDecorationStyle()));
    }
    static void applyValueTextDecorationStyle(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setTextDecorationStyle(fromCSSValueDeducingType(value));
    }
    static void applyInitialTextDecorationThickness(BuilderState& builderState)
    {
        builderState.style().setTextDecorationThickness(RenderStyle::initialTextDecorationThickness());
    }
    static void applyInheritTextDecorationThickness(BuilderState& builderState)
    {
        builderState.style().setTextDecorationThickness(forwardInheritedValue(builderState.parentStyle().textDecorationThickness()));
    }
    static void applyValueTextDecorationThickness(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setTextDecorationThickness(BuilderConverter::convertTextDecorationThickness(builderState, value));
    }
    static void applyInitialTextEmphasisColor(BuilderState& builderState)
    {
        if (builderState.applyPropertyToRegularStyle())
            builderState.style().setTextEmphasisColor(StyleColor::currentColor());
        if (builderState.applyPropertyToVisitedLinkStyle())
            builderState.style().setVisitedLinkTextEmphasisColor(StyleColor::currentColor());
    }
    static void applyInheritTextEmphasisColor(BuilderState& builderState)
    {
        if (builderState.applyPropertyToRegularStyle())
            builderState.style().setTextEmphasisColor(builderState.parentStyle().textEmphasisColor());
        if (builderState.applyPropertyToVisitedLinkStyle())
            builderState.style().setVisitedLinkTextEmphasisColor(builderState.parentStyle().textEmphasisColor());
    }
    static void applyValueTextEmphasisColor(BuilderState& builderState, CSSValue& value)
    {
        if (builderState.applyPropertyToRegularStyle())
            builderState.style().setTextEmphasisColor(builderState.colorFromPrimitiveValue(fromCSSValueDeducingType(value), ForVisitedLink::No));
        if (builderState.applyPropertyToVisitedLinkStyle())
            builderState.style().setVisitedLinkTextEmphasisColor(builderState.colorFromPrimitiveValue(fromCSSValueDeducingType(value), ForVisitedLink::Yes));
    }
    static void applyInitialTextEmphasisPosition(BuilderState& builderState)
    {
        builderState.style().setTextEmphasisPosition(RenderStyle::initialTextEmphasisPosition());
    }
    static void applyInheritTextEmphasisPosition(BuilderState& builderState)
    {
        builderState.style().setTextEmphasisPosition(forwardInheritedValue(builderState.parentStyle().textEmphasisPosition()));
    }
    static void applyValueTextEmphasisPosition(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setTextEmphasisPosition(BuilderConverter::convertTextEmphasisPosition(builderState, value));
    }
    static void applyInitialTextGroupAlign(BuilderState& builderState)
    {
        builderState.style().setTextGroupAlign(RenderStyle::initialTextGroupAlign());
    }
    static void applyInheritTextGroupAlign(BuilderState& builderState)
    {
        builderState.style().setTextGroupAlign(forwardInheritedValue(builderState.parentStyle().textGroupAlign()));
    }
    static void applyValueTextGroupAlign(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setTextGroupAlign(fromCSSValueDeducingType(value));
    }
    static void applyInitialTextJustify(BuilderState& builderState)
    {
        builderState.style().setTextJustify(RenderStyle::initialTextJustify());
    }
    static void applyInheritTextJustify(BuilderState& builderState)
    {
        builderState.style().setTextJustify(forwardInheritedValue(builderState.parentStyle().textJustify()));
    }
    static void applyValueTextJustify(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setTextJustify(fromCSSValueDeducingType(value));
    }
    static void applyInitialTextOverflow(BuilderState& builderState)
    {
        builderState.style().setTextOverflow(RenderStyle::initialTextOverflow());
    }
    static void applyInheritTextOverflow(BuilderState& builderState)
    {
        builderState.style().setTextOverflow(forwardInheritedValue(builderState.parentStyle().textOverflow()));
    }
    static void applyValueTextOverflow(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setTextOverflow(fromCSSValueDeducingType(value));
    }
    static void applyInitialTextTransform(BuilderState& builderState)
    {
        builderState.style().setTextTransform(RenderStyle::initialTextTransform());
    }
    static void applyInheritTextTransform(BuilderState& builderState)
    {
        builderState.style().setTextTransform(forwardInheritedValue(builderState.parentStyle().textTransform()));
    }
    static void applyValueTextTransform(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setTextTransform(BuilderConverter::convertTextTransform(builderState, value));
    }
    static void applyInitialTextUnderlineOffset(BuilderState& builderState)
    {
        builderState.style().setTextUnderlineOffset(RenderStyle::initialTextUnderlineOffset());
    }
    static void applyInheritTextUnderlineOffset(BuilderState& builderState)
    {
        builderState.style().setTextUnderlineOffset(forwardInheritedValue(builderState.parentStyle().textUnderlineOffset()));
    }
    static void applyValueTextUnderlineOffset(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setTextUnderlineOffset(BuilderConverter::convertTextUnderlineOffset(builderState, value));
    }
    static void applyInitialTextUnderlinePosition(BuilderState& builderState)
    {
        builderState.style().setTextUnderlinePosition(RenderStyle::initialTextUnderlinePosition());
    }
    static void applyInheritTextUnderlinePosition(BuilderState& builderState)
    {
        builderState.style().setTextUnderlinePosition(forwardInheritedValue(builderState.parentStyle().textUnderlinePosition()));
    }
    static void applyValueTextUnderlinePosition(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setTextUnderlinePosition(BuilderConverter::convertTextUnderlinePosition(builderState, value));
    }
    static void applyInitialTextWrapMode(BuilderState& builderState)
    {
        builderState.style().setTextWrapMode(RenderStyle::initialTextWrapMode());
    }
    static void applyInheritTextWrapMode(BuilderState& builderState)
    {
        builderState.style().setTextWrapMode(forwardInheritedValue(builderState.parentStyle().textWrapMode()));
    }
    static void applyValueTextWrapMode(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setTextWrapMode(fromCSSValueDeducingType(value));
    }
    static void applyInitialTextWrapStyle(BuilderState& builderState)
    {
        builderState.style().setTextWrapStyle(RenderStyle::initialTextWrapStyle());
    }
    static void applyInheritTextWrapStyle(BuilderState& builderState)
    {
        builderState.style().setTextWrapStyle(forwardInheritedValue(builderState.parentStyle().textWrapStyle()));
    }
    static void applyValueTextWrapStyle(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setTextWrapStyle(fromCSSValueDeducingType(value));
    }
    static void applyInitialTouchAction(BuilderState& builderState)
    {
        builderState.style().setTouchActions(RenderStyle::initialTouchActions());
    }
    static void applyInheritTouchAction(BuilderState& builderState)
    {
        builderState.style().setTouchActions(forwardInheritedValue(builderState.parentStyle().touchActions()));
    }
    static void applyValueTouchAction(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setTouchActions(BuilderConverter::convertTouchAction(builderState, value));
    }
    static void applyInitialTransform(BuilderState& builderState)
    {
        builderState.style().setTransform(RenderStyle::initialTransform());
    }
    static void applyInheritTransform(BuilderState& builderState)
    {
        builderState.style().setTransform(forwardInheritedValue(builderState.parentStyle().transform()));
    }
    static void applyValueTransform(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setTransform(BuilderConverter::convertTransform(builderState, value));
    }
    static void applyInitialTransformBox(BuilderState& builderState)
    {
        builderState.style().setTransformBox(RenderStyle::initialTransformBox());
    }
    static void applyInheritTransformBox(BuilderState& builderState)
    {
        builderState.style().setTransformBox(forwardInheritedValue(builderState.parentStyle().transformBox()));
    }
    static void applyValueTransformBox(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setTransformBox(fromCSSValueDeducingType(value));
    }
    static void applyInitialTransformOriginX(BuilderState& builderState)
    {
        builderState.style().setTransformOriginX(RenderStyle::initialTransformOriginX());
    }
    static void applyInheritTransformOriginX(BuilderState& builderState)
    {
        builderState.style().setTransformOriginX(forwardInheritedValue(builderState.parentStyle().transformOriginX()));
    }
    static void applyValueTransformOriginX(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setTransformOriginX(BuilderConverter::convertPositionComponentX(builderState, value));
    }
    static void applyInitialTransformOriginY(BuilderState& builderState)
    {
        builderState.style().setTransformOriginY(RenderStyle::initialTransformOriginY());
    }
    static void applyInheritTransformOriginY(BuilderState& builderState)
    {
        builderState.style().setTransformOriginY(forwardInheritedValue(builderState.parentStyle().transformOriginY()));
    }
    static void applyValueTransformOriginY(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setTransformOriginY(BuilderConverter::convertPositionComponentY(builderState, value));
    }
    static void applyInitialTransformOriginZ(BuilderState& builderState)
    {
        builderState.style().setTransformOriginZ(RenderStyle::initialTransformOriginZ());
    }
    static void applyInheritTransformOriginZ(BuilderState& builderState)
    {
        builderState.style().setTransformOriginZ(forwardInheritedValue(builderState.parentStyle().transformOriginZ()));
    }
    static void applyValueTransformOriginZ(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setTransformOriginZ(BuilderConverter::convertComputedLength<float>(builderState, value));
    }
    static void applyInitialTransformStyle(BuilderState& builderState)
    {
        builderState.style().setTransformStyle3D(RenderStyle::initialTransformStyle3D());
    }
    static void applyInheritTransformStyle(BuilderState& builderState)
    {
        builderState.style().setTransformStyle3D(forwardInheritedValue(builderState.parentStyle().transformStyle3D()));
    }
    static void applyValueTransformStyle(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setTransformStyle3D(fromCSSValueDeducingType(value));
    }
    static void applyInitialTransitionBehavior(BuilderState& builderState)
    {
        auto& list = builderState.style().ensureTransitions();
        if (list.isEmpty())
            list.append(Animation::create());
        list.animation(0).setAllowsDiscreteTransitions(Animation::initialAllowsDiscreteTransitions());
        for (auto& animation : list)
            animation->clearAllowsDiscreteTransitions();
    }
    static void applyInheritTransitionBehavior(BuilderState& builderState)
    {
        auto& list = builderState.style().ensureTransitions();
        auto* parentList = builderState.parentStyle().transitions();
        size_t i = 0, parentSize = parentList ? parentList->size() : 0;
        for ( ; i < parentSize && parentList->animation(i).isAllowsDiscreteTransitionsSet(); ++i) {
            if (list.size() <= i)
                list.append(Animation::create());
            list.animation(i).setAllowsDiscreteTransitions(parentList->animation(i).allowsDiscreteTransitions());
        }
        // Reset any remaining animations to not have the property set.
        for ( ; i < list.size(); ++i)
            list.animation(i).clearAllowsDiscreteTransitions();
    }
    static void applyValueTransitionBehavior(BuilderState& builderState, CSSValue& value)
    {
        auto& list = builderState.style().ensureTransitions();
        size_t childIndex = 0;
        if (auto* valueList = dynamicDowncast<CSSValueList>(value)) {
            // Walk each value and put it into an animation, creating new animations as needed.
            for (auto& currentValue : *valueList) {
                if (childIndex >= list.size())
                    list.append(Animation::create());
                builderState.styleMap().mapAnimationAllowsDiscreteTransitions(list.animation(childIndex), currentValue);
                ++childIndex;
            }
        } else {
            if (list.isEmpty())
                list.append(Animation::create());
            builderState.styleMap().mapAnimationAllowsDiscreteTransitions(list.animation(childIndex), value);
            childIndex = 1;
        }
        for ( ; childIndex < list.size(); ++childIndex) {
            // Reset all remaining animations to not have the property set.
            list.animation(childIndex).clearAllowsDiscreteTransitions();
        }
    }
    static void applyInitialTransitionDelay(BuilderState& builderState)
    {
        auto& list = builderState.style().ensureTransitions();
        if (list.isEmpty())
            list.append(Animation::create());
        list.animation(0).setDelay(Animation::initialDelay());
        for (auto& animation : list)
            animation->clearDelay();
    }
    static void applyInheritTransitionDelay(BuilderState& builderState)
    {
        auto& list = builderState.style().ensureTransitions();
        auto* parentList = builderState.parentStyle().transitions();
        size_t i = 0, parentSize = parentList ? parentList->size() : 0;
        for ( ; i < parentSize && parentList->animation(i).isDelaySet(); ++i) {
            if (list.size() <= i)
                list.append(Animation::create());
            list.animation(i).setDelay(parentList->animation(i).delay());
        }
        // Reset any remaining animations to not have the property set.
        for ( ; i < list.size(); ++i)
            list.animation(i).clearDelay();
    }
    static void applyValueTransitionDelay(BuilderState& builderState, CSSValue& value)
    {
        auto& list = builderState.style().ensureTransitions();
        size_t childIndex = 0;
        if (auto* valueList = dynamicDowncast<CSSValueList>(value)) {
            // Walk each value and put it into an animation, creating new animations as needed.
            for (auto& currentValue : *valueList) {
                if (childIndex >= list.size())
                    list.append(Animation::create());
                builderState.styleMap().mapAnimationDelay(list.animation(childIndex), currentValue);
                ++childIndex;
            }
        } else {
            if (list.isEmpty())
                list.append(Animation::create());
            builderState.styleMap().mapAnimationDelay(list.animation(childIndex), value);
            childIndex = 1;
        }
        for ( ; childIndex < list.size(); ++childIndex) {
            // Reset all remaining animations to not have the property set.
            list.animation(childIndex).clearDelay();
        }
    }
    static void applyInitialTransitionDuration(BuilderState& builderState)
    {
        auto& list = builderState.style().ensureTransitions();
        if (list.isEmpty())
            list.append(Animation::create());
        list.animation(0).setDuration(Animation::initialDuration());
        for (auto& animation : list)
            animation->clearDuration();
    }
    static void applyInheritTransitionDuration(BuilderState& builderState)
    {
        auto& list = builderState.style().ensureTransitions();
        auto* parentList = builderState.parentStyle().transitions();
        size_t i = 0, parentSize = parentList ? parentList->size() : 0;
        for ( ; i < parentSize && parentList->animation(i).isDurationSet(); ++i) {
            if (list.size() <= i)
                list.append(Animation::create());
            list.animation(i).setDuration(parentList->animation(i).duration());
        }
        // Reset any remaining animations to not have the property set.
        for ( ; i < list.size(); ++i)
            list.animation(i).clearDuration();
    }
    static void applyValueTransitionDuration(BuilderState& builderState, CSSValue& value)
    {
        auto& list = builderState.style().ensureTransitions();
        size_t childIndex = 0;
        if (auto* valueList = dynamicDowncast<CSSValueList>(value)) {
            // Walk each value and put it into an animation, creating new animations as needed.
            for (auto& currentValue : *valueList) {
                if (childIndex >= list.size())
                    list.append(Animation::create());
                builderState.styleMap().mapAnimationDuration(list.animation(childIndex), currentValue);
                ++childIndex;
            }
        } else {
            if (list.isEmpty())
                list.append(Animation::create());
            builderState.styleMap().mapAnimationDuration(list.animation(childIndex), value);
            childIndex = 1;
        }
        for ( ; childIndex < list.size(); ++childIndex) {
            // Reset all remaining animations to not have the property set.
            list.animation(childIndex).clearDuration();
        }
    }
    static void applyInitialTransitionProperty(BuilderState& builderState)
    {
        auto& list = builderState.style().ensureTransitions();
        if (list.isEmpty())
            list.append(Animation::create());
        list.animation(0).setProperty(Animation::initialProperty());
        for (auto& animation : list)
            animation->clearProperty();
    }
    static void applyInheritTransitionProperty(BuilderState& builderState)
    {
        auto& list = builderState.style().ensureTransitions();
        auto* parentList = builderState.parentStyle().transitions();
        size_t i = 0, parentSize = parentList ? parentList->size() : 0;
        for ( ; i < parentSize && parentList->animation(i).isPropertySet(); ++i) {
            if (list.size() <= i)
                list.append(Animation::create());
            list.animation(i).setProperty(parentList->animation(i).property());
        }
        // Reset any remaining animations to not have the property set.
        for ( ; i < list.size(); ++i)
            list.animation(i).clearProperty();
    }
    static void applyValueTransitionProperty(BuilderState& builderState, CSSValue& value)
    {
        auto& list = builderState.style().ensureTransitions();
        size_t childIndex = 0;
        if (auto* valueList = dynamicDowncast<CSSValueList>(value)) {
            // Walk each value and put it into an animation, creating new animations as needed.
            for (auto& currentValue : *valueList) {
                if (childIndex >= list.size())
                    list.append(Animation::create());
                builderState.styleMap().mapAnimationProperty(list.animation(childIndex), currentValue);
                ++childIndex;
            }
        } else {
            if (list.isEmpty())
                list.append(Animation::create());
            builderState.styleMap().mapAnimationProperty(list.animation(childIndex), value);
            childIndex = 1;
        }
        for ( ; childIndex < list.size(); ++childIndex) {
            // Reset all remaining animations to not have the property set.
            list.animation(childIndex).clearProperty();
        }
    }
    static void applyInitialTransitionTimingFunction(BuilderState& builderState)
    {
        auto& list = builderState.style().ensureTransitions();
        if (list.isEmpty())
            list.append(Animation::create());
        list.animation(0).setTimingFunction(Animation::initialTimingFunction());
        for (auto& animation : list)
            animation->clearTimingFunction();
    }
    static void applyInheritTransitionTimingFunction(BuilderState& builderState)
    {
        auto& list = builderState.style().ensureTransitions();
        auto* parentList = builderState.parentStyle().transitions();
        size_t i = 0, parentSize = parentList ? parentList->size() : 0;
        for ( ; i < parentSize && parentList->animation(i).isTimingFunctionSet(); ++i) {
            if (list.size() <= i)
                list.append(Animation::create());
            list.animation(i).setTimingFunction(parentList->animation(i).timingFunction());
        }
        // Reset any remaining animations to not have the property set.
        for ( ; i < list.size(); ++i)
            list.animation(i).clearTimingFunction();
    }
    static void applyValueTransitionTimingFunction(BuilderState& builderState, CSSValue& value)
    {
        auto& list = builderState.style().ensureTransitions();
        size_t childIndex = 0;
        if (auto* valueList = dynamicDowncast<CSSValueList>(value)) {
            // Walk each value and put it into an animation, creating new animations as needed.
            for (auto& currentValue : *valueList) {
                if (childIndex >= list.size())
                    list.append(Animation::create());
                builderState.styleMap().mapAnimationTimingFunction(list.animation(childIndex), currentValue);
                ++childIndex;
            }
        } else {
            if (list.isEmpty())
                list.append(Animation::create());
            builderState.styleMap().mapAnimationTimingFunction(list.animation(childIndex), value);
            childIndex = 1;
        }
        for ( ; childIndex < list.size(); ++childIndex) {
            // Reset all remaining animations to not have the property set.
            list.animation(childIndex).clearTimingFunction();
        }
    }
    static void applyInitialTranslate(BuilderState& builderState)
    {
        builderState.style().setTranslate(RenderStyle::initialTranslate());
    }
    static void applyInheritTranslate(BuilderState& builderState)
    {
        builderState.style().setTranslate(forwardInheritedValue(builderState.parentStyle().translate()));
    }
    static void applyValueTranslate(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setTranslate(BuilderConverter::convertTranslate(builderState, value));
    }
    static void applyInitialUnicodeBidi(BuilderState& builderState)
    {
        builderState.style().setUnicodeBidi(RenderStyle::initialUnicodeBidi());
    }
    static void applyInheritUnicodeBidi(BuilderState& builderState)
    {
        builderState.style().setUnicodeBidi(forwardInheritedValue(builderState.parentStyle().unicodeBidi()));
    }
    static void applyValueUnicodeBidi(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setUnicodeBidi(fromCSSValueDeducingType(value));
    }
    static void applyInitialVectorEffect(BuilderState& builderState)
    {
        builderState.style().accessSVGStyle().setVectorEffect(SVGRenderStyle::initialVectorEffect());
    }
    static void applyInheritVectorEffect(BuilderState& builderState)
    {
        builderState.style().accessSVGStyle().setVectorEffect(forwardInheritedValue(builderState.parentStyle().svgStyle().vectorEffect()));
    }
    static void applyValueVectorEffect(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().accessSVGStyle().setVectorEffect(fromCSSValueDeducingType(value));
    }
    static void applyInitialVerticalAlign(BuilderState& builderState)
    {
        builderState.style().setVerticalAlign(RenderStyle::initialVerticalAlign());
    }
    static void applyInitialViewTimelineAxis(BuilderState& builderState)
    {
        builderState.style().setViewTimelineAxes(RenderStyle::initialViewTimelineAxes());
    }
    static void applyInheritViewTimelineAxis(BuilderState& builderState)
    {
        builderState.style().setViewTimelineAxes(forwardInheritedValue(builderState.parentStyle().viewTimelineAxes()));
    }
    static void applyValueViewTimelineAxis(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setViewTimelineAxes(BuilderConverter::convertScrollTimelineAxis(builderState, value));
    }
    static void applyInitialViewTimelineInset(BuilderState& builderState)
    {
        builderState.style().setViewTimelineInsets(RenderStyle::initialViewTimelineInsets());
    }
    static void applyInheritViewTimelineInset(BuilderState& builderState)
    {
        builderState.style().setViewTimelineInsets(forwardInheritedValue(builderState.parentStyle().viewTimelineInsets()));
    }
    static void applyValueViewTimelineInset(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setViewTimelineInsets(BuilderConverter::convertViewTimelineInset(builderState, value));
    }
    static void applyInitialViewTimelineName(BuilderState& builderState)
    {
        builderState.style().setViewTimelineNames(RenderStyle::initialViewTimelineNames());
    }
    static void applyInheritViewTimelineName(BuilderState& builderState)
    {
        builderState.style().setViewTimelineNames(forwardInheritedValue(builderState.parentStyle().viewTimelineNames()));
    }
    static void applyValueViewTimelineName(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setViewTimelineNames(BuilderConverter::convertScrollTimelineName(builderState, value));
    }
    static void applyInitialViewTransitionClass(BuilderState& builderState)
    {
        builderState.style().setViewTransitionClasses(RenderStyle::initialViewTransitionClasses());
    }
    static void applyInheritViewTransitionClass(BuilderState& builderState)
    {
        builderState.style().setViewTransitionClasses(forwardInheritedValue(builderState.parentStyle().viewTransitionClasses()));
    }
    static void applyValueViewTransitionClass(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setViewTransitionClasses(BuilderConverter::convertViewTransitionClass(builderState, value));
    }
    static void applyInitialViewTransitionName(BuilderState& builderState)
    {
        builderState.style().setViewTransitionName(RenderStyle::initialViewTransitionName());
    }
    static void applyInheritViewTransitionName(BuilderState& builderState)
    {
        builderState.style().setViewTransitionName(forwardInheritedValue(builderState.parentStyle().viewTransitionName()));
    }
    static void applyValueViewTransitionName(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setViewTransitionName(BuilderConverter::convertViewTransitionName(builderState, value));
    }
    static void applyInitialVisibility(BuilderState& builderState)
    {
        builderState.style().setVisibility(RenderStyle::initialVisibility());
        builderState.style().setDisallowsFastPathInheritance();
    }
    static void applyInheritVisibility(BuilderState& builderState)
    {
        builderState.style().setVisibility(forwardInheritedValue(builderState.parentStyle().visibility()));
        builderState.style().setDisallowsFastPathInheritance();
    }
    static void applyValueVisibility(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setVisibility(fromCSSValueDeducingType(value));
        builderState.style().setDisallowsFastPathInheritance();
    }
    static void applyInitialWhiteSpaceCollapse(BuilderState& builderState)
    {
        builderState.style().setWhiteSpaceCollapse(RenderStyle::initialWhiteSpaceCollapse());
    }
    static void applyInheritWhiteSpaceCollapse(BuilderState& builderState)
    {
        builderState.style().setWhiteSpaceCollapse(forwardInheritedValue(builderState.parentStyle().whiteSpaceCollapse()));
    }
    static void applyValueWhiteSpaceCollapse(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setWhiteSpaceCollapse(fromCSSValueDeducingType(value));
    }
    static void applyInitialWidows(BuilderState& builderState)
    {
        builderState.style().setHasAutoWidows();
    }
    static void applyInheritWidows(BuilderState& builderState)
    {
        if (builderState.parentStyle().hasAutoWidows()) {
            builderState.style().setHasAutoWidows();
            return;
        }
        builderState.style().setWidows(forwardInheritedValue(builderState.parentStyle().widows()));
    }
    static void applyValueWidows(BuilderState& builderState, CSSValue& value)
    {
        if (value.valueID() == CSSValueAuto) {
            builderState.style().setHasAutoWidows();
            return;
        }
        builderState.style().setWidows(fromCSSValueDeducingType(value));
    }
    static void applyInitialWillChange(BuilderState& builderState)
    {
        builderState.style().setWillChange(RenderStyle::initialWillChange());
    }
    static void applyInheritWillChange(BuilderState& builderState)
    {
        builderState.style().setWillChange(forwardInheritedValue(builderState.parentStyle().willChange()));
    }
    static void applyValueWillChange(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setWillChange(BuilderConverter::convertWillChange(builderState, value));
    }
    static void applyInitialWordBreak(BuilderState& builderState)
    {
        builderState.style().setWordBreak(RenderStyle::initialWordBreak());
    }
    static void applyInheritWordBreak(BuilderState& builderState)
    {
        builderState.style().setWordBreak(forwardInheritedValue(builderState.parentStyle().wordBreak()));
    }
    static void applyValueWordBreak(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setWordBreak(fromCSSValueDeducingType(value));
    }
    static void applyInitialX(BuilderState& builderState)
    {
        builderState.style().setX(RenderStyle::zeroLength());
    }
    static void applyInheritX(BuilderState& builderState)
    {
        builderState.style().setX(forwardInheritedValue(builderState.parentStyle().x()));
    }
    static void applyValueX(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setX(BuilderConverter::convertLength(builderState, value));
    }
    static void applyInitialY(BuilderState& builderState)
    {
        builderState.style().setY(RenderStyle::zeroLength());
    }
    static void applyInheritY(BuilderState& builderState)
    {
        builderState.style().setY(forwardInheritedValue(builderState.parentStyle().y()));
    }
    static void applyValueY(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setY(BuilderConverter::convertLength(builderState, value));
    }
    static void applyInitialZIndex(BuilderState& builderState)
    {
        builderState.style().setHasAutoSpecifiedZIndex();
    }
    static void applyInheritZIndex(BuilderState& builderState)
    {
        if (builderState.parentStyle().hasAutoSpecifiedZIndex()) {
            builderState.style().setHasAutoSpecifiedZIndex();
            return;
        }
        builderState.style().setSpecifiedZIndex(forwardInheritedValue(builderState.parentStyle().specifiedZIndex()));
    }
    static void applyValueZIndex(BuilderState& builderState, CSSValue& value)
    {
        if (value.valueID() == CSSValueAuto) {
            builderState.style().setHasAutoSpecifiedZIndex();
            return;
        }
        builderState.style().setSpecifiedZIndex(fromCSSValueDeducingType(value));
    }
    static void applyInitialAppleColorFilter(BuilderState& builderState)
    {
        builderState.style().setAppleColorFilter(RenderStyle::initialAppleColorFilter());
    }
    static void applyInheritAppleColorFilter(BuilderState& builderState)
    {
        builderState.style().setAppleColorFilter(forwardInheritedValue(builderState.parentStyle().appleColorFilter()));
    }
    static void applyValueAppleColorFilter(BuilderState& builderState, CSSValue& value)
    {
        auto convertedValue = BuilderConverter::convertFilterOperations(builderState, value);
        if (convertedValue)
            builderState.style().setAppleColorFilter(WTFMove(convertedValue.value()));
    }
    static void applyInitialWebkitBorderHorizontalSpacing(BuilderState& builderState)
    {
        builderState.style().setHorizontalBorderSpacing(RenderStyle::initialHorizontalBorderSpacing());
    }
    static void applyInheritWebkitBorderHorizontalSpacing(BuilderState& builderState)
    {
        builderState.style().setHorizontalBorderSpacing(forwardInheritedValue(builderState.parentStyle().horizontalBorderSpacing()));
    }
    static void applyValueWebkitBorderHorizontalSpacing(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setHorizontalBorderSpacing(BuilderConverter::convertComputedLength<float>(builderState, value));
    }
    static void applyInitialWebkitBorderVerticalSpacing(BuilderState& builderState)
    {
        builderState.style().setVerticalBorderSpacing(RenderStyle::initialVerticalBorderSpacing());
    }
    static void applyInheritWebkitBorderVerticalSpacing(BuilderState& builderState)
    {
        builderState.style().setVerticalBorderSpacing(forwardInheritedValue(builderState.parentStyle().verticalBorderSpacing()));
    }
    static void applyValueWebkitBorderVerticalSpacing(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setVerticalBorderSpacing(BuilderConverter::convertComputedLength<float>(builderState, value));
    }
    static void applyInitialWebkitBoxAlign(BuilderState& builderState)
    {
        builderState.style().setBoxAlign(RenderStyle::initialBoxAlign());
    }
    static void applyInheritWebkitBoxAlign(BuilderState& builderState)
    {
        builderState.style().setBoxAlign(forwardInheritedValue(builderState.parentStyle().boxAlign()));
    }
    static void applyValueWebkitBoxAlign(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setBoxAlign(fromCSSValueDeducingType(value));
    }
    static void applyInitialWebkitBoxDecorationBreak(BuilderState& builderState)
    {
        builderState.style().setBoxDecorationBreak(RenderStyle::initialBoxDecorationBreak());
    }
    static void applyInheritWebkitBoxDecorationBreak(BuilderState& builderState)
    {
        builderState.style().setBoxDecorationBreak(forwardInheritedValue(builderState.parentStyle().boxDecorationBreak()));
    }
    static void applyValueWebkitBoxDecorationBreak(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setBoxDecorationBreak(fromCSSValueDeducingType(value));
    }
    static void applyInitialWebkitBoxDirection(BuilderState& builderState)
    {
        builderState.style().setBoxDirection(RenderStyle::initialBoxDirection());
    }
    static void applyInheritWebkitBoxDirection(BuilderState& builderState)
    {
        builderState.style().setBoxDirection(forwardInheritedValue(builderState.parentStyle().boxDirection()));
    }
    static void applyValueWebkitBoxDirection(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setBoxDirection(fromCSSValueDeducingType(value));
    }
    static void applyInitialWebkitBoxFlex(BuilderState& builderState)
    {
        builderState.style().setBoxFlex(RenderStyle::initialBoxFlex());
    }
    static void applyInheritWebkitBoxFlex(BuilderState& builderState)
    {
        builderState.style().setBoxFlex(forwardInheritedValue(builderState.parentStyle().boxFlex()));
    }
    static void applyValueWebkitBoxFlex(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setBoxFlex(fromCSSValueDeducingType(value));
    }
    static void applyInitialWebkitBoxFlexGroup(BuilderState& builderState)
    {
        builderState.style().setBoxFlexGroup(RenderStyle::initialBoxFlexGroup());
    }
    static void applyInheritWebkitBoxFlexGroup(BuilderState& builderState)
    {
        builderState.style().setBoxFlexGroup(forwardInheritedValue(builderState.parentStyle().boxFlexGroup()));
    }
    static void applyValueWebkitBoxFlexGroup(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setBoxFlexGroup(fromCSSValueDeducingType(value));
    }
    static void applyInitialWebkitBoxLines(BuilderState& builderState)
    {
        builderState.style().setBoxLines(RenderStyle::initialBoxLines());
    }
    static void applyInheritWebkitBoxLines(BuilderState& builderState)
    {
        builderState.style().setBoxLines(forwardInheritedValue(builderState.parentStyle().boxLines()));
    }
    static void applyValueWebkitBoxLines(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setBoxLines(fromCSSValueDeducingType(value));
    }
    static void applyInitialWebkitBoxOrdinalGroup(BuilderState& builderState)
    {
        builderState.style().setBoxOrdinalGroup(RenderStyle::initialBoxOrdinalGroup());
    }
    static void applyInheritWebkitBoxOrdinalGroup(BuilderState& builderState)
    {
        builderState.style().setBoxOrdinalGroup(forwardInheritedValue(builderState.parentStyle().boxOrdinalGroup()));
    }
    static void applyValueWebkitBoxOrdinalGroup(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setBoxOrdinalGroup(fromCSSValueDeducingType(value));
    }
    static void applyInitialWebkitBoxOrient(BuilderState& builderState)
    {
        builderState.style().setBoxOrient(RenderStyle::initialBoxOrient());
    }
    static void applyInheritWebkitBoxOrient(BuilderState& builderState)
    {
        builderState.style().setBoxOrient(forwardInheritedValue(builderState.parentStyle().boxOrient()));
    }
    static void applyValueWebkitBoxOrient(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setBoxOrient(fromCSSValueDeducingType(value));
    }
    static void applyInitialWebkitBoxPack(BuilderState& builderState)
    {
        builderState.style().setBoxPack(RenderStyle::initialBoxPack());
    }
    static void applyInheritWebkitBoxPack(BuilderState& builderState)
    {
        builderState.style().setBoxPack(forwardInheritedValue(builderState.parentStyle().boxPack()));
    }
    static void applyValueWebkitBoxPack(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setBoxPack(fromCSSValueDeducingType(value));
    }
    static void applyInitialWebkitBoxReflect(BuilderState& builderState)
    {
        builderState.style().setBoxReflect(RenderStyle::initialBoxReflect());
    }
    static void applyInheritWebkitBoxReflect(BuilderState& builderState)
    {
        builderState.style().setBoxReflect(forwardInheritedValue(builderState.parentStyle().boxReflect()));
    }
    static void applyValueWebkitBoxReflect(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setBoxReflect(BuilderConverter::convertReflection(builderState, value));
    }
    static void applyInitialWebkitColumnAxis(BuilderState& builderState)
    {
        builderState.style().setColumnAxis(RenderStyle::initialColumnAxis());
    }
    static void applyInheritWebkitColumnAxis(BuilderState& builderState)
    {
        builderState.style().setColumnAxis(forwardInheritedValue(builderState.parentStyle().columnAxis()));
    }
    static void applyValueWebkitColumnAxis(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setColumnAxis(fromCSSValueDeducingType(value));
    }
    static void applyInitialWebkitColumnProgression(BuilderState& builderState)
    {
        builderState.style().setColumnProgression(RenderStyle::initialColumnProgression());
    }
    static void applyInheritWebkitColumnProgression(BuilderState& builderState)
    {
        builderState.style().setColumnProgression(forwardInheritedValue(builderState.parentStyle().columnProgression()));
    }
    static void applyValueWebkitColumnProgression(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setColumnProgression(fromCSSValueDeducingType(value));
    }
    static void applyInitialWebkitCursorVisibility(BuilderState& builderState)
    {
        builderState.style().setCursorVisibility(RenderStyle::initialCursorVisibility());
    }
    static void applyInheritWebkitCursorVisibility(BuilderState& builderState)
    {
        builderState.style().setCursorVisibility(forwardInheritedValue(builderState.parentStyle().cursorVisibility()));
    }
    static void applyValueWebkitCursorVisibility(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setCursorVisibility(fromCSSValueDeducingType(value));
    }
    static void applyInitialWebkitHyphenateLimitAfter(BuilderState& builderState)
    {
        builderState.style().setHyphenationLimitAfter(RenderStyle::initialHyphenationLimitAfter());
    }
    static void applyInheritWebkitHyphenateLimitAfter(BuilderState& builderState)
    {
        builderState.style().setHyphenationLimitAfter(forwardInheritedValue(builderState.parentStyle().hyphenationLimitAfter()));
    }
    static void applyValueWebkitHyphenateLimitAfter(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setHyphenationLimitAfter(BuilderConverter::convertNumberOrAuto<short>(builderState, value));
    }
    static void applyInitialWebkitHyphenateLimitBefore(BuilderState& builderState)
    {
        builderState.style().setHyphenationLimitBefore(RenderStyle::initialHyphenationLimitBefore());
    }
    static void applyInheritWebkitHyphenateLimitBefore(BuilderState& builderState)
    {
        builderState.style().setHyphenationLimitBefore(forwardInheritedValue(builderState.parentStyle().hyphenationLimitBefore()));
    }
    static void applyValueWebkitHyphenateLimitBefore(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setHyphenationLimitBefore(BuilderConverter::convertNumberOrAuto<short>(builderState, value));
    }
    static void applyInitialWebkitHyphenateLimitLines(BuilderState& builderState)
    {
        builderState.style().setHyphenationLimitLines(RenderStyle::initialHyphenationLimitLines());
    }
    static void applyInheritWebkitHyphenateLimitLines(BuilderState& builderState)
    {
        builderState.style().setHyphenationLimitLines(forwardInheritedValue(builderState.parentStyle().hyphenationLimitLines()));
    }
    static void applyValueWebkitHyphenateLimitLines(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setHyphenationLimitLines(BuilderConverter::convertWebkitHyphenateLimitLines(builderState, value));
    }
    static void applyInitialWebkitInitialLetter(BuilderState& builderState)
    {
        builderState.style().setInitialLetter(RenderStyle::initialInitialLetter());
    }
    static void applyInheritWebkitInitialLetter(BuilderState& builderState)
    {
        builderState.style().setInitialLetter(forwardInheritedValue(builderState.parentStyle().initialLetter()));
    }
    static void applyValueWebkitInitialLetter(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setInitialLetter(BuilderConverter::convertInitialLetter(builderState, value));
    }
    static void applyInitialWebkitLineAlign(BuilderState& builderState)
    {
        builderState.style().setLineAlign(RenderStyle::initialLineAlign());
    }
    static void applyInheritWebkitLineAlign(BuilderState& builderState)
    {
        builderState.style().setLineAlign(forwardInheritedValue(builderState.parentStyle().lineAlign()));
    }
    static void applyValueWebkitLineAlign(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setLineAlign(fromCSSValueDeducingType(value));
    }
    static void applyInitialWebkitLineBoxContain(BuilderState& builderState)
    {
        builderState.style().setLineBoxContain(RenderStyle::initialLineBoxContain());
    }
    static void applyInheritWebkitLineBoxContain(BuilderState& builderState)
    {
        builderState.style().setLineBoxContain(forwardInheritedValue(builderState.parentStyle().lineBoxContain()));
    }
    static void applyValueWebkitLineBoxContain(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setLineBoxContain(BuilderConverter::convertLineBoxContain(builderState, value));
    }
    static void applyInitialWebkitLineClamp(BuilderState& builderState)
    {
        builderState.style().setLineClamp(RenderStyle::initialLineClamp());
    }
    static void applyInheritWebkitLineClamp(BuilderState& builderState)
    {
        builderState.style().setLineClamp(forwardInheritedValue(builderState.parentStyle().lineClamp()));
    }
    static void applyValueWebkitLineClamp(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setLineClamp(fromCSSValueDeducingType(value));
    }
    static void applyInitialWebkitLineGrid(BuilderState& builderState)
    {
        builderState.style().setLineGrid(RenderStyle::initialLineGrid());
    }
    static void applyInheritWebkitLineGrid(BuilderState& builderState)
    {
        builderState.style().setLineGrid(forwardInheritedValue(builderState.parentStyle().lineGrid()));
    }
    static void applyValueWebkitLineGrid(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setLineGrid(BuilderConverter::convertStringOrNoneAtom(builderState, value));
    }
    static void applyInitialWebkitLineSnap(BuilderState& builderState)
    {
        builderState.style().setLineSnap(RenderStyle::initialLineSnap());
    }
    static void applyInheritWebkitLineSnap(BuilderState& builderState)
    {
        builderState.style().setLineSnap(forwardInheritedValue(builderState.parentStyle().lineSnap()));
    }
    static void applyValueWebkitLineSnap(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setLineSnap(fromCSSValueDeducingType(value));
    }
    static void applyInitialWebkitMarqueeDirection(BuilderState& builderState)
    {
        builderState.style().setMarqueeDirection(RenderStyle::initialMarqueeDirection());
    }
    static void applyInheritWebkitMarqueeDirection(BuilderState& builderState)
    {
        builderState.style().setMarqueeDirection(forwardInheritedValue(builderState.parentStyle().marqueeDirection()));
    }
    static void applyValueWebkitMarqueeDirection(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setMarqueeDirection(fromCSSValueDeducingType(value));
    }
    static void applyInitialWebkitMarqueeIncrement(BuilderState& builderState)
    {
        builderState.style().setMarqueeIncrement(RenderStyle::initialMarqueeIncrement());
    }
    static void applyInheritWebkitMarqueeIncrement(BuilderState& builderState)
    {
        builderState.style().setMarqueeIncrement(forwardInheritedValue(builderState.parentStyle().marqueeIncrement()));
    }
    static void applyValueWebkitMarqueeIncrement(BuilderState& builderState, CSSValue& value)
    {
        auto convertedValue = BuilderConverter::convertMarqueeIncrement(builderState, value);
        if (convertedValue)
            builderState.style().setMarqueeIncrement(WTFMove(convertedValue.value()));
    }
    static void applyInitialWebkitMarqueeRepetition(BuilderState& builderState)
    {
        builderState.style().setMarqueeLoopCount(RenderStyle::initialMarqueeLoopCount());
    }
    static void applyInheritWebkitMarqueeRepetition(BuilderState& builderState)
    {
        builderState.style().setMarqueeLoopCount(forwardInheritedValue(builderState.parentStyle().marqueeLoopCount()));
    }
    static void applyValueWebkitMarqueeRepetition(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setMarqueeLoopCount(BuilderConverter::convertMarqueeRepetition(builderState, value));
    }
    static void applyInitialWebkitMarqueeSpeed(BuilderState& builderState)
    {
        builderState.style().setMarqueeSpeed(RenderStyle::initialMarqueeSpeed());
    }
    static void applyInheritWebkitMarqueeSpeed(BuilderState& builderState)
    {
        builderState.style().setMarqueeSpeed(forwardInheritedValue(builderState.parentStyle().marqueeSpeed()));
    }
    static void applyValueWebkitMarqueeSpeed(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setMarqueeSpeed(BuilderConverter::convertMarqueeSpeed(builderState, value));
    }
    static void applyInitialWebkitMarqueeStyle(BuilderState& builderState)
    {
        builderState.style().setMarqueeBehavior(RenderStyle::initialMarqueeBehavior());
    }
    static void applyInheritWebkitMarqueeStyle(BuilderState& builderState)
    {
        builderState.style().setMarqueeBehavior(forwardInheritedValue(builderState.parentStyle().marqueeBehavior()));
    }
    static void applyValueWebkitMarqueeStyle(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setMarqueeBehavior(fromCSSValueDeducingType(value));
    }
    static void applyInitialWebkitMaskPositionX(BuilderState& builderState)
    {
        // Check for (single-layer) no-op before clearing anything.
        auto& layers = builderState.style().maskLayers();
        if (!layers.next() && (!layers.isXPositionSet() || layers.xPosition() == FillLayer::initialFillXPosition(FillLayerType::Mask)))
            return;
        auto* child = &builderState.style().ensureMaskLayers();
        child->setXPosition(FillLayer::initialFillXPosition(FillLayerType::Mask));
        for (child = child->next(); child; child = child->next())
            child->clearXPosition();
    }
    static void applyInheritWebkitMaskPositionX(BuilderState& builderState)
    {
        // Check for no-op before copying anything.
        if (builderState.parentStyle().maskLayers() == builderState.style().maskLayers())
            return;
        auto* child = &builderState.style().ensureMaskLayers();
        FillLayer* previousChild = nullptr;
        for (auto* parent = &builderState.parentStyle().maskLayers(); parent && parent->isXPositionSet(); parent = parent->next()) {
            if (!child) {
                previousChild->setNext(FillLayer::create(FillLayerType::Mask));
                child = previousChild->next();
            }
            child->setXPosition(parent->xPosition());
            previousChild = child;
            child = previousChild->next();
        }
        for (; child; child = child->next())
            child->clearXPosition();
    }
    static void applyValueWebkitMaskPositionX(CSSPropertyID id, BuilderState& builderState, CSSValue& value)
    {
        auto* child = &builderState.style().ensureMaskLayers();
        FillLayer* previousChild = nullptr;
        if (auto* valueList = dynamicDowncast<CSSValueList>(value)) {
            // Walk each value and put it into a layer, creating new layers as needed.
            for (auto& item : *valueList) {
                if (!child) {
                    previousChild->setNext(FillLayer::create(FillLayerType::Mask));
                    child = previousChild->next();
                }
                builderState.styleMap().mapFillXPosition(id, *child, item);
                previousChild = child;
                child = child->next();
            }
        } else {
            builderState.styleMap().mapFillXPosition(id, *child, value);
            child = child->next();
        }
        for (; child; child = child->next())
            child->clearXPosition();
    }
    static void applyInitialWebkitMaskPositionY(BuilderState& builderState)
    {
        // Check for (single-layer) no-op before clearing anything.
        auto& layers = builderState.style().maskLayers();
        if (!layers.next() && (!layers.isYPositionSet() || layers.yPosition() == FillLayer::initialFillYPosition(FillLayerType::Mask)))
            return;
        auto* child = &builderState.style().ensureMaskLayers();
        child->setYPosition(FillLayer::initialFillYPosition(FillLayerType::Mask));
        for (child = child->next(); child; child = child->next())
            child->clearYPosition();
    }
    static void applyInheritWebkitMaskPositionY(BuilderState& builderState)
    {
        // Check for no-op before copying anything.
        if (builderState.parentStyle().maskLayers() == builderState.style().maskLayers())
            return;
        auto* child = &builderState.style().ensureMaskLayers();
        FillLayer* previousChild = nullptr;
        for (auto* parent = &builderState.parentStyle().maskLayers(); parent && parent->isYPositionSet(); parent = parent->next()) {
            if (!child) {
                previousChild->setNext(FillLayer::create(FillLayerType::Mask));
                child = previousChild->next();
            }
            child->setYPosition(parent->yPosition());
            previousChild = child;
            child = previousChild->next();
        }
        for (; child; child = child->next())
            child->clearYPosition();
    }
    static void applyValueWebkitMaskPositionY(CSSPropertyID id, BuilderState& builderState, CSSValue& value)
    {
        auto* child = &builderState.style().ensureMaskLayers();
        FillLayer* previousChild = nullptr;
        if (auto* valueList = dynamicDowncast<CSSValueList>(value)) {
            // Walk each value and put it into a layer, creating new layers as needed.
            for (auto& item : *valueList) {
                if (!child) {
                    previousChild->setNext(FillLayer::create(FillLayerType::Mask));
                    child = previousChild->next();
                }
                builderState.styleMap().mapFillYPosition(id, *child, item);
                previousChild = child;
                child = child->next();
            }
        } else {
            builderState.styleMap().mapFillYPosition(id, *child, value);
            child = child->next();
        }
        for (; child; child = child->next())
            child->clearYPosition();
    }
    static void applyInitialWebkitNbspMode(BuilderState& builderState)
    {
        builderState.style().setNBSPMode(RenderStyle::initialNBSPMode());
    }
    static void applyInheritWebkitNbspMode(BuilderState& builderState)
    {
        builderState.style().setNBSPMode(forwardInheritedValue(builderState.parentStyle().nbspMode()));
    }
    static void applyValueWebkitNbspMode(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setNBSPMode(fromCSSValueDeducingType(value));
    }
    static void applyInitialWebkitRtlOrdering(BuilderState& builderState)
    {
        builderState.style().setRTLOrdering(RenderStyle::initialRTLOrdering());
    }
    static void applyInheritWebkitRtlOrdering(BuilderState& builderState)
    {
        builderState.style().setRTLOrdering(forwardInheritedValue(builderState.parentStyle().rtlOrdering()));
    }
    static void applyValueWebkitRtlOrdering(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setRTLOrdering(fromCSSValueDeducingType(value));
    }
    static void applyInitialWebkitTapHighlightColor(BuilderState& builderState)
    {
        builderState.style().setTapHighlightColor(RenderStyle::initialTapHighlightColor());
    }
    static void applyInheritWebkitTapHighlightColor(BuilderState& builderState)
    {
        builderState.style().setTapHighlightColor(forwardInheritedValue(builderState.parentStyle().tapHighlightColor()));
    }
    static void applyValueWebkitTapHighlightColor(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setTapHighlightColor(BuilderConverter::convertTapHighlightColor(builderState, value));
    }
    static void applyInitialWebkitTextFillColor(BuilderState& builderState)
    {
        if (builderState.applyPropertyToRegularStyle())
            builderState.style().setTextFillColor(StyleColor::currentColor());
        if (builderState.applyPropertyToVisitedLinkStyle())
            builderState.style().setVisitedLinkTextFillColor(StyleColor::currentColor());
    }
    static void applyInheritWebkitTextFillColor(BuilderState& builderState)
    {
        if (builderState.applyPropertyToRegularStyle())
            builderState.style().setTextFillColor(builderState.parentStyle().textFillColor());
        if (builderState.applyPropertyToVisitedLinkStyle())
            builderState.style().setVisitedLinkTextFillColor(builderState.parentStyle().textFillColor());
    }
    static void applyValueWebkitTextFillColor(BuilderState& builderState, CSSValue& value)
    {
        if (builderState.applyPropertyToRegularStyle())
            builderState.style().setTextFillColor(builderState.colorFromPrimitiveValue(fromCSSValueDeducingType(value), ForVisitedLink::No));
        if (builderState.applyPropertyToVisitedLinkStyle())
            builderState.style().setVisitedLinkTextFillColor(builderState.colorFromPrimitiveValue(fromCSSValueDeducingType(value), ForVisitedLink::Yes));
    }
    static void applyInitialWebkitTextSecurity(BuilderState& builderState)
    {
        builderState.style().setTextSecurity(RenderStyle::initialTextSecurity());
    }
    static void applyInheritWebkitTextSecurity(BuilderState& builderState)
    {
        builderState.style().setTextSecurity(forwardInheritedValue(builderState.parentStyle().textSecurity()));
    }
    static void applyValueWebkitTextSecurity(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setTextSecurity(fromCSSValueDeducingType(value));
    }
    static void applyInitialWebkitTextStrokeColor(BuilderState& builderState)
    {
        if (builderState.applyPropertyToRegularStyle())
            builderState.style().setTextStrokeColor(StyleColor::currentColor());
        if (builderState.applyPropertyToVisitedLinkStyle())
            builderState.style().setVisitedLinkTextStrokeColor(StyleColor::currentColor());
    }
    static void applyInheritWebkitTextStrokeColor(BuilderState& builderState)
    {
        if (builderState.applyPropertyToRegularStyle())
            builderState.style().setTextStrokeColor(builderState.parentStyle().textStrokeColor());
        if (builderState.applyPropertyToVisitedLinkStyle())
            builderState.style().setVisitedLinkTextStrokeColor(builderState.parentStyle().textStrokeColor());
    }
    static void applyValueWebkitTextStrokeColor(BuilderState& builderState, CSSValue& value)
    {
        if (builderState.applyPropertyToRegularStyle())
            builderState.style().setTextStrokeColor(builderState.colorFromPrimitiveValue(fromCSSValueDeducingType(value), ForVisitedLink::No));
        if (builderState.applyPropertyToVisitedLinkStyle())
            builderState.style().setVisitedLinkTextStrokeColor(builderState.colorFromPrimitiveValue(fromCSSValueDeducingType(value), ForVisitedLink::Yes));
    }
    static void applyInitialWebkitTextStrokeWidth(BuilderState& builderState)
    {
        builderState.style().setTextStrokeWidth(RenderStyle::initialTextStrokeWidth());
    }
    static void applyInheritWebkitTextStrokeWidth(BuilderState& builderState)
    {
        builderState.style().setTextStrokeWidth(forwardInheritedValue(builderState.parentStyle().textStrokeWidth()));
    }
    static void applyValueWebkitTextStrokeWidth(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setTextStrokeWidth(BuilderConverter::convertTextStrokeWidth(builderState, value));
    }
    static void applyInitialWebkitUserDrag(BuilderState& builderState)
    {
        builderState.style().setUserDrag(RenderStyle::initialUserDrag());
    }
    static void applyInheritWebkitUserDrag(BuilderState& builderState)
    {
        builderState.style().setUserDrag(forwardInheritedValue(builderState.parentStyle().userDrag()));
    }
    static void applyValueWebkitUserDrag(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setUserDrag(fromCSSValueDeducingType(value));
    }
    static void applyInitialWebkitUserModify(BuilderState& builderState)
    {
        builderState.style().setUserModify(RenderStyle::initialUserModify());
    }
    static void applyInheritWebkitUserModify(BuilderState& builderState)
    {
        builderState.style().setUserModify(forwardInheritedValue(builderState.parentStyle().userModify()));
    }
    static void applyValueWebkitUserModify(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setUserModify(fromCSSValueDeducingType(value));
    }
    static void applyInitialWebkitUserSelect(BuilderState& builderState)
    {
        builderState.style().setUserSelect(RenderStyle::initialUserSelect());
    }
    static void applyInheritWebkitUserSelect(BuilderState& builderState)
    {
        builderState.style().setUserSelect(forwardInheritedValue(builderState.parentStyle().userSelect()));
    }
    static void applyValueWebkitUserSelect(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setUserSelect(fromCSSValueDeducingType(value));
    }
    static void applyInitialWordSpacing(BuilderState& builderState)
    {
        builderState.style().setWordSpacing(RenderStyle::initialWordSpacing());
    }
    static void applyValueWordSpacing(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setWordSpacing(BuilderConverter::convertTextLengthOrNormal(builderState, value));
    }
    static void applyInitialBorderBottomColor(BuilderState& builderState)
    {
        if (builderState.applyPropertyToRegularStyle())
            builderState.style().setBorderBottomColor(StyleColor::currentColor());
        if (builderState.applyPropertyToVisitedLinkStyle())
            builderState.style().setVisitedLinkBorderBottomColor(StyleColor::currentColor());
    }
    static void applyInheritBorderBottomColor(BuilderState& builderState)
    {
        if (builderState.applyPropertyToRegularStyle())
            builderState.style().setBorderBottomColor(builderState.parentStyle().borderBottomColor());
        if (builderState.applyPropertyToVisitedLinkStyle())
            builderState.style().setVisitedLinkBorderBottomColor(builderState.parentStyle().borderBottomColor());
    }
    static void applyValueBorderBottomColor(BuilderState& builderState, CSSValue& value)
    {
        if (builderState.applyPropertyToRegularStyle())
            builderState.style().setBorderBottomColor(builderState.colorFromPrimitiveValue(fromCSSValueDeducingType(value), ForVisitedLink::No));
        if (builderState.applyPropertyToVisitedLinkStyle())
            builderState.style().setVisitedLinkBorderBottomColor(builderState.colorFromPrimitiveValue(fromCSSValueDeducingType(value), ForVisitedLink::Yes));
    }
    static void applyInitialBorderBottomStyle(BuilderState& builderState)
    {
        builderState.style().setBorderBottomStyle(RenderStyle::initialBorderStyle());
    }
    static void applyInheritBorderBottomStyle(BuilderState& builderState)
    {
        builderState.style().setBorderBottomStyle(forwardInheritedValue(builderState.parentStyle().borderBottomStyle()));
    }
    static void applyValueBorderBottomStyle(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setBorderBottomStyle(fromCSSValueDeducingType(value));
    }
    static void applyInitialBorderBottomWidth(BuilderState& builderState)
    {
        builderState.style().setBorderBottomWidth(RenderStyle::initialBorderWidth());
    }
    static void applyInheritBorderBottomWidth(BuilderState& builderState)
    {
        builderState.style().setBorderBottomWidth(forwardInheritedValue(builderState.parentStyle().borderBottomWidth()));
    }
    static void applyValueBorderBottomWidth(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setBorderBottomWidth(BuilderConverter::convertLineWidth<float>(builderState, value));
    }
    static void applyInitialBorderLeftColor(BuilderState& builderState)
    {
        if (builderState.applyPropertyToRegularStyle())
            builderState.style().setBorderLeftColor(StyleColor::currentColor());
        if (builderState.applyPropertyToVisitedLinkStyle())
            builderState.style().setVisitedLinkBorderLeftColor(StyleColor::currentColor());
    }
    static void applyInheritBorderLeftColor(BuilderState& builderState)
    {
        if (builderState.applyPropertyToRegularStyle())
            builderState.style().setBorderLeftColor(builderState.parentStyle().borderLeftColor());
        if (builderState.applyPropertyToVisitedLinkStyle())
            builderState.style().setVisitedLinkBorderLeftColor(builderState.parentStyle().borderLeftColor());
    }
    static void applyValueBorderLeftColor(BuilderState& builderState, CSSValue& value)
    {
        if (builderState.applyPropertyToRegularStyle())
            builderState.style().setBorderLeftColor(builderState.colorFromPrimitiveValue(fromCSSValueDeducingType(value), ForVisitedLink::No));
        if (builderState.applyPropertyToVisitedLinkStyle())
            builderState.style().setVisitedLinkBorderLeftColor(builderState.colorFromPrimitiveValue(fromCSSValueDeducingType(value), ForVisitedLink::Yes));
    }
    static void applyInitialBorderLeftStyle(BuilderState& builderState)
    {
        builderState.style().setBorderLeftStyle(RenderStyle::initialBorderStyle());
    }
    static void applyInheritBorderLeftStyle(BuilderState& builderState)
    {
        builderState.style().setBorderLeftStyle(forwardInheritedValue(builderState.parentStyle().borderLeftStyle()));
    }
    static void applyValueBorderLeftStyle(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setBorderLeftStyle(fromCSSValueDeducingType(value));
    }
    static void applyInitialBorderLeftWidth(BuilderState& builderState)
    {
        builderState.style().setBorderLeftWidth(RenderStyle::initialBorderWidth());
    }
    static void applyInheritBorderLeftWidth(BuilderState& builderState)
    {
        builderState.style().setBorderLeftWidth(forwardInheritedValue(builderState.parentStyle().borderLeftWidth()));
    }
    static void applyValueBorderLeftWidth(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setBorderLeftWidth(BuilderConverter::convertLineWidth<float>(builderState, value));
    }
    static void applyInitialBorderRightColor(BuilderState& builderState)
    {
        if (builderState.applyPropertyToRegularStyle())
            builderState.style().setBorderRightColor(StyleColor::currentColor());
        if (builderState.applyPropertyToVisitedLinkStyle())
            builderState.style().setVisitedLinkBorderRightColor(StyleColor::currentColor());
    }
    static void applyInheritBorderRightColor(BuilderState& builderState)
    {
        if (builderState.applyPropertyToRegularStyle())
            builderState.style().setBorderRightColor(builderState.parentStyle().borderRightColor());
        if (builderState.applyPropertyToVisitedLinkStyle())
            builderState.style().setVisitedLinkBorderRightColor(builderState.parentStyle().borderRightColor());
    }
    static void applyValueBorderRightColor(BuilderState& builderState, CSSValue& value)
    {
        if (builderState.applyPropertyToRegularStyle())
            builderState.style().setBorderRightColor(builderState.colorFromPrimitiveValue(fromCSSValueDeducingType(value), ForVisitedLink::No));
        if (builderState.applyPropertyToVisitedLinkStyle())
            builderState.style().setVisitedLinkBorderRightColor(builderState.colorFromPrimitiveValue(fromCSSValueDeducingType(value), ForVisitedLink::Yes));
    }
    static void applyInitialBorderRightStyle(BuilderState& builderState)
    {
        builderState.style().setBorderRightStyle(RenderStyle::initialBorderStyle());
    }
    static void applyInheritBorderRightStyle(BuilderState& builderState)
    {
        builderState.style().setBorderRightStyle(forwardInheritedValue(builderState.parentStyle().borderRightStyle()));
    }
    static void applyValueBorderRightStyle(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setBorderRightStyle(fromCSSValueDeducingType(value));
    }
    static void applyInitialBorderRightWidth(BuilderState& builderState)
    {
        builderState.style().setBorderRightWidth(RenderStyle::initialBorderWidth());
    }
    static void applyInheritBorderRightWidth(BuilderState& builderState)
    {
        builderState.style().setBorderRightWidth(forwardInheritedValue(builderState.parentStyle().borderRightWidth()));
    }
    static void applyValueBorderRightWidth(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setBorderRightWidth(BuilderConverter::convertLineWidth<float>(builderState, value));
    }
    static void applyInitialBorderTopColor(BuilderState& builderState)
    {
        if (builderState.applyPropertyToRegularStyle())
            builderState.style().setBorderTopColor(StyleColor::currentColor());
        if (builderState.applyPropertyToVisitedLinkStyle())
            builderState.style().setVisitedLinkBorderTopColor(StyleColor::currentColor());
    }
    static void applyInheritBorderTopColor(BuilderState& builderState)
    {
        if (builderState.applyPropertyToRegularStyle())
            builderState.style().setBorderTopColor(builderState.parentStyle().borderTopColor());
        if (builderState.applyPropertyToVisitedLinkStyle())
            builderState.style().setVisitedLinkBorderTopColor(builderState.parentStyle().borderTopColor());
    }
    static void applyValueBorderTopColor(BuilderState& builderState, CSSValue& value)
    {
        if (builderState.applyPropertyToRegularStyle())
            builderState.style().setBorderTopColor(builderState.colorFromPrimitiveValue(fromCSSValueDeducingType(value), ForVisitedLink::No));
        if (builderState.applyPropertyToVisitedLinkStyle())
            builderState.style().setVisitedLinkBorderTopColor(builderState.colorFromPrimitiveValue(fromCSSValueDeducingType(value), ForVisitedLink::Yes));
    }
    static void applyInitialBorderTopStyle(BuilderState& builderState)
    {
        builderState.style().setBorderTopStyle(RenderStyle::initialBorderStyle());
    }
    static void applyInheritBorderTopStyle(BuilderState& builderState)
    {
        builderState.style().setBorderTopStyle(forwardInheritedValue(builderState.parentStyle().borderTopStyle()));
    }
    static void applyValueBorderTopStyle(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setBorderTopStyle(fromCSSValueDeducingType(value));
    }
    static void applyInitialBorderTopWidth(BuilderState& builderState)
    {
        builderState.style().setBorderTopWidth(RenderStyle::initialBorderWidth());
    }
    static void applyInheritBorderTopWidth(BuilderState& builderState)
    {
        builderState.style().setBorderTopWidth(forwardInheritedValue(builderState.parentStyle().borderTopWidth()));
    }
    static void applyValueBorderTopWidth(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setBorderTopWidth(BuilderConverter::convertLineWidth<float>(builderState, value));
    }
    static void applyInitialBottom(BuilderState& builderState)
    {
        builderState.style().setBottom(RenderStyle::initialOffset());
    }
    static void applyInheritBottom(BuilderState& builderState)
    {
        builderState.style().setBottom(forwardInheritedValue(builderState.parentStyle().bottom()));
    }
    static void applyValueBottom(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setBottom(BuilderConverter::convertLengthOrAuto(builderState, value));
    }
    static void applyInitialHeight(BuilderState& builderState)
    {
        builderState.style().setHeight(RenderStyle::initialSize());
    }
    static void applyInheritHeight(BuilderState& builderState)
    {
        builderState.style().setHeight(forwardInheritedValue(builderState.parentStyle().height()));
    }
    static void applyValueHeight(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setHeight(BuilderConverter::convertLengthSizing(builderState, value));
    }
    static void applyInitialLeft(BuilderState& builderState)
    {
        builderState.style().setLeft(RenderStyle::initialOffset());
    }
    static void applyInheritLeft(BuilderState& builderState)
    {
        builderState.style().setLeft(forwardInheritedValue(builderState.parentStyle().left()));
    }
    static void applyValueLeft(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setLeft(BuilderConverter::convertLengthOrAuto(builderState, value));
    }
    static void applyInitialMarginBottom(BuilderState& builderState)
    {
        builderState.style().setMarginBottom(RenderStyle::initialMargin());
    }
    static void applyInheritMarginBottom(BuilderState& builderState)
    {
        builderState.style().setMarginBottom(forwardInheritedValue(builderState.parentStyle().marginBottom()));
    }
    static void applyValueMarginBottom(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setMarginBottom(BuilderConverter::convertLengthOrAuto(builderState, value));
    }
    static void applyInitialMarginLeft(BuilderState& builderState)
    {
        builderState.style().setMarginLeft(RenderStyle::initialMargin());
    }
    static void applyInheritMarginLeft(BuilderState& builderState)
    {
        builderState.style().setMarginLeft(forwardInheritedValue(builderState.parentStyle().marginLeft()));
    }
    static void applyValueMarginLeft(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setMarginLeft(BuilderConverter::convertLengthOrAuto(builderState, value));
    }
    static void applyInitialMarginRight(BuilderState& builderState)
    {
        builderState.style().setMarginRight(RenderStyle::initialMargin());
    }
    static void applyInheritMarginRight(BuilderState& builderState)
    {
        builderState.style().setMarginRight(forwardInheritedValue(builderState.parentStyle().marginRight()));
    }
    static void applyValueMarginRight(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setMarginRight(BuilderConverter::convertLengthOrAuto(builderState, value));
    }
    static void applyInitialMarginTop(BuilderState& builderState)
    {
        builderState.style().setMarginTop(RenderStyle::initialMargin());
    }
    static void applyInheritMarginTop(BuilderState& builderState)
    {
        builderState.style().setMarginTop(forwardInheritedValue(builderState.parentStyle().marginTop()));
    }
    static void applyValueMarginTop(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setMarginTop(BuilderConverter::convertLengthOrAuto(builderState, value));
    }
    static void applyInitialMaxHeight(BuilderState& builderState)
    {
        builderState.style().setMaxHeight(RenderStyle::initialMaxSize());
    }
    static void applyInheritMaxHeight(BuilderState& builderState)
    {
        builderState.style().setMaxHeight(forwardInheritedValue(builderState.parentStyle().maxHeight()));
    }
    static void applyValueMaxHeight(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setMaxHeight(BuilderConverter::convertLengthMaxSizing(builderState, value));
    }
    static void applyInitialMaxWidth(BuilderState& builderState)
    {
        builderState.style().setMaxWidth(RenderStyle::initialMaxSize());
    }
    static void applyInheritMaxWidth(BuilderState& builderState)
    {
        builderState.style().setMaxWidth(forwardInheritedValue(builderState.parentStyle().maxWidth()));
    }
    static void applyValueMaxWidth(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setMaxWidth(BuilderConverter::convertLengthMaxSizing(builderState, value));
    }
    static void applyInitialMinHeight(BuilderState& builderState)
    {
        builderState.style().setMinHeight(RenderStyle::initialMinSize());
    }
    static void applyInheritMinHeight(BuilderState& builderState)
    {
        builderState.style().setMinHeight(forwardInheritedValue(builderState.parentStyle().minHeight()));
    }
    static void applyValueMinHeight(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setMinHeight(BuilderConverter::convertLengthSizing(builderState, value));
    }
    static void applyInitialMinWidth(BuilderState& builderState)
    {
        builderState.style().setMinWidth(RenderStyle::initialMinSize());
    }
    static void applyInheritMinWidth(BuilderState& builderState)
    {
        builderState.style().setMinWidth(forwardInheritedValue(builderState.parentStyle().minWidth()));
    }
    static void applyValueMinWidth(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setMinWidth(BuilderConverter::convertLengthSizing(builderState, value));
    }
    static void applyInitialOverscrollBehaviorX(BuilderState& builderState)
    {
        builderState.style().setOverscrollBehaviorX(RenderStyle::initialOverscrollBehaviorX());
    }
    static void applyInheritOverscrollBehaviorX(BuilderState& builderState)
    {
        builderState.style().setOverscrollBehaviorX(forwardInheritedValue(builderState.parentStyle().overscrollBehaviorX()));
    }
    static void applyValueOverscrollBehaviorX(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setOverscrollBehaviorX(fromCSSValueDeducingType(value));
    }
    static void applyInitialOverscrollBehaviorY(BuilderState& builderState)
    {
        builderState.style().setOverscrollBehaviorY(RenderStyle::initialOverscrollBehaviorY());
    }
    static void applyInheritOverscrollBehaviorY(BuilderState& builderState)
    {
        builderState.style().setOverscrollBehaviorY(forwardInheritedValue(builderState.parentStyle().overscrollBehaviorY()));
    }
    static void applyValueOverscrollBehaviorY(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setOverscrollBehaviorY(fromCSSValueDeducingType(value));
    }
    static void applyInitialPaddingBottom(BuilderState& builderState)
    {
        builderState.style().setPaddingBottom(RenderStyle::initialPadding());
    }
    static void applyInheritPaddingBottom(BuilderState& builderState)
    {
        builderState.style().setPaddingBottom(forwardInheritedValue(builderState.parentStyle().paddingBottom()));
    }
    static void applyValuePaddingBottom(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setPaddingBottom(BuilderConverter::convertLength(builderState, value));
    }
    static void applyInitialPaddingLeft(BuilderState& builderState)
    {
        builderState.style().setPaddingLeft(RenderStyle::initialPadding());
    }
    static void applyInheritPaddingLeft(BuilderState& builderState)
    {
        builderState.style().setPaddingLeft(forwardInheritedValue(builderState.parentStyle().paddingLeft()));
    }
    static void applyValuePaddingLeft(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setPaddingLeft(BuilderConverter::convertLength(builderState, value));
    }
    static void applyInitialPaddingRight(BuilderState& builderState)
    {
        builderState.style().setPaddingRight(RenderStyle::initialPadding());
    }
    static void applyInheritPaddingRight(BuilderState& builderState)
    {
        builderState.style().setPaddingRight(forwardInheritedValue(builderState.parentStyle().paddingRight()));
    }
    static void applyValuePaddingRight(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setPaddingRight(BuilderConverter::convertLength(builderState, value));
    }
    static void applyInitialPaddingTop(BuilderState& builderState)
    {
        builderState.style().setPaddingTop(RenderStyle::initialPadding());
    }
    static void applyInheritPaddingTop(BuilderState& builderState)
    {
        builderState.style().setPaddingTop(forwardInheritedValue(builderState.parentStyle().paddingTop()));
    }
    static void applyValuePaddingTop(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setPaddingTop(BuilderConverter::convertLength(builderState, value));
    }
    static void applyInitialRight(BuilderState& builderState)
    {
        builderState.style().setRight(RenderStyle::initialOffset());
    }
    static void applyInheritRight(BuilderState& builderState)
    {
        builderState.style().setRight(forwardInheritedValue(builderState.parentStyle().right()));
    }
    static void applyValueRight(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setRight(BuilderConverter::convertLengthOrAuto(builderState, value));
    }
    static void applyInitialScrollMarginBottom(BuilderState& builderState)
    {
        builderState.style().setScrollMarginBottom(RenderStyle::initialScrollMargin());
    }
    static void applyInheritScrollMarginBottom(BuilderState& builderState)
    {
        builderState.style().setScrollMarginBottom(forwardInheritedValue(builderState.parentStyle().scrollMarginBottom()));
    }
    static void applyValueScrollMarginBottom(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setScrollMarginBottom(BuilderConverter::convertLength(builderState, value));
    }
    static void applyInitialScrollMarginLeft(BuilderState& builderState)
    {
        builderState.style().setScrollMarginLeft(RenderStyle::initialScrollMargin());
    }
    static void applyInheritScrollMarginLeft(BuilderState& builderState)
    {
        builderState.style().setScrollMarginLeft(forwardInheritedValue(builderState.parentStyle().scrollMarginLeft()));
    }
    static void applyValueScrollMarginLeft(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setScrollMarginLeft(BuilderConverter::convertLength(builderState, value));
    }
    static void applyInitialScrollMarginRight(BuilderState& builderState)
    {
        builderState.style().setScrollMarginRight(RenderStyle::initialScrollMargin());
    }
    static void applyInheritScrollMarginRight(BuilderState& builderState)
    {
        builderState.style().setScrollMarginRight(forwardInheritedValue(builderState.parentStyle().scrollMarginRight()));
    }
    static void applyValueScrollMarginRight(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setScrollMarginRight(BuilderConverter::convertLength(builderState, value));
    }
    static void applyInitialScrollMarginTop(BuilderState& builderState)
    {
        builderState.style().setScrollMarginTop(RenderStyle::initialScrollMargin());
    }
    static void applyInheritScrollMarginTop(BuilderState& builderState)
    {
        builderState.style().setScrollMarginTop(forwardInheritedValue(builderState.parentStyle().scrollMarginTop()));
    }
    static void applyValueScrollMarginTop(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setScrollMarginTop(BuilderConverter::convertLength(builderState, value));
    }
    static void applyInitialScrollPaddingBottom(BuilderState& builderState)
    {
        builderState.style().setScrollPaddingBottom(RenderStyle::initialScrollPadding());
    }
    static void applyInheritScrollPaddingBottom(BuilderState& builderState)
    {
        builderState.style().setScrollPaddingBottom(forwardInheritedValue(builderState.parentStyle().scrollPaddingBottom()));
    }
    static void applyValueScrollPaddingBottom(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setScrollPaddingBottom(BuilderConverter::convertLengthOrAuto(builderState, value));
    }
    static void applyInitialScrollPaddingLeft(BuilderState& builderState)
    {
        builderState.style().setScrollPaddingLeft(RenderStyle::initialScrollPadding());
    }
    static void applyInheritScrollPaddingLeft(BuilderState& builderState)
    {
        builderState.style().setScrollPaddingLeft(forwardInheritedValue(builderState.parentStyle().scrollPaddingLeft()));
    }
    static void applyValueScrollPaddingLeft(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setScrollPaddingLeft(BuilderConverter::convertLengthOrAuto(builderState, value));
    }
    static void applyInitialScrollPaddingRight(BuilderState& builderState)
    {
        builderState.style().setScrollPaddingRight(RenderStyle::initialScrollPadding());
    }
    static void applyInheritScrollPaddingRight(BuilderState& builderState)
    {
        builderState.style().setScrollPaddingRight(forwardInheritedValue(builderState.parentStyle().scrollPaddingRight()));
    }
    static void applyValueScrollPaddingRight(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setScrollPaddingRight(BuilderConverter::convertLengthOrAuto(builderState, value));
    }
    static void applyInitialScrollPaddingTop(BuilderState& builderState)
    {
        builderState.style().setScrollPaddingTop(RenderStyle::initialScrollPadding());
    }
    static void applyInheritScrollPaddingTop(BuilderState& builderState)
    {
        builderState.style().setScrollPaddingTop(forwardInheritedValue(builderState.parentStyle().scrollPaddingTop()));
    }
    static void applyValueScrollPaddingTop(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setScrollPaddingTop(BuilderConverter::convertLengthOrAuto(builderState, value));
    }
    static void applyInitialTop(BuilderState& builderState)
    {
        builderState.style().setTop(RenderStyle::initialOffset());
    }
    static void applyInheritTop(BuilderState& builderState)
    {
        builderState.style().setTop(forwardInheritedValue(builderState.parentStyle().top()));
    }
    static void applyValueTop(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setTop(BuilderConverter::convertLengthOrAuto(builderState, value));
    }
    static void applyInitialWidth(BuilderState& builderState)
    {
        builderState.style().setWidth(RenderStyle::initialSize());
    }
    static void applyInheritWidth(BuilderState& builderState)
    {
        builderState.style().setWidth(forwardInheritedValue(builderState.parentStyle().width()));
    }
    static void applyValueWidth(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setWidth(BuilderConverter::convertLengthSizing(builderState, value));
    }
};

void BuilderGenerated::applyProperty(CSSPropertyID id, BuilderState& builderState, CSSValue& value, ApplyValueType valueType)
{
    switch (id) {
    case CSSPropertyID::CSSPropertyInvalid:
        break;
    case CSSPropertyID::CSSPropertyCustom:
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyID::CSSPropertyColorScheme:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialColorScheme(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritColorScheme(builderState);
            break;
        case ApplyValueType::Value:
            BuilderCustom::applyValueColorScheme(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyRubyPosition:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialRubyPosition(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritRubyPosition(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueRubyPosition(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyWritingMode:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialWritingMode(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritWritingMode(builderState);
            break;
        case ApplyValueType::Value:
            BuilderCustom::applyValueWritingMode(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyColor:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderCustom::applyInitialColor(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderCustom::applyInheritColor(builderState);
            break;
        case ApplyValueType::Value:
            BuilderCustom::applyValueColor(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyDirection:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialDirection(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritDirection(builderState);
            break;
        case ApplyValueType::Value:
            BuilderCustom::applyValueDirection(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyDisplay:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialDisplay(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritDisplay(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueDisplay(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyFontFamily:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderCustom::applyInitialFontFamily(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderCustom::applyInheritFontFamily(builderState);
            break;
        case ApplyValueType::Value:
            BuilderCustom::applyValueFontFamily(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyFontFeatureSettings:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderCustom::applyInitialFontFeatureSettings(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderCustom::applyInheritFontFeatureSettings(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueFontFeatureSettings(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyFontKerning:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialFontKerning(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritFontKerning(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueFontKerning(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyFontOpticalSizing:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialFontOpticalSizing(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritFontOpticalSizing(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueFontOpticalSizing(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyFontPalette:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialFontPalette(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritFontPalette(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueFontPalette(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyFontSize:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderCustom::applyInitialFontSize(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderCustom::applyInheritFontSize(builderState);
            break;
        case ApplyValueType::Value:
            BuilderCustom::applyValueFontSize(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyFontSizeAdjust:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialFontSizeAdjust(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritFontSizeAdjust(builderState);
            break;
        case ApplyValueType::Value:
            BuilderCustom::applyValueFontSizeAdjust(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyFontStretch:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialFontStretch(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritFontStretch(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueFontStretch(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyFontStyle:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderCustom::applyInitialFontStyle(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderCustom::applyInheritFontStyle(builderState);
            break;
        case ApplyValueType::Value:
            BuilderCustom::applyValueFontStyle(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyFontSynthesisSmallCaps:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialFontSynthesisSmallCaps(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritFontSynthesisSmallCaps(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueFontSynthesisSmallCaps(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyFontSynthesisStyle:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialFontSynthesisStyle(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritFontSynthesisStyle(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueFontSynthesisStyle(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyFontSynthesisWeight:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialFontSynthesisWeight(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritFontSynthesisWeight(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueFontSynthesisWeight(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyFontVariantAlternates:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderCustom::applyInitialFontVariantAlternates(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderCustom::applyInheritFontVariantAlternates(builderState);
            break;
        case ApplyValueType::Value:
            BuilderCustom::applyValueFontVariantAlternates(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyFontVariantCaps:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialFontVariantCaps(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritFontVariantCaps(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueFontVariantCaps(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyFontVariantEastAsian:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderCustom::applyInitialFontVariantEastAsian(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderCustom::applyInheritFontVariantEastAsian(builderState);
            break;
        case ApplyValueType::Value:
            BuilderCustom::applyValueFontVariantEastAsian(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyFontVariantEmoji:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialFontVariantEmoji(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritFontVariantEmoji(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueFontVariantEmoji(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyFontVariantLigatures:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderCustom::applyInitialFontVariantLigatures(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderCustom::applyInheritFontVariantLigatures(builderState);
            break;
        case ApplyValueType::Value:
            BuilderCustom::applyValueFontVariantLigatures(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyFontVariantNumeric:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderCustom::applyInitialFontVariantNumeric(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderCustom::applyInheritFontVariantNumeric(builderState);
            break;
        case ApplyValueType::Value:
            BuilderCustom::applyValueFontVariantNumeric(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyFontVariantPosition:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialFontVariantPosition(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritFontVariantPosition(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueFontVariantPosition(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyFontVariationSettings:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderCustom::applyInitialFontVariationSettings(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderCustom::applyInheritFontVariationSettings(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueFontVariationSettings(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyFontWeight:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialFontWeight(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritFontWeight(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueFontWeight(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyTextOrientation:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialTextOrientation(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritTextOrientation(builderState);
            break;
        case ApplyValueType::Value:
            BuilderCustom::applyValueTextOrientation(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyTextRendering:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialTextRendering(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritTextRendering(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueTextRendering(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyZoom:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderCustom::applyInitialZoom(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderCustom::applyInheritZoom(builderState);
            break;
        case ApplyValueType::Value:
            BuilderCustom::applyValueZoom(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyWebkitFontSmoothing:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialWebkitFontSmoothing(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritWebkitFontSmoothing(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueWebkitFontSmoothing(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyWebkitLocale:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialWebkitLocale(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritWebkitLocale(builderState);
            break;
        case ApplyValueType::Value:
            BuilderCustom::applyValueWebkitLocale(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyWebkitTextZoom:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialWebkitTextZoom(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritWebkitTextZoom(builderState);
            break;
        case ApplyValueType::Value:
            BuilderCustom::applyValueWebkitTextZoom(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyLetterSpacing:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderCustom::applyInitialLetterSpacing(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderCustom::applyInheritLetterSpacing(builderState);
            break;
        case ApplyValueType::Value:
            BuilderCustom::applyValueLetterSpacing(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyTextAutospace:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialTextAutospace(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritTextAutospace(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueTextAutospace(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyTextSpacingTrim:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialTextSpacingTrim(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritTextSpacingTrim(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueTextSpacingTrim(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyAccentColor:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialAccentColor(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritAccentColor(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueAccentColor(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyAdditiveSymbols:
        break;
    case CSSPropertyID::CSSPropertyAlignContent:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialAlignContent(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritAlignContent(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueAlignContent(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyAlignItems:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialAlignItems(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritAlignItems(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueAlignItems(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyAlignSelf:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialAlignSelf(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritAlignSelf(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueAlignSelf(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyAlignmentBaseline:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialAlignmentBaseline(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritAlignmentBaseline(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueAlignmentBaseline(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyAnchorName:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialAnchorName(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritAnchorName(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueAnchorName(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyAnimationComposition:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialAnimationComposition(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritAnimationComposition(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueAnimationComposition(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyAnimationDelay:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialAnimationDelay(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritAnimationDelay(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueAnimationDelay(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyAnimationDirection:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialAnimationDirection(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritAnimationDirection(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueAnimationDirection(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyAnimationDuration:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialAnimationDuration(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritAnimationDuration(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueAnimationDuration(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyAnimationFillMode:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialAnimationFillMode(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritAnimationFillMode(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueAnimationFillMode(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyAnimationIterationCount:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialAnimationIterationCount(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritAnimationIterationCount(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueAnimationIterationCount(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyAnimationName:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialAnimationName(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritAnimationName(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueAnimationName(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyAnimationPlayState:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialAnimationPlayState(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritAnimationPlayState(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueAnimationPlayState(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyAnimationTimeline:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialAnimationTimeline(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritAnimationTimeline(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueAnimationTimeline(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyAnimationTimingFunction:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialAnimationTimingFunction(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritAnimationTimingFunction(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueAnimationTimingFunction(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyAppearance:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialAppearance(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritAppearance(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueAppearance(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyAspectRatio:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderCustom::applyInitialAspectRatio(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderCustom::applyInheritAspectRatio(builderState);
            break;
        case ApplyValueType::Value:
            BuilderCustom::applyValueAspectRatio(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyBackdropFilter:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialBackdropFilter(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritBackdropFilter(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueBackdropFilter(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyBackfaceVisibility:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialBackfaceVisibility(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritBackfaceVisibility(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueBackfaceVisibility(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyBackgroundAttachment:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialBackgroundAttachment(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritBackgroundAttachment(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueBackgroundAttachment(id, builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyBackgroundBlendMode:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialBackgroundBlendMode(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritBackgroundBlendMode(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueBackgroundBlendMode(id, builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyBackgroundClip:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialBackgroundClip(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritBackgroundClip(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueBackgroundClip(id, builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyBackgroundColor:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialBackgroundColor(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritBackgroundColor(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueBackgroundColor(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyBackgroundImage:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialBackgroundImage(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritBackgroundImage(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueBackgroundImage(id, builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyBackgroundOrigin:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialBackgroundOrigin(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritBackgroundOrigin(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueBackgroundOrigin(id, builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyBackgroundPositionX:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialBackgroundPositionX(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritBackgroundPositionX(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueBackgroundPositionX(id, builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyBackgroundPositionY:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialBackgroundPositionY(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritBackgroundPositionY(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueBackgroundPositionY(id, builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyBackgroundRepeat:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialBackgroundRepeat(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritBackgroundRepeat(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueBackgroundRepeat(id, builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyBackgroundSize:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialBackgroundSize(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritBackgroundSize(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueBackgroundSize(id, builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyBasePalette:
        break;
    case CSSPropertyID::CSSPropertyBaselineShift:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialBaselineShift(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderCustom::applyInheritBaselineShift(builderState);
            break;
        case ApplyValueType::Value:
            BuilderCustom::applyValueBaselineShift(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyBlockStepInsert:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialBlockStepInsert(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritBlockStepInsert(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueBlockStepInsert(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyBlockStepSize:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialBlockStepSize(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritBlockStepSize(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueBlockStepSize(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyBorderCollapse:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialBorderCollapse(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritBorderCollapse(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueBorderCollapse(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyBorderImageOutset:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderCustom::applyInitialBorderImageOutset(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderCustom::applyInheritBorderImageOutset(builderState);
            break;
        case ApplyValueType::Value:
            BuilderCustom::applyValueBorderImageOutset(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyBorderImageRepeat:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderCustom::applyInitialBorderImageRepeat(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderCustom::applyInheritBorderImageRepeat(builderState);
            break;
        case ApplyValueType::Value:
            BuilderCustom::applyValueBorderImageRepeat(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyBorderImageSlice:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderCustom::applyInitialBorderImageSlice(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderCustom::applyInheritBorderImageSlice(builderState);
            break;
        case ApplyValueType::Value:
            BuilderCustom::applyValueBorderImageSlice(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyBorderImageSource:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialBorderImageSource(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritBorderImageSource(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueBorderImageSource(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyBorderImageWidth:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderCustom::applyInitialBorderImageWidth(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderCustom::applyInheritBorderImageWidth(builderState);
            break;
        case ApplyValueType::Value:
            BuilderCustom::applyValueBorderImageWidth(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyBoxShadow:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderCustom::applyInitialBoxShadow(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderCustom::applyInheritBoxShadow(builderState);
            break;
        case ApplyValueType::Value:
            BuilderCustom::applyValueBoxShadow(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyBoxSizing:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialBoxSizing(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritBoxSizing(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueBoxSizing(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyBreakAfter:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialBreakAfter(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritBreakAfter(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueBreakAfter(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyBreakBefore:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialBreakBefore(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritBreakBefore(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueBreakBefore(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyBreakInside:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialBreakInside(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritBreakInside(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueBreakInside(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyBufferedRendering:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialBufferedRendering(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritBufferedRendering(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueBufferedRendering(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyCaptionSide:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialCaptionSide(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritCaptionSide(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueCaptionSide(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyCaretColor:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderCustom::applyInitialCaretColor(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderCustom::applyInheritCaretColor(builderState);
            break;
        case ApplyValueType::Value:
            BuilderCustom::applyValueCaretColor(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyClear:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialClear(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritClear(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueClear(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyClip:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderCustom::applyInitialClip(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderCustom::applyInheritClip(builderState);
            break;
        case ApplyValueType::Value:
            BuilderCustom::applyValueClip(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyClipPath:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialClipPath(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritClipPath(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueClipPath(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyClipRule:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialClipRule(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritClipRule(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueClipRule(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyColorInterpolation:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialColorInterpolation(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritColorInterpolation(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueColorInterpolation(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyColorInterpolationFilters:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialColorInterpolationFilters(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritColorInterpolationFilters(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueColorInterpolationFilters(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyColumnCount:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialColumnCount(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritColumnCount(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueColumnCount(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyColumnFill:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialColumnFill(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritColumnFill(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueColumnFill(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyColumnGap:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialColumnGap(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritColumnGap(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueColumnGap(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyColumnRuleColor:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialColumnRuleColor(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritColumnRuleColor(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueColumnRuleColor(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyColumnRuleStyle:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialColumnRuleStyle(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritColumnRuleStyle(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueColumnRuleStyle(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyColumnRuleWidth:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialColumnRuleWidth(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritColumnRuleWidth(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueColumnRuleWidth(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyColumnSpan:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialColumnSpan(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritColumnSpan(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueColumnSpan(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyColumnWidth:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialColumnWidth(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritColumnWidth(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueColumnWidth(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyContain:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialContain(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritContain(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueContain(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyContainerName:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialContainerName(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritContainerName(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueContainerName(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyContainerType:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialContainerType(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritContainerType(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueContainerType(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyContent:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderCustom::applyInitialContent(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderCustom::applyInheritContent(builderState);
            break;
        case ApplyValueType::Value:
            BuilderCustom::applyValueContent(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyContentVisibility:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialContentVisibility(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritContentVisibility(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueContentVisibility(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyCounterIncrement:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderCustom::applyInitialCounterIncrement(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderCustom::applyInheritCounterIncrement(builderState);
            break;
        case ApplyValueType::Value:
            BuilderCustom::applyValueCounterIncrement(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyCounterReset:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderCustom::applyInitialCounterReset(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderCustom::applyInheritCounterReset(builderState);
            break;
        case ApplyValueType::Value:
            BuilderCustom::applyValueCounterReset(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyCounterSet:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderCustom::applyInitialCounterSet(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderCustom::applyInheritCounterSet(builderState);
            break;
        case ApplyValueType::Value:
            BuilderCustom::applyValueCounterSet(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyCursor:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderCustom::applyInitialCursor(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderCustom::applyInheritCursor(builderState);
            break;
        case ApplyValueType::Value:
            BuilderCustom::applyValueCursor(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyCx:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialCx(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritCx(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueCx(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyCy:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialCy(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritCy(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueCy(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyD:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialD(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritD(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueD(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyDominantBaseline:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialDominantBaseline(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritDominantBaseline(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueDominantBaseline(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyEmptyCells:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialEmptyCells(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritEmptyCells(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueEmptyCells(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyFallback:
        break;
    case CSSPropertyID::CSSPropertyFieldSizing:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialFieldSizing(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritFieldSizing(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueFieldSizing(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyFill:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderCustom::applyInitialFill(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderCustom::applyInheritFill(builderState);
            break;
        case ApplyValueType::Value:
            BuilderCustom::applyValueFill(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyFillOpacity:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialFillOpacity(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritFillOpacity(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueFillOpacity(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyFillRule:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialFillRule(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritFillRule(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueFillRule(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyFilter:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialFilter(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritFilter(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueFilter(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyFlexBasis:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialFlexBasis(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritFlexBasis(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueFlexBasis(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyFlexDirection:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialFlexDirection(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritFlexDirection(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueFlexDirection(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyFlexGrow:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialFlexGrow(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritFlexGrow(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueFlexGrow(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyFlexShrink:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialFlexShrink(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritFlexShrink(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueFlexShrink(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyFlexWrap:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialFlexWrap(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritFlexWrap(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueFlexWrap(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyFloat:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialFloat(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritFloat(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueFloat(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyFloodColor:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialFloodColor(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritFloodColor(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueFloodColor(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyFloodOpacity:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialFloodOpacity(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritFloodOpacity(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueFloodOpacity(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyFontDisplay:
        break;
    case CSSPropertyID::CSSPropertyGlyphOrientationHorizontal:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialGlyphOrientationHorizontal(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritGlyphOrientationHorizontal(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueGlyphOrientationHorizontal(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyGlyphOrientationVertical:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialGlyphOrientationVertical(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritGlyphOrientationVertical(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueGlyphOrientationVertical(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyGridAutoColumns:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialGridAutoColumns(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritGridAutoColumns(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueGridAutoColumns(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyGridAutoFlow:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialGridAutoFlow(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritGridAutoFlow(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueGridAutoFlow(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyGridAutoRows:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialGridAutoRows(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritGridAutoRows(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueGridAutoRows(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyGridColumnEnd:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialGridColumnEnd(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritGridColumnEnd(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueGridColumnEnd(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyGridColumnStart:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialGridColumnStart(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritGridColumnStart(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueGridColumnStart(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyGridRowEnd:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialGridRowEnd(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritGridRowEnd(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueGridRowEnd(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyGridRowStart:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialGridRowStart(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritGridRowStart(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueGridRowStart(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyGridTemplateAreas:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderCustom::applyInitialGridTemplateAreas(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderCustom::applyInheritGridTemplateAreas(builderState);
            break;
        case ApplyValueType::Value:
            BuilderCustom::applyValueGridTemplateAreas(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyGridTemplateColumns:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderCustom::applyInitialGridTemplateColumns(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderCustom::applyInheritGridTemplateColumns(builderState);
            break;
        case ApplyValueType::Value:
            BuilderCustom::applyValueGridTemplateColumns(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyGridTemplateRows:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderCustom::applyInitialGridTemplateRows(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderCustom::applyInheritGridTemplateRows(builderState);
            break;
        case ApplyValueType::Value:
            BuilderCustom::applyValueGridTemplateRows(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyHangingPunctuation:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialHangingPunctuation(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritHangingPunctuation(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueHangingPunctuation(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyHyphenateCharacter:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialHyphenateCharacter(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritHyphenateCharacter(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueHyphenateCharacter(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyHyphens:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialHyphens(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritHyphens(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueHyphens(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyImageOrientation:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialImageOrientation(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritImageOrientation(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueImageOrientation(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyImageRendering:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialImageRendering(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritImageRendering(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueImageRendering(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyInherits:
        break;
    case CSSPropertyID::CSSPropertyInitialValue:
        break;
    case CSSPropertyID::CSSPropertyInputSecurity:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialInputSecurity(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritInputSecurity(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueInputSecurity(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyIsolation:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialIsolation(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritIsolation(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueIsolation(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyJustifyContent:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialJustifyContent(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritJustifyContent(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueJustifyContent(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyJustifyItems:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialJustifyItems(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritJustifyItems(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueJustifyItems(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyJustifySelf:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialJustifySelf(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritJustifySelf(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueJustifySelf(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyKerning:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialKerning(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritKerning(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueKerning(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyLightingColor:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialLightingColor(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritLightingColor(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueLightingColor(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyLineBreak:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialLineBreak(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritLineBreak(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueLineBreak(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyLineFitEdge:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialLineFitEdge(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritLineFitEdge(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueLineFitEdge(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyLineHeight:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialLineHeight(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritLineHeight(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueLineHeight(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyListStyleImage:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialListStyleImage(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritListStyleImage(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueListStyleImage(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyListStylePosition:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialListStylePosition(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritListStylePosition(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueListStylePosition(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyListStyleType:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialListStyleType(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritListStyleType(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueListStyleType(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyMarginTrim:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialMarginTrim(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritMarginTrim(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueMarginTrim(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyMarkerEnd:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialMarkerEnd(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritMarkerEnd(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueMarkerEnd(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyMarkerMid:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialMarkerMid(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritMarkerMid(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueMarkerMid(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyMarkerStart:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialMarkerStart(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritMarkerStart(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueMarkerStart(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyMaskBorderOutset:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderCustom::applyInitialMaskBorderOutset(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderCustom::applyInheritMaskBorderOutset(builderState);
            break;
        case ApplyValueType::Value:
            BuilderCustom::applyValueMaskBorderOutset(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyMaskBorderRepeat:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderCustom::applyInitialMaskBorderRepeat(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderCustom::applyInheritMaskBorderRepeat(builderState);
            break;
        case ApplyValueType::Value:
            BuilderCustom::applyValueMaskBorderRepeat(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyMaskBorderSlice:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderCustom::applyInitialMaskBorderSlice(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderCustom::applyInheritMaskBorderSlice(builderState);
            break;
        case ApplyValueType::Value:
            BuilderCustom::applyValueMaskBorderSlice(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyMaskBorderSource:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialMaskBorderSource(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritMaskBorderSource(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueMaskBorderSource(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyMaskBorderWidth:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderCustom::applyInitialMaskBorderWidth(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderCustom::applyInheritMaskBorderWidth(builderState);
            break;
        case ApplyValueType::Value:
            BuilderCustom::applyValueMaskBorderWidth(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyMaskClip:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialMaskClip(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritMaskClip(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueMaskClip(id, builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyMaskComposite:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialMaskComposite(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritMaskComposite(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueMaskComposite(id, builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyMaskImage:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialMaskImage(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritMaskImage(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueMaskImage(id, builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyMaskMode:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialMaskMode(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritMaskMode(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueMaskMode(id, builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyMaskOrigin:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialMaskOrigin(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritMaskOrigin(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueMaskOrigin(id, builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyMaskRepeat:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialMaskRepeat(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritMaskRepeat(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueMaskRepeat(id, builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyMaskSize:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialMaskSize(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritMaskSize(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueMaskSize(id, builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyMaskType:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialMaskType(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritMaskType(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueMaskType(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyMasonryAutoFlow:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialMasonryAutoFlow(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritMasonryAutoFlow(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueMasonryAutoFlow(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyMathStyle:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialMathStyle(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritMathStyle(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueMathStyle(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyMixBlendMode:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialMixBlendMode(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritMixBlendMode(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueMixBlendMode(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyNavigation:
        break;
    case CSSPropertyID::CSSPropertyNegative:
        break;
    case CSSPropertyID::CSSPropertyObjectFit:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialObjectFit(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritObjectFit(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueObjectFit(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyObjectPosition:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialObjectPosition(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritObjectPosition(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueObjectPosition(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyOffsetAnchor:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialOffsetAnchor(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritOffsetAnchor(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueOffsetAnchor(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyOffsetDistance:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialOffsetDistance(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritOffsetDistance(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueOffsetDistance(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyOffsetPath:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialOffsetPath(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritOffsetPath(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueOffsetPath(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyOffsetPosition:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialOffsetPosition(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritOffsetPosition(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueOffsetPosition(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyOffsetRotate:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialOffsetRotate(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritOffsetRotate(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueOffsetRotate(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyOpacity:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialOpacity(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritOpacity(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueOpacity(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyOrder:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialOrder(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritOrder(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueOrder(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyOrphans:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialOrphans(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritOrphans(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueOrphans(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyOutlineColor:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialOutlineColor(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritOutlineColor(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueOutlineColor(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyOutlineOffset:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialOutlineOffset(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritOutlineOffset(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueOutlineOffset(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyOutlineStyle:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderCustom::applyInitialOutlineStyle(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderCustom::applyInheritOutlineStyle(builderState);
            break;
        case ApplyValueType::Value:
            BuilderCustom::applyValueOutlineStyle(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyOutlineWidth:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialOutlineWidth(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritOutlineWidth(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueOutlineWidth(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyOverflowAnchor:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialOverflowAnchor(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritOverflowAnchor(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueOverflowAnchor(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyOverflowWrap:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialOverflowWrap(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritOverflowWrap(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueOverflowWrap(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyOverflowX:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialOverflowX(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritOverflowX(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueOverflowX(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyOverflowY:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialOverflowY(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritOverflowY(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueOverflowY(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyOverrideColors:
        break;
    case CSSPropertyID::CSSPropertyPad:
        break;
    case CSSPropertyID::CSSPropertyPage:
        break;
    case CSSPropertyID::CSSPropertyPaintOrder:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialPaintOrder(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritPaintOrder(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValuePaintOrder(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyPerspective:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialPerspective(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritPerspective(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValuePerspective(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyPerspectiveOriginX:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialPerspectiveOriginX(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritPerspectiveOriginX(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValuePerspectiveOriginX(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyPerspectiveOriginY:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialPerspectiveOriginY(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritPerspectiveOriginY(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValuePerspectiveOriginY(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyPointerEvents:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialPointerEvents(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritPointerEvents(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValuePointerEvents(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyPosition:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialPosition(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritPosition(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValuePosition(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyPositionAnchor:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialPositionAnchor(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritPositionAnchor(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValuePositionAnchor(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyPrefix:
        break;
    case CSSPropertyID::CSSPropertyPrintColorAdjust:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialPrintColorAdjust(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritPrintColorAdjust(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValuePrintColorAdjust(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyQuotes:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialQuotes(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritQuotes(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueQuotes(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyR:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialR(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritR(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueR(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyRange:
        break;
    case CSSPropertyID::CSSPropertyResize:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialResize(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritResize(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueResize(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyRotate:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialRotate(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritRotate(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueRotate(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyRowGap:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialRowGap(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritRowGap(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueRowGap(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyRubyAlign:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialRubyAlign(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritRubyAlign(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueRubyAlign(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyRx:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialRx(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritRx(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueRx(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyRy:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialRy(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritRy(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueRy(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyScale:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialScale(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritScale(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueScale(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyScrollBehavior:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialScrollBehavior(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritScrollBehavior(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueScrollBehavior(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyScrollSnapAlign:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialScrollSnapAlign(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritScrollSnapAlign(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueScrollSnapAlign(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyScrollSnapStop:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialScrollSnapStop(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritScrollSnapStop(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueScrollSnapStop(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyScrollSnapType:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialScrollSnapType(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritScrollSnapType(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueScrollSnapType(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyScrollTimelineAxis:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialScrollTimelineAxis(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritScrollTimelineAxis(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueScrollTimelineAxis(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyScrollTimelineName:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialScrollTimelineName(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritScrollTimelineName(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueScrollTimelineName(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyScrollbarColor:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialScrollbarColor(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritScrollbarColor(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueScrollbarColor(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyScrollbarGutter:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialScrollbarGutter(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritScrollbarGutter(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueScrollbarGutter(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyScrollbarWidth:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialScrollbarWidth(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritScrollbarWidth(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueScrollbarWidth(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyShapeImageThreshold:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialShapeImageThreshold(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritShapeImageThreshold(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueShapeImageThreshold(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyShapeMargin:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialShapeMargin(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritShapeMargin(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueShapeMargin(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyShapeOutside:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialShapeOutside(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritShapeOutside(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueShapeOutside(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyShapeRendering:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialShapeRendering(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritShapeRendering(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueShapeRendering(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertySize:
        break;
    case CSSPropertyID::CSSPropertySizeAdjust:
        break;
    case CSSPropertyID::CSSPropertySpeakAs:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialSpeakAs(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritSpeakAs(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueSpeakAs(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertySrc:
        break;
    case CSSPropertyID::CSSPropertyStopColor:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialStopColor(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritStopColor(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueStopColor(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyStopOpacity:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialStopOpacity(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritStopOpacity(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueStopOpacity(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyStroke:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderCustom::applyInitialStroke(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderCustom::applyInheritStroke(builderState);
            break;
        case ApplyValueType::Value:
            BuilderCustom::applyValueStroke(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyStrokeColor:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialStrokeColor(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritStrokeColor(builderState);
            break;
        case ApplyValueType::Value:
            BuilderCustom::applyValueStrokeColor(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyStrokeDasharray:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialStrokeDasharray(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritStrokeDasharray(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueStrokeDasharray(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyStrokeDashoffset:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialStrokeDashoffset(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritStrokeDashoffset(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueStrokeDashoffset(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyStrokeLinecap:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialStrokeLinecap(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritStrokeLinecap(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueStrokeLinecap(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyStrokeLinejoin:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialStrokeLinejoin(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritStrokeLinejoin(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueStrokeLinejoin(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyStrokeMiterlimit:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialStrokeMiterlimit(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritStrokeMiterlimit(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueStrokeMiterlimit(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyStrokeOpacity:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialStrokeOpacity(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritStrokeOpacity(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueStrokeOpacity(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyStrokeWidth:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialStrokeWidth(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritStrokeWidth(builderState);
            break;
        case ApplyValueType::Value:
            BuilderCustom::applyValueStrokeWidth(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertySuffix:
        break;
    case CSSPropertyID::CSSPropertySymbols:
        break;
    case CSSPropertyID::CSSPropertySyntax:
        break;
    case CSSPropertyID::CSSPropertySystem:
        break;
    case CSSPropertyID::CSSPropertyTabSize:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialTabSize(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritTabSize(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueTabSize(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyTableLayout:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialTableLayout(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritTableLayout(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueTableLayout(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyTextAlign:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialTextAlign(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritTextAlign(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueTextAlign(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyTextAlignLast:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialTextAlignLast(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritTextAlignLast(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueTextAlignLast(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyTextAnchor:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialTextAnchor(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritTextAnchor(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueTextAnchor(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyTextBoxEdge:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialTextBoxEdge(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritTextBoxEdge(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueTextBoxEdge(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyTextBoxTrim:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialTextBoxTrim(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritTextBoxTrim(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueTextBoxTrim(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyTextCombineUpright:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialTextCombineUpright(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritTextCombineUpright(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueTextCombineUpright(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyTextDecorationColor:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialTextDecorationColor(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritTextDecorationColor(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueTextDecorationColor(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyTextDecorationLine:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialTextDecorationLine(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritTextDecorationLine(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueTextDecorationLine(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyTextDecorationSkipInk:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialTextDecorationSkipInk(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritTextDecorationSkipInk(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueTextDecorationSkipInk(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyTextDecorationStyle:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialTextDecorationStyle(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritTextDecorationStyle(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueTextDecorationStyle(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyTextDecorationThickness:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialTextDecorationThickness(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritTextDecorationThickness(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueTextDecorationThickness(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyTextEmphasisColor:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialTextEmphasisColor(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritTextEmphasisColor(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueTextEmphasisColor(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyTextEmphasisPosition:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialTextEmphasisPosition(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritTextEmphasisPosition(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueTextEmphasisPosition(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyTextEmphasisStyle:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderCustom::applyInitialTextEmphasisStyle(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderCustom::applyInheritTextEmphasisStyle(builderState);
            break;
        case ApplyValueType::Value:
            BuilderCustom::applyValueTextEmphasisStyle(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyTextGroupAlign:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialTextGroupAlign(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritTextGroupAlign(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueTextGroupAlign(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyTextIndent:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderCustom::applyInitialTextIndent(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderCustom::applyInheritTextIndent(builderState);
            break;
        case ApplyValueType::Value:
            BuilderCustom::applyValueTextIndent(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyTextJustify:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialTextJustify(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritTextJustify(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueTextJustify(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyTextOverflow:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialTextOverflow(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritTextOverflow(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueTextOverflow(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyTextShadow:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderCustom::applyInitialTextShadow(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderCustom::applyInheritTextShadow(builderState);
            break;
        case ApplyValueType::Value:
            BuilderCustom::applyValueTextShadow(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyTextTransform:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialTextTransform(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritTextTransform(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueTextTransform(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyTextUnderlineOffset:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialTextUnderlineOffset(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritTextUnderlineOffset(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueTextUnderlineOffset(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyTextUnderlinePosition:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialTextUnderlinePosition(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritTextUnderlinePosition(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueTextUnderlinePosition(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyTextWrapMode:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialTextWrapMode(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritTextWrapMode(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueTextWrapMode(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyTextWrapStyle:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialTextWrapStyle(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritTextWrapStyle(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueTextWrapStyle(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyTouchAction:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialTouchAction(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritTouchAction(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueTouchAction(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyTransform:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialTransform(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritTransform(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueTransform(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyTransformBox:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialTransformBox(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritTransformBox(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueTransformBox(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyTransformOriginX:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialTransformOriginX(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritTransformOriginX(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueTransformOriginX(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyTransformOriginY:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialTransformOriginY(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritTransformOriginY(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueTransformOriginY(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyTransformOriginZ:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialTransformOriginZ(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritTransformOriginZ(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueTransformOriginZ(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyTransformStyle:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialTransformStyle(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritTransformStyle(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueTransformStyle(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyTransitionBehavior:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialTransitionBehavior(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritTransitionBehavior(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueTransitionBehavior(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyTransitionDelay:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialTransitionDelay(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritTransitionDelay(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueTransitionDelay(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyTransitionDuration:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialTransitionDuration(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritTransitionDuration(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueTransitionDuration(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyTransitionProperty:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialTransitionProperty(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritTransitionProperty(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueTransitionProperty(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyTransitionTimingFunction:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialTransitionTimingFunction(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritTransitionTimingFunction(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueTransitionTimingFunction(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyTranslate:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialTranslate(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritTranslate(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueTranslate(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyTypes:
        break;
    case CSSPropertyID::CSSPropertyUnicodeBidi:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialUnicodeBidi(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritUnicodeBidi(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueUnicodeBidi(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyUnicodeRange:
        break;
    case CSSPropertyID::CSSPropertyVectorEffect:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialVectorEffect(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritVectorEffect(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueVectorEffect(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyVerticalAlign:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialVerticalAlign(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderCustom::applyInheritVerticalAlign(builderState);
            break;
        case ApplyValueType::Value:
            BuilderCustom::applyValueVerticalAlign(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyViewTimelineAxis:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialViewTimelineAxis(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritViewTimelineAxis(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueViewTimelineAxis(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyViewTimelineInset:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialViewTimelineInset(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritViewTimelineInset(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueViewTimelineInset(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyViewTimelineName:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialViewTimelineName(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritViewTimelineName(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueViewTimelineName(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyViewTransitionClass:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialViewTransitionClass(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritViewTransitionClass(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueViewTransitionClass(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyViewTransitionName:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialViewTransitionName(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritViewTransitionName(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueViewTransitionName(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyVisibility:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialVisibility(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritVisibility(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueVisibility(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyWhiteSpaceCollapse:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialWhiteSpaceCollapse(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritWhiteSpaceCollapse(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueWhiteSpaceCollapse(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyWidows:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialWidows(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritWidows(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueWidows(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyWillChange:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialWillChange(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritWillChange(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueWillChange(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyWordBreak:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialWordBreak(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritWordBreak(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueWordBreak(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyX:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialX(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritX(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueX(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyY:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialY(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritY(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueY(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyZIndex:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialZIndex(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritZIndex(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueZIndex(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyAppleColorFilter:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialAppleColorFilter(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritAppleColorFilter(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueAppleColorFilter(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyWebkitBackdropFilter:
        break;
    case CSSPropertyID::CSSPropertyWebkitBackgroundClip:
        break;
    case CSSPropertyID::CSSPropertyWebkitBackgroundOrigin:
        break;
    case CSSPropertyID::CSSPropertyWebkitBorderHorizontalSpacing:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialWebkitBorderHorizontalSpacing(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritWebkitBorderHorizontalSpacing(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueWebkitBorderHorizontalSpacing(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyWebkitBorderVerticalSpacing:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialWebkitBorderVerticalSpacing(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritWebkitBorderVerticalSpacing(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueWebkitBorderVerticalSpacing(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyWebkitBoxAlign:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialWebkitBoxAlign(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritWebkitBoxAlign(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueWebkitBoxAlign(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyWebkitBoxDecorationBreak:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialWebkitBoxDecorationBreak(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritWebkitBoxDecorationBreak(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueWebkitBoxDecorationBreak(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyWebkitBoxDirection:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialWebkitBoxDirection(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritWebkitBoxDirection(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueWebkitBoxDirection(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyWebkitBoxFlex:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialWebkitBoxFlex(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritWebkitBoxFlex(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueWebkitBoxFlex(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyWebkitBoxFlexGroup:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialWebkitBoxFlexGroup(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritWebkitBoxFlexGroup(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueWebkitBoxFlexGroup(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyWebkitBoxLines:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialWebkitBoxLines(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritWebkitBoxLines(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueWebkitBoxLines(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyWebkitBoxOrdinalGroup:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialWebkitBoxOrdinalGroup(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritWebkitBoxOrdinalGroup(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueWebkitBoxOrdinalGroup(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyWebkitBoxOrient:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialWebkitBoxOrient(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritWebkitBoxOrient(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueWebkitBoxOrient(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyWebkitBoxPack:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialWebkitBoxPack(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritWebkitBoxPack(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueWebkitBoxPack(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyWebkitBoxReflect:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialWebkitBoxReflect(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritWebkitBoxReflect(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueWebkitBoxReflect(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyWebkitBoxShadow:
        break;
    case CSSPropertyID::CSSPropertyWebkitColumnAxis:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialWebkitColumnAxis(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritWebkitColumnAxis(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueWebkitColumnAxis(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyWebkitColumnProgression:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialWebkitColumnProgression(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritWebkitColumnProgression(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueWebkitColumnProgression(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyWebkitCursorVisibility:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialWebkitCursorVisibility(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritWebkitCursorVisibility(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueWebkitCursorVisibility(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyWebkitFontSizeDelta:
        break;
    case CSSPropertyID::CSSPropertyWebkitHyphenateLimitAfter:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialWebkitHyphenateLimitAfter(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritWebkitHyphenateLimitAfter(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueWebkitHyphenateLimitAfter(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyWebkitHyphenateLimitBefore:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialWebkitHyphenateLimitBefore(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritWebkitHyphenateLimitBefore(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueWebkitHyphenateLimitBefore(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyWebkitHyphenateLimitLines:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialWebkitHyphenateLimitLines(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritWebkitHyphenateLimitLines(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueWebkitHyphenateLimitLines(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyWebkitInitialLetter:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialWebkitInitialLetter(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritWebkitInitialLetter(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueWebkitInitialLetter(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyWebkitLineAlign:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialWebkitLineAlign(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritWebkitLineAlign(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueWebkitLineAlign(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyWebkitLineBoxContain:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialWebkitLineBoxContain(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritWebkitLineBoxContain(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueWebkitLineBoxContain(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyWebkitLineClamp:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialWebkitLineClamp(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritWebkitLineClamp(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueWebkitLineClamp(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyWebkitLineGrid:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialWebkitLineGrid(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritWebkitLineGrid(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueWebkitLineGrid(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyWebkitLineSnap:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialWebkitLineSnap(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritWebkitLineSnap(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueWebkitLineSnap(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyWebkitMarqueeDirection:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialWebkitMarqueeDirection(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritWebkitMarqueeDirection(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueWebkitMarqueeDirection(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyWebkitMarqueeIncrement:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialWebkitMarqueeIncrement(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritWebkitMarqueeIncrement(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueWebkitMarqueeIncrement(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyWebkitMarqueeRepetition:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialWebkitMarqueeRepetition(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritWebkitMarqueeRepetition(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueWebkitMarqueeRepetition(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyWebkitMarqueeSpeed:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialWebkitMarqueeSpeed(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritWebkitMarqueeSpeed(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueWebkitMarqueeSpeed(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyWebkitMarqueeStyle:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialWebkitMarqueeStyle(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritWebkitMarqueeStyle(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueWebkitMarqueeStyle(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyWebkitMaskClip:
        break;
    case CSSPropertyID::CSSPropertyWebkitMaskComposite:
        break;
    case CSSPropertyID::CSSPropertyWebkitMaskPositionX:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialWebkitMaskPositionX(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritWebkitMaskPositionX(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueWebkitMaskPositionX(id, builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyWebkitMaskPositionY:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialWebkitMaskPositionY(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritWebkitMaskPositionY(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueWebkitMaskPositionY(id, builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyWebkitMaskSourceType:
        break;
    case CSSPropertyID::CSSPropertyWebkitNbspMode:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialWebkitNbspMode(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritWebkitNbspMode(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueWebkitNbspMode(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyWebkitRtlOrdering:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialWebkitRtlOrdering(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritWebkitRtlOrdering(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueWebkitRtlOrdering(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyWebkitRubyPosition:
        break;
    case CSSPropertyID::CSSPropertyWebkitTapHighlightColor:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialWebkitTapHighlightColor(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritWebkitTapHighlightColor(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueWebkitTapHighlightColor(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyWebkitTextCombine:
        break;
    case CSSPropertyID::CSSPropertyWebkitTextDecorationsInEffect:
        break;
    case CSSPropertyID::CSSPropertyWebkitTextFillColor:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialWebkitTextFillColor(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritWebkitTextFillColor(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueWebkitTextFillColor(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyWebkitTextSecurity:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialWebkitTextSecurity(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritWebkitTextSecurity(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueWebkitTextSecurity(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyWebkitTextStrokeColor:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialWebkitTextStrokeColor(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritWebkitTextStrokeColor(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueWebkitTextStrokeColor(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyWebkitTextStrokeWidth:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialWebkitTextStrokeWidth(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritWebkitTextStrokeWidth(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueWebkitTextStrokeWidth(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyWebkitUserDrag:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialWebkitUserDrag(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritWebkitUserDrag(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueWebkitUserDrag(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyWebkitUserModify:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialWebkitUserModify(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritWebkitUserModify(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueWebkitUserModify(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyWebkitUserSelect:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialWebkitUserSelect(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritWebkitUserSelect(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueWebkitUserSelect(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyWordSpacing:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialWordSpacing(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderCustom::applyInheritWordSpacing(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueWordSpacing(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyBlockSize:
        break;
    case CSSPropertyID::CSSPropertyBorderBlockEndColor:
        break;
    case CSSPropertyID::CSSPropertyBorderBlockEndStyle:
        break;
    case CSSPropertyID::CSSPropertyBorderBlockEndWidth:
        break;
    case CSSPropertyID::CSSPropertyBorderBlockStartColor:
        break;
    case CSSPropertyID::CSSPropertyBorderBlockStartStyle:
        break;
    case CSSPropertyID::CSSPropertyBorderBlockStartWidth:
        break;
    case CSSPropertyID::CSSPropertyBorderBottomColor:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialBorderBottomColor(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritBorderBottomColor(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueBorderBottomColor(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyBorderBottomLeftRadius:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderCustom::applyInitialBorderBottomLeftRadius(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderCustom::applyInheritBorderBottomLeftRadius(builderState);
            break;
        case ApplyValueType::Value:
            BuilderCustom::applyValueBorderBottomLeftRadius(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyBorderBottomRightRadius:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderCustom::applyInitialBorderBottomRightRadius(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderCustom::applyInheritBorderBottomRightRadius(builderState);
            break;
        case ApplyValueType::Value:
            BuilderCustom::applyValueBorderBottomRightRadius(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyBorderBottomStyle:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialBorderBottomStyle(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritBorderBottomStyle(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueBorderBottomStyle(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyBorderBottomWidth:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialBorderBottomWidth(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritBorderBottomWidth(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueBorderBottomWidth(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyBorderEndEndRadius:
        break;
    case CSSPropertyID::CSSPropertyBorderEndStartRadius:
        break;
    case CSSPropertyID::CSSPropertyBorderInlineEndColor:
        break;
    case CSSPropertyID::CSSPropertyBorderInlineEndStyle:
        break;
    case CSSPropertyID::CSSPropertyBorderInlineEndWidth:
        break;
    case CSSPropertyID::CSSPropertyBorderInlineStartColor:
        break;
    case CSSPropertyID::CSSPropertyBorderInlineStartStyle:
        break;
    case CSSPropertyID::CSSPropertyBorderInlineStartWidth:
        break;
    case CSSPropertyID::CSSPropertyBorderLeftColor:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialBorderLeftColor(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritBorderLeftColor(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueBorderLeftColor(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyBorderLeftStyle:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialBorderLeftStyle(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritBorderLeftStyle(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueBorderLeftStyle(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyBorderLeftWidth:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialBorderLeftWidth(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritBorderLeftWidth(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueBorderLeftWidth(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyBorderRightColor:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialBorderRightColor(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritBorderRightColor(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueBorderRightColor(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyBorderRightStyle:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialBorderRightStyle(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritBorderRightStyle(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueBorderRightStyle(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyBorderRightWidth:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialBorderRightWidth(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritBorderRightWidth(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueBorderRightWidth(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyBorderStartEndRadius:
        break;
    case CSSPropertyID::CSSPropertyBorderStartStartRadius:
        break;
    case CSSPropertyID::CSSPropertyBorderTopColor:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialBorderTopColor(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritBorderTopColor(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueBorderTopColor(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyBorderTopLeftRadius:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderCustom::applyInitialBorderTopLeftRadius(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderCustom::applyInheritBorderTopLeftRadius(builderState);
            break;
        case ApplyValueType::Value:
            BuilderCustom::applyValueBorderTopLeftRadius(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyBorderTopRightRadius:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderCustom::applyInitialBorderTopRightRadius(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderCustom::applyInheritBorderTopRightRadius(builderState);
            break;
        case ApplyValueType::Value:
            BuilderCustom::applyValueBorderTopRightRadius(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyBorderTopStyle:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialBorderTopStyle(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritBorderTopStyle(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueBorderTopStyle(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyBorderTopWidth:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialBorderTopWidth(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritBorderTopWidth(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueBorderTopWidth(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyBottom:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialBottom(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritBottom(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueBottom(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyContainIntrinsicBlockSize:
        break;
    case CSSPropertyID::CSSPropertyContainIntrinsicHeight:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderCustom::applyInitialContainIntrinsicHeight(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderCustom::applyInheritContainIntrinsicHeight(builderState);
            break;
        case ApplyValueType::Value:
            BuilderCustom::applyValueContainIntrinsicHeight(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyContainIntrinsicInlineSize:
        break;
    case CSSPropertyID::CSSPropertyContainIntrinsicWidth:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderCustom::applyInitialContainIntrinsicWidth(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderCustom::applyInheritContainIntrinsicWidth(builderState);
            break;
        case ApplyValueType::Value:
            BuilderCustom::applyValueContainIntrinsicWidth(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyHeight:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialHeight(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritHeight(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueHeight(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyInlineSize:
        break;
    case CSSPropertyID::CSSPropertyInsetBlockEnd:
        break;
    case CSSPropertyID::CSSPropertyInsetBlockStart:
        break;
    case CSSPropertyID::CSSPropertyInsetInlineEnd:
        break;
    case CSSPropertyID::CSSPropertyInsetInlineStart:
        break;
    case CSSPropertyID::CSSPropertyLeft:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialLeft(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritLeft(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueLeft(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyMarginBlockEnd:
        break;
    case CSSPropertyID::CSSPropertyMarginBlockStart:
        break;
    case CSSPropertyID::CSSPropertyMarginBottom:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialMarginBottom(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritMarginBottom(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueMarginBottom(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyMarginInlineEnd:
        break;
    case CSSPropertyID::CSSPropertyMarginInlineStart:
        break;
    case CSSPropertyID::CSSPropertyMarginLeft:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialMarginLeft(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritMarginLeft(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueMarginLeft(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyMarginRight:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialMarginRight(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritMarginRight(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueMarginRight(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyMarginTop:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialMarginTop(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritMarginTop(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueMarginTop(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyMaxBlockSize:
        break;
    case CSSPropertyID::CSSPropertyMaxHeight:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialMaxHeight(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritMaxHeight(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueMaxHeight(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyMaxInlineSize:
        break;
    case CSSPropertyID::CSSPropertyMaxWidth:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialMaxWidth(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritMaxWidth(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueMaxWidth(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyMinBlockSize:
        break;
    case CSSPropertyID::CSSPropertyMinHeight:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialMinHeight(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritMinHeight(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueMinHeight(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyMinInlineSize:
        break;
    case CSSPropertyID::CSSPropertyMinWidth:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialMinWidth(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritMinWidth(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueMinWidth(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyOverscrollBehaviorBlock:
        break;
    case CSSPropertyID::CSSPropertyOverscrollBehaviorInline:
        break;
    case CSSPropertyID::CSSPropertyOverscrollBehaviorX:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialOverscrollBehaviorX(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritOverscrollBehaviorX(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueOverscrollBehaviorX(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyOverscrollBehaviorY:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialOverscrollBehaviorY(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritOverscrollBehaviorY(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueOverscrollBehaviorY(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyPaddingBlockEnd:
        break;
    case CSSPropertyID::CSSPropertyPaddingBlockStart:
        break;
    case CSSPropertyID::CSSPropertyPaddingBottom:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialPaddingBottom(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritPaddingBottom(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValuePaddingBottom(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyPaddingInlineEnd:
        break;
    case CSSPropertyID::CSSPropertyPaddingInlineStart:
        break;
    case CSSPropertyID::CSSPropertyPaddingLeft:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialPaddingLeft(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritPaddingLeft(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValuePaddingLeft(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyPaddingRight:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialPaddingRight(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritPaddingRight(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValuePaddingRight(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyPaddingTop:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialPaddingTop(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritPaddingTop(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValuePaddingTop(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyRight:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialRight(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritRight(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueRight(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyScrollMarginBlockEnd:
        break;
    case CSSPropertyID::CSSPropertyScrollMarginBlockStart:
        break;
    case CSSPropertyID::CSSPropertyScrollMarginBottom:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialScrollMarginBottom(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritScrollMarginBottom(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueScrollMarginBottom(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyScrollMarginInlineEnd:
        break;
    case CSSPropertyID::CSSPropertyScrollMarginInlineStart:
        break;
    case CSSPropertyID::CSSPropertyScrollMarginLeft:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialScrollMarginLeft(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritScrollMarginLeft(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueScrollMarginLeft(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyScrollMarginRight:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialScrollMarginRight(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritScrollMarginRight(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueScrollMarginRight(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyScrollMarginTop:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialScrollMarginTop(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritScrollMarginTop(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueScrollMarginTop(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyScrollPaddingBlockEnd:
        break;
    case CSSPropertyID::CSSPropertyScrollPaddingBlockStart:
        break;
    case CSSPropertyID::CSSPropertyScrollPaddingBottom:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialScrollPaddingBottom(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritScrollPaddingBottom(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueScrollPaddingBottom(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyScrollPaddingInlineEnd:
        break;
    case CSSPropertyID::CSSPropertyScrollPaddingInlineStart:
        break;
    case CSSPropertyID::CSSPropertyScrollPaddingLeft:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialScrollPaddingLeft(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritScrollPaddingLeft(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueScrollPaddingLeft(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyScrollPaddingRight:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialScrollPaddingRight(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritScrollPaddingRight(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueScrollPaddingRight(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyScrollPaddingTop:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialScrollPaddingTop(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritScrollPaddingTop(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueScrollPaddingTop(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyTop:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialTop(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritTop(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueTop(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyWidth:
        switch (valueType) {
        case ApplyValueType::Initial:
            BuilderFunctions::applyInitialWidth(builderState);
            break;
        case ApplyValueType::Inherit:
            BuilderFunctions::applyInheritWidth(builderState);
            break;
        case ApplyValueType::Value:
            BuilderFunctions::applyValueWidth(builderState, value);
            break;
        }
        break;
    case CSSPropertyID::CSSPropertyAll:
        ASSERT(isShorthand(id));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyID::CSSPropertyAnimation:
        ASSERT(isShorthand(id));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyID::CSSPropertyBackground:
        ASSERT(isShorthand(id));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyID::CSSPropertyBackgroundPosition:
        ASSERT(isShorthand(id));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyID::CSSPropertyBorder:
        ASSERT(isShorthand(id));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyID::CSSPropertyBorderBlock:
        ASSERT(isShorthand(id));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyID::CSSPropertyBorderBlockColor:
        ASSERT(isShorthand(id));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyID::CSSPropertyBorderBlockEnd:
        ASSERT(isShorthand(id));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyID::CSSPropertyBorderBlockStart:
        ASSERT(isShorthand(id));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyID::CSSPropertyBorderBlockStyle:
        ASSERT(isShorthand(id));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyID::CSSPropertyBorderBlockWidth:
        ASSERT(isShorthand(id));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyID::CSSPropertyBorderBottom:
        ASSERT(isShorthand(id));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyID::CSSPropertyBorderColor:
        ASSERT(isShorthand(id));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyID::CSSPropertyBorderImage:
        ASSERT(isShorthand(id));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyID::CSSPropertyBorderInline:
        ASSERT(isShorthand(id));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyID::CSSPropertyBorderInlineColor:
        ASSERT(isShorthand(id));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyID::CSSPropertyBorderInlineEnd:
        ASSERT(isShorthand(id));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyID::CSSPropertyBorderInlineStart:
        ASSERT(isShorthand(id));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyID::CSSPropertyBorderInlineStyle:
        ASSERT(isShorthand(id));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyID::CSSPropertyBorderInlineWidth:
        ASSERT(isShorthand(id));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyID::CSSPropertyBorderLeft:
        ASSERT(isShorthand(id));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyID::CSSPropertyBorderRadius:
        ASSERT(isShorthand(id));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyID::CSSPropertyBorderRight:
        ASSERT(isShorthand(id));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyID::CSSPropertyBorderSpacing:
        ASSERT(isShorthand(id));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyID::CSSPropertyBorderStyle:
        ASSERT(isShorthand(id));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyID::CSSPropertyBorderTop:
        ASSERT(isShorthand(id));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyID::CSSPropertyBorderWidth:
        ASSERT(isShorthand(id));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyID::CSSPropertyColumnRule:
        ASSERT(isShorthand(id));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyID::CSSPropertyColumns:
        ASSERT(isShorthand(id));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyID::CSSPropertyContainIntrinsicSize:
        ASSERT(isShorthand(id));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyID::CSSPropertyContainer:
        ASSERT(isShorthand(id));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyID::CSSPropertyFlex:
        ASSERT(isShorthand(id));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyID::CSSPropertyFlexFlow:
        ASSERT(isShorthand(id));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyID::CSSPropertyFont:
        ASSERT(isShorthand(id));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyID::CSSPropertyFontSynthesis:
        ASSERT(isShorthand(id));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyID::CSSPropertyFontVariant:
        ASSERT(isShorthand(id));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyID::CSSPropertyGap:
        ASSERT(isShorthand(id));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyID::CSSPropertyGrid:
        ASSERT(isShorthand(id));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyID::CSSPropertyGridArea:
        ASSERT(isShorthand(id));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyID::CSSPropertyGridColumn:
        ASSERT(isShorthand(id));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyID::CSSPropertyGridRow:
        ASSERT(isShorthand(id));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyID::CSSPropertyGridTemplate:
        ASSERT(isShorthand(id));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyID::CSSPropertyInset:
        ASSERT(isShorthand(id));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyID::CSSPropertyInsetBlock:
        ASSERT(isShorthand(id));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyID::CSSPropertyInsetInline:
        ASSERT(isShorthand(id));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyID::CSSPropertyListStyle:
        ASSERT(isShorthand(id));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyID::CSSPropertyMargin:
        ASSERT(isShorthand(id));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyID::CSSPropertyMarginBlock:
        ASSERT(isShorthand(id));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyID::CSSPropertyMarginInline:
        ASSERT(isShorthand(id));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyID::CSSPropertyMarker:
        ASSERT(isShorthand(id));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyID::CSSPropertyMask:
        ASSERT(isShorthand(id));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyID::CSSPropertyMaskBorder:
        ASSERT(isShorthand(id));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyID::CSSPropertyMaskPosition:
        ASSERT(isShorthand(id));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyID::CSSPropertyOffset:
        ASSERT(isShorthand(id));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyID::CSSPropertyOutline:
        ASSERT(isShorthand(id));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyID::CSSPropertyOverflow:
        ASSERT(isShorthand(id));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyID::CSSPropertyOverscrollBehavior:
        ASSERT(isShorthand(id));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyID::CSSPropertyPadding:
        ASSERT(isShorthand(id));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyID::CSSPropertyPaddingBlock:
        ASSERT(isShorthand(id));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyID::CSSPropertyPaddingInline:
        ASSERT(isShorthand(id));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyID::CSSPropertyPageBreakAfter:
        ASSERT(isShorthand(id));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyID::CSSPropertyPageBreakBefore:
        ASSERT(isShorthand(id));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyID::CSSPropertyPageBreakInside:
        ASSERT(isShorthand(id));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyID::CSSPropertyPerspectiveOrigin:
        ASSERT(isShorthand(id));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyID::CSSPropertyPlaceContent:
        ASSERT(isShorthand(id));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyID::CSSPropertyPlaceItems:
        ASSERT(isShorthand(id));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyID::CSSPropertyPlaceSelf:
        ASSERT(isShorthand(id));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyID::CSSPropertyScrollMargin:
        ASSERT(isShorthand(id));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyID::CSSPropertyScrollMarginBlock:
        ASSERT(isShorthand(id));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyID::CSSPropertyScrollMarginInline:
        ASSERT(isShorthand(id));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyID::CSSPropertyScrollPadding:
        ASSERT(isShorthand(id));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyID::CSSPropertyScrollPaddingBlock:
        ASSERT(isShorthand(id));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyID::CSSPropertyScrollPaddingInline:
        ASSERT(isShorthand(id));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyID::CSSPropertyScrollTimeline:
        ASSERT(isShorthand(id));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyID::CSSPropertyTextBox:
        ASSERT(isShorthand(id));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyID::CSSPropertyTextDecoration:
        ASSERT(isShorthand(id));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyID::CSSPropertyTextDecorationSkip:
        ASSERT(isShorthand(id));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyID::CSSPropertyTextEmphasis:
        ASSERT(isShorthand(id));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyID::CSSPropertyTextWrap:
        ASSERT(isShorthand(id));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyID::CSSPropertyTransformOrigin:
        ASSERT(isShorthand(id));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyID::CSSPropertyTransition:
        ASSERT(isShorthand(id));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyID::CSSPropertyViewTimeline:
        ASSERT(isShorthand(id));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyID::CSSPropertyWhiteSpace:
        ASSERT(isShorthand(id));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyID::CSSPropertyWebkitBackgroundSize:
        ASSERT(isShorthand(id));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyID::CSSPropertyWebkitBorderImage:
        ASSERT(isShorthand(id));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyID::CSSPropertyWebkitBorderRadius:
        ASSERT(isShorthand(id));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyID::CSSPropertyWebkitColumnBreakAfter:
        ASSERT(isShorthand(id));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyID::CSSPropertyWebkitColumnBreakBefore:
        ASSERT(isShorthand(id));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyID::CSSPropertyWebkitColumnBreakInside:
        ASSERT(isShorthand(id));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyID::CSSPropertyWebkitMask:
        ASSERT(isShorthand(id));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyID::CSSPropertyWebkitMaskBoxImage:
        ASSERT(isShorthand(id));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyID::CSSPropertyWebkitMaskPosition:
        ASSERT(isShorthand(id));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyID::CSSPropertyWebkitPerspective:
        ASSERT(isShorthand(id));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyID::CSSPropertyWebkitTextDecoration:
        ASSERT(isShorthand(id));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyID::CSSPropertyWebkitTextOrientation:
        ASSERT(isShorthand(id));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyID::CSSPropertyWebkitTextStroke:
        ASSERT(isShorthand(id));
        ASSERT_NOT_REACHED();
        break;
    }
}

} // namespace WebCore
} // namespace Style

