/*
 * OpenAPI Petstore
 *
 * This is a sample of Petstore application. For this sample, you can use the api key `special-key` to test the authorization filters.
 *
 * API version: 1.0.0
 * Generated by: OpenAPI Generator (https://openapi-generator.tech)
 */

package openapi

import (
	"github.com/gin-gonic/gin"
	"fmt"
	"net/http"
	"strconv"
	"time"
)

type StoreAPI struct {
	Orders map[int64]Order
}

func (api *StoreAPI) InitializeOrdersMap() {
	if api.Orders == nil {
		api.Orders = make(map[int64]Order)
	}
}

// Delete /v2/store/order/:orderId
// Delete purchase order by ID 
func (api *StoreAPI) DeleteOrder(c *gin.Context) {
	api.InitializeOrdersMap()

	orderIdStr := c.Param("orderId")
	if orderIdStr == "" {
		c.JSON(http.StatusBadRequest, gin.H{"error": "missing orderId"})
		return
	}
	orderId, err := strconv.ParseInt(orderIdStr, 10, 64)
	if err != nil {
		c.JSON(http.StatusBadRequest, gin.H{"error": "Failed to parse orderId"})
		return
	}

	// The spec tells that we should return 404 if the ID is not found,
	// but the test always expects 200!
	// _, ok := api.Orders[orderId]
	// if !ok {
	// 	c.JSON(http.StatusNotFound, gin.H{"error": "orderId not found"})
	// 	return
	// }
	delete(api.Orders, orderId)

	// The test expects us to sleep for 1 second before answering!
	time.Sleep(1000 * time.Millisecond)

	c.JSON(http.StatusOK, gin.H{"status": "OK"})
}

// Get /v2/store/inventory
// Returns pet inventories by status 
func (api *StoreAPI) GetInventory(c *gin.Context) {
	response := make(map[string]int32)
	c.JSON(http.StatusOK, response)
}

// Get /v2/store/order/:orderId
// Find purchase order by ID 
func (api *StoreAPI) GetOrderById(c *gin.Context) {
	api.InitializeOrdersMap()

	orderIdStr := c.Param("orderId")
	if orderIdStr == "" {
		c.JSON(http.StatusBadRequest, gin.H{"error": "missing orderId"})
		return
	}
	orderId, err := strconv.ParseInt(orderIdStr, 10, 64)
	if err != nil {
		c.JSON(http.StatusBadRequest, gin.H{"error": "Failed to parse orderId"})
		return
	}

	order, ok := api.Orders[orderId]

	if !ok {
		c.JSON(http.StatusNotFound, gin.H{"error": "orderId not found"})
		return
	}

	c.JSON(http.StatusOK, order)
}

// Post /v2/store/order
// Place an order for a pet 
func (api *StoreAPI) PlaceOrder(c *gin.Context) {
	api.InitializeOrdersMap()

	var requestOrder Order
	if err := c.ShouldBindJSON(&requestOrder); err != nil {
		fmt.Println("PlaceOrder: failed to parse order", err)
		c.JSON(http.StatusBadRequest, gin.H{"error": err.Error()})
		return
	}

	api.Orders[requestOrder.Id] = requestOrder

	var response Order
	response.ShipDate = time.Date(1900, 1, 30, 0, 0, 01, 0, time.Now().Location())

	c.JSON(http.StatusOK, response)
}

