/* @(#)maxpath.h	1.6 03/08/23 Copyright 1985, 1995, 1998 J. Schilling */
/*
 *	Definitions for dealing with statically limitations on pathnames
 *
 *	Copyright (c) 1985, 1995, 1998 J. Schilling
 */
/*
 * Copyright Jrg Schilling. All rights reserved.
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License, Version 1.0 only.
 * See the file CDDL.Schily.txt in this distribution or
 * http://opensource.org/licenses/cddl1.php for details.
 */

#ifndef	_MAXPATH_H
#define	_MAXPATH_H

#ifndef	_DIRDEFS_H
#include <dirdefs.h>			/* Includes mconfig.h if needed	    */
#endif

#ifdef	JOS
#ifndef	_JOS_MAXP_H
#	include <jos_maxp.h>
#endif
#	define	FOUND_MAXPATHNAME
#	define	FOUND_MAXFILENAME
#else

#	ifdef	MAXPATHLEN
#		define	MAXPATHNAME	MAXPATHLEN	/* From sys/param.h */
#		define	FOUND_MAXPATHNAME
#	else
#	ifdef	PATH_MAX
#		define	MAXPATHNAME	PATH_MAX	/* From limits.h    */
#		define	FOUND_MAXPATHNAME
#	else
#		define	MAXPATHNAME	256		/* Is there a limit? */
#	endif
#	endif

/*
 * Don't use defaults here to allow recognition of problems.
 */
#	ifdef	MAXNAMELEN
#		define	MAXFILENAME	MAXNAMELEN	/* From sys/param.h */
#		define	FOUND_MAXFILENAME
#	else
#	ifdef	MAXNAMLEN
#		define	MAXFILENAME	MAXNAMLEN	/* From dirent.h    */
#		define	FOUND_MAXFILENAME
#	else
#	ifdef	DIRSIZ
#		define	MAXFILENAME	DIRSIZ		/* From sys/dir.h   */
#		define	FOUND_MAXFILENAME
#	endif
#	endif
#	endif

#if	!defined(FOUND_MAXFILENAME) && defined(FOUND_DIRSIZE)
#	define	MAXFILENAME		DIRSIZE		/* From dirdefs.h    */
#	define	FOUND_MAXFILENAME
#endif

#endif	/* JOS */

#endif	/* _MAXPATH_H */
