/*
 * FIG : Facility for Interactive Generation of figures
 * Copyright (c) 1985-1988 by Supoj Sutanthavibul
 * Parts Copyright (c) 1989-2002 by Brian V. Smith
 * Parts Copyright (c) 1991 by Paul King
 *
 * Any party obtaining a copy of these files is granted, free of charge, a
 * full and unrestricted irrevocable, world-wide, paid up, royalty-free,
 * nonexclusive right and license to deal in this software and
 * documentation files (the "Software"), including without limitation the
 * rights to use, copy, modify, merge, publish and/or distribute copies of
 * the Software, and to permit persons who receive copies from any such 
 * party to do so, with the only requirement being that this copyright 
 * notice remain intact.
 *
 */

#include "fig.h"
#include "resources.h"
#include "w_icons.h"

/*********** icons for mode panel *****************/

#ifdef USE_SMALL_ICONS

#define addpt_width 22
#define addpt_height 22
static unsigned char addpt_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0e,0x00,0x00,0x0e,0x00,
0x00,0x0e,0x00,0x00,0x1f,0x00,0x00,0x11,0x00,0x00,0x11,0x00,
0x80,0x20,0x00,0x80,0x20,0x00,0x40,0x44,0x00,0x40,0x4e,0x00,
0x20,0x95,0x00,0x20,0x84,0x00,0x10,0x04,0x01,0x10,0x04,0x01,
0x08,0x04,0x02,0x08,0x00,0x02,0x04,0x00,0x04,0x54,0x55,0x05,
0x00,0x00,0x00,0x00,0x00,0x00};
#define align_width 22
#define align_height 22
static unsigned char align_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x8f,0x03,0x10,0x49,0x04,
0x10,0x29,0x08,0x28,0x29,0x08,0x28,0x29,0x08,0x44,0x49,0x04,
0x7c,0x8f,0x03,0xa8,0xaa,0x0a,0x00,0x00,0x00,0x98,0x00,0x00,
0xa4,0x00,0x00,0xa4,0x02,0x00,0xa4,0x30,0x07,0xbc,0x4a,0x09,
0xa4,0x4a,0x09,0xa4,0x72,0x09,0xa4,0x42,0x09,0x00,0x38,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};
#define arc_width 22
#define arc_height 22
static unsigned char arc_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x90,0x03,0x00,0x90,0x0d,0x00,
0x10,0x10,0x00,0x10,0x20,0x00,0x00,0x20,0x00,0x00,0x40,0x00,
0x00,0x80,0x0c,0x00,0x80,0x08,0x00,0x80,0x0d,0x00,0x80,0x05,
0x00,0x80,0x0c,0x00,0x80,0x00,0x00,0x40,0x00,0x18,0x20,0x00,
0x10,0x20,0x00,0x08,0x10,0x00,0x90,0x0d,0x00,0x98,0x03,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};
#define arc_box_width 22
#define arc_box_height 22
static unsigned char arc_box_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xe0,0xff,0x01,0x10,0x00,0x02,0x08,0x00,0x04,0x08,0x00,0x04,
0x08,0x00,0x04,0x08,0x00,0x04,0x08,0x00,0x04,0x08,0x00,0x04,
0x08,0x00,0x04,0x08,0x00,0x04,0x08,0x00,0x04,0x08,0x00,0x04,
0x10,0x00,0x02,0xe0,0xff,0x01,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};
#define autoarrow_width 22
#define autoarrow_height 22
static unsigned char autoarrow_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x04,0x00,0x00,0x04,0x00,
0x00,0x0a,0x00,0x00,0x0a,0x00,0x00,0x11,0x00,0x00,0x11,0x00,
0x80,0x20,0x00,0x80,0x20,0x00,0x40,0x40,0x00,0x40,0x40,0x00,
0xc0,0x7f,0x00,0x00,0x04,0x00,0x00,0x04,0x00,0x00,0x04,0x00,
0x00,0x04,0x00,0x00,0x04,0x00,0x00,0x04,0x00,0x00,0x04,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};
#define box_width 22
#define box_height 22
static unsigned char box_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0xf8,0xff,0x07,0x08,0x00,0x04,0x08,0x00,0x04,
0x08,0x00,0x04,0x08,0x00,0x04,0x08,0x00,0x04,0x08,0x00,0x04,
0x08,0x00,0x04,0x08,0x00,0x04,0x08,0x00,0x04,0x08,0x00,0x04,
0xf8,0xff,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};
#define break_width 22
#define break_height 22
static unsigned char break_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x54,0x55,0x05,0x00,0x00,0x08,
0xe4,0xe0,0x00,0x10,0x11,0x09,0x34,0x08,0x02,0xc0,0x08,0x0a,
0x14,0x11,0x01,0xe0,0xe0,0x08,0x04,0x00,0x00,0x00,0x00,0x09,
0x04,0x7c,0x02,0xf0,0x11,0x0a,0x14,0x11,0x02,0x10,0x11,0x0a,
0xf4,0x11,0x01,0x00,0x90,0x08,0x04,0x00,0x00,0xa8,0xaa,0x0a,
0x00,0x00,0x00,0x00,0x00,0x00};
#define open_comp_width 22
#define open_comp_height 22
static unsigned char open_comp_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0xfc,0x1f,0x00,0x04,0x10,0x00,
0xf4,0x10,0x00,0x54,0x10,0x00,0x34,0x10,0x00,0x94,0x17,0x00,
0x84,0x14,0x00,0x84,0x17,0x00,0x04,0x10,0x00,0xfc,0x1f,0x00,
0x00,0x00,0x00,0x00,0xf0,0x00,0x00,0x50,0x00,0x00,0x30,0x00,
0x00,0x90,0x07,0x00,0x80,0x04,0x00,0x80,0x07,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};
#define join_split_width 22
#define join_split_height 22
static unsigned char join_split_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x04,0x08,0x00,0x04,0x14,0x00,
0x88,0x23,0x08,0x88,0x43,0x04,0x90,0x83,0x02,0x50,0x00,0x01,
0x20,0x00,0x00,0x80,0x00,0x00,0xc0,0x01,0x00,0xa0,0x02,0x00,
0x80,0x00,0x00,0x84,0x00,0x00,0xa4,0x12,0x00,0xc8,0x21,0x08,
0x88,0x40,0x04,0x10,0x80,0x02,0x10,0x00,0x01,0x20,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};
#define c_intspl_width 22
#define c_intspl_height 22
static unsigned char c_intspl_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x10,0x00,
0xc0,0x1f,0x00,0xa0,0x18,0x00,0x10,0x20,0x00,0x10,0x24,0x00,
0x20,0x1c,0x00,0x40,0x0e,0x00,0x80,0x41,0x00,0x68,0x7e,0x00,
0x18,0xe0,0x00,0x18,0x00,0x01,0x08,0x00,0x02,0x08,0x00,0x02,
0x08,0x00,0x03,0x28,0x10,0x07,0x30,0xf0,0x00,0xf0,0x3f,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};
#define c_spl_width 22
#define c_spl_height 22
static unsigned char c_spl_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0x0f,0x00,
0x20,0x10,0x00,0x10,0x20,0x00,0x10,0x20,0x00,0x20,0x18,0x00,
0x40,0x06,0x00,0x80,0x01,0x00,0x60,0x3e,0x00,0x10,0xc0,0x00,
0x08,0x00,0x01,0x08,0x00,0x02,0x08,0x00,0x02,0x08,0x00,0x02,
0x08,0x00,0x01,0x10,0xe0,0x00,0xe0,0x1f,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};
#define cirdia_width 22
#define cirdia_height 22
static unsigned char cirdia_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1f,0x00,
0xc0,0x60,0x00,0x30,0x80,0x01,0x10,0x00,0x01,0x08,0x00,0x02,
0x08,0x00,0x02,0x04,0x00,0x04,0x04,0x04,0x04,0xac,0xae,0x06,
0x04,0x04,0x04,0x04,0x00,0x04,0x08,0x00,0x02,0x08,0x00,0x02,
0x10,0x00,0x01,0x30,0x80,0x01,0xc0,0x60,0x00,0x00,0x1f,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};
#define cirrad_width 22
#define cirrad_height 22
static unsigned char cirrad_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1f,0x00,
0xc0,0x60,0x00,0x30,0x80,0x01,0x10,0x00,0x01,0x08,0x00,0x02,
0x08,0x00,0x02,0x04,0x00,0x04,0x04,0x04,0x04,0x04,0x56,0x05,
0x04,0x04,0x04,0x04,0x00,0x04,0x08,0x00,0x02,0x08,0x00,0x02,
0x10,0x00,0x01,0x30,0x80,0x01,0xc0,0x60,0x00,0x00,0x1f,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};
#define convert_width 22
#define convert_height 22
static unsigned char convert_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x30,0x40,0x00,0x40,0x80,0x00,
0x40,0x22,0x01,0x40,0x7f,0x02,0x20,0x22,0x04,0x30,0x00,0x02,
0x08,0x00,0x01,0x08,0x80,0x00,0x08,0x00,0x01,0x70,0x00,0x02,
0x00,0x00,0x00,0xfc,0xe3,0x07,0x04,0x12,0x08,0x44,0x92,0x08,
0xe4,0xff,0x09,0x44,0x92,0x08,0x04,0x12,0x08,0xfc,0xe3,0x07,
0x00,0x00,0x00,0x00,0x00,0x00};
#define copy_width 22
#define copy_height 22
static unsigned char copy_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x38,0x80,0x03,0xe8,0x80,0x0e,
0x8c,0xc0,0x08,0x84,0x48,0x08,0x84,0x5e,0x08,0x84,0x48,0x08,
0x8c,0xc0,0x08,0x98,0x80,0x09,0xf0,0x00,0x0f,0x60,0x00,0x06,
0x00,0x00,0x00,0x38,0x00,0x00,0x44,0x00,0x00,0x04,0x32,0x05,
0x04,0x55,0x05,0x44,0x35,0x07,0x38,0x12,0x04,0x00,0x10,0x03,
0x00,0x00,0x00,0x00,0x00,0x00};
#define delete_width 22
#define delete_height 22
static unsigned char delete_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1f,0x00,0x80,0x3f,0x00,
0x80,0x3f,0x00,0xc0,0x64,0x00,0xc0,0x7f,0x00,0x80,0x3f,0x00,
0x00,0x0e,0x00,0x00,0x0a,0x00,0x10,0x00,0x02,0xf8,0xe0,0x07,
0x00,0x1f,0x00,0xf8,0xe0,0x07,0x10,0x00,0x02,0x00,0x00,0x00,
0x46,0x92,0x08,0xaa,0xaa,0x15,0x6a,0x9a,0x0c,0xc6,0xb2,0x18,
0x00,0x00,0x00,0x00,0x00,0x00};
#define deletept_width 22
#define deletept_height 22
static unsigned char deletept_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x30,0x00,0x00,0x70,0x00,0x00,
0xe0,0x00,0x00,0xd8,0x01,0x07,0x98,0x83,0x0f,0x20,0x87,0x08,
0xac,0xff,0x08,0x58,0xff,0x0f,0x40,0x30,0x07,0x88,0x70,0x00,
0x88,0xd0,0x00,0x08,0x91,0x01,0x08,0x11,0x03,0x08,0x62,0x03,
0x08,0xc2,0x01,0x08,0x04,0x00,0x08,0x04,0x00,0x08,0x08,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};
#define edit_width 22
#define edit_height 22
static unsigned char edit_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf4,0x0f,0x80,0x10,0x08,
0x38,0x50,0x0b,0x28,0x10,0x08,0x64,0xd0,0x0b,0x4c,0x10,0x08,
0x68,0xd0,0x08,0x38,0x10,0x08,0x80,0xd0,0x08,0x00,0x14,0x08,
0x00,0xf0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0xe0,0xa8,0x00,
0x20,0x88,0x01,0x60,0xae,0x00,0x20,0xaa,0x00,0xe0,0x2e,0x01,
0x00,0x00,0x00,0x00,0x00,0x00};
#define elldia_width 22
#define elldia_height 22
static unsigned char elldia_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x1f,0x00,0xe0,0xe0,0x00,0x10,0x00,0x01,
0x08,0x00,0x02,0x08,0x00,0x02,0x04,0x04,0x04,0xac,0xae,0x06,
0x04,0x04,0x04,0x08,0x00,0x02,0x08,0x00,0x02,0x10,0x00,0x01,
0xe0,0xe0,0x00,0x00,0x1f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};
#define ellrad_width 22
#define ellrad_height 22
static unsigned char ellrad_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x1f,0x00,0xe0,0xe0,0x00,0x10,0x00,0x01,
0x08,0x00,0x02,0x08,0x00,0x02,0x04,0x04,0x04,0x04,0xae,0x06,
0x04,0x04,0x04,0x08,0x00,0x02,0x08,0x00,0x02,0x10,0x00,0x01,
0xe0,0xe0,0x00,0x00,0x1f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};
#define flip_x_width 22
#define flip_x_height 22
static unsigned char flip_x_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xe0,0xe4,0x00,
0x10,0x11,0x01,0x10,0x15,0x01,0x10,0x11,0x01,0xe0,0xe4,0x00,
0x40,0x40,0x00,0x48,0x44,0x02,0xb8,0xbb,0x03,0xa0,0xa4,0x00,
0x10,0x11,0x01,0x10,0x15,0x01,0xf8,0xfb,0x03,0xa0,0xa4,0x00,
0xa0,0xa0,0x00,0xa0,0xa4,0x00,0xb0,0xb1,0x01,0x00,0x04,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};
#define flip_y_width 22
#define flip_y_height 22
static unsigned char flip_y_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0c,0x00,
0x00,0x0c,0x00,0x00,0x12,0x00,0x00,0x12,0x00,0x00,0x21,0x00,
0x00,0x21,0x00,0x80,0x7f,0x00,0x00,0x00,0x00,0xf8,0xff,0x07,
0x00,0x00,0x00,0x80,0x7f,0x00,0x00,0x21,0x00,0x00,0x21,0x00,
0x00,0x12,0x00,0x00,0x12,0x00,0x00,0x0c,0x00,0x00,0x0c,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};
#define glue_width 22
#define glue_height 22
static unsigned char glue_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0xfc,0xff,0x0f,0x0c,0x00,0x0c,
0xe4,0xe0,0x08,0x14,0x11,0x09,0x34,0x08,0x0a,0xc4,0x08,0x0a,
0x14,0x11,0x09,0xe4,0xe0,0x08,0x04,0x00,0x08,0x04,0x00,0x09,
0x04,0x7c,0x0a,0xf4,0x11,0x0a,0x14,0x11,0x0a,0x14,0x11,0x0a,
0xf4,0x11,0x09,0x04,0x90,0x08,0x0c,0x00,0x0c,0xfc,0xff,0x0f,
0x00,0x00,0x00,0x00,0x00,0x00};
#define intspl_width 22
#define intspl_height 22
static unsigned char intspl_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0x00,0x00,0xc0,0x1f,0x00,
0xe0,0x30,0x00,0x10,0x30,0x00,0x10,0x00,0x00,0x20,0x00,0x00,
0x40,0x00,0x00,0x80,0x01,0x00,0x00,0x7e,0x00,0x00,0xe0,0x00,
0x00,0x60,0x01,0x00,0x00,0x02,0x00,0x00,0x02,0x00,0x00,0x07,
0x00,0x00,0x07,0x30,0xf0,0x00,0xf0,0x3f,0x00,0x30,0x30,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};
#define line_width 22
#define line_height 22
static unsigned char line_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x00,0x04,
0x80,0x00,0x04,0x40,0x01,0x04,0x40,0x01,0x02,0x20,0x01,0x02,
0x20,0x02,0x02,0x20,0x02,0x02,0x10,0x04,0x02,0x10,0x04,0x01,
0x08,0x04,0x01,0x08,0x08,0x01,0x00,0x08,0x01,0x00,0x04,0x01,
0x00,0x84,0x01,0x00,0x7a,0x00,0x00,0x06,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};
#define move_width 22
#define move_height 22
static unsigned char move_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x28,0x80,0x03,0x40,0x80,0x0e,
0x88,0xc0,0x08,0x00,0x48,0x08,0x84,0x5e,0x08,0x00,0x48,0x08,
0x84,0xc0,0x08,0x08,0x80,0x09,0xa0,0x00,0x0f,0x40,0x00,0x06,
0x00,0x00,0x00,0x00,0x00,0x00,0x44,0x00,0x00,0x6c,0x00,0x00,
0x54,0x52,0x03,0x44,0x55,0x05,0x44,0x55,0x03,0x44,0x22,0x06,
0x00,0x00,0x00,0x00,0x00,0x00};
#define movept_width 22
#define movept_height 22
static unsigned char movept_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x08,0x00,0x1c,0x10,0x0e,
0x1c,0x3f,0x0e,0x3c,0x10,0x0e,0x00,0x08,0x05,0x88,0x80,0x04,
0x08,0x40,0x04,0x00,0x22,0x04,0x08,0x10,0x04,0x08,0x08,0x04,
0x00,0x08,0x04,0x08,0x04,0x04,0x08,0x22,0x04,0x00,0x01,0x04,
0x88,0x80,0x04,0x48,0x00,0x04,0x20,0x00,0x06,0x18,0x00,0x04,
0x00,0x00,0x00,0x00,0x00,0x00};
#define picobj_width 22
#define picobj_height 22
static unsigned char picobj_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x38,0x00,0xc0,0x45,0x00,
0x20,0x42,0x00,0x20,0x7e,0x00,0x20,0x87,0x00,0xc0,0x8f,0x00,
0x20,0xf2,0x00,0x20,0x13,0x00,0xc0,0x12,0x00,0x00,0x0c,0x00,
0x1c,0x00,0x00,0x14,0x02,0x00,0x1c,0x07,0x00,0x84,0x52,0x0b,
0x54,0x52,0x15,0x54,0x52,0x0d,0x94,0x74,0x19,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};
#define library_width 45
#define library_height 22
static unsigned char library_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf0,0x00,0xde,0x03,0x00,
0x00,0x9e,0x1c,0x52,0x02,0x00,0x00,0x92,0xf7,0x52,0x0e,0x00,
0x80,0x93,0x94,0x53,0x0a,0x00,0x80,0x92,0x94,0x52,0x7a,0x00,
0x80,0x92,0x94,0x52,0x4a,0x00,0x80,0x92,0x94,0x52,0x4a,0x00,
0x80,0x92,0x94,0x52,0x4a,0x00,0x80,0x92,0x94,0x52,0x4a,0x00,
0x80,0x92,0x94,0x52,0x4a,0x00,0x80,0x92,0x94,0x52,0x4a,0x00,
0xe0,0xff,0xff,0xff,0xff,0x01,0x20,0x00,0x00,0x00,0x00,0x01,
0xe0,0xff,0xff,0xff,0xff,0x01,0x80,0x01,0x00,0x00,0x60,0x00,
0x80,0x01,0x00,0x00,0x60,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00};
#define polygon_width 22
#define polygon_height 22
static unsigned char polygon_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf0,0x3f,0x00,
0x10,0x40,0x00,0x10,0x80,0x00,0x10,0x00,0x01,0x10,0x00,0x01,
0x10,0x00,0x01,0x10,0x80,0x00,0x10,0x40,0x00,0x10,0x3e,0x00,
0x10,0x02,0x00,0x10,0x02,0x00,0x10,0x02,0x00,0x10,0x02,0x00,
0x10,0x02,0x00,0x10,0x02,0x00,0xf0,0x03,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};
#define regpoly_width 22
#define regpoly_height 22
static unsigned char regpoly_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0xff,0x00,0x20,0x00,0x01,
0x20,0x00,0x01,0x10,0x00,0x02,0x10,0x00,0x02,0x08,0x01,0x04,
0x08,0x01,0x04,0x04,0x0d,0x08,0x04,0x0d,0x08,0x08,0x00,0x04,
0x08,0x00,0x04,0x10,0x00,0x02,0x10,0x00,0x02,0x20,0x00,0x01,
0x20,0x80,0x0d,0xc0,0xff,0x09,0x00,0x00,0x04,0x00,0x00,0x0c,
0x00,0x00,0x00,0x00,0x00,0x00};
#define rotCCW_width 22
#define rotCCW_height 22
static unsigned char rotCCW_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x00,0x00,0xc0,0x00,0x00,
0xa0,0x3f,0x00,0x10,0x40,0x00,0x10,0x80,0x00,0xa0,0x1f,0x01,
0xc0,0x20,0x01,0x80,0x40,0x02,0x00,0x40,0x02,0x00,0x40,0x02,
0x00,0x40,0x02,0x60,0x40,0x02,0x90,0x20,0x01,0x10,0x1f,0x01,
0x20,0x80,0x00,0xc0,0x60,0x00,0x00,0x1f,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};
#define rotCW_width 22
#define rotCW_height 22
static unsigned char rotCW_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x40,0x00,0x00,0xc0,0x00,
0x00,0x7f,0x01,0x80,0x00,0x02,0x40,0x00,0x02,0x20,0x7e,0x01,
0x20,0xc1,0x00,0x90,0x40,0x00,0x90,0x00,0x00,0x90,0x00,0x00,
0x90,0x00,0x00,0x90,0x80,0x01,0x20,0x41,0x02,0x20,0x3e,0x02,
0x40,0x00,0x01,0x80,0xc1,0x00,0x00,0x3e,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};
#define scale_width 22
#define scale_height 22
static unsigned char scale_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0a,0x01,0x10,0x11,0x01,
0x90,0xbf,0x02,0x28,0x91,0x02,0x28,0x4a,0x04,0x7c,0x40,0x04,
0x00,0xe0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x18,0x80,0x00,
0x24,0x80,0x00,0x04,0x80,0x00,0x08,0x9b,0x04,0xb0,0xa0,0x0a,
0xa0,0xb8,0x0e,0xa4,0xa8,0x02,0x18,0xb3,0x0c,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};
#define spl_width 22
#define spl_height 22
static unsigned char spl_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0x0f,0x00,
0x20,0x10,0x00,0x10,0x20,0x00,0x10,0x00,0x00,0x20,0x00,0x00,
0x40,0x00,0x00,0x80,0x01,0x00,0x00,0x3e,0x00,0x00,0xc0,0x00,
0x00,0x00,0x01,0x00,0x00,0x02,0x00,0x00,0x02,0x00,0x00,0x02,
0x00,0x00,0x03,0x10,0xe0,0x00,0xe0,0x1f,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};
#define text_width 22
#define text_height 22
static unsigned char text_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfc,0xff,0x07,
0xfc,0xff,0x07,0x0c,0x1f,0x06,0x04,0x0e,0x04,0x00,0x0e,0x00,
0x00,0x0e,0x00,0x00,0x0e,0x00,0x00,0x0e,0x00,0x00,0x0e,0x00,
0x00,0x0e,0x00,0x00,0x0e,0x00,0x00,0x0e,0x00,0x00,0x0e,0x00,
0x00,0x0e,0x00,0x00,0x3f,0x00,0xe0,0xff,0x01,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};
#define update_width 22
#define update_height 22
static unsigned char update_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x48,0x00,0x00,
0x48,0x00,0x00,0x48,0x00,0x00,0x48,0x07,0x00,0x48,0xe5,0x00,
0x78,0x07,0x00,0x00,0x01,0x00,0x00,0x01,0x00,0x00,0x00,0x00,
0x40,0x00,0x00,0x40,0x23,0x00,0x70,0x64,0x02,0x48,0x27,0x05,
0x48,0x25,0x03,0x70,0x4b,0x06,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};
#define tangent_width 22
#define tangent_height 22
static unsigned char tangent_bits[] = {
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x0f,0x00,0x03,0x02,
 0x00,0x0c,0x02,0x24,0x10,0x02,0x2c,0x20,0x00,0x34,0x20,0x00,
 0x24,0x40,0x00,0x00,0x40,0x00,0xfe,0xff,0x03,0x00,0x40,0x00,
 0x00,0x40,0x00,0x00,0x20,0x00,0x00,0x20,0x00,0x00,0x10,0x00,
 0x00,0x0c,0x00,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,};
#define anglemeas_width 22
#define anglemeas_height 22
static unsigned char anglemeas_bits[] = {
 0x00,0x00,0xc0,0x00,0x00,0xc0,0x00,0x00,0xc0,0x36,0x00,0xc0,0x74,0x00,0xc0,
 0x84,0x01,0xc0,0x0e,0x02,0xc0,0x00,0x0c,0xc0,0x00,0x38,0xc0,0x00,0xc4,0xc8,
 0x00,0x84,0xd3,0x00,0x84,0xcb,0x00,0x68,0xd8,0x00,0x18,0xc0,0x06,0x06,0xc0,
 0x84,0x01,0xc0,0x66,0x00,0xc0,0x34,0x00,0xc0,0x36,0x00,0xc0,0x00,0x00,0xc0,
 0x00,0x00,0xc0,0x00,0x00,0xc0};
#define lenmeas_width 22
#define lenmeas_height 22
static unsigned char lenmeas_bits[] = {
 0x00,0x00,0xc0,0x00,0x00,0xc0,0x00,0x00,0xc0,0xf0,0x00,0xc0,0x8c,0xc0,0xcc,
 0x84,0xb0,0xc8,0x82,0x10,0xc9,0xc2,0x10,0xc9,0x60,0x08,0xc9,0x18,0x0c,0xcf,
 0x08,0x02,0xc0,0xf0,0x01,0xc0,0x00,0x00,0xc0,0x00,0x00,0xc0,0x00,0x00,0xc0,
 0x00,0x00,0xc0,0x24,0x49,0xd2,0xfc,0xff,0xdf,0x00,0x00,0xc0,0x00,0x00,0xc0,
 0x00,0x00,0xc0,0x00,0x00,0xc0};
#define areameas_width 22
#define areameas_height 22
static unsigned char areameas_bits[] = {
 0x00,0x00,0xc0,0x00,0x00,0xc0,0x00,0x00,0xc0,0x80,0x01,0xc0,0xc0,0x03,0xc0,
 0x60,0x05,0xc0,0x50,0x0d,0xc0,0x58,0x15,0xc0,0x54,0x15,0xc0,0x56,0x35,0xc0,
 0x56,0x35,0xcc,0x56,0xf5,0xd7,0x56,0x55,0xd5,0x56,0x55,0xd5,0xdc,0x57,0xd5,
 0x78,0x5c,0xcd,0x18,0x58,0xc7,0x00,0xf8,0xc1,0x00,0x20,0xc0,0x00,0x00,0xc0,
 0x00,0x00,0xc0,0x00,0x00,0xc0};

#else /* USE_SMALL_ICONS */

/****** NORMAL SIZE ICONS ******/

#define regpoly_width 36
#define regpoly_height 32
static unsigned char regpoly_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0xf8,0xff,0x00,0x00,0x00,0x04,
0x00,0x01,0x00,0x00,0x04,0x00,0x01,0x00,0x00,0x02,0x00,
0x02,0x00,0x00,0x01,0x00,0x04,0x00,0x00,0x01,0x00,0x04,
0x00,0x80,0x00,0x00,0x08,0x00,0x80,0x00,0x00,0x08,0x00,
0x40,0x10,0x00,0x10,0x00,0x20,0x18,0x00,0x20,0x00,0x20,
0x10,0x07,0x20,0x00,0x10,0x10,0x07,0x40,0x00,0x20,0x10,
0x07,0x20,0x00,0x20,0x10,0x00,0x20,0x00,0x40,0x38,0x00,
0x10,0x00,0x80,0x00,0x00,0x08,0x00,0x80,0x00,0x00,0x08,
0x00,0x00,0x01,0x00,0x04,0x00,0x00,0x01,0x00,0x04,0x00,
0x00,0x02,0x00,0x62,0x00,0x00,0x04,0x00,0x91,0x00,0x00,
0x04,0xc0,0x81,0x00,0x00,0xf8,0xff,0x41,0x00,0x00,0x00,
0xc0,0x21,0x00,0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x00,
0xf0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};

#define addpt_width 36
#define addpt_height 32
static unsigned char addpt_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x80,0x1f,0x00,0x00,0x00,0x80,0x1f,
0x00,0x00,0x00,0x80,0x19,0x00,0x00,0x00,0x80,0x19,0x00,
0x00,0x00,0x80,0x1f,0x00,0x00,0x00,0xc0,0x3f,0x00,0x00,
0x00,0x60,0x60,0x00,0x00,0x00,0x30,0xc0,0x00,0x00,0x00,
0x18,0x80,0x01,0x00,0x00,0x0c,0x02,0x03,0x00,0x00,0x06,
0x07,0x06,0x00,0x00,0x83,0x0a,0x0c,0x00,0x80,0x01,0x02,
0x18,0x00,0xc0,0x00,0x02,0x30,0x00,0x60,0x00,0x02,0x60,
0x00,0x30,0x00,0x02,0xc0,0x00,0x18,0x00,0x02,0x80,0x01,
0x00,0x00,0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xa8,0xaa,0xaa,0xaa,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};

#define align_width 36
#define align_height 32
static unsigned char align_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x1f,0x00,0x00,0x00,0xc0,0x60,
0x00,0x00,0x00,0x20,0x80,0x00,0x00,0x00,0x20,0x80,0x00,0x00,
0x00,0x10,0x00,0x01,0x00,0x01,0x10,0x00,0x01,0x00,0xc1,0x13,
0x00,0x01,0x80,0x42,0x12,0x00,0x01,0x80,0x42,0x12,0x00,0x01,
0x40,0x44,0x22,0x80,0x00,0x40,0x44,0x22,0x80,0x00,0x20,0x48,
0xc2,0x60,0x00,0xe0,0xcf,0x03,0x1f,0x00,0x54,0x55,0x55,0x55,
0x01,0x00,0x00,0x00,0x00,0x00,0x80,0x31,0x00,0x00,0x00,0x40,
0x22,0x02,0x00,0x00,0x20,0x24,0x00,0x00,0x00,0x20,0x24,0x63,
0x35,0x00,0x20,0x24,0x92,0x4c,0x00,0xe0,0x27,0x92,0x44,0x00,
0x20,0x24,0x62,0x44,0x00,0x20,0x24,0x12,0x44,0x00,0x20,0x74,
0xe7,0x44,0x00,0x00,0x00,0x10,0x01,0x00,0x00,0x00,0xe0,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,};

#define arc_width 36
#define arc_height 32
static unsigned char arc_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x80,0x38,0x00,0x00,0x00,0xc0,0xf8,
0x00,0x00,0x00,0x80,0x38,0x03,0x00,0x00,0x80,0x00,0x0c,
0x00,0x00,0x80,0x00,0x10,0x00,0x00,0x80,0x00,0x20,0x00,
0x00,0xc0,0x01,0x20,0x00,0x00,0x00,0x00,0x40,0x00,0x00,
0x00,0x00,0x40,0x00,0x00,0x00,0x00,0x80,0x30,0x00,0x00,
0x00,0x80,0x48,0x00,0x00,0x00,0xc0,0x41,0x00,0x00,0x00,
0xc0,0x21,0x00,0x00,0x00,0xc0,0x11,0x00,0x00,0x00,0x80,
0x08,0x00,0x00,0x00,0x80,0x78,0x00,0x00,0x00,0x40,0x00,
0x00,0x00,0x00,0x40,0x00,0x00,0xc0,0x00,0x20,0x00,0x00,
0x20,0x01,0x20,0x00,0x00,0x00,0x01,0x10,0x00,0x00,0xc0,
0x00,0x0c,0x00,0x00,0x00,0x39,0x03,0x00,0x00,0x20,0xf9,
0x00,0x00,0x00,0xc0,0x38,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};

#define autoarrow_width 36
#define autoarrow_height 32
static unsigned char autoarrow_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x04,0x00,0x02,
0x00,0x00,0x04,0x00,0x02,0x00,0x00,0x0e,0x08,0x87,0x00,0x00,
0x0a,0x10,0x45,0x00,0x00,0x0a,0x10,0x45,0x00,0x00,0x11,0xa0,
0x28,0x00,0x00,0x11,0xa0,0x28,0x00,0x00,0x11,0xc0,0x18,0x00,
0x80,0x20,0xc0,0x18,0x00,0x80,0x20,0xc0,0x18,0x00,0x80,0x20,
0x40,0x15,0x00,0x40,0x40,0x20,0x22,0x00,0x40,0x40,0x20,0x25,
0x00,0x40,0x40,0x20,0x25,0x00,0xe0,0xff,0xf0,0x7f,0x00,0x00,
0x04,0x40,0x12,0x00,0x00,0x04,0x40,0x12,0x00,0x00,0x04,0x20,
0x22,0x00,0x00,0x04,0x20,0x22,0x00,0x00,0x04,0x10,0x42,0x00,
0x00,0x04,0x10,0x42,0x00,0x00,0x04,0x00,0x02,0x00,0x00,0x04,
0x00,0x02,0x00,0x00,0x04,0x00,0x02,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00};

#define box_width 36
#define box_height 32
static unsigned char box_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0xff,0xff,0x1f,
0x00,0x80,0x00,0x00,0x10,0x00,0x80,0x00,0x00,0x10,0x00,
0x80,0x00,0x00,0x10,0x00,0x80,0x00,0x00,0x10,0x00,0x80,
0x00,0x00,0x10,0x00,0x80,0x00,0x00,0x10,0x00,0x80,0x00,
0x00,0x10,0x00,0x80,0x00,0x00,0x10,0x00,0x80,0x00,0x00,
0x10,0x00,0x80,0x00,0x00,0x10,0x00,0x80,0x00,0x00,0x10,
0x00,0x80,0x00,0x00,0x10,0x00,0x80,0x00,0x00,0x10,0x00,
0x80,0x00,0x00,0x10,0x00,0x80,0xff,0xff,0x1f,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};

#define arc_box_width 36
#define arc_box_height 32
static unsigned char arc_box_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0xfc,0xff,0x03,0x00,0x00,0x03,0x00,0x0c,
0x00,0x80,0x00,0x00,0x10,0x00,0x80,0x00,0x00,0x10,0x00,
0x40,0x00,0x00,0x20,0x00,0x40,0x00,0x00,0x20,0x00,0x40,
0x00,0x00,0x20,0x00,0x40,0x00,0x00,0x20,0x00,0x40,0x00,
0x00,0x20,0x00,0x40,0x00,0x00,0x20,0x00,0x40,0x00,0x00,
0x20,0x00,0x40,0x00,0x00,0x20,0x00,0x40,0x00,0x00,0x20,
0x00,0x40,0x00,0x00,0x20,0x00,0x80,0x00,0x00,0x10,0x00,
0x80,0x00,0x00,0x10,0x00,0x00,0x03,0x00,0x0c,0x00,0x00,
0xfc,0xff,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};

#define cirdia_width 36
#define cirdia_height 32
static unsigned char cirdia_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xc0,0x7f,0x00,0x00,0x00,0x78,0xc0,0x03,
0x00,0x00,0x0c,0x00,0x06,0x00,0x00,0x06,0x00,0x0c,0x00,0x00,
0x01,0x00,0x10,0x00,0x80,0x01,0x00,0x30,0x00,0x80,0x00,0x00,
0x20,0x00,0x40,0x00,0x00,0x40,0x00,0x40,0x00,0x00,0x40,0x00,
0x60,0x00,0x00,0xc0,0x00,0x20,0x00,0x04,0x80,0x00,0x20,0x00,
0x04,0x80,0x00,0x60,0x55,0x5f,0xd5,0x00,0x20,0x00,0x04,0x80,
0x00,0x20,0x00,0x04,0x80,0x00,0x20,0x00,0x00,0x80,0x00,0x40,
0x00,0x00,0x40,0x00,0x40,0x00,0x00,0x40,0x00,0x40,0x00,0x00,
0x40,0x00,0x80,0x00,0x00,0x20,0x00,0x00,0x01,0x00,0x10,0x00,
0x00,0x01,0x00,0x10,0x00,0x00,0x06,0x00,0x0c,0x00,0x00,0x08,
0x00,0x02,0x00,0x00,0x70,0xc0,0x01,0x00,0x00,0x80,0x3f,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,};

#define cirrad_width 36
#define cirrad_height 32
static unsigned char cirrad_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xc0,0x7f,0x00,0x00,0x00,0x78,0xc0,0x03,
0x00,0x00,0x0c,0x00,0x06,0x00,0x00,0x06,0x00,0x0c,0x00,0x00,
0x01,0x00,0x10,0x00,0x80,0x01,0x00,0x30,0x00,0x80,0x00,0x00,
0x20,0x00,0x40,0x00,0x00,0x40,0x00,0x40,0x00,0x00,0x40,0x00,
0x60,0x00,0x00,0xc0,0x00,0x20,0x00,0x04,0x80,0x00,0x20,0x00,
0x04,0x80,0x00,0x20,0x00,0x5f,0xd5,0x00,0x20,0x00,0x04,0x80,
0x00,0x20,0x00,0x04,0x80,0x00,0x20,0x00,0x00,0x80,0x00,0x40,
0x00,0x00,0x40,0x00,0x40,0x00,0x00,0x40,0x00,0x40,0x00,0x00,
0x40,0x00,0x80,0x00,0x00,0x20,0x00,0x00,0x01,0x00,0x10,0x00,
0x00,0x01,0x00,0x10,0x00,0x00,0x06,0x00,0x0c,0x00,0x00,0x08,
0x00,0x02,0x00,0x00,0x70,0xc0,0x01,0x00,0x00,0x80,0x3f,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,};

#define convert_width 36
#define convert_height 32
static unsigned char convert_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0xe0,0x00,0x00,0x80,0x00,0x10,0x00,0x00,0x40,
0x00,0x08,0x00,0x00,0x20,0x00,0x08,0x00,0x00,0x10,0x00,0x08,
0x00,0x00,0x08,0x00,0x10,0x10,0x40,0x04,0x00,0x60,0x08,0x80,
0x08,0x00,0x80,0xfc,0xff,0x11,0x00,0x00,0x09,0x80,0x20,0x00,
0x00,0x11,0x40,0x40,0x00,0x00,0x01,0x00,0x20,0x00,0x80,0x00,
0x00,0x10,0x00,0x70,0x00,0x00,0x08,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0xf8,0x7f,0x80,0x7f,0x00,0x08,
0x40,0x40,0x80,0x00,0x08,0x48,0x20,0x01,0x01,0x08,0x44,0x20,
0x02,0x01,0x08,0xfe,0xff,0x07,0x01,0x08,0x44,0x20,0x02,0x01,
0x08,0x48,0x20,0x01,0x01,0x08,0x40,0x20,0x00,0x01,0x08,0x40,
0x40,0x80,0x00,0xf8,0x7f,0x80,0x7f,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,};

#define c_spl_width 36
#define c_spl_height 32
static unsigned char c_spl_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xe0,
0x1f,0x00,0x00,0x00,0x1c,0x60,0x00,0x00,0x00,0x02,0x80,
0x00,0x00,0x00,0x01,0x00,0x01,0x00,0x00,0x01,0x00,0x01,
0x00,0x00,0x01,0x80,0x00,0x00,0x00,0x01,0x40,0x00,0x00,
0x00,0x02,0x30,0x00,0x00,0x00,0x3c,0x0c,0x00,0x00,0x00,
0xc0,0x7f,0x00,0x00,0x00,0x30,0x80,0x07,0x00,0x00,0x0c,
0x00,0x08,0x00,0x00,0x03,0x00,0x10,0x00,0x80,0x00,0x00,
0x20,0x00,0x40,0x00,0x00,0x20,0x00,0x40,0x00,0x00,0x20,
0x00,0x20,0x00,0x00,0x20,0x00,0x20,0x00,0x00,0x20,0x00,
0x20,0x00,0x00,0x10,0x00,0x40,0x00,0x00,0x08,0x00,0x40,
0x00,0x00,0x04,0x00,0x80,0x00,0x00,0x03,0x00,0x00,0x07,
0xf0,0x00,0x00,0x00,0xf8,0x0f,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};

#define copy_width 36
#define copy_height 32
static unsigned char copy_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x03,
0x00,0x1c,0x00,0xc0,0x07,0x00,0x3e,0x00,0x60,0x0c,0x00,0x63,
0x00,0x30,0x0c,0x80,0x61,0x00,0x30,0x0c,0x80,0x61,0x00,0x30,
0x0c,0x80,0x61,0x00,0x30,0x18,0x88,0xc1,0x00,0x30,0x18,0x90,
0xc1,0x00,0x30,0xd8,0xbf,0xc1,0x00,0x30,0x18,0x90,0xc1,0x00,
0x30,0x18,0x88,0xc1,0x00,0x30,0x0c,0x80,0x61,0x00,0x60,0x0c,
0x00,0x63,0x00,0xc0,0x0c,0x00,0x66,0x00,0x80,0x0f,0x00,0x7c,
0x00,0x00,0x07,0x00,0x38,0x00,0x00,0x00,0x00,0x00,0x00,0x80,
0x03,0x00,0x00,0x00,0x40,0x04,0x00,0x00,0x00,0x40,0x00,0x00,
0x00,0x00,0x40,0xe0,0x34,0x11,0x00,0x40,0x10,0x4d,0x11,0x00,
0x40,0x10,0x45,0x11,0x00,0x40,0x14,0x4d,0x19,0x00,0x80,0xe3,
0x34,0x16,0x00,0x00,0x00,0x04,0x10,0x00,0x00,0x00,0x04,0x0f,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,};

#define glue_width 36
#define glue_height 32
static unsigned char glue_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x38,0x00,0x00,0xe0,0x00,0xf8,0xff,
0xff,0xff,0x00,0x38,0x00,0x00,0xe0,0x00,0x10,0x00,0xe0,
0x40,0x00,0x10,0x3c,0x18,0x43,0x00,0x10,0x42,0x04,0x44,
0x00,0x10,0x81,0x04,0x44,0x00,0x10,0x01,0x04,0x44,0x00,
0x10,0x02,0x18,0x43,0x00,0x10,0x3c,0xe0,0x40,0x00,0x10,
0x40,0x00,0x40,0x00,0x10,0x80,0x00,0x40,0x00,0x10,0x81,
0x00,0x41,0x00,0x10,0x42,0x00,0x42,0x00,0x10,0x3c,0x00,
0x44,0x00,0x10,0x00,0xfe,0x48,0x00,0x10,0x00,0x10,0x48,
0x00,0x10,0x00,0x10,0x48,0x00,0x10,0xff,0x10,0x48,0x00,
0x10,0x81,0x10,0x48,0x00,0x10,0x81,0x10,0x44,0x00,0x10,
0x81,0x10,0x42,0x00,0x10,0xff,0x10,0x41,0x00,0x10,0x00,
0x00,0x40,0x00,0x38,0x00,0x00,0xe0,0x00,0xf8,0xff,0xff,
0xff,0x00,0x38,0x00,0x00,0xe0,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};

#define break_width 36
#define break_height 32
static unsigned char break_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x50,0x55,
0x55,0x55,0x00,0x00,0x00,0x00,0x00,0x00,0x10,0x00,0xe0,
0x40,0x00,0x00,0x3c,0x18,0x03,0x00,0x10,0x42,0x04,0x44,
0x00,0x00,0x81,0x04,0x04,0x00,0x10,0x01,0x04,0x44,0x00,
0x00,0x02,0x18,0x03,0x00,0x10,0x3c,0xe0,0x40,0x00,0x00,
0x40,0x00,0x00,0x00,0x10,0x80,0x00,0x40,0x00,0x00,0x81,
0x00,0x01,0x00,0x10,0x42,0x00,0x42,0x00,0x00,0x3c,0x00,
0x04,0x00,0x10,0x00,0xfe,0x48,0x00,0x00,0x00,0x10,0x08,
0x00,0x10,0x00,0x10,0x48,0x00,0x00,0xff,0x10,0x08,0x00,
0x10,0x81,0x10,0x48,0x00,0x00,0x81,0x10,0x04,0x00,0x10,
0x81,0x10,0x42,0x00,0x00,0xff,0x10,0x01,0x00,0x10,0x00,
0x00,0x40,0x00,0x00,0x00,0x00,0x00,0x00,0x50,0x55,0x55,
0x55,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};

#define open_comp_width 36
#define open_comp_height 32
static unsigned char open_comp_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x18,0x00,0x0c,0x00,0x00,0xf8,0xff,0x0f,0x00,0x00,0x10,
0x00,0x04,0x00,0x00,0x10,0x00,0x04,0x00,0x00,0x90,0x01,0x04,
0x00,0x00,0x50,0x02,0x04,0x00,0x00,0x50,0x82,0x04,0x00,0x00,
0x90,0xe1,0x04,0x00,0x00,0x10,0x98,0x04,0x00,0x00,0x10,0x8c,
0x04,0x00,0x00,0x10,0xb0,0x04,0x00,0x00,0x10,0xc0,0x04,0x00,
0x00,0x10,0x00,0x04,0x00,0x00,0xf8,0xff,0x0f,0x00,0x00,0x18,
0x00,0x0c,0x00,0x00,0x00,0x00,0xc0,0x00,0x00,0x00,0x00,0x20,
0x01,0x00,0x00,0x00,0x20,0x41,0x00,0x00,0x00,0xc0,0x70,0x00,
0x00,0x00,0x00,0x4c,0x00,0x00,0x00,0x00,0x46,0x00,0x00,0x00,
0x00,0x58,0x00,0x00,0x00,0x00,0x60,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00};

#define join_split_width 36
#define join_split_height 32
static unsigned char join_split_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x08,0x80,0x00,0x00,0x01,0x10,0x40,0x03,0x00,
0x01,0x10,0x40,0x04,0x80,0x00,0x20,0x78,0x18,0x80,0x00,0x40,
0x78,0x20,0x40,0x00,0x40,0x78,0x40,0x20,0x00,0x80,0x78,0x80,
0x21,0x00,0x00,0x0d,0x04,0x12,0x00,0x00,0x05,0x0e,0x0c,0x00,
0x00,0x02,0x15,0x00,0x00,0x00,0x00,0x04,0x00,0x00,0x00,0x00,
0x04,0x00,0x00,0x00,0x00,0x04,0x00,0x00,0x00,0x00,0x15,0x00,
0x00,0x00,0x00,0x0e,0x00,0x00,0x00,0x00,0x04,0x00,0x00,0x08,
0x00,0x00,0x00,0x00,0x10,0x80,0x00,0x00,0x01,0x10,0x00,0x03,
0x00,0x01,0x20,0x00,0x04,0x80,0x00,0x40,0x00,0x18,0x80,0x00,
0x40,0x00,0x20,0x40,0x00,0x80,0x00,0x40,0x20,0x00,0x00,0x01,
0x80,0x21,0x00,0x00,0x01,0x00,0x12,0x00,0x00,0x00,0x00,0x0c,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00};

#define delete_width 36
#define delete_height 32
static unsigned char delete_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x80,0x07,0x00,0x00,0x00,0xc0,
0x0f,0x00,0x00,0x00,0xe0,0x1f,0x00,0x00,0x00,0x30,0x33,
0x00,0x00,0x00,0x30,0x33,0x00,0x00,0x00,0xe0,0x1f,0x00,
0x00,0x00,0xc0,0x0f,0x00,0x00,0x00,0x80,0x07,0x00,0x00,
0x00,0x84,0x87,0x00,0x00,0x00,0x84,0x87,0x01,0x00,0x00,
0x08,0x43,0x00,0x00,0x00,0x70,0x38,0x00,0x00,0x00,0x80,
0x07,0x00,0x00,0x00,0xe0,0x1f,0x01,0x00,0x00,0x3c,0xf0,
0x01,0x00,0x00,0x04,0x80,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x3c,0xc0,0x00,0x02,0x00,
0x48,0x80,0x00,0x07,0x00,0x48,0x8e,0x38,0xc2,0x01,0x48,
0x91,0x44,0x22,0x02,0x48,0x9f,0x7c,0xe2,0x03,0x48,0x81,
0x04,0x22,0x00,0x48,0x91,0x44,0x2a,0x02,0x3c,0xce,0x39,
0xc4,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};

#define deletept_width 36
#define deletept_height 32
static unsigned char deletept_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xc0,0x01,0x00,0x00,0x00,0x40,0x01,0x00,
0x00,0x00,0xc0,0x01,0x00,0x00,0x80,0xc7,0x00,0x00,0x00,0x00,
0xa9,0x00,0x00,0x00,0x00,0xb2,0x00,0x00,0x00,0x00,0xa4,0x00,
0x00,0x00,0x00,0xc8,0x00,0x00,0x00,0x10,0x98,0x00,0x00,0x00,
0x70,0x28,0x01,0x00,0x00,0x90,0x45,0x02,0x00,0x00,0x30,0x86,
0x04,0x00,0x00,0xc0,0x9a,0x09,0x00,0x00,0x00,0xe3,0x12,0x00,
0x00,0x00,0x8d,0x25,0x00,0x00,0x00,0xb1,0x4e,0x00,0x00,0x80,
0xc0,0x58,0x38,0x00,0x80,0x80,0xe3,0x7c,0x00,0x40,0x80,0xfe,
0xcf,0x00,0x20,0x80,0x80,0x9d,0x00,0x20,0x80,0xc0,0xf3,0x00,
0x10,0x80,0xc0,0x66,0x00,0x10,0x80,0xc0,0x0c,0x00,0x00,0x80,
0x80,0x09,0x00,0x00,0x80,0x00,0x0b,0x00,0x00,0x80,0x00,0x0e,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,};

#define elldia_width 36
#define elldia_height 32
static unsigned char elldia_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x3f,0x00,0x00,0x00,
0x70,0xc4,0x01,0x00,0x00,0x0c,0x00,0x06,0x00,0x00,0x02,0x04,
0x08,0x00,0x00,0x01,0x00,0x10,0x00,0x80,0x00,0x04,0x20,0x00,
0x40,0x00,0x00,0x40,0x00,0x40,0x00,0x04,0x40,0x00,0x20,0x00,
0x04,0x80,0x00,0x60,0x55,0x5f,0xd5,0x00,0x20,0x00,0x04,0x80,
0x00,0x40,0x00,0x04,0x40,0x00,0x40,0x00,0x00,0x40,0x00,0x80,
0x00,0x04,0x20,0x00,0x00,0x01,0x00,0x10,0x00,0x00,0x02,0x04,
0x08,0x00,0x00,0x0c,0x00,0x06,0x00,0x00,0x70,0xc4,0x01,0x00,
0x00,0x80,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,};

#define ellrad_width 36
#define ellrad_height 32
static unsigned char ellrad_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x3f,0x00,0x00,0x00,
0x70,0xc4,0x01,0x00,0x00,0x0c,0x00,0x06,0x00,0x00,0x02,0x04,
0x08,0x00,0x00,0x01,0x00,0x10,0x00,0x80,0x00,0x04,0x20,0x00,
0x40,0x00,0x00,0x40,0x00,0x40,0x00,0x04,0x40,0x00,0x20,0x00,
0x04,0x80,0x00,0x20,0x00,0x5f,0xd5,0x00,0x20,0x00,0x04,0x80,
0x00,0x40,0x00,0x04,0x40,0x00,0x40,0x00,0x00,0x40,0x00,0x80,
0x00,0x00,0x20,0x00,0x00,0x01,0x00,0x10,0x00,0x00,0x02,0x00,
0x08,0x00,0x00,0x0c,0x00,0x06,0x00,0x00,0x70,0xc0,0x01,0x00,
0x00,0x80,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,};

#define flip_x_width 36
#define flip_x_height 32
static unsigned char flip_x_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x02,0x00,0x00,0x00,0x1c,0xc0,0x01,0x00,0x00,0x22,
0x22,0x02,0x00,0x00,0x41,0x10,0x04,0x00,0x00,0x41,0x12,
0x04,0x00,0x00,0x41,0x10,0x04,0x00,0x00,0x22,0x22,0x02,
0x00,0x00,0x14,0x40,0x01,0x00,0x00,0x14,0x42,0x01,0x00,
0x80,0xe3,0x38,0x0e,0x00,0x40,0x00,0x07,0x10,0x00,0x20,
0xc3,0x18,0x24,0x00,0x90,0x22,0x27,0x4a,0x00,0x50,0x22,
0x22,0x52,0x00,0x30,0x41,0x10,0x64,0x00,0x00,0x41,0x12,
0x04,0x00,0x80,0x80,0x08,0x08,0x00,0x80,0x80,0x0a,0x08,
0x00,0x40,0x00,0x05,0x10,0x00,0xc0,0xeb,0xbf,0x1e,0x00,
0x00,0x2a,0xa0,0x02,0x00,0x00,0x2a,0xa2,0x02,0x00,0x00,
0x2a,0xa0,0x02,0x00,0x00,0x2a,0xa2,0x02,0x00,0x00,0x2a,
0xa0,0x02,0x00,0x00,0x2a,0xa2,0x02,0x00,0x00,0x3e,0xe0,
0x03,0x00,0x00,0x00,0x02,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};

#define flip_y_width 36
#define flip_y_height 32
static unsigned char flip_y_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x40,
0x00,0x00,0x00,0x00,0x40,0x00,0x00,0x00,0x00,0xa0,0x00,
0x00,0x00,0x00,0xa0,0x00,0x04,0x00,0x00,0x10,0x01,0x02,
0x00,0x00,0x10,0x01,0x0f,0x00,0x00,0x08,0x02,0x32,0x00,
0x00,0x08,0x02,0x44,0x00,0x00,0x04,0x04,0x40,0x00,0x00,
0xfc,0x07,0x80,0x00,0x00,0x00,0x00,0x80,0x00,0x50,0x55,
0x55,0x81,0x00,0x00,0x00,0x00,0x80,0x00,0x00,0xfc,0x07,
0x80,0x00,0x00,0x04,0x04,0x40,0x00,0x00,0x08,0x02,0x44,
0x00,0x00,0x08,0x02,0x32,0x00,0x00,0x10,0x01,0x0f,0x00,
0x00,0x10,0x01,0x02,0x00,0x00,0xa0,0x00,0x04,0x00,0x00,
0xa0,0x00,0x00,0x00,0x00,0x40,0x00,0x00,0x00,0x00,0x40,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};

#define intspl_width 36
#define intspl_height 32
static unsigned char intspl_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x07,0x00,0x00,0x00,0xe0,
0x1f,0x00,0x00,0x00,0x1c,0xe7,0x03,0x00,0x00,0x02,0x80,
0x03,0x00,0x00,0x01,0x80,0x03,0x00,0x80,0x03,0x00,0x00,
0x00,0x80,0x03,0x00,0x00,0x00,0x80,0x03,0x00,0x00,0x00,
0x00,0x02,0x00,0x00,0x00,0x00,0x3c,0x0e,0x00,0x00,0x00,
0xc0,0x7f,0x00,0x00,0x00,0x00,0x8e,0x07,0x00,0x00,0x00,
0x00,0x08,0x00,0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x00,
0x20,0x00,0x00,0x00,0x00,0x70,0x00,0x00,0x00,0x00,0x70,
0x00,0xe0,0x00,0x00,0x70,0x00,0xe0,0x00,0x00,0x20,0x00,
0xe0,0x00,0x00,0x10,0x00,0x80,0x00,0x00,0x0c,0x00,0x00,
0x01,0x00,0x03,0x00,0x00,0x8e,0xe3,0x00,0x00,0x00,0xf0,
0x1f,0x00,0x00,0x00,0x80,0x03,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};

#define c_intspl_width 36
#define c_intspl_height 32
static unsigned char c_intspl_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x80,0x03,0x00,0x00,0x00,0xe0,
0x1f,0x00,0x00,0x00,0x9c,0x63,0x00,0x00,0x00,0x02,0xc0,
0x01,0x00,0x80,0x03,0xc0,0x01,0x00,0x80,0x03,0xc0,0x01,
0x00,0x80,0x03,0x80,0x00,0x00,0x00,0x01,0x40,0x00,0x00,
0x00,0x02,0x30,0x00,0x00,0x00,0x3c,0x1c,0x00,0x00,0x00,
0xc0,0x7f,0x00,0x00,0x00,0x30,0x9c,0x07,0x00,0x00,0x0c,
0x00,0x08,0x00,0x00,0x03,0x00,0x10,0x00,0x80,0x00,0x00,
0x20,0x00,0x40,0x00,0x00,0x70,0x00,0x40,0x00,0x00,0x70,
0x00,0xe0,0x00,0x00,0x70,0x00,0xe0,0x00,0x00,0x20,0x00,
0xe0,0x00,0x00,0x10,0x00,0x40,0x00,0x00,0x08,0x00,0x40,
0x00,0x00,0x04,0x00,0x80,0x00,0x00,0x03,0x00,0x00,0xc7,
0xf1,0x00,0x00,0x00,0xf8,0x0f,0x00,0x00,0x00,0xc0,0x01,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};

#define line_width 36
#define line_height 32
static unsigned char line_bits[]={
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x20,0x00,0x04,0x00,0x00,0x30,0x00,
0x0c,0x00,0x00,0x50,0x00,0x0c,0x00,0x00,0x48,0x00,0x14,
0x00,0x00,0x88,0x00,0x14,0x00,0x00,0x84,0x00,0x14,0x00,
0x00,0x04,0x01,0x22,0x00,0x00,0x02,0x01,0x22,0x00,0x00,
0x02,0x02,0x22,0x00,0x00,0x01,0x02,0x42,0x00,0x00,0x01,
0x04,0x42,0x00,0x80,0x00,0x04,0x42,0x00,0x80,0x00,0x02,
0x01,0x00,0x40,0x00,0x01,0x01,0x00,0x40,0x80,0x00,0x01,
0x00,0x20,0x40,0x00,0x01,0x00,0x20,0x20,0x00,0x01,0x00,
0x00,0x10,0x00,0x01,0x00,0x00,0x08,0x80,0x00,0x00,0x00,
0x30,0x40,0x00,0x00,0x00,0xc0,0x20,0x00,0x00,0x00,0x00,
0x13,0x00,0x00,0x00,0x00,0x0c,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};

#define library_width 73
#define library_height 32
static unsigned char library_bits[]={
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf0,
0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xb0,0x01,0x00,
0x00,0x00,0x00,0x00,0xf8,0x07,0x00,0x5f,0x1f,0x00,0x00,0x00,
0x00,0x00,0xa8,0x04,0xe0,0xb9,0x13,0x00,0x00,0x00,0x00,0x00,
0x98,0x04,0xa0,0x59,0x13,0x00,0x00,0x00,0x00,0xc0,0xcf,0x04,
0x7f,0xb9,0x13,0x00,0x00,0x00,0x00,0xc0,0xae,0x04,0x3b,0xb9,
0x13,0x00,0x00,0x00,0x00,0x40,0x9d,0xfc,0xb5,0x59,0xf3,0x03,
0x00,0x00,0x00,0xc0,0xce,0xdc,0x7b,0xb9,0x73,0x03,0x00,0x00,
0x00,0x40,0xad,0xac,0x35,0x59,0xb3,0x02,0x00,0x00,0x00,0xc0,
0x9e,0xdc,0xbb,0xb9,0x73,0x03,0x00,0x00,0x00,0x60,0xcd,0xac,
0x75,0xb9,0xb3,0x0e,0x00,0x00,0x00,0xe0,0xae,0xdc,0x3b,0x59,
0x73,0x0f,0x00,0x00,0x00,0x60,0x9d,0xac,0xb5,0xb9,0xb3,0x0e,
0x00,0x00,0x00,0xe0,0xce,0xdc,0x7b,0x59,0x73,0x0f,0x00,0x00,
0x00,0x60,0xad,0xac,0x35,0xb9,0xb3,0x0e,0x00,0x00,0x00,0xe0,
0x9e,0xdc,0xbb,0xb9,0x73,0x0f,0x00,0x00,0x00,0x78,0xcd,0xac,
0x75,0x59,0xb3,0x0e,0x00,0x00,0x00,0xf8,0xff,0xff,0xff,0xff,
0xff,0x3f,0x00,0x00,0x00,0xf8,0xff,0xff,0xff,0xff,0xff,0x3f,
0x00,0x00,0x00,0x08,0x00,0x00,0x00,0x00,0x00,0x20,0x00,0x00,
0x00,0xf8,0xff,0xff,0xff,0xff,0xff,0x3f,0x00,0x00,0x00,0x80,
0x02,0x00,0x00,0x00,0x40,0x01,0x00,0x00,0x00,0x80,0x02,0x00,
0x00,0x00,0x40,0x01,0x00,0x00,0x00,0x80,0x02,0x00,0x00,0x00,
0x40,0x01,0x00,0x00,0x00,0x80,0x03,0x00,0x00,0x00,0xc0,0x01,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define move_width 36
#define move_height 32
static unsigned char move_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x80,0x02,0x00,0x1c,0x00,0x20,0x00,
0x00,0x3e,0x00,0x10,0x04,0x00,0x63,0x00,0x00,0x00,0x80,
0x61,0x00,0x10,0x04,0x80,0x61,0x00,0x00,0x08,0x80,0x61,
0x00,0x10,0x00,0x88,0xc1,0x00,0x00,0x08,0x90,0xc1,0x00,
0x10,0xc0,0xbf,0xc1,0x00,0x00,0x08,0x90,0xc1,0x00,0x10,
0x00,0x88,0xc1,0x00,0x00,0x04,0x80,0x61,0x00,0x20,0x00,
0x00,0x63,0x00,0x00,0x04,0x00,0x66,0x00,0x80,0x02,0x00,
0x7c,0x00,0x00,0x00,0x00,0x38,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x40,0x04,0x00,0x00,0x00,
0xc0,0x06,0x00,0x00,0x00,0xc0,0xc6,0x89,0x1c,0x00,0x40,
0x25,0x8a,0x22,0x00,0x40,0x25,0x8a,0x3e,0x00,0x40,0x24,
0x52,0x02,0x00,0x40,0x24,0x52,0x22,0x00,0x40,0xc4,0x21,
0x1c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};

#define movept_width 36
#define movept_height 32
static unsigned char movept_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7e,0x00,0xa0,0x02,
0x08,0x7e,0x00,0x00,0x00,0x10,0x66,0x00,0x20,0xe2,0x3f,
0x66,0x00,0x00,0x00,0x10,0x7e,0x00,0xa0,0x02,0x08,0x7e,
0x00,0x00,0x00,0x00,0x1c,0x00,0x80,0x02,0x00,0x1e,0x00,
0x00,0x00,0x00,0x1b,0x00,0x80,0x08,0x80,0x19,0x00,0x00,
0x00,0xc0,0x18,0x00,0x80,0x20,0x60,0x18,0x00,0x00,0x00,
0x30,0x18,0x00,0x80,0x80,0x18,0x18,0x00,0x00,0x00,0x0c,
0x18,0x00,0x80,0x00,0x06,0x18,0x00,0x00,0x00,0x03,0x18,
0x00,0x80,0x80,0x09,0x18,0x00,0x00,0xc0,0x00,0x18,0x00,
0x80,0x60,0x20,0x18,0x00,0x00,0x30,0x00,0x18,0x00,0x80,
0x18,0x80,0x18,0x00,0x00,0x0c,0x00,0x18,0x00,0x80,0x06,
0x00,0x1a,0x00,0x00,0x03,0x00,0x18,0x00,0x80,0x01,0x00,
0x18,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};

#define polygon_width 36
#define polygon_height 32
static unsigned char polygon_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xff,
0x7f,0x00,0x00,0x00,0x01,0x80,0x00,0x00,0x00,0x01,0x00,
0x01,0x00,0x00,0x01,0x00,0x02,0x00,0x00,0x01,0x00,0x04,
0x00,0x00,0x01,0x00,0x08,0x00,0x00,0x01,0x00,0x08,0x00,
0x00,0x01,0x00,0x08,0x00,0x00,0x01,0x00,0x08,0x00,0x00,
0x01,0x00,0x08,0x00,0x00,0x01,0x00,0x04,0x00,0x00,0x01,
0x00,0x02,0x00,0x00,0x01,0x00,0x01,0x00,0x00,0x01,0x80,
0x00,0x00,0x00,0x01,0x7f,0x00,0x00,0x00,0x01,0x01,0x00,
0x00,0x00,0x01,0x01,0x00,0x00,0x00,0x01,0x01,0x00,0x00,
0x00,0x01,0x01,0x00,0x00,0x00,0x01,0x01,0x00,0x00,0x00,
0x01,0x01,0x00,0x00,0x00,0x01,0x01,0x00,0x00,0x00,0x01,
0x01,0x00,0x00,0x00,0xff,0x01,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};

#define scale_width 36
#define scale_height 32
static unsigned char scale_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x04,0x00,0x00,0x00,
0x00,0x04,0x00,0x00,0x00,0x00,0x0a,0x00,0x40,0x20,0x04,
0x0a,0x00,0x40,0x10,0x08,0x11,0x00,0xa0,0xf8,0x1f,0x11,
0x00,0xa0,0x10,0x88,0x20,0x00,0x10,0x21,0x84,0x20,0x00,
0xf0,0x01,0x40,0x40,0x00,0x00,0x00,0x40,0x40,0x00,0x00,
0x00,0x20,0x80,0x00,0x00,0x00,0x20,0x80,0x00,0x00,0x00,
0x10,0x00,0x01,0x00,0x00,0xf0,0xff,0x01,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0xe0,0x00,0xc0,0x00,0x00,0x10,0x01,0x80,0x00,0x00,
0x10,0x00,0x80,0x00,0x00,0x10,0x38,0x8e,0x38,0x00,0xe0,
0x44,0x90,0x44,0x00,0x00,0x05,0x9e,0x7c,0x00,0x00,0x05,
0x91,0x04,0x00,0x10,0x45,0x99,0x44,0x00,0xe0,0x38,0xd6,
0x39,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};

#define spl_width 36
#define spl_height 32
static unsigned char spl_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf0,
0x0f,0x00,0x00,0x00,0x0e,0x70,0x00,0x00,0x00,0x01,0x80,
0x00,0x00,0x80,0x00,0x00,0x00,0x00,0x80,0x00,0x00,0x00,
0x00,0x80,0x00,0x00,0x00,0x00,0x80,0x00,0x00,0x00,0x00,
0x00,0x01,0x00,0x00,0x00,0x00,0x1e,0x00,0x00,0x00,0x00,
0xe0,0x3f,0x00,0x00,0x00,0x00,0xc0,0x03,0x00,0x00,0x00,
0x00,0x04,0x00,0x00,0x00,0x00,0x08,0x00,0x00,0x00,0x00,
0x10,0x00,0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x00,0x10,
0x00,0x80,0x00,0x00,0x10,0x00,0x80,0x00,0x00,0x08,0x00,
0x00,0x01,0x00,0x04,0x00,0x00,0x01,0x00,0x02,0x00,0x00,
0x02,0x80,0x01,0x00,0x00,0x1c,0x78,0x00,0x00,0x00,0xe0,
0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};

#define text_width 36
#define text_height 32
static unsigned char text_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0xff,0xff,
0x1f,0x00,0x80,0x83,0x1f,0x1c,0x00,0x80,0x01,0x0f,0x18,
0x00,0x80,0x00,0x0f,0x10,0x00,0x00,0x00,0x0f,0x00,0x00,
0x00,0x00,0x0f,0x00,0x00,0x00,0x00,0x0f,0x00,0x00,0x00,
0x00,0x0f,0x00,0x00,0x00,0x00,0x0f,0x00,0x00,0x00,0x00,
0x0f,0x00,0x00,0x00,0x00,0x0f,0x00,0x00,0x00,0x00,0x0f,
0x00,0x00,0x00,0x00,0x0f,0x00,0x00,0x00,0x00,0x0f,0x00,
0x00,0x00,0x00,0x0f,0x00,0x00,0x00,0x00,0x0f,0x00,0x00,
0x00,0x00,0x0f,0x00,0x00,0x00,0x00,0x0f,0x00,0x00,0x00,
0x80,0x1f,0x00,0x00,0x00,0xe0,0x7f,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};

#define picobj_width 36
#define picobj_height 32
static unsigned char picobj_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x3e,0x00,0x00,0x00,0x00,0x7f,0x00,
0x00,0xe0,0x9b,0xff,0x3c,0x00,0xe0,0xdb,0xff,0x3d,0x00,0xe0,
0xff,0xff,0x7f,0x00,0x30,0x00,0x00,0xc0,0x00,0xf0,0xff,0xbe,
0xff,0x00,0xf0,0xff,0xff,0xff,0x00,0xf0,0xff,0xc1,0xff,0x00,
0xf0,0xff,0x9c,0xff,0x00,0xf0,0x7f,0x22,0xff,0x00,0xf0,0x7f,
0x41,0xff,0x00,0xf0,0x7f,0x41,0xff,0x00,0xf0,0x7f,0x22,0xff,
0x00,0xf0,0xff,0x9c,0xff,0x00,0xf0,0xff,0xc1,0xff,0x00,0xf0,
0xff,0xff,0xff,0x00,0xf0,0xff,0xff,0xff,0x00,0x00,0x00,0x00,
0x00,0x00,0x78,0x04,0x00,0x00,0x00,0x90,0x00,0x02,0x00,0x00,
0x90,0x66,0x97,0x9a,0x01,0x70,0x14,0x92,0x44,0x01,0x10,0x14,
0x92,0xc4,0x00,0x10,0x14,0x92,0x44,0x00,0x38,0x64,0x64,0x8e,
0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,};

#define rotCCW_width 36
#define rotCCW_height 32
static unsigned char rotCCW_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x02,0x00,0x00,0x00,0x00,0x03,0x00,0x00,0x00,0x80,0x02,0x00,
0x00,0x00,0x40,0x1e,0x00,0x00,0x00,0x20,0x60,0x00,0x00,0x00,
0x20,0x80,0x00,0x00,0x00,0x40,0x1e,0x01,0x00,0x00,0x80,0x22,
0x01,0x00,0x00,0x00,0x43,0x02,0x00,0x00,0x00,0x42,0x02,0x00,
0x00,0x78,0x40,0x02,0x00,0x00,0x48,0x40,0x02,0x00,0x00,0x48,
0x40,0x02,0x00,0x00,0x90,0x20,0x01,0x00,0x00,0x10,0x1f,0x01,
0x00,0x00,0x20,0x80,0x00,0x00,0x00,0xc0,0x60,0x00,0x00,0x00,
0x00,0x1f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x78,0x80,0x00,
0x02,0x00,0x88,0x80,0x00,0x02,0x00,0x88,0xcc,0x31,0xc7,0x00,
0x88,0x92,0x40,0x22,0x01,0x78,0x92,0x78,0xe2,0x01,0x88,0x92,
0x48,0x22,0x00,0x88,0x92,0x4a,0x2a,0x01,0x88,0x0c,0x71,0xc4,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,};

#define rotCW_width 36
#define rotCW_height 32
static unsigned char rotCW_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x08,0x00,0x00,0x00,0x00,0x18,0x00,0x00,0x00,0x00,0x28,0x00,
0x00,0x00,0x00,0x4f,0x00,0x00,0x00,0xc0,0x80,0x00,0x00,0x00,
0x20,0x80,0x00,0x00,0x00,0x10,0x4f,0x00,0x00,0x00,0x90,0x28,
0x00,0x00,0x00,0x48,0x18,0x00,0x00,0x00,0x48,0x08,0x00,0x00,
0x00,0x48,0xc0,0x03,0x00,0x00,0x48,0x40,0x02,0x00,0x00,0x48,
0x40,0x02,0x00,0x00,0x90,0x20,0x01,0x00,0x00,0x10,0x1f,0x01,
0x00,0x00,0x20,0x80,0x00,0x00,0x00,0xc0,0x60,0x00,0x00,0x00,
0x00,0x1f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x78,0x80,0x00,
0x02,0x00,0x88,0x80,0x00,0x02,0x00,0x88,0xcc,0x31,0xc7,0x00,
0x88,0x92,0x40,0x22,0x01,0x78,0x92,0x78,0xe2,0x01,0x88,0x92,
0x48,0x22,0x00,0x88,0x92,0x4a,0x2a,0x01,0x88,0x0c,0x71,0xc4,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,};

#define update_width 36
#define update_height 32
static unsigned char update_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0xc0,0x07,0xff,0xff,0x01,0x60,0x0d,0x01,0x00,
0x01,0xb0,0x1a,0x01,0x3e,0x01,0x50,0x35,0x3d,0x2a,0x01,0xb0,
0x2a,0x01,0x36,0x01,0x50,0x35,0x7d,0x2a,0x01,0xb0,0x2a,0x01,
0x3e,0x01,0x60,0x35,0x01,0x00,0x01,0xc0,0x1f,0xff,0xff,0x01,
0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x01,0x00,0x80,0x03,
0x80,0x03,0x00,0x40,0x05,0x40,0x05,0x00,0x00,0x01,0x00,0x01,
0x00,0x00,0xff,0xff,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x48,
0x00,0x02,0x02,0x00,0x48,0x00,0x02,0x02,0x00,0x48,0x8d,0x32,
0xc7,0x00,0x48,0x53,0x43,0x22,0x01,0x48,0x51,0x7a,0xe2,0x01,
0x48,0x53,0x4a,0x22,0x00,0x48,0x4d,0x4b,0x2a,0x01,0x30,0x81,
0x72,0xc4,0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x01,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,};

#define edit_width 36
#define edit_height 32
static unsigned char edit_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0xa7,
0xaa,0xff,0x00,0x60,0x0c,0x80,0x80,0x00,0x20,0x18,0x80,
0x8e,0x00,0x30,0x30,0x80,0x80,0x00,0x10,0x20,0x80,0x9e,
0x00,0x30,0x20,0x80,0x80,0x00,0x60,0x30,0x80,0x86,0x00,
0xc0,0x18,0x80,0x80,0x00,0x80,0x0f,0x80,0xbe,0x00,0x00,
0x20,0x80,0x80,0x00,0x00,0x80,0x80,0xbe,0x00,0x00,0x00,
0x82,0x80,0x00,0x00,0x00,0x88,0x80,0x00,0x00,0x00,0xa0,
0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x1f,0x04,0x00,0x00,0x00,0x01,0x44,0x04,0x00,
0x00,0x01,0x04,0x04,0x00,0x00,0x81,0x65,0x0e,0x00,0x00,
0x4f,0x46,0x04,0x00,0x00,0x41,0x44,0x04,0x00,0x00,0x41,
0x44,0x04,0x00,0x00,0x41,0x46,0x14,0x00,0x00,0x9f,0xe5,
0x08,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};
#define areameas_width 36
#define areameas_height 32
static unsigned char areameas_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x38,0x00,0x00,
0x00,0x00,0xee,0x00,0x00,0x00,0x00,0x27,0x01,0x00,0x00,0x80,
0x25,0x03,0x00,0x00,0xc0,0x24,0x05,0x00,0x00,0xe0,0x24,0x09,
0x00,0x00,0xa0,0x24,0x09,0x00,0x00,0xb0,0x24,0x19,0x00,0x00,
0xb0,0x24,0x19,0x00,0x00,0x98,0x24,0x39,0x00,0x00,0x98,0x24,
0x29,0x00,0x00,0x98,0x24,0x29,0x60,0x00,0x98,0x24,0xe9,0xdc,
0x00,0x98,0x24,0xc9,0x97,0x01,0x98,0x24,0x49,0x92,0x01,0x98,
0x24,0x49,0x92,0x01,0x90,0x24,0x49,0x92,0x01,0xb0,0xfc,0x49,
0x92,0x01,0xb0,0x0e,0x4b,0x92,0x00,0xe0,0x03,0x4e,0xd2,0x00,
0xc0,0x00,0x4c,0x72,0x00,0x00,0x00,0x4c,0x3a,0x00,0x00,0x00,
0xdc,0x07,0x00,0x00,0x00,0x70,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,};
#define tangent_width 36
#define tangent_height 32
static unsigned char tangent_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x7d,0x00,0x00,0xe0,0x00,0x11,
0x00,0x00,0x00,0x03,0x11,0x00,0x00,0x00,0x0c,0x11,0x00,0x00,
0x00,0x10,0x11,0x00,0x00,0x00,0x20,0x01,0x00,0x10,0x01,0x20,
0x01,0x00,0x30,0x01,0x40,0x01,0x00,0x50,0x01,0x40,0x01,0x00,
0x90,0x01,0x80,0x01,0x00,0x10,0x01,0x80,0x01,0x00,0x00,0x00,
0xc0,0x01,0x00,0xf8,0xff,0xff,0x3f,0x00,0x00,0x00,0xc0,0x01,
0x00,0x00,0x00,0x80,0x01,0x00,0x00,0x00,0x80,0x01,0x00,0x00,
0x00,0x40,0x01,0x00,0x00,0x00,0x40,0x01,0x00,0x00,0x00,0x20,
0x01,0x00,0x00,0x00,0x20,0x01,0x00,0x00,0x00,0x10,0x01,0x00,
0x00,0x00,0x0c,0x01,0x00,0x00,0x00,0x03,0x01,0x00,0x00,0xe0,
0x00,0x01,0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x01,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,};
#define anglemeas_width 36
#define anglemeas_height 32
static unsigned char anglemeas_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x20,0x07,0x00,0x00,
0x00,0x30,0x07,0x00,0x00,0x00,0x20,0x0f,0x00,0x00,0x00,0x20,
0x30,0x00,0x00,0x00,0x20,0x40,0x00,0x00,0x00,0x20,0x80,0x01,
0x00,0x00,0x70,0x00,0x06,0x00,0x00,0x00,0x00,0x1e,0x00,0x00,
0x00,0x00,0x21,0xc0,0x00,0x00,0x80,0xc0,0x20,0x01,0x00,0x80,
0x00,0x0f,0x01,0x00,0x80,0x00,0x8e,0x00,0x00,0x80,0x00,0x4f,
0x00,0x00,0x80,0xc0,0x20,0x00,0x00,0x00,0x21,0xe0,0x01,0x00,
0x00,0x1a,0x00,0x00,0x30,0x00,0x06,0x00,0x00,0x48,0x80,0x01,
0x00,0x00,0x40,0x40,0x00,0x00,0x00,0x30,0x30,0x00,0x00,0x00,
0x40,0x0f,0x00,0x00,0x00,0x48,0x07,0x00,0x00,0x00,0x30,0x07,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,};

#define lenmeas_width 36
#define lenmeas_height 32
static unsigned char lenmeas_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x1e,0x00,0x00,0x00,0x80,0x13,0x00,0x40,
0x00,0x70,0x10,0x80,0xc1,0x00,0x18,0x10,0xe0,0x83,0x01,0x08,
0x10,0x30,0x06,0x01,0x0c,0x10,0x10,0x0c,0x01,0x04,0x18,0x18,
0x08,0x01,0x04,0x08,0x08,0x0c,0x01,0x04,0x04,0x08,0x04,0x01,
0x00,0x03,0x0c,0x84,0x01,0xc0,0x00,0x06,0xdc,0x00,0x60,0x00,
0x03,0x70,0x00,0x60,0xc0,0x00,0x00,0x00,0xc0,0x3f,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x08,0x21,0x84,0x10,0x02,
0x08,0x21,0x84,0x10,0x02,0x08,0x21,0x84,0x10,0x02,0xf8,0xff,
0xff,0xff,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00};

#endif /* USE_SMALL_ICONS */

/********* special icon for X-Splines used in popup edit panel */

#define c_xspl_width 36
#define c_xspl_height 32
static unsigned char    c_xspl_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xf8,0x0f,0x00,0xfe,0x03,0x10,0x08,
0x00,0x02,0x01,0x10,0x08,0x00,0x81,0x00,0x20,0x08,0x80,
0x40,0x00,0x40,0x10,0x40,0x20,0x00,0x40,0x20,0x40,0x20,
0x00,0x80,0x20,0x20,0x10,0x00,0x80,0x40,0x10,0x08,0x00,
0x80,0x80,0x08,0x08,0x00,0x00,0x01,0x07,0x04,0x00,0x00,
0x01,0x00,0x04,0x00,0x00,0x01,0x00,0x04,0x00,0x00,0x01,
0x00,0x04,0x00,0x00,0x01,0x00,0x04,0x00,0x00,0x01,0x00,
0x08,0x00,0x00,0x01,0x07,0x08,0x00,0x80,0x80,0x08,0x08,
0x00,0x80,0x40,0x10,0x10,0x00,0x40,0x40,0x20,0x10,0x00,
0x40,0x20,0x20,0x20,0x00,0x20,0x20,0x40,0x40,0x00,0x20,
0x10,0x40,0x80,0x00,0x10,0x08,0x80,0x00,0x01,0x08,0x08,
0x80,0x00,0x02,0xf8,0x0f,0x00,0xff,0x03,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};

#define xspl_width 36
#define xspl_height 32
static unsigned char    xspl_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xf8,0x7f,0x00,0x00,0x00,0x08,0x00,
0x00,0x00,0x00,0x08,0x00,0x00,0x00,0x00,0x08,0x00,0x00,
0x00,0x00,0x08,0x00,0x00,0x00,0x00,0x08,0x00,0x00,0x00,
0x00,0x08,0x00,0x00,0x00,0x00,0x08,0x00,0x00,0x00,0x00,
0xf8,0x0f,0x00,0x00,0x00,0x00,0x30,0x00,0x00,0x00,0x00,
0x40,0x00,0x00,0x00,0x00,0x80,0x00,0x00,0x00,0x00,0x00,
0x01,0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x01,
0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x01,0x00,
0x00,0x00,0x00,0x01,0x00,0x00,0x04,0x80,0x00,0x00,0x00,
0x38,0x40,0x00,0x00,0x00,0xc0,0x31,0x00,0x00,0x00,0x00,
0x0e,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};

/********* icons for indicator panel **********/

#define open_arc_width 32
#define open_arc_height 32
static unsigned char open_arc_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x80,0x01,0x00,0x00,0x80,0x03,0x00,0x00,0x00,0x06,0x00,
0x00,0x00,0x0c,0x00,0x00,0x00,0x0c,0x00,0x00,0x00,0x18,0x00,
0x00,0x00,0x18,0x00,0x00,0x00,0x30,0x00,0x00,0x00,0x30,0x00,
0x00,0x00,0x30,0x00,0x00,0x00,0x30,0x00,0x00,0x00,0x60,0x00,
0x00,0x00,0x60,0x00,0x00,0x00,0x60,0x00,0x00,0x00,0x60,0x00,
0x00,0x00,0x60,0x00,0x00,0x00,0x30,0x00,0x00,0x00,0x30,0x00,
0x00,0x00,0x30,0x00,0x00,0x00,0x30,0x00,0x00,0x00,0x18,0x00,
0x00,0x00,0x18,0x00,0x00,0x00,0x0c,0x00,0x00,0x00,0x0c,0x00,
0x00,0x00,0x06,0x00,0x00,0x80,0x03,0x00,0x00,0x80,0x01,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define pie_wedge_arc_width 32
#define pie_wedge_arc_height 32
static unsigned char pie_wedge_arc_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x03,0x00,0x00,0x80,0x07,0x00,0x00,0xc0,0x0c,0x00,
0x00,0x60,0x18,0x00,0x00,0x30,0x18,0x00,0x00,0x18,0x30,0x00,
0x00,0x0c,0x30,0x00,0x00,0x06,0x60,0x00,0x00,0x03,0x60,0x00,
0x80,0x01,0x60,0x00,0xc0,0x00,0x60,0x00,0x60,0x00,0xc0,0x00,
0x30,0x00,0xc0,0x00,0x18,0x00,0xc0,0x00,0x30,0x00,0xc0,0x00,
0x60,0x00,0xc0,0x00,0xc0,0x00,0x60,0x00,0x80,0x01,0x60,0x00,
0x00,0x03,0x60,0x00,0x00,0x06,0x60,0x00,0x00,0x0c,0x30,0x00,
0x00,0x18,0x30,0x00,0x00,0x30,0x18,0x00,0x00,0x60,0x18,0x00,
0x00,0xc0,0x0c,0x00,0x00,0x80,0x07,0x00,0x00,0x00,0x03,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define smartoff_width 32
#define smartoff_height 32
static unsigned char smartoff_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfc,0x07,0x00,
0x00,0x04,0x04,0x00,0x00,0x04,0x04,0x00,0x00,0x04,0x04,
0x00,0x00,0x04,0x04,0x00,0x00,0x04,0x04,0x00,0x00,0xfc,
0x07,0x00,0x00,0x40,0x40,0x55,0x00,0x40,0x00,0x00,0x00,
0x40,0x40,0x40,0x00,0xc0,0x3f,0x00,0x00,0x00,0x40,0x40,
0x08,0x00,0x00,0x00,0x08,0x00,0x40,0x55,0x08,0x00,0x00,
0x00,0x08,0x00,0xc0,0x7f,0x08,0x00,0x40,0x40,0x2a,0x00,
0x40,0x40,0x1c,0x00,0x40,0x40,0x08,0x00,0x40,0x40,0x00,
0x00,0x40,0x40,0x00,0x00,0xc0,0x7f,0x00,0x00,0x00,0x00,
0x00,0x80,0xe3,0xf3,0x01,0x40,0x24,0x10,0x00,0x40,0xe4,
0x70,0x00,0x40,0x24,0x10,0x00,0x80,0x23,0x10,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define smartmove_width 32
#define smartmove_height 32
static unsigned char smartmove_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfc,0x07,0x00,
0x00,0x04,0x04,0x00,0x00,0x04,0x04,0x00,0x00,0x04,0x04,
0x00,0x00,0x04,0x04,0x00,0x00,0x04,0x04,0x00,0x00,0xfc,
0x07,0x00,0x00,0x40,0x40,0x55,0x00,0x40,0x00,0x00,0x00,
0x40,0x40,0x40,0x00,0x40,0x15,0x00,0x00,0x40,0x40,0x40,
0x08,0x80,0x00,0x00,0x08,0x00,0x41,0x55,0x08,0x00,0x02,
0x00,0x08,0x00,0xc4,0x7f,0x08,0x00,0x48,0x40,0x2a,0x00,
0x50,0x40,0x1c,0x00,0x60,0x40,0x08,0x00,0x40,0x40,0x00,
0x00,0x40,0x40,0x00,0x00,0xc0,0x7f,0x00,0x00,0x00,0x00,
0x00,0x88,0x38,0x22,0x1f,0xd8,0x44,0x22,0x01,0xa8,0x44,
0x22,0x07,0x88,0x44,0x14,0x01,0x88,0x38,0x08,0x1f,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define smartslide_width 32
#define smartslide_height 32
static unsigned char smartslide_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfc,0x07,0x00,
0x00,0x04,0x04,0x00,0x00,0x04,0x04,0x00,0x00,0x04,0x04,
0x00,0x00,0x04,0x04,0x00,0x00,0x04,0x04,0x00,0x00,0xfc,
0x07,0x00,0x00,0x40,0x40,0x55,0x00,0x40,0x00,0x00,0x00,
0x40,0x40,0x40,0x00,0x40,0x15,0x00,0x00,0x40,0x40,0x40,
0x08,0x40,0x00,0x00,0x08,0x40,0x40,0x55,0x08,0x40,0x00,
0x00,0x08,0x40,0xc0,0x7f,0x08,0x40,0x40,0x40,0x2a,0x40,
0x40,0x40,0x1c,0xc0,0x7f,0x40,0x08,0x00,0x40,0x40,0x00,
0x00,0x40,0x40,0x00,0x00,0xc0,0x7f,0x00,0x00,0x00,0x00,
0x00,0x70,0x82,0x73,0x1e,0x08,0x02,0x91,0x02,0x70,0x02,
0x91,0x0e,0x80,0x02,0x91,0x02,0x70,0x9e,0x73,0x1e,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define joinmiter_width 32
#define joinmiter_height 32
static unsigned char joinmiter_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xf0,0xff,0xff,0x0f,0xf0,0xff,0xff,0x03,0xf0,0xff,0xff,0x00,
0xf0,0xff,0x3f,0x00,0x00,0xf8,0x0f,0x00,0x00,0xfe,0x03,0x00,
0x80,0xff,0x00,0x00,0xe0,0x3f,0x00,0x00,0xf0,0x0f,0x00,0x00,
0xf0,0x03,0x00,0x00,0xf0,0x00,0x00,0x00,0x20,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define joinround_width 32
#define joinround_height 32
static unsigned char joinround_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xf0,0xff,0xff,0x07,0xf0,0xff,0xff,0x0f,0xf0,0xff,0xff,0x0f,
0xf0,0xff,0xff,0x0f,0xf0,0xff,0xff,0x07,0x00,0x80,0xff,0x03,
0x00,0xe0,0xff,0x00,0x00,0xf8,0x3f,0x00,0x00,0xfe,0x0f,0x00,
0x80,0xff,0x03,0x00,0xe0,0xff,0x00,0x00,0xc0,0x3f,0x00,0x00,
0xc0,0x0f,0x00,0x00,0x80,0x03,0x00,0x00,0x80,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define joinbevel_width 32
#define joinbevel_height 32
static unsigned char joinbevel_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xf0,0xff,0xff,0x07,0xf0,0xff,0xff,0x07,0xf0,0xff,0xff,0x07,
0xf0,0xff,0xff,0x07,0xf0,0xff,0xff,0x07,0x00,0x80,0xff,0x03,
0x00,0xe0,0xff,0x00,0x00,0xf8,0x3f,0x00,0x00,0xfe,0x0f,0x00,
0x80,0xff,0x03,0x00,0xe0,0xff,0x00,0x00,0xc0,0x3f,0x00,0x00,
0xc0,0x0f,0x00,0x00,0x80,0x03,0x00,0x00,0x80,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define capbutt_width 32
#define capbutt_height 32
static unsigned char capbutt_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x40,0x00,0x00,0x01,0x40,0x00,0x00,0x01,0x40,0x00,0x00,0x01,
0xc0,0xff,0xff,0x01,0xc0,0xff,0xff,0x01,0xc0,0xff,0xff,0x01,
0xc0,0xff,0xff,0x01,0xc0,0xff,0xff,0x01,0x40,0x00,0x00,0x01,
0x40,0x00,0x00,0x01,0x40,0x00,0x00,0x01,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define capround_width 32
#define capround_height 32
static unsigned char capround_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x40,0x00,0x00,0x01,0x40,0x00,0x00,0x01,0x40,0x00,0x00,0x01,
0xf0,0xff,0xff,0x07,0xf8,0xff,0xff,0x0f,0xf8,0xff,0xff,0x0f,
0xf8,0xff,0xff,0x0f,0xf0,0xff,0xff,0x07,0x40,0x00,0x00,0x01,
0x40,0x00,0x00,0x01,0x40,0x00,0x00,0x01,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define capproject_width 32
#define capproject_height 32
static unsigned char capproject_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x40,0x00,0x00,0x01,0x40,0x00,0x00,0x01,0x40,0x00,0x00,0x01,
0xf0,0xff,0xff,0x07,0xf0,0xff,0xff,0x07,0xf0,0xff,0xff,0x07,
0xf0,0xff,0xff,0x07,0xf0,0xff,0xff,0x07,0x40,0x00,0x00,0x01,
0x40,0x00,0x00,0x01,0x40,0x00,0x00,0x01,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define solidline_width 32
#define solidline_height 32
static unsigned char solidline_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0xfc,0xff,0xff,0x1f,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,};

#define dashline_width 32
#define dashline_height 32
static unsigned char dashline_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x7c,0x7c,0x7c,0x7c,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,};

#define dottedline_width 32
#define dottedline_height 32
static unsigned char dottedline_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x08,0x21,0x84,0x10,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,};

#define dashdotline_width 32
#define dashdotline_height 32
static unsigned char dashdotline_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x3f,0xe2,0x47,0xfc,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,};

#define dash2dotsline_width 32
#define dash2dotsline_height 32
static unsigned char dash2dotsline_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x3f,0x12,0x3f,0x12,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,};

#define dash3dotsline_width 32
#define dash3dotsline_height 32
static unsigned char dash3dotsline_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x3f,0x92,0xf8,0x91,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,};

/* fine grid (only used for point positioning) */

#define fine_grid_width 32
#define fine_grid_height 32
static unsigned char fine_grid_bits[]={
0x48,0x92,0x24,0x09,0x48,0x92,0x24,0x09,0x48,0x92,0x24,0x09,
0x48,0x92,0x24,0x09,0xff,0xff,0xff,0xff,0x48,0x92,0x24,0x09,
0x48,0x92,0x24,0x09,0xff,0xff,0xff,0xff,0x48,0x92,0x24,0x09,
0x48,0x92,0x24,0x09,0xff,0xff,0xff,0xff,0x48,0x92,0x24,0x09,
0x48,0x92,0x24,0x09,0xff,0xff,0xff,0xff,0x48,0x92,0x24,0x09,
0x48,0x92,0x24,0x09,0xff,0xff,0xff,0xff,0x48,0x92,0x24,0x09,
0x48,0x92,0x24,0x09,0xff,0xff,0xff,0xff,0x48,0x92,0x24,0x09,
0x48,0x92,0x24,0x09,0xff,0xff,0xff,0xff,0x48,0x92,0x24,0x09,
0x48,0x92,0x24,0x09,0xff,0xff,0xff,0xff,0x48,0x92,0x24,0x09,
0x48,0x92,0x24,0x09,0xff,0xff,0xff,0xff,0x48,0x92,0x24,0x09,
0x48,0x92,0x24,0x09,0x48,0x92,0x24,0x09};

#define grid1_width 32
#define grid1_height 32
static unsigned char grid1_bits[] = {
0x00,0x00,0x00,0x00,0x20,0x22,0x22,0x02,0x20,0x22,0x22,0x02,
0x20,0x22,0x22,0x02,0x20,0x22,0x22,0x02,0xfe,0xff,0xff,0x3f,
0x20,0x22,0x22,0x02,0x20,0x22,0x22,0x02,0x20,0x22,0x22,0x02,
0xfe,0xff,0xff,0x3f,0x20,0x22,0x22,0x02,0x20,0x22,0x22,0x02,
0x20,0x22,0x22,0x02,0xfe,0xff,0xff,0x3f,0x20,0x22,0x22,0x02,
0x20,0x22,0x22,0x02,0x20,0x22,0x22,0x02,0xfe,0xff,0xff,0x3f,
0x20,0x22,0x22,0x02,0x20,0x22,0x22,0x02,0x20,0x22,0x22,0x02,
0xfe,0xff,0xff,0x3f,0x20,0x22,0x22,0x02,0x20,0x22,0x22,0x02,
0x20,0x22,0x22,0x02,0xfe,0xff,0xff,0x3f,0x20,0x22,0x22,0x02,
0x20,0x22,0x22,0x02,0x20,0x22,0x22,0x02,0x20,0x22,0x22,0x02,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define grid2_width 32
#define grid2_height 32
static unsigned char	grid2_bits[] = {
0x08,0x21,0x84,0x10,0x08,0x21,0x84,0x10,0x08,0x21,0x84,0x10,
0x08,0x21,0x84,0x10,0xff,0xff,0xff,0xff,0x08,0x21,0x84,0x10,
0x08,0x21,0x84,0x10,0x08,0x21,0x84,0x10,0x08,0x21,0x84,0x10,
0xff,0xff,0xff,0xff,0x08,0x21,0x84,0x10,0x08,0x21,0x84,0x10,
0x08,0x21,0x84,0x10,0x08,0x21,0x84,0x10,0xff,0xff,0xff,0xff,
0x08,0x21,0x84,0x10,0x08,0x21,0x84,0x10,0x08,0x21,0x84,0x10,
0x08,0x21,0x84,0x10,0xff,0xff,0xff,0xff,0x08,0x21,0x84,0x10,
0x08,0x21,0x84,0x10,0x08,0x21,0x84,0x10,0x08,0x21,0x84,0x10,
0xff,0xff,0xff,0xff,0x08,0x21,0x84,0x10,0x08,0x21,0x84,0x10,
0x08,0x21,0x84,0x10,0x08,0x21,0x84,0x10,0xff,0xff,0xff,0xff,
0x08,0x21,0x84,0x10,0x08,0x21,0x84,0x10};

#define grid3_width 32
#define grid3_height 32
static unsigned char	grid3_bits[] = {
0x20,0x80,0x00,0x02,0x20,0x80,0x00,0x02,0x20,0x80,0x00,0x02,
0x20,0x80,0x00,0x02,0x20,0x80,0x00,0x02,0xff,0xff,0xff,0xff,
0x20,0x80,0x00,0x02,0x20,0x80,0x00,0x02,0x20,0x80,0x00,0x02,
0x20,0x80,0x00,0x02,0x20,0x80,0x00,0x02,0x20,0x80,0x00,0x02,
0x20,0x80,0x00,0x02,0x20,0x80,0x00,0x02,0x20,0x80,0x00,0x02,
0xff,0xff,0xff,0xff,0x20,0x80,0x00,0x02,0x20,0x80,0x00,0x02,
0x20,0x80,0x00,0x02,0x20,0x80,0x00,0x02,0x20,0x80,0x00,0x02,
0x20,0x80,0x00,0x02,0x20,0x80,0x00,0x02,0x20,0x80,0x00,0x02,
0x20,0x80,0x00,0x02,0xff,0xff,0xff,0xff,0x20,0x80,0x00,0x02,
0x20,0x80,0x00,0x02,0x20,0x80,0x00,0x02,0x20,0x80,0x00,0x02,
0x20,0x80,0x00,0x02,0x20,0x80,0x00,0x02};

#define grid4_width 32
#define grid4_height 32
static unsigned char	grid4_bits[] = {
0x40,0x00,0x00,0x04,0x40,0x00,0x00,0x04,0x40,0x00,0x00,0x04,
0x40,0x00,0x00,0x04,0x40,0x00,0x00,0x04,0x40,0x00,0x00,0x04,
0xff,0xff,0xff,0xff,0x40,0x00,0x00,0x04,0x40,0x00,0x00,0x04,
0x40,0x00,0x00,0x04,0x40,0x00,0x00,0x04,0x40,0x00,0x00,0x04,
0x40,0x00,0x00,0x04,0x40,0x00,0x00,0x04,0x40,0x00,0x00,0x04,
0x40,0x00,0x00,0x04,0x40,0x00,0x00,0x04,0x40,0x00,0x00,0x04,
0x40,0x00,0x00,0x04,0x40,0x00,0x00,0x04,0x40,0x00,0x00,0x04,
0x40,0x00,0x00,0x04,0x40,0x00,0x00,0x04,0x40,0x00,0x00,0x04,
0x40,0x00,0x00,0x04,0x40,0x00,0x00,0x04,0xff,0xff,0xff,0xff,
0x40,0x00,0x00,0x04,0x40,0x00,0x00,0x04,0x40,0x00,0x00,0x04,
0x40,0x00,0x00,0x04,0x40,0x00,0x00,0x04};

#define unconstrained_width 32
#define unconstrained_height 32
static unsigned char unconstrained_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0xa0,0xfa,0x01,0x00,0x08,0xf4,0x01,0x00,0x02,
0xe0,0x01,0x00,0x00,0xc4,0x02,0x80,0x00,0x00,0x06,0x00,
0x00,0x02,0x08,0x20,0x00,0x00,0x0c,0x00,0x00,0x02,0x16,
0x10,0x00,0x80,0x13,0x00,0x00,0xe2,0x10,0x08,0x00,0x70,
0x20,0x00,0x00,0x19,0xf8,0x08,0x00,0x0e,0x70,0x00,0x00,
0x03,0x70,0x08,0x00,0x14,0x70,0x00,0x00,0x42,0x20,0x08,
0x00,0x00,0x21,0x00,0x00,0x08,0x04,0x10,0x00,0x00,0x10,
0x00,0x00,0x10,0x00,0x20,0x00,0x00,0x08,0x00,0x00,0x20,
0x00,0x80,0x00,0x00,0x02,0x00,0x00,0x40,0x00,0x00,0x02,
0x80,0x00,0x00,0x08,0x20,0x00,0x00,0xa0,0x0a,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,};

#define latexline_width 32
#define latexline_height 32
static unsigned char latexline_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0e,
0x00,0x00,0xf8,0x01,0x00,0x00,0x0f,0x00,0x00,0x80,0xf7,
0x03,0x00,0x80,0x09,0xfc,0x00,0x40,0x31,0x00,0x0f,0x20,
0xc1,0x00,0x00,0x10,0x01,0x01,0x00,0x10,0x01,0x06,0x00,
0x08,0x01,0x08,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x18,0xf0,0x83,0x61,0x18,0xf3,0x03,0x33,0x98,
0xc4,0x00,0x33,0x98,0xc4,0x00,0x1e,0x98,0xc7,0x3e,0x0c,
0x98,0xc4,0x06,0x0c,0x98,0xc4,0x06,0x1e,0x18,0xc0,0x06,
0x33,0xf8,0xc1,0x1e,0x33,0xf8,0xc1,0x86,0x61,0x00,0x00,
0x06,0x00,0x00,0x00,0x06,0x00,0x00,0x00,0x3e,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,};

#define latexarrow_width 32
#define latexarrow_height 32
static unsigned char latexarrow_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x3c,0x00,0x00,0x00,0x1f,
0x00,0x00,0xf8,0x0c,0x00,0x00,0x0f,0x00,0x00,0x80,0xf7,
0x03,0x00,0x80,0x09,0xfc,0x06,0x40,0x31,0x00,0x0f,0x20,
0xc1,0x02,0x1f,0x98,0x03,0x03,0x00,0xb8,0x03,0x07,0x00,
0x18,0x01,0x0f,0x00,0x08,0x01,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x18,0xf0,0x83,0x61,0x18,0xf3,0x03,0x33,0x98,
0xc4,0x00,0x33,0x98,0xc4,0x00,0x1e,0x98,0xc7,0x3e,0x0c,
0x98,0xc4,0x06,0x0c,0x98,0xc4,0x06,0x1e,0x18,0xc0,0x06,
0x33,0xf8,0xc1,0x1e,0x33,0xf8,0xc1,0x86,0x61,0x00,0x00,
0x06,0x00,0x00,0x00,0x06,0x00,0x00,0x00,0x3e,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,};

#define mounthattan_width 32
#define mounthattan_height 32
static unsigned char mounthattan_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0xf8,0x01,0x00,0x00,0xf8,0x01,0x00,0x00,
0x98,0x01,0x00,0x00,0x98,0x01,0x02,0x00,0x98,0x01,0x07,
0x00,0x98,0x81,0x0d,0x00,0x9c,0xc3,0x18,0x80,0x9c,0x63,
0x30,0xc0,0x0d,0x33,0x20,0x60,0x0f,0x1b,0x00,0x30,0x0e,
0x0f,0x00,0x18,0x0c,0x07,0x00,0x0c,0x0c,0x03,0x00,0x04,
0x0c,0x03,0x00,0x00,0x0c,0x03,0x00,0x00,0x0c,0x1f,0x00,
0x00,0x0c,0x1f,0x00,0x00,0x0c,0x00,0x00,0x00,0x0c,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define manhattan_width 32
#define manhattan_height 32
static unsigned char manhattan_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf8,0x01,0x00,0x00,
0xf8,0x01,0x00,0x00,0x98,0x01,0x00,0x00,0x98,0x01,0x00,
0x00,0x98,0x01,0x00,0x00,0x9c,0x03,0x00,0x00,0x9c,0x03,
0x00,0x00,0x0c,0x03,0x00,0x00,0x0c,0x03,0x00,0x00,0x0c,
0x03,0x00,0x7c,0x0c,0xf3,0x01,0x7c,0x0c,0xf3,0x01,0x60,
0x0c,0xb3,0x01,0x60,0x0c,0xbf,0x01,0x60,0x0c,0xbf,0x01,
0xe0,0x0f,0x80,0x01,0xe0,0x0f,0x80,0x01,0x00,0x00,0x80,
0x3f,0x00,0x00,0x80,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define mountain_width 32
#define mountain_height 32
static unsigned char mountain_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x20,
0x00,0x00,0x00,0x70,0x00,0x00,0x00,0xd8,0x00,0x00,0x00,
0x8c,0x01,0x00,0x00,0x04,0x03,0x00,0x00,0x00,0x06,0x00,
0x00,0x00,0x0c,0x00,0x04,0x00,0x18,0x00,0x0e,0x00,0x30,
0x00,0x1b,0x00,0x60,0x80,0x31,0x00,0xc0,0xc0,0x20,0x00,
0x80,0x61,0x00,0x00,0x00,0x33,0x00,0x00,0x00,0x1e,0x00,
0x00,0x00,0x0c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define halignl_width 32
#define halignl_height 32
static unsigned char halignl_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0xf8,0x7f,0x00,0x00,0x08,0x40,0x00,0x00,0x08,0x40,
0x00,0x00,0x08,0x40,0x00,0x00,0x08,0x40,0x00,0x00,0x08,
0x40,0x00,0x00,0x08,0x40,0x00,0x00,0x08,0x40,0x00,0x00,
0x08,0x40,0x00,0x00,0xf8,0x7f,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x18,0x00,0x00,0x00,0x68,0x00,
0x00,0x00,0x88,0x01,0x00,0x00,0x08,0x06,0x00,0x00,0x88,
0x01,0x00,0x00,0x68,0x00,0x00,0x00,0x18,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf8,0xff,0xff,
0x00,0x08,0x00,0x80,0x00,0x08,0x00,0x80,0x00,0x08,0x00,
0x80,0x00,0xf8,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define halignr_width 32
#define halignr_height 32
static unsigned char halignr_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0xfe,0x1f,0x00,0x00,0x02,0x10,0x00,0x00,
0x02,0x10,0x00,0x00,0x02,0x10,0x00,0x00,0x02,0x10,0x00,
0x00,0x02,0x10,0x00,0x00,0x02,0x10,0x00,0x00,0x02,0x10,
0x00,0x00,0x02,0x10,0x00,0x00,0xfe,0x1f,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x18,0x00,0x00,
0x00,0x16,0x00,0x00,0x80,0x11,0x00,0x00,0x60,0x10,0x00,
0x00,0x80,0x11,0x00,0x00,0x00,0x16,0x00,0x00,0x00,0x18,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xff,0xff,
0x1f,0x00,0x01,0x00,0x10,0x00,0x01,0x00,0x10,0x00,0x01,
0x00,0x10,0x00,0xff,0xff,0x1f,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define halignc_width 32
#define halignc_height 32
static unsigned char halignc_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0xfc,0x3f,0x00,0x00,0x04,0x20,0x00,0x00,0x04,
0x20,0x00,0x00,0x04,0x20,0x00,0x00,0x04,0x20,0x00,0x00,
0x04,0x20,0x00,0x00,0x04,0x20,0x00,0x00,0x04,0x20,0x00,
0x00,0x04,0x20,0x00,0x00,0xfc,0x3f,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x80,
0x02,0x00,0x00,0x80,0x02,0x00,0x00,0x40,0x04,0x00,0x00,
0x40,0x04,0x00,0x00,0x20,0x08,0x00,0x00,0xe0,0x0f,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xe0,0xff,0xff,
0x07,0x20,0x00,0x00,0x04,0x20,0x00,0x00,0x04,0x20,0x00,
0x00,0x04,0xe0,0xff,0xff,0x07,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define haligndc_width 32
#define haligndc_height 32
static unsigned char haligndc_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0xf8,0x1f,0x00,0x00,0x08,0x10,0x00,0x00,0x08,0x10,
0x00,0x00,0x08,0x10,0x00,0x00,0x88,0x11,0x00,0x00,0x88,
0x11,0x00,0x00,0x08,0x10,0x00,0x00,0x08,0x10,0x00,0x00,
0x08,0x10,0x00,0x00,0xf8,0x1f,0x00,0x1f,0x00,0x00,0x00,
0x11,0x00,0x00,0x00,0x11,0x00,0x00,0x01,0x11,0x00,0x80,
0x02,0x11,0x00,0x40,0x04,0x11,0x00,0x20,0x09,0x11,0x00,
0x10,0x10,0x15,0x00,0xf8,0x3f,0x15,0x00,0x00,0x00,0x15,
0x00,0x00,0x00,0x11,0x00,0x00,0x00,0x11,0x00,0x00,0x00,
0x11,0x00,0x00,0x00,0x11,0x00,0x00,0x00,0x11,0x00,0x00,
0x00,0x11,0x00,0x00,0x00,0x1f,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define halignde_width 32
#define halignde_height 32
static unsigned char halignde_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0xf8,0x1f,0x00,0x00,0x18,0x18,0x00,0x00,0x18,0x18,
0x00,0x00,0x18,0x18,0x00,0x00,0x18,0x18,0x00,0x00,0x18,
0x18,0x00,0x00,0x18,0x18,0x00,0x00,0x18,0x18,0x00,0x00,
0x18,0x18,0x00,0x00,0xf8,0x1f,0x02,0x1f,0x00,0x00,0x02,
0x1b,0x00,0x00,0x07,0x1b,0x00,0x00,0x05,0x1b,0x00,0x80,
0x0d,0x1b,0x00,0x80,0x08,0x1b,0x00,0xc0,0x18,0x1b,0x00,
0xc0,0x18,0x1b,0x00,0xc0,0x1f,0x1b,0x00,0x00,0x00,0x1b,
0x00,0x00,0x00,0x1b,0x00,0x00,0x00,0x1b,0x00,0x00,0x00,
0x1b,0x00,0x00,0x00,0x1b,0x00,0x00,0x00,0x1b,0x00,0x00,
0x00,0x1b,0x00,0x00,0x00,0x1f,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define haligna_width 32
#define haligna_height 32
static unsigned char haligna_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x04,0x00,0x00,0x00,0x04,0x00,0x00,0x00,0x0a,0x00,
0x00,0x00,0x0a,0x00,0xf8,0x1f,0x11,0x1f,0x08,0x10,0x11,
0x11,0x08,0x90,0x20,0x11,0x08,0x90,0x20,0x11,0x08,0x50,
0x40,0x11,0x08,0x50,0x40,0x11,0x08,0x30,0x80,0x11,0x08,
0xf0,0xff,0x11,0x08,0x10,0x00,0x11,0xf8,0x1f,0x00,0x11,
0x00,0x00,0x00,0x11,0x00,0x00,0x00,0x11,0x00,0x00,0x00,
0x11,0x00,0x00,0x00,0x11,0x00,0x00,0x00,0x11,0x00,0x00,
0x00,0x11,0x00,0x00,0x00,0x1f,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define valignt_width 32
#define valignt_height 32
static unsigned char valignt_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0xf8,0x9f,0x3f,0x1f,0x08,0x90,0x20,0x11,0x08,0x10,
0x11,0x11,0x08,0x10,0x11,0x11,0x08,0x10,0x0a,0x11,0x08,
0x10,0x0a,0x11,0x08,0x10,0x04,0x11,0x08,0x10,0x04,0x11,
0x08,0x10,0x00,0x11,0xf8,0x1f,0x00,0x11,0x00,0x00,0x00,
0x11,0x00,0x00,0x00,0x11,0x00,0x00,0x00,0x11,0x00,0x00,
0x00,0x11,0x00,0x00,0x00,0x11,0x00,0x00,0x00,0x11,0x00,
0x00,0x00,0x11,0x00,0x00,0x00,0x1f,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define valignb_width 32
#define valignb_height 32
static unsigned char valignb_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x1f,0x00,0x00,0x00,0x11,0x00,0x00,0x00,
0x11,0x00,0x00,0x00,0x11,0x00,0x00,0x00,0x11,0x00,0x00,
0x00,0x11,0x00,0x00,0x00,0x11,0x00,0x00,0x00,0x11,0xf8,
0x1f,0x00,0x11,0x08,0x10,0x00,0x11,0x08,0x10,0x00,0x11,
0x08,0x10,0x04,0x11,0x08,0x10,0x0a,0x11,0x08,0x10,0x0a,
0x11,0x08,0x10,0x11,0x11,0x08,0x10,0x11,0x11,0x08,0x90,
0x20,0x11,0xf8,0x9f,0x3f,0x1f,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define valignc_width 32
#define valignc_height 32
static unsigned char valignc_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1f,0x00,
0x00,0x00,0x11,0x00,0x00,0x00,0x11,0x00,0x00,0x00,0x11,
0xf8,0x1f,0x00,0x11,0x08,0x10,0x30,0x11,0x08,0x10,0x2c,
0x11,0x08,0x10,0x23,0x11,0x08,0x90,0x20,0x11,0x08,0x10,
0x23,0x11,0x08,0x10,0x2c,0x11,0x08,0x10,0x30,0x11,0x08,
0x10,0x00,0x11,0xf8,0x1f,0x00,0x11,0x00,0x00,0x00,0x11,
0x00,0x00,0x00,0x11,0x00,0x00,0x00,0x11,0x00,0x00,0x00,
0x1f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define valigndc_width 32
#define valigndc_height 32
static unsigned char valigndc_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0xf8,0x7f,0x00,0x00,0x08,0x40,0x00,0x00,0x08,0x40,
0x00,0x00,0x08,0x40,0x00,0x00,0x08,0x43,0x00,0x00,0x08,
0x43,0x00,0x00,0x08,0x40,0x00,0x00,0x08,0x40,0x00,0x00,
0x08,0x40,0x00,0x00,0xf8,0x7f,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x02,0x00,0x00,0x00,0x05,0x00,0x00,0x80,
0x08,0x00,0x00,0x40,0x12,0x00,0x00,0x20,0x20,0x00,0x00,
0xf0,0x7f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xff,0xff,
0x1f,0x00,0x01,0x00,0x10,0x00,0x01,0x0e,0x10,0x00,0x01,
0x00,0x10,0x00,0xff,0xff,0x1f,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define valignde_width 32
#define valignde_height 32
static unsigned char valignde_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0xf8,0x7f,0x00,0x00,0xf8,0x7f,0x00,0x00,0x08,0x40,
0x00,0x00,0x08,0x40,0x00,0x00,0x08,0x40,0x00,0x00,0x08,
0x40,0x00,0x00,0x08,0x40,0x00,0x00,0xf8,0x7f,0x00,0x00,
0xf8,0x7f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x02,0x00,0x00,0x00,
0x07,0x00,0x00,0x80,0x08,0x00,0x00,0x40,0x10,0x00,0x00,
0xe0,0x3f,0x00,0x00,0xf0,0x7f,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xff,0xff,
0x1f,0x00,0xff,0xff,0x1f,0x00,0x01,0x00,0x10,0x00,0xff,
0xff,0x1f,0x00,0xff,0xff,0x1f,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define valigna_width 32
#define valigna_height 32
static unsigned char valigna_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0xc0,0xff,0x03,0x00,0x40,0x00,0x02,0x00,0x40,0x00,
0x02,0x00,0x40,0x00,0x02,0x00,0x40,0x00,0x02,0x00,0x40,
0x00,0x02,0x00,0x40,0x00,0x02,0x00,0x40,0x00,0x02,0x00,
0x40,0x00,0x02,0x00,0xc0,0xff,0x03,0x00,0x00,0x02,0x00,
0x00,0x00,0x02,0x00,0x00,0x00,0x05,0x00,0x00,0x00,0x05,
0x00,0x00,0x80,0x08,0x00,0x00,0x80,0x08,0x00,0x00,0x40,
0x10,0x00,0x00,0x40,0x10,0x00,0x00,0xe0,0x3f,0x00,0x00,
0x00,0xfe,0xff,0x3f,0x00,0x02,0x00,0x20,0x00,0x02,0x00,
0x20,0x00,0x02,0x00,0x20,0x00,0xfe,0xff,0x3f,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define any_width 32
#define any_height 32
static unsigned char any_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0xf8,0xff,0xff,0x1f,0x08,0x00,
0x00,0x10,0x08,0x00,0x00,0x10,0x08,0x00,0x00,0x10,0x08,
0x00,0x00,0x10,0x08,0x00,0x00,0x10,0x08,0x00,0x00,0x10,
0x08,0x21,0x12,0x11,0x88,0x22,0x12,0x11,0x48,0x64,0xa2,
0x10,0x48,0x64,0xa2,0x10,0x48,0xa4,0x42,0x10,0xc8,0xa7,
0x42,0x10,0x48,0x24,0x43,0x10,0x48,0x24,0x43,0x10,0x48,
0x24,0x42,0x10,0x48,0x24,0x42,0x10,0x08,0x00,0x00,0x10,
0x08,0x00,0x00,0x10,0x08,0x00,0x00,0x10,0x08,0x00,0x00,
0x10,0x08,0x00,0x00,0x10,0x08,0x00,0x00,0x10,0xf8,0xff,
0xff,0x1f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define none_width 32
#define none_height 32
static unsigned char none_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0xf8,0xff,0xff,0x1f,0x08,0x00,
0x00,0x10,0x08,0x00,0x00,0x10,0x08,0x00,0x00,0x10,0x08,
0x00,0x00,0x10,0x08,0x00,0x00,0x10,0x08,0x00,0x00,0x10,
0x28,0x32,0xd1,0x17,0x28,0x4a,0x51,0x10,0x68,0x4a,0x53,
0x10,0x68,0x4a,0x53,0x10,0xa8,0x4a,0xd5,0x11,0xa8,0x4a,
0x55,0x10,0x28,0x4b,0x59,0x10,0x28,0x4b,0x59,0x10,0x28,
0x4a,0x51,0x10,0x28,0x32,0xd1,0x17,0x08,0x00,0x00,0x10,
0x08,0x00,0x00,0x10,0x08,0x00,0x00,0x10,0x08,0x00,0x00,
0x10,0x08,0x00,0x00,0x10,0x08,0x00,0x00,0x10,0xf8,0xff,
0xff,0x1f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define fill_width 32
#define fill_height 32
static unsigned char fill_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf8,
0x03,0x00,0x00,0xac,0x06,0x00,0x00,0x54,0x0d,0x00,0x00,
0xae,0x1a,0x00,0x00,0x56,0x35,0x00,0x00,0xab,0x6a,0x00,
0x00,0x55,0xd5,0x00,0x00,0xab,0xaa,0x01,0x00,0x55,0x55,
0x01,0x00,0xab,0xaa,0x01,0x80,0x55,0x55,0x01,0x80,0xaa,
0xaa,0x01,0x80,0x55,0x55,0x03,0x80,0xaa,0xaa,0x02,0x80,
0x55,0x55,0x03,0x00,0xab,0xaa,0x02,0x00,0x5e,0x55,0x03,
0x00,0xb0,0xaa,0x02,0x00,0x60,0x55,0x03,0x00,0xc0,0xaa,
0x02,0x00,0x40,0x55,0x01,0x00,0x80,0xff,0x01,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define blank_width 32
#define blank_height 32
static unsigned char blank_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define textL_width 32
#define textL_height 32
static unsigned char	textL_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf8,0x01,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf8,0xff,0x3f,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0xf8,0x1f,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0xf8,0xff,0x01,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0xf8,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define textC_width 32
#define textC_height 32
static unsigned char	textC_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xe0,
0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xe0,0xff,0xff,0x07,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0xf8,0x1f,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xff,0xff,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0xfc,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define textR_width 32
#define textR_height 32
static unsigned char	textR_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x80,0x1f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfc,0xff,0x1f,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf8,0x1f,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x80,0xff,0x1f,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0xfc,0x1f,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define noarrows_width 32
#define noarrows_height 32
static unsigned char noarrows_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0xfc,0xff,0xff,0x1f,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,};

#define farrows_width 32
#define farrows_height 32
static unsigned char farrows_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x00,0x00,0x00,0x80,
0x03,0x00,0x00,0x80,0x0f,0xfc,0xff,0xff,0x1f,0x00,0x00,
0x80,0x0f,0x00,0x00,0x80,0x03,0x00,0x00,0x80,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define barrows_width 32
#define barrows_height 32
static unsigned char barrows_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x80,0x00,0x00,0x00,0xe0,0x00,0x00,
0x00,0xf8,0x00,0x00,0x00,0xfc,0xff,0xff,0x1f,0xf8,0x00,
0x00,0x00,0xe0,0x00,0x00,0x00,0x80,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define fbarrows_width 32
#define fbarrows_height 32
static unsigned char fbarrows_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0xe0,0x00,0x80,
0x03,0xf8,0x00,0x80,0x0f,0xfc,0xff,0xff,0x1f,0xf8,0x00,
0x80,0x0f,0xe0,0x00,0x80,0x03,0x80,0x00,0x80,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00};

/* create the data structures for them */

icon_struct	regpoly_ic = { regpoly_width, regpoly_height, 
				(char*)regpoly_bits };
icon_struct	addpt_ic = { addpt_width, addpt_height, 
				(char*)addpt_bits };
icon_struct	align_ic = { align_width, align_height, 
				(char*)align_bits };
icon_struct	arc_ic = { arc_width, arc_height, 
				(char*)arc_bits };
icon_struct	open_arc_ic = { open_arc_width, open_arc_height, 
				(char*)open_arc_bits };
icon_struct	pie_wedge_arc_ic = { pie_wedge_arc_width, pie_wedge_arc_height,
				     (char*)pie_wedge_arc_bits };
icon_struct	autoarrow_ic = { autoarrow_width, autoarrow_height, 
				 (char*)autoarrow_bits };
icon_struct	box_ic = { box_width, box_height, 
				(char*)box_bits };
icon_struct	arc_box_ic = { arc_box_width, arc_box_height, 
				(char*)arc_box_bits };
icon_struct	cirrad_ic = { cirrad_width, cirrad_height,
				(char*)cirrad_bits };
icon_struct	cirdia_ic = { cirdia_width, cirdia_height,
				(char*)cirdia_bits };
icon_struct	c_spl_ic = { c_spl_width, c_spl_height,
				(char*)c_spl_bits };
icon_struct	c_xspl_ic = { c_xspl_width, c_xspl_height,
				(char*)c_xspl_bits };
icon_struct	xspl_ic = { xspl_width, xspl_height,
				(char*)xspl_bits };
icon_struct	intspl_ic = { intspl_width, intspl_height,
				(char*)intspl_bits };
icon_struct	c_intspl_ic = { c_intspl_width, c_intspl_height,
				(char*)c_intspl_bits };
icon_struct	copy_ic = { copy_width, copy_height,
				(char*)copy_bits };
icon_struct	glue_ic = { glue_width, glue_height,
				(char*)glue_bits };
icon_struct	break_ic = { break_width, break_height,
				(char*)break_bits };
icon_struct	open_comp_ic = { open_comp_width, open_comp_height, 
				 (char*)open_comp_bits };
icon_struct	join_split_ic = { join_split_width, join_split_height, 
				 (char*)join_split_bits };
icon_struct	deletept_ic = { deletept_width, deletept_height, 
				(char*)deletept_bits };
icon_struct	ellrad_ic = { ellrad_width, ellrad_height,
				(char*)ellrad_bits };
icon_struct	elldia_ic = { elldia_width, elldia_height,
				(char*)elldia_bits };
icon_struct	flip_x_ic = { flip_x_width, flip_x_height,
				(char*)flip_x_bits };
icon_struct	flip_y_ic = { flip_y_width, flip_y_height,
				(char*)flip_y_bits };
icon_struct	line_ic = { line_width, line_height,
				(char*)line_bits };
icon_struct	library_ic = {library_width, library_height,
				    (char*)library_bits };
icon_struct	move_ic = { move_width, move_height,
				(char*)move_bits };
icon_struct	movept_ic = { movept_width, movept_height,
				(char*)movept_bits };
icon_struct	polygon_ic = { polygon_width, polygon_height,
				(char*)polygon_bits };
icon_struct	delete_ic = { delete_width, delete_height,
				(char*)delete_bits };
icon_struct	rotCCW_ic = { rotCCW_width, rotCCW_height,
				(char*)rotCCW_bits };
icon_struct	scale_ic = { scale_width, scale_height,
				(char*)scale_bits };
icon_struct	convert_ic = { convert_width, convert_height,
				(char*)convert_bits };
icon_struct	spl_ic = { spl_width, spl_height,
				(char*)spl_bits };
icon_struct	text_ic = { text_width, text_height,
				(char*)text_bits };
icon_struct	picobj_ic = { picobj_width, picobj_height,
				(char*)picobj_bits };
icon_struct	rotCW_ic = { rotCW_width, rotCW_height,
				(char*)rotCW_bits };
icon_struct	update_ic = { update_width, update_height,
				(char*)update_bits };
icon_struct	edit_ic = { edit_width, edit_height,
				(char*)edit_bits };
icon_struct	smartoff_ic = { smartoff_width, smartoff_height, 
				(char*)smartoff_bits };
icon_struct	smartmove_ic = { smartmove_width, smartmove_height, 
				 (char*)smartmove_bits };
icon_struct	smartslide_ic = { smartslide_width, smartslide_height, 
				  (char*)smartslide_bits };
icon_struct	joinmiter_ic = { joinmiter_width, joinmiter_height, 
				 (char*)joinmiter_bits };
icon_struct	joinround_ic = { joinround_width, joinround_height, 
				 (char*)joinround_bits };
icon_struct	joinbevel_ic = { joinbevel_width, joinbevel_height, 
				 (char*)joinbevel_bits };
icon_struct	capbutt_ic = { capbutt_width, capbutt_height,
				(char*)capbutt_bits };
icon_struct	capround_ic = { capround_width, capround_height, 
				(char*)capround_bits };
icon_struct	capproject_ic = { capproject_width, capproject_height, 
				  (char*)capproject_bits };
icon_struct	solidline_ic = { solidline_width, solidline_height, 
				 (char*)solidline_bits };
icon_struct	dashline_ic = { dashline_width, dashline_height, 
				(char*)dashline_bits };
icon_struct	dottedline_ic = { dottedline_width, dottedline_height, 
				  (char*)dottedline_bits };
icon_struct	dashdotline_ic = { dashdotline_width, dashdotline_height, 
				  (char*)dashdotline_bits };
icon_struct	dash2dotsline_ic = { dash2dotsline_width, dash2dotsline_height, 
				  (char*)dash2dotsline_bits };
icon_struct	dash3dotsline_ic = { dash3dotsline_width, dash3dotsline_height, 
				  (char*)dash3dotsline_bits };
icon_struct	grid1_ic = { grid1_width, grid1_height,
				(char*)grid1_bits };
icon_struct	grid2_ic = { grid2_width, grid2_height,
				(char*)grid2_bits };
icon_struct	grid3_ic = { grid3_width, grid3_height,
				(char*)grid3_bits };
icon_struct	grid4_ic = { grid4_width, grid4_height,
				(char*)grid4_bits };
icon_struct	fine_grid_ic = { fine_grid_width, fine_grid_height, 
				 (char*)fine_grid_bits };
icon_struct	unconstrained_ic = { unconstrained_width, unconstrained_height,
				     (char*)unconstrained_bits };
icon_struct	latexline_ic = { latexline_width, latexline_height, 
				 (char*)latexline_bits };
icon_struct	latexarrow_ic = { latexarrow_width, latexarrow_height, 
				  (char*)latexarrow_bits };
icon_struct	mounthattan_ic = { mounthattan_width, mounthattan_height, 
				   (char*)mounthattan_bits };
icon_struct	manhattan_ic = { manhattan_width, manhattan_height, 
				 (char*)manhattan_bits };
icon_struct	mountain_ic = { mountain_width, mountain_height,
				(char*)mountain_bits };
icon_struct	halignl_ic = { halignl_width, halignl_height, 
			       (char*)halignl_bits };
icon_struct	halignr_ic = { halignr_width, halignr_height, 
			       (char*)halignr_bits };
icon_struct	halignc_ic = { halignc_width, halignc_height, 
			       (char*)halignc_bits };
icon_struct	haligndc_ic = { haligndc_width, haligndc_height, 
				(char*)haligndc_bits };
icon_struct	halignde_ic = { halignde_width, halignde_height, 
				(char*)halignde_bits };
icon_struct	haligna_ic = { haligna_width, haligna_height, 
			       (char*)haligna_bits };
icon_struct	valignt_ic = { valignt_width, valignt_height, 
			       (char*)valignt_bits };
icon_struct	valignb_ic = { valignb_width, valignb_height, 
			       (char*)valignb_bits };
icon_struct	valignc_ic = { valignc_width, valignc_height, 
			       (char*)valignc_bits };
icon_struct	valigndc_ic = { valigndc_width, valigndc_height, 
				(char*)valigndc_bits };
icon_struct	valignde_ic = { valignde_width, valignde_height, 
				(char*)valignde_bits };
icon_struct	valigna_ic = { valigna_width, valigna_height, 
			       (char*)valigna_bits };
icon_struct	any_ic = { any_width, any_height,
				(char*)any_bits };
icon_struct	none_ic = { none_width, none_height,
				(char*)none_bits };
icon_struct	fill_ic = { fill_width, fill_height,
				(char*)fill_bits };
icon_struct	blank_ic = { blank_width, blank_height,
				(char*)blank_bits };
icon_struct	textL_ic = { textL_width, textL_height,
				(char*)textL_bits };
icon_struct	textC_ic = { textC_width, textC_height,
				(char*)textC_bits };
icon_struct	textR_ic = { textR_width, textR_height,
				(char*)textR_bits };
icon_struct	noarrows_ic = { noarrows_width, noarrows_height, 
				(char*)noarrows_bits };
icon_struct	farrows_ic = { farrows_width, farrows_height, 
			       (char*)farrows_bits };
icon_struct	barrows_ic = { barrows_width, barrows_height, 
			       (char*)barrows_bits };
icon_struct	fbarrows_ic = { fbarrows_width, fbarrows_height, 
				(char*)fbarrows_bits };
icon_struct	tangent_ic = { tangent_width, tangent_height, (char*)tangent_bits };
icon_struct	anglemeas_ic = { anglemeas_width, anglemeas_height, (char*)anglemeas_bits };
icon_struct	lenmeas_ic = { lenmeas_width, lenmeas_height, (char*)lenmeas_bits };
icon_struct	areameas_ic = { areameas_width, areameas_height, (char*)areameas_bits };


/*************** misc icons *************/

#define printer_width 54
#define printer_height 28
static unsigned char printer_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0xe0,0xff,0xff,0xff,0xff,0xff,0x0f,0x20,
0x00,0x00,0x00,0x00,0x00,0x08,0x20,0x00,0x00,0x00,0x00,
0x00,0x08,0x20,0x00,0x00,0x00,0x00,0x00,0x08,0xe0,0xff,
0xff,0xff,0xff,0xff,0x0f,0xa0,0x00,0x00,0x00,0x00,0x00,
0x08,0xa0,0x00,0x00,0xf8,0x03,0x00,0x08,0xa0,0x00,0x00,
0x08,0x02,0x00,0x08,0xa0,0x00,0x00,0xa8,0x02,0x00,0x04,
0xa0,0x00,0x00,0xf8,0x03,0x00,0x02,0xa0,0x00,0x00,0x00,
0x00,0x00,0x01,0xe0,0xff,0xff,0xff,0xff,0xff,0x00,0x80,
0x00,0x00,0x00,0x00,0x80,0x00,0xfc,0xf8,0xff,0xff,0xff,
0x9f,0x00,0x84,0x00,0x00,0x00,0x00,0x80,0x00,0x84,0xf8,
0xff,0xff,0xff,0x9f,0x00,0xfc,0x00,0x00,0x00,0x00,0x80,
0x00,0xe0,0xf8,0xff,0xff,0xff,0x9f,0x00,0xc0,0x00,0x00,
0x00,0x00,0x80,0x00,0x80,0xf8,0xff,0xff,0xff,0x9f,0x00,
0x00,0x01,0x00,0x00,0x00,0x80,0x00,0x00,0xfe,0xff,0xff,
0xff,0xff,0x00,0x00,0x7c,0x00,0x00,0x00,0x7c,0x00,0x00,
0x38,0x00,0x00,0x00,0x38,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define kbd_width 56
#define kbd_height 19
static unsigned char kbd_bits[] = {
0xef,0xbd,0xf7,0xde,0x7b,0xef,0xfd,0x29,0xa5,0x94,0x52,
0x4a,0x29,0x85,0x29,0xa5,0x94,0x52,0x4a,0x29,0x85,0xef,
0xbd,0xf7,0xde,0x7b,0xef,0xfd,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0xbc,0xf7,0xde,0x7b,0xef,0xbd,0xf7,0xa4,0x94,
0x52,0x4a,0x29,0xa5,0x94,0xa4,0x94,0x52,0x4a,0x29,0xa5,
0x94,0xbc,0xf7,0xde,0x7b,0xef,0xbd,0x97,0x00,0x00,0x00,
0x00,0x00,0x00,0x90,0xf0,0xde,0x7b,0xef,0xbd,0xf7,0x9e,
0x90,0x52,0x4a,0x29,0xa5,0x94,0x82,0x90,0x52,0x4a,0x29,
0xa5,0x94,0x82,0xf0,0xde,0x7b,0xef,0xbd,0xf7,0xfe,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0xe0,0xef,0xbd,0xf7,0xde,
0x7b,0x7f,0x20,0x28,0xa5,0x94,0x52,0x4a,0x41,0x20,0x28,
0xa5,0x94,0x52,0x4a,0x41,0xe0,0xef,0xbd,0xf7,0xde,0x7b,
0x7f};

/* arrowhead bitmaps */

#define no_arrow_width 32
#define no_arrow_height 32
unsigned char no_arrow_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x10,0x00,0x00,0x04,
0x08,0x00,0x00,0x08,0x08,0x00,0x00,0x08,0x24,0x32,0xd1,0x13,
0x24,0x4a,0x51,0x10,0x62,0x4a,0x53,0x20,0x62,0x4a,0x53,0x20,
0xa2,0x4a,0xd5,0x21,0xa2,0x4a,0x55,0x20,0x22,0x4b,0x59,0x20,
0x22,0x4b,0x59,0x20,0x24,0x4a,0x51,0x10,0x24,0x32,0xd1,0x13,
0x08,0x00,0x00,0x08,0x08,0x00,0x00,0x08,0x10,0x00,0x00,0x04,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,};

#define arrow0_width 32
#define arrow0_height 32
unsigned char	arrow0_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x18,0x00,0x00,0x00,0xe0,0x01,0x00,0x00,0x00,0x1e,0x00,
0x00,0x00,0xe0,0x01,0xf0,0xff,0xff,0x0f,0x00,0x00,0xc0,0x03,
0x00,0x00,0x3c,0x00,0x00,0xc0,0x03,0x00,0x00,0x38,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00};
#define arrow1o_width 32
#define arrow1o_height 32
unsigned char	arrow1o_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x38,0x00,0x00,0x00,0xe8,0x03,0x00,0x00,0x08,0x3e,0x00,
0x00,0x08,0xe0,0x03,0xf8,0x0f,0x00,0x0f,0x00,0x08,0xf8,0x01,
0x00,0x08,0x1f,0x00,0x00,0xf8,0x01,0x00,0x00,0x18,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00};
#define arrow1f_width 32
#define arrow1f_height 32
unsigned char	arrow1f_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x18,0x00,0x00,0x00,0xf8,0x01,0x00,0x00,0xf8,0x1f,0x00,
0x00,0xf8,0xff,0x01,0xf8,0xff,0xff,0x0f,0x00,0xf8,0xff,0x03,
0x00,0xf8,0x3f,0x00,0x00,0xf8,0x03,0x00,0x00,0x38,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00};
#define arrow2o_width 32
#define arrow2o_height 32
unsigned char	arrow2o_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0c,0x00,0x00,
0x00,0xf8,0x00,0x00,0x00,0x10,0x0f,0x00,0x00,0x20,0x70,0x00,
0x00,0x40,0x80,0x07,0xfc,0xff,0x00,0x1c,0x00,0x40,0x00,0x06,
0x00,0x20,0xe0,0x01,0x00,0x10,0x1e,0x00,0x00,0xe8,0x01,0x00,
0x00,0x1c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00};
#define arrow2f_width 32
#define arrow2f_height 32
unsigned char	arrow2f_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0c,0x00,0x00,
0x00,0xf8,0x00,0x00,0x00,0xf0,0x0f,0x00,0x00,0xe0,0x7f,0x00,
0x00,0xc0,0xff,0x07,0xfc,0xff,0xff,0x1f,0x00,0xc0,0xff,0x07,
0x00,0xe0,0xff,0x01,0x00,0xf0,0x1f,0x00,0x00,0xf8,0x01,0x00,
0x00,0x1c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00};
#define arrow3o_width 32
#define arrow3o_height 32
unsigned char	arrow3o_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x80,0x01,0x00,0x00,0x40,0x0e,0x00,0x00,0x40,0xf0,0x00,
0x00,0x20,0x00,0x07,0xf8,0x1f,0x00,0x18,0x00,0x20,0x00,0x07,
0x00,0x40,0xf0,0x00,0x00,0x40,0x0e,0x00,0x00,0x80,0x01,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00};
#define arrow3f_width 32
#define arrow3f_height 32
unsigned char	arrow3f_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x80,0x01,0x00,0x00,0xc0,0x0f,0x00,0x00,0xc0,0xff,0x00,
0x00,0xe0,0xff,0x07,0xf8,0xff,0xff,0x1f,0x00,0xe0,0xff,0x07,
0x00,0xc0,0xff,0x00,0x00,0xc0,0x0f,0x00,0x00,0x80,0x01,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00};
#define arrow4o_width 32
#define arrow4o_height 32
unsigned char	arrow4o_bits[] = {
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x6c, 0x00, 0x00, 0x80, 0x83, 0x03,
0x00, 0x60, 0x00, 0x0c, 0xf8, 0x1f, 0x00, 0x10, 0x00, 0x60, 0x00, 0x0c,
0x00, 0x80, 0x83, 0x03, 0x00, 0x00, 0x6c, 0x00, 0x00, 0x00, 0x10, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, };

#define arrow4f_width 32
#define arrow4f_height 32
unsigned char	arrow4f_bits[] = {
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x7c, 0x00, 0x00, 0x80, 0xff, 0x03,
0x00, 0xe0, 0xff, 0x0f, 0xf8, 0xff, 0xff, 0x1f, 0x00, 0xe0, 0xff, 0x0f,
0x00, 0x80, 0xff, 0x03, 0x00, 0x00, 0x7c, 0x00, 0x00, 0x00, 0x10, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, };

#define arrow5o_width 32
#define arrow5o_height 32
unsigned char	arrow5o_bits[] = {
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00,
0x00, 0x00, 0x6c, 0x00, 0x00, 0x00, 0x83, 0x01, 0x00, 0x80, 0x00, 0x02,
0x00, 0x40, 0x00, 0x04, 0x00, 0x40, 0x00, 0x04, 0x00, 0x20, 0x00, 0x08,
0x00, 0x20, 0x00, 0x08, 0xf8, 0x1f, 0x00, 0x10, 0x00, 0x20, 0x00, 0x08,
0x00, 0x20, 0x00, 0x08, 0x00, 0x40, 0x00, 0x04, 0x00, 0x40, 0x00, 0x04,
0x00, 0x80, 0x00, 0x02, 0x00, 0x00, 0x83, 0x01, 0x00, 0x00, 0x6c, 0x00,
0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, };

#define arrow5f_width 32
#define arrow5f_height 32
unsigned char	arrow5f_bits[] = {
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00,
0x00, 0x00, 0x7c, 0x00, 0x00, 0x00, 0xff, 0x01, 0x00, 0x80, 0xff, 0x03,
0x00, 0xc0, 0xff, 0x07, 0x00, 0xc0, 0xff, 0x07, 0x00, 0xe0, 0xff, 0x0f,
0x00, 0xe0, 0xff, 0x0f, 0xf8, 0xff, 0xff, 0x1f, 0x00, 0xe0, 0xff, 0x0f,
0x00, 0xe0, 0xff, 0x0f, 0x00, 0xc0, 0xff, 0x07, 0x00, 0xc0, 0xff, 0x07,
0x00, 0x80, 0xff, 0x03, 0x00, 0x00, 0xff, 0x01, 0x00, 0x00, 0x7c, 0x00,
0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, };

#define arrow6o_width 32
#define arrow6o_height 32
unsigned char arrow6o_bits[] = {
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x00, 0x00, 0x00, 0x07, 0x00,
0x00, 0x80, 0x01, 0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0xc0, 0x00, 0x00,
0x00, 0x40, 0x00, 0x00, 0xf8, 0x7f, 0x00, 0x00, 0x00, 0x40, 0x00, 0x00,
0x00, 0xc0, 0x00, 0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0x80, 0x01, 0x00,
0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
#define arrow6f_width 32
#define arrow6f_height 32
unsigned char arrow6f_bits[] = {
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x00, 0x00, 0x00, 0x3f, 0x00,
0x00, 0x80, 0x3f, 0x00, 0x00, 0x80, 0x3f, 0x00, 0x00, 0xc0, 0x3f, 0x00,
0x00, 0xc0, 0x3f, 0x00, 0xf8, 0xff, 0x3f, 0x00, 0x00, 0xc0, 0x3f, 0x00,
0x00, 0xc0, 0x3f, 0x00, 0x00, 0x80, 0x3f, 0x00, 0x00, 0x80, 0x3f, 0x00,
0x00, 0x00, 0x3f, 0x00, 0x00, 0x00, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
#define arrow7o_width 32
#define arrow7o_height 32
unsigned char arrow7o_bits[] = {
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0xc0, 0x7f, 0x00, 0x00, 0x40, 0x40, 0x00, 0x00, 0x40, 0x40, 0x00,
0x00, 0x40, 0x40, 0x00, 0xf8, 0x7f, 0x40, 0x00, 0x00, 0x40, 0x40, 0x00,
0x00, 0x40, 0x40, 0x00, 0x00, 0x40, 0x40, 0x00, 0x00, 0xc0, 0x7f, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};

#define arrow7f_width 32
#define arrow7f_height 32
unsigned char arrow7f_bits[] = {
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0xc0, 0x7f, 0x00, 0x00, 0xc0, 0x7f, 0x00, 0x00, 0xc0, 0x7f, 0x00,
0x00, 0xc0, 0x7f, 0x00, 0xf8, 0xff, 0x7f, 0x00, 0x00, 0xc0, 0x7f, 0x00,
0x00, 0xc0, 0x7f, 0x00, 0x00, 0xc0, 0x7f, 0x00, 0x00, 0xc0, 0x7f, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
#define arrow8o_width 32
#define arrow8o_height 32
unsigned char arrow8o_bits[] = {
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x00,
0x00, 0x00, 0x70, 0x00, 0x00, 0x00, 0x4c, 0x00, 0x00, 0x00, 0x43, 0x00,
0x00, 0xc0, 0x40, 0x00, 0xf8, 0x3f, 0x40, 0x00, 0x00, 0xc0, 0x40, 0x00,
0x00, 0x00, 0x43, 0x00, 0x00, 0x00, 0x4c, 0x00, 0x00, 0x00, 0x70, 0x00,
0x00, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
#define arrow8f_width 32
#define arrow8f_height 32
unsigned char arrow8f_bits[] = {
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x00,
0x00, 0x00, 0x70, 0x00, 0x00, 0x00, 0x7c, 0x00, 0x00, 0x00, 0x7f, 0x00,
0x00, 0xc0, 0x7f, 0x00, 0xf8, 0xff, 0x7f, 0x00, 0x00, 0xc0, 0x7f, 0x00,
0x00, 0x00, 0x7f, 0x00, 0x00, 0x00, 0x7c, 0x00, 0x00, 0x00, 0x70, 0x00,
0x00, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
#define arrow9a_width 32
#define arrow9a_height 32
unsigned char arrow9a_bits[] = {
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x08, 0x00,
0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x01, 0x00,
0x00, 0x80, 0x00, 0x00, 0xf8, 0x7f, 0x00, 0x00, 0x00, 0x80, 0x00, 0x00,
0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x04, 0x00,
0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x20, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
#define arrow9b_width 32
#define arrow9b_height 32
unsigned char arrow9b_bits[] = {
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x20, 0x00,
0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x20, 0x00,
0x00, 0x00, 0x20, 0x00, 0xf8, 0xff, 0x3f, 0x00, 0x00, 0x00, 0x20, 0x00,
0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x20, 0x00,
0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
#define arrow10a_width 32
#define arrow10a_height 32
unsigned char arrow10a_bits[] = {
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x3f, 0x00, 0x00, 0x40, 0x00, 0x00,
0x00, 0x40, 0x00, 0x00, 0x00, 0x40, 0x00, 0x00, 0x00, 0x40, 0x00, 0x00,
0x00, 0x40, 0x00, 0x00, 0xf8, 0x7f, 0x00, 0x00, 0x00, 0x40, 0x00, 0x00,
0x00, 0x40, 0x00, 0x00, 0x00, 0x40, 0x00, 0x00, 0x00, 0x40, 0x00, 0x00,
0x00, 0x40, 0x00, 0x00, 0x00, 0xc0, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
#define arrow10b_width 32
#define arrow10b_height 32
unsigned char arrow10b_bits[] = {
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x3f, 0x00, 0x00, 0x00, 0x20, 0x00,
0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x20, 0x00,
0x00, 0x00, 0x20, 0x00, 0xf8, 0xff, 0x3f, 0x00, 0x00, 0x00, 0x20, 0x00,
0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x20, 0x00,
0x00, 0x00, 0x20, 0x00, 0x00, 0xc0, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};

icon_struct	no_arrow_ic = { no_arrow_width, no_arrow_height, 
			      (char*)no_arrow_bits };
icon_struct	arrow0_ic = { arrow0_width, arrow0_height, 
			      (char*)arrow0_bits };
icon_struct	arrow1o_ic = { arrow1o_width, arrow1o_height, 
			      (char*)arrow1o_bits };
icon_struct	arrow1f_ic = { arrow1f_width, arrow1f_height, 
			      (char*)arrow1f_bits };
icon_struct	arrow2o_ic = { arrow2o_width, arrow2o_height, 
			      (char*)arrow2o_bits };
icon_struct	arrow2f_ic = { arrow2f_width, arrow2f_height, 
			      (char*)arrow2f_bits };
icon_struct	arrow3o_ic = { arrow3o_width, arrow3o_height, 
			      (char*)arrow3o_bits };
icon_struct	arrow3f_ic = { arrow3f_width, arrow3f_height, 
			      (char*)arrow3f_bits };
icon_struct	arrow4o_ic = { arrow4o_width, arrow4o_height, 
			      (char*)arrow4o_bits };
icon_struct	arrow4f_ic = { arrow4f_width, arrow4f_height, 
			      (char*)arrow4f_bits };
icon_struct	arrow5o_ic = { arrow5o_width, arrow5o_height, 
			      (char*)arrow5o_bits };
icon_struct	arrow5f_ic = { arrow5f_width, arrow5f_height, 
			      (char*)arrow5f_bits };
icon_struct	arrow6o_ic = { arrow6o_width, arrow6o_height, 
			      (char*)arrow6o_bits };
icon_struct	arrow6f_ic = { arrow6f_width, arrow6f_height, 
			      (char*)arrow6f_bits };
icon_struct	arrow7o_ic = { arrow7o_width, arrow7o_height, 
			      (char*)arrow7o_bits };
icon_struct	arrow7f_ic = { arrow7f_width, arrow7f_height, 
			      (char*)arrow7f_bits };
icon_struct	arrow8o_ic = { arrow8o_width, arrow8o_height, 
			      (char*)arrow8o_bits };
icon_struct	arrow8f_ic = { arrow8f_width, arrow8f_height, 
			      (char*)arrow8f_bits };
icon_struct	arrow9a_ic = { arrow9a_width, arrow9a_height, 
			      (char*)arrow9a_bits };
icon_struct	arrow9b_ic = { arrow9b_width, arrow9b_height, 
			      (char*)arrow9b_bits };
icon_struct	arrow10a_ic = { arrow10a_width, arrow10a_height, 
			      (char*)arrow10a_bits };
icon_struct	arrow10b_ic = { arrow10b_width, arrow10b_height, 
			      (char*)arrow10b_bits };

icon_struct	printer_ic = { printer_width, printer_height, 
			       (char*)printer_bits };
icon_struct	kbd_ic = { kbd_width, kbd_height,
				(char*)kbd_bits };

/* The following XBM image is used for the icon on a monochrome display */

/* new icon from Marc-Aurle Darche */

#define fig_width 64
#define fig_height 64
static char fig_bits[] = {
 0x55,0x55,0x55,0x55,0x55,0xb5,0x6d,0xdb,0x55,0x55,0xa9,0xa4,0x54,0xd5,0xb6,
 0xb5,0x2a,0x95,0x4a,0x95,0xd2,0x6a,0xdb,0xde,0xa9,0x52,0xaa,0x52,0xf5,0xab,
 0x6d,0x6b,0x55,0x55,0x49,0xaa,0xea,0xd7,0xaa,0xd5,0xaa,0x4a,0x25,0x49,0x6a,
 0x2b,0xb7,0xbe,0xa5,0x2a,0x55,0xa5,0xd2,0xdf,0xda,0xd5,0x9a,0x54,0x29,0x95,
 0xd4,0x5f,0xad,0xba,0xa5,0x52,0xa5,0x52,0xea,0xfb,0x76,0xd7,0x55,0x95,0x14,
 0x49,0xe5,0xef,0xda,0xba,0xaa,0xaa,0xaa,0x54,0xf2,0xff,0x6b,0xdb,0xaa,0x24,
 0x49,0x25,0xb5,0xef,0xad,0xad,0x95,0xaa,0x24,0x92,0xf4,0xfe,0xdb,0xf6,0x54,
 0x55,0x55,0xa9,0xfa,0xff,0x6f,0xad,0xab,0x4a,0x55,0x25,0xf9,0x6f,0xbf,0xbb,
 0x54,0x02,0x00,0x95,0xac,0xfb,0xfd,0xd6,0x4a,0x1f,0x50,0x19,0x80,0x5e,0xef,
 0xbb,0x55,0x1f,0xe0,0x7a,0x50,0xeb,0xfa,0xdd,0xaa,0x3e,0xe0,0x3d,0xf8,0x5f,
 0xbf,0xb7,0x55,0x5f,0xe0,0x3c,0xfc,0xea,0xea,0xdf,0x4a,0x7f,0x40,0x1d,0xff,
 0x5d,0xbf,0xbf,0xaa,0x7e,0xc2,0x4e,0xff,0xeb,0xfa,0xdf,0x55,0xf5,0x40,0x84,
 0x7f,0x5f,0xef,0x7e,0xaa,0xf2,0x80,0xe5,0xdf,0xb7,0xfb,0xff,0x55,0x6a,0x81,
 0xf2,0xfb,0xed,0xbe,0xbf,0xaa,0xea,0x89,0xf0,0x7f,0xbf,0xf7,0xff,0xa5,0xea,
 0x01,0xfc,0xff,0xfd,0xde,0x7f,0x54,0xd5,0x03,0xfe,0xff,0xef,0xff,0xff,0x95,
 0xa4,0x03,0xf6,0xef,0xbf,0xff,0xff,0x55,0xd5,0x15,0xf6,0xbf,0xf7,0xfb,0x7f,
 0x55,0x95,0x43,0xf4,0xff,0xff,0xbf,0xff,0xaa,0xaa,0x07,0xea,0xff,0xff,0xff,
 0xff,0xaa,0x54,0x03,0xf4,0xff,0xee,0xfe,0xff,0xaa,0x52,0x11,0xec,0xff,0xff,
 0xff,0x7f,0xaa,0xca,0x18,0xe8,0xff,0xff,0xff,0xff,0x55,0x55,0x1c,0xe8,0xff,
 0xff,0xff,0xbf,0xaa,0x6a,0x2e,0xf0,0xff,0xff,0xff,0xff,0x52,0x15,0xbf,0xd0,
 0xff,0xff,0xff,0x5f,0xaa,0x9a,0x3f,0xaa,0x1f,0x9c,0xff,0xff,0x95,0xc6,0x7b,
 0xa0,0x07,0x04,0xff,0xaf,0xaa,0xd2,0x7a,0x69,0x07,0x00,0xfe,0xbf,0x5b,0xe3,
 0xba,0x40,0x03,0x08,0xff,0xef,0xd5,0x78,0xf5,0x64,0x45,0x0f,0xff,0xd7,0x6d,
 0x74,0x75,0x89,0xe1,0xff,0x7f,0xfa,0xb6,0x5c,0xf5,0xa1,0x02,0x00,0x0f,0x80,
 0x0b,0xe8,0x5a,0x04,0x05,0x81,0x0f,0x80,0x42,0xa2,0x8e,0x50,0x0c,0x80,0x03,
 0x81,0xbd,0xbd,0x7d,0xbf,0xd7,0x96,0xa3,0xe9,0xff,0xff,0xfe,0xff,0xe2,0xc3,
 0xc2,0xe0,0xff,0x77,0xfd,0xff,0xe9,0x83,0x83,0xe8,0x55,0xad,0x56,0x55,0x51,
 0x53,0x4b,0xb0,0xaa,0xb5,0xab,0xea,0xe0,0xc2,0x07,0xf8,0xdd,0x56,0x75,0xbf,
 0x52,0xcb,0x1e,0xfa,0x6b,0xbb,0xad,0xd5,0xe0,0x41,0x8e,0xdf,0xad,0xd5,0xda,
 0xea,0x54,0x25,0x06,0xf8,0xb6,0x6e,0x6f,0xbf,0xf0,0x03,0x01,0xd0,0xdb,0x55,
 0xb5,0xd5,0x54,0x89,0x60,0xe0,0xad,0xba,0x5b,0x6d,0xf0,0xeb,0xa1,0xc1,0xea,
 0x6e,0xed,0x0b,0x5d,0xbf,0xe9,0xca,0xbf,0xd5,0xb6,0x06,0xb8,0xfd,0x01,0xe0,
 0x52,0xbb,0xdb,0x05,0xde,0x77,0x13,0xf0,0xef,0xd6,0xb6,0x2e,0x77,0xff,0x85,
 0xb8,0x5a,0x7b,0xdb,0xab,0xef,0xdd,0x5f,0xff,0xed,0xad,0x6d,0xfd,0xfb,0xf7,
 0xff,0xef};

/* for the whole figure edit panel */

icon_struct	figure_ic = { fig_width, fig_height, (char*) fig_bits };

#ifdef USE_XPM_ICON

/* XPM version of xfig icon - first in full color for TrueColor displays,
   then in reduced color for 256 color-mapped displays */

char * fig_full_c_icon_X[] = {
/* width height num_colors chars_per_pixel */
"    64    64      253            2",
/* colors */
".. c #050804", ".# c #138820", ".a c #793d26", ".b c #ac8664", ".c c #084808", ".d c #74622c",
".e c #e0c68c", ".f c #d0895b", ".g c #3f180a", ".h c #ae643e", ".i c #47511c", ".j c #9c522e",
".k c #ccaa74", ".l c #066813", ".m c #785030", ".n c #412f27", ".o c #b17859", ".p c #eda870",
".q c #117611", ".r c #072804", ".s c #84767c", ".t c #f9e6a4", ".u c #60301f", ".v c #925132",
".w c #ed9967", ".x c #748634", ".y c #1b9c2c", ".z c #07580d", ".A c #9a6350", ".B c #eac8c4",
".C c #cc986c", ".D c #c5774e", ".E c #efb97f", ".F c #b09ea8", ".G c #603b30", ".H c #8c4930",
".I c #342818", ".J c #bb8863", ".K c #b27052", ".L c #7a4730", ".M c #1e6818", ".N c #073707",
".O c #9b6f4f", ".P c #248822", ".Q c #24791f", ".R c #9e5834", ".S c #ae786a", ".T c #8e5b3d",
".U c #1f5717", ".V c #d4a6a0", ".W c #805c3e", ".X c #43251e", ".Y c #b98b84", ".Z c #260f05",
".0 c #eca99d", ".1 c #10801e", ".2 c #e9d9df", ".3 c #d1998e", ".4 c #ae5e39", ".5 c #0a7015",
".6 c #613247", ".7 c #086011", ".8 c #074008", ".9 c #14480e", "#. c #e9dd9c", "## c #cd8d7f",
"#a c #623c3f", "#b c #a05853", "#c c #1c9428", "#d c #924f52", "#e c #279b29", "#f c #f1b7ad",
"#g c #4c2413", "#h c #996960", "#i c #753e49", "#j c #ac6554", "#k c #74514f", "#l c #bd704a",
"#m c #5e4732", "#n c #b27e5b", "#o c #7c4745", "#p c #d5babe", "#q c #766667", "#r c #522f28",
"#s c #f8c9c3", "#t c #c4966c", "#u c #041804", "#v c #fae8e6", "#w c #a4634b", "#x c #ca8055",
"#y c #1c7f21", "#z c #1c892a", "#A c #0a500f", "#B c #d29062", "#C c #f3af77", "#D c #a27759",
"#E c #6c3521", "#F c #6c3c2f", "#G c #c48a60", "#H c #997169", "#I c #ae8069", "#J c #dd9d90",
"#K c #fbc88b", "#L c #146818", "#M c #84503c", "#N c #082f05", "#O c #603629", "#P c #de9966",
"#Q c #14380a", "#R c #259425", "#S c #f0b0a5", "#T c #146016", "#U c #25a430", "#V c #605e24",
"#W c #51372f", "#X c #bc6843", "#Y c #bc7852", "#Z c #1c7720", "#0 c #945638", "#1 c #145812",
"#2 c #ac715c", "#3 c #1e6f16", "#4 c #b99391", "#5 c #2f1c15", "#6 c #147019", "#7 c #14400a",
"#8 c #522a32", "#9 c #746e6c", "a. c #f7d0cb", "a# c #94868c", "aa c #e2b982", "ab c #bfadb4",
"ac c #ac9aa0", "ad c #fcfafa", "ae c #e3a774", "af c #4f4947", "ag c #f0a290", "ah c #f8d7d3",
"ai c #fbf7b0", "aj c #896240", "ak c #fcd898", "al c #1a0a04", "am c #2c3614", "an c #e3a89e",
"ao c #87645e", "ap c #685048", "aq c #a07972", "ar c #e4a694", "as c #c4a4a8", "at c #a7888f",
"au c #888084", "av c #ef9f69", "aw c #f1bf87", "ax c #d9c1c4", "ay c #f0bfba", "az c #dcd294",
"aA c #052004", "aB c #6c4834", "aC c #9c5150", "aD c #1d6012", "aE c #fbe1e0", "aF c #904a52",
"aG c #805e54", "aH c #844225", "aI c #b9877c", "aJ c #6c3644", "aK c #6c3b46", "aL c #84534c",
"aM c #c4948e", "aN c #25811f", "aO c #d49f96", "aP c #14500e", "aQ c #fceff0", "aR c #a48264",
"aS c #fbd092", "aT c #e2a06e", "aU c #e4b078", "aV c #a17f79", "aW c #fcb87e", "aX c #a46f4e",
"aY c #e4b6b0", "aZ c #fcb076", "a0 c #341404", "a1 c #443a24", "a2 c #cf9f6f", "a3 c #c48e84",
"a4 c #c48879", "a5 c #041004", "a6 c #fce09c", "a7 c #aa8784", "a8 c #dc885f", "a9 c #fc9a74",
"b. c #844830", "b# c #8f5b4e", "ba c #fcaa94", "bb c #ac5e54", "bc c #a46a5c", "bd c #844847",
"be c #d4825a", "bf c #a47264", "bg c #bc806f", "bh c #fcb29c", "bi c #1c7228", "bj c #343234",
"bk c #148e25", "bl c #401e13", "bm c #78563f", "bn c #e4ced4", "bo c #ceaeae", "bp c #cf9285",
"bq c #4f2a1e", "br c #846a4c", "bs c #8a6a69", "bt c #94766c", "bu c #fca284", "bv c #fcaa74",
"bw c #bc7a64", "bx c #fcbab1", "by c #bc8059", "bz c #dc915f", "bA c #143204", "bB c #fcc084",
"bC c #fcc1b5", "bD c #141a04", "bE c #8c7274", "bF c #ecd094", "bG c #6c4846", "bH c #a46a51",
"bI c #1c8e24", "bJ c #78422e", "bK c #b36a43", "bL c #1ca22c", "bM c #9c6a52", "bN c #5c4234",
"bO c #b68e6a", "bP c #278e20", "bQ c #a45e39", "bR c #422a20", "bS c #633642", "bT c #a05e4f",
"bU c #945651", "bV c #7b4246", "bW c #ac6a54", "bX c #795651", "bY c #e0a297", "bZ c #bc9a99",
"b0 c #342214", "b1 c #c4b2b4", "b2 c #e4aea6", "b3 c #ecc68c", "b4 c #7c4f3f", "b5 c #0f781d",
"b6 c #5c3231",
/* pixels */
"bK.h#XbKbK#X#l#X#l#l#l#l#l#l#l#l.D#l.D.D#Y.D.D#Y.D.D#Y.D.D#Y#l.D#l#l#l#l#l#l#XbKbKbK.h.h.h.h.h.hbQ.4bQ.R.R.R.R.R.R.j.R.v.j.v.j.v",
"bK#XbKbK#lbK#lbK#l#l#l#l#l.D#l.D#l.D#Y#l.D#l#Y.D#Y#Y.D#Y#Y.D.D#l.D.D#l#l#l#l.ObK#XbK#XbK.h.h.h.4.4bQbQbQ.4.R.R.R.j.j.j.j.j.j.v.v",
"bKbKbK#XbK#l#l#l#l#l#l#l#l.D#l.D#Y.D#Y.D#Y.D#Y.D#Y.D#Y.D#Y.D#Y.D#Y#l.D.D#l.xbk.5.hbKbKbK.h.h.h.4bQ.4bQ.RbQ.R.R.R.R.R.j.j.j.v.v.j",
".hbK#lbK#X#l#X#l#l#l#l.D#l.D#Y.D#Y#Y.D#Y#Y#x#Yby.D#Yby#Y#x#Y#Y#Y#Y.D#Y#Y.h.z.q.1.7bKbK#XbK.h.h.h.hbQbQ.4.RbQ.R.R.R.j#0.j.j.v.v.v",
"#X#XbK#l#lbK#l#l#l#l.D#l#Y#Y#Y#Y#Y.Dby#Yby#Yby#Ybyby.Dby#Yby.Dby#Y#Y#Y#YbQ.r.7#y.7#VbKbKbKbK.h.h.4bQ.4bQbQ.R.R.R.R.j#0.j.j.j.v.v",
"bKbK#lbK#l#l#l#l#l#Y#l#Y#Y.D#Y.D#Yby#Yby.Dbybyby#xbybybybybyby#Yby.D#Y#Y#Y#w.8.q.M.z.m#lbK.hbK.h.h.hbQbQbQbQ.R.R.R.R#0.v.j.v.v.v",
"bK#lbK#l#l#l#l#l#Y#l#Y#Y#Y#Y#Yby#Yby#Ybybybybybybybybybybyby.Dbyby#Yby#Y#YaX.N.9#1.z.N#0bKbKbK.h.hbQ.hbQbQ.RbQ.R.j.R.j.j.v.j.v.v",
"#lbK#X#l#l#l#l#Y#l#Y#Y#Y#Y#Y#Y#Yby#xbybybyby#xbybybybyby#xbybybybybyby#Y#x.K.r.c#A.z.7#A.ibKbK.hbKbQ.4bQbQbQ.R.R.R#0#0#0.j.v.v.v",
"bK#l#l#l#l#l#l#Y#Y#Y#Y#Y#Ybybybybybybybybybyby.Jbybyby.Jbybybybybyby#Yby#YbM.N.z.7.5.5#T.l.7.W.h.h.h.hbQbQbQ.R.R.R.R.j#0.v.v.v.v",
"bK#lbK#lbK#Y#l#Y#l#Y#Y#Yby#Yby#Ybybybybyby.Jby.Jby.J.Jby.Jby.Jbybybybyby#n#m.8.z.7.7.U.#.1.5#A.WbK.hbQbQbQbQbQ.R.R.j#0.j.v.v.v.v",
"#l#l#l#l#Y.K#Y.K#Y#Y#Y#Yby#Yby#nby#n.J.J.Jby.J.J.J.Jby.J.J.Jby.JbybybybybH.N#A.c.9#L.1.1.1.1.l.c.W.h.hbQbQbQ.R.R.R#0.R#0.v.v.v.v",
"#X.K#l.K#l#l#Y#Y#Y#Y.o#Yby#nbybyby.Jby#n.J.J.J.J.J.J.J.J.J.J.Jby.J.Jby#n.m.8.c.N.z.l.l.5.5.l.l.7#AbQ#wbQbQbQ.RbQ.R#0.j.v.j.v.v.v",
"#l.K#l#l.o#l.o#Y.o#Ybyby#nbyby#n.Jby.J.J.J.J.J.J.J.J.J.J.J.J.J.J#n.J#n#Dam.N.N.9.7.7.l.l.l.z.7.7.7.z.W.hbQbQbQ.T.R.R#0.v.v.v.v.H",
".K#l.K#l#Y.K#Y#Y#Y#Y.o#Yby#nbyby.J.J#n.J.J.J.J.J.J.J.J.J.J.J.J.J.Jby.Jbm.r.N#A.z.7.7.l.l.7.7.l.5.l.7.z.ibQbT.R.R.R.R.v.R.v.v.v.v",
"#l#l.K#l.K#Y.o#Y.o#0#nbybybK.KaX.K#D.o.O.O#D#naR#n.bbO.J.b.J.b.J.J.J#Da1.N.c#A.7.7.lb5.1.5.5.1.1.1.1.5.l.z.mbQ.R.R#0#0.v.v.v.v.H",
".K#l.K#l.o#l.o#YaX#lbO.k.ea6a6a6a6akakakakaSbFaT.WbObO#D#Y.C#t.C#t#t.K.T.W.W.d#V.7.1.#.1.1bkbkbkbkbk.1.5.5.7.i#0#0.R.v.j.v.v.H.v",
".K#l.K#Y.K#Y.o#Y#0#E.v.hbeaaa6a6a6.t.taS#G#G#x#xaj.JbOaj.fa2.e#.aiaiaiaiazaz#K.o#3.#bk.#.#.ybk.y.ybk.#.1.1.5.z.c.m.R#0#0.v.v.v.v",
".K#l.K.K#l.o#Y.oaBal.Za0aH#Baka6a6a6a6aS#xbqbqa0#D.J.J#W.u.H#Y.p.taib3bz.f.D#Y.W.#bkbk#c#c.ybLbL.y.y.1.#.1.1.l.z.c.L.v#d.v.v#M.H",
".K.K#l.o.K#Y.o.o.Lalalala0bKaaa6a6a6a6.t#xblalb0aRbObralala0bKakaiaUa8#wbq.Z.ZaD.##c#c#c.ybLbLbLbL.ybk.#.1.1.5.7.c.c.m.v.v.v.H.v",
"#l.K.K#l.o.K#Y.obmalalalal.a#Gakakaka6a6.E#M..bNbObO#m..a0.vb3#.aUa8.L.Z..al#Q.qbk#c.y.y#e#U#UbLbL.ybI#c.1.#.1.l.z.8.8.H.v.v#M.H",
".K.K.K.K.o#Y.o.o#Malalalala0.D#Kaka6aka6aSbKal.O.baRalalbJaU#.aebe#Fal..bD#Q#L#Z#z#c#cbP#R#U#U#UbL#ebIbI#Z.1b5.5.z.8.8.N#M.H.v.H",
".K.K#l.K#l.o.o.o.Aa1.Xalal.Z#0aeakakakakak#P#WaRbObral.aa2bFae#l#Oal#N#A.7#6b5#6.##c#e#e#e#U#U#U#e.ybPbI#y.#b5.l.z.c.8.N#W.v#d.H",
".K.K.K.o.K.o.o#Y.o.o#n.Oalal.g#lakakakakak.EbQbObO.b#F#Gb3ae.K.u..#N.c.z.7#6.q#Z#z#cbP#e#U#e#e#e#R#e#c#y.#.1.1.l.z.c.8.8#N.H#M.H",
".K.K.K.K.o.K.o.o.o#n#n#nbmala0.haeaSakakakak.Dbt.J.O#YaSaT#l.X..#N.8#A.z#L#6#3#3#ybIbP#R#e#e#e#ebP#RbI#z#y#y.q.7.c.8.8.N#N#W.vbd",
".K.K.K.K.K.o.o.o.o.o#n#n.oalal.a.faSaSaSakaSaTaj#D.o#KaTbK.X...r#N.8#A.c.7#L#6b5aN#y.PbP#R#RbP#R#R.P#y#Z#6.q#6.7#A.c.8.8.r.Ib..H",
"bW.K.K.K.o.K#Y.o.obw.S.o#n#mal.g.DaaaSaSaSaS#KbQbKawaebK.X..#u.N#N.8.c.c#T#L#6#3#Z#3aN.P.PbPaN.P#zaN#Z#Z#L#6#L.7.8.8.8.N#NaAb.bd",
".KbW.K.K#2.K.o.o.o.o#n#n#IbMal.Z.R#PaSaSaSaSaSa8aaaebQbq..a5.r#N#N.N#A#A.7#T.MaD#Z#3aN#y.P.PaNaN#y.M#3#Z#T#6.7#A.c.c.8#N.raA.G.v",
"bW.K.K#2.K.o#2#2.o.o.o.o#n#nalal.u.D#K#KaS#KaS#K.EbH.u...na5aA#N.N#N.c.9#A#1#T#Tbi.M#3.Q#y#y#y.M#y#3.M#LaP#L.7#A.N.N.8.N.raA#rb.",
".KbW.K.K.K#2.K.o.o.o.S.o#I.o.Wala0.4a2#K#K#KaS#K#B#Oal.Wbma5aA.r#N#N.8.8aP#1#1.U.MaD.M.Q#Z#Z.Q.Ubi#L#L#T.c#T.z.8.N.8.N.N.r#ubqbd",
"bW.KbW.K#2.K.o#2.o.S.o.S.o.S.Oalal.H.D#K#K#K#K#K#P#Fbm.bapa5#u.r#N#N.8.8.caP#1aP#TaDaD#3#3#3.MaDbi#1#T#1.9.z.c.8#N.N#N.raA#u.nb.",
"bWbW.KbW.K#2.K#2.o.K.o.o.o#I.obNal#g#lbB#K#K#K#K.EbQaR#Ibma5#u.r.r#N.N.N#7aPaP.9.U#TaD#T#L.M#LaP#T#1#T.9.c#A.c.8.N.N#NaA#ua5b0bd",
"bWbWbW.K.K.K#2.K#2#2.o.S.o.o.S.Wal#g#laWbBbBbBbB#K#x.T#I.Wa5#uaA.r.r#N.8.N.c.9.9aP#1aPaD#T#1.U#7#TaPaP.N.8.9.8.N.r.r.r.r#ua5bqb.",
"bWbWbWbW#2#2.K#2#2.o#2.o.o.o.o.Sbl.Rae.EbBbB#KbBbBav#0#naja5#u#uaA.raA.NbA.N.9#7.9aPaP#1#1#1#7aPaP.c#7#N.c.8.N#N.r.r.raA#u..#r#o",
"#jbWbWbWbWbW#2#2#2#2#2bf.obf.o.AbQaT.E.f.fbBbBbBbBbB.h#h#Ha5a5#uaAaAaA#N#N.N#7.c#Q.9#7.9aP.9#7.c.9.9.8.r.8.N#N.r.raAaAa5a5..#E#o",
"bWbWbWbWbWbW#2bW#2#2#2.obf.obM.R#PaW.f.jbQbBaWbBbBaW.f#0.o#5a5#u#uaA#u.r.rbA#N#Q#Q#7#Q.9#7.9#N.9.8.N#N.r.N#N.r.raAaA#ua5....bJbV",
"bK#j#jbWbW#2bWbW#2#2#2bW#2aX.R#BaW#B.a.g#XaTbBaWaWaW#C#0aXbN..#u#u#u#uaA.raAbA.N#N#Q.N#Q.8#Q#N#7#NbA#N.r#N#NaA#u#u#ua5.....XbJ#o",
"#j#j#jbW#jbWbWbW#2bW#2#2aX.v.faW#BbJ.Z.Z.v#laWaWaWaWaW#l.W.A..a5#uaA#uaAaAaA.rbA.rbA.rbA#NbA#N#N.r.r.raA.raA#u#u#ua5......b6bVbJ",
"#j#j#j#jbWbWbWbWbWbWbWbH.v.faWav.R.Zalal#E.havaWaWaWaW#P.v#2.n..#u#u#u#uaAaAbDaA.raA.r.r.raAbA.raAaAaA#u#u#u#ua5a5......#5bJbVbV",
"#j#j#j#j#jbWbWbW#2bWbH.v#xaZ#P.Rbl.I#rala0.R.faWaZaZ#C#C.R.A.A....a5#u#uafas.2aQbnaubD.rafa##9bDaAaA#u#u#ua5a5a5a5......aJbJbVbJ",
"#j#w#j#j#j#j#j#jbc#w#0#xaZ.p.hbqbR.A.Aal.ZaH.RaZaZ.EaZ#C#x#MbWb4..a5a5#qayahaEaEaQaEaubEa.adaQab#u#ua5a5#ua5a5........bq.LbVbVbV",
"#jbb#j#w#jbH#jbW#w#0#xaZbv.K.u...Tbc#2#5.Z.g.4#P#CaZ#C#CaT.v#wbc#r..afb2a.#sbCbCbC#fbZ.3a.a.#say#9a5a5a5a5a5..a5.....Z#ibVbJbVbJ",
"bbbT#jbT#j#jbcbT.v#xaZav#x.aalb4bWbWaX#oala0.jbK#C#C#C#C.pbQ#MbW.Aa0a7bC#s.0.wbhbxaObsbgbhbxbxaO#qa5a5..a5........#5aKbJbVbV#i#i",
"bb#jbb#jbb#wbT.j#xaZaZ#xaH.ZaB#jbWbcbW.Aalal.u.4#P#C.p#C.p#BaH#jbcbcbYbCbC.3aLbKbyaLbRbd.wag.3bf.na5.............ZaK#obVbJbJ#ibJ",
"bbbQbbbT#jbU.jbebvaZbe.vblb6#wbcbc#jbc#j.Gal.g.R#x#C.p.p.p.p.R#M#jbf.0bCbx.Y#W.ubq#5al#g.aaLb4aoa5..........bj#qbsb4bVbV#i#i#i#i",
"#b#b.R#0.v.ja8bvaZav.4.ubRb##j#j#w#jbc#j#Mal#g.j.D.p.p.p.p.p.fb..Sa3#fbx#S#4ababbZacb1bnaQaQaEat.........s#p#vadaQaE#p#p#pb1as#i",
"b..4bK.DbeavaZaZbvbv#X#X.4bQ#0#b#j#wbU.v.R.R.R.h#P.p.p.p.paT.p#Y.vbg###J.BaQadadabaEadaQaEa.boap......a#a.ad#va.#s#saEadadadb1.G",
"b..4bzbza8.w.w.w.w#P#Pav.w#l.HbT#w#jb6.j#xbz#PaT.p.p.pavae.paTaT#P.f.Rb#bx#fbx#SaM#J#S#S#S#S#4bN#r#ObsayaE#sana3###S.0ananara7bS",
".uaH.aaH.a.a.a.aaHaHaHaHaHaHaHbTbTbU.g.aaH.HaHaHaHaHaHaHaH.H.H.v#Mb..vaqa4#2bHbW.Y.AbWbY#Sb2aIbGbd#o.Y#sah#Sa3b4bwbh#SanbfbT#H#a",
"b6alalalalalalalalalalalalal#Fbbbb#Malalal.Zal.Zal.Z.Zal.Z.Z.Zbl.G#h.SbpaM.G.u.ubq#Wa4#S#Sanaq#ibdbGaObC#San#H#Wa3bxananaVbq#g.G",
"aC#i#O#E#OaJ#O#FaJ#F#FaJ#O.G#dbTbTbd#r#r#rbq#r.Xbq.X.XbR.X.Xb0.X.AbY#f#S.YbGaK#F#FaB#J#f#SbYbs#obd#Wbp#Sb2an#H#q#Sa.#SbY#HbSb6aK",
"#b#b#b#bbb#b#b#bbQ#b#b#bbb#b#bbTbb#b#b#b#b#b#b#b#b#b#b#b#b#bbUbU.SbY#S#Sa7b4#daF#dbXbY#S#S.3aG#o#obRbwbab2ana7axaha.anaMbXbSaKaJ",
"aC.4aCbbaC#b#bbb#b#bbb#b#b#bbb#b#b#b#bbT#b#bbT#bb##bbU#bbUbUbU#d#I.0#SanaV#o#daL#o.Aan#S#SaMap#obV.X#oa9.0anayadaEaY#J#H#raJaKaK",
"#baC#baC.4aC#baC#b#b#b#b#b#b#b#b#b#b#b#b#b#b#b#b#bbUbUbU#d#b#daLa4.0#SbY#HbdbdaF#o.S.0#SanaIbGbVbVb6#g.va9an.0#Sb2a3.A.GbSaKaJbS",
"aCaCaCaCaCaC#baC.4aC#baC#b#baC#b#b#b#b#bbU#b#dbU#daCbUaCbU#d#daLbpag#SaO#qaFaLbdaK.Y.0.0anaV#kat#4#ibqaoanahbY#hb#.L#rb6aJ#aaJaJ",
"aC#b#b#b#baC#baCaCaC#baCaC#b#baCaC#daC#d#b#d#b#d#b#d#d#d#d#d#0bU.3.0#SbpaGbdbdbd.G##.0.0bYbZ.2aQac#iaobZ#S#fan#say#pa##iaKaJbSaJ",
"aCaCaCaCaC#baCaCaCaCaC#baCaCaC#b#d#b#b#daCbU#d#d#d#d#d#0#d#d#db##J#S.0.Y#kbdbdbd.Ga4.0an.0aEaQ.Bbtat.BaQaEananan#SbCa.axbXbSaJbS",
"aCaCaCaCaCaCaCaC#baCaCaCaCaC#daC#daC#d#daC#d#d#d#d#d#d#d#daLaFbfbYbaan#IbGbdbdbdb6bTbu.0anan.3bgaqaY#vahanbga4#JanbYb2ayboaKbSbS",
"aCaCaCaCaCaCaCaCaCaCaCaCaC#d.R#daC#daC#d#d#d#d#d#d#daF#dbdaFbdbgan.0.3bs#ibdbdbV#i.u.R#jbHbT#M#Oao#f#sbY#Ib4b.bTbg#JbYbY.VbsbS.6",
"aCaCaCaCaCaCaCaCaCaC#daC#daC#d#d#d#d#0#d#d#d#d#d#dbd#d#h#p#pa7#J.0.0#IbGbdbVbVbVbVbSbq.u.ub6b6bq.S.0.0bYaI#Wbl.ubJ.D.0bY.3bs.6bS",
"aCaFaCaFaCaFaFaCaFaC#daC#daFaCaFaC#daFaF#daF#daFaFaFaLaOahadad#S.0##.AaKbVbdbVbV#ibVbV#i#i#i#i#8b#buanbY.Vbo.Fab#pa.aybYaIbGbS.6",
"aCaFaCaFaCaFaCaFaCaFaCaFaFaCaFaFaFaFaF#daFaFbdaFbdaF#obp#S#f#say#J#hbS#ibVbVbVbV#i#i#i#i#iaK#ib6#ObebabYanayaEadad#vaYbpaG#8bS.6",
"aCaFaFaFaFaCaFaCaFaFaFaCaFaFaFaFaFaFaFaFaFaFbdaFbdaFbV.Kag.0babp.A.GaKbd#ibd#i#i#i#i#i#i#iaK#iaJblbV.DbpbYbYb2#SaYbYbgaL#W.6.6.6",
"aFaFaCaFaFaFaFaFaCaFaFaFaFaFaFaFaFaFaFbdaFbdaFbdbdbdbdaH#jbw#2aL.uaKbV#ibV#i#ibV#i#i#iaK#iaJaKaJaJbl.a#dbT#2bg.Sbc#M.Gb6.6.6.6.6",
"aFaFaFaFaCaFaFaFaFaFaFaFaFaFaFaFaFbdaFbdaFbdaFbdaFbVbd#i#E#E.ub6#i#ibVbV#i#i#i#i#i#i#iaJ#iaJaKaJaKaJ#8bq.u#F#O.u.u#8#8.6.6.6.6.6"
};

/* now reduced colors (notice that some match the predefined brown3, brown4, red4, etc */

char * fig_reduced_c_icon_X[] = {
/* width height num_colors chars_per_pixel */
"    64    64       32            1",
/* colors */
". c #000000", "# c #009000", "a c #925132", "b c #bb8863", "c c #145812", "d c #fbc88b",
"e c #bc8059", "f c #000000", "g c #9e5834", "h c #47511c", "i c #ed9967", "j c #000000",
"k c #b17859", "l c #000000", "m c #84767c", "n c #fbf7b0", "o c #748634", "p c #00b000",
"q c #a05853", "r c #ffe0e0", "s c #bc7852", "t c #b09ea8", "u c #000000", "v c #b27052",
"w c #ffc0c0", "x c #aa8784", "y c #900000", "z c #d5babe", "A c #803000", "B c #bd704a",
"C c #ffffff", "D c #a04000",
/* pixels */
"BgBBBBBBBBBBBBBBsBssssssssssssBsBBBBBBBBBBgggggggggggggggggagaga",
"BBBBBBBBBBBBBsBsBssBsBsssssssssBssBBBBvBBBBBggggggggggggggggggaa",
"BBBBBBBBBBBBBsBssssssssssssssssssBssBo##gBBBgggggggggggggggggaag",
"gBBBBBBBBBBsBssssssssesessesesssssssgc##cBBBBgggggggggggggaggaaa",
"BBBBBBBBBBsBsssssseseseseesesesessssglc#chBBBBggggggggggggagggaa",
"BBBBBBBBBsBsssssseseseeeeeeeeeesessssql#ccaBBgBgggggggggggaagaaa",
"BBBBBBBBsBssssseseseeeeeeeeeeeseesessvlccclaBBBgggggggggggggagaa",
"BBBBBBBsBssssssseeeeeeeeeeeeeeeeeeesevlccccchBBgBggggggggaaagaaa",
"BBBBBBBsssssseeeeeeeeeebeeebeeeeeesesqlcc##cccaggggggggggggaaaaa",
"BBBBBsBsBssseseseeeeebebebbebebeeeeekulcccc###caBgggggggggagaaaa",
"BBBBsvsvssssesekekbbbebbbbebbbebeeeevlcccc####ccaggggggggagaaaaa",
"BvBvBBssssksekeeebekbbbbbbbbbbbebbekalclccc##ccccgqggggggagagaaa",
"BvBBkBkskseekeekbebbbbbbbbbbbbbbkbkklllcccccccccccaggggaggaaaaaa",
"vBvBsvssssksekeebbkbbbbbbbbbbbbbbeballccccccccc#ccchgqggggagaaaa",
"BBvBvskskakeeBvvvkkvvkkkkbbbbbbbbbkjlccccc#########ccagggaaaaaaa",
"vBvBkBksvBbidddddddddddiabbksbbbbbvaaaahc############chaagagaaaa",
"vBvsvsksauageddddnndbbeeabbaeiddnnnndddk#####p#pp#####ccagaaaaaa",
"vBvvBksku.ffabddddddefffkbbufasinndiessa###ppppppp####cccaayaaaa",
"vvBkvskka...fBdddddnef.fkby..fBdniiqfffc#ppppppppp#####cccaaaaaa",
"BvvBkvska....abdddddda.ubbu.faddiiaf..l##ppppppppp#p###ccllaaaaa",
"vvvvkskka....fsddddddB.vbk..aidieu...lc##pp#pppppp######clllaaaa",
"vvBvBkkkqjf..faidddddiukby.aidiBu.lcc####ppppppppp#####ccclluaya",
"vvvkvkkskkkv..fBddddddgbbbubdivf.lccc####p#pppppppp####ccclllaaa",
"vvvvkvkkkkkka.fgidddddsmbvsdiBf.llccc######ppppp#p#####cclllluaA",
"vvvvvkkkkkkkk..aedddddiakkdiBf.lllcccc######pp#pp######ccclllfaa",
"vvvvkvskkekkku.fsddddddgBdiBf..lllcccc##############c#ccllllllaA",
"vvvvkvkkkkkkbq.fgidddddidigf..llllcccccc#########c##c#ccccllllua",
"vvvkvkkkkkkkkk..fsdddddddvf.j.llllcccccc#c#####c##ccccccllllllja",
"vvvvvkvkkkkkbka.fgidddddbu.aa.llllllccccccc####c#ccccccllllll.fA",
"vvvvkvkkkkkkkkv..asdddddiuabu..lllllccccccc###cc#ccccccllllll.ja",
"vvvvvkvkkvkkkbku.fBddddddgkba..llllllcccccccccccccccccclllll..fA",
"vvvvvvkvkkkkkkka.fBddddddeaba..llllllcccccccccclcccllcllllll..fa",
"vvvvkkvkkkkkkkkkfgiddddddiaka...llllllclcccccclcccllclllllll..jA",
"vvvvvvkkkkkkkkkqgideedddddgqm...lllllllclclccclccclllllllll...uA",
"vvvvvvkvkkkkkkqgideggdddddeakf...l.llllllllclclcllllllllll....aA",
"BvvvvkvvkkkvkvgbdbafBiddddiavu.....llllllllllllllllllll......faA",
"vvvvvvvvkvkkvaedbaffaBdddddBaq...l.lllllllllllllllllll.......uAa",
"vvvvvvvvvvvvaedigf..ugiddddiakj.....ll.llllllllllll.........faAA",
"vvvvvvvvkvvaeiigffj.fgediiiigqq.....utrCrm.luxm.ll..........uaAa",
"vqvvvvvvvqaeiigffqq.fagiidiieava...mrrrrCrmmrCCt...........faAAA",
"vqvqvvvvqaeiivf.avkfffgiiiiiiaqvj.uwrrrrrztwrrrrm.........fuAaAa",
"qqvqvvvqaeiiea.avvvA.fgBiiiiigavqfxrrwidrwmbdrrwm........fuaAAuu",
"qvqvqqqgeiieafuvvvvq..fgiiiiibavvvwrrwyBeyfAiwwkj.......fuAAaaua",
"qgqqvygeiieafuqvvvvvu.fgeiiiiigavkwrrxufff.fayay......jmmaAAuuuu",
"qqgaagiiiigffyvvqvvva.fgsiiiiieakxzrwxttttzrCCrx....mzCCCrzzzztu",
"agBseiiiiiBBggaqvqyaggggiiiiiiisabbwrCCCtrCCrrzu...xrCCrrrrCCCzu",
"agiiiiiiiiiiiBaqqvugeiiiiiiiiiiiiegyrzrwxwwwwwxujumrrrwxbwwwwwxu",
"faaaaaaaaaaaaaaqqyfaaaaaaaaaaaaaaaaxbkvvxqvwwwxuAAxrrwxaedwwkqmu",
"u.............uqqa...f.f.ff.ffffuqkwxufffubwwwxuAuwrwwmuxrwwxffu",
"DuuuuuuuuuuuuuyqqAjjjfjfffffffffqwzwxuuuuuwzwwmAAuwwwwmmwrwwmuuu",
"qqqqqqqqgqqqqqqqqqqqqqqqqqqqqqyykwwwxayAyAwwwwyAAfewwwxzrrwxAuuu",
"DgDqDqqqqqqqqqqqqqqqqqqqyqyqyyyybwwwxAyyAqwwwxuAAfAiwwrCrzwmjuuu",
"qDqDgDqDqqqqqqqqqqqqqqqqqyyyyqyybwwwmAAAAkwwwxuAAufaiwwwwxquuuuu",
"DDDDDDqDgDqDqqDqqqqqyqyyyDyDyyyywwwwmAyAuxwwwxAxxufywrwqyajuuuuu",
"DqqqqDqDDDqDDqqDDyDyqyqyqyyyyyaywwwwyAAAubwwwtrCtuytwzwrrzxuuuuu",
"DDDDDqDDDDDqDDDqyqqyDyyyyyyayyyywwwxAAAAubwwwrCrmxrCrwwwwrrzAuuu",
"DDDDDDDDqDDDDDyDyDyyDyyyyyyyyyAkwwwbuAAAuqwwwwwbxzCrwbbwwwwrzuuu",
"DDDDDDDDDDDDDygyDyDyyyyyyyAyAAAbwwwmuAAAufgvvqauyzrwbaaqbwwwwmuu",
"DDDDDDDDDDyDyDyyyyayyyyyyAyqzzxwwwbuAAAAAufffuufkwwwxuffaswwwmuu",
"DADADAADADyDyADADyAAyAyAAAywrCCwwbquAAAAuAAuuuuuywwwwzttzrrwxuuu",
"DADADADADADAADAAAAAyAAAAAAAwwzrrwquuAAAAuuuuuuuuuewwwrrCCCzwyuuu",
"DAAAADADAAADAAAAAAAAAAAAAAAvwwwwquuAuAuuuuuuuuuufAswwwwwzwbyuuuu",
"AADAAAAADAAAAAAAAAAAAAAAAAAavekyfuAuAuuAuuuuuuuuufayqkbkvauuuuuu",
"AAAADAAAAAAAAAAAAAAAAAAAAAAuuufuuuAAuuuuuuuuuuuuuuuffuuffuuuuuuu"
};

#endif /* USE_XPM_ICON */

/* bitmap of letters for splash screen ("3.2.X") */

#define letters_width 231
#define letters_height 76
static char letters_bits[] = {
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x15,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x40,0x05,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf8,0x0f,0x00,0x00,0x00,
 0xfc,0xff,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xff,0xff,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfc,0x0f,0x00,0x00,0x00,0xff,
 0xff,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xe0,0xff,0xff,0x07,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xff,0x0f,0x00,0x00,0xe0,0xff,0xff,
 0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf8,0xff,0xff,0x1f,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xff,0x07,0x00,0x00,0xf8,0xff,0xff,0xff,
 0x01,0x00,0x00,0x00,0x00,0x00,0x00,0xfe,0xff,0xff,0x7f,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x80,0xff,0x07,0x00,0x00,0xfc,0xbf,0xfe,0xff,0x07,
 0x00,0x00,0x00,0x00,0x00,0x80,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0xc0,0xff,0x07,0x00,0x00,0xfe,0x07,0xf0,0xff,0x0f,0x00,
 0x00,0x00,0x00,0x00,0xc0,0xff,0xf5,0xff,0xff,0x01,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0xe0,0xff,0x07,0x00,0x00,0xff,0x01,0xc0,0xff,0x1f,0x00,0x00,
 0x00,0x00,0x00,0xe0,0x3f,0x80,0xff,0xff,0x03,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0xf0,0xff,0x03,0x00,0x80,0x7f,0x00,0xc0,0xff,0x1f,0x00,0x00,0x00,
 0x00,0x00,0xf0,0x07,0x00,0xfe,0xff,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0xf8,0xff,0x03,0x00,0xc0,0x7f,0x00,0x80,0xff,0x3f,0x00,0x00,0x00,0x00,
 0x00,0xf8,0x03,0x00,0xf8,0xff,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0xfc,0xff,0x03,0x00,0xe0,0x7f,0x00,0x00,0xff,0x7f,0x00,0x00,0x00,0x00,0x00,
 0xf8,0x01,0x00,0xf0,0xff,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfe,
 0xff,0x03,0x00,0xe0,0xff,0x01,0x00,0xfe,0x7f,0x00,0x00,0x00,0x00,0x00,0xfc,
 0x01,0x00,0xf0,0xff,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xff,0xff,
 0x01,0x00,0xe0,0xff,0x01,0x00,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0xfe,0x00,
 0x00,0xe0,0xff,0x1f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0xff,0xff,0x01,
 0x00,0xf0,0xff,0x07,0x00,0xfe,0x7f,0x00,0x00,0x00,0x00,0x00,0xfe,0x00,0x00,
 0xe0,0xff,0x1f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0xff,0xff,0x01,0x00,
 0xf0,0xff,0x07,0x00,0xfe,0xff,0x00,0x00,0x00,0x00,0x00,0xff,0x00,0x00,0xc0,
 0xff,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xe0,0xff,0xff,0x01,0x00,0xf0,
 0xff,0x0f,0x00,0xfe,0xff,0x00,0x00,0x00,0x00,0x00,0xff,0x01,0x00,0xc0,0xff,
 0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf0,0xff,0xff,0x00,0x00,0xf0,0xff,
 0x0f,0x00,0xfe,0xff,0x00,0x00,0x00,0x00,0x00,0xff,0x07,0x00,0xc0,0xff,0x3f,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf8,0xff,0xff,0x00,0x00,0xf0,0xff,0x0f,
 0x00,0xfe,0xff,0x00,0x00,0x00,0x00,0x80,0xff,0x1f,0x00,0xc0,0xff,0x3f,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0xfc,0xff,0xff,0x00,0x00,0xf0,0xff,0x0f,0x00,
 0xfe,0xff,0x00,0x00,0x00,0x00,0x80,0xff,0x3f,0x00,0xc0,0xff,0x3f,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0xfe,0xff,0x7f,0x00,0x00,0xe0,0xff,0x0f,0x00,0xff,
 0xff,0x00,0x00,0x00,0x00,0x80,0xff,0x7f,0x00,0xc0,0xff,0x3f,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0xff,0xff,0x7f,0x00,0x00,0xe0,0xff,0x0f,0x00,0xff,0x7f,
 0x00,0x00,0x00,0x00,0x80,0xff,0xff,0x00,0xe0,0xff,0x3f,0x00,0x00,0x00,0x00,
 0x00,0x00,0x80,0x3f,0xff,0x7f,0x00,0x00,0xe0,0xff,0x07,0x00,0xff,0x7f,0x00,
 0x00,0x00,0x00,0x80,0xff,0xff,0x01,0xc0,0xff,0x3f,0x00,0x00,0x00,0x00,0x00,
 0x00,0xc0,0x3f,0xff,0x7f,0x00,0x00,0x80,0xff,0x03,0x00,0xff,0x7f,0x00,0x00,
 0x00,0x00,0x80,0xff,0xff,0x01,0xe0,0xff,0x1f,0x00,0x00,0x00,0x00,0x00,0x00,
 0xe0,0x9f,0xff,0x3f,0x00,0x00,0x80,0xff,0x01,0x80,0xff,0x3f,0x00,0x00,0x00,
 0x00,0x80,0xff,0xff,0x01,0xe0,0xff,0x1f,0x00,0x00,0x00,0x00,0x00,0x00,0xf0,
 0x8f,0xff,0x3f,0x00,0x00,0x00,0x7c,0x00,0xc0,0xff,0x3f,0x00,0x00,0x00,0x00,
 0x00,0xff,0xff,0x01,0xf0,0xff,0x1f,0x00,0x00,0x00,0x00,0x00,0x00,0xf8,0x83,
 0xff,0x3f,0x00,0x00,0x00,0x00,0x00,0xc0,0xff,0x1f,0x00,0x00,0x00,0x00,0x80,
 0xff,0xff,0x01,0xf0,0xff,0x1f,0x00,0x00,0x00,0x00,0x00,0x00,0xfc,0x83,0xff,
 0x3f,0x00,0x00,0x00,0x00,0x00,0xe0,0xff,0x0f,0x00,0x00,0x00,0x00,0x00,0xff,
 0xff,0x01,0xf0,0xff,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0xfe,0xc1,0xff,0x1f,
 0x00,0x00,0x00,0x00,0x00,0xf0,0xff,0x0f,0x00,0x00,0x00,0x00,0x00,0xfe,0xff,
 0x00,0xf8,0xff,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0xff,0xc0,0xff,0x1f,0x00,
 0x00,0x00,0x00,0x00,0xf0,0xff,0x03,0x00,0x00,0x00,0x00,0x00,0xfe,0xff,0x00,
 0xfc,0xff,0x07,0x00,0x00,0x00,0x00,0x00,0x80,0x3f,0xc0,0xff,0x1f,0x00,0x00,
 0x00,0x00,0x00,0xfc,0xff,0x03,0x00,0x00,0x00,0x00,0x00,0xfc,0x7f,0x00,0xfc,
 0xff,0x03,0x00,0x00,0x00,0x00,0x00,0xc0,0x3f,0xe0,0xff,0x1f,0x00,0x00,0x00,
 0x00,0x00,0xfe,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0xf8,0x7f,0x00,0xfe,0xff,
 0x03,0x00,0x00,0x00,0x00,0x00,0xe0,0x1f,0xe0,0xff,0x0f,0x00,0x00,0x00,0xf0,
 0x80,0xff,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0xe0,0x1f,0x00,0xff,0xff,0x01,
 0x00,0x00,0x00,0x00,0x00,0xf0,0x0f,0xe0,0xff,0x0f,0x00,0x00,0x00,0xf0,0xff,
 0xff,0x1f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x80,0xff,0xff,0x00,0x00,
 0x00,0x00,0x00,0x00,0xf8,0x07,0xe0,0xff,0x0f,0x00,0x00,0x00,0xf8,0xff,0xff,
 0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0xff,0x7f,0x00,0x00,0x00,
 0x00,0x00,0x00,0xfc,0x03,0xf0,0xff,0x0f,0x00,0x00,0x00,0xf8,0xff,0x5f,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xe0,0xff,0x7f,0x00,0x00,0x00,0x00,
 0x00,0x00,0xfe,0x01,0xf0,0xff,0x07,0x00,0x00,0x00,0xf8,0xff,0x3f,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xe0,0xff,0x1f,0x00,0x00,0x00,0x00,0x00,
 0x00,0xff,0x00,0xf0,0xff,0x07,0x00,0x00,0x00,0xf8,0xff,0xff,0x03,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0xf0,0xff,0x0f,0x00,0x00,0x00,0x00,0x00,0x80,
 0x7f,0x00,0xf0,0xff,0x07,0x00,0x00,0x00,0xf0,0xc1,0xff,0x0f,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0xf8,0xff,0x07,0x00,0x00,0x00,0x00,0x00,0xc0,0x3f,
 0x00,0xf8,0xff,0x03,0x00,0x00,0x00,0x00,0x00,0xff,0x3f,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0xfc,0xff,0x03,0x00,0x00,0x00,0x00,0x00,0xe0,0x0f,0x00,
 0xf8,0xff,0x03,0x00,0x00,0x00,0x00,0x00,0xfe,0x3f,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0xfe,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0xf0,0x0f,0x00,0xf8,
 0xff,0x03,0x00,0x00,0x00,0x00,0x00,0xfc,0xff,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x80,0xff,0x7f,0x00,0x00,0x00,0x00,0x00,0x00,0xf8,0x07,0x00,0xfc,0xff,
 0x03,0x00,0x00,0x00,0x00,0x00,0xfc,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x80,0xff,0x1f,0x00,0x00,0x00,0x00,0x00,0x00,0xfc,0x03,0x00,0xfc,0xff,0x01,
 0x00,0x00,0x00,0x00,0x00,0xf8,0xff,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0xe0,
 0xff,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0xfe,0x01,0x00,0xfc,0xff,0x01,0x00,
 0x00,0x00,0x00,0x00,0xfc,0xff,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0xe0,0xff,
 0x03,0x00,0x00,0x00,0x00,0x00,0x00,0xff,0x00,0x00,0xfc,0xff,0x01,0x00,0x00,
 0x00,0x00,0x00,0xf8,0xff,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0xf8,0xff,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x7f,0x00,0x00,0xfe,0xff,0x01,0x00,0x00,0x00,
 0x00,0x00,0xf8,0xff,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0xfc,0x7f,0x00,0x00,
 0x00,0x00,0x00,0x00,0xc0,0x3f,0x00,0x00,0xfe,0xff,0x00,0x00,0x00,0x1f,0x00,
 0x00,0xf8,0xff,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0xfe,0x1f,0x00,0x40,0x00,
 0x00,0x00,0x00,0xe0,0xff,0xff,0xff,0xff,0xff,0xff,0x07,0xc0,0xff,0x00,0x00,
 0xf8,0xff,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0xff,0x0f,0x00,0xe0,0x03,0x00,
 0x00,0x00,0xe0,0xff,0xff,0xff,0xff,0xff,0xff,0x0f,0xe0,0xff,0x00,0x00,0xf8,
 0xff,0x07,0x00,0x00,0x00,0x00,0x00,0x80,0xff,0x03,0x00,0xf0,0x03,0x00,0x00,
 0x00,0xe0,0xff,0xff,0xff,0xff,0xff,0xff,0x07,0xf0,0xff,0x03,0x00,0xf8,0xff,
 0x07,0x00,0x00,0x00,0x00,0x00,0xe0,0xff,0x00,0x00,0xf0,0x01,0x00,0x00,0x00,
 0xe0,0xff,0xff,0xff,0xff,0xff,0xff,0x07,0xf8,0xff,0x03,0x00,0xf8,0xff,0x07,
 0x00,0x00,0x00,0x00,0x00,0xe0,0x3f,0x00,0x00,0xf0,0x01,0x00,0x00,0x00,0xe0,
 0xff,0xff,0xff,0xff,0xff,0xff,0x07,0xf8,0xff,0x03,0x00,0xfc,0xff,0x07,0x00,
 0x00,0x00,0x00,0x00,0xf8,0x1f,0x00,0x00,0xf8,0x01,0x00,0x00,0x00,0xf0,0xff,
 0xff,0xff,0xff,0xff,0xff,0x03,0xfc,0xff,0x07,0x00,0xfc,0xff,0x07,0x00,0x00,
 0x00,0x00,0x00,0xfc,0x07,0x00,0x00,0xfc,0x00,0x00,0x00,0x00,0xe0,0xff,0xff,
 0xff,0xff,0xff,0xff,0x07,0xfc,0xff,0x07,0x00,0xfc,0xff,0x07,0x00,0x00,0x00,
 0x00,0x00,0xfe,0x01,0x00,0x00,0xfe,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,
 0xff,0x3f,0x00,0x00,0xfc,0xff,0x03,0x00,0xfc,0xff,0x03,0x00,0x00,0x00,0x00,
 0x00,0xff,0x00,0x00,0x00,0xfe,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0xff,
 0x3f,0x00,0x00,0xfc,0xff,0x07,0x00,0xfe,0xff,0x03,0x00,0x7c,0x00,0x00,0x80,
 0x3f,0x00,0x00,0x80,0x7f,0x00,0x00,0x1f,0x00,0x00,0x00,0x00,0xc0,0xff,0x3f,
 0x00,0x00,0xfc,0xff,0x03,0x00,0xfe,0xff,0x03,0x00,0xff,0x03,0x00,0xc0,0x1f,
 0x00,0x00,0xc0,0x7f,0x00,0xc0,0xff,0x00,0x00,0x00,0x00,0xc0,0xff,0x1f,0x00,
 0x00,0xfc,0xff,0x03,0x00,0xfe,0xff,0x03,0x80,0xff,0x07,0x00,0xe0,0xff,0xff,
 0xff,0xff,0x3f,0x00,0xe0,0xff,0x01,0x00,0x00,0x00,0xc0,0xff,0x1f,0x00,0x00,
 0xfc,0xff,0x01,0x00,0xff,0xff,0x01,0xc0,0xff,0x0f,0x00,0xf0,0xff,0xff,0xff,
 0xff,0x3f,0x00,0xf0,0xff,0x03,0x00,0x00,0x00,0xc0,0xff,0x1f,0x00,0x00,0xf8,
 0xff,0x00,0x00,0xff,0xff,0x01,0xe0,0xff,0x0f,0x00,0xf8,0xff,0xff,0xff,0xff,
 0x3f,0x00,0xf8,0xff,0x03,0x00,0x00,0x00,0xe0,0xff,0x0f,0x00,0x00,0xfc,0x3f,
 0x00,0x80,0xff,0xff,0x00,0xe0,0xff,0x1f,0x00,0xfc,0xff,0xff,0xff,0xff,0x1f,
 0x00,0xf8,0xff,0x07,0x00,0x00,0x00,0xe0,0xff,0x1f,0x00,0x00,0xf8,0x0f,0x00,
 0x80,0xff,0x7f,0x00,0xf0,0xff,0x1f,0x00,0xfe,0xff,0xff,0xff,0xff,0x1f,0x00,
 0xfc,0xff,0x07,0x00,0x00,0x00,0xe0,0xff,0x0f,0x00,0x00,0xf8,0x0f,0x00,0xc0,
 0xff,0x7f,0x00,0xe0,0xff,0x3f,0x00,0xff,0xff,0xff,0xff,0xff,0x1f,0x00,0xf8,
 0xff,0x0f,0x00,0x00,0x00,0xe0,0xff,0x0f,0x00,0x00,0xf0,0x0f,0x00,0xe0,0xff,
 0x3f,0x00,0xf0,0xff,0x1f,0x80,0xff,0xff,0xff,0xff,0xff,0x0f,0x00,0xfc,0xff,
 0x07,0x00,0x00,0x00,0xf0,0xff,0x0f,0x00,0x00,0xf0,0x1f,0x00,0xf0,0xff,0x1f,
 0x00,0xf0,0xff,0x3f,0xc0,0xff,0xff,0xff,0xff,0xff,0x0f,0x00,0xfc,0xff,0x0f,
 0x00,0x00,0x00,0xf8,0xff,0x0f,0x00,0x00,0xe0,0x3f,0x00,0xfc,0xff,0x07,0x00,
 0xf0,0xff,0x1f,0xc0,0xff,0xff,0xff,0xff,0xff,0x0f,0x00,0xfc,0xff,0x07,0x00,
 0x00,0x00,0xff,0xff,0x3f,0x00,0x00,0xc0,0xff,0x00,0xfe,0xff,0x07,0x00,0xe0,
 0xff,0x1f,0xe0,0xff,0xff,0xff,0xff,0xff,0x07,0x00,0xf8,0xff,0x07,0x00,0x00,
 0xfe,0xff,0xff,0xff,0x3f,0x00,0x80,0xff,0xeb,0xff,0xff,0x01,0x00,0xe0,0xff,
 0x1f,0xe0,0xff,0xff,0xff,0xff,0xff,0x07,0x00,0xf8,0xff,0x07,0x00,0x00,0xfc,
 0xff,0xff,0xff,0x1f,0x00,0x00,0xff,0xff,0xff,0x7f,0x00,0x00,0xc0,0xff,0x0f,
 0xf0,0xff,0xff,0xff,0xff,0xff,0x03,0x00,0xf0,0xff,0x03,0x00,0x00,0xfe,0xff,
 0xff,0xff,0x3f,0x00,0x00,0xfc,0xff,0xff,0x1f,0x00,0x00,0xc0,0xff,0x0f,0xf0,
 0xff,0xff,0xff,0xff,0xff,0x03,0x00,0xf0,0xff,0x03,0x00,0x00,0xfe,0xff,0xff,
 0xff,0x1f,0x00,0x00,0xf0,0xff,0xff,0x07,0x00,0x00,0x00,0xff,0x03,0xf0,0xff,
 0xff,0xff,0xff,0xff,0x03,0x00,0xc0,0xff,0x00,0x00,0x00,0xfe,0xff,0xff,0xff,
 0x1f,0x00,0x00,0x80,0xff,0x7f,0x00,0x00,0x00,0x00,0xfe,0x01,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x80,0x7f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0xa0,0x02,0x00,0x00,0x00,0x00,0x28,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x0a,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00};

/* splash background in XPM */

#ifdef USE_XPM

char *spl_bckgnd_xpm[] = {
/* width height ncolors chars_per_pixel */
"630 210 61 1",
/* colors */
"  c #000000", ". c #D6D6FD", "X c #78480C", "o c #AC5CC7", "O c #8484B3", "+ c #E6DAD1", "@ c #9795AB",
"# c #BCBAB8", "$ c #1A2305", "% c #935E33", "& c #EACCC7", "* c #737373", "= c #F4C5B3", "- c #9E8DE6",
"; c #22172A", ": c #FCFCF9", "> c #532404", ", c #E5B29D", "< c #2B0A04", "1 c #DCD3CC", "2 c #918B89",
"3 c #9F88E3", "4 c #9B97EC", "5 c #2A3A09", "6 c #8E50A7", "7 c #A083E0", "8 c #ACACD1", "9 c #653C7B",
"0 c #9C92E9", "q c #D4D3CD", "w c #422E55", "e c #C6957A", "r c #98A1F2", "t c #774A93", "y c #837B70",
"u c #BCAA94", "i c #999CEF", "p c #646154", "a c #A965CD", "s c #A574D6", "d c #AC7155", "f c #5D4E32",
"g c #AA8C77", "h c #453321", "j c #AA60CA", "k c #FCE4C4", "l c #A66FD3", "z c #8F654F", "x c #686899",
"c c #D8BEB1", "v c #A27EDC", "b c #D6CEC9", "n c #CCCDC9", "m c #ECE6E5", "M c #A76AD0", "N c #BDBDE5",
"B c #A379D9", "V c #804C25", "C c #E5D6CD", "Z c #E4BEB5", "A c None",
/* pixels */
".....................................................................................................................................................................................................................................................................................................................................................................................................................................................................................................................................................................................................................................................8",
"N...................................................................................................................................................................................................................................................................................................................................................................................................................................................................................................................................................................................................................................................8O",
"NN.................................................................................................................................................................................................................................................................................................................................................................................................................................................................................................................................................................................................................................................8OO",
"NNN...............................................................................................................................................................................................................................................................................................................................................................................................................................................................................................................................................................................................................................................8OOO",
"NNNN.............................................................................................................................................................................................................................................................................................................................................................................................................................................................................................................................................................................................................................................8OOOO",
"NNNNN...........................................................................................................................................................................................................................................................................................................................................................................................................................................................................................................................................................................................................................................8OOOOO",
"NNNNNN.........................................................................................................................................................................................................................................................................................................................................................................................................................................................................................................................................................................................................................................8OOOOOO",
"NNNNNNN.......................................................................................................................................................................................................................................................................................................................................................................................................................................................................................................................................................................................................................................8OOOOOOO",
"NNNNNNNN.....................................................................................................................................................................................................................................................................................................................................................................................................................................................................................................................................................................................................................................8OOOOOOOO",
"NNNNNNNNN...................................................................................................................................................................................................................................................................................................................................................................................................................................................................................................................................................................................................................................8OOOOOOOOO",
"NNNNNNNNNNrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrriiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiii444444444444444444444444444444444444444440000000000000000000000000000000000000000-----------------------------------------333333333333333333333333333333333333333337777777777777777777777777777777777777777vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBsssssssssssssssssssssssssssssssssssssssslllllllllllllllllllllllllllllllllllllllllMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaajjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjoooooooooooooooooooooooooooooooooooooooooOOOOOOOOOO",
"NNNNNNNNNNrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrriiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiii444444444444444444444444444444444444444440000000000000000000000000000000000000000-----------------------------------------333333333333333333333333333333333333333337777777777777777777777777777777777777777vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBsssssssssssssssssssssssssssssssssssssssslllllllllllllllllllllllllllllllllllllllllMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaajjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjoooooooooooooooooooooooooooooooooooooooooOOOOOOOOOO",
"NNNNNNNNNNrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrriiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiii444444444444444444444444444444444444444440000000000000000000000000000000000000000-----------------------------------------333333333333333333333333333333333333333337777777777777777777777777777777777777777vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBsssssssssssssssssssssssssssssssssssssssslllllllllllllllllllllllllllllllllllllllllMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaajjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjoooooooooooooooooooooooooooooooooooooooooOOOOOOOOOO",
"NNNNNNNNNNrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrriiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiii444444444444444444444444444444444444444440000000000000000000000000000000000000000-----------------------------------------333333333333333333333333333333333333333337777777777777777777777777777777777777777vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBsssssssssssssssssssssssssssssssssssssssslllllllllllllllllllllllllllllllllllllllllMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaajjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjoooooooooooooooooooooooooooooooooooooooooOOOOOOOOOO",
"NNNNNNNNNNrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrriiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiii444444444444444444444444444444444444444440000000000000000000000000000000000000000-----------------------------------------333333333333333333333333333333333333333337777777777777777777777777777777777777777vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBsssssssssssssssssssssssssssssssssssssssslllllllllllllllllllllllllllllllllllllllllMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaajjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjoooooooooooooooooooooooooooooooooooooooooOOOOOOOOOO",
"NNNNNNNNNNrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrriiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiii444444444444444444444444444444444444444440000000000000000000000000000000000000000-----------------------------------------333333333333333333333333333333333333333337777777777777777777777777777777777777777vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBsssssssssssssssssssssssssssssssssssssssslllllllllllllllllllllllllllllllllllllllllMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaajjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjoooooooooooooooooooooooooooooooooooooooooOOOOOOOOOO",
"NNNNNNNNNNrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrriiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiii444444444444444444444444444444444444444440000000000000000000000000000000000000000-----------------------------------------333333333333333333333333333333333333333337777777777777777777777777777777777777777vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBsssssssssssssssssssssssssssssssssssssssslllllllllllllllllllllllllllllllllllllllllMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaajjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjoooooooooooooooooooooooooooooooooooooooooOOOOOOOOOO",
"NNNNNNNNNNrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrriiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiii444444444444444444444444444444444444444440000000000000000000000000000000000000000-----------------------------------------333333333333333333333333333333333333333337777777777777777777777777777777777777777vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBsssssssssssssssssssssssssssssssssssssssslllllllllllllllllllllllllllllllllllllllllMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaajjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjoooooooooooooooooooooooooooooooooooooooooOOOOOOOOOO",
"NNNNNNNNNNrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrriiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiii444444444444444444444444444444444444444440000000000000000000000000000000000000000-----------------------------------------333333333333333333333333333333333333333337777777777777777777777777777777777777777vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBsssssssssssssssssssssssssssssssssssssssslllllllllllllllllllllllllllllllllllllllllMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaajjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjoooooooooooooooooooooooooooooooooooooooooOOOOOOOOOO",
"NNNNNNNNNNrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrriiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiii444444444444444444444444444444444444444440000000000000000000000000000000000000000-----------------------------------------333333333333333333333333333333333333333337777777777777777777777777777777777777777vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBsssssssssssssssssssssssssssssssssssssssslllllllllllllllllllllllllllllllllllllllllMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaajjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjoooooooooooooooooooooooooooooooooooooooooOOOOOOOOOO",
"NNNNNNNNNNrrrrrrrrrrrrrrr:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::77777777777777777777vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBsssssssssssssssssssssssssssssssssssssssslllllllllllllllllllllllllllllllllllllllllMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaajjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjoooooooooooooooooooooooooooooooooooooooooOOOOOOOOOO",
"NNNNNNNNNNrrrrrrrrrrrrrrr:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::77777777777777777777vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBsssssssssssssssssssssssssssssssssssssssslllllllllllllllllllllllllllllllllllllllllMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaajjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjoooooooooooooooooooooooooooooooooooooooooOOOOOOOOOO",
"NNNNNNNNNNrrrrrrrrrrrrrrr::::::::::::<::::::::::::::$:::::::::::::$:::::::::::::$:::::::::::::$::::::::::::::<::::::::::::::5:::::::::::::<::::::::::::: :::::::::::::<::::::::::::::$:::::::::::::$:::::::::::::: :::::::::::::$:::::::::::::$::::::::::::::5:::::::::::::<::::::77777777777777777777vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBsssssssssssssssssssssssssssssssssssssssslllllllllllllllllllllllllllllllllllllllllMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaajjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjoooooooooooooooooooooooooooooooooooooooooOOOOOOOOOO",
"NNNNNNNNNNrrrrrrrrrrrrrrr:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::77777777777777777777vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBsssssssssssssssssssssssssssssssssssssssslllllllllllllllllllllllllllllllllllllllllMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaajjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjoooooooooooooooooooooooooooooooooooooooooOOOOOOOOOO",
"NNNNNNNNNNrrrrrrrrrrrrrrr:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::OOOOOOv7777777777777vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBsssssssssssssssssssssssssssssssssssssssslllllllllllllllllllllllllllllllllllllllllMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaajjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjoooooooooooooooooooooooooooooooooooooooooOOOOOOOOOO",
"NNNNNNNNNNrrrrrrrrrrrrrrr::::::::::::$::::::::::::::$:::::::::::::$:::::::::::::5:::::::::::::$::::::::::::::$::::::::::::::$:::::::::::::$::::::::::::: :::::::::::::5::::::::::::::$:::::::::::::$::::::::::::::5:::::::::::::<:::::::::::::$::::::::::::::$:::::::::::::$::::::******O7777777777777vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBsssssssssssssssssssssssssssssssssssssssslllllllllllllllllllllllllllllllllllllllllMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaajjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjoooooooooooooooooooooooooooooooooooooooooOOOOOOOOOO",
"NNNNNNNNNNrrrrrrrrrrrrrrr:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::******O7777777777777vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBsssssssssssssssssssssssssssssssssssssssslllllllllllllllllllllllllllllllllllllllllMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaajjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjoooooooooooooooooooooooooooooooooooooooooOOOOOOOOOO",
"NNNNNNNNNNrrrrrrrrrrrrrrr:5::<::<::$:5::h::5::$::<::<::::$::$::$::$::$::$:$::$::$::$::$::5:5::<::$::<::5:::h:5::5::<::<::5::5::::<::$::$::h::5::5:<::5::<::h::h::<::::5::$::5::$::$::$:5::;::$::$:: ::$::$::5::h::5::5::5::::5::$::5::$::$::5:5::$:: ::$:: ::$:$:: ::;::5::$::5:::******O7777777777777vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBsssssssssssssssssssssssssssssssssssssssslllllllllllllllllllllllllllllllllllllllllMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaajjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjoooooooooooooooooooooooooooooooooooooooooOOOOOOOOOO",
"NNNNNNNNNNrrrrrrrrrrrrrrrm+mmmmmmmmmm+mm+mmmmm+mmmmmmmmmmmmmmmmmmm+mmmmmmmmmm+mmmmmmm+mmmmm+mmmmmmm+mmmmmmm+mmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmm+mmmmmmmmmm+mm+mmm+mmmmmmmm+mmmmmmmmmmm+mm+mm+mm+mmmmmmmmmmmmmm+mm+mmmmmm+mmm+mm+mm+mmmmmmm++mmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmm+mmm******O7777777777777vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBsssssssssssssssssssssssssssssssssssssssslllllllllllllllllllllllllllllllllllllllllMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaajjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjoooooooooooooooooooooooooooooooooooooooooOOOOOOOOOO",
"NNNNNNNNNNrrrrrrrrrrrrrrrnnqnnbncnnbnnqnnbnnnnnnnnnbnnbnbnbnbnnnbnnnbn55hnqbnnnnnbnnnnnnnnnnqnbbnnnnnnnnnbnnbnnnbnnnnnbnnnnbnnnbnbnbnnbnnnnnnnnnnqnnnbnnnnnnnqnnnnnqnbnnbnnnbnbnnbnnnnnnnqnnqnnnnqnnnnnnnnnnnnq5555qnnnnnnnnnnnnnqnqnnnnnnnqnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnqnnn******O7777777777777vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBsssssssssssssssssssssssssssssssssssssssslllllllllllllllllllllllllllllllllllllllllMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaajjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjoooooooooooooooooooooooooooooooooooooooooOOOOOOOOOO",
"NNNNNNNNNNrrrrrrrrrrrrrrrnnnnnnnqnnnn5nnnnnnnnnnnnnn5nnnnnnnnnbnnn5qn5nnnhnnnnnq$nnqnqnbnqnnnn5nnnnnnnnbnnnnn5nnnnbnnnnnnnnn5bnnnnnnnnnnnn5bnnnqnnnqnnnn$qnqnnnnqnnnnn5nnnnnnnnnnnnnn5nnnnnnnbnnnnn5bnnbqnnbnn$nnnh<qnnnnqnqnnqn5nnnbnnnnqnnnn5bnqnbnnbnqnnqn$nnnbnnnnnqnbn5bnnnnn******O7777777777777vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBsssssssssssssssssssssssssssssssssssssssslllllllllllllllllllllllllllllllllllllllllMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaajjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjoooooooooooooooooooooooooooooooooooooooooOOOOOOOOOO",
"NNNNNNNNNNrrrrrrrrrrrrrrrnnnqnnnnqnnnnqnnnbnnnnqnnnnnnnnnnbnnnnnqnnn5n55hn5nqqnnnnnnnnnnnnnbnnbnnqnqnbnnnnnqnnqnnnnnbnnqnbnnnnnnnnnqnnnnnnnnnqnnnnnnnnnqnnnnnnnnnnqnbnnnnqnnqnbnqnbnbnnbnqnbnnnqnbnnnbnnbnbnb55$$bnn5nbnbnnnnqnnnnnqnnbnnnnbnnnnnnnnnqnnnnbnnnqnnnnnnbnnnnnnnnqnnn******O7777777777777vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBsssssssssssssssssssssssssssssssssssssssslllllllllllllllllllllllllllllllllllllllllMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaajjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjoooooooooooooooooooooooooooooooooooooooooOOOOOOOOOO",
"NNNNNNNNNNrrrrrrrrrrrrrrrnqnnnnqnnnbqnnbqbnnqbnnbnqbnqnnbnnqbqnbnnb$nnn5nbn5nnnbnqqnbnbbbnbnbnbnbnbnnbnbnbnbnnnbnqbnbnbnbnnbqnbbqnbnnbqnbnbnnnbbqbbnbnbnqnnbnbqbbbnnnnqnqnbnnqnbnnqnnbqnnbnnbnbnnbnnqcnbbnnn5nb5bnbnb$qnnnqbnnqnqbnbnqnbbnqnbnqnbnbqnnbnbqnnnbnqnqqbqnqnbnbqnbnbnn******O7777777777777vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBsssssssssssssssssssssssssssssssssssssssslllllllllllllllllllllllllllllllllllllllllMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaajjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjoooooooooooooooooooooooooooooooooooooooooOOOOOOOOOO",
"NNNNNNNNNNrrrrrrrrrrrrrrrqqqqqqbqqbqbzqnbnq1bqqqbqqb*qqqbqqqqbqbq1yyb1qyqbqyb1qbyqqqqqqqqqbqqbyqq1q1qbq1qbbq1yqb1qqqq1qbqq1b*1qqbqqqqqqbbqp11bbqbbbnqqqbpqbnbqnqnqbqnqpqnbnbnqbnqbqqbpbbnqnbnnbnbnbpnnqnnbbbpbnpbnpbnpbqqbnnbnnbfnqnqbnqnbnnbbfqqnnnqnnqnnbqnfnqnnnnnqnqnbnhqnnqnn******O7777777777777vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBsssssssssssssssssssssssssssssssssssssssslllllllllllllllllllllllllllllllllllllllllMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaajjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjoooooooooooooooooooooooooooooooooooooooooOOOOOOOOOO",
"NNNNNNNNNNrrrrrrrrrrrrrrrqqq11q1q111q1q11111111111111111+111111+C+12+1C2C+1gC1+1++1C++1+1C+1C+11+1C1CC++1+11+C1+1C1C1111C11111111C11111111111qgy1111111q11q11q111qq11qqq1qqq1qq1qqqqqqqqqqb1qbqqqqnbqqqbqqnbpq1pbbbqqpbbnqqqnbqqqqbbnqbqqbqqnbqnbqqqbqqbqqnbnqnbqbqbqbqbqqqqnbqnbn******O7777777777777vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBsssssssssssssssssssssssssssssssssssssssslllllllllllllllllllllllllllllllllllllllllMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaajjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjoooooooooooooooooooooooooooooooooooooooooOOOOOOOOOO",
"NNNNNNNNNNrrrrrrrrrrrrrrrq1q1q11111q1111111+11+1+1++1+1C1C1++CCC1CCg1+CgCCCg2CCC+C++C1++C+11+C+++1++C+C1+1+1C1C11++C+C+11+1C1C11+11111111+111Cgg1111q1111111q11q111q1q1b11q1b1q1q1q1qqqbbqqbbq1bqbqqbqbqbqbbzbbp1bqbbpbbpbbbbqbqbbqqqqqqbqqbqqnqbnbbnqbnqbqqbbqnbqnqbnqnqbnbqnbnbn******O7777777777777vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBsssssssssssssssssssssssssssssssssssssssslllllllllllllllllllllllllllllllllllllllllMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaajjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjoooooooooooooooooooooooooooooooooooooooooOOOOOOOOOO",
"NNNNNNNNNNrrrrrrrrrrrrrrrb1111111q111g1111q1+11C1C11g1111++1C11C#gzgygyzzgygeyggygggg@ggggggggzggggggg@ggggggzq+1C1CC1+#ggggzuggggguggggggzgggpz2g2g2g2gz2gg2bq11q11b1y1qb1bq11bq1q1qyqbq1bqqbqqbqbzbqbqqb1qnzzzpbzbpbbbzpbbbnbqpnqbbbbqbqbnbnpbqbqqqbqqbqnbbpnqqnbqqnbqnbqpbqnbnb******O7777777777777vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBsssssssssssssssssssssssssssssssssssssssslllllllllllllllllllllllllllllllllllllllllMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaajjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjoooooooooooooooooooooooooooooooooooooooooOOOOOOOOOO",
"NNNNNNNNNNrrrrrrrrrrrrrrrqq111q11+111111+11111+1C11++C111C1+1++Cgzggggggggggdggdgggyggygygyygyggygygyyyyyyydzf>b+CC1C1Cgyyzzzzzzzzzzzzzzzzzzzzzzzzpzzzz%%%pff#q1q11q1bq1b1q1bq11qb1b1q11bbq1q1bqqqbbbbbqbqpb1bz1bbbzbqpbbzpbbbbbbqbbqqbqbnqqbqnqnbqbnqbbqnbqqbbqbqqnbqqnqnbnbbbnbn******O7777777777777vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBsssssssssssssssssssssssssssssssssssssssslllllllllllllllllllllllllllllllllllllllllMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaajjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjoooooooooooooooooooooooooooooooooooooooooOOOOOOOOOO",
"NNNNNNNNNNrrrrrrrrrrrrrrrq1111111q1111111111+1C1+1+1C11CC+1+11C1guc,c,,,,,,,,,,,,,,,,,,,,,,,,u,,cuuu,uuuuuuugf>h#+1+C+1gguuuueeeeeeeeegeegegggggggggggggggyX>gq111b1111b1bq11b1bq11q1qbqbqqbb1qbbbbq1qqbbzzb1bbzzpzbbbbbbpzbnbqqbbqbqbqbqqqbnnbqbqnbqnbqqbqnbnqbbnbqqnbqbqbbqnqbnb******O7777777777777vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBsssssssssssssssssssssssssssssssssssssssslllllllllllllllllllllllllllllllllllllllllMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaajjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjoooooooooooooooooooooooooooooooooooooooooOOOOOOOOOO",
"NNNNNNNNNNrrrrrrrrrrrrrrrb1q11111+111g11C11+11+C11+1g+C1+1C++1+cXc,=+k==kk===k===========================uuud>>>>#+CC1=yeee,Z,,,c,uc,u,ucuu,uuuuuuuuuuegggz>>>11q11111y111b1bq111bq1byqbqb1qqqbqbq1pqbb1qzzqbbbb1bpbbbzbb%zqqbbnpbqqbbbnqbqbqbpqbnqbqbbnbbqbqpnqnqbnbqqnqbnpnbbbbn******O7777777777777vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBsssssssssssssssssssssssssssssssssssssssslllllllllllllllllllllllllllllllllllllllllMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaajjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjoooooooooooooooooooooooooooooooooooooooooOOOOOOOOOO",
"NNNNNNNNNNrrrrrrrrrrrrrrrq1111q1111+1111111C11111C1CC+1+1CC1+1C#g,=kkkkkkkkkkkkkkkkkkkkkkkkkkk=k=kk=====ZeuuV>>>>>uC1+#zee,=ccccccc,,,,,,,,,,,,,,,c,cuggggVV>>#q11b1bq111q1b11qbq1q11b1qbbbb1b1q1bbqb1bbzzzbzbb1bb1b&bz%Cz%zbbbbbnqbqnbqbbnqnqbbqqbqbqbqqnbqbbqbqbqqbbnbqbqbbnbbnn******O7777777777777vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBsssssssssssssssssssssssssssssssssssssssslllllllllllllllllllllllllllllllllllllllllMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaajjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjoooooooooooooooooooooooooooooooooooooooooOOOOOOOOOO",
"NNNNNNNNNNrrrrrrrrrrrrrrrq1111111111qC1+11+11C1C11C11C++1CC1+++eec,Z===+kkkkkkkkkkkkkkkkkkkkkkkkkk===c,,u,ueV>>>h>>2C1uyueuuuu,,ccccc,c,c,c,c,ccuueeeegggg>>>>g11b111111b1bb1qb1bq1bb1b1qb1qqbbb1qqbb1b1zzzzzbbzbbbzbbzzVz%zzbbbqbbnbbbqqnbbqbqqbbnbbqbbqqbnbbqqnqbnqnbbnbnbbbbnbb******O7777777777777vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBsssssssssssssssssssssssssssssssssssssssslllllllllllllllllllllllllllllllllllllllllMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaajjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjoooooooooooooooooooooooooooooooooooooooooOOOOOOOOOO",
"NNNNNNNNNNrrrrrrrrrrrrrrrqy11y+1g11y1g11g11gCqg1+g1C21C1+g1C211zu,Z,,,,,,=kkkkkkkkkkkkkkkkkkkkc,,uue,,u,u,,eV>>hh>>fb+ygeeeeeeeegu,cc,,,,c,,cueggggggggggdX>>hp1qy1q11yq1y11y1by1qyb1y1yq1pqby1bz1b*qbyzzzzzz&bzbzzzzz%zzbzzbzbbpbbpqqpbbpbqpnpbbpqqpbnpqbpqbpbpbqpbqpnbpnbpqnpqbn******O7777777777777vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBsssssssssssssssssssssssssssssssssssssssslllllllllllllllllllllllllllllllllllllllllMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaajjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjoooooooooooooooooooooooooooooooooooooooooOOOOOOOOOO",
"NNNNNNNNNNrrrrrrrrrrrrrrrq11111111111111111+11+11+C1CC1C11+1C1czguu,,,Z,,Z=kkkkkkkkkkkkkkkkk+cu,,,,,,,,,ueedV>hhh>>2+bzdgggeeeeeeeuccc,,,,,eggggggggggddgzX>>>ub11q11q1b111b111bq1q1q1b1bq1bbbbqbqq1bbzzzzzzzbzzzzzz%zb%z%zbbpqbbqnqcqbnbqbnqbbnqbbbnqbqbnqqnbnnbqbqbqbbbbbbbbqbnc******O7777777777777vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBsssssssssssssssssssssssssssssssssssssssslllllllllllllllllllllllllllllllllllllllllMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaajjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjoooooooooooooooooooooooooooooooooooooooooOOOOOOOOOO",
"NNNNNNNNNNrrrrrrrrrrrrrrrq11111111111g1C11C1C11C11C12C11+1++C+cydddd%ddg,,Zkkkkkkkkkkkkkkkkkk,,,,,ueegd%ddddz>hh>>>u1#zyddddd%deee,ccc,c,cegeeegggd%dddddy%>>>cq1q111qy111bq1bqq11bbby1qb1bqqb1b1qb*b1bzzzzzz&%zzzz%zz&z%zzbbpbbpbbqbnbbqnqbbnpqbnqqbqqnbqbbqpbbqnbbnbbnqqnpbnbqnn******O7777777777777vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBsssssssssssssssssssssssssssssssssssssssslllllllllllllllllllllllllllllllllllllllllMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaajjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjoooooooooooooooooooooooooooooooooooooooooOOOOOOOOOO",
"NNNNNNNNNNrrrrrrrrrrrrrrrq11111111111C1C11+C1+1C+1+11C++1C+1C+CCb#f>>>>fzgcZ=kkkkkkkkkkkkkkkk=,,,g%z%fX>>>>>>>>>h>>cCCCg>>X>>>zee,c,cc,ugegeegd%d%>>>>>X>h>>>2q11111b111111bq1qb1bb1bbbq1bbbbqbb1qb1bb1zCzzzzbzzzzz%%%zzzzpbbbp1bbbnbbnbqbnbbbqnbqqnbbqbqbqnbbqqqbnbbqqbbnbbqbnqbb******O7777777777777vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBsssssssssssssssssssssssssssssssssssssssslllllllllllllllllllllllllllllllllllllllllMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaajjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjoooooooooooooooooooooooooooooooooooooooooOOOOOOOOOO",
"NNNNNNNNNNrrrrrrrrrrrrrrrq1q11+1+C111g1111C11+11C11+2CC++C1C+C+C+1g#z>>>>ze,Zkkkkkkkkkkkkkkkkke,,eXX>>>>>>>>>h>h>>>bCC1C2ff>XXze,,ccc,ugeeeeg%%dV>>h>fh>>>hf>u1111q111y1b1b11b11q11b1z1bqbqqb1bqbbqzqbbzzyzzzzz%zzzzzzzzqbzbb1bppbb1bqbqqbbnqnpqqqbbqbbqnqbnbpcbnqbqbbbnqqbpqbbbnn******O7777777777777vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBsssssssssssssssssssssssssssssssssssssssslllllllllllllllllllllllllllllllllllllllllMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaajjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjoooooooooooooooooooooooooooooooooooooooooOOOOOOOOOO",
"NNNNNNNNNNrrrrrrrrrrrrrrrq11111111+1111C1+1C+1C++1+CC111C1+C1+1CCgCCgbg>>zz,Zkkkkkkkkkkkkkkkkkc,,,XV>>>h>f>>f>>>h>yC+1++Cu>>X%yuc=cccueeeeegdz%>>>h>>>>>>>>>hn1q1111111b1b1bq1111bq11qbqbqbqbbqbqbbqb1z&bbzbbzzzzzz%%zzzbqbqb1bbp1bbnbbbbnqqbqbbbqbqqnbqbbqbbqnqqbnqnbnqqbbqbbqnbb******O7777777777777vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBsssssssssssssssssssssssssssssssssssssssslllllllllllllllllllllllllllllllllllllllllMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaajjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjoooooooooooooooooooooooooooooooooooooooooOOOOOOOOOO",
"NNNNNNNNNNrrrrrrrrrrrrrrrq1111111111+1111111C1+C1+111+11+C1+CC+CCgCCgCCg#>zec=kkkkkkkkkkkkkkkk=u,,%X>>>hhh>>>>>>>hg++++C1+#Xzzec=cccueeeged%%X>>>>>f>h>>>>>>zb1+11111b11q1b11q1b1b1b1b1qb1bq1b1bq1qbbbzbb&zbbCbzzzzzzzqbqbbqbbbbzbbbbbqbnbbbqqbnqbqbbbqqbnqbbnbbbqbbnqqbnqqnbbbnqn******O7777777777777vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBsssssssssssssssssssssssssssssssssssssssslllllllllllllllllllllllllllllllllllllllllMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaajjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjoooooooooooooooooooooooooooooooooooooooooOOOOOOOOOO",
"NNNNNNNNNNrrrrrrrrrrrrrrrq111+1+11+11g1C+111+1C1+11+g1CC1CCC+1+CCugg+CCgCCu%ZZkkkkkkkkkkkkkkkkk,,,uff>><>h>fgy##b11+1C+C+CCuzgu=c=cceeeeed%zV>>>>>>>zuu#y#bbbq1111111qy1bb1bb1q111q1byq1bqqbqbqbbbbz11zb1nzbbbbz1bzbbzbbbbbbqbbbppbbqbnbqqqbbn*bqnbqqnbbqqbnbpnnbqqnqqqnbnbpbqbqnb******O7777777777777vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBsssssssssssssssssssssssssssssssssssssssslllllllllllllllllllllllllllllllllllllllllMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaajjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjoooooooooooooooooooooooooooooooooooooooooOOOOOOOOOO",
"NNNNNNNNNNrrrrrrrrrrrrrrrq11111111111C111C+11+1+C1++C1++C=+C1+1+Cg+g+CCuC+bzuZ=kkkkkkkkkkkkkkkk=,,,Xp>5555y1++C++++1++C+CC#zgecccc,eeeeed%%V>>>>f>y#q1+q1111q1111q1q111q11q1111b1q1q1bqq1bqb1bq1bq1bqbzbbzqqb1bzbbzbbzb1bbbzbbbbbzqbbnqbbbbbnbnqqbqbqqqbqbnqbnbqbnqqbnbqqbnbbnqnbn******O7777777777777vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBsssssssssssssssssssssssssssssssssssssssslllllllllllllllllllllllllllllllllllllllllMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaajjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjoooooooooooooooooooooooooooooooooooooooooOOOOOOOOOO",
"NNNNNNNNNNrrrrrrrrrrrrrrrqq11q1+1+1++11+111+1+1C1+1C11+CC+1+C+CCgC+uC+CuC++gzZZkkkkkkkkkkkkkkkkke,,gV>5$5>>1+++1++1+++1++cgduu==c,eeeeed%%V>>h>>>f1111111111111111111b11b1b11qb1q1111q11b1b1qb1bqbb1bbz1bz1b1bbz1bzCbzbbbqbpbbbbbqpbbbbnqbbqbbqbbqqbqbqnqbqqbbnnbqbqnqbbnbqqbqbnbn******O7777777777777vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBsssssssssssssssssssssssssssssssssssssssslllllllllllllllllllllllllllllllllllllllllMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaajjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjoooooooooooooooooooooooooooooooooooooooooOOOOOOOOOO",
"NNNNNNNNNNrrrrrrrrrrrrrrrqCq1111111C1gC11+11+1+1+1C+2C11+C+1CC+CgCgg+CCuC++g%,Z=kkkkkkkkkkkkkkkk=,,,Xp555><#+g1++C++1++Cbgye,=cc,eeeeed%%X>fhh>>y#C1C111g1111111111111yq11bb1q111qq1qybbb1qb1qb1b1bzbz1bbzbbbbbzbbzbbzbbbbbbzbqbp1znbbqqqbbbnqpqbbqbbqbqbqbqqpqqbqbbqbqqbqbp1nbqqb******O7777777777777vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBsssssssssssssssssssssssssssssssssssssssslllllllllllllllllllllllllllllllllllllllllMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaajjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjoooooooooooooooooooooooooooooooooooooooooOOOOOOOOOO",
"NNNNNNNNNNrrrrrrrrrrrrrrrq1111+111+1+111C1+C+1+1C++1C+1+C1C1+1C+gC+gCCCg++CCdg,=kkkkkkkkkkkkkkkk=,,,XVh<5>h2++C++C+++1+1uzeu,==,eeeeed%%X>>>h>>fb11111C1111111111111111111q1111q111bb111b1b1bq1bqbqq1z1bbzqqbb1zbbzb1zb1bbq1zbqbbbbzbbqbbbqbqbqnbqnbqbqqnbqnbqbbnqbnqqbqnbbqbbqnbn******O7777777777777vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBsssssssssssssssssssssssssssssssssssssssslllllllllllllllllllllllllllllllllllllllllMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaajjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjoooooooooooooooooooooooooooooooooooooooooOOOOOOOOOO",
"NNNNNNNNNNrrrrrrrrrrrrrrrq111+111C1111C+11C1+1C+C1C+1++++CC++1+gC+gC+C+uC++Cg%,Z=kkkkkkkkkkkkkkkk,,,uVp>5;<>n++C+CCC++1uzgec=c=eeeeedd%X>>>>>>%g1111+111111C11111111q1b11b111b1bq1b1qbbq1q1qb1qb1qqb1y1bbzbqb1bzqbz1bbzqbbqqzqbb1bbqpbbbnqbbbqbqqbqqbbqbbnbqbnbbqbqqbbnqbbqbbbnqbn******O7777777777777vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBsssssssssssssssssssssssssssssssssssssssslllllllllllllllllllllllllllllllllllllllllMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaajjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjoooooooooooooooooooooooooooooooooooooooooOOOOOOOOOO",
"NNNNNNNNNNrrrrrrrrrrrrrrrng1qg1+g11gCg11g+1g1+gC12C1gC1C1gC+g+Cg+CuCCu+eggu+ezeZ=kkkkkkkkkkkkkkkk=,,uVp>>;h>ugC+gC+gC+gzge,===,eeeed%%X>>>>>>zgg21g11g1Cg11y11g11g11bqg11y1qy1by11yb1y1yb1y1qy1qzbby1zzq1z1qzbqzbqzbbzpbzqbbbzbbzqnzz1pqqpbbpqpqnpbnpbnpbnpbbpnpbnpbnpqbpbbpbnpqnb******O7777777777777vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBsssssssssssssssssssssssssssssssssssssssslllllllllllllllllllllllllllllllllllllllllMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaajjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjoooooooooooooooooooooooooooooooooooooooooOOOOOOOOOO",
"NNNNNNNNNNrrrrrrrrrrrrrrrqq111111Cq111C1+11+11+1+C1+1++1+11++1CuC+g+CCCu+uC+uczZZkkkkkkkkkkkkkkkkk,,cgV>5> 5<+CC+++C+cyguc===,ueeed%%X>>f>>>ubgg11+11111111111111q11C1b111111q1q1b1q1bbqbb1b1bq1qbqbz111zb1nqbbzbb1zbbzbbqbb1zbbbqqbbzbbqqbbqnbbqbnqbbnqbqnqnbbnqqnqqqbbbbbbqqqn1n******O7777777777777vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBsssssssssssssssssssssssssssssssssssssssslllllllllllllllllllllllllllllllllllllllllMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaajjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjoooooooooooooooooooooooooooooooooooooooooOOOOOOOOOO",
"NNNNNNNNNNrrrrrrrrrrrrrrrq1+111111111C1CC1+11+1C11+1+1C+1++++CCgCCuCCC+uCg+CubzuZ=kkkkkkkkkkkkkkkk,,,eVf>$555++CC+1+bgde,===ceeeed%%>>f>>>>u11gg+1C1C11111C111111111b11b111b111bq1b1b111q1qb1bb1bq1bzbqbz1qq1bbz1b1zbbzqbqb1bzbbqqbbbzbqbnbqbbbqbbqbbqqnbqbbqbqbqbqbnbbbbnbqbbqqnn******O7777777777777vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBsssssssssssssssssssssssssssssssssssssssslllllllllllllllllllllllllllllllllllllllllMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaajjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjoooooooooooooooooooooooooooooooooooooooooOOOOOOOOOO",
"NNNNNNNNNNrrrrrrrrrrrrrrrq111111C11C+g1111C+C1+1+C1+gC1++1+1++g+C+g+++Cg+uC+eCu%Z=kkkkkkkkkkkkkkkk=,,,XVh55<5g+C++C1gye,Z===eeeed%%>>h>>hhy1C&gg1C1111C1g1111111111111y1b1111qb1b1b11ybbb1bqbbqbqbbyz1b1zbbqb1bzbbzz1qzbbqbbb1zbpbqbbbzbbbqbqbpbnbbqnbbqbbqnbpnbbnqbbqbnqbqpnbbbqn******O7777777777777vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBsssssssssssssssssssssssssssssssssssssssslllllllllllllllllllllllllllllllllllllllllMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaajjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjoooooooooooooooooooooooooooooooooooooooooOOOOOOOOOO",
"NNNNNNNNNNrrrrrrrrrrrrrrrq11111111111C1+1C1C1+1+11+1C+C1CC+CCCgCCuCC+CCuCu++g+bz,Z=kkkkkkkkkkkkkkkke,,eXf>$55n+CC+1u%euc==cueeed%%X>>>>>>u1C11ggC1+1111111111111111b11q1111bb111111b1b11q1q1bb1bbq1bzbb1zbqqbbbz1bqzbbzbbbqbbbzbbqbbbbzbbbbqnnqb1nbbqqqbqnbbqbbbqqnbqbqbnbqbqbqbbn******O7777777777777vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBsssssssssssssssssssssssssssssssssssssssslllllllllllllllllllllllllllllllllllllllllMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaajjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjoooooooooooooooooooooooooooooooooooooooooOOOOOOOOOO",
"NNNNNNNNNNrrrrrrrrrrrrrrrq11111+11111C111+11C11+C1++1C+C++1+CCg+Cg+C++CuCuC+CuCggZckkkkkkkkkkkkkkkkc,,,Xp><55u++1+czeuZ===uueue%%>>>>>h>uq11+Cgg1111+111C11111111b11111b111111bb1b11b1bbqbb1bqbq11bz1qbbzbbqbb&zbbbzbbbzqbnbqbbzqbqbbbbpqbbqbqbnqbqqbbbnbqbnbbnbnqbqbnnbbbnbbnqbnb******O7777777777777vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBsssssssssssssssssssssssssssssssssssssssslllllllllllllllllllllllllllllllllllllllllMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaajjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjoooooooooooooooooooooooooooooooooooooooooOOOOOOOOOO",
"NNNNNNNNNNrrrrrrrrrrrrrrrq111111C1C1Cg1C+1+1C+C11+1+g1CCCC+1+g++Cug+C++g+g+++uC#z,==kkkkkkkkkkkkkkkk,,,dff5$5>+++#zgu,===,eueeg%>>>>f>>u1+gC11ggC1111111gC111111111111gb1bq1bq1b11bq1y111b1qb11qbb1zb1bzbbqb11bz1bzzbbbzbqbqbb1pzbqbbqbbzqbqbqpbbqbqbbbqbbbqbpbnqbqbnbqqbqnpbqbnbn******O7777777777777vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBsssssssssssssssssssssssssssssssssssssssslllllllllllllllllllllllllllllllllllllllllMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaajjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjoooooooooooooooooooooooooooooooooooooooooOOOOOOOOOO",
"NNNNNNNNNNrrrrrrrrrrrrrrrq11+11111+11+1C1C1+C1++1C+C1+C+1+++Cg+CCgC++++uCu++CuC+zuZZkkkkkkkkkkkkkkkk,,,uVp5$;>#+cggu,===,eeueg%X>>>>>fu11C1+1Cgg1111C11111111111111111q111b1b111q1111bqbq1b1b1qq1bbzb1bzbb1qbbbzb1bz1bbzqbqbbbqzbbbbqbbqpbbbqbbqbbqbqqqbqbnbbbbbqqbbqbqbnqbqbbqqbb******O7777777777777vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBsssssssssssssssssssssssssssssssssssssssslllllllllllllllllllllllllllllllllllllllllMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaajjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjoooooooooooooooooooooooooooooooooooooooooOOOOOOOOOO",
"NNNNNNNNNNrrrrrrrrrrrrrrrq111C+1C1C1111C1+1+1C+1+1+1C+1C+C1++g+C+uC++CCuCeC+CeC+uzZZ=kkkkkkkkkkkkkkk=Z,,Vp<5>>21gdu,===,ueuug%%>>>>>>u1C1+1C11gg1+1C11C1111111+1111111b11111111q1b1q1b11b1qbbb1bq1by1bbz1bbqq1bzbb1zbbbzqqbbbqqbzqbqbqqbbzbbnbbqnbbbbqnbqbqqqnbbbqnbqnbqbqbbbnbqbb******O7777777777777vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBsssssssssssssssssssssssssssssssssssssssslllllllllllllllllllllllllllllllllllllllllMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaajjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjoooooooooooooooooooooooooooooooooooooooooOOOOOOOOOO",
"NNNNNNNNNNrrrrrrrrrrrrrrrq+1111C111C1+11C+1C1++1+C++11+C+CC+gC+CuCC++C+gCu+C+e+++ggZ=kkkkkkkkkkkkkkkkc,,uXV<<>zzeuZ==Zuuuug%%X>>>>>uC1+1+1+1C1gg1+11+1111111111C+1111111111q11q1b1b111b1b111qb1qb1zb1bqz1b1qbbbzbq1zbbbzqbqbqqqbzbbbbqnb1bzbbqbbbbqbqbqqnbqnqqnqnbqqnbnbqqbbbbqnqn******O7777777777777vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBsssssssssssssssssssssssssssssssssssssssslllllllllllllllllllllllllllllllllllllllllMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaajjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjoooooooooooooooooooooooooooooooooooooooooOOOOOOOOOO",
"NNNNNNNNNNrrrrrrrrrrrrrrr1111+111C+1+1C1+1+1+1+1+1+1+++1C+C+g+C+g+C++++u+g+C+Ce++,z,Z=kkkkkkkkkkkkkkkk,,,dV>>pzeu====uuuug%%V>>>>>u11+C1+1C1CCggC1C111+111C1+111111+11111111111q1q1b1b1q1q1q11qb1by1bbbzbbqb1bbzbqbz1bbz1qbqbbb1bzb1bbqqbqp1bbbnqbbqbqbqbqbqbbbbbqqbqqbbqbqnqbqbqb******O7777777777777vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBsssssssssssssssssssssssssssssssssssssssslllllllllllllllllllllllllllllllllllllllllMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaajjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjoooooooooooooooooooooooooooooooooooooooooOOOOOOOOOO",
"NNNNNNNNNNrrrrrrrrrrrrrrrq11111+1C111g1+11C+C1+1+C+1g1CCC+CCuC+CuCuC++Ce+u++CCu+uCyeZ=kkkkkkkkkkkkkkkk,,,eff>zgc,===,u,ue%%X>>>>>u1+1C+1+1g1+1ggC+1C1111g111111+=+1111y111bq1q11b1111y11b1bbqbbq11yzCbzqqb1bb1bzb1zzbbb1zbqnqqbbzzbbqbbbqbbzbbpqnqnbbbbqbbnbbpbqqbbqbqbqnqbpbqnnqn******O7777777777777vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBsssssssssssssssssssssssssssssssssssssssslllllllllllllllllllllllllllllllllllllllllMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaajjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjoooooooooooooooooooooooooooooooooooooooooOOOOOOOOOO",
"NNNNNNNNNNrrrrrrrrrrrrrrrq11+11C11+1+1C11+11++C+1+C+C+1C+C+g+CC+gC++CCCuC+u+++e+++uzZZ=kkkkkkkkkkkkkkk=,,,Xffgc,===ueu,e%dX>>>>>ubCC+1C+1C1C1CggC1C11C1C1C1C111111111111111qq11111q1q11b11q1bq11bzbbbbyqqbbbqbbz1nb1zbb1zqbqbbqbbbzbbbqqnbqbzbbbqqqbqbbqbqqbbqbbnqqbnqbbqbbnbb1bnn******O7777777777777vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBsssssssssssssssssssssssssssssssssssssssslllllllllllllllllllllllllllllllllllllllllMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaajjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjoooooooooooooooooooooooooooooooooooooooooOOOOOOOOOO",
"NNNNNNNNNNrrrrrrrrrrrrrrrq111+11+11111C1+1++1CC1+1+1+1++1++g+CCg+C++C+Ce+CuC+Cgk++&%uZZkkkkkkkkkkkkkkkke,,gV%u,===,,uuedzX>>f>>gbC++1++C1CCC1CggC1C1+1111111C11111C11111111b1111b11111b11b1bb1bq1y=1&bzb11bbqb1zb1bbzb1bz1bbbqb1bbzbqbbbqbbbpbbqbbbbqbqbqbqnbbbqqbqbqbqbqbqbqbnqbb******O7777777777777vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBsssssssssssssssssssssssssssssssssssssssslllllllllllllllllllllllllllllllllllllllllMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaajjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjoooooooooooooooooooooooooooooooooooooooooOOOOOOOOOO",
"NNNNNNNNNNrrrrrrrrrrrrrrr1g+1g11g11g+g11g+12C12C1g1+g+1+CgCug++uCCu+CuCgu+u++uuCg++dgZckkkkkkkkkkkkkkkkc,,uXd,===c,uueddV>>>>h>b+gC1g11g1C2CCgggg+g+Cg1+g11g11gq+y1111g1by11yb=y11y1by1y11y11ybbzybyb1yqbz1bzq1zbbzbzz1bzb1qqpbbzqzzbqpbqpbbzbpqbpbqpqbpqbp1bpbpqqpnbpqbpnbpbqpnqn******O7777777777777vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBsssssssssssssssssssssssssssssssssssssssslllllllllllllllllllllllllllllllllllllllllMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaajjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjoooooooooooooooooooooooooooooooooooooooooOOOOOOOOOO",
"NNNNNNNNNNrrrrrrrrrrrrrrrq111111111+11C++1CC1C+1+CC1C1+1+CCgC+Cg+C+++C+u+Cu+++u++++#z,Z=kkkkkkkkkkkkkkk=u,,Xe=k==,u,ed%V>>>h>hgCC+C1+CC++1CC1Cgg111C11+11111111q1n##@uu@cbbq1111b11b111bqbbbbbCbCzbb1bzbqb1bqbbybqb1zbbbzbbqbb1qbbbzqbbqbqbqb1bbbbqqnbbqbqqnbbnqnqqqnbnbnbqbbqnbqn******O7777777777777vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBsssssssssssssssssssssssssssssssssssssssslllllllllllllllllllllllllllllllllllllllllMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaajjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjoooooooooooooooooooooooooooooooooooooooooOOOOOOOOOO",
"NNNNNNNNNNrrrrrrrrrrrrrrrq111111+1111CC11+11+11C11++1++C++gC+CCu++C+C++u+CuC++u+++++zeZZkkkkkkkkkkkkkkkk,,,,,k==uuued%VX>>>>>yb1+1C+1C1C1+1CC1gg1111C1C1111C11b#uuuu#u@gyp2q1b111b11b11111111bbbyb111yb11qbqb1bzb1bbz1bqz11bqbqbbb1pbbqqqbqbbpbqbnbbqqbbqqbqbbqbqbbbbqbbbqnbnbqbnb******O7777777777777vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBsssssssssssssssssssssssssssssssssssssssslllllllllllllllllllllllllllllllllllllllllMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaajjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjoooooooooooooooooooooooooooooooooooooooooOOOOOOOOOO",
"NNNNNNNNNNrrrrrrrrrrrrrrrq111111111++g1C11+1+1+1+C+1g+1+CCg+C+CuC+g+++CuC+u++C+ue+++uzcZ=kkkkkkkkkkkkkkk=,,,===,,,,g%V>>>>h>pc+++1++CCC1C1g1C1ggCC+1C111gC11b#u###n####uu2yfuqqqqbn##z1qbqbqb11bz1bzbzCbbqbb1b1zbbz1zbbqzbbbbqbbzbbzbbqbqbbqbzpbbqqbbbqnbbbbbpbnqbqnbbbbbqqpqqbqbn******O7777777777777vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBsssssssssssssssssssssssssssssssssssssssslllllllllllllllllllllllllllllllllllllllllMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaajjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjoooooooooooooooooooooooooooooooooooooooooOOOOOOOOOO",
"NNNNNNNNNNrrrrrrrrrrrrrrrq1+11+1C11C1+1C1+1+qC+C1+1+1CC1C+gC++gC+C+++++eCCu++++u+C++b%uZZkkkkkkkkkkkkkkkku,Z==,uu,d%%>>h>h>>#++1CC1CC1C++C1C1Cgg111111C1C1b###nnbbnbb####uu2p2bn#u@uyyu#q1bq1b1by1b1bybbqqbqb1bz1bbbzbbb1zbqbqbqqbbbz1qbqbqbbbzbbqbbqqbqbbnqbbbbbnqbbnbnbbqbbbbqnn******O7777777777777vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBsssssssssssssssssssssssssssssssssssssssslllllllllllllllllllllllllllllllllllllllllMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaajjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjoooooooooooooooooooooooooooooooooooooooooOOOOOOOOOO",
"NNNNNNNNNNrrrrrrrrrrrrrrrqq1C1111+111C1C1+1+1CC1C+C+1+1++g+C++uCC++CC+Cg+Cu+C++u+++CCegZZ=kkkkkkkkkkkkkkkc,=k=u,,g%%>>>>hh>#+C++C1C+C1C1C1CC+bggC111C11C1q#nnbbbbb&bbbcc###u2pu#####uuypuq1q1bbCz1bb1zbb1qqbbb1z1bb1zbb1bzbbbbqbbbbqzbbbbqbqbb1pqbbqbbbnqbbqbqnnqqbqnbqbbnbbqnqbbb******O7777777777777vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBsssssssssssssssssssssssssssssssssssssssslllllllllllllllllllllllllllllllllllllllllMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaajjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjoooooooooooooooooooooooooooooooooooooooooOOOOOOOOOO",
"NNNNNNNNNNrrrrrrrrrrrrrrrq11111+11111g+1C1+1+1C1+1+Cg1++CgCC++g+C+g++C+u+Cu+++Cug++++#%,ZZkkkkkkkkkkkkkkkk=k=u,ug%zV>>h>>>#Cg1+1+C+1CC1+1+g11Cgg11+111112##nb1b&&&&&&&&bZ##uu2unnbn###u2py11q1qz1b1ybz1bqbbq1bbzqbybzbbbbzbbbqqb*bbb1zqbbbqbqbpzbbbnbqnqbbbbbpbqbbnbbbnbqbqpbbqnbb******O7777777777777vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBsssssssssssssssssssssssssssssssssssssssslllllllllllllllllllllllllllllllllllllllllMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaajjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjoooooooooooooooooooooooooooooooooooooooooOOOOOOOOOO",
"NNNNNNNNNNrrrrrrrrrrrrrrrq111111111+1+111+11CC11+C+C1++CCuCCC+g++C+C+++uC+u++++gk+++++zeZZ=kkkkkkkkkkkkkk=k=ku,e%zX>>>>>>u+1++1+C+1+1+1+1C11+1ggC111C1+b#nb11C&b&&&&&&&&&bc##unbbbbb##uu2pgbq1byb1bbby1bqb1bqb1zbbbbzb1bqz1qbbb1bbb1bpbqbqbqbbbbpbbqbqqbqnbbbbbbqbqqnbbbbbqnbqbqqn******O7777777777777vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBsssssssssssssssssssssssssssssssssssssssslllllllllllllllllllllllllllllllllllllllllMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaajjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjoooooooooooooooooooooooooooooooooooooooooOOOOOOOOOO",
"NNNNNNNNNNrrrrrrrrrrrrrrrq+111+11C1C11C+11++11+11+1C+1++CgCCC+gC++C++++e++u++++u++++++udcZckkkkkkkkkkkkkkk=k=,e%%V>>>>h>u1+C++11+++CCC1C1+1CCCggC1C1111#nb11&C&&&&&&&&&&&&&#uu&&&&&bccuuuzf#qqby1b1bz1b1qbbqb1bzb1b1zbb1bzbqbbqbbqqbqzqbbbqbqbqbzbbqbbbbqqbbbbbqqbbbbbbnbqbbqbqbnn******O7777777777777vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBsssssssssssssssssssssssssssssssssssssssslllllllllllllllllllllllllllllllllllllllllMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaajjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjoooooooooooooooooooooooooooooooooooooooooOOOOOOOOOO",
"NNNNNNNNNNrrrrrrrrrrrrrrrq11111111111g11C1+1+1+1+1++gC+CgC+C+g++++g+++Cu++eC+++uu+=+++b%uZZkkkkkkkkkkkkkkkk=ue%%V>>h>>>ub+CCg1++11C1+1C++1g11Cgg1111Cbnb11C++&&&&&&&&&&&&&&Z#u++&&&&&&cuugV>b11yCbbyzbb11b1b1bbybbzbzbbbbzbqbqbqzbbbbqzbbbbqc1pq1pbbbqbbbbbbbpbbbqnbqbnqbqbpbqbnqb******O7777777777777vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBsssssssssssssssssssssssssssssssssssssssslllllllllllllllllllllllllllllllllllllllllMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaajjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjoooooooooooooooooooooooooooooooooooooooooOOOOOOOOOO",
"NNNNNNNNNNrrrrrrrrrrrrrrrq111111111+C+11+1C1+C1+1C1CC+1+gCCCCgC+1++CC+Ce+++u+++Ce++++++egZZkkkkkkkkkkkkkkk=ku,X%X>h>>>y1+1+C+C++C+1+1++1C1CCC1gg1C1C1cnb1+++&&&&&&&&&&&&&&&Z#cmm&b&&&&c#uuyV#b1ybbb&ybbq1bbbqb1z1b1bbzb11bzbqbbqqqb1bbp1bqqbqbbbb1pqbbnbqnbqbqbnbqbqbnbqbnqbnbbqqn******O7777777777777vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBsssssssssssssssssssssssssssssssssssssssslllllllllllllllllllllllllllllllllllllllllMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaajjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjoooooooooooooooooooooooooooooooooooooooooOOOOOOOOOO",
"NNNNNNNNNNrrrrrrrrrrrrrrrq1+11+1C1111C1C1+1+11+1C+++1C+CgC+CCu+C++CC+++gC++uC++Ce+++m++cz,,kkkkkkkkkkkkkk=kk,,eVV>>>>>#C+C+1C+++C1++C1C1+C1C1Cgg1111bnb1+m+C&&&&&C+&&&&&&&&&cb:mb&&&&&&cuugVubyb11bbzb1bbb1bqbbybbbbbz1bbbzqb1bbbbqbb1pbqbqbqqbbbqzbbbqbbbbbqbbbqbqbbqbnqqnbbqqbnb******O7777777777777vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBsssssssssssssssssssssssssssssssssssssssslllllllllllllllllllllllllllllllllllllllllMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaajjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjoooooooooooooooooooooooooooooooooooooooooOOOOOOOOOO",
"NNNNNNNNNNrrrrrrrrrrrrrrrq1111111+111g+1C1C1++CC1+11g1CgCCC++gC++CgC++CuC+Cu+++Cu++C++++ze,=kkkkkkkkkkkkkk==,,,%%>>h>>u+C+C+gC+C+CC1+CC+1+2+1Cgg1C+1nbC+mm+&&&&&&&&C&&&&&&&bc+:+&b&&&&Zc#egVgbybb1bzybq11b1bqb1z1bz1bzbqbbzbqbb1zqbqqbbzbqnbqbpbbbbzbqbqbqbnqpbbnqbbqbbbbqqpbbbqbn******O7777777777777vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBsssssssssssssssssssssssssssssssssssssssslllllllllllllllllllllllllllllllllllllllllMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaajjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjoooooooooooooooooooooooooooooooooooooooooOOOOOOOOOO",
"NNNNNNNNNNrrrrrrrrrrrrrrrq111111C1111C11+1+C1C1C+1+1+1+g++1+gC+CCC++CC+uC++uCC++uC++++++czu,kkkkkkkkkkkk=k=k=u,uVf>h5<>#1+C+C1C+CC11+CCC11C11Cgg1Cbnb+m:m+&&&&Zc,c&=C=&&&=&Zck:+&&&&&&&cceg%g1ybb11zCbbbbbb1b1bzbb11bzbbbbzbbqbbqbbbbbbbzbbqbbbqbbbbzbqqbqbbbbbqqqbbbbqbbbnbbqbnbn******O7777777777777vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBsssssssssssssssssssssssssssssssssssssssslllllllllllllllllllllllllllllllllllllllllMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaajjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjoooooooooooooooooooooooooooooooooooooooooOOOOOOOOOO",
"NNNNNNNNNNrrrrrrrrrrrrrrrqg11g+1g11g+gC+gC1g1+g11g++gCCgCg++uC+gC+u++eCuu+guCuCCeC+u++u++gg,=kkkkkkkkkkkkk=k=u,,dV>>h5>>+g+Cg+1CCg++g1+2C+gCCggggCubCm::+&C&&&,,ug&&&+C=&==Z,+mC&&&&ZZ&cuug%uybbybbybbzqbzbqzb1z1bzbbzbqzbz1bzbqzb1zqbzbzzb1pbpbbzbbpqbpqbpbqpbpbbpbbpbbpbqpbqpbqb******O7777777777777vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBsssssssssssssssssssssssssssssssssssssssslllllllllllllllllllllllllllllllllllllllllMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaajjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjoooooooooooooooooooooooooooooooooooooooooOOOOOOOOOO",
"NNNNNNNNNNrrrrrrrrrrrrrrrq111111111+11111C11C1+1+1C+1+CCC+C1uCC+C+C+C++eC++u++++u++C+CC++cz,ckkkkkkkkkk===k==euueVf><5>>nC+C1+CC1C1C1+C+1C11C1gg1Cn1+m:m&&&&&Zc,g%c&C===+==ZZ+++&&=b&ZZcued%#y11bb&zb&1b11b1bb1zb11b&zbbb1zb1bbbb1bqb1b1z1bbqbbbbbqbbp1bbbbbbqbbqqbnqbbqqqbbbbbbbb******O7777777777777vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBsssssssssssssssssssssssssssssssssssssssslllllllllllllllllllllllllllllllllllllllllMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaajjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjoooooooooooooooooooooooooooooooooooooooooOOOOOOOOOO",
"NNNNNNNNNNrrrrrrrrrrrrrrrq1+1C1+11+11CC1+11+C1C1C+C1+1CCCC+Cg+CC+CC++CCuC++uCC+C+uk+++++++z,Zkkkkkkkkkkkk=k=k,,,,Xff><<52+1++CC+C1++C1+1+1CC1CggC1bCm::+C&&&&,,ud%uc&&+===Z,c+++&&&&ZZZ,ee%2bzbbb1byb1q1bb1qb11zb1b1bzqb1bbbbqq1bbbbqbbq1pbqbbqbqb1b1bpbqbbqqbnbnbqbbbqqbbnbqbqqbn******O7777777777777vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBsssssssssssssssssssssssssssssssssssssssslllllllllllllllllllllllllllllllllllllllllMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaajjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjoooooooooooooooooooooooooooooooooooooooooOOOOOOOOOO",
"NNNNNNNNNNrrrrrrrrrrrrrrrq1111111+11+g111+C11+1C+1+1gCCC1C1+gC++C+gC+C+g+C+e++CCuuC++=+++Cu,ckkkkkkkkkk=k=====e,ueVf>5$5<b+CgCC1C+C+1+1CC1g1CCgg1Cb+m:m&&&&&bc,ed%u#b&=ZZ,eg,&&&&&Z====,eddu1zC111by1bq111bb1b1z1bzbbzbqbbb1bbqbzbqbqbqbbp1bqqpbbbnbbbp1bbbbbpqbbbqbbqbbqnqpbnbbnb******O7777777777777vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBsssssssssssssssssssssssssssssssssssssssslllllllllllllllllllllllllllllllllllllllllMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaajjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjoooooooooooooooooooooooooooooooooooooooooOOOOOOOOOO",
"NNNNNNNNNNrrrrrrrrrrrrrrrq1111+11C1+1C1+1C1+C1C+1+1CC1CC++CgC+C1+++C+CCu++1eC++CCeC++++++bg,=kkkkkkkkk=k==k=k=,u,uVV>>5 5u1CCCC++1C1+C+1C++1Cbgg&1Cm::++&&&&,cug%%b1cb&,eeddub&&&=&===,eg%ubyCbbbqyb11bq1b11bbbzbb11bz1bq1bbb1bqbqqbq1b1bzbbbbbbbbbqb1qpqqbb1qbnbqbqqbbqbqqbbqbbqb******O7777777777777vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBsssssssssssssssssssssssssssssssssssssssslllllllllllllllllllllllllllllllllllllllllMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaajjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjoooooooooooooooooooooooooooooooooooooooooOOOOOOOOOO",
"NNNNNNNNNNrrrrrrrrrrrrrrrq111111+111111+1+11+1C1C1+1CCg1C1+gCC++1+C++C+gC++gC++++u+C+++CCeg,=kkkkkkkk=kk=k====cu,udVf5$55>++CC+1++1++1C+C1C+CCgg1n+m::&&&&&&ccud%g11b#cggdg#c#ZZ&ZZZZ,eg%gbbybb1b1y1b1q1bb1bqb1z11bb=zqb1bbq1b1bbqbbqbqqb1z1bqbb1bbqbbbzbbbqbbqbqbbbqbbqbqbbqbbqbn******O7777777777777vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBsssssssssssssssssssssssssssssssssssssssslllllllllllllllllllllllllllllllllllllllllMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaajjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjoooooooooooooooooooooooooooooooooooooooooOOOOOOOOOO",
"NNNNNNNNNNrrrrrrrrrrrrrrrq1111111+111g1111+C+1+1+1+Cg1g+1+CgC++1+Cu1C++g++CuC+C+ug++C+++uzu=kkkkkkk=k=k===k=k==e,uuVp>5$55#+g1C+1++1+1C1CC2C1Cgg1b+::+C&&+&Zc,e%%u111Cggcc111bu#cc,c,egdubb1y11b11zy1q1q1q1qb11zb1zbbz1bb1bbbbbbzbbqbqbbqbzbqqzbbqnqbqbbzbbbqpbbbqnqbqbbqbqpbbnbbb******O7777777777777vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBsssssssssssssssssssssssssssssssssssssssslllllllllllllllllllllllllllllllllllllllllMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaajjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjoooooooooooooooooooooooooooooooooooooooooOOOOOOOOOO",
"NNNNNNNNNNrrrrrrrrrrrrrrrq1111+111+11+1+1C11C1+C1+1C1CgCC+CgC1C+1+C++1CuCC++u++CCu=++++u%u,kkkkkkkkkkk==k======,u,uzVf5$55gCC+CC+CCC+C1C1C1+C1ggbbm::+&&&&&Zcug%X#1q11C11q11b11#uuuuegu#bbbbyb11b&ybb1bqqb11bq1z1b1q1bz11bcbb1bb1qbbbbqbqbbzbbqbbbqbbn1bpb1bb1qbnqqbbqbnbnqbbqqbbq******O7777777777777vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBsssssssssssssssssssssssssssssssssssssssslllllllllllllllllllllllllllllllllllllllllMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaajjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjoooooooooooooooooooooooooooooooooooooooooOOOOOOOOOO",
"NNNNNNNNNNrrrrrrrrrrrrrrrq111111C11++1111C1C+C1+1C1+CgC1++Cg+C++++CC+++gC++CgC+++Cu+++czu,,kkkk,=kk=k==k===k====eeuuVf55$<>c1C1C+=+C+1+1+C11C1ggbbm:m&&&C&&c,ug%gb+11&bC11b1qbb##g2g22@gguCyb1bb1bz&b1bqn#uuu@2yyuu##qzbb1qbbb1bbqb1bbqqb1bpbbbbqbqbb1bbbzbbqbqbqbqbqbbqqqbnbbbbqb******O7777777777777vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBsssssssssssssssssssssssssssssssssssssssslllllllllllllllllllllllllllllllllllllllllMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaajjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjoooooooooooooooooooooooooooooooooooooooooOOOOOOOOOO",
"NNNNNNNNNNrrrrrrrrrrrrrrrq11+11+11111gC+11111C1+1+11gg11+1gCCC1+C+gC+CCuCC+CuCCCu+uCCcgg,,=kkk,,=k=kk===========uu,uVf>5555ug+C+C+C11+CC1+g+1122n1::mC&&=&&cuudzgCb1112b1b##uu#uu#uuuuuu2ubyCbbCb&yy11b#u#uuuuuuu@yyyypbbbbz1bqb*qbbqbbqbbbzbqzqbbqqbbbbbbp1bzbqqbbnqbqbbqqpbqqqnn******O7777777777777vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBsssssssssssssssssssssssssssssssssssssssslllllllllllllllllllllllllllllllllllllllllMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaajjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjoooooooooooooooooooooooooooooooooooooooooOOOOOOOOOO",
"NNNNNNNNNNrrrrrrrrrrrrrrrq111111bC1111+11++1+11+11++1g++1+g1++++1C+CC++g+++Cg++C+CgCcgg,,=kkkc,,uk=k=k==========,,eugVV>h$<>+11C1C1+1C1C11C1CCggb+::+&&&&Ccc,uggg####u#uuuu#u##nncn#n##gz#bybb1bbybbnu#u#########uuu22ypu@@2@@@@@@@u@ugubbCbzbbqbqbbqqbbbbpbqbqbbqbqbnbqqbnqbbbbbb******O7777777777777vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBsssssssssssssssssssssssssssssssssssssssslllllllllllllllllllllllllllllllllllllllllMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaajjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjoooooooooooooooooooooooooooooooooooooooooOOOOOOOOOO",
"NNNNNNNNNNrrrrrrrrrrrrrrrq11111111+b1111C1111+1+111+1gC1+1gCC1+1++CC+CCg+CC+u+C+C=uCggu,=kkk=,,,,==k====k========euueVf>>5>>#++C+CC1+C1C++111bu#n+::+&&+&=Zcuuuuuuuuuuu##n#nnbnbbbccnZuz%b1z11b11ybuu##nn#nbn#c####uuu@2@gu@u@@@@u@2g22yqbbbzbbbbqbbbbqqbbbzqbbbqbnbbbbnbbqbbbbqnn******O7777777777777vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBsssssssssssssssssssssssssssssssssssssssslllllllllllllllllllllllllllllllllllllllllMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaajjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjoooooooooooooooooooooooooooooooooooooooooOOOOOOOOOO",
"NNNNNNNNNNrrrrrrrrrrrrrrrq11111+1111Cg+111C+C1+11C++g1C+CCgC1+CC+1gC+1+gC++Cg++Cu+gggu,Zkkk=,,e,,,k==k===k=======,uuudVh><5hp+1+1C1+1C1+1C2b##nnb1:mC&&&&&ccu#n#nn####nnnbbbbbbbbbbZbcg%gby1bbq1by##nnbnbbbcbccccc###uuuuuuuuuuuuuuuuuygbbbbzbpbqbbqbnbb1b1pbpbbnqqbbqbqnbqpbnqbqb******O7777777777777vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBsssssssssssssssssssssssssssssssssssssssslllllllllllllllllllllllllllllllllllllllllMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaajjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjoooooooooooooooooooooooooooooooooooooooooOOOOOOOOOO",
"NNNNNNNNNNrrrrrrrrrrrrrrr1q111111111111C1C111CC1+1C1g1C1C1gCC+1+C+++C+Cg+CC+g+C+CCg%u,Zkkkk,,e%,u,================euegff>>55>c+C+1+1C++1b###nbbbb1:m&&&&&&c,cbbbbcbbbnbbbbbb1b&&&&b&cugzg1yq11bbnunnbbbbbbbbcbcbccc###uu#############gzybqb1bbbbqbbbb1bnqbbbzbbqbbbqbbbbbbbqbqbqbb******O7777777777777vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBsssssssssssssssssssssssssssssssssssssssslllllllllllllllllllllllllllllllllllllllllMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaajjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjoooooooooooooooooooooooooooooooooooooooooOOOOOOOOOO",
"NNNNNNNNNNrrrrrrrrrrrrrrr1111111C111111C111C1C1CC1+1gC1C1gCC1C+1+CC1CCCg+C+Cu+1++uze,,kkkkk,,%%e,,,=k=k===========ueeuVV>h>$$u1CCC1+C1CCnnnbbb1&&1+++&+&&&Zb&&b&bbbbbbb&&b&&&&&&&&&&cudzu&y1bb1##nbbbb1b&&c&ZbZZbcbbcc##c#cc#c#c##c#ugzgbbbbb&bbbbbbbbqbbbbqzb1bbbbbbbqbqbbbqbbbbb******O7777777777777vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBsssssssssssssssssssssssssssssssssssssssslllllllllllllllllllllllllllllllllllllllllMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaajjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjoooooooooooooooooooooooooooooooooooooooooOOOOOOOOOO",
"NNNNNNNNNNrrrrrrrrrrrrrrrby11y11g11g1g11gC1gC+g+1gCg2CCCCgCCg1+g1CgC+g+geCgCgg++gzu,,=kkkk,,dd%%,u,===============,uuedVf<;h55+1CgCCgCCgbbCbCC&++++&&&&&&&&&&b&&&&&&b&&&b&&&b&&&&&&&c,d%nby11yn#nb1&&&&bcZ&cZb,cZZZZcZZcZccccccbcccuggVybzbbzzz1bzbbpbbpbbzb1pbpbbpbbpqbpbqpqbpqbb******O7777777777777vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBsssssssssssssssssssssssssssssssssssssssslllllllllllllllllllllllllllllllllllllllllMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaajjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjoooooooooooooooooooooooooooooooooooooooooOOOOOOOOOO",
"NNNNNNNNNNrrrrrrrrrrrrrrrq111+11111111C11+1C111C1C12C1C1+2+1C+1+CCCCCCCg1+CCuC+cgg,,=kkkk,ug%%Xzeu,c=k=============geeuVf>5$$5#+C1C1+1C1nb++C++++&&&&&+&&&&&&&&&&&b&&&&&&&&&&&&&&&&&,uzzby1bq##bb1&C1&bZZZZZZZ=ZZZcb&cZcZccbcZcccccugg%gbbbb1zb11bbbbbqb1bqqbqzb1bbbbqbbqqbbbnbnqn******O7777777777777vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBsssssssssssssssssssssssssssssssssssssssslllllllllllllllllllllllllllllllllllllllllMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaajjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjoooooooooooooooooooooooooooooooooooooooooOOOOOOOOOO",
"NNNNNNNNNNrrrrrrrrrrrrrrrqq111111ng22p2222@22222222p*2222p@2222222*222gp222uzgggu,=kkk==,,ezV>>Vze,uZ==============ZeeugVf55$5>22222222@#1++m+++&+&&+&&&&&&&&&&&&&&&&&&&&&&&&&&&Z&&Zuu%z2p22un11+m+&bZ&cZZ,====ZZ&&ZbZZcZZcc,,Z,c,c,gd%fg22222p22222222222222p2222222222222f222222******O7777777777777vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBsssssssssssssssssssssssssssssssssssssssslllllllllllllllllllllllllllllllllllllllllMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaajjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjoooooooooooooooooooooooooooooooooooooooooOOOOOOOOOO",
"NNNNNNNNNNrrrrrrrrrrrrrrrq111C111#ppp*ppppp*ppppppppppppp*ppppppppppppfpppppzzg,,ck=k==u,edV>>>>zg,u,===============eeeeXf5$55<ppppppppp#b++:+&&&&&&&&+&&&&&&&&&&&&&&,&Z=Z&&Z&&&&&Z,uu%fpfpy#11m:m+&&ZbZZ,,,,e,,Z=&&ZZcZcZ,=&======,gg%fppppppfpppppppppppppppppppppfhhwffpppppppp******O7777777777777vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBsssssssssssssssssssssssssssssssssssssssslllllllllllllllllllllllllllllllllllllllllMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaajjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjoooooooooooooooooooooooooooooooooooooooooOOOOOOOOOO",
"NNNNNNNNNNrrrrrrrrrrrrrrrqq1111112*ppppppp*pppppppppppppfpppppppppppppppppzpzze,c=kkkk,uugd>>h>>z%u,e===============,eeudff55>5ppppppppp#b++m+&&&&&&+&&&&ZZ&Z&ZZ&=Z&ZZcZZ&Cm=&Z&=&&ceu%XVpp#nbm::m&ZZZZZ,c,eegec&&+&&ZZcZcc&========,d%fppppppfppppppppppppppppfpppphpffphpppppppp******O7777777777777vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBsssssssssssssssssssssssssssssssssssssssslllllllllllllllllllllllllllllllllllllllllMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaajjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjoooooooooooooooooooooooooooooooooooooooooOOOOOOOOOO",
"NNNNNNNNNNrrrrrrrrrrrrrrrq1q1111npp@guuuggguguguuuuuuuuuuuuuuuuuuuuuuuuuuuuzzuuZ=k==k,u,g%V>>>>2uzeu,,=============c=geeeVp>h<>uugugueuu#b++&&&&&m&+&&=&ZcZZZZZZZZZ,ZZ,cc+::&&&&&&Z,uu%gy22#1Cm::+bZZ&ZZ,uegd%d#&++++cZbcZcue,,,,,,,,u%Vyyyyyyyyyyyyyyyyyyyyyyyyzyyyzzzyzzyzyy*ppp******O7777777777777vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBsssssssssssssssssssssssssssssssssssssssslllllllllllllllllllllllllllllllllllllllllMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaajjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjoooooooooooooooooooooooooooooooooooooooooOOOOOOOOOO",
"NNNNNNNNNNrrrrrrrrrrrrrrrqq11111upycc##c###c#c#,##c#ccccccccccccbcccbcbcbbuze,,=k=kk,e,e%z>>h>dccgduu,===========c===ueeezfh>$5#cc#cccc#nbC&ZZcb+:&&&&&&Zcec,,c,c,c,c,cu&:::&&&&&&Zuug%uuuun1m:::b&ZZbZb,eg%%gun&C+++ZZcZbZugdgueeeeeud%gggggggggggg2ggggggggggggggggggggggg22ypp2******O7777777777777vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBsssssssssssssssssssssssssssssssssssssssslllllllllllllllllllllllllllllllllllllllllMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaajjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjoooooooooooooooooooooooooooooooooooooooooOOOOOOOOOO",
"NNNNNNNNNNrrrrrrrrrrrrrrrq1q111qypg#ccccc,ccccc#ccccc#cccccccccccbcbcbccbuze,,===k=cuue%%X>>>>#bbu%euu,============c=,eeegVf<5>#,cccccuc#&b#ccc&m:C&&&&&c,ugeuuuuuuuuuuc+::m&=&&Z&Zuugduuu#b+m::+bZZZ&Zcegd%guunbC+m+ZbZccZued%dgggggggzugggggggggggggggggggggggggggggggggggg2ppp#******O7777777777777vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBsssssssssssssssssssssssssssssssssssssssslllllllllllllllllllllllllllllllllllllllllMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaajjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjoooooooooooooooooooooooooooooooooooooooooOOOOOOOOOO",
"NNNNNNNNNNrrrrrrrrrrrrrrrb11111#p*#ucuccccc#,#c,cc,#cccccccbccbcbcccbccbcdgu,==k===u,ed%%>>>>ubccc%g,uu===========c=c=eeueVV>>5u#,cu,,#c##uuuuc++:&&&+&&cc,d%dddddddgg#&m::m&&&&&Zc,edgeuun1+:::&&ZbZ&Z,ed%dugunb+::+bZcZZcueg%%gdddddddgggggggggggggggggggggggggggggggggggg2ypppn******O7777777777777vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBsssssssssssssssssssssssssssssssssssssssslllllllllllllllllllllllllllllllllllllllllMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaajjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjoooooooooooooooooooooooooooooooooooooooooOOOOOOOOOO",
"NNNNNNNNNNrrrrrrrrrrrrrrr1q11q+gpgcuucccc#,c#,#cc#,#,#cccccccccccbcccbbccguu====k=u,,g%%>>>>gbc&ccu%uuuZ======c=c=c=c=ueeedVf><>,ccccucuuggguu&+m:&&&&&&,,ud%duuuuueuub+m::C&&Z&Z&cuedguuub1m::mb&cZZZZ,g%%gugun&+::mZZcZZcuud%%uguggggugggggggggggggggggggggggggggggggggggggzpppb******O7777777777777vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBsssssssssssssssssssssssssssssssssssssssslllllllllllllllllllllllllllllllllllllllllMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaajjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjoooooooooooooooooooooooooooooooooooooooooOOOOOOOOOO",
"NNNNNNNNNNrrrrrrrrrrrrrrrq111qnppu#cuccccc#,cc,cc,#ccc,ccccccccccccbccc,guu=k=k==,,ug%%>>>hgccccccczeeuu===========,=c=geueVf>5>uc,c,ccccu#u#n&+m:&+&&=&c,ud%duueueuu#b+m::&&&&=&&,uedguuun+m::+ZZZ&Z&cug%dguuun1+::+ZbZcZZugd%%ggggggggggggggggggggggggggggggggggggggggggggyppppb******O7777777777777vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBsssssssssssssssssssssssssssssssssssssssslllllllllllllllllllllllllllllllllllllllllMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaajjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjoooooooooooooooooooooooooooooooooooooooooOOOOOOOOOO",
"NNNNNNNNNNrrrrrrrrrrrrrrrqb111upyucucucc#,ccc#,ccc,cccc,cccccccccccccbcgd,Z=====,u,e%%X>>f>cbccccbcgdueec=====c=cc==cccueeedVf5>y#c,uu,uucuc#b++m:&&&&&&cued%guuuuuuu#1C:::&&&&&ZZ,ug%eeuubCm::&&Z&cZbcud%dgugub1m::mcZcZ,cugd%dggguggggggggggggggggggggggggggggggggggggggggyppp2b******O7777777777777vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBsssssssssssssssssssssssssssssssssssssssslllllllllllllllllllllllllllllllllllllllllMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaajjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjoooooooooooooooooooooooooooooooooooooooooOOOOOOOOOO",
"NNNNNNNNNNrrrrrrrrrrrrrrrqq11n2pgcuccc#cccc#c,#ccc#,#,##,#,cccccccccc,gdeZ=k=k=c,uedzV>>>>>ccbccbccu%eue,====c=c==c=Z=c,eeegfp>5<uccu,uccuuu#bC+m:&&&+&ZcuezXguuuuuuun&+::m&&Z&&&Z,ug%uuuub+m::&ZZZZ&Z,ud%guuunb1m::+ZcZcZZued%dguggggguggggggggggggggggggggggggggggggggggggzppp#n******O7777777777777vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBsssssssssssssssssssssssssssssssssssssssslllllllllllllllllllllllllllllllllllllllllMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaajjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjoooooooooooooooooooooooooooooooooooooooooOOOOOOOOOO",
"NNNNNNNNNNrrrrrrrrrrrrrrrq1q1#ppu#ucuc#c#cccccc,#,ccccc#ccc#,ccccccccgzuu======uuud%V>>>>>ubccccccbc%geue=c=c==cZc=cccZceeeeVph$>2c,ucuu,uuu#bCmmm&&&&&Zc,g%%guuuuuuub1m::+b=&&Z&cuug%euuubCmmm&bZZZ&ccu%XgugunbC:::&bZZcZcugd%dgeggggggugggggggggggggggggggggggggggggggggggppp*nn******O7777777777777vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBsssssssssssssssssssssssssssssssssssssssslllllllllllllllllllllllllllllllllllllllllMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaajjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjoooooooooooooooooooooooooooooooooooooooooOOOOOOOOOO",
"NNNNNNNNNNrrrrrrrrrrrrrrrqyq1ppyuuuu#uu#cuc#ccccc##,ccccc,cc,#ccccccgzeu,=====uuegz%>h>>>gcccccccccce%eee,===c==c==cc=ccueeedV>5$>ccuucuuuuu#bC+mm+=&&&Zcug%VuuuuuuuubCm::C&Z&Z&&cuud%eeu#b+mmm&Z&Z&ZZuu%%guu#n1+::mbZZcZZcegd%ggggggggggggggggggggggggggggggggggggggggggggppphubb******O7777777777777vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBsssssssssssssssssssssssssssssssssssssssslllllllllllllllllllllllllllllllllllllllllMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaajjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjoooooooooooooooooooooooooooooooooooooooooOOOOOOOOOO",
"NNNNNNNNNNrrrrrrrrrrrrrrrbb1cpp@cucuuccucccuc#ccccc#cc##cccc#,#,cc,uzeu,=====ueug%z>>>f>y#cbccccccccc%gue,c===c=,=,=c,=,cgeegVV$5>uc,cuu,uuu#1C+:m&&&&&c,ug%%uuuuuueub+m::&&Z&Z&Z,ued%eueubC+m+&Z&c&c&uu%%guunb1m::+cZZZZcceg%%ggggggggggggggggggggggggggggggggggggggggggg2ppppnbb******O7777777777777vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBsssssssssssssssssssssssssssssssssssssssslllllllllllllllllllllllllllllllllllllllllMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaajjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjoooooooooooooooooooooooooooooooooooooooooOOOOOOOOOO",
"NNNNNNNNNNrrrrrrrrrrrrrrrq11#pzucuuuucu#cuccccccccc,ccccc#,#,cc,c#uzgu,=====,eued%X>>>>>#ccccccccccccgdeee,=cc=c=c=cc,,ccueeezV<5<f#cucuu,u##b++m+&&&&&c,ud%%uuueuuu#1+m::&&&=&&&,ue%%ueuub1+++&Z&ZZZZuu%Vgu#nbC::m&ZcZ,cZcgd%degeggggegggggggggggggggggggggggggggggggggggyppp2nbb******O7777777777777vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBsssssssssssssssssssssssssssssssssssssssslllllllllllllllllllllllllllllllllllllllllMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaajjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjoooooooooooooooooooooooooooooooooooooooooOOOOOOOOOO",
"NNNNNNNNNNrrrrrrrrrrrrrrrqqb2p2uuuuuuuucuc#ccccccc##,#,#,,cc,#,#cezgu,=====,euedzV>>>>>ucccccccccc,c,uXeeeu=,c=,c,=,=cZc,,geegV>$h>ucuu,uuuu#1+mm+&+&&&c,ud%duuueuuun1+::m&&Z&&ZZ,ug%duuuub&+&+&ZZ&Z&Z,udf2unn1+mm&bcZZcZceg%%ggggggggggggggggggggggggggggggggggggggggggggzhpp#bbb******O7777777777777vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBsssssssssssssssssssssssssssssssssssssssslllllllllllllllllllllllllllllllllllllllllMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaajjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjoooooooooooooooooooooooooooooooooooooooooOOOOOOOOOO",
"NNNNNNNNNNrrrrrrrrrrrrrrrbq#ppuuucuuuucucuccccuccc,cccccccccc,ccuzge,=====,eeed%%>>>X>g#cccccccc,ccccc%geee===,=c=c,,cccc,eeeeXf5;5ycuuu,uuub1+mm&&&&&Zc,ed%guuuuuuubC+::+&&&=&&c,ug%deeuu#b&+&&&ZbZZZcugy@#nb1+++&cZZcZ,cud%dgugeggggeggegggggggggggggggggggggggggggggggy>>pzbbbn******O7777777777777vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBsssssssssssssssssssssssssssssssssssssssslllllllllllllllllllllllllllllllllllllllllMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaajjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjoooooooooooooooooooooooooooooooooooooooooOOOOOOOOOO",
"NNNNNNNNNNrrrrrrrrrrrrrrrqq@pyuuuuuuuuucucucucucccccccccccc,#c#uyge,c=====euegd%X>>>>zccccc,c,ccccc,ccg%eee,Z=cc,cc,=,,c,c,eeggf<h<>uuuuuuuunC+mm&&&&=Zc,e%%guueuuuub1m::&&&&&&Zcuud%geeuuub&+&&&ZZbZZcuuu##b1&&&bZcZcZccue%%ggggggggggggggggggggggggggggggggggggggggggggypph#bbbb******O7777777777777vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBsssssssssssssssssssssssssssssssssssssssslllllllllllllllllllllllllllllllllllllllllMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaajjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjoooooooooooooooooooooooooooooooooooooooooOOOOOOOOOO",
"NNNNNNNNNNrrrrrrrrrrrrrrrqnppguuuuuccuuu#u#ucuc#cc#cccc#cc#cccuygeuZ=====euee%dX>>>>>uc#,c,ccc,ccc,c#,c%geeec,=,=,=c,,=,,,,deeef>$5>guuuuuu#bC+mm&&&&&Z,,g%Vuuuuuuuub+m::&&Z&=&Zcued%geeuuucb&&&&&ZZbZ&c##cbbbb&&Zc&cZZ,,eg%%ggggggggggggggggggggggggggggggggggggggggggggzp5ppbbbn******O7777777777777vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBsssssssssssssssssssssssssssssssssssssssslllllllllllllllllllllllllllllllllllllllllMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaajjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjoooooooooooooooooooooooooooooooooooooooooOOOOOOOOOO",
"NNNNNNNNNNrrrrrrrrrrrrrrrnypyuuuuuuuuuuuuuuuuuu#u#u#uu##c##cuydee=======uued%%>>f>hyc#cccc#cuccc#c#c#ccgzgeeuc,cZ,=,c,c,,,,,ggeVf><5>guuuuu#bC+m+&&&=&c,ug%zuuuuuuuu1+m:m&&&&Z&Z,ug%%ggggggg#b&&&&&ZZZZbbcbZcZbZbZc,Z,,eeddggggg2gg2ggggggggg2gggggggggggggggg2ygygggyg2zpppubzbbn******O7777777777777vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBsssssssssssssssssssssssssssssssssssssssslllllllllllllllllllllllllllllllllllllllllMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaajjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjoooooooooooooooooooooooooooooooooooooooooOOOOOOOOOO",
"NNNNNNNNNNrrrrrrrrrrrrrrr#*ppppfpppfp>ppppppf>zfpppf>>fpppVfzdeuc======ueegd%X>h>>h>pp>>fppppp>ppppppfpfzgeeec,,=,,,c,c,,,,,uegzffh<>>5>pphu1++m&+&&&&,,ud%Vppppzzpp&+::+&&Z&Z&Zuug%V>pzpppz2cbZ&&&&Z&ZZZcZ&ZZZZZZZZ,,eegd%Vpppf>pp>pppppppppz>pzppzpV>zzfpzp>ppppppp>Vpppphbbzbbb******O7777777777777vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBsssssssssssssssssssssssssssssssssssssssslllllllllllllllllllllllllllllllllllllllllMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaajjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjoooooooooooooooooooooooooooooooooooooooooOOOOOOOOOO",
"NNNNNNNNNNrrrrrrrrrrrrrrr#@@u@uuuu#uuuuuuuuuzuuuuuuuuzuuuuyzdeuc======,eee%%V>>>>>fyuuyzuuuuuuuuuuuuuuuug%eeecc=,,c,,,,,,,,,,gegVf<5 ;  5@unb++m+&&&=&c,udzguuuuuuu#C+::&&Z&Z&Zcuud%g%u@uuuuzucZZ&Z&&c&Z&ZZcZZZ,,Z==,eeg%%uuuuupuuuuuuuuu@uuuuuuuu@uuufuuuuuuuuu@uuuufuuu@@ubbzbbb******O7777777777777vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBsssssssssssssssssssssssssssssssssssssssslllllllllllllllllllllllllllllllllllllllllMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaajjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjoooooooooooooooooooooooooooooooooooooooooOOOOOOOOOO",
"NNNNNNNNNNrrrrrrrrrrrrrrrqqq1111b1b1q111111bgb11q1111g11cuzgeu,===b==ceeedd%>>>>>hhz#cy2bb11+1C1+11111+1czgee,c,,,,,c,,,,,,,,eggzVf<; ;$<h@nC++m&&&&&&c,ed%ub11b111n+mmm&&&Z&Z&ceed%z&bb1bb1yb##&C&&c&&ZZZZZZ=====,,eedd%c11b1bzbb1b1b1bbbbbb1b1qbqbbbzbbbqbqbbbbq1bqbzbb1qbbzbbbn******O7777777777777vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBsssssssssssssssssssssssssssssssssssssssslllllllllllllllllllllllllllllllllllllllllMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaajjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjoooooooooooooooooooooooooooooooooooooooooOOOOOOOOOO",
"NNNNNNNNNNrrrrrrrrrrrrrrrbqq1bqbq11qqy1qq111g1111q+qgg#ugzgeu,==c=c==eeee%%>>>>>>>hfh>>f>>fyc1g11C11qugzXzdeec,,=,c,,,,,,,,,,,gggX%f<;$$hh2n1++m&&&&=Zc,ud%u1111111bCm:m&&Z&ZZZcue%%yy1Cbbbny&n#bbm::+&Z,Z======,,eeed%uzbbb1b1bzCbbbbbbqqbb1bp1bbb1bbbzbbbqbzbbbbbbbb&zbbbzzbbbbn******O7777777777777vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBsssssssssssssssssssssssssssssssssssssssslllllllllllllllllllllllllllllllllllllllllMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaajjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjoooooooooooooooooooooooooooooooooooooooooOOOOOOOOOO",
"NNNNNNNNNNrrrrrrrrrrrrrrrq1111111b1b1111111y111111cuuf%zygeu,c=c====ueeee%X>>>ff>ff>f>ffhfh>#+C+C1#gy>>fXzdee,=,,,,,,,,,,,,,,,ugggVpf>55hh2bC+m+&&&=&Zc,g%V#b1111b1n+mm+&&Z&Z&Z,ug%gdb1buu@gubnnbC:::CZZce,,,,,eeeed%%#bz=bqbqbbzbb&b1qb1b1bbb1bb1bb1bbz1bbb1bbbbbbbbbbb%zzzbbbbbb******O7777777777777vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBsssssssssssssssssssssssssssssssssssssssslllllllllllllllllllllllllllllllllllllllllMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaajjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjoooooooooooooooooooooooooooooooooooooooooOOOOOOOOOO",
"NNNNNNNNNNrrrrrrrrrrrrrrrnb11b1b1q11b1b11y1g&1cuuypzzzzgeeec=c==c=cceeeegzVVppff>f>fffhhfhh>b11b#gffppzzzzgee,,,,,,,,,,,,,,,,c,gggg%%ppfffhfuub&&&&&&Zceg%XbC111bC1n+mm+b=&&Z&Z,ug%uycu2@###ub#bCm::mb&Zuueueueegd%gucb11zbbbb&bzzzzzbbb1bbbbbbb1b1bb1bz&bb1bbbbbb1b1bbCbbbbbbb1qq******O7777777777777vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBsssssssssssssssssssssssssssssssssssssssslllllllllllllllllllllllllllllllllllllllllMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaajjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjoooooooooooooooooooooooooooooooooooooooooOOOOOOOOOO",
"NNNNNNNNNNrrrrrrrrrrrrrrrqyq1yqby1by1y11ygyyygzzyyzyzygeeu,=ccc=c=c,geeegzyyyyyyyzzzfh>>>>>f1Cygzzzyzyyyygeee,,c,,,,,,,,,,,,,,cgggggz%zzzzzzzzVz&&&&=c,ug%dy11ybCybb+mm&&&=&&Zcuug%yg2@u##nu22#b1:::CZZZ,uuuuggdd%V#by1bzz&bbzbbzbbzqzzqbzbbz1zb1zqbzbbzzbzbbz1zbbpbqp1bzb1zbbzbbb******O7777777777777vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBsssssssssssssssssssssssssssssssssssssssslllllllllllllllllllllllllllllllllllllllllMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaajjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjoooooooooooooooooooooooooooooooooooooooooOOOOOOOOOO",
"NNNNNNNNNNrrrrrrrrrrrrrrrqqb1qb111q1b1b11ygyzzzyddggeeeeuccc=c=c=cc,geeeegggdddzdzzzV>>>>h>ggbgzzzdgdgggeeeee,,,,,,,,,,,,,,,,u,,dgggggddzzz%zzfg&&&&&,cud%gCbCb1bbbb+mm&Z&&ZZ&cuegzgu##nnbndynnb+::m&ZZZcuc##uuggyzfy#1bbzb1bbCz&b1b1bzb&b1bqb1bb1bb11b1zbb1bbbbbbbbb1bbbbbb1bbqbn******O7777777777777vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBsssssssssssssssssssssssssssssssssssssssslllllllllllllllllllllllllllllllllllllllllMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaajjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjoooooooooooooooooooooooooooooooooooooooooOOOOOOOOOO",
"NNNNNNNNNNrrrrrrrrrrrrrrrqqq1b11bq1q1111bgyzzgeeeeeeeee,c=c=c=c=cc=cgeeeeeeeeeeeeed%V>>>>>huCgzgeeegeeeeeee,,,,,,,,,,,,c,,,c,,,,,ggggggggggggV>u&&&&Zc,ud%g111111bbb+mm&&&Z&Z&,,u%uunnbnbbu%y@n1Cmm+ZcZccZcc####ug22*pyn1*b&bbybbbb1bb1zbbb1bbb1b1bb1b1bbz&bb1bbbbbbbbbbqbbbbbbbqb******O7777777777777vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBsssssssssssssssssssssssssssssssssssssssslllllllllllllllllllllllllllllllllllllllllMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaajjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjoooooooooooooooooooooooooooooooooooooooooOOOOOOOOOO",
"NNNNNNNNNNrrrrrrrrrrrrrrrbq1q1b1b1q11y11bygzzegeeeeeuc,,=cccc,ccc=ccc,ueeeegeeeeee%%>>hh>hf#Cy%eeeeeeee,uu,,,,,,,,,,,,,,,c,,,,cu,,uegggdgggggV>#&&&=Zc,ed%ub111111nb+m+&&&&Z&Zcuuu#cbbb&&#gzg##&+mm&&ZZZZZZccc####uu22ypyzbb1bz&yb1q1bbz&bbqb1zbbqbbb1bbbzb1bzbb11q1bbb1bqbzbbbqbb******O7777777777777vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBsssssssssssssssssssssssssssssssssssssssslllllllllllllllllllllllllllllllllllllllllMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaajjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjoooooooooooooooooooooooooooooooooooooooooOOOOOOOOOO",
"NNNNNNNNNNrrrrrrrrrrrrrrrqq1q11q11q11b11Cyyzggu,c,ccc,cZ,c=c=ccccccc=,c=cZ,c,ugeeg%%>>>>h>>bCydeeu,,,,,,,,,,,,,,,,,,c,,,,,,,c,,,,,u,,u,,ugggdXVc&&&&Z,uu%V#C111111n1++&&&Z&&Z&cu#bbbb&&bbugz#nb&b+++,ZbZZZZZcccc##u#uug2z>ub1bybbbbbbbCz1b1b1bbb111bbq11bzbb11bbbbbbb1bqbqbbbbbqbb******O7777777777777vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBsssssssssssssssssssssssssssssssssssssssslllllllllllllllllllllllllllllllllllllllllMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaajjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjoooooooooooooooooooooooooooooooooooooooooOOOOOOOOOO",
"NNNNNNNNNNrrrrrrrrrrrrrrrqbq1b11q1qb1111byy%gg,,ccc,ccc,cc,cccc=c=c=,cc,cccZZeeeeg%V>>>h>>g=Czyee,,Zc,,,,,,,,,,,,,,,,,,,,,,,,,,u,u,,u,u,ugggdV>&&&&=ZcegzVbb111111nbC+C&&&&Z&ZZccb&b&&&&cegubbbC&&+&ZZZbZZZZZZ&cccc#u#uu2ypb1bzb&bC1bbbzbb1bbq=bqb1bbbbb1bzbbbbqb1bbbbbbbbbbbqbqbb******O7777777777777vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBsssssssssssssssssssssssssssssssssssssssslllllllllllllllllllllllllllllllllllllllllMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaajjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjoooooooooooooooooooooooooooooooooooooooooOOOOOOOOOO",
"NNNNNNNNNNrrrrrrrrrrrrrrrbqq11111q11byb1byy%ggeeeeeeeeeeeeeeeeeeeeeeeeeueeueeeeeed%V>>>>y#b1g%gegueeeeeeeeeeeeeeeeeeeeeeeeeeeegeeeeegeeeggdgdXg&&&&&,,eg%gCCb11111nbC+&Z&Z&&Z&&ZZ&b&&b&cuugb&&&C+++&&ZZZZZZZZcZZZcccc##uug2znb&zybbbbCz&1bbb11zb1bqb1bbqbbzbbz1bqbbqbbbqbb1zbbbqbb******O7777777777777vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBsssssssssssssssssssssssssssssssssssssssslllllllllllllllllllllllllllllllllllllllllMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaajjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjoooooooooooooooooooooooooooooooooooooooooOOOOOOOOOO",
"NNNNNNNNNNrrrrrrrrrrrrrrrn1bq1bq1bqqb11bCyzzggggggggggggggggggggggggegegggggeggggzzf>>gy11CgczgggggggggggggggggggggggggggggggdgdggggdgggdgggVVu&&&&&,,ud%gq&b11111bbC&&&Z&=&Z&Z&&&&&Z&ZZuu#++++&&bZZZZZ&bZZZZZc&cZZccc##uugzzbb1z&bCbz11bb11bbbbq1bbq1bbbbzb&bbbbqb1bbbb1bbbbqbbbb******O7777777777777vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBsssssssssssssssssssssssssssssssssssssssslllllllllllllllllllllllllllllllllllllllllMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaajjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjoooooooooooooooooooooooooooooooooooooooooOOOOOOOOOO",
"NNNNNNNNNNrrrrrrrrrrrrrrrqbq1b1b11111bb1by#fVVXXXVXXVXVXXXXXVXXXXXXXXXXXXXXXXVVVV%%>ucC1ggg1#zVXXXXXXVXVXXVXVVXXVXXXXVXVXXXXXXXXXXVXXVXVVVVVV>c&&&&=,,ed%u11111b11nb&&&&&Z&Z&Z&ZZZZ&&ZZZ,u+m++&b&ZZZZ=&,ZZbZcZZcZZbZZccc#uu2zybbCzzzy11bb1bb11b1bb11bqbbb&bzb1bb1bqbqb1bbb1b1bbqbb******O7777777777777vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBsssssssssssssssssssssssssssssssssssssssslllllllllllllllllllllllllllllllllllllllllMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaajjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjoooooooooooooooooooooooooooooooooooooooooOOOOOOOOOO",
"NNNNNNNNNNrrrrrrrrrrrrrrrqqqq1b111qqby1yyyy######cy#z#c###########y#c#y####c####y##c11111111b#y##c####c######y##du#c##c####cy#cc##c#######ccbZb&&&=Z,,g%Vb11b1111b1#&&&&Z&Z&Z&ZZZ&ZZZ===,&:m+&&ZZZZ==Z,,ZZZcZZZZcZZZcZZcc#uudfubzb1bbbb1b1b1bbzb1bbbbbb1b1bzbzbbbqqqbqbbqbbzbbbbbb******O7777777777777vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBsssssssssssssssssssssssssssssssssssssssslllllllllllllllllllllllllllllllllllllllllMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaajjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjoooooooooooooooooooooooooooooooooooooooooOOOOOOOOOO",
"NNNNNNNNNNrrrrrrrrrrrrrrrbqbb1b1bq1b11y1yCby11q11qyq1111q1111q11111111g111111111gC11111C11C11111+11C11C11C11111C1gCb1C111111C1C111+11111nb1+++&&&&=Z,ug%g11CbbC111&#b&&&&Z=&ZZ&ZZZ====,,+::+&bZZZ==Z,e,,cZZZZZZZZZcZZcZZ,c,ugzhcbCbb1b1q1qbbb1qb1b1b111bbbbbz1bb1bbbbbbbbbqbqbqbqn******O7777777777777vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBsssssssssssssssssssssssssssssssssssssssslllllllllllllllllllllllllllllllllllllllllMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaajjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjoooooooooooooooooooooooooooooooooooooooooOOOOOOOOOO",
"NNNNNNNNNNrrrrrrrrrrrrrrrqqq1bq1n1q1y11bC1b1qybq11yq1q111q1q1111111111gCb1111q11CyC111+111111111111C11C1C111CC1Cgggg11C111111111111+1111n1C++&&&=&&,,ed%c1111b111bb&#cbZZ,,,,,c,,,,eeem::m&&&ZZZ,eeeddguccc,ZcZZZZZZZZ,c,cZuugzX&1bC1bbb1bbb1b11b111b11b1bbbbzb&zb%%zzzzb1bbbbb1bb******O7777777777777vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBsssssssssssssssssssssssssssssssssssssssslllllllllllllllllllllllllllllllllllllllllMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaajjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjoooooooooooooooooooooooooooooooooooooooooOOOOOOOOOO",
"NNNNNNNNNNrrrrrrrrrrrrrrrbqbq1bb1qbbybb11b111y1bbyb1b1b11111111111111Cy1&1111111&gCbC1b11+11C1111=1q=111C1111bCbCgygCCb11111Cb11111CbCbbbbC++=&&&&Z,ugzg&1b11b1b111quuuccccc,c,,,euegu:::&bZZZZ,,egdducuu,cccc,,ZZZZcZcZZZZuugdf#11bbb11b11qqbbb1bb1bbbb1bCb1zbbzbbbbb1bb1bbbb1bbc******O7777777777777vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBsssssssssssssssssssssssssssssssssssssssslllllllllllllllllllllllllllllllllllllllllMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaajjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjoooooooooooooooooooooooooooooooooooooooooOOOOOOOOOO",
"NNNNNNNNNNrrrrrrrrrrrrrrrnyqqyq1zq1yyy1by1qy1yy11yC1y111by11y11gq1g11yy&gCgq1g11ggbg1b211g1211gCb211g1bg111g12C&ggggb&211gb1y11uuyq1yCbub1C++&&&=&Z,ed%#y1by11yb1y111#uuuu,uuuueggddu&::+&ZZZZZ,eed%u1ybuuu,cccc,cZZZZ,ZcZccuggV%qbzbbyb1zb1zbzqbz1bzq1zqbzb&z1zbbzbCzbbzb1zb1pbbb******O7777777777777vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBB6t6BBBBssssssssssssMMssssssssssssssssssssssssssllllllllllllMMlllllllllllllllllllllllllllMt96MMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaajjjjjjjjjjjjjjjjjjjjjj696jjjjjjjjjjjjjjjjoooooooot96ooooooooooooot96ooooooooooooooOOOOOOOOOO",
"NNNNNNNNNNrrrrrrrrrrrrrrrqq11q1bqb1q1yb111q1yCb1by1b1q1111q1111111b11bg1b1b11q11CyCq1C1111111C11111111C111Cb1b111CggCbCb11C1111yy**2#n1nbC+++&=&&&,,e%gbbb1b11b111b111bugggggddddguub1mm&ZZZZZc,eg%gbb1bbbugu,,c,cZZZZZc,Zc,ugdVu1bCbbbbb11bqbbb1bb1qbb11bbbb1zbbbbbbb1bq1qb1bbqqb******O7777777777777vvvvvvvvvvvvvvvvvvvvvvvvvvvBww   ;BvvvvvvBBBBBBBBBBBBBBBBBBBBBBB;;BBBBBBBBt; MBBBBsssssssss6w; Mssst;  tssw;  9sss6    6sslllllllll6w; Mllt;  tlllw;  9llw;  9lllll9  MMMMMMMMMMMMMMMMMMMMw;  w;MMMMMMMMMMMMaaaaaaaaaaaaaa; aaaaaaw;  w;aaaaaaaaaaaajjjjjjjjjjjjjjjjjjjjjt; 6jjjjjjjjjjjjjjjjoooo;;o9  ooooooooooooot; oooooooooooooooOOOOOOOOOO",
"NNNNNNNNNNrrrrrrrrrrrrrrrqqqbb1qbq1b11yb1bbyqb11Cyb1q11b1qbb1q11q11b11y11111111b1g111111111111b11111111111q1111b&1yggCbC1b111n#@222yy*2n+C+++&&&&=,ed%ubC&111111bb111bCb&b###c#zb&bnbC++&ZZ&ZZZuug%g&b1q1bbCuuuuccZZ&cZcZcZZeedzgbbbCbb11bb1cb1bb=bbb11bb1bbbbzbCbb11bbb1bb1b1bbbb******O7777777777777vvvvvvvvvvvvvvvvvvvvvvvvvv6 ;vvBw;vvvvvvvBBBBBBBBBBBBBBBBBBBBBBB;wBBBBBBBBB;;BBBBBss6wsssssst ;ssst 9s ;sw Ms  sssw   ;sssllllllllllt ;llt 9l ;llw Ml  lw Ml  lllllj wMMMMMMMMMMMMMMMMMMMw jMjwwMMMMMMMMMMMMaaaaaaaaaaaaaaw;aaaaaw jajwwaaaaaaaaaa6wjjjjjjjjjjjjjjjjjj6wjj;;jjjjjjjjjjjjjjjjjoooo;woo woooooooooooooo ;oooooooooooooooOOOOOOOOOO",
"NNNNNNNNNNrrrrrrrrrrrrrrrbbbq1qbqbq11yqyyyyq1b11byb1y1b1b11111111qg111y11q111b11yg11111111q111g111111111111112b111&ggC111111gbb#uu@@@2@b1+++&&&&==,g%gb&y1b1q1b1111bCby1bbCb&b1byyyubC+&&ZZZ&ZZ,eg%Vu1qb11&bbbuuuc&&&&cZZZZ,ugg%Vb1bb11bbbbbbbyb1bbb1bb11b1&bz&bbbb1bbbbbqbzbbb1bb******O7777777777777vvvvvvvvvvvvvvvvvvvvvvvvvB; MvvvvwvvvvvvvBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBB6 wBBBBBst tssssss9 wsss; ts; s  ts  ssM;sssssssllllllllll9 wll; tl; ll  tl  l  tl  lllll9 9MMMMMMMMMMMMMMMMMMM  9MM69MMMMMMMMMMMMaaaaaaaaaaaaaaaaaaaaa  9aa69aaaaaaaaa9 9jjjjjjjjjjjjjjjjj9 9j6 wjjjjjjjjjjjjjjjjjooooooo9 9ooooooooooooot woooooooooooooooOOOOOOOOOO",
"NNNNNNNNNNrrrrrrrrrrrrrrrnq1bbq111bqq1b1q111q11by1111b1q1111111q111b11yCb11111111&y111111111111b11111111111111C1111gdbCb111bnq1bnn##uun+Cmm+&&&&==eddubbCb111b111b1bbb1bbCbb11bCbbbbb1&&&ZZZZZZ,uudf>y#q1bq##uuu#bb&C&ZcZ,ccugd%ubbCbb1b=b1bbbb&b111bb1bbq1bb1bbb&bbq1bb1bbb11bbqb******O7777777777777vvvvvvvvvvvvvvvvvvvvvvvvv9 wvvvvvMvvw; ;6B9w;t; 69;wB;;Btw;t;w9w;tBt;    t9 9t ;BB;   ssssss; tsss  Ms  s;  9 tssw  wMssssllllllllll; tll  Ml  ll;  9 tl;  9 tlllllw w  9M9;wM;;MMMMMMMMMw  9MMM9w;wM9;6M9w;9; 6aaw; ;6atw;9aaaaaw  9aaa9w;wa9;6;   jjw;wwwjow;99 ;j;   j9 99 ;jjjjw;www9;wjw;o9w;tow w  9o9w;wo9;tow toooooooooooooooOOOOOOOOOO",
"NNNNNNNNNNrrrrrrrrrrrrrrrbqbqqqqb1q111b11b1q11b1y11b11q1q1q11111b111bCyb111q11q111y1111111111111C111111111111111Cb1bgyygy11n11m1&bbbnnbC+mm&&&&==Ze%gb&CbCb1111111CbbCbCb1b111bq&b&nb1&&&ZZZZZZcuugyp<fp22@2@@unn1+:m+ZZZZZ,egd%#&bb1b1b1b1b=b1b1bbbb1b1b1b1bbbzzz11qb1b1bb1b1qbbb******O7777777777777vvvvvvvvvvvvvvvvvvvvvvvvv; tvvvvvvvw;BB ;BB; 99 wl ;Bw BB; w;wB; Bt wB  BBw 96  BBs ;sssssss  ssss  st ;s6   Msss9w  wssssllllllllll  lll  lt ;ll6   Mll6   Mllllll; 96  Mj ;Mw MMMMMMMMMMw  wMMM; 6M; MMM; 99 waw;jj ;aaw 6aaaaaaw  waaa; 6a; aa ;ajw;o  9jjw 9t  jj ;jjw 96  jjjw;o  9j ;jw oo; oo; 9t  oo; to; oo; ooooooooooooooooOOOOOOOOOO",
"NNNNNNNNNNrrrrrrrrrrrrrrrqbqb1bq11bqby1bbb1b1b11y111ybqqb11b11b111y11byCb1111111y1y11111111111yC1111111111111g11bCbCyCb1byn1+m:&&&&bbbbmmm+&=&===,d%c11byb11111b11111byb1b&qb111111bn&&&&ZZ&ZZZ,,uuuyy*y222@u##nb1::m&ZZc,,,eg%zzb1b1b11b1bb11z1b1b11bb1bqbb&zz&bbzbbqbqbbbzbbbbqb******O7777777777777vvvvvvvvvvvvvvvvvvvvvvvvv  Mvvvvvv9 wvM  BM ;Bt wBw llwBl ;tlll wBw 6B  BB  9l ;BB6 wsssssst wssssw Mw 9M;;w wssssst  sssslllllllllt wlllw Mw 9lM;;w wlM;;w wlllll6 ;MM  MMw jjwMMMMMMMMMMMw  wMM;;M6 wMM6 ;at w9 wa6  aa; aaaaaaaaw  waa;;a6 wa6 wat wo  6jj; 9o ;j6 wjj  9o ;jjt wo  6j; jowoo wot ;oo  oo;;o6 woo wooooooooooooooooOOOOOOOOOO",
"NNNNNNNNNNrrrrrrrrrrrrrrrnbbbq1q1qqqq1b1b1q1q1bbybbbqq111b11111q1b1b1Cyb1q1q1q1b1Cy111111q11111111+111111111111111Cybgb1Cbb1+m:&C&&&&&&mmm+&&===Zedeb111111b1b1111b1bb1111b1b11bq1bbnb&&&ZZZ&ZZ&,#uuug@g@uuu#nnbb+::+Zc,,,Zuegdgbb1bCbb1b11bq11bb1bb1b1b11bbbzbbb&bz&bq1bbbbbbqbbq******O7777777777777vvvvvvvvvvvvvvvvvvvvvvvvv  vvvvvvv; tv9 ;B9 9Bw 9Bw t9tBt wBBBt 9Bw M6 wBt ;B9 wBBw tssssssw 9ssss6;  ;M; 6M  ssssss  st       tlllw 9lll6;  ;Ml; 6M  l; 6M  lllll9 9M9 wMMw t9tMMMMMMMMMMMMw  M6 wMw 9MM9 9aw 9; ta9 ;aj waaaaaaaaaw  a6 waw 9aw 9aw tt ;jj6 ;j9 wjw 9jt ;j9 wjjw tt ;jj; jwoo9 9o9 9o9 wot wow 9o9 9ooooooooooooooooOOOOOOOOOO",
"NNNNNNNNNNrrrrrrrrrrrrrrrq1q1qbb1b1bbb1b1qb1bb11yCb1b1bbq11q11q111111byCb1111111bbg1b111q1111bb=q111111111111bbC11y11C1Cbbn&+m:&&+C&&&&m:m&=&===,ed#11qbb1b1b1b1b1111Cbbb&b1b1bC111b#b&&&bZZZZ&Zbc,###uu#u#nncbb1C++&ZZZ,Zcegdzu11bbb111b11b1qbb1b11b=b1b1bbzbb1qbb&zbc1q1bbCbbqbb******O7777777777777vvvvvvvvvvvvvvvvvvvvvvvvv; BvvvvMv  Mvw tBw MB; lBt wwBBw tBBBw MBB;; wBBw 9Bw 6BB; 6ssssss; 6sssssM; 6s  ss  ssssss ;sssslllllllll; 6llllM; 6ll  ll  l  ll  lllll; MMw 6MMt wwMMMMMMMMMwMMMj  Mw 96  6MMw 6a; j  6aw 9a9 9aaaaawaaaj  aw 96  6a; 6a  j9 9jj9 9jw tj; 6jw 9jw 6jj  j9 9jj; 96oow 6o; oow 6ow 96  6ow tooooooooooooooooOOOOOOOOOO",
"NNNNNNNNNNrrrrrrrrrrrrrrrnbbb1qqbqq11y1qbbb1q1bybb11y1bqb11bb111qqyb11yb11qb11b1yCy1111111b1bCy11111111111111y1Cb1yCbbb11nbC+++&&&&&&C&+m&&&===,edc11111yb111b11111bb1yC1b1bCb11bbbC#n&&&ZZZZZZZZZccc##cncncbbb&b&+&ZZZZ,,,gdzu1zbb=bb1b11qb1bz=b1b1b1bqb1bbzzbqb1bbz1qqbb1zbbqbnb******O7777777777777vvvvvvvvvvvvvvvvvvvvvvvvvw wBvvwtv  v6 wvB;;B9 tBBl  tBB; BBBB; 6t;;tlBBB; lB  t6B  t6ssss6 ;sssssM;;6ss; M6 wsM;9s9 6ssssllllllll6 ;llllM;;6lll; M6 wl; M6 wlllll  M9 9MMMj  tMMMMMMMMM;wMMM wM; j9  96M;;M9 9a  a6 waaw 6aaaaa;waaa wa; j9  96  96  o; 69jw 6j  t6  96; oj  96j  o; 69j; 9joo; tt  o9 9oo; o9  96; ttoooooooooooooooOOOOOOOOOO",
"NNNNNNNNNNrrrrrrrrrrrrrrrqqqqbq1q1bbqbb1qqqbb1qy1b1bb1bqb1111q1q11qq11yb=q1111111b1y1111q11b11111111111111q1111b1&y1CCb11#bC&+&&&&&&&&&&+&====,ed%&1q1b1b11bb=b11b1b1bbbb1bb11b1bC1b&#b&&ZZZZZZZZZZccccccbbbb&&b&&&ZZZ,,,ceg%gbbb1b1bb=b1b1bb11bbbb11b1b1bb&z&1qqbb&zbb1qbqb1b1bbb******O7777777777777vvvvvvvvvvvvvvvvvvvvvvvvvvw; ;wtvvt; ;tvvM   ;tBBBB wBB6 wBBBB; 9Bw   ;tl;wBB  9BB ;6ssss9;  9MsMw;9Msss6;  wMsM;  w6ssssslllllll9;  9MMw;9Mllll6;  wMl6;  wMlllll;  w6MMMMM wMMMMMMMMMM;;  ;wjM; wM  9M6   ;taa9; ;9aaa; aaaaaa;;  ;wja; wa  9a ;6aw w; wojwwjj  9j ;6o;wjj  9jjw w; wojw6jjoo; 9o;  w6ooo; wo  9o; 9ooooooooooooooooOOOOOOOOOO",
"NNNNNNNNNNrrrrrrrrrrrrrrrbbbb1qqb1qqb1qb1bb11b1yb1b11b111q1b11111q1bb1yb1q1qb1b1111y1b1b11111b1111111111bb111bCb11ybbbC1b#b&&C&&&&&&&&&&&&===,egde1b111b1111111b11111CbbCb11b11bCb11q#c&Z&ZZZZZZZZZZZZcccbb&ZbZ&&cZcZZ,Z,eed%cb1b1b11b1bb11b1bb1b11b1bb11q1bzbbbq1bbzbbbqbq1bbbbbb******O7777777777777vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv9 9BBBBBBB;lBBBBBBBBBBBB9;6t;  BBBBBBBBBBsssssssssssssssssssssssssssssssssssssssslllllllllllllllllllllllllllllllllllllllllMMMMMMMMM;jMMMMMMMMMMMMMMMMMMMMMMMMMM9 9Maaaaaaaaaaa6 waaaaaaaaaaaaaaaaaaaaaaaaaajjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjoooooooooooooooooooooooooooooooooooooooooOOOOOOOOOO",
"NNNNNNNNNNrrrrrrrrrrrrrrrqqqqbqb1b1bqybbq1q1bqby111by11b1q1q1qb1q1y11byCb11b1b11y1byCb111q1b11y1111111111111bybC11bgCb1b1nn1&&&&&&&&&&&&&===,eg%gcbCb11&y1b1b11111b1b1y1bb=b1b=b1b111ycZ&ZZZZZZZZZZZZZZZZZZbZ&ZZZZZ,,,Z,eeg%%b&byb1b1b11b1bb&bzbbb1bbb=bbb1bbz1bbbbzbb1b11bz1b11bb******O7777777777777vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvw lBBBMwtw6BBBBBBBBBBBBB  lBl ;BBBBBBBBBBsssssssssssssssssssssssssssssssssssssssslllllllllllllllllllllllllllllllllllllllllMMMMM6w9w6MMMMMMMMMMMMMMMMMMMMMMMMMMMw jMaaaaaaaaaw9w 6aaaaaaaaaaaaaaaaaaaaaaaaaajjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjoooooooooooooooooooooooooooooooooooooooooOOOOOOOOOO",
"NNNNNNNNNNrrrrrrrrrrrrrrrqbqbbqb1bb1b11bqbq11b1ybqb11bb1bb111b1bq1b11Cy&bq1qq=b1b11gb11111b1111111q11b111Cb1b1Cb1bC1y&bCbgn&b&&&&&&&&&&&==Z,ee%%b1bb11b11=b11b1bb11bb11bCb11bb1b11bqbCuccZZZZZZZZZZZZZZZZbZZZZcZZ,ZZZ,,eegduz&bbb1b1bbbb1bbbq1&bb111=bqb11q&b1z&b&zbbb11bb1bbbbbqn******O7777777777777vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv;   BBBt ;6BBBBBBBBBBBBBBt;  ;wlBBBBBBBBBBsssssssssssssssssssssssssssssssssssssssslllllllllllllllllllllllllllllllllllllllllMMMMM9 ;6MMMMMMMMMMMMMMMMMMMMMMMMMMM;   Maaaaaaaaa;;;9aaaaaaaaaaaaaaaaaaaaaaaaaaajjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjoooooooooooooooooooooooooooooooooooooooooOOOOOOOOOO",
"NNNNNNNNNNrrrrrrrrrrrrrrrqbbqb1qbqqnbb1qq1bb11z11qb1111111b1b1111b11bbybC1b111b1111ybCb1b11b11111b11111b11b11bb111b1byyyybubb&&&&=&&&&ZZZ,,eg%%%CbbCbb1b1b1111b111b111b11b1b=q11b11b1bgu#ccZcZZZcZZZZZZZZZZZZZ,,ZZZ,,eeegdgbz1bb1b1b1&1b1c1b=1qb&bb1b11bbbbb1bbzzzbbb1bb1bbbCbbbbb******O7777777777777vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBsssssssssssssssssssssssssssssssssssssssslllllllllllllllllllllllllllllllllllllllllMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaajjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjoooooooooooooooooooooooooooooooooooooooooOOOOOOOOOO",
"NNNNNNNNNNrrrrrrrrrrrrrrrnzbqzbqz1qzqzqbyb1ybbybby1by1bbby1qybbybqybyyydzbyqby11yq1y&bybqy1yb1yb1y1qy1qy111ybgb1yb1y1Cyb1yu#bb&&&&&=ZZ,,,,eddd%dyby1byCby1qy1byb1ybbbby&byb1y1by1by1byzdu#cccccZcZZZZZZZ,ZZ,Z,ZZZ,,eeeg%dg#&zybCzb1yq1z1byb1zbzb1z1bzbbz11z1bzbzCbzb1zbbzb1zbqz1qb******O7777777777777vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBsssssssssssssssssssssssssssssssssssssssslllllllllllllllllllllllllllllllllllllllllMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaajjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjoooooooooooooooooooooooooooooooooooooooooOOOOOOOOOO",
"NNNNNNNNNNrrrrrrrrrrrrrrrbbqqbqq1qbqbbbqqbqb=byb1bb1q1bbbbbbq1q1b11b1ydyb1b11bCb1q1Cyb1111b11b1111q111b111111b1111111Cb1b1b#u#ccccc,ceeegd%ub&ydb11b1&b1111bq=bbb11b1b1b=b1cb1=b11b1&bb&bCuguu,,,,,,,,,,,,,,e,eeeegdddubbbb1bz&1b=11b11bbb1=b1bb1b1bbbbbb11b=b1bbCbb&bb11b1bbb1b1n******O7777777777777vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBsssssssssssssssssssssssssssssssssssssssslllllllllllllllllllllllllllllllllllllllllMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaajjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjoooooooooooooooooooooooooooooooooooooooooOOOOOOOOOO",
"NNNNNNNNNNrrrrrrrrrrrrrrrqbbqbqqbqqqqy1bb1bbbby1bqqbyb1q111q1bb11by1byyyb111b1bCyqb1yCbbb111b1yb111qb11b1b1b1yq111b11b111bC1ygu,uu,uuegdduy&1bdyb1bq1q1byqb11bb=1bb=1by1q11111bb1b1bbyb&bbCbugueuu,u,u,eueuueeegd%dgub1bb=bb1ybbzqbb1bbb1bb1bbz=bbb=b1bb1bb1bz11bbb1b11bb1bz1bbbbb******O7777777777777vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBsssssssssssssssssssssssssssssssssssssssslllllllllllllllllllllllllllllllllllllllllMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaajjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjoooooooooooooooooooooooooooooooooooooooooOOOOOOOOOO",
"NNNNNNNNNNrrrrrrrrrrrrrrrqnbqbbbqbbq1qbbqqb1qybbqqb1qqbbbqqqb1qbqqb1byyy11bb11bbqb11y1q111qq1q11qbq1q1qq1q1qqq1bqq1b1111b1b11bggguggdzgu#b111byyb1qbb1b11b11b11qq11q11q1b11b1q111bCbC1bbCbbb1c#udggggggggggdddzdu#cbbb111b1bbz&bb1b1b111bb11bq1bq11qbq1111q1q1bb1b1b1bqbbqqbb11bqb******O7777777777777vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBsssssssssssssssssssssssssssssssssssssssslllllllllllllllllllllllllllllllllllllllllMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaajjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjoooooooooooooooooooooooooooooooooooooooooOOOOOOOOOO",
"NNNNNNNNNNrrrrrrrrrrrrrrrnqqbnbnbqbqnbbqnbbqbpbqbbqbbqbbqbbqbbbqbbbbqpppbbbqbbbqbqbbpbqbbbnqbqbqbbbqbqbbqqbqbqbbbqbqbbbbqbqbbbbuu2guu#bbbbbbqbzzbbqbqbbqbbbbbqbbbbbqbqbqbbbqbbbbbbbbbbbbbbbbbqbbbcpuuggzggguuu#pbbbbbbbbnqbbbpqbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbnbbbbbbbbbbbbbbnbnbbn******O7777777777777vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBsssssssssssssssssssssssssssssssssssssssslllllllllllllllllllllllllllllllllllllllllMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaajjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjoooooooooooooooooooooooooooooooooooooooooOOOOOOOOOO",
"NNNNNNNNNNrrrrrrrrrrrrrrrbnbnnqnbnnnn5nnbnnbnhnbnnbn5nnnnnbnnnbnnnhnn>>>bbnbnnbnhbnb5nbnnnbnbn>nqnbnbnbnbnbnbhnqnbnbnnnnnnnnhnbbbbbbbbnbnbhnnbh>bbbbnbnb5nnnnnnbnqnnnnhnnbnbnbnnnqnbb5nbbnbbnbnbnhb>bbbbbbbbbbn>bb>bbnnnqnnbb>bnhbbnqnnnnnnnnnhnnbnnnbnnnnnnnhnbnnnbnnnnbnn5bnbnnn******O7777777777777vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBssssssssssssssssssssssssssssss6t6sssssssllllllllllMMlllllllllllllllllllllllllllllMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMt96aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaajjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjoooooooooooooooooooot9tooooooooooooooooooOOOOOOOOOO",
"NNNNNNNNNNrrrrrrrrrrrrrrrnnnnbnnbnqnnbnqnnbnn5nnbnnbnbnnbnnnbnnbbbnnbn>nnnnnnnnqcnnnb5nbbnqbnnqnbnbnbnqnbnnqnnnbnbnnqnqnqnnnnnbbnnbnbnnnnnnnnn$5bnnnqnnbnqnbnbnnnnbnbnbnnnnnnnnbnnnnnqbnnnnnnnnnnnnnnnbnnnnnnnn>nnnnnnnnnnnnnnhnnnnnnnbnbnnbnnnbnnnqbnbnqnbnnnqnnqnqnqqbnqnbnbnbnn******O7777777777777vvvvvvvvvvvvvvvvvvvvvvvvvvBw  ; ;6vvvvvvvBBBBBBBBBBBBBBBBBBBBBBBlww   ;lBBBBBBBBBBsssssssssssssssssss;;sssssssst; 6ssssssslllllll6w; Mllt;  tlllw;  9llt;  tlllllllMMMMjw  ;6MM6w ;6MMM6w ;6Mjw  ;6MMMMM9  Maaaaaaaaaaaaaaaw  ww;6aaaaaaaaa;;aaaaaaajjjjjjjjjjjjjj9  w6jow 9jjjjjjjjw;  w;jjjooooooooooo;;oooooot; 6ooooooooooooooooooOOOOOOOOOO",
"NNNNNNNNNNrrrrrrrrrrrrrrrnqnbnnqnnbnnnnnnnqnn5bnnnbnnnnnnnbnnnnnnnbbnn5qnnqnqnnnnnqnbhnnnnnnnnbnnnqnnnbnnnnnnnnbnnqnnnqnnqnnnnnqnnnbnbqnnnnqnbhhnbnnnqnnnbnnqnnqnbnnnnnnqnqnnbnnnqnnn5nqnnnnnnnqnnqnbbbnnnqnbnnhnbnqnnnqnnqnnn5bqnnqnnnnqnnqnnnnqnqnnnnnqnnnqnnbnqnnnnnnnnnnqnnnnn******O7777777777777vvvvvvvvvvvvvvvvvvvvvvvvvvvt ;v6 ;vvvvvvvBBBBBBBB6wBBBBBBBBBBBB6 ;BBlw;BBBBBBBBBBBsssssssssssssssssss;wsssssssss;;sssssss6wlllllllt ;llt 9l ;llw Ml  lt 9l ;lllllllMMMMwtMw ;Mj ;Mw;MMj ;Mw;MwtMw ;MMMMMj wMaaaaaaaaaaaaaaat  aa ;aaaaaaaaa;waaaaaaajjjjjjjjjjjjjjj; 9jjj9wjjjjjjjjw ojowwjjjooooooooooo;woootwoo;;oooooooooooooooooooOOOOOOOOOO",
"NNNNNNNNNNrrrrrrrrrrrrrrrnnnnnqnqnnnn5qnnbnn$nnnnnqn5nnnnbnnnbnnnn5nnbnbnqnnnnqn5nnnn5bnnqnnnn5nqnnqnnqnnnnnq5nnqnqnqnnqnnnnhnqnnqnnnnqnbnfnnnh5bnqnqnnn5nnnnnnnnqnnnn5nnnnnnnnnnnnnb5nnnqnqnqnnnnn5nnnnbnnqnnnhbnhnnqnnnnnqnn5n5nnnnqnnnnnnnnhnnnnnqnnqnnqnn5nnnnqnqnnqnnq5nqnnnn******O7777777777777vvvvvvvvvvvvvvvvvvvvvvvvvvvw wvB  vvvvvvvBBBBBBBt tBBBBBBBBBBBl; MBBBBwBBBBBBBBBBBsssssssssssssssssssssssssssss6 wsssssst tlllllll9 wll; tl; ll  tl  l; tl; lllllllMMMM6MMM  Mw 9Mw jMw 9Mw j6MMM  MMMMM9 9Maaaaaaaaaaaaaaaw waa  aaaaaaaaaaaaaaaaaajjjjjjjjjjjjjjj; wjjowjjjjjjjjj  9jj69jjjooooooooooooooo9 9ot woooooooooooooooooooOOOOOOOOOO",
"NNNNNNNNNNrrrrrrrrrrrrrrrmmmmmmmmmmmmmmmmm$$5mmmmmmmmmmmmmmmmmmmmmmm55<5mmmmmmmmmmmmmh$$mmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmm55mmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmm$mmmmmmmmmmmmmmmmmmmmmmmm5555mmmmmmmmmmmm5mmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmm******O7777777777777vvvvvvvvvvvvvvvvvvvvvvvvvvv; 9v9 wvvw;wwwBtw;t;    B6; ;;BBBBB9 wBBBBBMBBw; ;6B9w;t; 69;ws;;stw;t;w9w;tst;    t9 9t ;ss;   lllllll; tll  Ml  ll;  9 tl  Ml  lllllllMMMMMMM6 w6  MM; t6  MM; tMMM6 wMMMMMw w  9a9;wa;;aaaaaa; 9a9 ;atw;9;w9w;taaw;wwwjow;99 ;jjjjjjjw wjjw6jjjjjjjjjw  9jjjj6w;99 ;o; w9w;to;   o9 99 ;ooooooooooooooooOOOOOOOOOO",
"NNNNNNNNNNrrrrrrrrrrrrrrr:::::::::::::::::h$5$$::::::::::::::::::::<::::5:::::::::::h<$<::::::::::::::::::::::::::::::::::::::::::::::::::::::5$:::::::::::::::::::::::::::::::::::::<:::::::::::::::::::::::5::::<:::::::::::5:::::::::::::::::::::::::::::::::::::::::::::::::::******O7777777777777vvvvvvvvvvvvvvvvvvvvvvvvvvM  ; ;wBvw;B  9BB; w;w ;BB; l6;BBBBB; tBBBBBBBw;ll ;BB; 99 wM ;sw ss; w;ws; st ws  ssw 96  sss ;llllllll  lll  lt ;ll6   Mll  lt ;lllllllMMMMMMMw;jw ;MM  Mw ;MM  MMMMw;jMMMMM; 96  aj ;aw aaaaaj  ww 9aaa; w;wa; aaw;j  9jjw 9t  jjjjjjj9 ;j6wjjjjjjjjjjjw  wjjjj; 9t ;96 ;o; ooo ;oow 9t  ooooooooooooooooOOOOOOOOOO",
"NNNNNNNNNNrrrrrrrrrrrrrrr::::::::::::5::::;   f:::::5:::::::::::::$:::::::::::::$:::<<<<::::::5::::::::::::::5::::::::::::::$:::::::::::::;:::$$::::::::5:::::::::::::<<55<h<$<<:::::$::::::::::::: ::::::::5::::: 5::::::::::5:5:: h <5 :::::$::::::::::::::$:::::::::::::5::::::******O7777777777777vvvvvvvvvvvvvvvvvvvvvvvvvv9 ;Mvvvvt wB  MBl ;tlt wBB  wB6BBBBB  MBBBBBB9 wBM  BM ;st wsw MMwsM ;tMMM wsw 6s  ss  9M ;ss6 wlllllllt wlllw Mw 9lM;;w wllw Mw 9lllllllMMMMMM9;jM; wMt ;M; wMt ;MMM9;jMMMMM6 ;MM  aaw jjwaaaaa9 ;a6 waaj ;tjjj wat wj  6jj; 9o ;jjjjjjjt ;jwjjjjjjjjjjjjjw  wjjj ;tt  ow 9o woot woo  9o ;ooooooooooooooooOOOOOOOOOO",
"NNNNNNNNNNrrrrrrrrrrrrrrr:::::::::::::::::5 5$:::::::::::::::::::$:::::::5::::::::::: 5$::::::::::::::::::::::::::::::::::::::::::::::::::::::55::::::::::::::::::::::::$<$:::>:::::$::::::::::::::::::::::5::::::::5::::::::::5:::$:$ :$:::::::::::::::::::::::::::::::::::::::::******O7777777777777vvvvvvvvvvvvvvvvvvvvvvvvvvw wvvvvvw tt ;vBt wBBw tBB6  9BBBBBB  BBBBBBB; tB9 ;B9 9sw 9sw t9tst wssst 9sw 66 wst ;s9 wssw tlllllllw 9lll6;  ;Ml; 6M  ll6;  ;Mlt       tMM6wjMM  9Mw wM  9Mw wMM6wjMMMMMM9 9M9 waaw t9taaaaaw waa  aa9 waaa9 9aw tt ;aj6 ;j9 wjjjjjjjo  9tjjjjjjjjjjjjjjw  jj6 ;ow 9o; o9 9oow 9ot ;o9 wooooooooooooooooOOOOOOOOOO",
"NNNNNNNNNNrrrrrrrrrrrrrrr:::::::::::::::::<;< :::::::::::::::::::5:::::::$:::::::::::$$<::::::::::::::::::::::::::::::::::::::::::::::::::::::$$::::::::::::::::::::::::$:5$  5 ::::$::::::::::::::::::::::5::::::::5::::::::::5:::$ 5:  :::::::::::::::::::::::::::::::::::::::::******O7777777777777vvvvvvvvvvvvvvvvvvvvvvvvvv  tvvvvv  v9 9vBw tBB; 6BBMM ;BBBBBB; lBBBBMB  MBw tBw Ms; Mst wwssw tsssw 6ss;; wssw 9sw 6ss; 6lllllll; 6llllM; 6ll  ll  lllM; 6llllllllMMMM6tMM9j  6M; 6M  6M; 6M6tMM9jMMMM; MMw 6aat wwaaaaaa; 9aj  aaw 9aaaw 6a  a9 9aj9 9jw tjjjjjjjj  wjjjjjjjjjjjwjjjo  jjw 9o; ot wow 6oo; tow 9ow tooooooooooooooooOOOOOOOOOO",
"NNNNNNNNNNrrrrrrrrrrrrrrr:5::5::<::5:5::5::$<:$::$::5::::h::$::5:<$::$::h$$::$::5:: : $$:;:5::$::5:: ::5::: :$::5::$::5::5::5::::5::5::<::5::f$$5:$::5::$::5::5::$::::$: $::$::$::5:55:5::h::5::$::$::$::$:$ ::$::$:;$::$::::5:  ::;::h:: ::h:5::$::5::5::5::$:5::h::$::5::$::$:::******O7777777777777vvvvvvvvvvvvvvvvvvvvvvvvv6  vvvvvv  B; M9B; BBB  tMBwB; BBBBBBw wlBBwtB  B6 wBB;;B9 tssM  tss; ssss; 6t;;tMsss; Ms  t6s  t6lllll6 ;llllM;;6lll; M6 wllM;;6lllllllllMMM9    ;Mw Mt wMMw Mt wM9    ;MMMMM  M9 9aaaj  taaaaa6  ja9 waa; aaaa; 6t  j; 69jw 6j  t6jjjjjjj;;ojjjj;;jjjjj;wjjj wjj; o6 wo; 99; tto  96; oo  9toooooooooooooooOOOOOOOOOO",
"NNNNNNNNNNrrrrrrrrrrrrrrr:::::::::::::::::: 5::::::::::::::::::::5:::::::5::::::::::::; ::::::::::::::::::::::::::::::::::::::::::::::::::::::5$:::::::::::::::::::::::5::::::::::::<::::::::::::::::::::::5::::::::$::::::::::5::::::::::::::::::::::::::::::::::::::::::::::::::******O7777777777777vvvvvvvvvvvvvvvvvvvvvvvvt;  wvvvvvw w; wB6 wBBB ;6Bt;  9BBBBBBBw; ;wtBBt; ;tBBM   ;tssss wss6 wssss; 9sw   ;tM;wss  9ss ;6lllll9;  9MMw;9Mllll6;  wMMw;9MllllllllllMM9     9Mj;  wMMMj;  wM9     9MMMMM;  w6aaaaa waaaaaaw    ;wja6 waaaa; 9aw w; wjjwwjj  9jjjjjjjjwtjjjjo ;jjjjj;;  ;wojo;wo9;to; wo; 9oo ;to;woo  9ooooooooooooooooOOOOOOOOOO",
"NNNNNNNNNNrrrrrrrrrrrrrrr::::::::::::::::::< :::::::::::::::::::::$::::::::::::::::::: 5:::::::::::::::::::::::::::::::::::::::::::::::::::::: $::::::::::::::::::::::::::::::::::::5:::::::::::::::::::::::5::::::$:::::::::::$::::::::::::::::::::::::::::::::::::::::::::::::::******O7777777777777vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBB9 9Bssssss;Mssssssssssss9;6t;  ssssssssssssslllllllllllllllllllllllllllllllllllllllllMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMaaaaa;jaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaajjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjoooooooooooooooooooooooooooooooooooooooooOOOOOOOOOO",
"NNNNNNNNNNrrrrrrrrrrrrrrr::::::::::::$::::: ::::::::$:::::::::::::5 ::::5:::::::$::::::5::::::$::::::::::::::5::::::::::::::5:::::::::::::$:::5$:::::::: :::::::::::::<:::::::::::::5h:::::::::::::5:::::::::5::::h::::::::::::5$:::::::::::::5::::::::::::::5:::::::::::::5::::::******O7777777777777vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBw lBss6wtw6sssssssssssss  MsM ;ssssssssssssslllllllllllllllllllllllllllllllllllllllllMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMa6w9w6aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaajjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjoooooooooooooooooooooooooooooooooooooooooOOOOOOOOOO",
"NNNNNNNNNNrrrrrrrrrrrrrrr::::::::::::::::::5::::::::::::::::::::::::$;<5::::::::::::::: ::::::::::::::::::::::::::::::::::::::::::::::::::::::;5:::::::::::::::::::::::::::::::::::5:::::::::::::::::::::::::: 5h$::::::::::::::<:::::::::::::::::::::::::::::::::::::::::::::::::******O7777777777777vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBB;   Bsst ;6sssssssssssssst;  ;wMssssssssssssslllllllllllllllllllllllllllllllllllllllllMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMa9 ;6aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaajjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjoooooooooooooooooooooooooooooooooooooooooOOOOOOOOOO",
"NNNNNNNNNNrrrrrrrrrrrrrrr::::::::::::::  5 :::::::::::::::::::::::::::::::::::::::::::::$;<:::::::::::::::::::::::::::::::::::::::::::::::::::$$::::::::::::::::::::::::::::::::;5$;::::::::::::::::::::::::::::::::::::::::::::$$55$:::::::::::::::::::::::::::::::::::::::::::::******O7777777777777vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBsssssssssssssssssssssssssssssssssssssssslllllllllllllllllllllllllllllllllllllllllMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaajjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjoooooooooooooooooooooooooooooooooooooooooOOOOOOOOOO",
"NNNNNNNNNNrrrrrrrrrrrrrrr:::::::::::: ::::::5::::::::::::::::::::::::::::::::::::::::: ::::: :::::::::::::::::::::::::::::::::::::::::::::::::$5::::::::::::::::::::::::::::::5::::::5:::::::::::::::::::::::::::::::::::::::::5:::::: :::::::::::::::::::::::::::::::::::::::::::******O7777777777777vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBsssssssssssssssssssssssssssssssssssssssslllllllllllllllllllllllllllllllllllllllllMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaajjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjoooooooooooooooooooooooooooooooooooooooooOOOOOOOOOO",
"NNNNNNNNNNrrrrrrrrrrrrrrr:::::::::::5::::::::5:::::::::::::::::::::::::::::::::::::::5:::::::5::::::::::::::::::::::::::::::::::::::::::::::::$$:::::::::::::::::::::::::::::$::::::::::::::::::::::::::::::::::::::::::::::::5::::::::$::::::::::::::::::::::::::::::::::::::::::******O7777777777777vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBsssssssssssssssssssssssssssssssssssssssslllllllllllllllllllllllllllllllllllllllllMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaajjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjoooooooooooooooooooooooooooooooooooooooooOOOOOOOOOO",
"NNNNNNNNNNrrrrrrrrrrrrrrr::::::::::: 5::::::: ::::::5:::::::::::::$:::::::::::::5::::$:::::::5$::::::::::::::$::::::::::::::$:::::::::::::5:::$$::::::::5:::::::::::::5::::::$:::::::;:::::::::::::$::::::::::::::$::::::::::: :5::::::h::::::5::::::::::::::5::::::::::::: ::::::******O7777777777777vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBsssssssssssssssssssssssssssssssssssssssslllllllllllllllllllllllllllllllllllllllllMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaajjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjoooooooooooooooooooooooooooooooooooooooooOOOOOOOOOO",
"NNNNNNNNNNrrrrrrrrrrrrrrr:::::::::::h::::::::5:::::::::::::::::::::::::::::::::::::::$:::::::5::::::::::::::::::::::::::::::::::::::::::::::::$$:::::::::::::::::::::::::::::$::::::::::::::::::::::::::::::::::::::::::::::::5:::::::: ::::::::::::::::::::::::::::::::::::::::::******O7777777777777vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBsssssssssssssssssssssssssssssssssssssssslllllllllllllllllllllllllllllllllllllllllMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaajjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjoooooooooooooooooooooooooooooooooooooooooOOOOOOOOOO",
"NNNNNNNNNNrrrrrrrrrrrrrrr:::::::::::;::::::::5:::::::::::::::::::::::::::::::::::::::5:::::::;::::::::::::::::::::::::::::::::::::::::::::::::$$:::::::::::::::::::::::::::::5::::::::::::::::::::::::::::::::::::::::::::::::$::::::::$::::::::::::::::::::::::::::::::::::::::::******O7777777777777vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBsssssssssssssssssssssssssssssssssssssssslllllllllllllllllllllllllllllllllllllllllMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaajjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjoooooooooooooooooooooooooooooooooooooooooOOOOOOOOOO",
"NNNNNNNNNNrrrrrrrrrrrrrrr::::::::::::$::::::5:::::::$:::::::::::::5:::::::::::::5:::::5:::::$:5::::::::::::::$::::::::::::::$:::::::::::::$:::$$::::::::$:::::::::::::$:::::::$::::::$:::::::::::::5::::::::::::::$::::::::::::;$:::::$::::::: ::::::::::::::5:::::::::::::$::::::******O7777777777777vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBsssssssssssssssssssssssssssssssssssssssslllllllllllllllllllllllllllllllllllllllllMMMMMMMMMMMMMMMMMMM696MMMMMMMMMMMMMMMMMjjaaaaaaaaaaaaaaaaaaaajjaaaaaat96aaaaaaaaajjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjt96jjjjjjjoooooooooooooooooooooooooooooooooooooooooOOOOOOOOOO",
"NNNNNNNNNNrrrrrrrrrrrrrrr:::::::::::::$::::$:::::::::::::::::::::::::::::::::::::::::::$:::;::::::::::::::::::::::::::::::::::::::::::::::::::$$:::::::::::::::::::::::::::::::5::::5:::::::::::::::::::::::::::::::::::::::::::$::::;::::::::::::::::::::::::::::::::::::::::::::******O7777777777777vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBssssssssssssssMw  ; ;6ssssssssssssssssssllllllllllllMww   ;MlllllllllllllllllllllMMMMMMMM;;MMMMMMMMt; 6MMMMMMMMMMMMMM6w; jaa9;  9aaa9;  9aa6w; jaaaaa9  aaaaaaaaaajjjjjow  ; ;6jjjjjjjjjjjjjjjjjt; ojjjjow  wtt;;to;;oooooooooooooooooooooooooooooooOOOOOOOOOO",
"NNNNNNNNNNrrrrrrrrrrrrrrr::::::::::::::;5$$:::::::::::::::::::::::::::::::::::::::::::::5$$:::::::::::::::::::::::::::::::::::::::::::::::::::$$::::::::::::::::::::::::::::::::5 5;:::::::::::::::::::::::::::::::::::::::::::::5$ 5:::::::::::::::::::::::::::::::::::::::::::::******O7777777777777vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBssssssssssssssst ;s6 ;sssssssssssssss6wslllllllllll6 ;llMw;llllllllllllllllllllllMMMMMMMM;wMMMMMMMMM;;MMMMMMM6wMMMMMMMt ;Ma9 9a ;aa9 9a ;aaat ;aaaaaaj waaaaaaaaaajjjjjj9 ;j6 ;jjjjjjjjjjjjjjjjjj ;jjjjjjt  ootwooo;woooooooooooooooooooooooooooooooOOOOOOOOOO",
"NNNNNNNNNNrrrrrrrrrrrrrrr:$::5::$::5: ::$::5:: ::$::5::::5::$:: ::5::$::5:5::$::$::$::$::5:5::5:: ::$::5:::$:$::5:: :: :: ::$::::$::$::$::;::<;5$:$::5::$::5::5::5::::5::h::5::;:: ::5:$::5::5::5::$::$::$::5::5::5:: ::5::::5:: ::5:: ::5:: :$::5:: ::$::$::$:$::$:: ::5::5::$:::******O7777777777777vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBsssssssssssssssw wsM  sssssssssssssst tsllllllllllM; 6llllwllllllllllllllllllllllMMMMMMMMMMMMMMMMMM6 wMMMMMM9 9MMMMMMM9 wMa; ta; aa; ta; aaa9 waaaaaa9 9aaaaaaaaaajjjjjjw wjo  jjjjjjjjjjjjjjjjjt wjjjjjj9 ;o9woooooooooooooooooooooooooooooooooooooOOOOOOOOOO",
"NNNNNNNNNNrrrrrrrrrrrrrrr::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::: $::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::******O7777777777777vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBsssssssssssssss; 9s9 wssw;wwwtw;t;w;   6; ;;llllll9 wlllll6llw; ;6l9w;t; 69;wl;;ltw;9;w9w;tMt;    t9 99 ;MM;   MMMMMMM; tMa  ja  aa  ja  aaa; taaaaaaw w  9a9;wa;;jjjjjj; 9j9 wjjw;wwwj9w;wj9;6jw tjjjjjj; 999ooo9w;tow;99 ;ooot;    tooooooooooooooOOOOOOOOOO",
"NNNNNNNNNNrrrrrrrrrrrrrrr:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::h ::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::******O7777777777777vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBssssssssssssss6  ; ;wMsw;M  9s; w;ws ;s; M6;llllll; tlllllllw;MM ;ll; 99 wM ;lw lM; w;wM; Mt wM  MMw 96  MMM ;MMMMMMMM  MMa  at ;aa  at ;aaa  aaaaaaa; 96  aj ;aw jjjjj6  ; ;wojw;o  9jj; 6j; jj; jjjjjjj  w 6oooo; oow 9t  oot wo  ooooooooooooooooOOOOOOOOOO",
"NNNNNNNNNNrrrrrrrrrrrrrrrrrrrr**********************************************************************************************************************************************************************************************************************************************************O7777777777777vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBssssssssssssss9 ;6sssst wM  6M ;tMM6 ws  wl6llllll  6llllll9 wl6  l6 ;lt wlw MMwlj ;tjjj wMw 6M  MM  9j ;MM6 wMMMMMMM9 wMMaw jw 9aaw jw 9aa9 waaaaaa6 ;aa  aaw jjwjjjjj9 ;6jjjjt wo  6jj;;j6 wjo wjjjjjj9  w woooo woo; 9o ;oow to  ooooooooooooooooOOOOOOOOOO",
"NNNNNNNNNNrrrrrrrrrrrrrrrrrrrr**********************************************************************************************************************************************************************************************************************************************************O7777777777777vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBssssssssssssssw wsssssw tt ;st wsssw ts6  9lllllll  lllllll; tl9 ;l9 9lw 9lw t9tl9 wMMM9 9Mw 66 wMt ;M9 wMMw 9MMMMMMMw 9MMa6;  ;jaa6;  ;jaaw 9aaaaaa9 9a9 waaw t9tjjjjjw wjjjjjw tt ;jj6 wjw 9j9 9jjjjjjw wt  ooo9 9o6 ;o9 woow 6t wooooooooooooooooOOOOOOOOOO",
"NNNNNNNNNNrrrrrrrrrrrrrrrrrrrr**********************************************************************************************************************************************************************************************************************************************************O7777777777777vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBssssssssssssss  tsssss  s9 9sw tsss; 6s66 ;lllllll; Mllll6l  6lw tlw 6l; Mlt wwllw 9MMMw 6MM;; wMMw 9Mw 6MM; 6MMMMMMM; 6MMaaj; 6aaaaj; 6aaa; 6aaaaaa; aaw 6aat wwajjjjj  tjjjjj  j9 9jjw 96  6jw 6jjjjjj; 9o; woow 6o9 9ow tooo;; woooooooooooooooooOOOOOOOOOO",
"NNNNNNNNNNrrrrrrrrrrrrrrrrrrrr**********************************************************************************************************************************************************************************************************************************************************O7777777777777vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBsssssssssssss6  ssssss  M; 69; ssss  t6wl; lllllllw wMllwtl  l6 wll;;l9 tllM  tll; MMMM; 6t;;9jMMM; jM  96M  96MMMMM6 ;MMMaj;;6aaaaj;;6aaa6 ;aaaaaaa  a9 9aaaj  tajjjj6  jjjjjj  o; 69j; o9  96; 6tjjjj6  6ot  oo; ttw 6o  t6o;;9oooooooooooooooooooOOOOOOOOOO",
"NNNNNNNNNNrrrrrrrrrrrrrrrrrrrr**********************************************************************************************************************************************************************************************************************************************************O7777777777777vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBsssssssssssst;  wsssssw w; wt wssss ;6t;  9llllllllw; ;wtllt; ;tll6   ;tllll wll6 wMMMM; 9Mw   ;tj;wMM  9MM ;6MMMMM9;  9jjw;9jaaajw;9jaaa9;  9jaaaaa;  w6aaaaa waajjjt;  wjjjjjw w; woj; wj  9j; 9jjjj6w  wow  w6; 9owwoo  9oow   ;tooooooooooooooooOOOOOOOOOO",
"NNNNNNNNNNrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrriiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiii444444444444444444444444444444444444444440000000000000000000000000000000000000000-----------------------------------------333333333333333333333333333333333333333337777777777777777777777777777777777777777vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBssssssssssssssssssssssssssssssssssssssssllllllllllllllllllllllllll9 9lllllll;MlllMMMMMMMMM9;69;  MMMMMMMMMMMMMMMMMMMMMMMMMaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa;jaajjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjoooooooooooooooooo9;t9;  ooooooooooooooooOOOOOOOOOO",
"NNNNNNNNNNrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrriiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiii444444444444444444444444444444444444444440000000000000000000000000000000000000000-----------------------------------------333333333333333333333333333333333333333337777777777777777777777777777777777777777vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBssssssssssssssssssssssssssssssssssssssssllllllllllllllllllllllllllw Mlll6wtw6llllMMMMMMMMM  jMj ;MMMMMMMMMMMMMMMMMMMMMMMMMaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa6w9w6aaajjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjoooooooooooooooooo  ooo ;ooooooooooooooooOOOOOOOOOO",
"NNNNNNNNNNrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrriiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiii444444444444444444444444444444444444444440000000000000000000000000000000000000000-----------------------------------------333333333333333333333333333333333333333337777777777777777777777777777777777777777vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBsssssssssssssssssssssssssssssssssssssssslllllllllllllllllllllllll;   lllt ;6lllllMMMMMMMMM9;  ;wjMMMMMMMMMMMMMMMMMMMMMMMMMaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa9 ;6aaaajjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjoooooooooooooooooo9;  ;woooooooooooooooooOOOOOOOOOO",
"NNNNNNNNNNrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrriiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiii444444444444444444444444444444444444444440000000000000000000000000000000000000000-----------------------------------------333333333333333333333333333333333333333337777777777777777777777777777777777777777vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBsssssssssssssssssssssssssssssssssssssssslllllllllllllllllllllllllllllllllllllllllMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaajjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjoooooooooooooooooooooooooooooooooooooooooOOOOOOOOOO",
"NNNNNNNNNNrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrriiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiii444444444444444444444444444444444444444440000000000000000000000000000000000000000-----------------------------------------333333333333333333333333333333333333333337777777777777777777777777777777777777777vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBsssssssssssssssssssssssssssssssssssssssslllllllllllllllllllllllllllllllllllllllllMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaajjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjoooooooooooooooooooooooooooooooooooooooooOOOOOOOOOO",
"NNNNNNNNNNrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrriiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiii444444444444444444444444444444444444444440000000000000000000000000000000000000000-----------------------------------------333333333333333333333333333333333333333337777777777777777777777777777777777777777vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBsssssssssssssssssssssssssssssssssssssssslllllllllllllllllllllllllllllllllllllllllMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaajjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjoooooooooooooooooooooooooooooooooooooooooOOOOOOOOOO",
"NNNNNNNNNNrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrriiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiii444444444444444444444444444444444444444440000000000000000000000000000000000000000-----------------------------------------333333333333333333333333333333333333333337777777777777777777777777777777777777777vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBsssssssssssssssssssssssssssssssssssssssslllllllllllllllllllllllllllllllllllllllllMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaajjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjoooooooooooooooooooooooooooooooooooooooooOOOOOOOOOO",
"NNNNNNNNNNrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrriiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiii444444444444444444444444444444444444444440000000000000000000000000000000000000000-----------------------------------------333333333333333333333333333333333333333337777777777777777777777777777777777777777vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBsssssssssssssssssssssssssssssssssssssssslllllllllllllllllllllllllllllllllllllllllMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaajjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjoooooooooooooooooooooooooooooooooooooooooOOOOOOOOOO",
"NNNNNNNNNNrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrriiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiii444444444444444444444444444444444444444440000000000000000000000000000000000000000-----------------------------------------333333333333333333333333333333333333333337777777777777777777777777777777777777777vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBsssssssssssssssssssssssssssssssssssssssslllllllllllllllllllllllllllllllllllllllllMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaajjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjoooooooooooooooooooooooooooooooooooooooooOOOOOOOOOO",
"NNNNNNNNNN---------------------------------------------------------------------------------33333333333333333333333333333333333333333777777777777777777777777777777777777777777777777777777777777777777777777777777777vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBlllllllllllllllllllllllllllllllllllllllllMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjoooooooooooooooooooooooooooooooooooooooooOOOOOOOOOO",
"NNNNNNNNN@xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxOOOOOOOOOO",
"NNNNNNNN@xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxOOOOOOOOO",
"NNNNNNN@xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxOOOOOOOO",
"NNNNNN@xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxOOOOOOO",
"NNNNN@xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxOOOOOO",
"NNNN@xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxOOOOO",
"NNN@xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxOOOO",
"NN@xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxOOO",
"N@xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxOO",
"@xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxO"
};

#endif /* USE_XPM */

/* splash background for monochrome or non-XPM compile */

#define spl_bckgnd_width 630
#define spl_bckgnd_height 210
static char spl_bckgnd_bits[] = {
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x81,0x20,0x00,0x10,0x08,0x02,0x11,0x49,0x84,0x20,0x00,
 0x82,0x88,0x84,0x10,0x10,0x41,0x04,0x02,0x20,0x92,0x40,0x40,0x00,0x10,0x44,
 0x88,0x10,0x04,0x00,0x02,0x04,0x11,0x00,0x44,0x02,0x01,0x22,0x01,0x00,0x02,
 0x01,0x09,0x80,0x24,0x02,0x80,0x08,0x82,0x10,0x01,0x84,0x90,0x80,0x40,0x08,
 0x84,0x40,0x04,0x44,0x00,0x44,0x10,0x10,0x42,0x04,0x49,0x92,0x80,0x88,0x00,
 0x00,0x48,0x40,0x04,0x80,0x08,0x01,0x20,0x24,0x82,0x94,0x44,0x42,0x08,0x40,
 0x00,0x10,0x82,0x24,0x08,0x02,0x10,0x42,0x02,0x04,0x90,0x50,0x02,0x00,0x0a,
 0x09,0x49,0x41,0x10,0x02,0x42,0x90,0x12,0x48,0x10,0x44,0x4a,0x00,0x48,0x24,
 0x08,0x24,0x29,0x48,0x24,0xa0,0x24,0x80,0x48,0x12,0x20,0x08,0x02,0x24,0x21,
 0x04,0x12,0x12,0x22,0x21,0x02,0x90,0x00,0x49,0x00,0x41,0x42,0x08,0x10,0x00,
 0x00,0x12,0x00,0x92,0x54,0x02,0x09,0x90,0x24,0x20,0x54,0x2a,0x01,0x08,0x00,
 0x00,0x00,0x80,0x08,0x20,0x02,0x10,0x00,0x41,0x20,0x01,0x00,0x80,0x20,0x02,
 0x00,0x10,0x21,0x00,0x00,0x00,0x08,0x02,0x20,0x00,0x02,0x00,0x01,0x41,0x00,
 0x00,0x22,0x01,0x00,0x01,0x00,0x00,0x01,0x00,0x02,0x00,0x08,0x00,0x00,0x04,
 0x41,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x20,0x02,0x20,0x00,0x22,0x08,
 0x00,0x00,0x42,0x22,0x44,0x00,0x44,0x00,0x00,0x00,0x00,0x02,0x00,0x04,0x00,
 0x10,0x04,0x20,0x22,0x82,0x88,0x08,0x02,0x09,0x20,0x81,0x08,0x00,0x00,0x44,
 0x24,0x12,0x80,0x20,0x82,0x40,0x04,0x91,0x24,0x12,0x80,0x40,0x80,0x24,0x20,
 0x24,0x10,0x00,0x81,0x10,0x08,0x10,0x12,0x20,0x49,0x04,0x08,0x11,0x08,0x89,
 0x20,0x24,0x49,0x40,0x00,0x14,0x48,0x84,0x50,0x24,0x21,0x41,0x84,0x84,0x10,
 0x05,0x89,0x08,0x80,0x88,0x90,0x00,0x80,0x00,0x44,0x10,0x44,0x80,0x48,0x92,
 0x90,0x88,0x40,0x80,0x2a,0x51,0x02,0x00,0x20,0x00,0x42,0x40,0x00,0x09,0x08,
 0x42,0x24,0x49,0x00,0x00,0x00,0x12,0x08,0x20,0x08,0x00,0x00,0x80,0x40,0x22,
 0x10,0x12,0x80,0x08,0x01,0x04,0x14,0x24,0x04,0x01,0x84,0x80,0x08,0x00,0x20,
 0x41,0x80,0x20,0x00,0x04,0x01,0x00,0x12,0x24,0x01,0x02,0x20,0x04,0x01,0x08,
 0x10,0x20,0x00,0x40,0x10,0x00,0x80,0x24,0x02,0x04,0x10,0x10,0x20,0x01,0x82,
 0x10,0x24,0x00,0x00,0x00,0x02,0x10,0x24,0x14,0x04,0x88,0x48,0x04,0x49,0x00,
 0x04,0x22,0x80,0x20,0x00,0x01,0x00,0x91,0x88,0x48,0x00,0x40,0x02,0x01,0x91,
 0x44,0x10,0x00,0x08,0x02,0x00,0x02,0x00,0x90,0x20,0x01,0x00,0x20,0x20,0x01,
 0x00,0x42,0x84,0x00,0x00,0x02,0x02,0x22,0x00,0x40,0x84,0x00,0x00,0x20,0x20,
 0x01,0x00,0x10,0x80,0x80,0x00,0x12,0x02,0x40,0x24,0x00,0x00,0x10,0x21,0x42,
 0x81,0x04,0x88,0x00,0x80,0x00,0x11,0x11,0x09,0x10,0x81,0x80,0x2a,0x48,0x01,
 0x02,0x01,0x00,0x20,0x41,0x00,0x22,0x00,0x20,0x10,0x11,0x00,0x02,0x02,0x24,
 0x05,0x20,0x40,0x00,0x00,0x04,0x12,0x01,0x20,0x89,0x20,0x44,0x04,0x00,0x40,
 0x41,0x02,0x08,0x20,0x49,0x00,0x20,0x88,0x28,0x48,0x80,0x00,0x49,0x12,0x20,
 0x00,0x49,0x88,0x08,0x48,0x22,0x42,0x12,0x12,0x92,0x80,0x10,0x04,0x00,0x4a,
 0x84,0x40,0x00,0x00,0x10,0x80,0x20,0x20,0x04,0x10,0x04,0x40,0x80,0x40,0x10,
 0x10,0x15,0x22,0x10,0x00,0x48,0x84,0x04,0x08,0x12,0x00,0x89,0x02,0x00,0x84,
 0x44,0x10,0x20,0x00,0x10,0x09,0x09,0x12,0x11,0x81,0x00,0x20,0x01,0x20,0x88,
 0x10,0x40,0x12,0x04,0x04,0x48,0x42,0x04,0x00,0x88,0x00,0x21,0x80,0x00,0x24,
 0x04,0x00,0x80,0x00,0x4a,0x00,0x01,0x00,0x00,0x08,0x00,0x00,0x00,0x00,0x08,
 0x40,0x20,0x91,0x00,0x11,0x02,0x44,0x04,0x82,0x08,0x02,0x82,0x10,0x41,0x20,
 0x02,0x24,0x02,0x82,0xc4,0x2a,0x88,0x84,0x90,0x00,0x20,0x80,0x00,0x00,0x11,
 0x00,0x20,0x89,0x00,0x10,0x40,0x84,0x84,0x00,0x00,0x20,0x00,0x04,0x20,0x88,
 0x08,0x10,0x02,0x02,0x00,0x11,0x00,0x21,0x10,0x01,0x00,0x00,0x24,0x02,0x12,
 0x04,0x04,0x10,0x01,0x90,0x84,0x10,0x88,0x00,0x00,0x20,0x92,0x12,0x01,0x11,
 0x22,0x21,0x11,0x02,0x09,0x04,0x00,0x20,0x00,0x10,0x01,0xa1,0x08,0x42,0x80,
 0x10,0x40,0x08,0x80,0x10,0x01,0x20,0x00,0x20,0x15,0x02,0x52,0x4a,0xaa,0x4a,
 0x55,0x6a,0x55,0xaa,0xaa,0x4a,0x52,0xaa,0xa2,0x2a,0x29,0x29,0xd5,0x6a,0x95,
 0x55,0x69,0x95,0x52,0x55,0x65,0x55,0xa9,0x56,0x4a,0x55,0x4a,0xa5,0xaa,0xad,
 0x75,0xc9,0xb4,0xd4,0xaa,0xb5,0x66,0xaa,0xa5,0x5a,0xab,0x55,0xb5,0xdf,0x56,
 0xa5,0x54,0xb5,0xd6,0xaa,0x56,0xd5,0x74,0xb5,0xb5,0x6d,0xab,0x76,0x6b,0xb6,
 0x2a,0xb5,0x5a,0xbb,0xd6,0x57,0x6b,0xaf,0x56,0x6d,0xd7,0x7d,0x5b,0x29,0xa0,
 0x24,0x25,0x49,0x92,0x24,0x15,0x49,0x85,0x54,0x29,0x29,0xa5,0x54,0x4a,0x95,
 0xa4,0x2a,0x14,0x4a,0xa8,0x92,0x4a,0x2a,0x49,0x95,0xa8,0x54,0xa9,0xaa,0xaa,
 0xa9,0xaa,0x54,0x52,0x8a,0xaa,0xaa,0x2a,0x51,0x8a,0x52,0x55,0xaa,0xa4,0x48,
 0x55,0x4a,0x20,0xa9,0xaa,0xaa,0x4a,0x29,0x55,0xa9,0x2a,0x95,0xaa,0x4a,0x95,
 0x54,0x95,0x54,0x55,0xd5,0x4a,0xa5,0x4a,0x55,0xa8,0xaa,0x52,0xa9,0xaa,0x54,
 0x8a,0x4a,0x15,0x0a,0x48,0x94,0x92,0x24,0x49,0x48,0x92,0x28,0x21,0x52,0x52,
 0x12,0x85,0x24,0x22,0x95,0xa4,0xa9,0xa4,0x12,0x25,0xa9,0xa4,0x92,0x24,0x45,
 0x25,0x45,0x91,0x24,0x4a,0x49,0x49,0xa5,0x54,0x15,0x45,0x49,0x95,0xb4,0x94,
 0xaa,0x2a,0x95,0x56,0x52,0x55,0xab,0x4a,0x55,0x25,0x55,0x55,0x95,0x4a,0x55,
 0x55,0xa5,0xaa,0xaa,0xaa,0xaa,0x4a,0x55,0x95,0xaa,0xaa,0xaa,0xaa,0x55,0x55,
 0x55,0x55,0x55,0x55,0xb5,0xaa,0x2a,0xa0,0x92,0xa2,0x48,0x49,0x92,0x52,0x29,
 0xa5,0x4a,0x89,0x0a,0x49,0xa9,0x92,0x94,0x22,0x49,0x92,0x92,0x4a,0x52,0x4a,
 0x4a,0x54,0xaa,0x52,0x52,0xa9,0x54,0x52,0xa5,0x54,0x2a,0x29,0xa5,0xc8,0x54,
 0xaa,0xaa,0x8a,0x4a,0x49,0xa5,0x52,0x29,0x95,0xaa,0xaa,0x2a,0x49,0xaa,0xaa,
 0xaa,0x52,0x55,0xa9,0xaa,0x2a,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,
 0x55,0x55,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0x4a,0x55,0x15,0x0a,0x24,0x09,0x25,
 0x92,0x24,0x45,0xa2,0x14,0x95,0x52,0x54,0x55,0x92,0xa4,0x52,0x54,0x92,0xa4,
 0x54,0xaa,0xa4,0x94,0x92,0x92,0x44,0xaa,0x24,0x15,0xa5,0x4a,0x4a,0xa5,0x52,
 0x4a,0x49,0x15,0x55,0x25,0x49,0xa9,0xaa,0x2a,0xa9,0xaa,0x52,0x55,0x52,0x2a,
 0x55,0x55,0xa9,0x54,0x52,0x55,0x55,0x4a,0x55,0xaa,0xaa,0x54,0x95,0x54,0x55,
 0xa9,0xaa,0xaa,0xaa,0xaa,0xaa,0x55,0x55,0x55,0x55,0x55,0x55,0xb5,0xaa,0x24,
 0x40,0x49,0xaa,0x52,0x49,0x92,0x28,0x15,0xa2,0x40,0x28,0x49,0x22,0x29,0x95,
 0x94,0x2a,0x55,0x55,0x92,0x22,0x55,0xa2,0x54,0xa9,0xaa,0x12,0x55,0x49,0x95,
 0x54,0x29,0x29,0x49,0xa5,0xaa,0x64,0x25,0xa9,0x2a,0x55,0x92,0xa4,0x2a,0x49,
 0xaa,0xa4,0xaa,0x52,0x49,0x55,0x95,0xaa,0x4a,0x2a,0xa9,0xaa,0xaa,0xaa,0x52,
 0x55,0x55,0x55,0x55,0x95,0x54,0x55,0x55,0x55,0x55,0xaa,0xaa,0xaa,0xaa,0xaa,
 0xaa,0x4a,0x55,0x15,0x0a,0x94,0x10,0x84,0x92,0x24,0xa5,0xa4,0x94,0x96,0x42,
 0xa5,0x94,0x52,0x28,0x51,0xa2,0x24,0xa2,0x4a,0x54,0x92,0x4a,0x49,0x92,0x24,
 0xa5,0x92,0x52,0x52,0x49,0x52,0x4a,0x55,0x2a,0x95,0x8a,0x54,0x95,0x54,0x92,
 0xaa,0x2a,0x55,0x55,0xa5,0xaa,0x4a,0x55,0x55,0x4a,0x55,0xa5,0xaa,0xaa,0x4a,
 0x55,0x52,0x55,0x95,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0x94,0xaa,0xaa,0xaa,0x55,
 0x55,0x55,0x55,0x55,0x55,0xb5,0x4a,0x15,0xa0,0x42,0xca,0x52,0x48,0x92,0x12,
 0x52,0x25,0x51,0x2a,0x51,0x4a,0x09,0x95,0x14,0x49,0x4a,0x55,0xa4,0x2a,0x49,
 0xa9,0xa4,0x4a,0x52,0x52,0x49,0x54,0x29,0xa5,0x4a,0xa5,0x94,0x52,0x49,0xa9,
 0x4a,0x4a,0xa5,0xaa,0x52,0xaa,0x92,0x2a,0x29,0x95,0x54,0x2a,0x55,0xa9,0xa4,
 0x2a,0x55,0xa5,0xaa,0xaa,0x2a,0xa5,0x54,0x25,0xa5,0x4a,0x55,0x55,0x55,0x55,
 0x55,0x55,0x55,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0x2a,0x12,0x94,0x12,
 0x95,0xaa,0x54,0xa4,0x84,0x48,0x4a,0x49,0x8a,0x28,0x6a,0xa1,0xa2,0xaa,0x94,
 0x88,0x4a,0x42,0x95,0x12,0x15,0xa9,0x4a,0x25,0x55,0x25,0xa5,0x94,0x94,0x2a,
 0xa9,0x24,0x95,0x52,0xa9,0x54,0x4a,0x25,0xa5,0x52,0x2a,0x49,0x55,0x52,0x55,
 0x49,0xa9,0x2a,0x55,0xaa,0xaa,0xaa,0xaa,0xa4,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
 0x92,0xaa,0x4a,0x55,0x55,0x55,0xaa,0x2a,0xa5,0xaa,0xaa,0xaa,0xaa,0xaa,0x2a,
 0x15,0x04,0x51,0xa4,0x48,0x12,0x8a,0x92,0x32,0x25,0x91,0xa4,0xa4,0x92,0x92,
 0x54,0x94,0x44,0x42,0xa5,0x24,0xa9,0x48,0xa8,0xa4,0x94,0x24,0x92,0x92,0x92,
 0x52,0x52,0x52,0x51,0x25,0x95,0x52,0xaa,0x94,0x4a,0x29,0xa9,0x94,0x4a,0x55,
 0x55,0xa5,0xaa,0x4a,0x55,0x25,0x55,0x55,0xa5,0x92,0x54,0x52,0x55,0x55,0x55,
 0x55,0x55,0x55,0x55,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
 0xaa,0xaa,0xaa,0xaa,0x12,0x50,0xa4,0x12,0x01,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xa8,0xa4,0x24,0x55,0xa9,0xaa,
 0x4a,0x55,0xaa,0xa4,0xaa,0x54,0x25,0xa9,0xaa,0xaa,0x52,0x49,0x55,0x55,0xa5,
 0x4a,0x95,0xaa,0xaa,0x2a,0x55,0x2a,0xa9,0xaa,0x52,0x55,0x55,0x52,0x55,0x55,
 0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x15,0x0a,0x12,0xa4,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x24,0x55,
 0x55,0x25,0x25,0x49,0xa9,0x4a,0x95,0x2a,0x49,0x2a,0xa9,0xaa,0x24,0x55,0x95,
 0xaa,0x54,0xaa,0xaa,0xaa,0xaa,0x94,0x24,0xa5,0x52,0xa5,0xaa,0xaa,0xaa,0xaa,
 0x4a,0x55,0xa9,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0x2a,0xa0,0xa8,
 0x12,0x01,0x20,0x00,0x10,0x00,0x04,0x00,0x01,0x40,0x00,0x20,0x00,0x10,0x00,
 0x04,0x00,0x01,0x40,0x00,0x20,0x00,0x08,0x00,0x04,0x00,0x01,0x40,0x00,0x20,
 0x00,0x08,0xa8,0x24,0x49,0xaa,0xaa,0x2a,0x95,0x54,0x52,0xa9,0xaa,0x52,0x55,
 0x92,0xaa,0x24,0x55,0x55,0x55,0x55,0x55,0x55,0x52,0x55,0x55,0x55,0x55,0x55,
 0x55,0x55,0x55,0x52,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
 0x4a,0x0a,0x0a,0x8a,0xa4,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x48,0x55,0xa5,0x52,0x52,0xa5,0x4a,0xa5,0x2a,
 0x95,0x52,0x95,0x4a,0x55,0x55,0x55,0x49,0x29,0x25,0x25,0x29,0xa9,0xaa,0x52,
 0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0xaa,
 0xaa,0xaa,0xaa,0xaa,0xaa,0x2a,0x50,0x50,0x4a,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x54,0x92,0x2a,0xa5,0x24,
 0x4a,0x52,0x4a,0x55,0xa5,0x94,0x2a,0xa9,0xaa,0xa4,0xaa,0xaa,0x52,0x55,0x55,
 0x55,0x95,0x2a,0x55,0x55,0xa9,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
 0xaa,0xaa,0xaa,0x55,0x55,0x55,0x55,0x55,0x55,0x15,0x04,0x25,0x21,0x01,0x20,
 0x00,0x10,0x00,0x04,0x00,0x01,0x40,0x00,0x20,0x00,0x10,0x00,0x04,0x00,0x01,
 0x40,0x00,0x20,0x00,0x08,0x00,0x04,0x00,0x01,0x40,0x00,0x20,0x00,0x08,0xa8,
 0x4a,0x92,0x2a,0x55,0x55,0x55,0xa9,0xa4,0x54,0x55,0x52,0x25,0x49,0x55,0x49,
 0x55,0xaa,0xaa,0x54,0xa5,0xaa,0xaa,0xaa,0xaa,0xaa,0x94,0x94,0x54,0x52,0x52,
 0x55,0x55,0x55,0x55,0x55,0x55,0x55,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0x24,0x92,
 0x48,0x4a,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x54,0x55,0x55,0x52,0x95,0x94,0xa4,0x92,0x4a,0x29,0xa5,0x4a,
 0x55,0x55,0x95,0x2a,0xa9,0x4a,0xaa,0xaa,0x2a,0xa5,0xa4,0x2a,0x25,0x55,0x55,
 0x55,0xa5,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0x4a,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
 0xaa,0x4a,0x15,0x20,0x24,0x29,0x25,0x29,0x49,0x12,0x92,0x24,0x25,0x49,0x4a,
 0x92,0x28,0x49,0x12,0x92,0x24,0x25,0x49,0x42,0x92,0xa4,0x24,0x49,0x92,0x24,
 0x21,0x49,0x52,0x92,0xa4,0x24,0x49,0xd8,0xa4,0xa4,0xaa,0xa4,0x4a,0x95,0x54,
 0xa9,0xaa,0x52,0xa9,0x54,0x55,0x52,0x55,0x95,0xaa,0x4a,0x95,0x54,0x55,0x55,
 0x55,0x55,0x95,0x52,0x55,0x55,0x55,0x55,0x55,0x49,0x55,0x55,0xa9,0x55,0xa9,
 0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0x2a,0x8a,0x48,0x92,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x54,0x49,0x49,0x49,
 0x55,0xa9,0x2a,0xa5,0x2a,0xa5,0x4c,0x2a,0x25,0xa9,0x2a,0xa9,0xaa,0x54,0xa9,
 0x52,0x55,0xa9,0x2a,0xa9,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0x2a,0xa9,0xaa,0x94,
 0xaa,0xaa,0x4a,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x15,0x00,0x25,0x25,0x49,
 0x25,0x49,0xa5,0x54,0xea,0x55,0xaa,0x24,0xa9,0x24,0xa9,0x4a,0x55,0x55,0x95,
 0x52,0x55,0xaa,0x2a,0x55,0x25,0xa9,0xa7,0x54,0x92,0x92,0x54,0x25,0xa9,0x24,
 0x6d,0x55,0xaa,0x54,0x92,0x24,0x51,0x95,0xa4,0x94,0x52,0x55,0x55,0x95,0xaa,
 0x4a,0x49,0x25,0x55,0x55,0xa5,0x2a,0x55,0x55,0x55,0xa9,0xaa,0x52,0x55,0x55,
 0x55,0x95,0xaa,0xaa,0x4a,0x55,0xa9,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0x12,
 0x2a,0x48,0x94,0x20,0x30,0x04,0x10,0x02,0x24,0x02,0x01,0x50,0x04,0x20,0x04,
 0x10,0x00,0x04,0x40,0x01,0x40,0x00,0x20,0x00,0x88,0x40,0x0c,0x00,0x09,0x40,
 0x00,0x20,0x04,0x88,0xa8,0xaa,0x92,0xaa,0xaa,0xaa,0x4a,0xa9,0xaa,0xaa,0xaa,
 0x92,0x52,0xaa,0xa4,0x2a,0x55,0x55,0x95,0x54,0x95,0xaa,0x52,0xa5,0x54,0x55,
 0x95,0xaa,0xaa,0x4a,0xa9,0xaa,0xaa,0xaa,0xaa,0xaa,0x56,0x55,0x55,0x55,0x55,
 0x55,0x55,0x95,0x2a,0x00,0xa5,0x22,0x09,0x04,0x21,0x89,0x20,0xd1,0x25,0x11,
 0x05,0x41,0x12,0x21,0x22,0x11,0x21,0x12,0x48,0x12,0x92,0x44,0x22,0x22,0xe4,
 0x53,0x8a,0x20,0x29,0x49,0x12,0x41,0x12,0xaa,0x12,0xa9,0x12,0x25,0x55,0xaa,
 0x54,0x95,0x52,0x25,0xa9,0x94,0x4a,0x55,0xa9,0x2a,0xa9,0xaa,0xaa,0x54,0xa5,
 0xaa,0xaa,0xaa,0xaa,0x54,0x95,0x54,0xa9,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0x52,
 0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x15,0x2a,0x88,0x94,0x40,0x40,0x08,0x20,
 0x04,0x8c,0x08,0x44,0x20,0x08,0x41,0x80,0x08,0x44,0x84,0x00,0x01,0x40,0x00,
 0x10,0x88,0x08,0x91,0x28,0x20,0x02,0x00,0x00,0x48,0x08,0x40,0x54,0x65,0x4a,
 0xaa,0x54,0x92,0x92,0x4a,0x52,0x4a,0xaa,0xaa,0xaa,0x52,0x95,0x4a,0xa9,0x4a,
 0xa9,0x92,0xaa,0x54,0x4a,0x55,0x25,0x95,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0x4a,
 0x55,0x55,0x55,0xad,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0x14,0x80,0x2a,0x45,
 0x12,0x25,0x82,0x14,0x21,0x89,0x4a,0x01,0x44,0x21,0x24,0x14,0x10,0x01,0x10,
 0x24,0x25,0x49,0x49,0x22,0x02,0x48,0x90,0x24,0x09,0x49,0x4a,0x4a,0x22,0x42,
 0x1a,0xd8,0x14,0x55,0xa5,0x52,0x55,0x55,0xa5,0xaa,0xaa,0x52,0x4a,0x4a,0x55,
 0x52,0x55,0xa5,0x2a,0x55,0x55,0x55,0x55,0x55,0xaa,0xaa,0x52,0x55,0xa9,0x4a,
 0x55,0x55,0x55,0xa9,0xaa,0xaa,0xaa,0x52,0x55,0x55,0x55,0x55,0x55,0x55,0x95,
 0x2a,0x2a,0x50,0x28,0x01,0x10,0x10,0x00,0x00,0x88,0x08,0x88,0x00,0x00,0x00,
 0x41,0x42,0x48,0xc2,0x00,0x00,0x00,0x00,0x81,0x28,0x01,0x92,0x20,0x20,0x00,
 0x20,0x00,0x00,0x10,0x80,0xaa,0x6a,0x49,0x2a,0x95,0x92,0x24,0x29,0xa5,0x94,
 0x4a,0x55,0x29,0x55,0x55,0x2a,0x55,0xaa,0x4a,0xaa,0x92,0xaa,0xaa,0x92,0x54,
 0x55,0xa5,0xaa,0xaa,0xaa,0x4a,0xaa,0xaa,0x54,0x55,0x55,0x55,0x95,0xaa,0xaa,
 0xaa,0xaa,0xaa,0xaa,0x12,0x40,0x0a,0x95,0x20,0x81,0x04,0x42,0x24,0x21,0x10,
 0x21,0x20,0x88,0x48,0x00,0x00,0x00,0x88,0x20,0x21,0x49,0x24,0x24,0x00,0x90,
 0x90,0x24,0x05,0x92,0x84,0x92,0x92,0x84,0x24,0xa8,0x12,0xa5,0x92,0xaa,0x54,
 0x55,0x55,0x29,0xa5,0x54,0xa5,0xaa,0x92,0x4a,0xa5,0xaa,0x52,0x55,0x55,0xaa,
 0x4a,0x52,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0xa9,0x4a,0x55,0x55,0x55,0x55,
 0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x15,0x0a,0x51,0x21,0x05,0x24,0x20,
 0x08,0x01,0xd6,0x65,0x95,0x56,0x53,0x15,0x24,0x5d,0xab,0x52,0xab,0x16,0x40,
 0x82,0x20,0x49,0x0a,0x62,0x15,0x93,0x41,0x50,0x00,0x20,0x20,0x88,0xac,0xa4,
 0x2a,0x55,0x49,0x25,0xa9,0xa4,0xaa,0xaa,0x2a,0x29,0xa5,0x54,0x55,0xa9,0x94,
 0x4a,0x52,0xa5,0xaa,0x54,0x95,0xaa,0xaa,0xaa,0x2a,0xa5,0x54,0xaa,0xaa,0xaa,
 0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0x2a,0x40,0xa8,
 0x94,0x90,0x00,0x08,0x42,0x10,0x29,0x9a,0xaa,0xaa,0xac,0x6a,0x01,0xa5,0xda,
 0x6d,0xad,0x5a,0x12,0x20,0x08,0x00,0x40,0x4c,0x48,0x04,0x10,0x04,0x28,0x09,
 0x09,0x02,0x69,0x55,0x52,0xa9,0xa4,0x54,0x25,0x55,0x4a,0x29,0xa5,0xaa,0x54,
 0x55,0x29,0x55,0xa5,0xaa,0xaa,0x54,0x55,0x55,0x55,0x55,0x55,0x95,0x54,0x55,
 0x55,0x25,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0xa9,0xaa,0xaa,0xaa,0xaa,
 0x2a,0x15,0x0a,0x05,0x29,0x01,0x92,0xa0,0x10,0x44,0x82,0x40,0x00,0x80,0x42,
 0xf4,0x48,0xa9,0x24,0x92,0x52,0x2d,0x40,0x02,0x21,0x49,0x02,0x82,0x83,0x12,
 0x82,0x20,0x01,0x20,0x20,0x48,0x54,0x95,0xa4,0x92,0x2a,0xa5,0x4a,0x49,0xa9,
 0x4a,0x29,0xa5,0x4a,0x25,0x55,0xa5,0x2a,0x55,0x55,0x55,0x92,0xaa,0xaa,0xaa,
 0x92,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0x2a,0xa9,0xa4,0xaa,0xaa,0x56,
 0x55,0x55,0x55,0x55,0x55,0x29,0xa0,0xa8,0x84,0x44,0x20,0x04,0x80,0x00,0x25,
 0x08,0x48,0x25,0x10,0xa2,0x83,0x04,0x09,0x49,0x24,0x35,0x49,0x48,0x20,0x00,
 0xa8,0x14,0x54,0x46,0x21,0x48,0x48,0x4a,0x0a,0x09,0x58,0xa5,0x2a,0x55,0xaa,
 0x2a,0xa9,0xaa,0x2a,0xa9,0xaa,0x54,0xa9,0x54,0xa5,0x2a,0xa9,0xa4,0x94,0x4a,
 0x55,0x49,0x52,0x52,0xaa,0x52,0x55,0x29,0x55,0x55,0x55,0x55,0x52,0xaa,0x96,
 0x5a,0xa9,0x54,0xa9,0xaa,0xaa,0xaa,0xaa,0x4a,0x15,0x0a,0x92,0x2a,0x11,0x01,
 0x01,0x05,0x08,0x01,0x00,0x02,0x00,0x00,0xf4,0x42,0x11,0x20,0x04,0x51,0x5d,
 0x00,0x00,0x82,0x92,0x00,0x13,0x40,0x0a,0x84,0x00,0x01,0x20,0x40,0x20,0xd5,
 0x54,0x55,0xaa,0x92,0x54,0x2a,0x25,0xa5,0x2a,0xa5,0x4a,0x4a,0x55,0x4a,0xaa,
 0xaa,0x2a,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x49,0x55,0xa9,0xaa,0xaa,
 0xa4,0xaa,0xaa,0x54,0xa5,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0x2a,0x80,
 0x24,0xa1,0x00,0x48,0x50,0x20,0x82,0x08,0x42,0x00,0x00,0x44,0xa9,0x97,0xa4,
 0x4a,0x51,0x8a,0x34,0x92,0x92,0x28,0x20,0x24,0x96,0xc9,0x36,0x11,0x4a,0x24,
 0x09,0x12,0x0a,0x54,0x25,0x49,0x49,0xa9,0x92,0x4a,0xa9,0x54,0xa5,0x94,0x52,
 0x55,0xaa,0xaa,0x52,0x95,0xaa,0xaa,0x52,0x55,0x55,0x95,0xaa,0xaa,0xaa,0xaa,
 0xaa,0x4a,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,
 0x55,0x55,0x15,0x2a,0x48,0x4a,0x2a,0x29,0x09,0x12,0x92,0xa0,0x00,0x20,0xa4,
 0x12,0xf1,0x4d,0x15,0x01,0x44,0xa9,0x7e,0x40,0x92,0x84,0x24,0xc9,0x8d,0xb6,
 0x09,0x49,0x52,0x92,0xa4,0x24,0x49,0xb5,0x4a,0x92,0x92,0x4a,0xa5,0x54,0x4a,
 0x95,0x54,0x55,0x95,0x52,0x49,0x55,0x95,0xa4,0xa4,0x52,0xaa,0xa4,0xaa,0xaa,
 0x4a,0x55,0x4a,0x55,0x55,0x55,0xaa,0x92,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
 0xaa,0xaa,0xaa,0xaa,0xaa,0x2a,0x29,0x80,0x92,0x24,0x01,0x00,0x80,0x80,0x20,
 0x15,0x08,0x04,0x00,0xa0,0x6c,0x4f,0x49,0x52,0xa9,0x54,0x35,0x0a,0x00,0x20,
 0x02,0x40,0xd5,0xaa,0x66,0x00,0x00,0x00,0x00,0x40,0x20,0x54,0x51,0x55,0x55,
 0xaa,0x54,0xa5,0xaa,0x4a,0x95,0x4a,0xa9,0x2a,0x55,0x49,0xaa,0xaa,0xaa,0x4a,
 0x95,0x2a,0x49,0x52,0x55,0xa5,0xaa,0xaa,0x2a,0x55,0x55,0x55,0x55,0x55,0x55,
 0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x15,0x4a,0x24,0x49,0x48,
 0x22,0x22,0x14,0x80,0xd5,0x82,0x80,0xa0,0x4a,0xf3,0x45,0xb5,0x04,0x24,0xab,
 0x3a,0xa0,0x24,0x21,0x48,0x89,0x9a,0x96,0x22,0x55,0x52,0xa9,0xa4,0x12,0x09,
 0x54,0x95,0x2a,0x55,0x49,0x95,0x4a,0x49,0x52,0x29,0x29,0x55,0x4a,0x95,0xaa,
 0x52,0x55,0x95,0xaa,0xaa,0xaa,0xaa,0x2a,0xa9,0xaa,0xaa,0x54,0x52,0x55,0xa5,
 0xaa,0xaa,0x4a,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0x2a,
 0x10,0x48,0x92,0x02,0x80,0x00,0x00,0x09,0xfc,0x02,0x00,0x08,0xf4,0x5e,0x07,
 0x6f,0x91,0xd2,0xfc,0x9f,0x04,0x00,0x08,0x02,0x84,0xcc,0x6a,0x4d,0x80,0x00,
 0x00,0x10,0x00,0x42,0x59,0x55,0x91,0x24,0x55,0x52,0x52,0xaa,0x2a,0xa5,0xaa,
 0x4a,0xa9,0x52,0xaa,0x2a,0x29,0xa9,0x54,0xa9,0xaa,0xaa,0xaa,0xaa,0x54,0xa9,
 0xaa,0xaa,0xaa,0x2a,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x95,0xaa,0xaa,0xaa,
 0xaa,0xaa,0x4a,0x15,0x42,0xa5,0x24,0x91,0x24,0x44,0x12,0x20,0xa0,0x15,0x08,
 0x40,0xdd,0xfb,0x27,0x5d,0x44,0x55,0x57,0x15,0x50,0x92,0xa0,0x48,0x28,0xab,
 0xb6,0x84,0x09,0x52,0x22,0xa1,0x24,0x08,0xd4,0x24,0xa5,0xaa,0x92,0xaa,0xaa,
 0x92,0x54,0x55,0xa5,0x94,0xaa,0xaa,0x52,0xaa,0x4a,0x55,0x95,0x4a,0x52,0x55,
 0xa5,0xaa,0xaa,0x4a,0xa5,0xaa,0xaa,0xaa,0xaa,0x2a,0xa9,0xaa,0xaa,0xaa,0xaa,
 0x6a,0x55,0x55,0x55,0x55,0x55,0x55,0x12,0x28,0x28,0x92,0x00,0x00,0x10,0x40,
 0x04,0x92,0x05,0x80,0x04,0xf4,0x6e,0x05,0x54,0x81,0xa8,0xfd,0x5f,0x02,0x00,
 0x08,0x00,0x42,0xc4,0xaa,0x00,0x41,0x80,0x08,0x08,0x00,0x91,0x54,0x95,0xaa,
 0x92,0x54,0x25,0x25,0xa9,0xaa,0xaa,0x94,0x52,0x95,0x54,0x95,0x4a,0x55,0x25,
 0x55,0x55,0x55,0x92,0x54,0x55,0x95,0xaa,0xaa,0xaa,0x54,0x55,0x55,0xa5,0x56,
 0x55,0x55,0x55,0x55,0x95,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0x2a,0x82,0x44,0x25,
 0x49,0x92,0x80,0x08,0x20,0x82,0x2a,0x01,0xa0,0xba,0xbb,0x43,0x58,0x54,0xf5,
 0x57,0x0b,0x48,0x92,0x22,0x49,0x40,0x24,0x1b,0x12,0x09,0x09,0x20,0x21,0x49,
 0x04,0xaa,0x52,0x4a,0xaa,0x2a,0xa9,0x54,0x55,0x49,0x92,0xaa,0xaa,0xa4,0x4a,
 0x55,0xa9,0x54,0xaa,0x52,0x55,0x95,0xaa,0x2a,0xa5,0xaa,0xaa,0x2a,0x55,0xa5,
 0xaa,0x52,0xaa,0x54,0xa5,0xaa,0xaa,0x4a,0xaa,0x54,0x55,0x55,0x55,0x55,0x55,
 0x15,0x20,0x29,0x91,0x00,0x20,0x24,0x90,0x84,0x28,0x08,0x20,0x00,0xe8,0x4e,
 0x10,0x24,0x20,0x55,0x2d,0x21,0x41,0x00,0x20,0x00,0x49,0x84,0xa4,0x20,0x23,
 0x40,0x0a,0x24,0x00,0x48,0x6c,0xa9,0x52,0x55,0x92,0x94,0x4a,0x4a,0x2a,0x55,
 0x52,0x29,0x55,0x55,0x52,0x55,0xa5,0xaa,0xaa,0x52,0x55,0x55,0x55,0x55,0x52,
 0x55,0xa9,0x92,0xaa,0x54,0x55,0x55,0x55,0x55,0x55,0x55,0xa9,0x55,0xab,0xaa,
 0xaa,0xaa,0xaa,0x2a,0x15,0x0a,0x44,0x2a,0x25,0x01,0x01,0x01,0x00,0x82,0x48,
 0x00,0x82,0xfa,0x03,0x00,0x89,0x4a,0xfe,0x03,0x04,0x04,0x49,0x84,0x24,0x44,
 0x82,0x24,0x0c,0x82,0x24,0x20,0x80,0x92,0x00,0xa9,0x4a,0x2a,0x49,0x65,0xa5,
 0x54,0xa9,0x52,0xa9,0x4a,0x4a,0x29,0xa9,0x2a,0x25,0x55,0x49,0x95,0x2a,0xa9,
 0xaa,0x52,0x55,0x55,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
 0x2a,0x55,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0x2a,0x40,0x29,0x89,0x00,0x48,0x10,
 0x20,0x24,0x11,0x12,0x08,0x10,0xa0,0x17,0x49,0x28,0xa4,0x55,0x93,0x90,0x20,
 0x00,0x10,0x00,0x40,0x92,0x24,0x41,0x24,0x80,0x04,0x29,0x04,0x52,0x54,0x55,
 0x49,0xa5,0x14,0x55,0x25,0x25,0x55,0x95,0xaa,0xaa,0x4a,0x95,0xaa,0xaa,0x2a,
 0x55,0x52,0x55,0x55,0x49,0xaa,0x52,0x55,0x25,0x55,0x55,0x55,0x55,0xaa,0xaa,
 0x2a,0x55,0x55,0x55,0xd5,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0x12,0x0a,0x44,
 0x52,0x49,0x20,0x44,0x92,0x00,0x44,0x28,0x40,0x00,0xf5,0x26,0x00,0x86,0x48,
 0xff,0x00,0x01,0x42,0x4a,0xa1,0x92,0x2a,0x82,0x24,0x18,0x85,0x4a,0x90,0x20,
 0x90,0x08,0xb4,0x24,0x95,0x2a,0x55,0x29,0xa9,0xaa,0x4a,0xaa,0x54,0x29,0x55,
 0xaa,0xa4,0x54,0xa9,0xaa,0xaa,0xa4,0x4a,0x55,0x95,0xaa,0xaa,0xaa,0xaa,0xaa,
 0xaa,0x52,0x55,0x55,0x55,0x55,0x4a,0x4a,0x55,0x55,0x55,0x55,0x55,0x55,0x55,
 0x55,0x15,0x50,0x29,0x49,0x00,0x04,0x01,0x00,0x20,0x89,0x20,0x01,0x00,0xd0,
 0x0f,0x10,0x29,0x55,0xd5,0x48,0x44,0x10,0x00,0x04,0x00,0x20,0x92,0x20,0x11,
 0x10,0x00,0x04,0x04,0x02,0x00,0xaa,0x92,0x52,0x52,0xa5,0x4a,0x55,0x52,0x52,
 0x49,0x25,0x55,0xa9,0x52,0x95,0x2a,0x95,0x52,0x95,0xaa,0xaa,0xaa,0x52,0x55,
 0x55,0x55,0x95,0x54,0x52,0x55,0x95,0x2a,0xa5,0xaa,0xaa,0x55,0x55,0xaa,0xaa,
 0xaa,0xaa,0xaa,0xaa,0x4a,0x2a,0x02,0xa4,0x24,0x49,0x01,0x10,0x01,0x89,0x04,
 0x92,0x00,0x22,0xaa,0x8f,0x42,0x85,0xd4,0xbf,0x00,0x10,0x42,0x12,0x10,0x4a,
 0x24,0x82,0x44,0x90,0x94,0x48,0x22,0x50,0x48,0xaa,0x54,0x55,0xaa,0x4a,0x2a,
 0x55,0x4a,0xa5,0xaa,0x2a,0x55,0x92,0x52,0x95,0xaa,0x52,0xa5,0x94,0xaa,0x2a,
 0x29,0x55,0x55,0x2a,0x49,0xaa,0x52,0xa5,0x2a,0x55,0xa9,0x54,0x55,0x55,0x55,
 0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0x4a,0x55,0x55,0x15,0x50,0x11,0x92,0x24,0x68,
 0x49,0x54,0x12,0x40,0x65,0x44,0x00,0xc0,0x2b,0x08,0x01,0xa9,0x55,0x25,0x49,
 0x42,0x92,0xa5,0x24,0x49,0x92,0x4a,0x25,0x51,0x52,0x92,0x25,0x25,0x49,0xb4,
 0x4a,0x49,0xa9,0x92,0x24,0xa5,0x2a,0x29,0x55,0x49,0x55,0x95,0x54,0x55,0xaa,
 0x54,0x55,0xa9,0xaa,0xaa,0x92,0x54,0x55,0x55,0x55,0xaa,0xaa,0xaa,0xaa,0xaa,
 0xaa,0xaa,0x52,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0xb5,0xaa,0xaa,0x12,0x02,
 0xa4,0x24,0x01,0x01,0x00,0x00,0x80,0x24,0x10,0x00,0x80,0x54,0x1f,0x61,0xa4,
 0xfa,0x4e,0x10,0x00,0x08,0x00,0x00,0x00,0x10,0x21,0x48,0x20,0x24,0x00,0x00,
 0x80,0x00,0x00,0x54,0xa9,0x92,0x4a,0x55,0xa9,0x2a,0xa9,0x4a,0x49,0x55,0xa5,
 0xaa,0x2a,0xa9,0x4a,0x55,0xa5,0x4a,0x49,0x55,0x55,0xa5,0x52,0x55,0xa5,0xaa,
 0xaa,0xaa,0x4a,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0xa5,0xaa,0x4a,
 0x55,0x55,0x15,0xa8,0x92,0x92,0x10,0x08,0x12,0x09,0x80,0x84,0x42,0x01,0x10,
 0xc0,0x1f,0x40,0x21,0xaa,0x8b,0x84,0x12,0x81,0x48,0x48,0x22,0x25,0x89,0x48,
 0x20,0x81,0x24,0x49,0x24,0xa4,0x24,0x59,0x25,0x55,0x29,0x49,0x95,0xa4,0x94,
 0xaa,0xaa,0x54,0x2a,0x49,0xa5,0x4a,0xa9,0xaa,0x54,0xaa,0xaa,0x2a,0x55,0x55,
 0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
 0xaa,0x5a,0x55,0xaa,0xaa,0x4a,0x2a,0x02,0x24,0x25,0x41,0x20,0x40,0x50,0x52,
 0x00,0x92,0x88,0x04,0x4a,0x5b,0x14,0x44,0xfd,0x46,0x00,0x41,0x48,0x00,0x21,
 0x08,0x18,0x41,0x45,0x4a,0x29,0x40,0x00,0x21,0x00,0x08,0xd4,0xaa,0x24,0x55,
 0x55,0xaa,0x4a,0xa5,0x54,0x52,0xa5,0x54,0x55,0xaa,0xaa,0x2a,0x49,0x55,0x55,
 0xaa,0xa4,0xaa,0xaa,0x2a,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x25,0x95,0xaa,
 0xaa,0xaa,0xaa,0x4a,0x55,0xa5,0xaa,0x55,0x55,0x55,0x15,0x50,0x91,0xa8,0x08,
 0x04,0x09,0x00,0x00,0x92,0x80,0x02,0x00,0xa0,0x1e,0x50,0x29,0xab,0x81,0x22,
 0x08,0x02,0x24,0x04,0x02,0x11,0x89,0x48,0x40,0x40,0x15,0x52,0x08,0x49,0x22,
 0x55,0x49,0xaa,0x92,0x52,0x49,0xa9,0xaa,0x92,0x2a,0x95,0x4a,0x2a,0x95,0x24,
 0xa5,0x2a,0x95,0x4a,0x55,0x55,0x49,0xa9,0xaa,0x4a,0xaa,0x2a,0x49,0x92,0xaa,
 0xaa,0xaa,0x52,0x55,0x55,0x55,0xa9,0xaa,0x52,0x55,0x55,0xaa,0xaa,0xaa,0x12,
 0x02,0x2a,0x45,0x21,0x11,0x40,0x82,0x44,0x80,0x92,0x00,0x40,0x90,0x9f,0x14,
 0x90,0xfe,0xa4,0x08,0x00,0x48,0x80,0x90,0x50,0x08,0x21,0x94,0x84,0x84,0x40,
 0x00,0x21,0x00,0x00,0xac,0xaa,0x52,0x2a,0xa5,0x2a,0x95,0x94,0xaa,0x54,0xaa,
 0x52,0xc9,0x54,0x55,0x55,0x55,0xa9,0x54,0x29,0x55,0x55,0x4a,0x55,0x55,0x55,
 0x52,0x55,0x55,0x29,0x25,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0xad,0xaa,0xaa,
 0xaa,0x4a,0x55,0x15,0xa8,0x84,0x28,0x04,0xa0,0x08,0x28,0x20,0x15,0x20,0x89,
 0x00,0x80,0x3a,0x48,0xa4,0x6d,0x44,0x40,0x49,0x01,0x25,0x20,0x04,0x88,0x84,
 0x09,0x21,0x11,0x41,0x24,0xa0,0x94,0x9a,0x54,0x25,0x29,0xa5,0x2a,0xa5,0x52,
 0x4a,0x49,0x95,0x52,0x55,0x55,0x4a,0x55,0x29,0x49,0xa5,0xaa,0xaa,0xaa,0xaa,
 0xaa,0xa4,0x54,0xa5,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
 0xaa,0x52,0x55,0x55,0x55,0xb5,0xaa,0x2a,0x02,0x28,0x45,0x21,0x01,0x82,0x00,
 0x01,0x80,0x02,0x01,0x04,0x11,0x3f,0x03,0xa9,0x37,0x40,0x02,0x00,0x24,0x00,
 0x09,0x20,0x49,0x90,0xc8,0x88,0x40,0x05,0x81,0x04,0x00,0x00,0xb4,0x54,0xa5,
 0x2a,0x49,0x2a,0xa5,0x52,0xaa,0x52,0x25,0x29,0xa5,0xaa,0xa4,0xaa,0xaa,0x2a,
 0x55,0xa5,0x24,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,
 0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0xa5,0x4a,0x0a,0xa4,0x52,0xa9,
 0x08,0x10,0x20,0x08,0x24,0x84,0x20,0x12,0x20,0x40,0x75,0x2a,0xd2,0x1d,0x91,
 0x20,0x92,0x80,0x48,0x00,0x09,0x88,0x82,0x88,0x00,0x09,0x52,0x24,0x10,0x49,
 0x22,0xa9,0x92,0x54,0x52,0x55,0xa5,0x54,0xa9,0x2a,0xa9,0xaa,0x4a,0xa9,0x52,
 0x55,0x4a,0x55,0xaa,0x4a,0xaa,0xaa,0x92,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
 0xaa,0xaa,0xaa,0x2a,0xa9,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
 0x2a,0x10,0x84,0x04,0x41,0x42,0x00,0x21,0x90,0x22,0x22,0x0a,0x00,0x04,0xbe,
 0x40,0xb5,0x07,0x40,0x84,0x00,0x04,0x02,0x49,0x20,0x85,0x80,0x88,0x24,0x21,
 0x04,0x80,0x44,0x20,0x08,0xac,0x2a,0xa5,0xa4,0x54,0xaa,0x4a,0x4a,0xa5,0x4a,
 0x4a,0x55,0x95,0x2a,0x95,0x52,0xaa,0x52,0x55,0x55,0x55,0x55,0x49,0x55,0x25,
 0x95,0x52,0x52,0x55,0x55,0x55,0x49,0x55,0x55,0x52,0xa9,0x4a,0x55,0x55,0x55,
 0x55,0x55,0x55,0x55,0x15,0x05,0x29,0xa9,0x08,0x08,0x29,0x00,0x01,0x80,0x44,
 0x04,0x82,0x80,0x5a,0x12,0xea,0x22,0x49,0x11,0x24,0x41,0x20,0x00,0x04,0x90,
 0x90,0x88,0x00,0x0a,0x84,0x24,0x00,0x08,0x81,0x54,0xa5,0x52,0x55,0x4a,0x49,
 0x52,0x55,0x52,0x55,0x29,0xa9,0x54,0xa9,0x52,0x55,0x49,0x95,0x52,0x95,0xaa,
 0xaa,0xaa,0x94,0xaa,0x52,0x55,0x55,0x4a,0x2a,0xa9,0xaa,0x52,0x55,0x2d,0x95,
 0xaa,0x52,0x55,0x55,0x55,0x55,0x55,0x55,0x25,0x50,0xa4,0x24,0x21,0x20,0x00,
 0x09,0x14,0x05,0x02,0x29,0x00,0x50,0x3c,0xa1,0xba,0x01,0x84,0x80,0x00,0x48,
 0x84,0xa4,0x90,0x4c,0x82,0x0c,0x25,0x21,0x29,0x80,0xa4,0x02,0x4c,0xb4,0x4a,
 0x95,0x4a,0xa9,0xaa,0xaa,0x92,0x2a,0xa9,0xaa,0x92,0x52,0x4a,0x55,0x55,0x95,
 0xaa,0x94,0x52,0x49,0x4a,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,
 0x55,0x55,0xa9,0x6a,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x95,0x2a,0x0a,0x29,
 0x92,0x00,0x05,0x04,0x90,0x40,0x90,0x44,0x08,0x10,0x00,0x4a,0x10,0xed,0x89,
 0x80,0x20,0x48,0x02,0x11,0x10,0x04,0x42,0xa8,0x20,0x41,0x0c,0x10,0x29,0x10,
 0x40,0x01,0x54,0xa9,0x48,0x29,0x25,0x25,0x95,0x54,0x55,0x95,0x54,0x55,0x95,
 0xaa,0xaa,0x92,0x6a,0x52,0x55,0x55,0x55,0x55,0x2a,0x55,0xa9,0xaa,0xaa,0xaa,
 0xaa,0x52,0x95,0xaa,0xaa,0xaa,0x56,0x95,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
 0xaa,0x14,0x20,0x44,0x49,0x45,0x90,0x90,0x00,0x88,0x00,0x40,0x48,0x80,0x84,
 0x14,0xa4,0x3e,0x20,0x48,0x82,0x00,0x10,0x40,0x82,0x10,0x42,0x80,0x14,0x09,
 0x41,0x92,0x80,0x40,0x14,0x48,0xaa,0x92,0x2a,0x55,0x55,0xaa,0x28,0xa5,0xa4,
 0x52,0x49,0x2a,0x55,0x55,0x92,0x54,0x89,0xaa,0xaa,0x94,0xaa,0xaa,0x52,0xa5,
 0xaa,0x2a,0x25,0x95,0xaa,0xaa,0xaa,0x2a,0x55,0x55,0xa9,0xaa,0xaa,0xaa,0xaa,
 0xaa,0xaa,0xaa,0xaa,0xaa,0x2a,0x09,0x91,0x24,0x24,0x21,0x45,0x52,0x12,0x44,
 0x25,0x12,0x04,0x00,0x29,0x49,0x6f,0x8a,0xa4,0x24,0x4a,0x45,0x92,0xa4,0xa4,
 0x4a,0x92,0x24,0x21,0x4d,0x52,0x16,0xa5,0x24,0x49,0x68,0x55,0xa5,0x4a,0xa9,
 0x92,0xa6,0x2a,0x55,0x4a,0x55,0x49,0x49,0x25,0x55,0x55,0xb5,0x2a,0x55,0x55,
 0x55,0xa5,0xaa,0xaa,0x2a,0xa5,0xaa,0x52,0xa9,0xaa,0xaa,0xaa,0xaa,0x54,0x55,
 0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x15,0xa4,0x24,0x49,0x01,0x04,
 0x00,0x00,0x88,0x10,0x40,0x28,0x01,0x00,0x14,0xa4,0x35,0x00,0x40,0x00,0x00,
 0x50,0x04,0x00,0x00,0x42,0x84,0x10,0x01,0x08,0x00,0x40,0x08,0x00,0x02,0xad,
 0x92,0x94,0x94,0x92,0x54,0x4a,0x52,0x49,0x55,0xaa,0xaa,0x2a,0xa9,0xaa,0x4a,
 0x52,0x49,0x49,0x55,0x92,0x54,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,
 0x55,0x55,0x55,0x55,0x55,0x55,0x95,0xaa,0xaa,0xaa,0xaa,0xaa,0x4a,0x29,0x01,
 0x90,0xa4,0x40,0x00,0x20,0x84,0x04,0x82,0x14,0x10,0x80,0x48,0x02,0x69,0x3f,
 0x41,0x84,0x92,0x92,0x4a,0x83,0x48,0x24,0x21,0x91,0x24,0xa9,0x88,0xa4,0x10,
 0x42,0x92,0x48,0x54,0x55,0xaa,0x52,0xaa,0x4a,0xa9,0xaa,0x2a,0xa9,0x4a,0x2a,
 0xa5,0xaa,0x92,0x54,0x95,0xaa,0xaa,0x4a,0x55,0x55,0x4a,0x52,0x4a,0x55,0xa9,
 0xaa,0xaa,0xaa,0xaa,0x52,0xa5,0xaa,0xaa,0xaa,0xaa,0x6a,0x55,0x55,0x55,0x55,
 0x55,0x55,0x15,0x54,0x55,0x0a,0x09,0xa9,0x84,0x10,0x90,0x08,0x80,0xa1,0x10,
 0x00,0x14,0xd2,0x0d,0x04,0x51,0x00,0x41,0x10,0x2d,0x22,0x01,0x29,0x80,0x14,
 0x01,0x29,0x50,0x82,0x10,0x01,0x08,0x54,0x49,0x51,0xaa,0x52,0x55,0x55,0x49,
 0xaa,0x92,0x54,0x49,0xa9,0x4a,0x55,0x55,0x55,0x55,0x55,0xaa,0xaa,0xaa,0xaa,
 0xaa,0xaa,0xaa,0xaa,0xaa,0x4a,0x25,0x25,0x55,0x55,0x55,0x55,0x55,0x55,0x95,
 0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0x2a,0x01,0x88,0xa2,0x20,0x00,0x10,0x00,0x44,
 0x40,0x25,0x20,0x00,0x02,0x81,0x74,0x8f,0x20,0x80,0x24,0x10,0x85,0x28,0x54,
 0x20,0x21,0x92,0x10,0x12,0x90,0x44,0x20,0x44,0x48,0x22,0x69,0x55,0x95,0x4a,
 0x2a,0x49,0x92,0x54,0xa5,0xaa,0x92,0xaa,0x2a,0xa9,0x54,0x25,0x29,0x49,0x4a,
 0x55,0x55,0x49,0xa9,0xaa,0xaa,0x94,0x2a,0x55,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
 0xaa,0xaa,0xaa,0x52,0xa9,0xaa,0xaa,0xaa,0xaa,0xaa,0x14,0x54,0x51,0x54,0x01,
 0x11,0x81,0x24,0x01,0x02,0x80,0xa4,0x04,0x10,0x44,0xda,0x05,0x04,0x42,0x00,
 0x22,0x10,0x52,0xd1,0x0a,0x89,0x80,0x50,0x42,0x11,0x80,0x04,0x01,0x20,0x00,
 0xac,0x92,0xaa,0x54,0xa5,0xaa,0x2a,0xa5,0x2a,0x55,0x55,0x55,0xaa,0xaa,0x4a,
 0xaa,0xaa,0xaa,0xaa,0x52,0x92,0xaa,0x4a,0x55,0x55,0x55,0x55,0xa9,0xaa,0x54,
 0x55,0x55,0x2a,0x55,0x55,0x55,0x49,0xad,0x56,0x55,0x55,0x55,0x55,0x95,0x2a,
 0x01,0x14,0x25,0x48,0x20,0x08,0x10,0xa2,0x88,0x0a,0x41,0x40,0x00,0x90,0x76,
 0x93,0x80,0x48,0x49,0x09,0x84,0x28,0x84,0x82,0x28,0x90,0x14,0x0a,0x25,0xd2,
 0x48,0x60,0x0a,0x99,0x54,0x49,0x49,0x92,0x92,0x24,0x49,0x55,0x92,0x92,0x54,
 0x92,0x4a,0x55,0x52,0xa9,0x4a,0x55,0x55,0x55,0x55,0x55,0xaa,0xaa,0xa4,0xaa,
 0x4a,0x95,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0x54,0x55,0xb5,0x52,0x49,0x55,0x55,
 0x55,0x55,0x55,0x15,0x54,0xa1,0x48,0x01,0x82,0x20,0x02,0x02,0x00,0x20,0x40,
 0x01,0x44,0x00,0xdd,0x01,0x24,0x40,0x00,0xa0,0x10,0xa2,0x10,0xa5,0x20,0x89,
 0x10,0x22,0x20,0x00,0x01,0x0a,0x40,0x00,0xaa,0x2a,0x52,0x55,0xaa,0xaa,0xaa,
 0xa4,0xaa,0x54,0xa5,0xaa,0x94,0xa4,0xaa,0x4a,0xa9,0x24,0x29,0xa5,0xaa,0xaa,
 0x2a,0x49,0x55,0x55,0xaa,0xaa,0x52,0x55,0x55,0xa5,0xaa,0x52,0xab,0xaa,0x4a,
 0x55,0xb5,0xaa,0xaa,0xaa,0xaa,0xaa,0x12,0x01,0x54,0x52,0x92,0x10,0x82,0x80,
 0x48,0xa2,0x84,0x92,0x04,0x00,0xc4,0xf6,0x90,0x00,0x89,0x22,0x05,0x82,0x10,
 0x44,0x06,0x12,0x80,0x44,0x02,0xa0,0x12,0x91,0x00,0x12,0x92,0x68,0xa5,0x95,
 0x4a,0x55,0x92,0x94,0x2a,0xa9,0xaa,0x2a,0xa5,0x52,0x55,0x95,0x2a,0x55,0x55,
 0xa5,0x54,0x55,0x49,0xa5,0xaa,0xaa,0xa4,0xaa,0xaa,0xaa,0xaa,0x52,0x55,0xa5,
 0xaa,0x54,0x95,0xaa,0xaa,0x4a,0x55,0x55,0x55,0x55,0x55,0x2a,0x54,0x82,0x8a,
 0x00,0x24,0x08,0x28,0x22,0x04,0x04,0x80,0x90,0x00,0x51,0x5f,0x02,0x02,0x44,
 0x08,0x00,0x08,0x22,0x90,0xcc,0x48,0x22,0x14,0x92,0x45,0x40,0x02,0xb2,0x80,
 0x08,0x56,0x29,0x2a,0x29,0x49,0x55,0x29,0x49,0x25,0x25,0xa9,0x94,0xaa,0x4a,
 0xaa,0x54,0x25,0x55,0x55,0x95,0x24,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,
 0x55,0x95,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
 0x0a,0x01,0x34,0x51,0x24,0x01,0x00,0x02,0x01,0x80,0x10,0x89,0x02,0x20,0xc0,
 0x76,0x48,0x90,0x80,0x20,0x21,0x41,0x08,0x05,0x8a,0x10,0x88,0x41,0x04,0x40,
 0x24,0xa4,0x00,0x24,0x40,0x54,0x55,0x49,0x55,0x55,0xa9,0x4a,0x55,0x55,0x95,
 0x4a,0x55,0x95,0x54,0xa5,0xaa,0xaa,0x2a,0x55,0x55,0x55,0x55,0xaa,0xaa,0xaa,
 0xaa,0xaa,0xa4,0xaa,0x2a,0x55,0x55,0x55,0x55,0x95,0x54,0x55,0x55,0x55,0x55,
 0x55,0x55,0x55,0x95,0x2a,0x54,0x41,0x8a,0x00,0x40,0x91,0x00,0x50,0x24,0x42,
 0x00,0x01,0x02,0x90,0x1f,0x00,0x00,0xa4,0x00,0x08,0x08,0x21,0x50,0x55,0x94,
 0x80,0x28,0x24,0x12,0x82,0x04,0x22,0x80,0x04,0x59,0x49,0x55,0x92,0x24,0x25,
 0x55,0x2a,0xa9,0x54,0x55,0x2a,0xa9,0xaa,0x2a,0x25,0xa9,0xa4,0xaa,0xaa,0xaa,
 0xaa,0x52,0x55,0x92,0x2a,0x49,0x55,0x4a,0x52,0x55,0xa9,0xaa,0xaa,0x6a,0x55,
 0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x15,0x01,0x28,0xa1,0x92,0x28,0x04,
 0xa8,0x04,0x81,0x08,0x22,0x4a,0x88,0x84,0x7a,0x92,0x24,0x41,0x92,0x40,0x42,
 0x08,0x02,0x18,0x10,0x92,0x24,0x05,0x81,0x48,0x28,0x24,0x25,0x58,0x54,0xa5,
 0xa4,0xaa,0xaa,0x94,0x52,0x49,0x95,0x52,0x49,0x49,0xa5,0x92,0x54,0x55,0x55,
 0x55,0x25,0x49,0x55,0x95,0x2a,0x49,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x95,
 0x94,0x54,0x95,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0x24,0x54,0x95,
 0x4a,0x00,0x02,0x20,0x80,0x10,0x04,0x80,0x00,0x01,0x00,0x20,0x6f,0x00,0x00,
 0x84,0x00,0x04,0x01,0x00,0x88,0x4a,0x49,0x80,0x20,0x24,0x24,0x21,0x91,0x00,
 0x80,0x00,0xb4,0x2a,0x95,0x24,0x49,0x55,0x4a,0x55,0x2a,0x95,0xaa,0xaa,0x2a,
 0x55,0xa5,0x54,0x25,0x95,0xaa,0xaa,0x24,0xa9,0xaa,0xaa,0xaa,0x52,0x55,0x55,
 0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,
 0x55,0x15,0x01,0x40,0x24,0x25,0x29,0x89,0x12,0x92,0xa0,0x2a,0x49,0x16,0x20,
 0x40,0xfa,0x52,0x92,0x50,0x15,0x90,0x48,0x12,0x21,0x29,0x49,0x96,0x24,0x25,
 0x49,0x53,0x92,0xa8,0x2c,0xca,0x54,0x95,0xa4,0xaa,0xaa,0x4a,0x55,0x4a,0xa5,
 0x4a,0x29,0x25,0xa9,0x54,0x55,0x95,0x54,0xa9,0x54,0x55,0x55,0x55,0x55,0x55,
 0x55,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
 0xaa,0xaa,0xaa,0xaa,0xaa,0x2a,0x54,0x95,0x92,0x10,0x00,0x00,0x80,0x00,0x02,
 0x08,0x00,0x80,0x80,0x24,0xfd,0x00,0x00,0x42,0x00,0x41,0x03,0x08,0x04,0x2a,
 0x08,0x80,0x20,0x84,0x00,0x01,0x20,0x82,0x80,0x00,0x54,0xa9,0x2a,0x55,0x92,
 0x54,0x92,0x52,0xa9,0x54,0x4a,0x55,0xa5,0x4a,0x2a,0xa9,0xaa,0xaa,0xaa,0x2a,
 0x55,0xa5,0xa4,0xaa,0xaa,0xaa,0x4a,0x49,0x55,0x55,0x52,0x55,0x55,0x55,0x55,
 0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x25,0x15,0x01,0x50,0x49,0x02,0x01,
 0x49,0x24,0x50,0x40,0x81,0x24,0x14,0x08,0x40,0xda,0x09,0x92,0x80,0x00,0x10,
 0x24,0x42,0x40,0x25,0x08,0x91,0xa4,0x10,0x24,0x0a,0x49,0x20,0x22,0x24,0xb4,
 0x4a,0x92,0x24,0x55,0x4a,0x55,0x29,0x95,0x52,0x55,0xa9,0x2a,0x55,0xa5,0xa6,
 0x4a,0x4a,0x95,0xa4,0xaa,0xaa,0xaa,0x54,0xa5,0x2a,0x55,0x55,0x52,0x55,0x55,
 0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0x12,0x54,
 0x05,0x92,0x08,0x34,0x00,0x11,0x04,0x84,0x08,0x01,0x01,0x01,0x82,0xf6,0x91,
 0x00,0x54,0x82,0x44,0x83,0x08,0x09,0x8a,0x48,0x80,0x24,0x40,0x01,0x62,0x40,
 0x29,0x08,0x89,0x54,0xa9,0xaa,0x4a,0xa5,0x52,0xaa,0x4a,0x55,0x95,0x52,0x4a,
 0xaa,0x52,0xa9,0x28,0xa9,0x52,0x52,0x55,0x49,0x2a,0x55,0x25,0x55,0x55,0xa9,
 0xaa,0xaa,0xaa,0xaa,0xaa,0x52,0x55,0x55,0x55,0x55,0x52,0x55,0x55,0x55,0x55,
 0x55,0x55,0x15,0x01,0x68,0x29,0x81,0x00,0x24,0x80,0x08,0x11,0x08,0x12,0x28,
 0x80,0x20,0xf8,0x02,0x20,0x81,0x08,0x90,0x2a,0x2a,0x40,0x25,0x04,0x94,0x20,
 0x0a,0x48,0x02,0x92,0x00,0x41,0x00,0x59,0x25,0x49,0xa9,0x54,0x29,0x45,0xaa,
 0xa4,0x54,0x55,0x55,0x49,0x2a,0x95,0x56,0x55,0x55,0x55,0x55,0x55,0x55,0x95,
 0xaa,0xaa,0x4a,0x55,0x55,0x55,0x49,0x55,0x95,0xaa,0x94,0x52,0x55,0x4a,0xad,
 0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0x2a,0x54,0x92,0x44,0x24,0x40,0x00,0x42,0x20,
 0x80,0x20,0x40,0x06,0x24,0x88,0xea,0x23,0x02,0x40,0x00,0x41,0x41,0x85,0x84,
 0x92,0x24,0x81,0x08,0x20,0x02,0x84,0x80,0x44,0x04,0x12,0xd4,0xaa,0x52,0xaa,
 0x4a,0xaa,0x54,0xa9,0x2a,0xa5,0xa4,0x92,0xaa,0xaa,0xaa,0x54,0xa5,0xaa,0xaa,
 0x4a,0xaa,0x52,0xa9,0xaa,0x2a,0x55,0x95,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
 0xaa,0xaa,0xaa,0x52,0x55,0x55,0x55,0x55,0x55,0x55,0x15,0x81,0x48,0x52,0x01,
 0x29,0x92,0x10,0x08,0x8a,0x08,0x05,0x82,0x00,0x00,0xb9,0x8b,0x90,0x94,0x42,
 0x90,0x12,0x21,0xa9,0x10,0x08,0x90,0x64,0x09,0x91,0x54,0x10,0x21,0x90,0x88,
 0x54,0x49,0xaa,0x4a,0x52,0x95,0x2a,0x25,0xa9,0x2a,0x95,0x54,0x55,0x49,0xa9,
 0x92,0x94,0x24,0x55,0xa9,0xaa,0x2a,0x55,0x55,0xa5,0xaa,0xaa,0x94,0x2a,0x55,
 0x55,0x55,0x55,0x55,0x55,0xa5,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0x4a,0x12,
 0x24,0x92,0x24,0x09,0x00,0x00,0x40,0x22,0x20,0x02,0x82,0x01,0x80,0x44,0xf4,
 0x02,0x04,0x40,0x00,0xa2,0x41,0x08,0x52,0x44,0x46,0x84,0x00,0x40,0x00,0x08,
 0x45,0x89,0x00,0x20,0xac,0x52,0x25,0xa9,0xaa,0x52,0x49,0x55,0xa5,0x54,0x55,
 0xa5,0x24,0x55,0x55,0x55,0x55,0x55,0x49,0xaa,0x92,0x54,0x25,0xa9,0xaa,0x54,
 0x55,0x55,0x55,0x55,0x4a,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0x2a,0x55,0x55,0x55,
 0x55,0x55,0x55,0x15,0x88,0x48,0x92,0x80,0x84,0x44,0x24,0x08,0x81,0x50,0x90,
 0x88,0x24,0x00,0xd2,0x4f,0x20,0x44,0x41,0x48,0x01,0x42,0x29,0x11,0x10,0x51,
 0x55,0x12,0x49,0x22,0x00,0x02,0x4a,0x0a,0x54,0x55,0x52,0x95,0x14,0xa9,0x54,
 0x29,0x95,0x4a,0x29,0x55,0xaa,0xaa,0x94,0x54,0x55,0x55,0x55,0x55,0x55,0x55,
 0x55,0x55,0xa9,0x2a,0xa9,0x52,0xa9,0xaa,0xaa,0x52,0x95,0xaa,0xaa,0xaa,0xaa,
 0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0x2a,0x22,0x92,0x24,0x49,0x10,0x10,0x91,
 0x04,0x04,0x10,0x45,0x02,0x00,0x12,0xe9,0x07,0x81,0x44,0x00,0x51,0x54,0x88,
 0x44,0x49,0x8a,0x24,0x55,0x08,0x01,0x49,0x12,0x34,0x00,0x49,0xb5,0xa4,0x94,
 0x52,0xa9,0x4a,0x25,0xa5,0xaa,0x52,0x52,0xa9,0x52,0xa5,0x52,0xa5,0xa4,0x24,
 0x55,0xa5,0xaa,0x4a,0x55,0x25,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x95,0x54,
 0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x49,0x55,0x55,0x55,0x15,0x88,0x48,0x92,
 0x00,0x42,0x02,0x20,0x80,0x90,0x04,0xa0,0x40,0x85,0x40,0xa4,0x2e,0x08,0x80,
 0x22,0x84,0x02,0x25,0x91,0x0a,0x22,0x89,0xc8,0xaa,0x6a,0x10,0x80,0x04,0x49,
 0x00,0x54,0x95,0x4a,0x29,0xa5,0x54,0xaa,0x54,0x52,0xaa,0xaa,0x2a,0x95,0x94,
 0xaa,0x2a,0x95,0xaa,0xaa,0xaa,0x54,0x55,0xa9,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
 0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0x2a,0xb5,0xaa,0xaa,0xaa,
 0x12,0x22,0x92,0x24,0x09,0x08,0x88,0x04,0x25,0x80,0x10,0x14,0x28,0x10,0x00,
 0xf2,0x0f,0x20,0x52,0x00,0xb0,0x54,0x10,0x44,0x89,0x08,0x24,0x92,0x52,0x94,
 0x94,0x24,0x48,0x00,0x12,0xd4,0x52,0x52,0x4a,0x55,0x49,0x49,0x49,0xa5,0x4a,
 0x25,0xa5,0xaa,0xaa,0x4a,0x55,0x55,0x55,0x49,0x95,0x4a,0xaa,0x4a,0x55,0x95,
 0x54,0x25,0x95,0x52,0x52,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0xd5,
 0x4a,0x55,0x55,0x95,0x2a,0x88,0x48,0x52,0x21,0x21,0x21,0x20,0x04,0x24,0x10,
 0x49,0x41,0x02,0x92,0x88,0x9b,0x04,0x04,0x20,0x09,0x09,0x05,0x91,0x24,0x46,
 0x81,0xa4,0x88,0xa2,0x50,0x01,0x29,0x92,0x88,0x54,0x29,0x55,0x55,0x49,0x2a,
 0x55,0x55,0x99,0x52,0xaa,0x52,0x49,0x55,0xa9,0xa4,0xaa,0x92,0x2a,0xa9,0xaa,
 0x52,0xaa,0x54,0x55,0x95,0xaa,0xaa,0xaa,0xaa,0x4a,0x55,0x55,0xa9,0xaa,0xaa,
 0xaa,0xaa,0xaa,0x2a,0xb5,0xaa,0x4a,0x55,0x15,0x22,0x92,0x0a,0x04,0x00,0x00,
 0x12,0x90,0x80,0x40,0x14,0x48,0x41,0x00,0x64,0x1f,0x20,0x51,0x01,0x44,0x20,
 0x90,0xa0,0x04,0x10,0x24,0x00,0x21,0xa4,0x00,0x24,0x10,0x00,0x20,0xac,0x4a,
 0x49,0x52,0xaa,0x52,0x29,0xa5,0xa2,0x54,0x49,0x2a,0x95,0x24,0x55,0x55,0x52,
 0xaa,0xaa,0xaa,0x54,0x95,0xaa,0xaa,0xaa,0xaa,0x54,0x55,0x55,0x55,0xaa,0xaa,
 0xaa,0x2a,0x95,0x54,0x55,0x55,0x55,0x55,0x55,0x55,0xb5,0xaa,0x14,0x80,0x48,
 0xa1,0x01,0x29,0x89,0x10,0x05,0x88,0x14,0x0a,0x60,0x08,0x24,0x91,0x5f,0x04,
 0x04,0x10,0x01,0x89,0x04,0x48,0x05,0x05,0x81,0x54,0x14,0x51,0x12,0x00,0x52,
 0x52,0x8a,0x54,0xa5,0xaa,0x2a,0x55,0x4a,0x95,0x94,0xac,0x2a,0x55,0x95,0xaa,
 0xaa,0x2a,0x55,0x95,0xaa,0x54,0xa5,0xaa,0xaa,0x52,0x55,0x52,0x55,0x55,0xa9,
 0x54,0x55,0x55,0x55,0x25,0x55,0x55,0xab,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0x4a,
 0x95,0x2a,0x0a,0x12,0x4a,0x34,0x21,0x48,0x12,0x92,0x24,0x11,0x21,0xaa,0x42,
 0x00,0x64,0x3b,0x92,0x00,0x42,0x08,0x20,0x90,0xa0,0xb0,0x20,0x14,0x82,0x40,
 0x6a,0x72,0x9b,0xa4,0x24,0x49,0xb4,0x54,0x92,0xa4,0xa2,0x2a,0xa9,0xaa,0x52,
 0xa5,0xaa,0x52,0x29,0x55,0x49,0x49,0x55,0x25,0xa5,0x2a,0x25,0x55,0x95,0xaa,
 0xaa,0x52,0x55,0x55,0x95,0xaa,0xaa,0xa4,0xaa,0xaa,0xaa,0x54,0x29,0x55,0x55,
 0x55,0x55,0x55,0x55,0x55,0x25,0xa0,0x54,0x29,0x01,0x08,0x02,0x48,0x00,0x80,
 0x40,0x0a,0x50,0x09,0x11,0x91,0x3e,0x00,0x91,0x00,0x20,0x09,0x02,0xa4,0x04,
 0x00,0x81,0x20,0x94,0x90,0x00,0x40,0x40,0x00,0x00,0xa9,0x2a,0x55,0x55,0x29,
 0xa5,0x4a,0x25,0x55,0x52,0x25,0xa9,0xa4,0x92,0xaa,0x2a,0xa9,0x54,0x55,0x55,
 0x55,0x49,0x55,0x49,0x55,0xaa,0xaa,0x4a,0x55,0x95,0xaa,0x5a,0xaa,0xaa,0xaa,
 0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0x2a,0x55,0x55,0x15,0x0a,0xa0,0x44,0x44,0xb4,
 0xaa,0xaa,0xd6,0x56,0x55,0x41,0xed,0x04,0x44,0x48,0xfb,0x5a,0x00,0x24,0x09,
 0x40,0x48,0x52,0x4b,0x94,0x04,0x92,0x00,0xe2,0x76,0x95,0x95,0xb6,0x5d,0x56,
 0x49,0x49,0x49,0x56,0x2a,0x55,0xaa,0x4a,0x95,0x54,0x55,0x55,0x55,0x2a,0x55,
 0xa5,0xaa,0x2a,0xa9,0xaa,0xaa,0x54,0x55,0x55,0x55,0x25,0x55,0x55,0x55,0x55,
 0xa5,0xaa,0xaa,0xaa,0x4a,0x55,0x55,0x52,0x55,0x55,0xd5,0xaa,0xaa,0x14,0x40,
 0x15,0x2a,0x01,0xaa,0xb5,0x55,0x6b,0x5b,0x5d,0x00,0x74,0x4b,0x00,0x22,0x7d,
 0xad,0x05,0x01,0x40,0x12,0x11,0xc0,0x16,0x00,0xa8,0x00,0x94,0x50,0xab,0xed,
 0xf6,0x6d,0xab,0x6b,0xa5,0xa4,0x54,0x49,0xa5,0x92,0x92,0xa4,0xaa,0xaa,0x2a,
 0x95,0x54,0xa5,0x52,0x55,0x4a,0x55,0x55,0xa5,0xaa,0xaa,0xaa,0xaa,0x4a,0xaa,
 0xaa,0xaa,0x52,0x25,0x55,0x55,0x55,0x55,0xb5,0xaa,0x4a,0xad,0xaa,0xaa,0x2a,
 0x55,0x95,0x2a,0x0a,0xa4,0x50,0x49,0x6c,0x6b,0xb7,0xad,0xea,0x2a,0x49,0xdd,
 0x22,0x12,0x90,0xf6,0x75,0x20,0x48,0x02,0x40,0x40,0xaa,0x05,0x28,0x51,0xa4,
 0x02,0xa4,0xd6,0x5a,0xab,0xba,0x77,0x55,0x95,0x2a,0x95,0x52,0x4a,0xaa,0x54,
 0x95,0x24,0x49,0x52,0xa9,0x4a,0x55,0x95,0xaa,0x52,0x52,0x25,0x55,0x55,0x25,
 0x55,0x52,0x55,0x55,0x55,0x52,0x55,0x55,0x55,0x55,0xaa,0xaa,0x4a,0x55,0xb5,
 0x52,0x55,0x55,0x55,0x55,0x55,0x15,0xa0,0x92,0x0a,0x00,0x96,0x14,0x48,0x20,
 0x11,0x55,0x00,0xf5,0x0a,0x40,0x22,0x7d,0x8a,0x02,0x01,0x50,0x15,0x01,0x40,
 0x25,0x02,0xaa,0x00,0x50,0x89,0x55,0x55,0x55,0xd5,0x54,0xab,0x52,0x95,0x52,
 0xaa,0x52,0x49,0xaa,0xaa,0xaa,0xaa,0x2a,0x55,0x55,0xa9,0x54,0x92,0xaa,0x2a,
 0x55,0x29,0x49,0xaa,0xaa,0xaa,0x54,0x55,0xa5,0xaa,0xaa,0xaa,0xaa,0x4a,0x55,
 0x55,0x55,0x55,0x95,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0x12,0x0a,0x24,0x69,0x89,
 0x02,0xa0,0x00,0x85,0x04,0x08,0x51,0x1d,0x24,0x01,0x48,0x5a,0x20,0x48,0x48,
 0x05,0x40,0x90,0x54,0x04,0x48,0x14,0xa2,0x24,0x52,0xaa,0x92,0x54,0x25,0x55,
 0x6d,0x25,0xa9,0xaa,0x4a,0x55,0x55,0x45,0x52,0xa9,0x92,0xa4,0x92,0x94,0x4a,
 0xa5,0xaa,0x54,0x55,0x55,0x55,0x55,0x55,0x49,0x95,0xaa,0xaa,0xaa,0x2a,0x55,
 0xaa,0xaa,0xb4,0xaa,0xaa,0xaa,0xaa,0x6a,0x55,0x55,0x55,0x55,0x55,0x55,0x15,
 0x40,0x49,0x12,0x21,0xa5,0x0a,0xaa,0x20,0x40,0x25,0x88,0x76,0x4a,0x50,0x02,
 0x75,0x15,0x21,0x00,0xa8,0x2a,0x00,0xa1,0x02,0x80,0xaa,0x00,0xd1,0xa9,0x52,
 0xaa,0x2a,0x55,0xa5,0x55,0xa9,0xa4,0x24,0x25,0x49,0x4a,0xa9,0x4a,0x4a,0xaa,
 0xaa,0x54,0xa5,0x2a,0x55,0x55,0x95,0x52,0xa9,0x4a,0x55,0xa5,0xaa,0xaa,0xaa,
 0x92,0x54,0x55,0x55,0x55,0xa5,0x4a,0x55,0x52,0x55,0x55,0x95,0xaa,0xaa,0xaa,
 0xaa,0xaa,0x4a,0x2a,0x0a,0x94,0xa4,0x00,0x09,0x50,0x00,0x8a,0x0a,0x0a,0x50,
 0x1f,0x25,0x02,0xa8,0x7e,0x40,0x8a,0x88,0xaa,0x2a,0x10,0x54,0x12,0x15,0x15,
 0x20,0x24,0xa6,0x4a,0x55,0xa5,0xaa,0xaa,0x54,0x95,0x4a,0x55,0xaa,0xaa,0x94,
 0x2a,0x55,0x55,0x55,0x95,0x2a,0x55,0xaa,0xaa,0xa4,0x2a,0x95,0x4a,0x55,0xa5,
 0x2a,0x55,0x55,0x95,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0x95,0xaa,0xaa,
 0xaa,0xaa,0xaa,0x2a,0x55,0x55,0x55,0x15,0x40,0x21,0x49,0x14,0x53,0x85,0xaa,
 0x20,0xa0,0x04,0xa5,0x0d,0x90,0x48,0x42,0xe8,0x2a,0x2a,0x20,0xa8,0x88,0x00,
 0x21,0x01,0x40,0xaa,0x02,0xd1,0x51,0x29,0x49,0x52,0x49,0xd2,0xa9,0x4a,0xa9,
 0xa4,0x92,0x94,0xaa,0x94,0x52,0xa9,0x92,0xa4,0x4a,0x55,0xa5,0x24,0x95,0xa4,
 0xaa,0xaa,0x54,0xaa,0x54,0x55,0xa9,0xaa,0xaa,0x2a,0xa9,0x4a,0x55,0x55,0x55,
 0x55,0x6a,0x55,0x55,0x55,0x55,0x55,0xd5,0xaa,0xaa,0xaa,0x12,0x2a,0x54,0x92,
 0xc0,0x04,0x12,0x00,0x82,0x04,0x11,0x68,0xa7,0x4c,0x00,0x88,0xfa,0x40,0x01,
 0x00,0x15,0x25,0x48,0x54,0x05,0x82,0x4a,0x20,0xa4,0x2a,0x55,0x95,0x2a,0x55,
 0x55,0x6d,0x29,0x25,0x95,0x54,0xa9,0xa4,0x52,0x95,0x92,0x54,0x55,0x52,0x4a,
 0xa9,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0x2a,0xa5,0xaa,0x4a,0xa9,0x54,0x55,0x55,
 0x55,0x49,0xaa,0xaa,0x54,0x95,0xaa,0xaa,0xaa,0xaa,0xaa,0x2a,0x55,0x55,0x55,
 0x15,0x00,0x89,0x24,0x85,0xa2,0x88,0xaa,0x28,0x41,0x45,0xd2,0x0d,0x28,0x92,
 0x02,0xa4,0x2b,0xa8,0x48,0x50,0x11,0x00,0xa1,0x00,0x28,0x25,0x00,0xa9,0x94,
 0x92,0xaa,0xaa,0xaa,0x6a,0xa9,0xa4,0xaa,0xaa,0xaa,0x4a,0x2a,0x55,0x52,0xaa,
 0x4a,0xaa,0xaa,0x52,0x55,0x55,0x55,0x55,0xa5,0x94,0x4a,0x55,0x55,0x49,0x55,
 0x55,0x55,0xa5,0xaa,0x54,0x55,0x55,0x55,0x55,0x55,0x55,0x49,0xa9,0xaa,0xaa,
 0xaa,0xaa,0xaa,0xaa,0x2a,0x2a,0x24,0x49,0x50,0x89,0x24,0x00,0x01,0x94,0x00,
 0xb5,0xa7,0x90,0x00,0x50,0xd9,0x41,0x05,0x00,0x1d,0x4a,0x10,0x54,0x81,0x80,
 0x4a,0x20,0x50,0xa5,0x54,0x52,0x52,0x92,0xd4,0x54,0x55,0x24,0x49,0x25,0x55,
 0x55,0x4a,0x55,0x55,0x55,0x49,0x55,0x55,0x4a,0x4a,0x92,0x92,0x54,0x55,0xa9,
 0xa4,0xaa,0xaa,0xaa,0xaa,0x2a,0x55,0x55,0x55,0x55,0xa5,0xa4,0xaa,0xaa,0xaa,
 0x56,0x55,0x55,0x55,0x55,0x55,0x55,0x95,0x14,0x80,0x92,0x94,0x82,0x24,0x02,
 0x55,0x54,0x41,0x81,0xe8,0x02,0x54,0xa5,0x04,0xe5,0x2a,0x20,0x24,0x52,0x11,
 0x04,0x29,0x0a,0xa4,0x16,0x81,0xaa,0x52,0x4a,0x95,0x4a,0x55,0xb5,0xb4,0x2a,
 0x55,0x55,0x92,0x24,0x49,0xa5,0x2a,0x25,0xa9,0x2a,0x49,0xaa,0xaa,0x52,0x55,
 0xaa,0xaa,0x4a,0x55,0x55,0x55,0xaa,0x54,0x4a,0xa5,0xaa,0x4a,0x55,0x55,0x55,
 0x55,0x55,0x55,0x95,0x52,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x15,0x4a,0x28,
 0x51,0x64,0x91,0xa8,0x00,0x01,0x34,0x14,0xdd,0x49,0x21,0x00,0x10,0xda,0x43,
 0x15,0x80,0x2c,0x05,0x50,0x54,0x81,0x00,0x49,0x10,0x50,0x95,0x52,0xaa,0x54,
 0xa5,0x6a,0x54,0x51,0x49,0x92,0xaa,0xaa,0x52,0x2a,0x49,0xa9,0x92,0x52,0x95,
 0x92,0x52,0x55,0x55,0x55,0x95,0x54,0xaa,0x2a,0x49,0x55,0x55,0x55,0xaa,0x4a,
 0x55,0xa5,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
 0xaa,0x2a,0x10,0x8a,0x0a,0xa1,0x24,0x12,0x54,0x52,0x91,0xa0,0xf6,0x12,0xa8,
 0x2a,0x85,0xa2,0x17,0x02,0x10,0x92,0x50,0x00,0xa1,0x04,0xa9,0x16,0x80,0x54,
 0xa9,0xaa,0x92,0xaa,0x54,0x59,0xa9,0x2a,0x55,0x55,0xa9,0x92,0x2a,0xa5,0xaa,
 0x2a,0x55,0xaa,0x52,0x55,0x55,0xaa,0xa4,0x92,0x52,0x55,0x25,0xa9,0xaa,0xaa,
 0x4a,0x55,0x55,0xa9,0x54,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0xaa,
 0xaa,0xaa,0xaa,0xaa,0x4a,0x15,0x42,0x50,0x54,0x69,0x92,0x48,0x01,0x08,0x4c,
 0x80,0x5a,0x41,0x22,0x01,0x10,0xd4,0xa2,0x28,0x42,0x2c,0x05,0x04,0x5c,0x22,
 0x84,0x42,0x28,0xb2,0x52,0x4a,0x55,0x49,0x95,0x2a,0x6c,0xa5,0x92,0xaa,0x4a,
 0xaa,0x54,0x29,0x55,0x4a,0xa5,0x92,0x54,0xaa,0x94,0x92,0x2a,0x55,0x55,0x55,
 0x55,0x55,0x55,0x25,0x55,0xa9,0xaa,0xaa,0xaa,0x2a,0xa9,0xaa,0x2a,0xa9,0xaa,
 0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0x24,0x10,0x2a,0x89,0xa0,0x44,
 0x12,0xa8,0x82,0x12,0x54,0x7d,0x90,0xc4,0x44,0x85,0xd4,0x17,0x05,0x00,0x95,
 0x14,0x50,0x22,0x01,0x40,0x16,0x80,0x50,0x2a,0x25,0x29,0x55,0x52,0xba,0x54,
 0x29,0x49,0x91,0x54,0x55,0x4a,0x55,0x49,0x55,0xa9,0xaa,0x4a,0x25,0x55,0x55,
 0x55,0x55,0x2a,0x25,0x55,0x95,0xaa,0x54,0x55,0x55,0x55,0x55,0x55,0xaa,0x2a,
 0x25,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x15,0x4a,
 0x41,0x25,0x19,0x12,0x41,0x05,0x54,0x8a,0x90,0xb6,0x02,0x50,0x12,0x10,0xa2,
 0x4f,0x48,0x94,0x54,0x42,0x00,0x59,0x4a,0x89,0x42,0x24,0xaa,0xa4,0x54,0x52,
 0xaa,0xaa,0x2e,0x54,0x55,0xaa,0x2a,0x49,0x92,0x92,0xa4,0xaa,0xa4,0x4a,0x4a,
 0x55,0x55,0xa5,0xaa,0xa4,0xa4,0x52,0x55,0x55,0xa9,0xa4,0xaa,0xaa,0xaa,0x92,
 0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
 0xaa,0xaa,0x2a,0x00,0x94,0x50,0xa2,0x44,0x94,0x50,0x01,0x05,0xa4,0x2f,0x50,
 0x85,0x84,0xa4,0x50,0x2f,0x12,0x00,0x9a,0x14,0x48,0xa8,0x02,0x20,0x11,0x08,
 0x29,0x55,0x55,0x55,0x25,0x49,0x15,0xb4,0x4a,0x95,0xa4,0xaa,0x4a,0x55,0x95,
 0x24,0x95,0x54,0x29,0xa9,0x52,0x55,0x92,0xaa,0xaa,0xaa,0xaa,0x92,0xaa,0xaa,
 0xaa,0x52,0x2a,0x55,0x29,0x55,0x55,0x55,0x55,0xa5,0xaa,0x54,0xa9,0xaa,0xaa,
 0xaa,0xaa,0xaa,0xaa,0xaa,0x2a,0x15,0xaa,0x28,0x45,0x59,0x92,0x48,0x02,0xaa,
 0x90,0x54,0x9d,0x02,0x90,0x0a,0x00,0xca,0x4d,0x09,0xa2,0x24,0x01,0x00,0x15,
 0x25,0x05,0x42,0x21,0x5a,0x49,0x92,0x4a,0xa9,0xaa,0xba,0x54,0x91,0x52,0x55,
 0x25,0x55,0x2a,0xa9,0xaa,0xaa,0xaa,0xaa,0x92,0x94,0x54,0x55,0x95,0x4a,0x55,
 0x52,0x55,0x55,0x95,0xaa,0xaa,0x52,0x55,0x55,0xa9,0xaa,0xaa,0xaa,0xaa,0xaa,
 0xaa,0xaa,0xaa,0x52,0x55,0x55,0x55,0x55,0x55,0x55,0x29,0x00,0x44,0x29,0x94,
 0x24,0x25,0x54,0x41,0x05,0xd2,0x27,0x54,0xa5,0xa2,0x2a,0x21,0x3f,0x02,0x08,
 0x9a,0x14,0x4a,0x54,0x09,0x90,0x14,0x48,0x25,0x55,0x55,0x55,0x55,0x55,0x4d,
 0x59,0x55,0x49,0x2a,0xa9,0x52,0xa5,0x4a,0x95,0x52,0x25,0x55,0x55,0x55,0xa5,
 0xaa,0x52,0x55,0x4a,0x55,0xaa,0x92,0x54,0x55,0x55,0x55,0x55,0x55,0x95,0x52,
 0x55,0xa9,0xaa,0xaa,0x4a,0x55,0x55,0xad,0xaa,0xaa,0xaa,0xaa,0xaa,0x4a,0x15,
 0xaa,0x12,0x52,0x6d,0x7b,0xbb,0x7b,0x1f,0x90,0x6c,0xdf,0x6b,0xdb,0x0a,0x80,
 0x54,0xfd,0x4d,0x40,0x75,0x07,0x00,0x75,0x57,0x40,0x40,0x82,0xda,0x6d,0xdb,
 0xda,0xb6,0x6d,0x4b,0xd4,0x2a,0x55,0x49,0x95,0xa4,0x94,0x2a,0xa9,0x94,0x54,
 0x92,0x2a,0x55,0x95,0x24,0x55,0x52,0x55,0x55,0x55,0xaa,0xaa,0x24,0xa5,0xaa,
 0xaa,0xaa,0xaa,0xaa,0x52,0x55,0x55,0x55,0x55,0x55,0x95,0x52,0x55,0x55,0x55,
 0x55,0x55,0x55,0x15,0x00,0x54,0x89,0x90,0x84,0x90,0x84,0xa8,0x02,0xf5,0xa5,
 0x90,0x24,0x92,0x24,0x20,0xf7,0x03,0x12,0x8a,0x10,0xa4,0x94,0x10,0x15,0x92,
 0x50,0xa5,0x92,0x84,0x44,0x49,0xa2,0x44,0xa8,0x92,0x2a,0x55,0x4a,0x55,0x52,
 0x52,0xa5,0xaa,0x4a,0x55,0x92,0x4a,0xaa,0xaa,0x4a,0x55,0xa9,0xaa,0x92,0xaa,
 0x4a,0x55,0x55,0x55,0x49,0x49,0x55,0x55,0xaa,0xaa,0x52,0xaa,0xaa,0xaa,0xaa,
 0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0x2a,0x2a,0x21,0x25,0x01,0x00,0x02,0x10,
 0x0a,0xa8,0xda,0x56,0x02,0x80,0x4a,0x90,0x42,0x7d,0x0b,0x40,0x05,0x02,0x01,
 0x15,0x94,0x80,0x00,0x44,0x81,0x00,0x10,0x50,0x00,0x48,0x20,0x56,0xa5,0x48,
 0xa9,0x54,0x4a,0x55,0xa5,0x2a,0x25,0x55,0xa9,0xaa,0x54,0xa9,0xaa,0x54,0x95,
 0x4a,0x92,0xaa,0xaa,0x52,0x55,0x55,0x4a,0x55,0x55,0xaa,0xaa,0x2a,0x95,0xaa,
 0x52,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x12,0x40,0x48,0x91,
 0x88,0x64,0x30,0x51,0x25,0x41,0xb4,0xdf,0x57,0x48,0x15,0x05,0xa8,0xfa,0x07,
 0x11,0x4a,0x10,0x20,0x2a,0x11,0x20,0x48,0x52,0x11,0x91,0xc4,0x84,0x64,0x82,
 0x18,0xb4,0x52,0xa5,0x94,0x4a,0xa5,0x2a,0x29,0xa9,0x52,0x29,0x25,0x55,0x55,
 0x55,0x49,0x55,0x52,0x55,0x55,0x55,0x55,0xaa,0xaa,0x54,0x55,0x55,0x55,0x55,
 0x55,0x55,0x55,0x55,0x55,0x55,0x55,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0x4a,
 0x15,0x0a,0x15,0x2a,0x21,0x00,0x09,0x64,0x85,0x88,0x7e,0xb5,0x0e,0xf1,0x05,
 0xa8,0x84,0xd6,0x12,0x44,0x05,0x09,0x85,0x14,0x4a,0x82,0x22,0x35,0x01,0x01,
 0x00,0x80,0x00,0x10,0x47,0x54,0x95,0xaa,0x52,0xa9,0x94,0xa4,0x4a,0xa5,0xac,
 0x52,0x55,0x92,0x92,0x4a,0x2a,0xa5,0xaa,0xaa,0xaa,0x54,0x92,0x2a,0x55,0xa5,
 0xaa,0xaa,0xaa,0xaa,0xa4,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0x2a,0x55,0x55,
 0x55,0x55,0x55,0x55,0x15,0x90,0x40,0x89,0x04,0x12,0x42,0xb5,0x22,0xa2,0xaa,
 0xef,0x0d,0x5c,0xaa,0x02,0x91,0xb4,0xae,0x80,0x4a,0x00,0x20,0x55,0x11,0x00,
 0x49,0x0a,0x4a,0x3e,0x29,0x92,0x90,0x04,0x88,0x54,0x29,0x29,0x95,0x54,0xaa,
 0x52,0xaa,0x2a,0x45,0xaa,0xaa,0xaa,0xaa,0x52,0x55,0x55,0x55,0x52,0x95,0xaa,
 0xaa,0xaa,0x4a,0x55,0xa5,0x54,0xa9,0x4a,0x55,0x55,0x55,0x55,0x55,0x55,0xa5,
 0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0x2a,0x42,0x2a,0x25,0x51,0x29,0x5d,
 0x4d,0x08,0x28,0x55,0xda,0xe7,0x53,0x15,0x48,0x44,0x69,0x55,0x12,0x4b,0x82,
 0x88,0x4a,0x52,0x20,0x52,0x25,0x21,0x41,0x52,0x92,0xa5,0xa4,0x48,0xb4,0x52,
 0x52,0xaa,0x92,0x52,0x4a,0x29,0xa9,0xaa,0x4a,0x52,0x25,0x55,0xaa,0xaa,0x94,
 0xa4,0x2a,0xa9,0x52,0x55,0xa5,0x54,0x55,0xaa,0x4a,0x55,0x55,0x55,0xaa,0xaa,
 0x4a,0x55,0xaa,0xaa,0xaa,0xaa,0x52,0x55,0x55,0x55,0x55,0x55,0x12,0x10,0x90,
 0xa8,0x04,0x00,0x52,0xa5,0x22,0x51,0xaa,0xea,0x16,0xac,0x42,0x12,0x11,0x95,
 0xd5,0x80,0x04,0x10,0x22,0x2a,0x94,0x80,0x88,0x1a,0x8a,0x40,0x00,0x00,0x01,
 0x00,0x02,0x54,0x95,0x4a,0x49,0x4a,0x95,0xaa,0x4a,0x95,0x54,0xa5,0x4a,0x52,
 0x49,0x55,0x92,0x52,0x55,0x55,0x55,0x95,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0x2a,
 0xa9,0xaa,0x4a,0x49,0xa9,0xaa,0x55,0x55,0x55,0x55,0xad,0xaa,0xaa,0xaa,0xaa,
 0xaa,0x2a,0x4a,0x25,0x45,0x10,0x22,0xaa,0x14,0x08,0x84,0xa4,0xb4,0x67,0x91,
 0x14,0x41,0x44,0x52,0x6a,0x24,0x23,0x05,0x80,0x82,0x28,0x10,0x22,0x6a,0x42,
 0x94,0x44,0x09,0x8a,0x94,0x90,0x54,0xa9,0x94,0xaa,0xaa,0xa4,0x94,0x54,0xaa,
 0x92,0x54,0xaa,0xaa,0xaa,0x92,0xaa,0xaa,0x4a,0x4a,0x55,0xaa,0x24,0x55,0x55,
 0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0xaa,0xaa,0xaa,0xaa,0x52,
 0x55,0x55,0x55,0x55,0x55,0x15,0x00,0x50,0x91,0x82,0x88,0x54,0x42,0x42,0x51,
 0x12,0xed,0x85,0x4a,0x42,0x10,0x11,0xa8,0xaa,0x80,0x0a,0x00,0x29,0x29,0x4a,
 0x80,0x88,0xa4,0x42,0x01,0x41,0x40,0x22,0x00,0x08,0x6a,0x95,0xaa,0x4a,0x29,
 0x55,0xa5,0x4a,0xa5,0xaa,0xaa,0x52,0x29,0x55,0x55,0x55,0x55,0xa9,0xaa,0x4a,
 0x55,0x55,0x49,0xaa,0xa4,0x2a,0xa9,0xa4,0xaa,0xaa,0xaa,0xaa,0xaa,0x52,0x55,
 0x55,0x55,0xa9,0xaa,0xaa,0xaa,0xaa,0xaa,0x2a,0x15,0xaa,0x8a,0x24,0x11,0x20,
 0x2a,0x09,0x11,0x00,0x49,0xba,0x67,0x22,0x08,0x45,0x44,0x01,0x69,0x52,0x41,
 0x44,0x80,0x00,0x0c,0x09,0x22,0x52,0x4b,0xa4,0x08,0x12,0x42,0x92,0x24,0x54,
 0x29,0x49,0x92,0x52,0x29,0x29,0xa9,0x94,0x54,0x49,0x25,0x55,0x49,0xaa,0x92,
 0x24,0x55,0x55,0xaa,0xaa,0xaa,0xaa,0x52,0x55,0x55,0x95,0xaa,0x4a,0x55,0x55,
 0x55,0x55,0x55,0xa5,0xaa,0xaa,0xaa,0xaa,0x54,0x55,0x55,0x55,0xa5,0x2a,0x00,
 0x24,0x95,0x80,0x04,0x1a,0x40,0x84,0x54,0xa0,0xea,0x45,0x89,0x42,0x10,0x21,
 0x54,0x6a,0x80,0x0a,0x11,0x24,0x92,0x22,0xa0,0x88,0x88,0x44,0x80,0x82,0x00,
 0x14,0x00,0x00,0xa9,0x4a,0x55,0x55,0x95,0x4a,0x55,0x95,0xaa,0x4a,0xaa,0x54,
 0x95,0xaa,0x52,0xaa,0xaa,0x2a,0x49,0x55,0x25,0x55,0x55,0x95,0xaa,0xa4,0xaa,
 0xaa,0xaa,0x92,0xaa,0xaa,0xaa,0xaa,0x5a,0xaa,0x4a,0x55,0x55,0xab,0xaa,0xaa,
 0xaa,0xaa,0x12,0xaa,0x48,0x48,0x0a,0x50,0xaa,0x9a,0x28,0x41,0x45,0xba,0x30,
 0x11,0x55,0xa5,0x54,0xa5,0x2a,0x29,0x21,0x80,0x80,0x00,0x85,0x08,0x20,0x22,
 0x95,0x49,0x48,0x4a,0xa4,0xa4,0x4c,0xac,0x52,0x92,0x54,0x2a,0x55,0x4a,0x52,
 0x29,0x95,0x92,0xaa,0xa4,0xaa,0x4a,0x55,0x55,0x49,0x55,0x29,0xa9,0xa4,0xaa,
 0xaa,0x4a,0x55,0x55,0x55,0xaa,0xaa,0x94,0x52,0x92,0xaa,0x52,0x55,0x55,0x55,
 0x55,0x4a,0x55,0x55,0x55,0x55,0x15,0x00,0x24,0x25,0x81,0x04,0xaa,0x4a,0x55,
 0xad,0x34,0x6d,0xa9,0x54,0xa9,0xaa,0x4a,0x55,0x72,0x80,0x05,0x08,0x29,0x50,
 0x00,0x42,0x0a,0x48,0x14,0x21,0x10,0x80,0x04,0x00,0x00,0x68,0xa9,0x4a,0x25,
 0xa5,0xa4,0x52,0x55,0x4a,0xa9,0xaa,0x4a,0xaa,0x24,0x55,0xa5,0x24,0x55,0x55,
 0x55,0x55,0x55,0x52,0xaa,0xaa,0xaa,0xaa,0x4a,0x55,0x55,0x55,0x55,0xad,0xaa,
 0xaa,0xaa,0x54,0x55,0x55,0xb5,0xaa,0xaa,0x52,0x55,0x2a,0xaa,0x48,0x49,0x08,
 0x20,0x6a,0xbb,0x6b,0x5b,0xdb,0x0d,0xe2,0x77,0xd7,0x6e,0xbf,0xed,0x2d,0x52,
 0x91,0x22,0x80,0x02,0x25,0x08,0xa1,0x80,0x2a,0x0e,0x41,0x08,0x48,0x4a,0x92,
 0x56,0x25,0xa9,0x4a,0xa9,0x4a,0x95,0x4a,0x55,0xa5,0x54,0x52,0x95,0xaa,0x54,
 0x4a,0x55,0x55,0x95,0x4a,0x55,0x55,0x95,0xaa,0x54,0x55,0x52,0x55,0x95,0xaa,
 0xaa,0xaa,0x52,0x55,0x55,0x55,0x55,0x95,0xaa,0x4a,0x55,0x55,0xad,0xaa,0x12,
 0x00,0x25,0x92,0x42,0x89,0x15,0x14,0x08,0xa4,0x00,0x81,0x08,0x00,0x20,0x01,
 0x00,0x00,0x02,0x40,0x01,0x08,0x12,0x48,0x00,0x42,0x08,0x2a,0x20,0x41,0x44,
 0x22,0x29,0x00,0x08,0x54,0x95,0x2a,0xa9,0x2a,0xa9,0xa4,0xa4,0x52,0xaa,0x2a,
 0x55,0xa5,0xaa,0x4a,0x35,0x55,0x49,0x52,0x55,0x95,0x4a,0x55,0xa5,0xaa,0x4a,
 0x55,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
 0xaa,0x52,0x95,0x2a,0x4a,0xa8,0x24,0x11,0x20,0x40,0x44,0x20,0x40,0x12,0x04,
 0x40,0x44,0x04,0x92,0x90,0x24,0x90,0x94,0x24,0x20,0x40,0x80,0xa0,0x10,0x21,
 0x80,0x5a,0x10,0x10,0x00,0x90,0x24,0x21,0xb4,0x52,0x52,0x2a,0x49,0x95,0x2a,
 0x95,0x94,0x92,0x52,0x25,0x29,0x49,0x55,0x49,0x49,0x55,0x55,0xaa,0x54,0x55,
 0xaa,0xaa,0x4a,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,
 0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x15,0x10,0x44,0x92,0x00,0x92,0x24,0x01,
 0x04,0x09,0x80,0x42,0x12,0x10,0x41,0x0a,0x04,0x00,0x02,0x40,0x01,0x0a,0x15,
 0x2a,0x08,0xaa,0x08,0x25,0xc0,0x84,0x04,0x92,0x24,0xd9,0x84,0x54,0xa9,0x4a,
 0x95,0xaa,0x4a,0xa5,0x52,0x55,0x55,0xa9,0x54,0x55,0x55,0xa9,0xaa,0xaa,0x54,
 0x55,0x49,0x55,0xa9,0x52,0x55,0x55,0xa9,0xaa,0x2a,0xa9,0x4a,0x29,0x29,0x55,
 0xa9,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0x14,0x42,0x29,0x25,
 0x25,0x10,0x20,0x92,0x10,0x60,0x12,0x12,0x80,0x00,0x08,0x4a,0x20,0x49,0x20,
 0x69,0xa4,0xa0,0xa0,0x14,0x20,0x95,0xa2,0x90,0xaa,0x00,0xa0,0x00,0x20,0x01,
 0x10,0x54,0x25,0xa9,0xa4,0x94,0x54,0xaa,0x54,0xa5,0x54,0x4a,0x95,0xaa,0x2a,
 0x25,0x55,0x55,0xa5,0xaa,0xaa,0x92,0xaa,0x2a,0x95,0xaa,0xaa,0x54,0xa9,0x2a,
 0x55,0x55,0x55,0x95,0x4a,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,
 0x15,0x28,0x44,0x91,0x24,0xa9,0x4a,0x12,0x92,0x44,0x24,0x49,0x4a,0x94,0x22,
 0x45,0x92,0x12,0x09,0x50,0x49,0x42,0x94,0x0a,0x88,0x48,0x14,0x04,0xa0,0xd9,
 0x52,0xb2,0xa5,0x24,0x49,0x6a,0x95,0x54,0xaa,0x4a,0x25,0x49,0x4a,0x52,0x95,
 0x2a,0xa5,0x4a,0x52,0x55,0x49,0x92,0x2a,0x49,0x55,0x55,0x95,0xaa,0xaa,0x54,
 0x55,0x95,0xaa,0xaa,0xaa,0xaa,0xaa,0x52,0xb5,0xaa,0xaa,0xaa,0x54,0x55,0xb5,
 0xaa,0xaa,0xaa,0x4a,0x25,0x82,0x28,0x2a,0x81,0x24,0x10,0x42,0x00,0x11,0x01,
 0x02,0x00,0x01,0x08,0x14,0x08,0x85,0x40,0x22,0x00,0x88,0xaa,0x22,0x02,0x05,
 0x49,0x52,0x55,0x00,0x08,0x08,0x40,0x88,0x00,0x54,0xa9,0xa2,0x92,0x54,0xaa,
 0xfe,0x95,0x2a,0xa9,0xd2,0x2a,0x57,0x55,0x5d,0xbf,0x5f,0xbf,0xaa,0x5e,0x5f,
 0xdf,0x4f,0x5d,0xa5,0x4a,0xbf,0x4a,0x55,0x55,0xab,0xbf,0xaa,0x4a,0x55,0x49,
 0x57,0x55,0xd5,0x5d,0x55,0x5d,0x55,0x55,0x15,0x20,0x4a,0x89,0x20,0x40,0x08,
 0x02,0x49,0x40,0x40,0x82,0x52,0x90,0x20,0x09,0x42,0x75,0x00,0x54,0x12,0x02,
 0x80,0x08,0x50,0x55,0xa0,0x00,0x80,0x05,0x02,0x02,0x48,0x22,0x48,0x59,0xa5,
 0x2a,0x55,0xa5,0x92,0xd6,0x52,0x95,0x4a,0xd5,0xa9,0xae,0x9a,0xba,0x76,0x5b,
 0x5f,0x55,0x59,0xbb,0xdb,0xac,0x5e,0x55,0xa9,0xb5,0xaa,0xaa,0x52,0xab,0xb5,
 0xaa,0xaa,0x2a,0xb5,0xab,0xaa,0xaa,0xbb,0xaa,0xba,0xaa,0xaa,0x2a,0x8a,0x10,
 0x25,0x09,0xa1,0x23,0x12,0x00,0x45,0x12,0x09,0x00,0x01,0x02,0x28,0x10,0x0a,
 0x29,0x29,0x41,0x68,0x0a,0x85,0x02,0x0e,0x02,0x49,0x6a,0x91,0x50,0x20,0x21,
 0x00,0x09,0x54,0x95,0x54,0x4a,0x4a,0x55,0x4b,0x55,0xaa,0x2a,0x29,0xa5,0x26,
 0x2d,0x9d,0xbb,0x3d,0x95,0x4a,0xdd,0x9d,0xfd,0x5f,0x4d,0x95,0xaa,0xab,0x54,
 0xa9,0xaa,0xca,0xab,0xaa,0xab,0xd4,0xba,0xab,0xaa,0x54,0x5e,0x55,0x5d,0x55,
 0x55,0x0a,0x20,0xa4,0x50,0x41,0x08,0x08,0x89,0x24,0x48,0x00,0x84,0x48,0x48,
 0x48,0x92,0x84,0x50,0x00,0x10,0x08,0x01,0x40,0x20,0x48,0xb1,0x50,0x82,0x90,
 0x00,0x00,0x09,0x88,0x48,0x80,0xac,0x52,0x92,0x52,0x29,0xa9,0xa7,0x7c,0x77,
 0xdb,0xff,0x7e,0x7b,0x4f,0x5d,0xf7,0xdf,0xab,0x54,0xae,0xdb,0xdb,0xad,0x7e,
 0x77,0xd5,0xd7,0x5b,0x5f,0xaf,0x57,0xd7,0xdb,0xf7,0xbb,0x7d,0xbf,0xde,0xed,
 0xfa,0xba,0xad,0xaa,0x4a,0x29,0x8a,0x92,0x8a,0x04,0x02,0x20,0x21,0x80,0x40,
 0x92,0x24,0x02,0x02,0x01,0xa8,0x10,0x04,0x20,0x4a,0x00,0x88,0x08,0x09,0x01,
 0xba,0x2a,0x00,0x62,0x25,0x25,0xa0,0x80,0x02,0x25,0xb4,0xa4,0xaa,0x94,0xaa,
 0x92,0xa9,0x66,0x7f,0x9b,0x6d,0x77,0xbf,0xae,0xae,0x3b,0xa7,0xaf,0xaa,0xde,
 0xbd,0xcf,0x93,0x76,0xb7,0x2a,0xaf,0xbb,0xbb,0xdd,0xa9,0xaf,0xbd,0xdd,0xfa,
 0xdb,0x5d,0xbb,0xef,0xed,0xce,0x5e,0x55,0x55,0x15,0x40,0x48,0x52,0x90,0x20,
 0x09,0x11,0x24,0x44,0x00,0x05,0x40,0x40,0x20,0x11,0x86,0x40,0x88,0x14,0x49,
 0x42,0x22,0x10,0xa4,0x44,0x15,0x81,0x50,0x01,0x40,0x09,0x64,0x4c,0x08,0xd4,
 0x2a,0x95,0xaa,0x4a,0xca,0x2b,0xf7,0x66,0xd7,0x67,0xbb,0x77,0x57,0x2d,0xdb,
 0x5f,0x9e,0x52,0x9d,0x9d,0xd7,0x57,0xef,0x6e,0xa5,0xbe,0x5d,0xfb,0xbb,0x55,
 0xbd,0xdb,0xfb,0xba,0xbd,0xbb,0xdf,0xd9,0xde,0xfd,0xad,0xaa,0xaa,0x2a,0x0a,
 0x25,0x89,0x02,0x44,0x40,0x84,0x00,0x11,0x09,0x90,0x24,0x09,0x12,0x48,0x00,
 0x04,0x00,0x0a,0x20,0x10,0x80,0x44,0x10,0x52,0x21,0x10,0x4a,0x48,0x04,0x40,
 0x20,0x00,0xa0,0x54,0x55,0x52,0x49,0x52,0xd5,0x55,0x77,0x7b,0xdf,0x79,0xbb,
 0x9b,0xab,0xae,0xfe,0x4c,0xed,0xbf,0xa6,0xef,0x7e,0xae,0x76,0x56,0xaa,0xda,
 0x5d,0xdb,0xde,0x2b,0xdd,0xdd,0xec,0xdd,0xcd,0xcd,0xbd,0xe7,0xee,0xee,0xae,
 0xaa,0xaa,0x0a,0x50,0x90,0xa4,0x20,0x11,0x12,0x21,0x48,0x40,0x40,0x04,0x00,
 0x80,0x80,0x04,0x02,0x40,0x48,0x84,0x0a,0x02,0x11,0x10,0x84,0x24,0x8a,0x84,
 0x50,0x02,0x21,0x12,0x94,0x54,0x0a,0x54,0x49,0x49,0xaa,0x2a,0xa9,0x4b,0x77,
 0x77,0xcb,0xb2,0x5e,0x7b,0x97,0x96,0xce,0x2e,0x5d,0x95,0xae,0xd6,0xed,0x57,
 0xb7,0x5e,0x55,0xdd,0xae,0xfb,0xad,0xd5,0xda,0xdd,0x6f,0xdd,0xdd,0xbd,0xad,
 0xeb,0xe6,0xee,0x56,0x55,0x55,0x29,0x82,0x4a,0x12,0x09,0x20,0x80,0x10,0x01,
 0x46,0x12,0x25,0x49,0x12,0x24,0x04,0x88,0x04,0x02,0x23,0x81,0x48,0x44,0x40,
 0x21,0x90,0x20,0x10,0x55,0x11,0x48,0x40,0x11,0x10,0x88,0x54,0x95,0xaa,0x52,
 0x4a,0xa5,0xb3,0x9b,0x9b,0xee,0xba,0xcb,0x9d,0xab,0xae,0xee,0xdd,0xa6,0xaa,
 0x56,0xd7,0x6e,0x96,0xbb,0x5e,0xd5,0xfa,0xdd,0xdd,0xee,0x6a,0xdd,0xee,0xfe,
 0xee,0xfe,0xae,0xdf,0x75,0xbf,0x76,0xaf,0xaa,0x4a,0x15,0x28,0x20,0x49,0x01,
 0x09,0x92,0x44,0x48,0x40,0x00,0x08,0x00,0x00,0x01,0xa4,0x22,0x50,0x90,0x02,
 0x20,0x00,0x00,0x12,0x08,0x0a,0x88,0x44,0x28,0x44,0x02,0x09,0x50,0x12,0x21,
 0x68,0xa5,0x54,0x2a,0xa9,0x94,0xae,0x5e,0xaf,0xd6,0x75,0xbf,0x79,0xab,0xaf,
 0xab,0xe7,0x9b,0xa4,0xdf,0xd5,0xef,0x57,0x4f,0x4d,0xd5,0xcf,0xbe,0xcf,0xd7,
 0xd5,0xef,0xdd,0xed,0xda,0xcd,0xdd,0xbd,0xea,0x5e,0xef,0xae,0xaa,0xaa,0x2a,
 0x82,0x4a,0x92,0x24,0xa0,0x80,0x00,0x01,0x49,0x92,0x48,0x52,0x12,0xa4,0x04,
 0x00,0x01,0x41,0x89,0x08,0x49,0x92,0x40,0xa0,0xa0,0x02,0x22,0x15,0x00,0x10,
 0x20,0x12,0x90,0x80,0x56,0x29,0x49,0xa5,0x52,0x55,0x55,0xa1,0x55,0x2b,0x92,
 0xbd,0x82,0x4a,0x52,0xa4,0xaa,0xaa,0xaa,0x22,0x29,0x91,0xaa,0xaa,0x56,0x55,
 0x55,0xc9,0x55,0xd4,0x52,0xa9,0x2a,0x55,0xa5,0x1a,0x55,0xa5,0xaa,0x52,0x55,
 0x55,0x55,0x55,0x12,0x48,0x28,0x29,0x81,0x24,0x90,0x30,0x24,0x44,0x00,0x09,
 0x40,0x80,0x20,0x08,0x4a,0x10,0xa4,0x20,0x42,0x40,0x00,0x24,0x0a,0x08,0xa0,
 0x08,0x14,0x93,0x44,0x89,0x20,0x0a,0x18,0x58,0x55,0xa5,0x92,0x4a,0x92,0x94,
 0xac,0xd5,0x4a,0xa9,0x73,0x5a,0xa9,0x4a,0x55,0x2a,0xa5,0xaa,0xac,0xaa,0xaa,
 0x52,0xa9,0x55,0xa9,0x54,0xd5,0x52,0x7b,0x55,0x55,0x55,0x55,0x55,0x65,0x55,
 0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x15,0x22,0x91,0xa2,0x08,0x00,0x85,0x04,
 0x80,0x40,0x12,0x88,0x04,0x09,0x02,0x52,0x00,0x41,0x50,0x02,0x00,0x09,0x49,
 0x40,0x20,0xa1,0x04,0xa0,0x12,0x00,0x00,0x00,0x44,0x24,0x41,0x54,0x49,0x95,
 0x54,0x55,0xa5,0x52,0xd5,0xeb,0x52,0x55,0x9f,0xaa,0xaa,0xaa,0xaa,0x52,0x2a,
 0x95,0x52,0x55,0x55,0x95,0xaa,0xab,0xaa,0xaa,0xea,0xad,0x7c,0x95,0xaa,0xaa,
 0xaa,0xaa,0x5a,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x95,0x2a,0x08,0x4a,0x14,
 0x21,0x49,0x40,0x40,0x12,0x48,0x40,0x22,0x20,0x80,0x90,0xa0,0x2a,0x14,0xa9,
 0x20,0x29,0x40,0x00,0x92,0x4a,0x08,0x51,0x4a,0x95,0x48,0x92,0x24,0x81,0x03,
 0x08,0x54,0x55,0x52,0x2a,0xa9,0x54,0x2a,0x49,0x95,0xaa,0x4a,0x55,0x25,0x95,
 0x54,0x95,0xaa,0xa9,0xaa,0xaa,0x92,0xaa,0xaa,0xaa,0x54,0x95,0xaa,0xaa,0x52,
 0x05,0x55,0x55,0xaa,0xaa,0xaa,0x4a,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,
 0x15,0x22,0xa8,0xa2,0x24,0x29,0x49,0x12,0x92,0x54,0x25,0x49,0x4a,0x9a,0x28,
 0x49,0x82,0x00,0xaa,0x25,0x49,0x12,0x93,0x64,0x00,0x21,0x04,0x91,0x52,0x49,
 0x52,0x92,0x94,0xa4,0x49,0xb5,0x92,0x54,0xa5,0x92,0xaa,0x52,0x95,0x52,0x4a,
 0x52,0x92,0x54,0xaa,0x4a,0x52,0x95,0x4a,0xa9,0x2a,0x55,0x92,0x54,0x55,0xa5,
 0xaa,0x52,0x55,0x55,0x75,0x55,0xa5,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
 0xaa,0xaa,0xaa,0xaa,0x2a,0x88,0x12,0x14,0x01,0x00,0x42,0x84,0x00,0xa1,0x00,
 0x90,0x00,0x00,0x02,0x00,0x28,0x52,0x45,0x08,0x00,0x41,0x20,0x00,0xaa,0x14,
 0xa1,0x54,0x20,0x00,0x00,0x00,0x20,0x08,0x00,0x54,0x49,0x25,0x55,0x4a,0x25,
 0x95,0x52,0x4a,0xa9,0xaa,0xaa,0x52,0xa5,0xaa,0xaa,0xa4,0x54,0x55,0xa9,0xaa,
 0xaa,0x4a,0xaa,0xaa,0x54,0x55,0xaa,0xaa,0x4a,0x55,0x55,0x55,0x55,0x55,0x55,
 0x95,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0x14,0x22,0xa4,0x52,0x24,0x29,0x48,
 0x10,0x12,0xa4,0x14,0x11,0x52,0x21,0x20,0x82,0x50,0xa4,0xc2,0x40,0x21,0x44,
 0x84,0x24,0x91,0xa2,0x94,0x0a,0x21,0x25,0x49,0x49,0x22,0x20,0x2a,0xd4,0xaa,
 0x4a,0xa9,0x2a,0xa9,0x54,0xaa,0xaa,0x2a,0x95,0x54,0x95,0x2a,0xa9,0x54,0x55,
 0x95,0x4a,0x55,0x55,0x55,0x55,0xa5,0xaa,0xaa,0xaa,0x52,0x55,0x55,0xa9,0xaa,
 0x4a,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0x4a,0x25,0x08,0x91,
 0x24,0x09,0x00,0xa1,0x44,0x80,0xa0,0x80,0x10,0x00,0x88,0x88,0x20,0x82,0xaa,
 0x90,0x10,0x08,0x00,0x10,0x00,0x20,0x55,0xaa,0x22,0x24,0x00,0x00,0x00,0x80,
 0x84,0x00,0x59,0x25,0xa9,0x94,0xa4,0x94,0x4a,0x95,0x52,0x4a,0xa5,0x4a,0xaa,
 0x52,0x95,0x4a,0xaa,0x52,0xa9,0xaa,0xa4,0xaa,0x54,0x55,0x55,0x55,0xaa,0xaa,
 0x2a,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,
 0x55,0x15,0xa2,0x24,0x49,0xa0,0x44,0x24,0x10,0x09,0x62,0x22,0x92,0x24,0x01,
 0x02,0x0a,0x88,0x04,0x42,0x82,0x44,0x49,0x42,0x52,0x02,0xa4,0xa5,0x00,0x20,
 0x49,0x25,0x49,0x0a,0x10,0x24,0x54,0xa9,0x52,0xa5,0xaa,0x2a,0x29,0xa9,0x94,
 0x52,0xaa,0x52,0x49,0x55,0xa5,0xaa,0x92,0xaa,0x2a,0xa5,0x2a,0xa5,0xaa,0x2a,
 0x49,0xa9,0x52,0x55,0xaa,0xaa,0x2a,0x55,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
 0xaa,0xaa,0xaa,0xaa,0xaa,0x2a,0x08,0x90,0x24,0x05,0x20,0x20,0x12,0xa0,0xe4,
 0x08,0x11,0x41,0x48,0xa8,0x20,0x31,0x50,0xcc,0x24,0x11,0x90,0x80,0x20,0x90,
 0x0a,0x80,0x4c,0x29,0x01,0x40,0x10,0xa0,0x04,0x89,0xac,0x54,0x4a,0x52,0x52,
 0x4a,0xa5,0x94,0xaa,0xaa,0x52,0x2a,0x55,0x4a,0xaa,0x52,0x55,0x29,0x55,0x95,
 0xaa,0x54,0x25,0xa9,0xaa,0x4a,0x95,0xaa,0x55,0xa9,0xaa,0x52,0x55,0x25,0x55,
 0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x15,0xa2,0x4a,0x92,0x90,0x8a,
 0x22,0x48,0x02,0x48,0x22,0x24,0x24,0x02,0x01,0x04,0x84,0x04,0xe1,0x00,0x40,
 0x42,0x0a,0x8a,0x04,0x10,0x92,0x00,0x44,0x2a,0x89,0x44,0x11,0x10,0x10,0xd4,
 0x92,0x54,0x95,0x4a,0xa9,0xfe,0x52,0xa5,0x54,0x95,0x5f,0x55,0x55,0x55,0x5a,
 0xea,0x55,0xa9,0xd7,0xd7,0xd7,0xab,0xea,0xd7,0xeb,0xfb,0xd2,0x55,0x55,0x7d,
 0x55,0x57,0x55,0xa9,0xae,0xab,0xfa,0xaa,0xea,0xaa,0xab,0xaa,0x4a,0x2a,0x08,
 0x24,0x49,0x05,0x20,0xa8,0x82,0x48,0x42,0x00,0xa1,0x80,0x50,0x50,0x21,0x01,
 0x20,0xc0,0x92,0x0a,0x10,0x90,0x20,0x21,0x85,0x80,0x24,0xc1,0x00,0x20,0x00,
 0x84,0x84,0x04,0xa9,0xaa,0x92,0x54,0x29,0x55,0xde,0xaa,0x54,0x25,0xe9,0xba,
 0x92,0x52,0x49,0x5d,0xd5,0x4a,0x4b,0xee,0x6e,0x77,0x57,0x55,0x77,0xeb,0xd6,
 0xab,0xab,0xaa,0xce,0xaa,0xae,0xaa,0x56,0xaf,0xa9,0xae,0x55,0xd5,0xda,0xab,
 0xaa,0xaa,0x12,0xa2,0x48,0x12,0x90,0x20,0x11,0x10,0x00,0x25,0x49,0x29,0x4a,
 0x04,0x21,0x08,0x54,0x81,0xc4,0x40,0xa1,0x44,0x01,0x22,0x04,0x28,0xca,0x04,
 0x48,0x49,0x42,0x49,0x30,0x10,0x2a,0xac,0x24,0x55,0xa5,0xaa,0x92,0xee,0x92,
 0xaa,0x55,0x75,0x49,0x2a,0x95,0xaa,0x52,0xe9,0xaa,0x55,0x77,0xe7,0xbe,0x53,
 0x55,0x77,0x37,0xab,0xd5,0x52,0x95,0xfe,0x55,0x52,0x55,0xa9,0xae,0x56,0xaf,
 0xaa,0xaa,0xda,0x55,0x55,0x55,0x15,0x08,0x24,0x49,0x01,0x08,0x1c,0x04,0x12,
 0xf0,0x00,0xe0,0x00,0x00,0x04,0x00,0x00,0x08,0xc0,0x00,0x00,0x00,0x20,0x20,
 0x80,0x00,0xc0,0x83,0x40,0x00,0x08,0x00,0x00,0x01,0x00,0xd4,0xaa,0x94,0x52,
 0x4a,0xa9,0xd6,0xfd,0xf6,0xfb,0x6a,0xb5,0xef,0x77,0xb7,0xaf,0x6f,0xef,0x53,
 0xe7,0xf6,0x77,0x57,0xaa,0x7e,0xbb,0xd7,0xd5,0xef,0xae,0xce,0xed,0x6b,0xf7,
 0xab,0xde,0xa9,0x5e,0xfd,0x7e,0xdf,0xae,0xaa,0xaa,0x2a,0xa2,0x48,0x55,0x00,
 0x00,0x7c,0x00,0x00,0x08,0x01,0xf0,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0x00,
 0x00,0x00,0x00,0x20,0x00,0x00,0x20,0x04,0x40,0x00,0x00,0x00,0x00,0x00,0x00,
 0x54,0x49,0x29,0x95,0x94,0x4a,0x7f,0x36,0xff,0x2c,0x79,0xc9,0xce,0x6e,0xfb,
 0xdc,0xee,0xd6,0xac,0x6b,0xd7,0xb9,0xab,0x52,0xbb,0x7f,0xab,0xe5,0xee,0x56,
 0x7f,0x7e,0xb7,0xb5,0x57,0x6d,0x4a,0xbd,0xee,0xed,0xdc,0x5d,0x55,0x95,0x0a,
 0x08,0x55,0x22,0x01,0x20,0x7c,0x10,0x00,0x04,0x00,0xf1,0x40,0x00,0x20,0x00,
 0x10,0x00,0xc4,0x00,0x01,0xc0,0xff,0x20,0x00,0x08,0x10,0x0c,0x40,0xf9,0x41,
 0x00,0x20,0x00,0x08,0x58,0xa5,0x4a,0xa9,0x52,0xa9,0x2e,0xf7,0xd6,0x5e,0xb5,
 0xea,0xed,0xee,0x76,0x6f,0xef,0xee,0x4a,0x77,0xef,0xb7,0x4b,0x55,0x5b,0xbb,
 0x6b,0xd5,0xdd,0x55,0x77,0x5d,0xfb,0x75,0xab,0xae,0xaa,0x7a,0xdd,0x6f,0xef,
 0x5f,0x55,0x55,0x29,0x22,0x20,0x49,0x00,0x00,0x3c,0x00,0x00,0x02,0x02,0xe0,
 0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0x00,0x00,0x00,0x47,0x10,0x00,0x00,0x08,
 0x10,0x80,0x68,0x01,0x00,0x00,0x00,0x00,0x54,0x95,0x54,0x4a,0x95,0x4a,0xa7,
 0x3b,0xf7,0xba,0xb2,0x74,0xde,0x6e,0x39,0xed,0x76,0xe7,0xd2,0xc9,0xb3,0xf3,
 0xf5,0xaf,0xbc,0xdb,0xab,0x6a,0xad,0xab,0xe7,0xce,0xdb,0xbb,0xab,0xbe,0xaa,
 0x74,0x6d,0x76,0xed,0xa6,0xaa,0xaa,0x2a,0x08,0x95,0x24,0x01,0x00,0x3c,0x00,
 0x00,0x02,0x02,0xe0,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0x00,0x00,0x00,0xfd,
 0x10,0x00,0x00,0x08,0x10,0x80,0xb8,0x01,0x00,0x00,0x00,0x00,0xa8,0x52,0x4a,
 0x55,0xaa,0x54,0x57,0x5b,0xe7,0x7a,0xba,0xea,0xee,0xee,0xbb,0xd6,0x77,0xeb,
 0xaa,0xd7,0x7b,0xd7,0xaa,0x52,0xdb,0xbd,0xb5,0xea,0xd6,0x2a,0xf7,0xae,0xdd,
 0xba,0x55,0x5d,0x55,0xeb,0xee,0xbf,0xee,0x5e,0x55,0x55,0x15,0x22,0x48,0x4a,
 0x25,0x29,0x59,0x12,0x92,0x26,0x27,0xe9,0x4a,0x92,0x28,0x49,0x12,0x92,0xe4,
 0x25,0x49,0x42,0x93,0xb4,0x24,0x49,0x9a,0x34,0xa1,0x49,0x52,0x92,0xa4,0x24,
 0x49,0x6c,0x55,0xa9,0xa4,0x24,0xa9,0x93,0xbf,0x6b,0xb5,0x7a,0x75,0x67,0xd3,
 0x5a,0xef,0xb8,0x77,0xd5,0xe9,0xb4,0xeb,0xaa,0xfa,0xbf,0xdd,0xfd,0x6a,0xaf,
 0xab,0x7b,0xd7,0xfd,0xdb,0xab,0xae,0x56,0x6b,0x77,0x7b,0x6f,0x57,0x55,0x25,
 0x15,0x48,0x25,0x51,0x00,0x00,0x18,0x00,0x00,0x02,0x02,0xc0,0x00,0x00,0x00,
 0x00,0x00,0x00,0xc0,0x00,0x00,0x80,0x00,0x10,0x00,0x00,0x08,0x10,0x80,0x00,
 0x00,0x00,0x00,0x00,0x00,0xa8,0x24,0x25,0x95,0x52,0x95,0x4f,0x7b,0xeb,0x7e,
 0xe5,0xcb,0xf3,0xd7,0x5d,0xee,0x6b,0x6b,0xd5,0x77,0xf5,0x39,0x29,0xf5,0xf3,
 0xf2,0xfe,0xf5,0xd3,0xab,0xbf,0xaa,0xfb,0xba,0x57,0x55,0x57,0xbf,0x6e,0xf7,
 0xee,0x5e,0x55,0x55,0x25,0x02,0x48,0x8a,0x00,0x00,0x18,0x00,0x00,0x04,0x00,
 0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0x00,0x00,0x00,0x00,0x10,0x00,0x00,
 0x10,0x08,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x54,0x55,0xaa,0xaa,0xaa,0x52,
 0x28,0x85,0x94,0x84,0x94,0x54,0x6c,0x54,0x52,0xb9,0x97,0xaa,0x2a,0x88,0x4a,
 0xa6,0xaa,0xaa,0x54,0x95,0x4a,0x4a,0xaa,0x54,0x42,0x95,0x92,0x4a,0xa9,0xaa,
 0xaa,0xaa,0x52,0x95,0x12,0x51,0x55,0x55,0x15,0x50,0xa5,0x24,0x01,0x20,0x08,
 0x10,0x00,0x0c,0x01,0x81,0x40,0x00,0x20,0x00,0x10,0x00,0xc4,0x00,0x01,0x40,
 0x00,0x30,0x00,0x08,0x20,0x04,0x80,0x01,0x40,0x00,0x20,0x00,0x08,0xb4,0x4a,
 0x49,0x49,0x29,0xa9,0xa6,0xaa,0x52,0xb5,0x52,0x55,0x73,0xeb,0x2a,0xb5,0x56,
 0x55,0xa5,0x6b,0x55,0x55,0x55,0x95,0x2a,0x55,0x55,0x55,0x75,0xab,0x5a,0x55,
 0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0xed,0x56,0x55,0x55,0x29,0x02,0x88,
 0x52,0x00,0x00,0x08,0x00,0x00,0xf0,0x00,0x80,0x00,0x00,0x00,0x00,0x00,0x00,
 0xc0,0x00,0x00,0x00,0x00,0x08,0x00,0x00,0xc0,0x03,0x00,0x01,0x00,0x00,0x00,
 0x00,0x00,0x54,0xa9,0x2a,0x95,0x52,0xa5,0x54,0x54,0x55,0x4a,0xa5,0x4a,0x7c,
 0x1d,0x55,0xf5,0x57,0x92,0x2a,0x4a,0xa9,0xaa,0x4a,0xaa,0xaa,0xaa,0xaa,0xaa,
 0xba,0x54,0x55,0x55,0x55,0x55,0x95,0xaa,0xaa,0xaa,0xaa,0xaa,0x92,0xaa,0xaa,
 0xaa,0x0a,0xa8,0x52,0x08,0x01,0x80,0x07,0x00,0x00,0x00,0x00,0x00,0x07,0x00,
 0x00,0x00,0x00,0x00,0xc0,0x00,0x00,0x00,0x00,0x0f,0x00,0x00,0x00,0x00,0x00,
 0x1f,0x00,0x00,0x00,0x00,0x00,0xa8,0x4a,0x92,0x52,0x95,0x94,0x92,0x4a,0x2a,
 0xa5,0x54,0x52,0x4b,0x69,0xa5,0x4a,0x49,0x55,0xa9,0x35,0x55,0x52,0xa9,0xaa,
 0xaa,0xaa,0xa4,0xa4,0x4a,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,
 0x55,0xad,0xaa,0xaa,0x4a,0x2a,0x02,0xa4,0x52,0x00,0x20,0x10,0x00,0x00,0x00,
 0x00,0x40,0x10,0x00,0x00,0x00,0x00,0x00,0xc0,0x00,0x00,0x00,0x40,0x20,0x00,
 0x00,0x00,0x00,0x80,0x40,0x00,0x00,0x00,0x00,0x00,0x6c,0xa9,0x54,0x2a,0xa9,
 0xaa,0xaa,0x52,0xc9,0x54,0x95,0xaa,0x94,0x4a,0x4a,0x52,0xaa,0xaa,0x2a,0x4a,
 0xa5,0x4a,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0xaa,0xaa,0xaa,
 0xaa,0xaa,0xaa,0xaa,0xaa,0x52,0x55,0x55,0x55,0x15,0x48,0x11,0x49,0x01,0x10,
 0x20,0x00,0x00,0x00,0x00,0x20,0x20,0x00,0x00,0x40,0x00,0x00,0xc0,0x00,0x00,
 0x00,0x20,0x00,0x00,0x00,0x00,0x00,0x40,0x80,0x00,0x00,0x00,0x00,0x00,0x54,
 0x95,0x4a,0x95,0x4a,0x92,0x54,0xaa,0x2a,0x55,0x52,0x25,0x65,0xaa,0xaa,0xaa,
 0x2a,0x25,0xa5,0x55,0x55,0x35,0x55,0xa5,0x92,0x92,0xaa,0xaa,0xaa,0xaa,0xaa,
 0x4a,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0xad,0xaa,0xaa,0xaa,0x2a,0x22,
 0xa4,0x94,0x00,0x30,0x20,0x10,0x00,0x04,0x00,0x21,0x60,0x00,0x20,0x00,0x10,
 0x00,0xc4,0x00,0x01,0x40,0x20,0x20,0x00,0x08,0x00,0x04,0x40,0x81,0x40,0x00,
 0x20,0x00,0x08,0xa8,0x52,0x52,0x52,0xaa,0xaa,0x92,0x92,0x54,0x49,0x55,0xaa,
 0x94,0x52,0xa9,0xaa,0x52,0xa9,0xaa,0x54,0x55,0x49,0x49,0x2a,0x55,0x55,0x55,
 0x55,0xaa,0x52,0x49,0x55,0xa5,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0x52,0x55,
 0x55,0x55,0x09,0x08,0x55,0x22,0x01,0x10,0x20,0x00,0x00,0x00,0x00,0x20,0x20,
 0x00,0x00,0x00,0x00,0x00,0xc0,0x00,0x00,0x00,0x20,0x00,0x00,0x00,0x00,0x00,
 0x40,0x80,0x00,0x20,0x00,0x00,0x00,0xd8,0x94,0xaa,0x4a,0x25,0x55,0x4a,0x55,
 0xa5,0xaa,0x4a,0x95,0xaa,0xaa,0x2a,0x25,0x55,0x55,0x55,0xa5,0x92,0xaa,0xaa,
 0xaa,0xaa,0xaa,0x4a,0x4a,0xa5,0x2a,0x55,0xa9,0xaa,0x54,0x55,0x25,0x55,0x55,
 0x55,0x55,0xad,0xaa,0xaa,0xaa,0x2a,0x22,0x80,0x94,0x00,0x10,0x20,0x00,0x00,
 0x00,0x00,0x20,0x20,0x10,0x00,0x02,0x00,0x00,0xc0,0x00,0x00,0x00,0x20,0x00,
 0x00,0x00,0x00,0x00,0x40,0x80,0x00,0x00,0x00,0x20,0x00,0x54,0xa5,0x24,0x55,
 0xaa,0xa4,0xaa,0xa4,0x4a,0x92,0x54,0x52,0x49,0x95,0xaa,0x54,0x95,0x2a,0x29,
 0x95,0xaa,0xaa,0xaa,0xaa,0x2a,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,
 0x55,0x55,0x55,0xaa,0xaa,0xaa,0x52,0x55,0x55,0x95,0x2a,0x88,0x5a,0x4a,0x00,
 0x20,0x10,0x10,0x00,0x04,0x00,0x41,0x50,0x00,0x20,0x00,0x10,0x00,0xc4,0x00,
 0x01,0x40,0x40,0x20,0x40,0x08,0x00,0x04,0x80,0x41,0x40,0x00,0x20,0x00,0x08,
 0xac,0x52,0x95,0xa4,0x92,0x92,0x24,0x95,0x54,0x55,0xa5,0xaa,0x2a,0x49,0x49,
 0x55,0xa9,0xa4,0xaa,0xaa,0x54,0x55,0x55,0x55,0x55,0x55,0xa9,0xaa,0xaa,0xaa,
 0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0x95,0xaa,0xaa,0xaa,0xaa,0x4a,0x55,0x15,
 0x22,0x20,0x91,0x00,0x40,0x08,0x00,0x00,0x00,0x00,0x80,0x08,0x00,0x00,0x00,
 0x00,0x01,0xc0,0x00,0x20,0x00,0x80,0x10,0x00,0x00,0x00,0x00,0x00,0x21,0x00,
 0x00,0x00,0x00,0x00,0xa8,0x4a,0xaa,0x4a,0x55,0x55,0x55,0xa9,0xaa,0xaa,0x2a,
 0x25,0x55,0x55,0xaa,0x5f,0xaa,0xaa,0x4a,0xf5,0x57,0x92,0x24,0xa9,0x56,0x79,
 0x55,0xd5,0xf5,0xf5,0x75,0xd5,0x55,0x55,0xbf,0xaa,0x52,0xaf,0xde,0x5d,0x55,
 0x55,0xb5,0xaa,0x14,0x08,0x95,0x4a,0x01,0x80,0x07,0x00,0x00,0x00,0x00,0x00,
 0x07,0x00,0x04,0x00,0x00,0x00,0xc0,0x00,0x00,0x00,0x00,0x0f,0x00,0x00,0x00,
 0x00,0x00,0x1e,0x00,0x00,0x00,0x00,0x00,0x68,0x29,0x49,0x29,0x29,0x29,0xa9,
 0x2a,0x25,0x49,0x52,0xa9,0xa4,0xaa,0xaa,0xbb,0x4a,0x55,0xa9,0xb4,0x56,0x55,
 0x55,0x95,0x56,0xb5,0xaa,0xaa,0xbb,0xbb,0xf5,0xea,0x92,0xaa,0xee,0xaa,0xaa,
 0xae,0xde,0x5a,0x55,0x55,0x95,0x4a,0x25,0x22,0x48,0x24,0x24,0x29,0x49,0x12,
 0x92,0x24,0x25,0x49,0x4a,0x92,0x28,0x49,0x12,0x92,0xe4,0x25,0x49,0x42,0x92,
 0xa4,0x24,0x49,0x92,0x24,0x21,0x49,0x52,0x92,0xa4,0x24,0x49,0xac,0xaa,0x52,
 0xaa,0x52,0xa5,0x12,0xa5,0x54,0x55,0x95,0xaa,0x4a,0x52,0xa5,0xbb,0x52,0x6a,
 0x55,0x5d,0x95,0xaa,0xaa,0xaa,0xaa,0xba,0x6a,0xe9,0xdd,0xd9,0x75,0xd5,0xaa,
 0x54,0x77,0x55,0x55,0xab,0x6e,0x55,0x55,0x55,0x55,0x55,0x15,0x40,0x25,0x49,
 0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x54,0x25,0x55,0x95,0x94,0x54,0xaa,0x92,0xaa,0xa4,0x52,0x25,0x55,0x95,
 0xaa,0x75,0xdf,0x7f,0xaf,0xba,0xea,0xf5,0xdd,0xfd,0xeb,0xdf,0x7b,0xd5,0xb9,
 0xbd,0x75,0xea,0x77,0xab,0xeb,0xbe,0x77,0xab,0xb6,0xde,0xaf,0xbf,0xaa,0xaa,
 0x2a,0x0a,0x48,0x92,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x54,0x49,0x4a,0x52,0x55,0xa5,0x4a,0xaa,0x24,0x95,
 0x54,0xaa,0x54,0x55,0xaa,0x9f,0xdd,0xf5,0x2d,0x4d,0xb5,0xbb,0xdb,0x6e,0xb7,
 0xb9,0x75,0xe5,0xda,0xdd,0xbb,0xea,0xee,0x57,0x3f,0xbb,0xbb,0x57,0x5f,0xed,
 0xde,0xad,0xaa,0x2a,0x15,0x40,0x25,0x25,0xd5,0x6f,0x55,0xfb,0xff,0xb7,0xed,
 0xad,0x6a,0xef,0xed,0xfe,0xff,0xfe,0x57,0xda,0x7f,0xff,0xad,0xaa,0x7d,0xff,
 0x6f,0xdb,0xb7,0xaa,0xfd,0xff,0xff,0xff,0xff,0x6b,0x55,0xa5,0x2a,0xa5,0x94,
 0x52,0xa9,0xaa,0xaa,0x4a,0x55,0x25,0xa9,0xd2,0xd5,0xef,0xba,0xab,0x5e,0x7a,
 0xb7,0xbb,0x5c,0xdb,0xdd,0x5b,0xd5,0xdd,0xdb,0x75,0x75,0x6f,0xaa,0xab,0x5f,
 0x77,0xab,0x7e,0xdd,0xdd,0xae,0xaa,0xaa,0x12,0x2a,0x48,0x94,0x48,0xaa,0x6a,
 0x25,0x11,0xaa,0x9a,0x6a,0x55,0x99,0xaa,0x22,0x49,0x89,0x54,0x35,0xc4,0x88,
 0xaa,0xb6,0xa2,0x24,0xaa,0x2a,0xaa,0xaa,0x22,0x22,0x49,0x22,0x12,0x55,0xa9,
 0x94,0xa4,0x94,0x2a,0x55,0x25,0x55,0x29,0x55,0x92,0xaa,0x4a,0xd5,0xe5,0xdc,
 0xba,0x57,0xad,0xda,0xbb,0xfb,0xae,0xbb,0xbb,0xbd,0x6a,0xfa,0xf4,0x9a,0x6a,
 0xf7,0xd5,0xd7,0x5d,0x9b,0xab,0xb7,0xd6,0xee,0x5d,0x55,0x55,0x15,0x00,0xa5,
 0x22,0xa5,0xaa,0xb6,0xda,0xd6,0xd5,0xaa,0xaa,0xaa,0xaa,0xaa,0xda,0x56,0x6b,
 0xab,0xcd,0x35,0xb7,0x6a,0x55,0x5d,0xab,0x55,0xd5,0x55,0x6b,0xdd,0xda,0x56,
 0xad,0xd5,0x5a,0x25,0xa5,0xaa,0x52,0xa5,0x92,0x54,0x49,0x4a,0xa9,0xaa,0x94,
 0xaa,0xd4,0xd5,0xef,0xba,0xae,0xae,0xba,0xbb,0xb5,0xae,0xf5,0xdd,0xb9,0xea,
 0x65,0xf5,0x7a,0x75,0x67,0xab,0xab,0xbb,0xfb,0x55,0xf7,0xee,0x96,0x57,0x55,
 0x95,0x2a,0x4a,0x88,0x94,0x54,0xd5,0xaa,0x55,0xad,0xaa,0x56,0x5b,0x5b,0x6b,
 0x5b,0xab,0x6a,0x55,0x6d,0xb5,0x6a,0x55,0x55,0xd5,0xaa,0x5a,0xb5,0xad,0x5a,
 0x55,0x55,0x55,0xb5,0x5a,0xad,0xaa,0x4a,0x2a,0x95,0x2a,0xa9,0x54,0xa5,0xaa,
 0xaa,0x92,0x54,0xa9,0x54,0xe5,0xca,0x76,0xdd,0x26,0x5d,0xdb,0xda,0x75,0xd7,
 0x3b,0xee,0x5a,0x75,0x7a,0xb5,0x9a,0xba,0xe9,0xd5,0xd5,0xad,0x9d,0xab,0x7b,
 0x77,0xef,0xaa,0xaa,0xaa,0x14,0x20,0x24,0x49,0xa2,0xb6,0xaa,0xaa,0xaa,0x5a,
 0xd5,0xaa,0xaa,0x55,0xd5,0xaa,0xaa,0xb6,0xaa,0xaa,0x56,0x55,0x5b,0x5b,0xd5,
 0xaa,0x56,0xb5,0xaa,0x5a,0xab,0x56,0x55,0xab,0xaa,0xaa,0x52,0xa5,0xa4,0x94,
 0x54,0x2a,0x95,0x94,0x52,0x55,0x25,0x55,0x25,0xf5,0xe9,0xef,0xba,0xaf,0xfa,
 0x7a,0xfd,0xba,0x96,0xfd,0xdd,0x5d,0xf9,0x5d,0xbd,0x7e,0xf5,0xd6,0xd2,0xab,
 0xdf,0xfb,0xab,0xef,0xee,0xde,0x57,0x55,0x55,0x15,0x8a,0x52,0x92,0x94,0x88,
 0x24,0x25,0x51,0xa2,0x24,0x49,0x52,0x4a,0x12,0x95,0x94,0x48,0x49,0x25,0x49,
 0xaa,0xa4,0xa4,0x2a,0xa5,0x28,0x49,0x55,0xa5,0x54,0xa9,0x4a,0x54,0x55,0x55,
 0x95,0x54,0x29,0xa9,0x4a,0xa5,0x54,0xa9,0x94,0xaa,0xaa,0x92,0xaa,0x4a,0x95,
 0x14,0x49,0x51,0xa5,0xaa,0x1a,0x55,0xa9,0xda,0xa5,0xaa,0x4a,0x52,0x45,0x95,
 0xaa,0x6a,0x2d,0x95,0x54,0x95,0xaa,0x54,0x95,0x62,0x5f,0x55,0x55,0x15,0x20,
 0x94,0x24,0x45,0x52,0x92,0x90,0x14,0x29,0x92,0x24,0x89,0x24,0x49,0x42,0x4a,
 0x92,0x24,0x92,0x2a,0x11,0x29,0x49,0x44,0x29,0x95,0x24,0x49,0x52,0x92,0x14,
 0x51,0x25,0x49,0x92,0xa8,0x92,0xaa,0x4a,0xa5,0x52,0x25,0x95,0x4a,0x49,0x52,
 0xaa,0x54,0x29,0x55,0xaa,0xaa,0xac,0x54,0x4a,0xdd,0x5a,0xaa,0xde,0x55,0x55,
 0x55,0x55,0xb5,0xaa,0xaa,0x5a,0xa5,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xfa,0xad,
 0xaa,0x2a,0x25,0x82,0x20,0x49,0x28,0x45,0x49,0x55,0x49,0x45,0x25,0x49,0x2a,
 0x49,0x55,0x99,0x50,0x25,0x55,0x29,0xa4,0xaa,0x92,0x92,0x2a,0x52,0xa2,0x4a,
 0x92,0xa4,0x2a,0xa9,0x4a,0x49,0x95,0xaa,0x52,0x2a,0xa5,0x52,0x2a,0x95,0xaa,
 0xaa,0x2a,0x55,0x95,0x4a,0xa5,0xaa,0x52,0x55,0x55,0xa5,0xaa,0xaa,0x5e,0x57,
 0x55,0xfd,0xaa,0xaa,0xaa,0xaa,0x4a,0x55,0x55,0xbd,0x5a,0x55,0x55,0x55,0x55,
 0x55,0x55,0xe5,0x57,0x55,0x55,0x15,0x54,0x94,0x24,0x95,0x28,0x52,0x24,0xa4,
 0x28,0x91,0xa4,0x92,0xa4,0x88,0xa4,0x2a,0x52,0x49,0x4a,0x93,0x24,0x49,0xa9,
 0x92,0x2a,0x55,0x52,0x55,0x95,0x44,0x95,0x54,0xaa,0x52,0x49,0x2a,0xa5,0x52,
 0xaa,0x52,0x49,0x52,0x49,0x52,0xa5,0x54,0xa9,0x2a,0xa5,0x4a,0xa5,0x92,0xaa,
 0xaa,0x52,0xa5,0xaa,0xaa,0x22,0x95,0x54,0x55,0x55,0x55,0x55,0x25,0x45,0xa5,
 0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0x2a,0xaa,0xaa,0xaa,0x2a,0x00,0x29,0x49,0x21,
 0x45,0x89,0x92,0x49,0x52,0x2a,0x15,0x29,0x15,0x25,0x49,0x92,0x24,0x92,0x94,
 0x24,0x49,0x2a,0x4a,0xa4,0x44,0x49,0xa5,0x24,0x29,0xa9,0x24,0x49,0x95,0xa4,
 0x52,0xa5,0x94,0x94,0x4a,0x25,0x55,0x25,0x55,0x55,0x2a,0xa5,0x2a,0x55,0x55,
 0xaa,0x2a,0x55,0x95,0x94,0x2a,0x55,0x4a,0x95,0xaa,0xaa,0x4a,0x92,0x2a,0x55,
 0xa9,0xaa,0x5a,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0x55,0x55,0x25,0x09,
 0x55,0x84,0x54,0x4a,0xa9,0x24,0x49,0x24,0x15,0x45,0x49,0x8a,0xa2,0x52,0x25,
 0x49,0x95,0x4a,0x45,0xa9,0x2a,0x45,0x25,0x55,0xaa,0xa4,0x28,0x95,0x4a,0x55,
 0x52,0x25,0x49,0x95,0x54,0x52,0xa5,0xaa,0x24,0xa9,0xaa,0x94,0xaa,0x4a,0xa9,
 0x2a,0xa5,0xa4,0x52,0x55,0xa9,0x54,0xa9,0xaa,0xaa,0xaa,0xaa,0x52,0x55,0x55,
 0x55,0x55,0xa5,0x52,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,
 0xaa,0xaa,0xaa,0x2a,0x80,0x28,0x21,0x29,0x02,0xa9,0x94,0x4a,0xa2,0x28,0x52,
 0x51,0x94,0x24,0x4a,0x95,0xa8,0x94,0x28,0x25,0x51,0xaa,0x54,0x49,0x91,0x4a,
 0xa5,0xa4,0x94,0xa4,0x4a,0xaa,0x52,0x2a,0xa5,0x94,0x54,0x49,0x55,0x4a,0x92,
 0xaa,0x24,0xa9,0x4a,0xa9,0x54,0x95,0x94,0x92,0x4a,0x25,0x55,0xa5,0x54,0x49,
 0x29,0x55,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0x2a,0x55,0xa9,0xaa,0xaa,0xaa,0xaa,
 0xaa,0xaa,0xaa,0xaa,0x55,0x55,0x55,0x15,0x29,0xa5,0x4a,0x92,0xb4,0x12,0xa2,
 0xa4,0x54,0x4a,0x25,0xaa,0x4a,0x52,0x51,0x22,0x25,0x49,0x55,0x52,0x4a,0x51,
 0x92,0x54,0x2a,0x29,0x52,0x52,0xa5,0x92,0xa4,0x52,0x2a,0x49,0x95,0x4a,0x4a,
 0xaa,0x52,0x55,0x55,0x52,0x55,0x55,0x2a,0x95,0x2a,0x55,0x55,0x55,0xaa,0xaa,
 0x4a,0x55,0x95,0xaa,0xaa,0xaa,0xaa,0x52,0x55,0x55,0x55,0x55,0x55,0x55,0x55,
 0x55,0x55,0x55,0x55,0x49,0x55,0x55,0x55,0xaa,0xaa,0xaa,0x2a,0x04,0x48,0x94,
 0x24,0x09,0x49,0x15,0x89,0x42,0x91,0x48,0x11,0x91,0x44,0x8a,0x54,0x4a,0x92,
 0xa4,0xa4,0x94,0x8a,0x2a,0x89,0x52,0x52,0xa5,0x4a,0x4a,0x2a,0x95,0xa4,0x54,
 0x55,0x52,0xa9,0x92,0x92,0x94,0x92,0xa4,0x4a,0x4a,0x4a,0xa9,0xaa,0x52,0xa9,
 0xaa,0x54,0x55,0x55,0x55,0xaa,0xaa,0x2a,0x55,0x55,0x55,0x2a,0xa9,0xaa,0x54,
 0x95,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0x56,0xaa,0xaa,0xaa,0x55,0x55,0x55,
 0x09,0xa1,0x2a,0xa5,0x52,0xd5,0xa4,0xa4,0xaa,0x34,0x55,0x55,0xaa,0xac,0xaa,
 0x6a,0x95,0x52,0x55,0x95,0x2a,0xa5,0x54,0xa5,0xaa,0x4a,0x95,0x2a,0x55,0xa9,
 0xaa,0x52,0x55,0xa5,0x52,0x55,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
 0xaa,0x52,0x55,0x55,0x95,0xaa,0x2a,0x29,0x55,0x55,0x55,0xd5,0x4a,0x55,0x55,
 0x55,0x55,0xa9,0xaa,0x6a,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0xa9,0x55,0x55,
 0x55,0x55,0x55,0x95,0x2a,0x04,0xd4,0x5a,0xad,0xaa,0x5e,0x5b,0xb5,0xaa,0x56,
 0xd5,0xd6,0x6a,0xad,0xaa,0x6a,0xad,0xad,0x6a,0xd5,0x5a,0xab,0x5a,0xb5,0xba,
 0x6a,0xd5,0xaa,0x56,0x55,0xad,0xaa,0x5a,0xad,0xaa,0x55,0xb5,0x6a,0x55,0x55,
 0x55,0x55,0xd5,0xaa,0x56,0xad,0xaa,0xaa,0x6a,0x55,0xd5,0xd6,0xaa,0xaa,0xaa,
 0xaa,0xba,0xaa,0xaa,0xd5,0xaa,0x56,0xab,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
 0xaa,0x56,0x55,0xb5,0xb6,0xaa,0xaa,0xaa,0x2a,0xa1,0xb6,0x56,0xab,0x55,0xa5,
 0xd5,0x56,0xdb,0x6a,0x5b,0x55,0xad,0xd6,0x56,0xad,0xb5,0x6a,0x5b,0x6d,0x6d,
 0xb5,0xd5,0x56,0xab,0xb6,0x5a,0x6d,0x6b,0x6b,0x6b,0xdb,0x56,0xab,0x6d,0x6d,
 0x5b,0x5b,0xdb,0xda,0xb6,0xb6,0x6d,0x6d,0xab,0x55,0x5b,0x5b,0x55,0xdb,0xaa,
 0xaa,0xda,0x56,0x55,0x55,0xab,0x6a,0xad,0x5a,0x5b,0xab,0xda,0x56,0x55,0xab,
 0x56,0x6d,0x55,0x5b,0x5b,0x6b,0x6d,0x5b,0xab,0xda,0xd6,0x56,0x15,0x84,0xaa,
 0xb5,0x5a,0xdb,0x5a,0xad,0x6a,0x55,0xad,0xaa,0x6d,0xab,0xb5,0xda,0x5a,0x55,
 0x55,0xd5,0xaa,0x55,0x6b,0xad,0xad,0x6a,0x55,0xab,0xaa,0x5a,0xad,0x5a,0x55,
 0xb5,0x5a,0x55,0xab,0x6a,0x55,0x55,0xab,0xd5,0x6a,0x55,0xab,0x5a,0xdb,0x6a,
 0xb5,0xad,0xaa,0x6d,0x6d,0xab,0x6d,0xdb,0x6e,0xd5,0xd6,0x5a,0xab,0xd6,0xda,
 0xaa,0xda,0xb6,0xb6,0x6d,0xab,0x6d,0xb5,0x6a,0xad,0x55,0xd5,0x6a,0xab,0x5a,
 0xad,0x14,0xa8,0xda,0xaa,0x6d,0xad,0xd6,0x6a,0x5b,0xdb,0x56,0xdb,0xaa,0x6a,
 0x55,0x55,0xab,0xda,0xb6,0xad,0xb6,0xaa,0x55,0xb5,0xb2,0xad,0xad,0xd5,0xd6,
 0xaa,0x55,0xab,0x6d,0xab,0xd5,0xb6,0xaa,0x55,0xad,0x6d,0xb5,0x5a,0xad,0x5a,
 0xd5,0x6a,0x55,0xad,0xaa,0xd6,0x56,0xb5,0x56,0xb5,0xaa,0x6a,0x55,0xad,0x5a,
 0xab,0xd5,0xaa,0x6a,0x6d,0x55,0x5b,0x55,0x55,0xb5,0xaa,0x55,0xad,0x55,0xb5,
 0x56,0xad,0x55,0xab,0x55,0x25,0x42,0xab,0x56,0x55,0xb5,0xb5,0x56,0xd5,0xaa,
 0x6a,0x55,0xb5,0xad,0xb6,0xad,0x6a,0xab,0x55,0xb5,0x55,0x5b,0xad,0x55,0x6b,
 0x55,0xb5,0xb6,0xb5,0x56,0x6d,0x55,0x55,0xad,0xb6,0x6a,0x6d,0xad,0xb5,0xaa,
 0x56,0xb5,0xaa,0xb5,0x5a,0xab,0xaa,0x6a,0x57,0xb5,0xda,0xaa,0xb5,0x56,0xb5,
 0x55,0xab,0xb5,0x55,0xb5,0xb6,0x5a,0xab,0xaa,0xad,0x6a,0x6d,0xb5,0xaa,0xad,
 0xd6,0xaa,0xda,0xd6,0x5a,0x55,0x6d,0xb5,0x5a,0x15,0xb0,0xad,0xda,0xaa,0x55,
 0x55,0xb5,0x5a,0x6d,0xb5,0x6a,0x5b,0x55,0xab,0xd6,0xb6,0xb5,0xaa,0x56,0xd5,
 0xaa,0x6a,0x6d,0xad,0x6a,0xab,0xaa,0xaa,0xda,0xaa,0xda,0xb6,0x6a,0x55,0x55,
 0xab,0xd6,0xd6,0x56,0xdb,0xd6,0xd6,0xaa,0xad,0xda,0xb6,0xad,0x6a,0xab,0x55,
 0x5b,0x55,0xab,0xad,0xb6,0xda,0xaa,0x6a,0xad,0x5a,0xad,0xb5,0xb6,0x6a,0x55,
 0xab,0xd6,0xb6,0x6a,0xb5,0xd6,0x56,0x55,0xd5,0xb6,0x56,0xad,0xd6,0x2a,0xaa,
 0x6a,0xb5,0x6d,0xad,0xb6,0xd5,0x56,0xd5,0xd6,0x56,0xd5,0xda,0x6a,0xb5,0xaa,
 0x56,0xdb,0xaa,0xb6,0xb6,0x55,0xab,0x5a,0x5b,0x6d,0xad,0xd6,0xaa,0xb5,0xb5,
 0x6a,0xdb,0xaa,0xad,0x5a,0x35,0x55,0x6d,0x55,0x55,0xad,0x56,0x6b,0x55,0x6d,
 0xd5,0x5a,0xad,0xb6,0x6a,0x6b,0xb5,0x6a,0xd5,0xaa,0x56,0x5b,0x6b,0xd5,0x6a,
 0xad,0x55,0xdb,0xd6,0xda,0xaa,0x55,0x5b,0xab,0xad,0x6a,0xdb,0x56,0xd5,0xda,
 0x6a,0x55,0x15,0x54,0x55,0xab,0xaa,0x6a,0xab,0x5a,0xd5,0x56,0x55,0xb5,0x56,
 0xad,0x5a,0x55,0x55,0xd5,0x6a,0xb5,0x55,0x55,0x6d,0x55,0xab,0xad,0xaa,0xb5,
 0xb5,0x56,0xad,0x56,0xab,0x2a,0xdb,0x6a,0xab,0xd5,0xb5,0xb2,0xaa,0xad,0xd5,
 0xda,0xaa,0xad,0xaa,0x6a,0xd5,0x6a,0x55,0x55,0xb5,0xda,0x56,0xad,0xb6,0xda,
 0xaa,0x55,0xab,0x56,0xd5,0xda,0xaa,0x6a,0x55,0xb5,0xaa,0x55,0xb5,0x6a,0xb5,
 0xaa,0x6a,0x5b,0x55,0xad,0xb5,0x15,0x6a,0xdb,0x56,0xad,0xd5,0x5a,0xab,0xad,
 0x5a,0x5b,0xab,0xb5,0x55,0xd5,0xb6,0x6d,0xad,0x56,0x6b,0xad,0x6d,0xab,0xda,
 0x6a,0x6a,0x5b,0xab,0xaa,0x6d,0x6b,0xad,0x5a,0xeb,0xaa,0x56,0xb5,0x56,0xad,
 0xad,0x6d,0xb5,0x5a,0x55,0xad,0xda,0xaa,0xad,0x56,0xdb,0x6a,0xdb,0xd6,0xa6,
 0xda,0x5a,0xd5,0xaa,0x56,0xad,0xb6,0xb5,0xaa,0xaa,0x56,0x5b,0xab,0xad,0xb6,
 0x6a,0xab,0xaa,0xad,0x56,0x5b,0xd5,0x6a,0xab,0x56,0x15,0xb5,0x55,0xd9,0xd6,
 0xb6,0xaa,0xd5,0x6a,0xab,0xd5,0xda,0x5a,0xb5,0xad,0xaa,0xaa,0xb5,0x5a,0xad,
 0x6a,0x55,0xd5,0x56,0xb5,0x56,0x55,0xd5,0xb6,0xaa,0xaa,0x6a,0xad,0xad,0xda,
 0xda,0xda,0x6a,0xd5,0xaa,0xaa,0x56,0xad,0xb6,0x6a,0x55,0xdb,0xaa,0xb5,0x2a,
 0x5b,0xad,0xaa,0x6a,0x55,0x6b,0x5b,0x6d,0x6b,0xd5,0xaa,0x5a,0xb7,0xd6,0xda,
 0xaa,0xda,0xd6,0xda,0x5a,0x6d,0x5b,0xd5,0xda,0xaa,0x5a,0x5b,0xd5,0x6a,0x2d};

icon_struct	letters_ic = { letters_width, letters_height, 
			      (char*)letters_bits };
icon_struct	spl_bckgnd_ic = { spl_bckgnd_width, spl_bckgnd_height, 
			      (char*)spl_bckgnd_bits };
