/*
 * Decompiled with CFR 0.152.
 */
package info.aduna.xml;

import info.aduna.xml.XMLUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.HashMap;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class SAXWriter
implements ContentHandler {
    public static final boolean DEFAULT_INDENT = false;
    public static final int INDENT_INCREASE = 2;
    private static final char[] SPACES = new char[30];
    private static final int SPACES_LENGTH = 30;
    private Writer writer;
    private boolean indenting;
    private int indentLength;
    private HashMap<String, String> prefixMappings;
    private String lastUri;
    private String lastLName;
    private String lastQName;
    private AttributesImpl lastAttributes;
    private boolean charactersNeedIndenting;

    public SAXWriter(Writer writer, boolean indenting) {
        this.writer = writer;
        this.indenting = indenting;
        this.indentLength = 0;
        this.lastAttributes = new AttributesImpl();
        this.charactersNeedIndenting = true;
    }

    public SAXWriter(Writer writer) {
        this(writer, false);
    }

    public SAXWriter(OutputStream stream, boolean indent) throws IOException {
        this(new OutputStreamWriter(stream, "ISO8859_1"), indent);
    }

    public SAXWriter(OutputStream stream) throws IOException {
        this(stream, false);
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void startDocument() throws SAXException {
        try {
            this.writer.write("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>");
            this.indentLength = 0;
            this.prefixMappings = new HashMap();
        }
        catch (IOException e) {
            throw new SAXException("I/O error", e);
        }
    }

    public void endDocument() throws SAXException {
        try {
            this.writer.write(10);
            this.writer.flush();
            this.prefixMappings = null;
        }
        catch (IOException e) {
            throw new SAXException("I/O error", e);
        }
    }

    public void startPrefixMapping(String prefix, String uri) {
        this.prefixMappings.put(prefix, uri);
    }

    public void endPrefixMapping(String prefix) {
        this.prefixMappings.remove(prefix);
    }

    public void startElement(String uri, String lName, String qName, Attributes attrs) throws SAXException {
        if (this.hasCachedTag()) {
            this.printElement(this.lastUri, this.lastLName, this.lastQName, this.lastAttributes, false);
        }
        this.lastUri = uri;
        this.lastLName = lName;
        this.lastQName = qName;
        if (attrs == null) {
            this.lastAttributes.clear();
        } else {
            this.lastAttributes.setAttributes(attrs);
        }
    }

    private boolean hasCachedTag() {
        return this.lastUri != null || this.lastLName != null || this.lastQName != null;
    }

    public void endElement(String uri, String lName, String qName) throws SAXException {
        if (this.lastUri == null && this.lastLName == null && this.lastQName == null) {
            try {
                if (this.indenting) {
                    this.indentLength -= 2;
                    this.printIndentation();
                }
                this.writer.write("</");
                this.writer.write(this.getTagName(uri, lName, qName));
                this.writer.write(62);
            }
            catch (IOException e) {
                throw new SAXException("I/O error", e);
            }
        } else {
            if (!(this.equals(uri, this.lastUri) && this.equals(lName, this.lastLName) && this.equals(qName, this.lastQName))) {
                throw new SAXException("No matching start and end tags: " + this.getTagName(uri, lName, qName) + ", " + this.getTagName(this.lastUri, this.lastLName, this.lastQName));
            }
            this.printElement(uri, lName, qName, this.lastAttributes, true);
            this.clearTagCache();
            if (this.indenting) {
                this.indentLength -= 2;
            }
        }
        this.charactersNeedIndenting = true;
    }

    private boolean equals(String s1, String s2) {
        if (s1 == s2) {
            return true;
        }
        if (s1 != null && s2 != null) {
            return s1.equals(s2);
        }
        return false;
    }

    private void clearTagCache() {
        this.lastUri = null;
        this.lastLName = null;
        this.lastQName = null;
        this.lastAttributes.clear();
    }

    public void characters(char[] buf, int offset, int len) throws SAXException {
        if (this.hasCachedTag()) {
            this.printElement(this.lastUri, this.lastLName, this.lastQName, this.lastAttributes, false);
        }
        this.clearTagCache();
        if (this.indenting && this.charactersNeedIndenting) {
            try {
                this.printIndentation();
            }
            catch (IOException e) {
                throw new SAXException("I/O error", e);
            }
            this.charactersNeedIndenting = false;
        }
        try {
            int length = offset + len;
            for (int i = offset; i < length; ++i) {
                char c = buf[i];
                if (c == '&') {
                    this.writer.write("&amp;");
                    continue;
                }
                if (c == '<') {
                    this.writer.write("&lt;");
                    continue;
                }
                if (c == '>') {
                    this.writer.write("&gt;");
                    continue;
                }
                if (c != '\t' && c != '\n' && c != '\r' && (c < ' ' || c > '\ud7ff') && (c < '\ue000' || c > '\ufffd')) continue;
                this.writer.write(c);
            }
        }
        catch (IOException e) {
            throw new SAXException("I/O error", e);
        }
    }

    public void ignorableWhitespace(char[] buf, int offset, int len) throws SAXException {
    }

    public void processingInstruction(String target, String data) throws SAXException {
        try {
            this.writer.write("<?");
            this.writer.write(target);
            this.writer.write(32);
            this.writer.write(data);
            this.writer.write("?>");
        }
        catch (IOException e) {
            throw new SAXException("I/O error", e);
        }
    }

    public void skippedEntity(String name) {
    }

    private String getTagName(String uri, String lName, String qName) throws SAXException {
        String tag = qName;
        if (tag == null && lName != null) {
            tag = uri == null ? lName : uri + ":" + lName;
        }
        if (tag == null) {
            throw new SAXException("Unable to determine tag");
        }
        return tag;
    }

    private void printElement(String uri, String lName, String qName, Attributes attrs, boolean closing) throws SAXException {
        String tag = this.getTagName(uri, lName, qName);
        try {
            if (this.indenting) {
                this.printIndentation();
                this.indentLength += 2;
            }
            this.writer.write(60);
            this.writer.write(tag);
            if (attrs != null) {
                for (int i = 0; i < attrs.getLength(); ++i) {
                    String attName = attrs.getQName(i);
                    if (attName == null) {
                        String attUri = attrs.getURI(i);
                        String attLName = attrs.getLocalName(i);
                        if (attLName != null) {
                            attName = attUri == null ? attLName : attUri + ":" + attLName;
                        }
                    }
                    if (attName == null) {
                        throw new SAXException("Unable to determine attribute name");
                    }
                    this.writer.write(32);
                    this.writer.write(attName);
                    this.writer.write("=\"");
                    this.writer.write(XMLUtil.escapeAttributeValue(attrs.getValue(i)));
                    this.writer.write("\"");
                }
            }
            if (closing) {
                this.writer.write("/>");
            } else {
                this.writer.write(62);
            }
        }
        catch (IOException e) {
            throw new SAXException("I/O error", e);
        }
    }

    private void printIndentation() throws IOException {
        this.writer.write(10);
        for (int length = this.indentLength; length > 0; length -= 30) {
            this.writer.write(SPACES, 0, length);
        }
    }

    static {
        Arrays.fill(SPACES, ' ');
    }
}

